/*************************************************************************
 *
 *  $RCSfile: XclExpExternsheet.cxx,v $
 *
 *  $Revision: 1.5.4.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 07:54:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//___________________________________________________________________

#ifndef _SC_XCLEXPEXTERNSHEET_HXX
#include "XclExpExternsheet.hxx"
#endif

#include <algorithm>

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef _SCEXTOPT_HXX
#include "scextopt.hxx"
#endif

#ifndef _SC_XCLEXPSTREAM_HXX
#include "XclExpStream.hxx"
#endif

//___________________________________________________________________
// class XclExpTabNumBuffer

XclExpTabNumBuffer::XclExpTabNumBuffer( ScDocument& rDoc ) :
    bEnableLog( sal_False ),
    nCodeCnt( 0 )
{
    nScCnt = rDoc.GetTableCount();
    pBuffer = nScCnt ? new sal_uInt32[ nScCnt ] : NULL;

    for( sal_uInt16 nTab = 0; nTab < nScCnt; ++nTab )
    {
        pBuffer[ nTab ] = 0;

        // ignored tables (skipped by export, invalid Excel table number)
        if( rDoc.IsScenario( nTab ) )
            pBuffer[ nTab ] = EXC_TABBUF_FLAGIGNORE;

        // external tables (skipped, with valid Excel table number for ref's)
        else if( rDoc.GetLinkMode( nTab ) == SC_LINK_VALUE )
            pBuffer[ nTab ] = EXC_TABBUF_FLAGEXT;
    }
    ApplyBuffer();

    if( rDoc.GetExtDocOptions() )
    {
        CodenameList* pCList = rDoc.GetExtDocOptions()->GetCodenames();
        if( pCList )
            nCodeCnt = static_cast< sal_uInt16 >( Min( pCList->Count(), 0xFFFFUL ) );
    }

    InitSortedIndexes( rDoc );
}

XclExpTabNumBuffer::~XclExpTabNumBuffer()
{
    if( pBuffer )
        delete[] pBuffer;
}

void XclExpTabNumBuffer::ApplyBuffer()
{
    sal_uInt16 nIndex = 0;
    sal_uInt16 nTab;
    nExcCnt = nExtCnt = 0;

    // regular tables
    for( nTab = 0; nTab < nScCnt; nTab++ )
    {
        if( IsExportTable( nTab ) )
        {
            pBuffer[ nTab ] |= nIndex;
            nIndex++;
            nExcCnt++;
        }
        else
            pBuffer[ nTab ] |= EXC_TABBUF_INVALID;
    }

    // external tables
    for( nTab = 0; nTab < nScCnt; nTab++ )
    {
        if( IsExternal( nTab ) )
        {
            pBuffer[ nTab ] &= EXC_TABBUF_MASKFLAGS;
            pBuffer[ nTab ] |= nIndex;
            nIndex++;
            nExtCnt++;
        }
    }
}

struct XclExpTabName
{
    String                      maName;
    sal_uInt16                  mnIndex;
    inline bool                 operator<( const XclExpTabName& rArg ) const;
};

bool XclExpTabName::operator<( const XclExpTabName& rArg ) const
{
    return ScGlobal::pCollator->compareString( maName, rArg.maName ) == COMPARE_LESS;
}

void XclExpTabNumBuffer::InitSortedIndexes( ScDocument& rDoc )
{
    ::std::vector< XclExpTabName > aVec( nScCnt );
    sal_uInt16 nScTab;
    for( nScTab = 0; nScTab < nScCnt; ++nScTab )
    {
        rDoc.GetName( nScTab, aVec[ nScTab ].maName );
        aVec[ nScTab ].mnIndex = nScTab;
    }
    ::std::sort( aVec.begin(), aVec.end() );
    maFromSortedVec.resize( nScCnt );
    maToSortedVec.resize( nScCnt );
    for( nScTab = 0; nScTab < nScCnt; ++nScTab )
    {
        maFromSortedVec[ nScTab ] = aVec[ nScTab ].mnIndex;
        maToSortedVec[ aVec[ nScTab ].mnIndex ] = nScTab;
    }
}

sal_Bool XclExpTabNumBuffer::IsExternal( sal_uInt16 nScTab ) const
{
    return (nScTab < nScCnt) ? ::hasFlag( pBuffer[ nScTab ], EXC_TABBUF_FLAGEXT ) : sal_False;
}

sal_Bool XclExpTabNumBuffer::IsExportTable( sal_uInt16 nScTab ) const
{
    DBG_ASSERT( nScTab < nScCnt, "XclExpTabNumBuffer::IsExportTable - out of range!" );
    return (pBuffer[ nScTab ] & EXC_TABBUF_MASKFLAGS) == 0;
}

sal_uInt16 XclExpTabNumBuffer::GetExcTable( sal_uInt16 nScTab ) const
{
    return (nScTab < nScCnt) ? static_cast< sal_uInt16 >( pBuffer[ nScTab ] & EXC_TABBUF_MASKTAB ) : EXC_TABBUF_INVALID;
}

sal_uInt16 XclExpTabNumBuffer::GetRealSheetIndex( sal_uInt16 nSortedTab ) const
{
    DBG_ASSERT( nSortedTab < nScCnt, "XclExpTabNumBuffer::GetRealSheetIndex - out of range" );
    return maFromSortedVec[ nSortedTab ];
}

sal_uInt16 XclExpTabNumBuffer::GetSortedSheetIndex( sal_uInt16 nScTab ) const
{
    DBG_ASSERT( nScTab < nScCnt, "XclExpTabNumBuffer::GetSortedSheetIndex - out of range" );
    return maToSortedVec[ nScTab ];
}

void XclExpTabNumBuffer::AppendTabRef( sal_uInt16 nExcFirst, sal_uInt16 nExcLast )
{
    if( bEnableLog )
    {
        Append( nExcFirst );
        Append( nExcLast );
    }
}



//___________________________________________________________________
// class XclExpCrn

void XclExpCrn::SaveCont( XclExpStream& rStrm )
{
    rStrm   << static_cast< sal_uInt8 >( nCol )
            << static_cast< sal_uInt8 >( nCol )
            << nRow << nId;
    SaveDiff( rStrm );
}

sal_uInt16 XclExpCrn::GetNum() const
{
    return 0x005A;
}

sal_uInt32 XclExpCrn::GetLen() const
{
    return 5 + GetDiffLen();
}



//___________________________________________________________________
// class XclExpCrnDouble

XclExpCrnDouble::XclExpCrnDouble( sal_uInt16 _nCol, sal_uInt16 _nRow, double _fVal ) :
    XclExpCrn( _nCol, _nRow, EXC_CACHEDVAL_DOUBLE ),
    fVal( _fVal )
{
}

void XclExpCrnDouble::SaveDiff( XclExpStream& rStrm )
{
    rStrm << fVal;
}

sal_uInt32 XclExpCrnDouble::GetDiffLen() const
{
    return 8;
}



//___________________________________________________________________
// class XclExpCrnString

XclExpCrnString::XclExpCrnString( sal_uInt16 _nCol, sal_uInt16 _nRow, const String& rTxt ) :
    XclExpCrn( _nCol, _nRow, EXC_CACHEDVAL_STRING ),
    aText( rTxt )
{
}

void XclExpCrnString::SaveDiff( XclExpStream& rStrm )
{
    aText.Write( rStrm );
}

sal_uInt32 XclExpCrnString::GetDiffLen() const
{
    return aText.GetByteCount();
}



//___________________________________________________________________
// class XclExpCrnBool

XclExpCrnBool::XclExpCrnBool( sal_uInt16 _nCol, sal_uInt16 _nRow, sal_Bool bBoolVal ) :
    XclExpCrn( _nCol, _nRow, EXC_CACHEDVAL_BOOL ),
    nBool( bBoolVal ? 1 : 0 )
{
}

void XclExpCrnBool::SaveDiff( XclExpStream& rStrm )
{
    rStrm << nBool;
    rStrm.WriteZeroBytes( 6 );
}

sal_uInt32 XclExpCrnBool::GetDiffLen() const
{
    return 8;
}



//___________________________________________________________________
// class XclExpXct

sal_Bool XclExpXct::Exists( sal_uInt16 nCol, sal_uInt16 nRow )
{
    for( XclExpCrn* pCrn = aCrnList.First(); pCrn; pCrn = aCrnList.Next() )
        if( pCrn->IsAddress( nCol, nRow ) )
            return sal_True;
    return sal_False;
}

void XclExpXct::StoreCellRange( RootData& rRootData, const ScRange& rRange )
{
    ScDocument&         rDoc = *rRootData.pDoc;
    SvNumberFormatter&  rFTab = *rRootData.pFormTable;
    sal_uInt16          nTab = rRange.aStart.Tab();

    for( sal_uInt16 nRow = rRange.aStart.Row(); nRow <= rRange.aEnd.Row(); nRow++ )
        for( sal_uInt16 nCol = rRange.aStart.Col(); nCol <= rRange.aEnd.Col(); nCol++ )
            if( !Exists( nCol, nRow ) )
            {
                if( rDoc.HasValueData( nCol, nRow, nTab ) )
                {
                    ScAddress   aAddr( nCol, nRow, nTab );
                    double      fVal    = rDoc.GetValue( aAddr );
                    sal_uInt32  nFormat = rDoc.GetNumberFormat( aAddr );
                    sal_Int16   nType   = rFTab.GetType( nFormat );
                    sal_Bool    bIsBool = (nType == NUMBERFORMAT_LOGICAL);

                    if( !bIsBool && ((nFormat % SV_COUNTRY_LANGUAGE_OFFSET) == 0) &&
                        (rDoc.GetCellType( aAddr ) == CELLTYPE_FORMULA) )
                    {
                        ScFormulaCell* pCell = (ScFormulaCell*) rDoc.GetCell( aAddr );
                        if ( pCell )
                            bIsBool = (pCell->GetFormatType() == NUMBERFORMAT_LOGICAL);
                    }

                    if( bIsBool && ((fVal == 0.0) || (fVal == 1.0)) )
                        aCrnList.Append( new XclExpCrnBool( nCol, nRow, (fVal == 1.0) ) );
                    else
                        aCrnList.Append( new XclExpCrnDouble( nCol, nRow, fVal ) );
                }
                else
                {
                    String aText;
                    rDoc.GetString( nCol, nRow, nTab, aText );
                    aCrnList.Append( new XclExpCrnString( nCol, nRow, aText ) );
                }
            }
}

void XclExpXct::SaveCont( XclExpStream& rStrm )
{
    rStrm   << static_cast< sal_uInt16 >( aCrnList.Count() )
            << nTabNum;
}

void XclExpXct::Save( XclExpStream& rStrm )
{
    ExcRecord::Save( rStrm );

    for( XclExpCrn* pCrn = aCrnList.First(); pCrn; pCrn = aCrnList.Next() )
        pCrn->Save( rStrm );
}

sal_uInt16 XclExpXct::GetNum() const
{
    return 0x0059;
}

sal_uInt32 XclExpXct::GetLen() const
{
    return 4;
}



//___________________________________________________________________
// class XclExpExternname

XclExpExternname::XclExpExternname( const String& rName, sal_uInt16 _nFlags ) :
    aName( rName ),
    nFlags( _nFlags )
{
    DBG_ASSERT( aName.Len() <= 255, "XclExpExternname::XclExpExternname - no strings longer than 255 allowed!" );
}

XclExpExternname::~XclExpExternname()
{
}

void XclExpExternname::SaveCont( XclExpStream& rStrm )
{
    rStrm   << nFlags                                           // grbit
            << static_cast< sal_uInt32 >( 0 );                  // reserved
    XclExpUniString( aName, 255 ).Write( rStrm, sal_False );    // 8 bit length

    SaveDiff( rStrm );
}

sal_uInt16 XclExpExternname::GetNum() const
{
    return 0x0023;
}

sal_uInt32 XclExpExternname::GetLen() const
{
    return aName.Len() + 8 + GetDiffLen();
}



//___________________________________________________________________
// class XclExpExternnameAddIn

void XclExpExternnameAddIn::SaveDiff( XclExpStream& rStrm )
{
    rStrm   << static_cast< sal_uInt16 >( 0x0002 )
            << static_cast< sal_uInt16 >( 0x171C );        // error value 0x17
}

sal_uInt32 XclExpExternnameAddIn::GetDiffLen() const
{
    return 4;
}



//___________________________________________________________________
// class XclExpExternnameDDE

XclExpExternnameDDE::~XclExpExternnameDDE()
{
    if( pOpList )
        delete pOpList;
}

sal_Bool XclExpExternnameDDE::InsertDDE(
        RootData& rRootData,
        const String& rApplic, const String& rTopic, const String& rItem )
{
    ScDocument& rScDoc = *rRootData.pDoc;

    sal_uInt16 nPos;
    if( rScDoc.FindDdeLink( rApplic, rTopic, rItem, SC_DDE_IGNOREMODE, nPos ) )
    {
        ScMatrix* pMatrix = NULL;
        sal_uInt16 nCols, nRows;
        if( rScDoc.GetDdeLinkResultDimension( nPos, nCols, nRows, pMatrix ) && pMatrix )
            pOpList = new XclExpCachedValueList( rScDoc, nCols, nRows, pMatrix, sal_True );
        return sal_True;
    }
    return sal_False;
}

void XclExpExternnameDDE::SaveDiff( XclExpStream& rStrm )
{
    if( pOpList )
        pOpList->Save( rStrm );
}

sal_uInt32 XclExpExternnameDDE::GetDiffLen() const
{
    return pOpList ? pOpList->GetLen() : 0;
}



//___________________________________________________________________
// class XclExpExternNameList

sal_uInt16 XclExpExternnameList::GetExtname( const String& rName )
{
    for( XclExpExternname* pName = First(); pName; pName = Next() )
        if( pName->GetName() == rName )
            return static_cast< sal_uInt16 >( GetCurPos() + 1 );
    return 0;
}

sal_uInt16 XclExpExternnameList::InsertAddin( const String& rName )
{
    sal_uInt16 nIndex = GetExtname( rName );
    return nIndex ? nIndex : Append( new XclExpExternnameAddIn( rName ) );
}

sal_uInt16 XclExpExternnameList::InsertDDE(
        RootData& rRootData,
        const String& rApplic, const String& rTopic, const String& rItem )
{
    if( !Count() )
        Append( new XclExpExternnameDDE( String( RTL_CONSTASCII_USTRINGPARAM( "StdDocumentName" ) ), 0x7FEA ) );

    sal_uInt16 nIndex = GetExtname( rItem );
    if( !nIndex )
    {
        XclExpExternnameDDE* pExtname = new XclExpExternnameDDE( rItem, 0x7FE2 );
        if( pExtname->InsertDDE( rRootData, rApplic, rTopic, rItem ) )
            nIndex = Append( pExtname );
        else
            delete pExtname;
    }
    return nIndex;
}

void XclExpExternnameList::Save( XclExpStream& rStrm )
{
    for( XclExpExternname* pName = First(); pName; pName = Next() )
        pName->Save( rStrm );
}



//___________________________________________________________________
// class XclExpSupbook

XclExpSupbook::XclExpSupbook() :
    pExtnameList( NULL ),
    eType( xlSBAddin ),
    nLen( 4 ),
    nTables( 1 )
{
}

XclExpSupbook::XclExpSupbook( sal_uInt16 nTabs ) :
    pExtnameList( NULL ),
    eType( xlSBSelf ),
    nLen( 4 ),
    nTables( nTabs )
{
}

XclExpSupbook::XclExpSupbook( const String& rDocName, sal_Bool bDDE ) :
    aDocName( rDocName ),
    pExtnameList( NULL ),
    eType( xlSBExt )
{
    if( bDDE )
        aEncoded.Assign( rDocName );
    else
    {
        INetURLObject aURLObj( rDocName );
        DBG_ASSERT( !aURLObj.HasError(), "XclExpSupbook::XclExpSupbook - Corrupt external filename!" );

        aEncoded.Assign( aURLObj.getFSysPath( INetURLObject::FSYS_DOS ) );
        if( !aEncoded.GetLen() )
            aEncoded.Assign( rDocName );
    }
    nLen = 2 + aEncoded.GetByteCount();
}

XclExpSupbook::~XclExpSupbook()
{
    if( pExtnameList )
        delete pExtnameList;
}

XclExpExternnameList& XclExpSupbook::GetExternnameList()
{
    if( !pExtnameList )
        pExtnameList = new XclExpExternnameList;
    return *pExtnameList;
}

const XclExpUniString* XclExpSupbook::GetTableName( sal_uInt16 nIndex ) const
{
    XclExpXct* pXct = aXctList.GetObject( nIndex );
    return pXct ? &pXct->GetTableName() : NULL;
}

void XclExpSupbook::StoreCellRange( RootData& rRootData, const ScRange& rRange, sal_uInt16 nXct )
{
    XclExpXct* pXct = aXctList.GetObject( nXct );
    if( pXct )
        pXct->StoreCellRange( rRootData, rRange );
}

sal_uInt16 XclExpSupbook::InsertTable( const String& rTabName )
{
    DBG_ASSERT( eType == xlSBExt, "XclExpSupbook::InsertTable - Don't insert table names here" );
    XclExpXct* pXct = new XclExpXct( rTabName );
    nLen += pXct->GetTableBytes();
    aXctList.Append( pXct );

    sal_uInt16 nTabNum = static_cast< sal_uInt16 >( Min( aXctList.Count() - 1, 0xFFFFUL ) );
    pXct->SetTableNum( nTabNum );
    return nTabNum;
}

sal_uInt16 XclExpSupbook::InsertAddin( const String& rName )
{
    return GetExternnameList().InsertAddin( rName );
}

sal_uInt16 XclExpSupbook::InsertDDE(
        RootData& rRootData,
        const String& rApplic, const String& rTopic, const String& rItem )
{
    return GetExternnameList().InsertDDE( rRootData, rApplic, rTopic, rItem );
}

void XclExpSupbook::SaveCont( XclExpStream& rStrm )
{
    switch( eType )
    {
        case xlSBAddin:
            rStrm   << nTables
                    << static_cast< sal_uInt8 >( 0x01 )
                    << static_cast< sal_uInt8 >( 0x3A );
        break;
        case xlSBSelf:
            rStrm   << nTables
                    << static_cast< sal_uInt8 >( 0x01 )
                    << static_cast< sal_uInt8 >( 0x04 );
        break;
        default:
        {
            rStrm << static_cast< sal_uInt16 >( aXctList.Count() );
            aEncoded.Write( rStrm );

            for( XclExpXct* pXct = aXctList.First(); pXct; pXct = aXctList.Next() )
                pXct->GetTableName().Write( rStrm );
        }
    }
}

void XclExpSupbook::Save( XclExpStream& rStrm )
{
    ExcRecord::Save( rStrm );

    for( XclExpXct* pXct = aXctList.First(); pXct; pXct = aXctList.Next() )
        pXct->Save( rStrm );

    if( pExtnameList )
        pExtnameList->Save( rStrm );
}

sal_uInt16 XclExpSupbook::GetNum() const
{
    return 0x01AE;
}

sal_uInt32 XclExpSupbook::GetLen() const
{
    return nLen;
}



//___________________________________________________________________
// class XclExpSupbookList

XclExpSupbookBuffer::XclExpSupbookBuffer( RootData& rRootData ) :
        ExcRoot( &rRootData ),
        pSBIndexBuffer( NULL ),
        pTabIndexBuffer( NULL ),
        nAddinSupb( EXC_TAB_INVALID )
{
    XclExpTabNumBuffer& rTabBuffer = *rRootData.pTabBuffer;

    sal_uInt16 nScCnt  = rTabBuffer.GetScTabCount();
    sal_uInt16 nExcCnt = rTabBuffer.GetExcTabCount();
    sal_uInt16 nExtCnt = rTabBuffer.GetExternTabCount();

    nRefdCnt = nExcCnt + nExtCnt;
    if( !nRefdCnt )
        return;

    pSBIndexBuffer = new sal_uInt16[ nRefdCnt ];
    pTabIndexBuffer = new sal_uInt16[ nRefdCnt ];

    // self-ref supbook first of list
    sal_uInt16 nInd;
    sal_uInt16 nSelfInd = Append( new XclExpSupbook( Max( nExcCnt, rRootData.nCodenames ) ) );
    for( nInd = 0; nInd < nExcCnt; nInd++ )
    {
        pSBIndexBuffer[ nInd ] = nSelfInd;
        pTabIndexBuffer[ nInd ] = nInd;
    }

    // add supbooks with external references
    for( nInd = 0; nInd < nScCnt; nInd++ )
        if( rTabBuffer.IsExternal( nInd ) )
            AddExt( nInd );
}

XclExpSupbookBuffer::~XclExpSupbookBuffer()
{
    if( pSBIndexBuffer )
        delete[] pSBIndexBuffer;
    if( pTabIndexBuffer )
        delete[] pTabIndexBuffer;
}

XclExpSupbook* XclExpSupbookBuffer::GetSupbook( sal_uInt16& rnIndex, const String& rDocName )
{
    for( XclExpSupbook* pBook = aSupbookList.First(); pBook; pBook = aSupbookList.Next() )
    {
        if( pBook->IsExt() && (pBook->GetName() == rDocName) )
        {
            rnIndex = static_cast< sal_uInt16 >( Min( aSupbookList.GetCurPos(), 0xFFFFUL ) );
            return pBook;
        }
    }
    return NULL;
}

sal_uInt16 XclExpSupbookBuffer::Append( XclExpSupbook* pBook )
{
    aSupbookList.Append( pBook );
    return static_cast< sal_uInt16 >( Min( aSupbookList.Count() - 1, 0xFFFFUL ) );
}

void XclExpSupbookBuffer::AddExt( sal_uInt16 nScTab )
{
    // find ext doc name or append new one, save position in pSBIndexBuffer
    const String& rExtDoc = pExcRoot->pDoc->GetLinkDoc( nScTab );
    DBG_ASSERT( rExtDoc.Len(), "XclExpSupbookBuffer::AddExt - Missing external filename!" );

    sal_uInt16 nPos;
    XclExpSupbook* pBook = GetSupbook( nPos, rExtDoc );
    if( !pBook )
        nPos = Append( pBook = new XclExpSupbook( rExtDoc, sal_False ) );

    sal_uInt16 nInd = pExcRoot->pTabBuffer->GetExcTable( nScTab );
    DBG_ASSERT( nInd < nRefdCnt, "XclExpSupbookBuffer::AddExt - Out of range!" );
    pSBIndexBuffer[ nInd ] = nPos;

    // append new table name, save position in pTabIndexBuffer
    nPos = pBook->InsertTable( pExcRoot->pDoc->GetLinkTab( nScTab ) );
    pTabIndexBuffer[ nInd ] = nPos;
}

const XclExpUniString* XclExpSupbookBuffer::GetDocumentName( sal_uInt16 nExcTab ) const
{
    DBG_ASSERT( nExcTab < nRefdCnt, "XclExpSupbookBuffer::GetDocumentName - out of range" );
    const XclExpSupbook* pSupbook = GetSupbook( nExcTab );
    const XclExpUniString* pString = pSupbook ? &pSupbook->GetEncName() : NULL;
    return (pString && pString->GetLen()) ? pString : NULL;
}

const XclExpUniString* XclExpSupbookBuffer::GetTableName( sal_uInt16 nExcTab ) const
{
    DBG_ASSERT( nExcTab < nRefdCnt, "XclExpSupbookBuffer::GetTableName - out of range" );
    const XclExpSupbook* pSupbook = GetSupbook( nExcTab );
    return pSupbook ? pSupbook->GetTableName( pTabIndexBuffer[ nExcTab ] ) : NULL;
}

void XclExpSupbookBuffer::GetXtiRange(
        sal_uInt16& rnSupb, sal_uInt16& rnXtiFirst, sal_uInt16& rnXtiLast,
        sal_uInt16 nTabFirst, sal_uInt16 nTabLast ) const
{
    if( (nTabFirst >= nRefdCnt) || (nTabLast >= nRefdCnt) )
    {
        rnSupb = 0;
        rnXtiFirst = nTabFirst;
        rnXtiLast = nTabLast;
    }
    else
    {
        rnSupb = pSBIndexBuffer[ nTabFirst ];
        sal_Bool bConflict = sal_False;

        // all tables in the same supbook?
        for( sal_uInt16 nTab = nTabFirst + 1; !bConflict && (nTab <= nTabLast); nTab++ )
        {
            bConflict = (pSBIndexBuffer[ nTab ] != rnSupb);
            if( bConflict )
                nTabLast = nTab - 1;
        }
        rnXtiFirst = pTabIndexBuffer[ nTabFirst ];
        rnXtiLast = pTabIndexBuffer[ nTabLast ];
    }
}

void XclExpSupbookBuffer::StoreCellRange( const ScRange& rRange )
{
    sal_uInt16 nExcTab = pExcRoot->pTabBuffer->GetExcTable( rRange.aStart.Tab() );
    DBG_ASSERT( nExcTab < nRefdCnt, "XclExpSupbookBuffer::StoreCellRange - out of range!" );

    XclExpSupbook* pBook = GetSupbook( nExcTab );
    if( pBook )
        pBook->StoreCellRange( *pExcRoot, rRange, pTabIndexBuffer[ nExcTab ] );
}

void XclExpSupbookBuffer::InsertAddin( sal_uInt16& rnSupbook, sal_uInt16& rnExtname, const String& rName )
{
    XclExpSupbook* pBook;
    if( nAddinSupb == EXC_TAB_INVALID )
        nAddinSupb = Append( pBook = new XclExpSupbook() );
    else
        pBook = aSupbookList.GetObject( nAddinSupb );
    DBG_ASSERT( pBook, "XclExpSupbookBuffer::InsertAddin - missing Addin supbook" );
    rnSupbook = nAddinSupb;
    rnExtname = pBook->InsertAddin( rName );
}

void XclExpSupbookBuffer::InsertDDE(
        sal_uInt16& rnSupbook, sal_uInt16& rnExtname,
        const String& rApplic, const String& rTopic, const String& rItem )
{
    String aSupbName( rApplic );
    aSupbName += static_cast< sal_Unicode >( 0x03 );
    aSupbName += rTopic;
    XclExpSupbook* pBook = GetSupbook( rnSupbook, aSupbName );
    if( !pBook )
        rnSupbook = Append( pBook = new XclExpSupbook( aSupbName, sal_True ) );
    rnExtname = pBook->InsertDDE( *pExcRoot, rApplic, rTopic, rItem );
}

void XclExpSupbookBuffer::Save( XclExpStream& rStrm )
{
    for( XclExpSupbook* pBook = aSupbookList.First(); pBook; pBook = aSupbookList.Next() )
        pBook->Save( rStrm );
}



//___________________________________________________________________
// class XclExpExtsheetBuffer

XclExpExtsheetBuffer::XclExpExtsheetBuffer( RootData& rRootData ) :
    ExcRoot( &rRootData ),
    aSupbookBuffer( rRootData )
{
    Find( 0, 0 );   // dummy to avoid empty list
}

sal_uInt16 XclExpExtsheetBuffer::AppendXti( XclExpXti* pXti )
{
    DBG_ASSERT( aXtiBuffer.Count() != 0xFFFF, "XclExpExtsheetBuffer::AppendXti - too much for Xcl" );
    aXtiBuffer.Append( pXti );
    return GetVal16( aXtiBuffer.Count() - 1 );
}

sal_uInt16 XclExpExtsheetBuffer::InsertXti( sal_uInt16 nSupb, sal_uInt16 nFirst, sal_uInt16 nLast )
{
    for( XclExpXti* pXti = aXtiBuffer.First(); pXti; pXti = aXtiBuffer.Next() )
        if( pXti->Equals( nSupb, nFirst, nLast ) )
            return GetVal16( aXtiBuffer.GetCurPos() );
    return AppendXti( new XclExpXti( nSupb, nFirst, nLast ) );
}

sal_uInt16 XclExpExtsheetBuffer::Find( sal_uInt16 nTabFirst, sal_uInt16 nTabLast )
{
    sal_uInt16 nSupb, nXtiFirst, nXtiLast;
    aSupbookBuffer.GetXtiRange( nSupb, nXtiFirst, nXtiLast, nTabFirst, nTabLast );
    return InsertXti( nSupb, nXtiFirst, nXtiLast );
}

sal_uInt16 XclExpExtsheetBuffer::FindSpecial( sal_uInt16 nSupb )
{
    return InsertXti( nSupb, EXC_TAB_EXTERNAL, EXC_TAB_EXTERNAL );
}

void XclExpExtsheetBuffer::StoreCellCont( const SingleRefData& rRef )
{
    if( pExcRoot->pTabBuffer->IsExternal( rRef.nTab ) )
        aSupbookBuffer.StoreCellRange( ScRange(
            rRef.nCol, rRef.nRow, rRef.nTab, rRef.nCol, rRef.nRow, rRef.nTab ) );
}

void XclExpExtsheetBuffer::StoreCellRange( const SingleRefData& rRef1, const SingleRefData& rRef2 )
{
    for( sal_uInt16 nTab = rRef1.nTab; nTab <= rRef2.nTab; nTab++ )
        if( pExcRoot->pTabBuffer->IsExternal( nTab ) )
            aSupbookBuffer.StoreCellRange( ScRange(
                rRef1.nCol, rRef1.nRow, nTab, rRef2.nCol, rRef2.nRow, nTab ) );
}

void XclExpExtsheetBuffer::InsertAddin( sal_uInt16& rnXti, sal_uInt16& rnExtname, const String& rName )
{
    sal_uInt16 nSupbook;
    aSupbookBuffer.InsertAddin( nSupbook, rnExtname, rName );
    rnXti = FindSpecial( nSupbook );
}

sal_Bool XclExpExtsheetBuffer::InsertDDE(
        sal_uInt16& rnXti, sal_uInt16& rnExtname,
        const String& rApplic, const String& rTopic, const String& rItem )
{
    sal_uInt16 nSupbook;
    aSupbookBuffer.InsertDDE( nSupbook, rnExtname, rApplic, rTopic, rItem );
    if( !rnExtname )
        return sal_False;
    rnXti = FindSpecial( nSupbook );
    return sal_True;
}

void XclExpExtsheetBuffer::SaveCont( XclExpStream& rStrm )
{
    sal_uInt16 nCount16 = GetVal16( aXtiBuffer.Count() );
    rStrm << nCount16;

    rStrm.SetSliceLen( 6 );
    for( sal_uInt16 nIndex = 0; nIndex < nCount16; nIndex++ )
    {
        const XclExpXti* pXti = aXtiBuffer.GetObject( nIndex );
        DBG_ASSERT( pXti, "XclExpExtsheetBuffer::SaveCont - no Xti found!" );
        pXti->Save( rStrm );
    }
}

void XclExpExtsheetBuffer::Save( XclExpStream& rStrm )
{
    aSupbookBuffer.Save( rStrm );   // SUPBOOKs, XCTs, CRNs
    ExcRecord::Save( rStrm );       // EXTERNSHEET
}

sal_uInt16 XclExpExtsheetBuffer::GetNum() const
{
    return 0x0017;
}

sal_uInt32 XclExpExtsheetBuffer::GetLen() const
{
    return 2 + 6 * GetVal16( aXtiBuffer.Count() );
}



//___________________________________________________________________

