/*************************************************************************
 *
 *  $RCSfile: XclImpObjects.cxx,v $
 *
 *  $Revision: 1.8.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 07:54:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//___________________________________________________________________

#ifndef _SC_XCLIMPOBJECTS_HXX
#include "XclImpObjects.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#ifndef _RTL_LOGFILE_HXX_
#include <rtl/logfile.hxx>
#endif

#ifndef SC_ITEMS_HXX
#include "scitems.hxx"
#endif
#ifndef _SFX_OBJSH_HXX
#include <sfx2/objsh.hxx>
#endif
#ifndef _SFX_INTERNO_HXX
#include <sfx2/interno.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif
#ifndef _SVDOBJ_HXX
#include <svx/svdobj.hxx>
#endif
#ifndef _SVDOGRP_HXX
#include <svx/svdogrp.hxx>
#endif
#ifndef _SVDOOLE2_HXX
#include <svx/svdoole2.hxx>
#endif
#ifndef _SVDPAGE_HXX
#include <svx/svdpage.hxx>
#endif
#ifndef _EDITOBJ_HXX
#include <svx/editobj.hxx>
#endif
#ifndef _OUTLINER_HXX
#include <svx/outliner.hxx>
#endif
#ifndef _OUTLOBJ_HXX
#include <svx/outlobj.hxx>
#endif
#ifndef _SVX_COLRITEM_HXX
#include <svx/colritem.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX
#include <svx/xflclit.hxx>
#endif

#ifndef _SCH_DLL_HXX
#include <sch/schdll.hxx>
#endif
#ifndef _SCHDLL0_HXX
#include <sch/schdll0.hxx>
#endif
#ifndef _SCH_MEMCHRT_HXX
#include <sch/memchrt.hxx>
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef SC_DRWLAYER_HXX
#include "drwlayer.hxx"
#endif
#ifndef SC_CHARTARR_HXX
#include "chartarr.hxx"
#endif
#ifndef __GLOBSTR_HRC_
#include "globstr.hrc"
#endif

#ifndef _SC_XCLTOOLS_HXX
#include "XclTools.hxx"
#endif
#ifndef _SC_XCLIMPSTREAM_HXX
#include "XclImpStream.hxx"
#endif
#ifndef _SC_XCLIMPEXTERNSHEET_HXX
#include "XclImpExternsheet.hxx"
#endif
#ifndef _SC_XCLIMPCHARTS_HXX
#include "XclImpCharts.hxx"
#endif
#ifndef _SC_XCLIMPSTYLEBUFFER_HXX
#include "XclImpStyleBuffer.hxx"
#endif

#ifndef _EXCSST_HXX
#include "excsst.hxx"
#endif
#ifndef _FONTBUFF_HXX
#include "fontbuff.hxx"
#endif

#include <stdio.h>

using namespace ::com::sun::star;

//___________________________________________________________________
// class XclImpStreamConsumer

XclImpStreamConsumer::XclImpStreamConsumer() :
    aStrm(),
    aHd(),
    pNode( NULL ),
    nBytesLeft( 0 )
{
}

XclImpStreamConsumer::~XclImpStreamConsumer()
{
    while( pNode )
        RemoveNode();
}

void XclImpStreamConsumer::UpdateNode( const DffRecordHeader& rHd )
{
    while( pNode && ((pNode->nPos + pNode->nSize) <= rHd.nFilePos) )
        RemoveNode();
    XclImpStreamNode* pTemp = pNode;
    pNode = new XclImpStreamNode;
    pNode->nPos = rHd.nFilePos;
    pNode->nSize = rHd.nRecLen + 8;
    pNode->pPrev = pTemp;
}

void XclImpStreamConsumer::RemoveNode()
{
    XclImpStreamNode* pTemp = pNode;
    pNode = pNode->pPrev;
    delete pTemp;
}

const DffRecordHeader* XclImpStreamConsumer::ConsumeRecord( XclImpStream& rSrcStrm )
{
    sal_uInt32 nEntry = aStrm.Tell();
    sal_uInt32 nSrcLen = rSrcStrm.GetRecLen();
    if( !nSrcLen )
        return NULL;

    rSrcStrm.Seek( RECORD_SEEK_TO_BEGIN );
    sal_Char* pBuf = new sal_Char[ nSrcLen ];
    rSrcStrm.Read( pBuf, nSrcLen );
    aStrm.Write( pBuf, nSrcLen );
    delete[] pBuf;

    sal_uInt32 nPos = aStrm.Tell();
    aStrm.Seek( nEntry );
    if( nBytesLeft )
    {
        if( nSrcLen < nBytesLeft )
        {
            aStrm.SeekRel( nSrcLen );
            nBytesLeft -= nSrcLen;
        }
        else
        {
            aStrm.SeekRel( nBytesLeft );
            nBytesLeft = 0;
        }
    }
    while( aStrm.Tell() < nPos )
    {
        aStrm >> aHd;
        if( aHd.IsContainer() )
            UpdateNode( aHd );
        else if( (aStrm.Tell() + aHd.nRecLen) <= nPos )
            aStrm.SeekRel( aHd.nRecLen );
        else
        {
            nBytesLeft = aStrm.Tell() + aHd.nRecLen - nPos;
            aStrm.Seek( nPos );
        }
    }
    aStrm.Seek( nPos );

    return nBytesLeft ? NULL : &aHd;
}

sal_Bool XclImpStreamConsumer::AppendData( sal_Char* pBuf, sal_uInt32 nLen )
{
    sal_Bool bRetValue = sal_False;
    if ( aHd.nRecType && ( aHd.IsContainer() == sal_False ) && ( nBytesLeft == 0 ) )
    {
        while( pNode && ((pNode->nPos + pNode->nSize) <= aHd.nFilePos) )
            RemoveNode();
        XclImpStreamNode* pTemp = pNode;
        while( pTemp )
        {
            pTemp->nSize += nLen;               // updating container sizes
            aStrm.Seek( pTemp->nPos + 4 );
            aStrm << pTemp->nSize - 8;
            pTemp = pTemp->pPrev;
        }
        aHd.nRecLen += nLen;
        aStrm.Seek( aHd.nFilePos + 4 );        // updating atom size
        aStrm << aHd.nRecLen;
        aStrm.Seek( STREAM_SEEK_TO_END );
        aStrm.Write( pBuf, nLen );
        return sal_True;
    }
    return bRetValue;
}



//___________________________________________________________________
// class XclImpEscherObj

XclImpEscherObj::XclImpEscherObj(
        sal_uInt32 _nStrmStart, sal_uInt32 _nStrmEnd,
        RootData& rRootData,
        XclImpObjectType _eType ) :
    ExcRoot( &rRootData ),
    eType( _eType ),
    pAnchor( NULL ),
    pSdrObj( NULL ),
    nStrmStart( _nStrmStart ),
    nStrmEnd( _nStrmEnd ),
    nTab( *rRootData.pAktTab ),
    nId( 0xFFFF )
{
}

XclImpEscherObj::XclImpEscherObj( XclImpEscherObj& rCopy, XclImpObjectType _eType ) :
    ExcRoot( rCopy.pExcRoot ),
    eType( _eType ),
    pAnchor( rCopy.pAnchor ? new Rectangle( *rCopy.pAnchor ) : NULL ),
    pSdrObj( rCopy.pSdrObj ),
    nStrmStart( rCopy.nStrmStart ),
    nStrmEnd( rCopy.nStrmEnd ),
    nTab( rCopy.nTab ),
    nId( rCopy.nId )
{
    rCopy.pSdrObj = NULL;
}

XclImpEscherObj::~XclImpEscherObj()
{
    if( pAnchor )
        delete pAnchor;
    if( pSdrObj )
        delete pSdrObj;
}

void XclImpEscherObj::SetAnchor( const Rectangle& rAnchor )
{
    if( pAnchor )
        *pAnchor = rAnchor;
    else
        pAnchor = new Rectangle( rAnchor );
}

void XclImpEscherObj::SetSdrObj( SdrObject* pNewSdrObj )
{
    if( pSdrObj )
        delete pSdrObj;
    pSdrObj = pNewSdrObj;
}

void XclImpEscherObj::Apply()
{
    if( pSdrObj && pAnchor )
    {
        SdrPage* pPage = pExcRoot->pDoc->GetDrawLayer()->GetPage( nTab );
        if( pPage )
        {
            pPage->InsertObject( pSdrObj );
            pSdrObj = NULL;
        }
    }
}

void XclImpEscherObj::MorpheFrom( XclImpEscherObj*& rpMAD )
{
    nStrmStart = rpMAD->nStrmStart;
    nStrmEnd = rpMAD->nStrmEnd;
    nTab = rpMAD->nTab;
    nId = rpMAD->nId;

    pAnchor = rpMAD->pAnchor;
    rpMAD->pAnchor = NULL;

    pSdrObj = rpMAD->pSdrObj;
    rpMAD->pSdrObj = NULL;

    delete rpMAD;
    rpMAD = NULL;
}



//___________________________________________________________________
// class XclImpEscherChart

XclImpEscherChart::XclImpEscherChart( XclImpEscherObj*& rpCAD ) :
    XclImpEscherObj( *rpCAD, otChart )
{
    delete rpCAD;
    rpCAD = NULL;

    pChrtData = new XclImpChart( *pExcRoot );
    pChrtData->nBaseTab = nTab;
}

XclImpEscherChart::~XclImpEscherChart()
{
    if( pChrtData )
        delete pChrtData;
}

void XclImpEscherChart::SetChartData( XclImpChart* pNewChart )
{
    if( pChrtData )
        delete pChrtData;
    pChrtData = pNewChart;
}

void XclImpEscherChart::InitProgress( ScfProgressBar& rProgress )
{
    if( pChrtData )
        pChrtData->InitProgress( rProgress );
}

void XclImpEscherChart::Apply()
{
    if( !pChrtData || !pAnchor ) return;

    const XclImpChart_LinkedData* pLinkData = pChrtData->GetSourceData();
    if( !pLinkData ) return;

    pChrtData->CloseSourceData();

    ScDocument*                 pD = pExcRoot->pDoc;

    SfxObjectShell*             pSh = pD->GetDocumentShell();
    SvStorageRef                aStor = new SvStorage( String() );
    SvInPlaceObjectRef          aIPObj;
    Rectangle&                  rRect = *pAnchor;

    //  wenn Chart nicht installiert ist, darf nicht auf SCH_MOD zugegriffen werden!
    //! Warnung am Storage setzen?
    if ( SvtModuleOptions().IsChart() )
        aIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit(
            *SCH_MOD()->pSchChartDocShellFactory, aStor );

    if( aIPObj.Is() )
    {
        pSh->InsertObject(aIPObj, String());

        String              aName;
        SvInfoObject*       pInfoObj = pSh->Find( aIPObj );

        if( pInfoObj )
            aName = pInfoObj->GetObjName();
        else
            DBG_ERROR( "IP-Object not found :-/" );

        sal_Bool bEnabled = aIPObj->IsEnableSetModified();
        if (bEnabled)
            aIPObj->EnableSetModified(sal_False);

        Size aSize = aIPObj->GetVisArea().GetSize();
        if( !aSize.Height() || !aSize.Width() )
        {
            aSize.Width() = 5000;
            aSize.Height() = 5000;
            aSize = Window::LogicToLogic
                        ( aSize, MapMode( MAP_100TH_MM ), MapMode( aIPObj->GetMapUnit() ) );
            aIPObj->SetVisAreaSize( aSize );
        }

        SdrOle2Obj* pSdrObj = new SdrOle2Obj( aIPObj, aName, rRect );

        pSdrObj->SetLayer( SC_LAYER_FRONT );

        pD->GetDrawLayer()->GetPage( pChrtData->nBaseTab )->InsertObject( pSdrObj );

        pSdrObj->NbcSetLogicRect( rRect );

        ScChartArray aChartObj( pD, pLinkData->GetRangeList(), aName );

        sal_Bool bSwap = pLinkData && pLinkData->GetDir();
        sal_Bool bColHdr = bSwap ? pChrtData->bHasSeriesNames : pChrtData->bHasCategoryNames;
        sal_Bool bRowHdr = bSwap ? pChrtData->bHasCategoryNames : pChrtData->bHasSeriesNames;
        aChartObj.SetHeaders( bColHdr, bRowHdr );

        SchMemChart* pMemChart = aChartObj.CreateMemChart();
        SchDLL::Update( aIPObj, pMemChart );
        delete pMemChart;

        SfxInPlaceObjectRef aSfxObj( aIPObj );
        if( aSfxObj.Is() )
        {
            SfxObjectShell* pObjSh = aSfxObj->GetObjectShell();
            if( pObjSh )
            {
                uno::Reference<lang::XComponent> xComp = pObjSh->GetModel().get();
                if( xComp.is() )
                    pChrtData->Apply( xComp, rRect );
            }
        }

        if( bEnabled )
            aIPObj->EnableSetModified( sal_True );

        aIPObj->SetModified();
        aIPObj->DoSave();
        aIPObj->DoSaveCompleted();
        aIPObj->GetStorage()->Commit();
    }
}



//___________________________________________________________________
// class XclImpEscherOle

XclImpEscherOle::XclImpEscherOle( XclImpEscherObj*& rpCAD ):
    XclImpEscherObj( *rpCAD, otOle ),
    nBlipId( 0 ),
    bAsSymbol( sal_False ),
    bLinked( sal_False )
{
    delete rpCAD;
    rpCAD = NULL;
}

XclImpEscherOle::~XclImpEscherOle()
{
}

void XclImpEscherOle::ReadPictFmla( XclImpStream& rIn, sal_uInt16 nLen )
{
    sal_uInt32  nStorageId;
    sal_uInt16  nFmlaLen;
    rIn >> nFmlaLen;

    String  aUserName;
    sal_uInt32   nPos0 = rIn.GetRecPos();        // fmla start
    sal_Bool    bOk = sal_True;
    if ( bLinked )
    {
        sal_Bool    bSizeOk = (sizeof(nFmlaLen) + nFmlaLen == nLen);
        DBG_ASSERT( bSizeOk, "ExcEscherOle::ReadPictFmla: bad linked size" );
//        sal_uInt16  n16;
//        rIn >> n16;     // should be 7 but who knows ...
//        bOk = (n16 + 3 <= nFmlaLen);
//        DBG_ASSERT( bOk, "ExcEscherOle::ReadPictFmla: linked length mismatch" );
//        if ( bOk )
//        {
//            rIn.Ignore( n16 );
//            sal_uInt8 n8;
//            rIn >> n8;
//            bOk = (n8 == 0x01);
//            DBG_ASSERT( bOk, "ExcEscherOle::ReadPictFmla: no sheet start" );
//            if ( bOk )
//            {
//                rIn >> n16;     // EXTERNSHEET based 0, EXTERNNAME based 1
//                const ExtName*  pExtName = pExcRoot->pExtNameBuff->GetName( n16 + 1 );
//                bOk = (pExtName && pExtName->IsOLE());
//                DBG_ASSERT( bOk, "ExcEscherOle::ReadPictFmla: EXTERNNAME not found or not OLE" );
//                if ( bOk )
//                    nStorageId = pExtName->nStorageId;
//            }
//        }
        rIn.Ignore( 7 );
        sal_uInt16 nXTI, nExtname;
        rIn >> nXTI >> nExtname;
        const XclImpSupbook* pSupbook = pExcRoot->pExtsheetBuffer->GetSupbook( nXTI );
        const XclImpExtName* pExtName = pSupbook ? pSupbook->GetExtName( nExtname ) : NULL;
        bOk = (pExtName && (pExtName->GetType() == xienOLE));
        DBG_ASSERT( bOk, "XclImpEscherOle::ReadPictFmla - EXTERNNAME not found or not OLE" );
        if ( bOk )
            nStorageId = pExtName->GetStorageId();
    }
    else
    {
        sal_uInt16  n16;
        rIn >> n16;     // should be 5 but who knows ...
        DBG_ASSERT( n16 + 4 <= nFmlaLen, "ExcEscherOle::ReadPictFmla: embedded length mismatch" );
        if ( n16 + 4 <= nFmlaLen )
        {
            rIn.Ignore( n16 + 4 );
            sal_uInt8 n8;
            rIn >> n8;
            DBG_ASSERT( n8 == 0x03, "ExcEscherOle::ReadPictFmla: no name start" );
            if ( n8 == 0x03 )
            {
                rIn >> n16;     // string length
                if ( n16 )
                {   // the 4th way Xcl stores a unicode string: not even a Grbit byte present if length 0
                    rIn.AppendUniString( aUserName, n16 );
                    // 0:= ID follows, 1:= pad byte + ID
#ifndef PRODUCT
                    INT32 nLeft = INT32(nFmlaLen) - (rIn.GetRecPos() - nPos0);
                    DBG_ASSERT( nLeft == 0 || nLeft == 1, "ExcEscherOle::ReadPictFmla: unknown left over" );
#endif

                    if( aUserName.EqualsAscii( "Forms.", 0, 6 ) )
                        SetType( otCtrl );
                }
            }
        }
        rIn.Seek( nPos0 + nFmlaLen );
        rIn >> nStorageId;
        if ( nStorageId )
        {
            sal_Bool bSizeOk = sizeof(nFmlaLen) + nFmlaLen + sizeof(nStorageId) == nLen;
            DBG_ASSERT( bSizeOk, "ExcEscherOle::ReadPictFmla: bad embedded size" );
        }
        else
            bOk = sal_False;        // no storage, internal
    }
    if ( bOk )
    {
        aStorageName.AssignAscii( bLinked ? "LNK" : "MBD" );
        sal_Char    aBuf[ sizeof(sal_uInt32) * 2 + 1 ];
        sprintf( aBuf, "%08X", nStorageId );
        aStorageName.AppendAscii( aBuf );
    }
}

void XclImpEscherOle::CreateSdrOle( Biff8MSDffManager& rDffMan, sal_uInt32 nOLEImpFlgs )
{
    if( pAnchor && aStorageName.Len() )
    {
        Graphic             aGraph;
        if( rDffMan.GetBLIP( nBlipId, aGraph ) )
        {
            SvStorageRef        xSrc = pExcRoot->pRootStorage;
            SvStorageRef        xDst( pExcRoot->pDoc->GetDocumentShell()->GetStorage() );

            SdrOle2Obj*     pRet = SvxMSDffManager::CreateSdrOLEFromStorage(
                    aStorageName, xSrc, xDst, aGraph, *pAnchor, NULL, nOLEImpFlgs );
            if( pRet )
                SetSdrObj( pRet );
        }
    }
}

void XclImpEscherOle::Apply()
{
    if( pSdrObj && pSdrObj->ISA( SdrOle2Obj ) && pAnchor )
    {
        SvInfoObject*   pInfoObj =
            pExcRoot->pDoc->GetDocumentShell()->InsertObject(
            ((SdrOle2Obj*)pSdrObj)->GetObjRef(), EMPTY_STRING );

        DBG_ASSERT( pInfoObj, "ExcEscherOle::Apply: no InfoObject" );

        if( pInfoObj )
            // #95381# SetPersistName, not SetName
            ((SdrOle2Obj*)pSdrObj)->SetPersistName( pInfoObj->GetObjName() );
    }
    XclImpEscherObj::Apply();
}



//___________________________________________________________________
// class XclImpEscherDrwObj

XclImpEscherDrwObj::XclImpEscherDrwObj( XclImpEscherObj*& rpCAD ) :
    XclImpEscherObj( *rpCAD, otPicture )
{
    delete rpCAD;
    rpCAD = NULL;
}

XclImpEscherDrwObj::~XclImpEscherDrwObj()
{
}



//___________________________________________________________________
// class XclImpEscherTxo

XclImpEscherTxo::XclImpEscherTxo( XclImpEscherObj*& rpCAD ) :
    XclImpEscherObj( *rpCAD, otTxo ),
    pText( NULL ),
    pFormText( NULL ),
    bIsApplied( sal_False )
{
    delete rpCAD;
    rpCAD = NULL;
}

XclImpEscherTxo::~XclImpEscherTxo()
{
    if( pText )
        delete pText;
}


void XclImpEscherTxo::ApplyTextOnObject( SdrObject* pNewSdrObj )
{
    if( bIsApplied )
        return;

    SdrObject* pObj = pNewSdrObj ? pNewSdrObj : pSdrObj;

    if( pObj && pObj->ISA( SdrTextObj ) )
    {
        SdrTextObj* pTxtObj = (SdrTextObj*) pObj;

        bIsApplied = (pNewSdrObj == NULL);

        if( pFormText )
        {
            OutlinerParaObject* pOPO = new OutlinerParaObject( *pFormText );
            pOPO->SetOutlinerMode( OUTLINERMODE_TEXTOBJECT );
            pTxtObj->NbcSetOutlinerParaObject( pOPO );
        }
        else if( pText )
            pTxtObj->SetText( *pText );
        else
            bIsApplied = sal_False;
    }
}

void XclImpEscherTxo::SetSdrObj( SdrObject* pNewSdrObj )
{
    XclImpEscherObj::SetSdrObj( pNewSdrObj );
    ApplyTextOnObject();
}

void XclImpEscherTxo::SetText( const String& rText )
{
    if( pText )
        *pText = rText;
    else
        pText = new String( rText );
}

void XclImpEscherTxo::TakeText( String* pNewText, EditTextObject* pNewFormText )
{
    if( pText )
        delete pText;
    pText = pNewText;

    if( pFormText )
        delete pFormText;
    pFormText = pNewFormText;
}

void XclImpEscherTxo::Apply()
{
    ApplyTextOnObject();
    XclImpEscherObj::Apply();
}

void XclImpEscherTxo::Apply( SdrObject* pNewSdrObj )
{
    ApplyTextOnObject( pNewSdrObj );
}



//___________________________________________________________________
// class XclImpEscherNote

XclImpEscherNote::XclImpEscherNote( XclImpEscherObj*& rpCAD ) :
    XclImpEscherTxo( rpCAD )
{
    SetType( otNote );
}

void XclImpEscherNote::Apply()
{
}



//___________________________________________________________________
// class XclImpAnchorData

SvStream& operator>>( SvStream& rStrm, XclImpAnchorData& rAnchor )
{
    rStrm   >> rAnchor.nCol >> rAnchor.nX
            >> rAnchor.nRow >> rAnchor.nY
            >> rAnchor.nDCol >> rAnchor.nDX
            >> rAnchor.nDRow >> rAnchor.nDY;
    return rStrm;
}



//___________________________________________________________________
// class XclImpEscherObjList

XclImpEscherObjList::XclImpEscherObjList( RootData& rRootData ) :
    ExcRoot( &rRootData ),
    nLastReqTabStart( 0 ),
    nLastReqTab( 0 )
{
}

XclImpObjData* XclImpEscherObjList::GetFromStream( sal_uInt32 nStrmPos ) const
{
    for( sal_uInt32 nIndex = 0; nIndex < aObjDataList.Count(); nIndex++ )
    {
        XclImpObjData* pData = aObjDataList.GetObject( nIndex );
        if( pData && pData->IsInRange( nStrmPos ) )
            return pData;
    }
    return NULL;
}

sal_Bool XclImpEscherObjList::SetTabStart( sal_uInt16 nTab )
{
    if( nTab == nLastReqTab )
        return sal_True;

    sal_uInt32 nSrchIndx = (nTab > nLastReqTab) ? nLastReqTabStart + 1 : 0;
    for( sal_uInt32 nIndex = nSrchIndx; nIndex < aObjDataList.Count(); ++nIndex )
    {
        XclImpObjData* pData = aObjDataList.GetObject( nIndex );
        if( pData && pData->pEscherObj && (pData->pEscherObj->GetTab() == nTab) )
        {
            nLastReqTab = nTab;
            nLastReqTabStart = nIndex;
            return sal_True;
        }
    }
    return sal_False;
}

void XclImpEscherObjList::Append( XclImpEscherObj* pObj )
{
    DBG_ASSERT( pObj, "XclImpEscherObjList::Append - missing object" );
    aObjDataList.Append( new XclImpObjData( pObj, aObjDataList.Count() ) );
}

void XclImpEscherObjList::MorpheLastObj( XclImpEscherObj* pObj )
{
    XclImpObjData* pLast = aObjDataList.Last();
    if( !pLast || !pLast->pEscherObj ) return;

    pObj->MorpheFrom( pLast->pEscherObj );
    pLast->pEscherObj = pObj;
}

sal_Bool XclImpEscherObjList::GetObjNum( sal_uInt32 nStrmPos, sal_uInt32& rnObjNum ) const
{
    for( sal_uInt32 nIndex = 0; nIndex < aObjDataList.Count(); ++nIndex )
    {
        const XclImpObjData* pData = aObjDataList.GetObject( nIndex );
        if( pData && pData->IsInRange( nStrmPos ) )
        {
            rnObjNum = pData->nObjNum;
            return sal_True;
        }
    }
    return sal_False;
}

XclImpAnchorData* XclImpEscherObjList::GetAnchorDataAccess( sal_uInt32 nStrmPos )
{
    XclImpObjData* pData = GetFromStream( nStrmPos );
    return pData ? pData->GetAnchorDataAccess() : NULL;
}

const XclImpAnchorData* XclImpEscherObjList::GetAnchorData( sal_uInt32 nStrmPos ) const
{
    XclImpObjData* pData = GetFromStream( nStrmPos );
    return pData ? pData->pAnchorData : NULL;
}

XclImpEscherObj* XclImpEscherObjList::GetObj( sal_uInt32 nObjNum, sal_uInt16 nTab ) const
{
    if( nTab == EXC_TAB_INVALID )
    {
        XclImpObjData* pData = aObjDataList.GetObject( nObjNum );
        return pData ? pData->pEscherObj : NULL;
    }
    else if( ((XclImpEscherObjList*)this)->SetTabStart( nTab ) )
    {
        sal_uInt32 nPos = nLastReqTabStart;
        for( sal_uInt32 nIndex = nLastReqTabStart; nIndex < aObjDataList.Count(); nIndex++ )
        {
            XclImpObjData* pData = aObjDataList.GetObject( nIndex );
            XclImpEscherObj* pObj = pData ? pData->pEscherObj : NULL;
            if( pObj && (pObj->GetTab() == nTab) && (pObj->GetId() == nObjNum) )
                return pObj;
        }
    }
    return NULL;
}

XclImpEscherObj* XclImpEscherObjList::GetObjFromStream( sal_uInt32 nStrmPos )
{
    sal_uInt32 nObjNum;
    if( GetObjNum( nStrmPos, nObjNum ) )
        return GetObj( nObjNum );
    return NULL;
}

void XclImpEscherObjList::Apply( ScfProgressBar& rProgress )
{
    DBG_ASSERT( !rProgress.IsStarted(), "XclImpEscherObjList::Apply - progress already started" );

    XclImpObjData* pData;

    // initialize progress ranges for charts
    for( pData = aObjDataList.First(); pData; pData = aObjDataList.Next() )
    {
        if( pData->pEscherObj && (pData->pEscherObj->GetObjType() == otChart) )
        {
            XclImpEscherChart* pChartObj = static_cast< XclImpEscherChart* >( pData->pEscherObj );
            pChartObj->InitProgress( rProgress );
        }
    }

    // apply all objects
    for( pData = aObjDataList.First(); pData; pData = aObjDataList.Next() )
        if( pData->pEscherObj )
            pData->pEscherObj->Apply();
}



//___________________________________________________________________
// class XclImpObjectManager

XclImpObjectManager::XclImpObjectManager( RootData& rRootData ) :
    ExcRoot( &rRootData ),
    aStreamConsumer(),
    aEscherObjList( rRootData ),
    pCurrEscherObj( NULL ),
    bLeadingTxo( sal_False ),
    bMaybeTxo( sal_False ),
    bStartWithDummy( sal_True )
{
}

XclImpObjectManager::~XclImpObjectManager()
{
    if( pCurrEscherObj )
        delete pCurrEscherObj;
}

const XclImpEscherNote* XclImpObjectManager::GetObjNote( sal_uInt32 nObjNum, sal_uInt16 nTab ) const
{
    const XclImpEscherObj* pObj = GetObj( nObjNum, nTab );
    return IsType( pObj, otNote ) ? (const XclImpEscherNote*)pObj : NULL;
}

XclImpEscherTxo* XclImpObjectManager::GetTxoFromStream( sal_uInt32 nStrmPos )
{
    XclImpEscherObj* pObj = GetObjFromStream( nStrmPos );
    return IsType( pObj, otTxo ) ? (XclImpEscherTxo*)pObj : NULL;
}

void XclImpObjectManager::AppendCurrObjToList()
{
    if( pCurrEscherObj )
        aEscherObjList.Append( pCurrEscherObj );
    pCurrEscherObj = NULL;
}

void XclImpObjectManager::SetNewCurrObjChart()
{
    if ( pCurrEscherObj )
    {
        DBG_ERROR( "XclImpObjectManager::SetCurrObjChart - old escher object found" );
        delete pCurrEscherObj;
    }
    pCurrEscherObj = new XclImpEscherObj( 0, 0, *pExcRoot );
    // set any size
    pCurrEscherObj = new XclImpEscherChart( pCurrEscherObj );
}

XclImpChart* XclImpObjectManager::ReplaceChartData( XclImpStream& rStrm, XclChartType eNewType )
{
    XclImpEscherChart* pEscherObj = IsType( pCurrEscherObj, otChart ) ? (XclImpEscherChart*)pCurrEscherObj : NULL;
    XclImpChart* pChart = pEscherObj ? pEscherObj->GetChartData() : NULL;

    DBG_ASSERT( pChart, "XclImpObjectManager::ReplaceChartData - no chart data found" );
    if( !pChart )
        return NULL;

    // #92909# create line chart if no X values present
    // #94149# of course only for XY charts!
    if( (eNewType == ctScatter) && !pChart->HasXValues() )
        eNewType = ctLine;

    XclImpChart* pNewChart = NULL;
    switch( eNewType )
    {
        case ctLine:
        case ctArea:
            pNewChart = new XclImpChartLine( *pChart, rStrm, eNewType == ctArea );
        break;
        case ctBar:
            pNewChart = new XclImpChartBar( *pChart, rStrm );
        break;
        case ctPie:
            pNewChart = new XclImpChartPie( *pChart, rStrm );
        break;
        case ctNet:
            pNewChart = new XclImpChartRadar( *pChart );
        break;
        case ctScatter:
            pNewChart = new XclImpChartScatter( *pChart, rStrm );
        break;
        case ctSurface:
            pNewChart = new XclImpChartSurface( *pChart );
        break;
        default:
            DBG_ERROR( "XclImpObjectManager::ReplaceChartData - unknown chart type" );
            return pChart;
    }

    pEscherObj->SetChartData( pNewChart );
    return pNewChart;
}

void XclImpObjectManager::ReadMsodrawinggroup( XclImpStream& rStrm )
{
    aStreamConsumer.ConsumeRecord( rStrm );
}

void XclImpObjectManager::ReadMsodrawing( XclImpStream& rStrm )
{
    RootData& rRootData = *pExcRoot;

    rStrm.InitializeRecord( sal_False );    // disable internal CONTINUE handling
    sal_uInt32 nRecLen = rStrm.GetRecLen();

    if ( !aStreamConsumer.HasData() ) return;

    rStrm.PushPosition();

    if( bStartWithDummy )    // insert dummy object for invalid first shape
    {
        aEscherObjList.Append( new XclImpEscherObj( 0, 0, rRootData ) );
        bStartWithDummy = sal_False;
    }

    sal_uInt32 nStrmPos = aStreamConsumer.Tell();

    if( nRecLen )
    {
        const DffRecordHeader* pLatestRecHd = aStreamConsumer.ConsumeRecord( rStrm );
        if ( pLatestRecHd )
        {
            switch ( pLatestRecHd->nRecType )
            {
                case DFF_msofbtClientData :
                {
                    sal_Char aBuf[ 0x0100 ];
                    aStreamConsumer.AppendData( aBuf, 0x0100 );
                }
                break;
                case DFF_msofbtClientTextbox :
                {
                    sal_Char aBuf[ 0x0200 ];
                    aStreamConsumer.AppendData( aBuf, 0x0200 );
                }
                break;
            }
        }
    }
    if( bLeadingTxo )
    {
        DBG_ASSERTWARNING( IsType( pCurrEscherObj, otTxo ),
            "XclImpObjectManager::ReadMsodrawing - invalid predecessor object" );
        bLeadingTxo = sal_False;
    }
    else
    {
        if( pCurrEscherObj )
            delete pCurrEscherObj;

        pCurrEscherObj = new XclImpEscherObj( nStrmPos, aStreamConsumer.Tell() - 1, rRootData );

        if( bMaybeTxo )
        {
            if( nRecLen <= 8 )
            {
                rStrm.PopPosition();
                rStrm.Ignore( 2 );
                if( rStrm.ReaduInt16() != 0xF00D )
                    bMaybeTxo = sal_False;  // != Client Text Box
            }
            else
                bMaybeTxo = sal_False;
        }
    }
}

void XclImpObjectManager::ReadMsodrawingselection( XclImpStream& rStrm )
{
}

void XclImpObjectManager::ReadObj( XclImpStream& rStrm )
{
    sal_uInt16              nOpcode, nLenRec;
    sal_Bool                bLoop = sal_True;
    XclImpEscherObj*    pObj = NULL;

    rStrm.InitializeRecord( sal_False );      // disable internal CONTINUE handling

    while( bLoop && (rStrm.GetRecLeft() >= 4) )
    {
        rStrm >> nOpcode >> nLenRec;
        rStrm.PushPosition();

        switch( nOpcode )
        {
            case 0x00:  bLoop = sal_False;                              break;
            case 0x15:  pObj = ReadObjFtCmo( rStrm );               break;
            case 0x08:  ReadObjFtPioGrbit( rStrm, pObj );           break;
            case 0x09:  ReadObjFtPictFmla( rStrm, pObj, nLenRec );  break;
        }

        rStrm.PopPosition();
        // sometimes the last subrecord has an invalid length -> Min()
        rStrm.Ignore( Min( (sal_uInt32) nLenRec, rStrm.GetRecLeft() ) );
    }
}

XclImpEscherObj* XclImpObjectManager::ReadObjFtCmo( XclImpStream& rStrm )
{
    sal_uInt16 nOt, nOid, nGrbit;
    rStrm >> nOt >> nOid >> nGrbit;

    if( !pCurrEscherObj )
        pCurrEscherObj = new XclImpEscherObj( 0, 0, *pExcRoot );
    if ( pCurrEscherObj )
        pCurrEscherObj->SetId( nOid );

    bMaybeTxo = sal_False;

    XclImpEscherObj* pObj;
    switch( nOt )
    {
        case EXC_OBJT_LINE:
        case EXC_OBJT_RECT:
        case EXC_OBJT_ELLIP:
        case EXC_OBJT_ARC:
        case EXC_OBJT_POLYGON:
            aEscherObjList.Append( pObj = new XclImpEscherDrwObj( pCurrEscherObj ) );
            bMaybeTxo = sal_True;
        break;
        case EXC_OBJT_TEXT:
            pCurrEscherObj = pObj = new XclImpEscherTxo( pCurrEscherObj );
            bLeadingTxo = sal_True;
        break;
        case EXC_OBJT_NOTE:
            pCurrEscherObj = pObj = new XclImpEscherNote( pCurrEscherObj );
            bLeadingTxo = sal_True;
        break;
        case EXC_OBJT_PICT:
            aEscherObjList.Append( pObj = new XclImpEscherOle( pCurrEscherObj ) );
        break;
        case EXC_OBJT_CHART:
            pCurrEscherObj = pObj = new XclImpEscherChart( pCurrEscherObj );
        break;
        default:
            aEscherObjList.Append( pObj = new XclImpEscherDrwObj( pCurrEscherObj ) );
    }
    return pObj;
}

void XclImpObjectManager::ReadObjFtPioGrbit( XclImpStream& rStrm, XclImpEscherObj* pObj )
{
    XclImpEscherOle* pOle = IsType( pObj, otOle ) ? (XclImpEscherOle*)pObj : NULL;
    DBG_ASSERT( pOle, "XclImpObjectManager::ReadObjFtPioGrbit - no OLE object" );
    if( !pOle ) return;

    sal_uInt16 nBits;
    rStrm >> nBits;
    pOle->SetAsSymbol( nBits & 0x0008 );
    pOle->SetLinked( nBits & 0x0002 );
}

void XclImpObjectManager::ReadObjFtPictFmla( XclImpStream& rStrm, XclImpEscherObj* pObj, sal_uInt16 nLen )
{
    XclImpEscherOle* pOle = IsType( pObj, otOle ) ? (XclImpEscherOle*)pObj : NULL;
    DBG_ASSERT( pOle, "XclImpObjectManager::ReadObjFtPictFmla - no OLE object" );
    if( !pOle ) return;

    pOle->ReadPictFmla( rStrm, nLen );
}

void XclImpObjectManager::ReadTxo( XclImpStream& rStrm )
{
    rStrm.InitializeRecord( sal_False );      // disable internal CONTINUE handling

    sal_uInt16 nTextLen, nFormCnt;
    String* pText = NULL;
    EditTextObject* pFormText = NULL;

    // step 1: read TXO record
    rStrm.Ignore( 10 );
    rStrm >> nTextLen >> nFormCnt;
    nFormCnt /= 8;

    // step 2: read 1st CONTINUE with string
    sal_Bool bValid = sal_True;
    if( nTextLen )
    {
        rStrm.StartNextRecord();
        bValid = rStrm.IsValid() && (rStrm.GetRecNum() == EXC_CONT);
        DBG_ASSERT( bValid, "XclImpObjectManager::ReadTxo - missing CONTINUE record" );
        if( bValid )
        {
            rStrm.InitializeRecord( sal_False );
            pText = new String;
            rStrm.AppendUniString( *pText, nTextLen );
        }
    }

    // step 3: read 2nd CONTINUE with format runs
    if( bValid && pText && nFormCnt )
    {
        rStrm.StartNextRecord();
        bValid = rStrm.IsValid() && (rStrm.GetRecNum() == EXC_CONT);
        DBG_ASSERT( bValid, "XclImpObjectManager::ReadTxo - missing CONTINUE record" );
        if( bValid )
        {
            rStrm.InitializeRecord( sal_False );
            SvMemoryStream aMemStrm;
            aMemStrm << (sal_uInt16) 0x0001 << (sal_uInt16)(4 * (nFormCnt - 1));
            sal_uInt16 nChar, nFont;

            for( sal_uInt16 nIndex = 0; nIndex < nFormCnt; nIndex++ )
            {
                rStrm >> nChar >> nFont;
                rStrm.Ignore( 4 );
                if( nIndex < (nFormCnt - 1) )
                    aMemStrm << nChar << nFont;
            }

            XclImpStream aImpStrm( aMemStrm, pExcRoot->pCharset, sal_True );
            aImpStrm.StartNextRecord();
            ShStrTabFormEntry aHelpObj( *pText, aImpStrm, nFormCnt - 1 );
            pFormText = aHelpObj.CreateEditTextObject( pExcRoot->GetEdEng(), *pExcRoot->pFontBuffer );
        }
    }

    if( (pCurrEscherObj && !IsType( pCurrEscherObj, otNote )) || bMaybeTxo )
    {
        if( !pCurrEscherObj )
            pCurrEscherObj = new XclImpEscherObj( 0, 0, *pExcRoot );
        pCurrEscherObj = new XclImpEscherTxo( pCurrEscherObj );
    }

    if( pCurrEscherObj )
    {
        if( IsType( pCurrEscherObj, otTxo ) || IsType( pCurrEscherObj, otNote ) )
        {
            if( bValid )
            {
                ((XclImpEscherTxo*)pCurrEscherObj)->TakeText( pText, pFormText );
                pText = NULL;
                pFormText = NULL;
            }

            if( bMaybeTxo )
                aEscherObjList.MorpheLastObj( pCurrEscherObj );
            else
                aEscherObjList.Append( pCurrEscherObj );
            bMaybeTxo = sal_False;
        }
        else
            delete pCurrEscherObj;
        pCurrEscherObj = NULL;
    }
    if( pText )
        delete pText;
    if( pFormText )
        delete pFormText;
}

void XclImpObjectManager::Apply()
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLog, "sc", "dr104026", "XclImpObjectManager::Apply" );
    ScfProgressBar aProgress( STR_PROGRESS_CALCULATING );
    aEscherObjList.Apply( aProgress );
}



//___________________________________________________________________
// class Biff8MSDffManager

Biff8MSDffManager::Biff8MSDffManager(
        RootData&               rRootData,
        XclImpObjectManager&    rObjMan,
        sal_Int32                    nOffsDgg,
        SvStream*               pStData,
        SdrModel*               pSdrModel_,
        sal_Int32                    nApplicationScale,
        ColorData               mnDefaultColor_,
        sal_uInt32                   nDefaultFontHeight_,
        SvStream*               pStData2_ ) :
    SvxMSDffManager( rObjMan.GetEscherStream(), nOffsDgg, pStData, pSdrModel_,
        nApplicationScale, mnDefaultColor_, nDefaultFontHeight_, pStData2_ ),
    ExcRoot( &rRootData ),
    rObjManager( rObjMan )
{
    SetSvxMSDffSettings( SVXMSDFF_SETTINGS_CROP_BITMAPS | SVXMSDFF_SETTINGS_IMPORT_EXCEL );
}

Biff8MSDffManager::~Biff8MSDffManager()
{
}

void Biff8MSDffManager::ProcessClientAnchor2( SvStream& rStr, DffRecordHeader& rH, void*, DffObjData& rD )
{
    rH.SeekToContent( rStr );
    rStr.SeekRel( 2 );
    sal_uInt32                  nFilePos = rStr.Tell();

    XclImpAnchorData* pAnchor = rObjManager.GetAnchorDataAccess( nFilePos );
    if( pAnchor )
    {
        rStr >> *pAnchor;

        const sal_uInt16        nAnchTab = pAnchor->nTab;
        const sal_uInt16        nAnchRow = pAnchor->nRow;
        const sal_uInt16        nAnchCol = pAnchor->nCol;
        ScDocument*         pDoc = pExcRoot->pDoc;

        Rectangle&          rRect = rD.aChildAnchor;
        rRect.nLeft     = XclTools::CalcX( nAnchTab, nAnchCol, pAnchor->nX, HMM_PER_TWIPS, pDoc );
        rRect.nTop      = XclTools::CalcY( nAnchTab, nAnchRow, pAnchor->nY, HMM_PER_TWIPS, pDoc );
        rRect.nRight    = XclTools::CalcX( nAnchTab, pAnchor->nDCol, pAnchor->nDX, HMM_PER_TWIPS, pDoc );
        rRect.nBottom   = XclTools::CalcY( nAnchTab, pAnchor->nDRow, pAnchor->nDY, HMM_PER_TWIPS, pDoc );

        rD.bChildAnchor = sal_True;

        XclImpEscherObj* pObj = rObjManager.GetObjFromStream( nFilePos );
        if( pObj )
        {
            pObj->SetAnchor( rRect );
            if( pObj->GetObjType() == otOle )
                ((XclImpEscherOle*)pObj)->SetBlipId( GetPropertyValue( DFF_Prop_pib ) );
        }
    }
}

SdrObject* Biff8MSDffManager::ProcessObj(
    SvStream& rSt, DffObjData& rObjData, void* pData, Rectangle& rTextRect, SdrObject* pRet )
{
    if( pRet && ( GetPropertyValue( DFF_Prop_fNoFillHitTest ) & 0x10 ) &&
        ( IsProperty( DFF_Prop_fillColor ) == 0 ) )
    {   // maybe if there is no color, we could do this in ApplyAttributes ( writer ?, calc ? )
        pRet->SetItem(XFillColorItem(XubString(), Color(0xffffff)));
    }

    // #98132# don't ask for the text-ID, Escher export doesn't set one
//    XclImpEscherTxo* pTxoObj = NULL;
//    sal_uInt32                      nTextId = GetPropertyValue( DFF_Prop_lTxid, 0 );
//    if( nTextId )
//        pTxoObj = rObjManager.GetTxoFromStream( rObjData.rSpHd.nFilePos );
    XclImpEscherTxo* pTxoObj = rObjManager.GetTxoFromStream( rObjData.rSpHd.nFilePos );

    // #102378# ...but that leads to another problem: now the first text is
    // applied to the omnipresent first dummy shape in the table. In consequence
    // we will miss this text while processing the real text object.
    // Solution: filter the dummy shape (it has the flag SP_FPATRIARCH set).
    bool bDummy = (rObjData.nSpFlags & SP_FPATRIARCH) != 0;

    if( !bDummy && pTxoObj )
    {
        if( rObjData.eShapeType == mso_sptRectangle )
            delete pRet, pRet = NULL;

        SdrRectObj* pTObj = NULL;

        // Abstaende an den Raendern der Textbox lesen

        INT32                   nDefault = 92076;
        if( GetPropertyValue( DFF_Prop_FitTextToShape ) & 0x08 )
            nDefault = 20000;   // auto default

        INT32                   nTextLeft = GetPropertyValue( DFF_Prop_dxTextLeft, nDefault );
        INT32                   nTextRight = GetPropertyValue( DFF_Prop_dxTextRight, nDefault );
        INT32                   nTextTop = GetPropertyValue( DFF_Prop_dyTextTop, nDefault / 2 );
        INT32                   nTextBottom = GetPropertyValue( DFF_Prop_dyTextBottom, nDefault / 2 );
        ScaleEmu( nTextLeft );
        ScaleEmu( nTextRight );
        ScaleEmu( nTextTop );
        ScaleEmu( nTextBottom );
        // Die vertikalen Absatzeinrueckungen sind im BoundRect mit drin, hier rausrechnen
        rTextRect.Bottom() -= nTextTop + nTextBottom;

        INT32                   nTextRotationAngle = 0;
        if( IsProperty( DFF_Prop_txflTextFlow ) )
        {
            MSO_TextFlow eTextFlow = (MSO_TextFlow)( GetPropertyValue( DFF_Prop_txflTextFlow ) & 0xFFFF );
            switch( eTextFlow )
            {
                case mso_txflBtoT :                     // Bottom to Top non-@, unten -> oben
                    nTextRotationAngle = 9000;
                break;
                case mso_txflTtoBA :    /* #68110# */   // Top to Bottom @-font, oben -> unten
                case mso_txflTtoBN :                    // Top to Bottom non-@, oben -> unten
                case mso_txflVertN :                    // Vertical, non-@, oben -> unten
                    nTextRotationAngle = 27000;
                break;
                case mso_txflHorzN :                    // Horizontal non-@, normal
                case mso_txflHorzA :                    // Horizontal @-font, normal
                default :
                    nTextRotationAngle = 0;
                break;
            }
            if( nTextRotationAngle )
            {
                if( rObjData.nSpFlags & SP_FFLIPV )
                {
                    if( nTextRotationAngle == 9000 )
                        nTextRotationAngle = 27000;
                    else if( nTextRotationAngle == 27000 )
                        nTextRotationAngle = 9000;
                }
                Point nCenter( rTextRect.Center() );
                sal_Int32            nDX = rTextRect.Right() - rTextRect.Left();
                sal_Int32            nDY = rTextRect.Bottom() - rTextRect.Top();
                rTextRect.Left()       = nCenter.X() - nDY/2;
                rTextRect.Top()        = nCenter.Y() - nDX/2;
                rTextRect.Right()      = rTextRect.Left() + nDY;
                rTextRect.Bottom()     = rTextRect.Top()  + nDX;
            }
        }
        pTObj = new SdrRectObj( OBJ_TEXT, rTextRect );

        if( nTextRotationAngle )
        {
            double              f = nTextRotationAngle * nPi180;
            pTObj->NbcRotate( rTextRect.Center(), nTextRotationAngle, sin( f ), cos( f ) );
        }

        SfxItemSet              aSet( pSdrModel->GetItemPool() );
        if( !pRet )
        {
            if( ( GetPropertyValue( DFF_Prop_fNoFillHitTest ) & 0x10 ) &&
                ( IsProperty( DFF_Prop_fillColor ) == 0 ) )
            {   // maybe if there is no color, we could do this in ApplyAttributes ( writer ?, calc ? )
                pTObj->SetItem(XFillColorItem(XubString(), Color(0xffffff)));
            }

            ((SvxMSDffManager*)this)->ApplyAttributes( rSt, aSet, pTObj );
        }
        switch( (MSO_WrapMode)GetPropertyValue( DFF_Prop_WrapText, mso_wrapSquare ) )
        {
            case mso_wrapNone :
            {
                if( GetPropertyValue( DFF_Prop_FitTextToShape ) & 2 )   // be sure this is FitShapeToText
                    aSet.Put( SdrTextAutoGrowWidthItem( sal_True ) );
            }
                break;

            case mso_wrapByPoints :
                aSet.Put( SdrTextContourFrameItem( sal_True ) );
                break;
        }
        aSet.Put( SdrTextAutoGrowHeightItem( sal_False ) );

        // Abstaende an den Raendern der Textbox setzen
        aSet.Put( SdrTextLeftDistItem( nTextLeft ) );
        aSet.Put( SdrTextRightDistItem( nTextRight ) );
        aSet.Put( SdrTextUpperDistItem( nTextTop ) );
        aSet.Put( SdrTextLowerDistItem( nTextBottom ) );

        // Textverankerung lesen
        if( IsProperty( DFF_Prop_anchorText ) )
        {
            MSO_Anchor          eTextAnchor = (MSO_Anchor)GetPropertyValue( DFF_Prop_anchorText );

            SdrTextVertAdjust   eTVA = SDRTEXTVERTADJUST_CENTER;
            sal_Bool                bTVASet = sal_False;
            SdrTextHorzAdjust   eTHA = SDRTEXTHORZADJUST_CENTER;
            sal_Bool                bTHASet = sal_False;

            switch( eTextAnchor )
            {
                case mso_anchorTop:
                {
                    eTVA = SDRTEXTVERTADJUST_TOP;
                    bTVASet = sal_True;
                }
                    break;
                case mso_anchorTopCentered:
                {
                    eTVA = SDRTEXTVERTADJUST_TOP;
                    bTVASet = sal_True;
                    bTHASet = sal_True;
                }
                    break;

                case mso_anchorMiddle:
                    bTVASet = sal_True;
                    break;
                case mso_anchorMiddleCentered:
                {
                    bTVASet = sal_True;
                    bTHASet = sal_True;
                }
                    break;
                case mso_anchorBottom:
                {
                    eTVA = SDRTEXTVERTADJUST_BOTTOM;
                    bTVASet = sal_True;
                }
                    break;
                case mso_anchorBottomCentered:
                {
                    eTVA = SDRTEXTVERTADJUST_BOTTOM;
                    bTVASet = sal_True;
                    bTHASet = sal_True;
                }
                    break;
            }

            // Einsetzen
            if( bTVASet )
                aSet.Put( SdrTextVertAdjustItem( eTVA ) );
            if( bTHASet )
                aSet.Put( SdrTextHorzAdjustItem( eTHA ) );
        }

        aSet.Put( SdrTextMinFrameHeightItem( rTextRect.Bottom() - rTextRect.Top() ) );
        pTObj->SetModel( pSdrModel );
        // #96092# SetModel() modifies the height of the text box -> restore it with NbcSetSnapRect()
        pTObj->NbcSetSnapRect( rTextRect );

//-/        pTObj->NbcSetAttributes( aSet, sal_False );
        pTObj->SetItemSet(aSet);

        // Apply the Sdr text object to the Escher TXO object
        pTxoObj->Apply( pTObj );

        if( pTObj )
        {   // rotate text with shape ?
            if( mnFix16Angle )
            {
                double          f = mnFix16Angle * nPi180;
                pTObj->NbcRotate( rObjData.rBoundRect.Center(), mnFix16Angle, sin( f ), cos( f ) );
            }

            if( pRet )
            {
                SdrObject*      pGroup = new SdrObjGroup;
                pGroup->GetSubList()->NbcInsertObject( pRet );
                pGroup->GetSubList()->NbcInsertObject( pTObj );
                pRet = pGroup;
            }
            else
                pRet = pTObj;
        }
        if( (rObjData.nCalledByGroup == 0) ||
            ((rObjData.nSpFlags & SP_FGROUP) && (rObjData.nCalledByGroup < 2)) )
        {
            sal_uInt32 nTextId = GetPropertyValue( DFF_Prop_lTxid, 0 );
            StoreShapeOrder( rObjData.nShapeId, nTextId, pRet );
        }
    }
    return pRet;
}

sal_uInt32 Biff8MSDffManager::Calc_nBLIPPos( sal_uInt32 nOrgVal, sal_uInt32 nStreamPos ) const
{
    return nStreamPos + 4;
}

FASTBOOL Biff8MSDffManager::GetColorFromPalette( sal_uInt16 nIndex, Color& rColor ) const
{
    const SvxColorItem* pItem = pExcRoot->pColor->GetColor( nIndex, sal_False );

    if( pItem )
    {
        rColor = pItem->GetValue();
        return TRUE;
    }
    return FALSE;
}

sal_Bool Biff8MSDffManager::ShapeHasText( sal_uInt32 nShapeId, sal_uInt32 nFilePos ) const
{
    const XclImpEscherTxo* pTxoObj = rObjManager.GetTxoFromStream( nFilePos );
    return pTxoObj ? (pTxoObj->GetText() != NULL) : sal_False;
}

void Biff8MSDffManager::SetSdrObject( XclImpEscherObj* pEscherObj, sal_uInt32 nId, SvxMSDffImportData& rData )
{
    SdrObject* pSdrObj = NULL;
    sal_Bool bRet = GetShape( nId, pSdrObj, rData );
    if( bRet )
        pEscherObj->SetSdrObj( pSdrObj );
    else if( pSdrObj )
        delete pSdrObj;
}

