/*************************************************************************
 *
 *  $RCSfile: XclExpCharts.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: dr $ $Date: 2001/10/23 15:03:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_XCLEXPCHARTS_HXX
#define _SC_XCLEXPCHARTS_HXX

#ifndef _COM_SUN_STAR_CHART_XCHARTDOCUMENT_HPP_
#include <com/sun/star/chart/XChartDocument.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_XDIAGRAM_HPP_
#include <com/sun/star/chart/XDiagram.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_X3DDISPLAY_HPP_
#include <com/sun/star/chart/X3DDisplay.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSHAPE_HPP_
#include <com/sun/star/drawing/XShape.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _REF_HXX //autogen wg. SV_DECL_REF_LIST
#include <tools/ref.hxx>
#endif

#ifndef SC_RANGELST_HXX
#include "rangelst.hxx"
#endif

#ifndef _CHRTDEFS_HXX
#include "chrtdefs.hxx"
#endif
#ifndef _XCL97REC_HXX
#include "xcl97rec.hxx"
#endif
#ifndef _EXCUPN_HXX
#include "excupn.hxx"
#endif


// -------------------------------------------------------------------

SV_DECL_REF_LIST( ScRangeList, ScRangeList* );

// --- struct XclPosSize ---------------------------------------------

struct XclPosSize
{
	INT32						nPosX;
	INT32						nPosY;
	INT32						nWidth;
	INT32						nHeight;
	UINT16						nAngle;

	inline void					Set( INT32 nX, INT32 nY, INT32 nW, INT32 nH, UINT16 nA = 0 );
};


inline void XclPosSize::Set( INT32 nX, INT32 nY, INT32 nW, INT32 nH, UINT16 nA )
{
	nPosX = nX; nPosY = nY; nWidth = nW; nHeight = nH; nAngle = nA;
}


// --- class XclChartDataFormat --------------------------------------
// contains global properties of data series

class XclChartDataFormat
{
private:
	BOOL						bDiff;

public:
	// line format
	UINT16						nLineStyle;
	INT16						nLineWidth;
	Color						aLineColor;
	UINT16						nLineIndex;
	// area format
	UINT16						nAreaStyle;
	Color						aAreaColor;
	UINT16						nAreaIndex;
	// gradient
	UINT32						nGradientMode;
	Color						aGradientFColor;
	UINT16						nGradientFIndex;
	Color						aGradientBColor;
	UINT16						nGradientBIndex;
	INT16						nGradientRot;
	INT16						nGradientCol2Pos;
	// pie segment offset
	UINT16						nSegment;
	// line symbols
	BOOL						bHasSymbol;
	// data captions
	UINT16						nFontx;
	Color						aTextColor;
	UINT16						nTextIndex;
	UINT16						nTextFlags;
	UINT16						nLabelFlags;
	// 3D bar style
	UINT8						nDataFormatBase;
	UINT8						nDataFormatTop;

								XclChartDataFormat();
								XclChartDataFormat( const XclChartDataFormat& rSrc );

	void						SetLineFormat( UINT16 nStyle, INT16 nWidth, const Color& rColor, UINT16 nIndex );
	void						SetAreaFormat( UINT16 nStyle, const Color& rColor, UINT16 nIndex );
	void						SetGradient(
									UINT32 nMode,
									const Color& rForeColor, UINT16 nForeIndex,
									const Color& rBackColor, UINT16 nBackIndex,
									INT16 nRot, INT16 nCol2Pos );
	inline void					SetSegmentOffset( UINT16 nSeg );
	inline void					SetSymbol( BOOL bHas );
	void						SetTextFormat(
									UINT16 nFx, const Color& rColor, UINT16 nIndex,
									UINT16 nTFl, UINT16 nLFl );
	void						SetSolidType( UINT8 nBase, UINT8 nTop );

	UINT16						GetSymbol( UINT16 nSeries ) const;

	inline BOOL					IsDifferent() const		{ return bDiff; }
};


inline void XclChartDataFormat::SetSegmentOffset( UINT16 nSeg )
{
	bDiff |= (nSegment != nSeg);
	nSegment = nSeg;
}

inline void XclChartDataFormat::SetSymbol( BOOL bHas )
{
	bDiff |= (bHasSymbol && !bHas);
	bHasSymbol &= bHas;
}


// --- struct XclChartText -------------------------------------------
// contains data for a TEXT record

struct XclChartText
{
	UINT16						nSeries;
	UINT16						nPoint;
	UINT16						nFontx;
	ColorData					nRGB;
	UINT16						nIndex;
	UINT16						nFlags;

								XclChartText( UINT16 nSer, UINT16 nPt,
											const XclChartDataFormat& rFormats );
};


// --- class XclChartTextList ----------------------------------------
// list of XclChartText, write them at end of chart

class XclChartTextList : private List
{
private:
	inline XclChartText*		_First()	{ return (XclChartText*) List::First(); }
	inline XclChartText*		_Next()		{ return (XclChartText*) List::Next(); }

protected:
public:
	virtual						~XclChartTextList();

	inline const XclChartText*	First()		{ return (const XclChartText*) List::First(); }
	inline const XclChartText*	Next()		{ return (const XclChartText*) List::Next(); }

	inline void					Append( XclChartText* pText )
											{ List::Insert( pText, LIST_APPEND ); }
};


// --- class XclObjChart ---------------------------------------------

class ScChartArray;
//class ExcUPN;

class XclObjChart : public XclObj
{
private:
	enum TextType			// for WriteGroupText(), WriteText(), WritePos()
	{
		ttNone,				// no POS record
		ttCommon,			// POS record
		ttTitle,			// POS record chart relative
		ttLegend,			// no POS record
		ttXAxisTitle,		// POS record X axis relative
		ttYAxisTitle,		// POS record Y axis relative
		ttZAxisTitle,		// POS record Z axis relative
		ttDataCaption		// caption of data points
	};

	enum DefaultAlign		// for WriteText()
	{
		daAboveTop,
		daBelowTop,
		daCenter,
		daAboveBottom,
		daBelowBottom
	};

    CSS::uno::Reference< CSS::drawing::XShape >       xChartShape;
    CSS::uno::Reference< CSS::chart::XChartDocument > xChartDoc;
    CSS::uno::Reference< CSS::beans::XPropertySet >   xDocProp;
    CSS::uno::Reference< CSS::chart::XDiagram >       xDiagram;
    CSS::uno::Reference< CSS::beans::XPropertySet >   xDiaProp;
    CSS::uno::Reference< CSS::chart::X3DDisplay >     xDiagr3D;
    CSS::uno::Any    aAny;               // used for Get...PropValue
	ScRangeListMemberList		aSeriesYRangeList;	// Y-values
	ScRangeListMemberList		aSeriesXRangeList;	// X-categories
	List						aSeriesYUpnList;	// Y-UPN values
	List						aSeriesXUpnList;	// X-UPN categories
	List						aSeriesNUpnList;	// N-UPN names, title or text
	List						aSerieslistList;	// list of SvUShort arrays
	XclChartTextList			aTextList;			// write TEXT groups at end of chart
	double						fX4000;
	double						fY4000;
	RootData&					rRootData;
	const SdrObject&			rChartObj;
	ExcPalette2&				rPal;
	UsedFontList&				rFontList;
	ScChartArray*				pChartArray;
	XclExpStream*				pStrm;
    XclChartType                eChartType;
	XclPosSize					aDiaPosSize;
	XclChartDataFormat			aDiaFormats;
	UINT16						nMaxSegOffset;		// correct diagram area for pie chart
	USHORT						nLevel;				// BEGIN, END
	USHORT						nChartDataColumns;
	UINT16						nChartCategoriesDataType;
    UINT16                      nCurrAxesSet;
    UINT16                      nCurrAxis;
	BOOL						bInitOk			: 1;
	BOOL						bColHeaders		: 1;
	BOOL						bRowHeaders		: 1;
	BOOL						bXAxisDescr		: 1;
	BOOL						bYAxisDescr		: 1;
	BOOL						bChartStacked	: 1;
	BOOL						bChartPercent	: 1;
	BOOL						bChartLine		: 1;
	BOOL						bChartSpline	: 1;
	BOOL						bChart3D		: 1;
	BOOL						bChartDeep		: 1;
	BOOL						bStockUpDown	: 1;
	BOOL						bStockVolume	: 1;
	BOOL						bChartTypeRound	: 1;	// ctPie, ctDonut
	BOOL						bChartTypeBars	: 1;	// ctBar, ctColumn
    BOOL                        bHasSecAxes     : 1;    // any series on secondary Y-axis?
	BOOL						bWriteMode		: 1;


	// properties
			BOOL				GetPropValue(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			BOOL				GetPropBool(	// FALSE = either property value is FALSE or property not found
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			BOOL				GetPropBool(	// property in rValue
									sal_Bool& rValue,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			BOOL				GetPropInt32(
									sal_Int32& rValue,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			BOOL				GetPropInt16(
									sal_Int16& rValue,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			BOOL				GetPropDouble(
									double& rValue,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);

			void				GetChartType();

			ColorData			GetColor(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			void				GetTextColor(
									Color& rColor, UINT16& rIndex,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);

			ExcFont*			NewExcFont(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);

			UINT16				GetFontx(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				GetTextFormat(
									UINT16& rFontx,
									Color& rColor, UINT16& rColIndex,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);

			void				GetLineformat(
									UINT16& rStyle, INT16& rWidth,
									Color& rColor, UINT16& rColIndex,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				GetAreaformat(
									UINT16& rStyle, Color& rColor, UINT16& rColIndex,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				GetGradient(
									UINT32& rMode, UINT16& rForeIndex, UINT16& rBackIndex, INT16& rRot, INT16& rCol2Pos,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				GetGradient(
									UINT32& rMode, Color& rForeColor, UINT16& rForeIndex,
									Color& rBackColor, UINT16& rBackIndex,
									INT16& rRot, INT16& rCol2Pos,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);

			BOOL				GetDataCaption(
									UINT16& rTextFlags, UINT16& rLabelFlags,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);

			void				GetFormats(
									XclChartDataFormat& rFormats,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									BOOL bGetLineArea, BOOL bGetText
									);

	// initialization, global functions
			void				InitChartFormats();
	virtual	void				SaveCont( XclExpStream& rStrm );

								// FALSE	= find formats (colors, fonts, number formats)
								// TRUE		= save the chart
			void				GoThroughChart( BOOL bSetWriteMode );

			BOOL				InitInterface();
			void				InitValues();
			void				AppendToSeriesNUpnList( const ScAddress* pA );
			void				BuildSeriesList();

	// writing records...
	inline	void				StartRecord( UINT16 nRecNum, ULONG nRecLen )
												{ pStrm->StartRecord( nRecNum, nRecLen ); }
	inline	void				EndRecord()		{ pStrm->EndRecord(); }

	inline	void				WriteEmptyRecord( UINT16 nRecNum );
	inline	void				WriteUINT16Record( UINT16 nRecNum, UINT16 nData );

			void				WriteBeginLevel();
			void				WriteEndLevel();

			void				WriteSheetHeaderSetup();
			void				WriteChart();
			void				WriteShtprops();

	inline	void				WriteRGB( ColorData nRGB );

	// FRAME group
			void				WriteGroupFrame(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xShape,
									BOOL bAutoSize = TRUE
									);
			void				WriteGroupFrame(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									BOOL bAutoSize = TRUE
									);
			void				WriteFrame( BOOL bAutoSize );

			void				WriteLineformat(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									UINT16 nGrbit = 0x0000
									);
			void				WriteLineformat( const XclChartDataFormat& rF, UINT16 nGrbit = 0x0000 );
			void				WriteLineformat(
									ColorData nRGB, UINT16 nIndex,
									UINT16 nStyle, INT16 nWidth, UINT16 nGrbit
									);

			void				WriteAreaformat(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									UINT16 nGrbit = 0x0000
									);
			void				WriteAreaformat( const XclChartDataFormat& rF, UINT16 nGrbit = 0x0000 );
			void				WriteAreaformat(
									ColorData nForeRGB, ColorData nBackRGB,
									UINT16 nForeIndex, UINT16 nBackIndex,
									UINT16 nStyle, UINT16 nGrbit
									);

			void				WriteGelframe(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				WriteGelframe( const XclChartDataFormat& rF );
			void				WriteGelframe(
									UINT32 nMode, UINT16 nForeIndex, UINT16 nBackIndex,
									INT16 nRot, INT16 nCol2Pos
									);

	// POS record - position, size, rotation
			void				WritePos(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xShape,
									TextType eType
									);
			void				WritePos( const XclPosSize& rPos, TextType eType );

			void				WritePosData(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xShape,
									TextType eType
									);
			void				WritePosData( const XclPosSize& rPos, TextType eType );

			INT32				GetDefRelPos(
									INT32 nPos, INT32 nSize,
									INT32 nParPos, INT32 nParSize,
									DefaultAlign eDefAlign, INT32 nDist,
									INT32 nScaling = 4000
									);

			void				GetPosSize(
									XclPosSize& rP,
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xShape
									);

			BOOL				GetRotation(
									UINT16& nRealAngle,
									UINT16& nExcAngle,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			UINT16				GetRotationFlags( UINT16 nExcAngle );

	// TEXT group
			void				WriteTheText();
			void				WriteDefaulttext( UINT16 nId );
			void				WriteGroupText(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xTextShape,
									TextType eType
									);
			void				WriteGroupText(
									UINT16 nSeries, UINT16 nPoint, UINT16 nFontx,
									ColorData nRGB, UINT16 nIndex, UINT16 nFlags
									);

			void				WriteText(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xTextShape,
									const XclPosSize& rPosSize,
									TextType eType
									);
			void				WriteText(
									const XclPosSize& rPosSize,
									ColorData nRGB, UINT16 nIndex,
									TextType eType,
									UINT16 nFlags
									);

			void				WriteFontx(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				WriteFontx( UINT16 nFontx );
			void				WriteAI();
			void				WriteSeriestext(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				WriteSeriestext( const XclExpUniString& rString );
			void				WriteObjectlink( UINT16 nLinkObj, UINT16 nLinkVar1, UINT16 nLinkVar2 );

			void				WriteTextList();

	// SERIES group
			void				WriteTheSeries();
			void				WriteGroupSeries(
									UINT16 nSeriesCnt,
									UINT16 nSeriesIndex,
									UINT16 nSeriesNumber,
									UINT16 nXCatCount,
									UINT16 nYValCount,
									const ExcUPN& rYUPN,
									const ExcUPN* pXUPN,
									const ExcUPN* pNUPN
									);
			void				WriteSeries( UINT16 nXValCount, UINT16 nYValCount );

	// DATAFORMAT group
			void				WriteGroupDataformat(
									UINT16 nSeriesIndex,
									UINT16 nSeriesNumber,
									UINT16 nSeriesPoint,
									const XclChartDataFormat& rFormats
									);
			void				WriteDataformat(
									UINT16 nSeriesIndex,
									UINT16 nSeriesNumber,
									UINT16 nSeriesPoint
									);
			void				Write3DDataformat( const XclChartDataFormat& rFormats );
			void				WriteMarkerformat( UINT16 nType, UINT16 nBordInd, UINT16 nFillInd );
			void				WriteSerfmt( UINT16 nFlags );
			void				WriteAttachedLabel( UINT16 nFlags );
			void				WriteSertocrt();
			void				WriteAI( const ExcUPN* pUPN, UINT8 nType, UINT8 nRef, UINT16 nFmt );

	// AXIS group
			void				WriteAllAxes();
			void				WriteAxesused( UINT16 nNumber );
            void                WriteTheAxes( UINT16 nNewAxesSet );
			void				WriteAxisparent();
			void				WritePlotarea();
            void                WriteGroupAxis( UINT16 nNewAxis );
			void				WriteFirstXAxis(
                                    CSS::uno::Reference< CSS::drawing::XShape >& xTitle,
                                    TextType& rType,
                                    BOOL bMaxCross
									);
//            void                WriteSecondXAxis();
			void				WriteFirstYAxis(
                                    CSS::uno::Reference< CSS::drawing::XShape >& xTitle,
									TextType& rType,
									BOOL bWriteExtras
									);
			void				WriteSecondYAxis();
			void				WriteFirstZAxis(
                                    CSS::uno::Reference< CSS::drawing::XShape >& xTitle,
									TextType& rType
									);
			void				WriteAxis();
			void				WriteXZRange();
			void				WriteCatserrange();
			void				WriteAxcext();
			BOOL				WriteTick(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									BOOL bHasDescr
									);
			void				WriteValuerange(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
                                    BOOL bMaxCross
									);
			void				WriteIfmt(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				WriteTheAxisline(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									UINT16 nId, BOOL bTicks = FALSE
									);
			void				WriteTheAxisframe(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									UINT16 nId
									);
			void				WriteAxislineformat( UINT16 nId );

	// chart formats
            void                WriteGroupChartformat();
			void				WriteChartformat( UINT16 nZOrder );
			void				WriteSerieslist( UINT16 nAxesSet );
			void				Write3D();
			void				WriteTheChartline( UINT16 nId );
			void				WriteChartline( UINT16 nId );
			void				WriteTheDropbars();
			void				WriteGroupDropbar( UINT16 nBar );
			void				WriteDropbar();

	// chart types
	inline	void				WriteLine()		{ WriteLineArea( 0x1018 ); }
	inline	void				WriteArea()		{ WriteLineArea( 0x101A ); }
			void				WriteLineArea( UINT16 nRecId );
			void				WriteBar();
			void				WritePie();
			void				WritePieformat( UINT16 nPercent );
			void				WriteScatter();
			void				WriteRadar();

	// main title, legend
			void				WriteTheMainTitle();

			void				WriteGroupLegend();
			void				WriteLegend(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xShape
									);
	// SIINDEX
			void				WriteTheSiindex();
			void				WriteSiindex( UINT16 nIndex );

public:
								XclObjChart( RootData& rRoot,
                                    const CSS::uno::Reference< CSS::drawing::XShape >& rShape
									);
	virtual						~XclObjChart();

	virtual	void				Save( XclExpStream& rStrm );
	virtual	ULONG				GetLen() const;		// GetNum() done by XclObj
};


inline void XclObjChart::WriteEmptyRecord( UINT16 nRecNum )
{
	pStrm->StartRecord( nRecNum, 0 );
	pStrm->EndRecord();
}

inline void XclObjChart::WriteUINT16Record( UINT16 nRecNum, UINT16 nData )
{
	pStrm->StartRecord( nRecNum, 2 );
	*pStrm << nData;
	pStrm->EndRecord();
}

inline void XclObjChart::WriteRGB( ColorData nRGB )
{
	*pStrm	<< COLORDATA_RED( nRGB )
			<< COLORDATA_GREEN( nRGB )
			<< COLORDATA_BLUE( nRGB )
			<< (UINT8)0;
}


#endif

