/*************************************************************************
 *
 *  $RCSfile: XclExpHelper.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/28 16:41:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_XCLEXPHELPER_HXX
#define _SC_XCLEXPHELPER_HXX

#ifndef _SC_FILTERTOOLS_HXX
#include "FilterTools.hxx"
#endif
#ifndef _SC_XCLEXPSTREAM_HXX
#include "XclExpStream.hxx"
#endif
#ifndef _EXCDEFS_HXX
#include "excdefs.hxx"
#endif


class ScDocument;
class ScMatrix;
class ExcRichStr;


//___________________________________________________________________

/** This class stores a string containing 8-bit characters or 16-bit Unicode characters.
    The string can be exported to Excel files in many different ways. */
class XclExpUniString
{
private:
    sal_uInt16*                 pBuffer;        /// The character buffer.
    sal_uInt16                  nLen;           /// The current character count.
    sal_Bool                    b16Bit;         /// sal_True, if any of the characters is >0xFF.

                                /** Creates a new character buffer from the given buffer.
                                    @param  pSource
                                    The source character buffer. Trailing NULL character is not necessary.
                                    @param  nCount
                                    The count of characters contained in the buffer.
                                    @param  bForce16Bit
                                    16-bit-character mode: sal_False = Auto detection; sal_True = Always 16-bit; */
    void                        Build( const sal_Unicode* pSource, sal_uInt16 nCount, sal_Bool bForce16Bit = sal_False );

                                /** Initializes write process on stream. */
    void                        PrepareWrite( XclExpStream& rStrm, sal_uInt32 nBytes ) const;

protected:
                                /** Writes the Unicode string header (length field and string flags field).
                                    @param  nAddLen
                                    The additional size of header data to write after this basic header.
                                    @param  b16BitCount
                                    Write length field: sal_False = As 8-bit-integer; sal_True = As 16-bit-integer.
                                    @param  bForceFlags
                                    Write flags field: sal_False = Only if string is not empty; sal_True = Always. */
    void                        WriteRawHeader(
									XclExpStream& rStrm,
                                    sal_uInt32 nAddLen,
                                    sal_Bool b16BitCount,
                                    sal_Bool bForceFlags ) const;

public:
								XclExpUniString();
								XclExpUniString( const XclExpUniString& rCopy );

                                /** Constructs an XclExpUniString.
                                    @param  nMaxLen
                                    The maximum number of characters to store in this string.
                                    @param  bForce16Bit
                                    16-bit-character mode: sal_False = Auto detection; sal_True = Always 16-bit; */
								XclExpUniString(
									const String& rString,
                                    sal_uInt16 nMaxLen = 0xFFFF,
                                    sal_Bool bForce16Bit = sal_False );
                                /** Constructs an XclExpUniString.
                                    @param  nMaxLen
                                    The maximum number of characters to store in this string.
                                    @param  bForce16Bit
                                    16-bit-character mode: sal_False = Auto detection; sal_True = Always 16-bit; */
								XclExpUniString(
									const ::rtl::OUString& rString,
                                    sal_uInt16 nMaxLen = 0xFFFF,
                                    sal_Bool bForce16Bit = sal_False );

	virtual						~XclExpUniString();

                                /** Assigns a new string.
                                    @param  nMaxLen
                                    The maximum number of characters to store in this string.
                                    @param  bForce16Bit
                                    16-bit-character mode: sal_False = Auto detection; sal_True = Always 16-bit; */
	void						Assign(
									const String& rString,
                                    sal_uInt16 nMaxLen = 0xFFFF,
                                    sal_Bool bForce16Bit = sal_False );
                                /** Assigns a new string.
                                    @param  nMaxLen
                                    The maximum number of characters to store in this string.
                                    @param  bForce16Bit
                                    16-bit-character mode: sal_False = Auto detection; sal_True = Always 16-bit; */
	void						Assign(
									const ::rtl::OUString& rString,
                                    sal_uInt16 nMaxLen = 0xFFFF,
                                    sal_Bool bForce16Bit = sal_False );

                                /** @return  The character count of the string. */
    inline sal_uInt16           GetLen() const              { return nLen; }
                                /** @return  The current string flags field. */
    virtual sal_uInt8           GetGrbit() const;

                                /** @return  The byte count the character buffer will take on export. */
    inline sal_uInt32           GetBufferByteCount() const  { return GetLen() * (b16Bit ? 2 : 1); }
                                /** @return  The byte count the whole string will take on export (assuming 3 byte header!). */
    virtual sal_uInt32          GetByteCount() const;

                                /** Writes the raw character buffer to memory (8-bit or 16-bit little-endian) */
	void						WriteBuffer( void* pDest ) const;

                                /** Writes the string flags field (1 byte). */
	virtual void				WriteFlags( XclExpStream& rStrm ) const;
                                /** Writes 8-bit or 16-bit length field and string flags field.
                                    @param  b16BitCount
                                    Write length field: sal_False = As 8-bit-integer; sal_True = As 16-bit-integer.
                                    @param  bForceFlags
                                    Write flags field: sal_False = Only if string is not empty; sal_True = Always. */
	virtual void				WriteHeader(
									XclExpStream& rStrm,
                                    sal_Bool b16BitCount = sal_True,
                                    sal_Bool bForceFlags = sal_True ) const;
                                /** Writes the raw character buffer. */
	virtual void				WriteBuffer( XclExpStream& rStrm ) const;

                                /** Writes the complete Unicode string.
                                    @param  b16BitCount
                                    Write length field: sal_False = As 8-bit-integer; sal_True = As 16-bit-integer.
                                    @param  bForceFlags
                                    Write flags field: sal_False = Only if string is not empty; sal_True = Always. */
	virtual void				Write(
									XclExpStream& rStrm,
                                    sal_Bool b16BitCount = sal_True,
                                    sal_Bool bForceFlags = sal_True ) const;
};


//___________________________________________________________________

/** This class stores a rich-string containing 8-bit characters or 16-bit Unicode characters.
    A rich-string additionally contains formatting information for all characters. */
class XclExpRichString : public XclExpUniString
{
private:
    ExcRichStr*                 pRichData;      /// A helper class to store formatting information.

public:
								XclExpRichString();
								XclExpRichString( const XclExpRichString& rCopy );

                                /** Constructs an XclExpRichString. Formatting information has to be stored using SetRichData().
                                    @param  nMaxLen
                                    The maximum number of characters to store in this string.
                                    @param  bForce16Bit
                                    16-bit-character mode: sal_False = Auto detection; sal_True = Always 16-bit; */
								XclExpRichString(
									const String& rString,
                                    sal_uInt16 nMaxLen = 0xFFFF,
                                    sal_Bool bForce16Bit = sal_False );
                                /** Constructs an XclExpRichString. Formatting information has to be stored using SetRichData().
                                    @param  nMaxLen
                                    The maximum number of characters to store in this string.
                                    @param  bForce16Bit
                                    16-bit-character mode: sal_False = Auto detection; sal_True = Always 16-bit; */
								XclExpRichString(
									const ::rtl::OUString& rString,
                                    sal_uInt16 nMaxLen = 0xFFFF,
                                    sal_Bool bForce16Bit = sal_False );

	virtual						~XclExpRichString();

                                /** Sets formatting information for this string. The data will be deleted on destruction. */
    void                        SetRichData( ExcRichStr* pNewData );

                                /** @return  The current string flags field. */
    virtual sal_uInt8           GetGrbit() const;
                                /** @return  The byte count the whole string will take on export including
                                    formatting information (assuming 3 byte header!). */
    virtual sal_uInt32          GetByteCount() const;

                                /** Writes 8-bit or 16-bit length field, string flags field and size of formatting data.
                                    @param  b16BitCount
                                    Write length field: sal_False = As 8-bit-integer; sal_True = As 16-bit-integer.
                                    @param  bForceFlags
                                    Write flags field: sal_False = Only if string is not empty; sal_True = Always. */
	virtual void				WriteHeader(
									XclExpStream& rStrm,
                                    sal_Bool b16BitCount = sal_True,
                                    sal_Bool bForceFlags = sal_True ) const;

                                /** Writes the complete Unicode string including formatting data.
                                    @param  b16BitCount
                                    Write length field: sal_False = As 8-bit-integer; sal_True = As 16-bit-integer.
                                    @param  bForceFlags
                                    Write flags field: sal_False = Only if string is not empty; sal_True = Always. */
	virtual void				Write(
									XclExpStream& rStrm,
                                    sal_Bool b16BitCount = sal_True,
                                    sal_Bool bForceFlags = sal_True ) const;
};


//___________________________________________________________________

/** The base class for cached values. Cached values are used to store a list or a 2D array
    of double, string and Boolean values and error codes, for instannce in the records
    CRN and EXTERNNAME or in the token ptgArray. */
class XclExpCachedValue
{
public:
    virtual                     ~XclExpCachedValue();
    virtual void                Save( XclExpStream& rStrm ) = 0;
};


/** A cached value that stores a double. */
class XclExpCachedValueDbl : public XclExpCachedValue
{
private:
    double                      fVal;           /// The double value.
public:
    inline                      XclExpCachedValueDbl( double _fVal ) : fVal( _fVal ) {}
                                /** Writes the double value to stream. */
    virtual void                Save( XclExpStream& rStrm );
};


/** A cached value that stores a string. */
class XclExpCachedValueStr : public XclExpCachedValue
{
private:
    XclExpUniString             aStr;           /// The string.
    sal_Bool                    b16BitCnt;      /// String length write mode: sal_False = 8-bit, sal_True = 16-bit.
public:
                                XclExpCachedValueStr( const String& rStr, sal_Bool b16BitCount );

                                /** @return  The byte size of the complete string. */
    inline sal_uInt32           GetLen();
                                /** Writes the string to stream. */
    virtual void                Save( XclExpStream& rStrm );
};

inline sal_uInt32 XclExpCachedValueStr::GetLen()
{
    return aStr.GetBufferByteCount() + 3 + (b16BitCnt ? 1 : 0);
}



/** List of cached values (for CRN, EXTERNNAME, ptgArray, ...). The file format is as follows:
    (1 byte) column count - 1
    (2 byte) row count - 1
    (x byte) list of values (doubles, strings)

    - Structure of a double value: (XclExpCachedValueDbl)
        (1 byte) 0x01 (identifier)
        (8 byte) double

    - structure of a string value: (XclExpCachedValueStr)
        (1 byte) 0x02 (identifier)
        (1 byte) or (2 byte) length
        (1 byte) unicode flags (always!)
        (x byte) character array
*/
class XclExpCachedValueList : private ScfObjList< XclExpCachedValue >
{
private:
    sal_uInt32                  nLen;           /// Size of all data.
    sal_uInt16                  nCols;          /// Column count of the value matrix.
    sal_uInt16                  nRows;          /// Row count of the value matrix.
    sal_Bool                    b16BitCnt;      /// String length write mode: sal_False = 8-bit, sal_True = 16-bit.

    void                        Append( double fVal );
    void                        Append( const String& rStr );

public:
                                /** Constructs and fills a new list.
                                    @param  _nCols
                                    The column count of the value matrix.
                                    @param  _nRows
                                    The row count of the value matrix.
                                    @param  pMatrix
                                    The value matrix.
                                    @param  b16BitCount
                                    String length write mode: sal_False = 8-bit, sal_True = 16-bit. */
                                XclExpCachedValueList(
                                    ScDocument& rDoc,
                                    sal_uInt16 _nCols,
                                    sal_uInt16 _nRows,
                                    const ScMatrix* pMatrix,
                                    sal_Bool b16BitCount );

                                /** @return  The byte count of all contained data. */
    inline sal_uInt32           GetLen() const  { return nLen; }
                                /** Writes the complete list to stream. */
    void                        Save( XclExpStream& rStrm );
};


//___________________________________________________________________

#endif

