/*************************************************************************
 *
 *  $RCSfile: XclImpHelper.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/28 16:41:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_XCLIMPHELPER_HXX
#define _SC_XCLIMPHELPER_HXX

//___________________________________________________________________

#ifndef _SC_XCLIMPSTREAM_HXX
#include "XclImpStream.hxx"
#endif


class ScTokenArray;
class ExcelToSc;


//___________________________________________________________________

class ShStrTabEntry;

class XclImpHelper
{
public:
                                // create (formatted) shared string table entry
    static ShStrTabEntry*       CreateUnicodeEntry( XclImpStream& rStrm, sal_uInt16 nChars );
    static inline ShStrTabEntry* CreateUnicodeEntry( XclImpStream& rStrm )
                                    { return CreateUnicodeEntry( rStrm, rStrm.ReaduInt16() ); }
};


//___________________________________________________________________

/** This class contains static methods to decode an URL stored in an Excel file.
    Excel URLs can contain a sheet name, for instance: path\[test.xls]Sheet1
    This sheet name will be extracted automatically. */
class XclImpURLDecoder
{
private:
                                XclImpURLDecoder();
                                XclImpURLDecoder( const XclImpURLDecoder& );
                                operator=( const XclImpURLDecoder& );

                                /** Reads an 8-bit or 16-bit character.
                                    @param  rnCharsLeft
                                    Return: Total character counter. Will be decreased automatically.
                                    @param  b16Bit
                                    sal_False = 8-bit character, sal_True = 16-bit character.
                                    @return  The read character as Unicode. */
    static inline sal_Unicode   ReadChar( XclImpStream& rStrm, sal_uInt16& rnCharsLeft, sal_Bool b16Bit );
                                /** Reads and decodes an encoded external document URL.
                                    @param  rFile
                                    Return: The decoded file name incl. path.
                                    @param  rTable
                                    Return: The decoded sheet name.
                                    @param  rbSameWb
                                    Return: sal_True = URL is a reference to the own workbook.
                                    @param  nChars
                                    Number of characters to read.
                                    @param  b16Bit
                                    Character type. sal_True = 16-bit Unicode characters. */
    static void                 DecodeURL_Impl(
                                    XclImpStream& rStrm,
                                    String& rFile,
                                    String& rTable,
                                    sal_Bool& rbSameWb,
                                    sal_uInt16 nChars,
                                    sal_Bool b16Bit );

public:
                                /** Reads and decodes an encoded external document URL.
                                    @param  rFile
                                    Return: The decoded file name incl. path.
                                    @param  rTable
                                    Return: The decoded sheet name.
                                    @param  rbSameWb
                                    Return: sal_True = URL is a reference to the own workbook.
                                    @param  nChars
                                    Number of characters to read.
                                    @param  nFlags
                                    The flags field of an Excel Unicode string. */
    static void                 DecodeURL(
                                    XclImpStream& rStrm,
                                    String& rFile,
                                    String& rTable,
                                    sal_Bool& rbSameWb,
                                    sal_uInt16 nChars,
                                    sal_uInt8 nFlags );
                                /** Reads the flags field of an Excel Unicode string and reads and decodes
                                    an encoded external document URL.
                                    @param  rFile
                                    Return: The decoded file name incl. path.
                                    @param  rTable
                                    Return: The decoded sheet name.
                                    @param  rbSameWb
                                    Return: sal_True = URL is a reference to the own workbook.
                                    @param  nChars
                                    Number of characters to read. */
    static inline void          DecodeURL(
                                    XclImpStream& rStrm,
                                    String& rFile,
                                    String& rTable,
                                    sal_Bool& rbSameWb,
                                    sal_uInt16 nChars );
                                /** Reads the length and flags field of an Excel Unicode string and
                                    reads and decodes an encoded external document URL.
                                    @param  rFile
                                    Return: The decoded file name incl. path.
                                    @param  rTable
                                    Return: The decoded sheet name.
                                    @param  rbSameWb
                                    Return: sal_True = URL is a reference to the own workbook. */
    static inline void          DecodeURL(
                                    XclImpStream& rStrm,
                                    String& rFile,
                                    String& rTable,
                                    sal_Bool& rbSameWb );

                                /** Reads the length of an Excel BYTE string (8-bit) and
                                    reads and decodes an encoded external document URL.
                                    @param  rFile
                                    Return: The decoded file name incl. path.
                                    @param  rTable
                                    Return: The decoded sheet name.
                                    @param  rbSameWb
                                    Return: sal_True = URL is a reference to the own workbook. */
    static inline void          DecodeURLByte(
                                    XclImpStream& rStrm,
                                    String& rFile,
                                    String& rTable,
                                    sal_Bool& rbSameWb );
};

inline sal_Unicode XclImpURLDecoder::ReadChar( XclImpStream& rStrm, sal_uInt16& rnCharsLeft, sal_Bool b16Bit )
{
    --rnCharsLeft;
    return b16Bit ? rStrm.ReaduInt16() : rStrm.ReaduInt8();
}

inline void XclImpURLDecoder::DecodeURL(
        XclImpStream& rStrm, String& rFile, String& rTable,
        sal_Bool& rbSameWb, sal_uInt16 nChars )
{
    DecodeURL( rStrm, rFile, rTable, rbSameWb, nChars, rStrm.ReaduInt8() );
}

inline void XclImpURLDecoder::DecodeURL(
        XclImpStream& rStrm, String& rFile, String& rTable, sal_Bool& rbSameWb )
{
    DecodeURL( rStrm, rFile, rTable, rbSameWb, rStrm.ReaduInt16() );
}

inline void XclImpURLDecoder::DecodeURLByte(
        XclImpStream& rStrm, String& rFile, String& rTable, sal_Bool& rbSameWb )
{
    DecodeURL_Impl( rStrm, rFile, rTable, rbSameWb, rStrm.ReaduInt8(), sal_False );
}



//___________________________________________________________________

/** This is a base class for import of a cached value (for instance for CRN, EXTERNNAME, ptgArray). */
class XclImpCachedValue
{
protected:
    String*                     pStr;       /// Cached value is a string.
    double                      fValue;     /// Cached value is a double.
    const ScTokenArray*         pTokArr;    /// Cached value is a formula or error code or Boolean.
    sal_uInt8                   nType;      /// The type of the cached value (EXC_CACHEDVAL_*).

public:
                                /** Creates a cached value and reads contents from stream. */
                                XclImpCachedValue( XclImpStream& rStrm, ExcelToSc& rFmlConv );
    virtual                     ~XclImpCachedValue();

    inline sal_uInt8            GetType() const     { return nType; }
    inline const String*        GetString() const   { return pStr; }
    inline double               GetValue() const    { return fValue; }
    inline const ScTokenArray*  GetTokArray() const { return pTokArr; }
};



//___________________________________________________________________

#endif

