/*************************************************************************
 *
 *  $RCSfile: ruler.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:44:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#include "ruler.hxx"

#define _SVSTDARR_STRINGS
#include <svtools/svstdarr.hxx>

#ifndef _GEN_HXX //autogen
#include <tools/gen.hxx>
#endif

#ifndef _SV_MAPMOD_HXX //autogen
#include <vcl/mapmod.hxx>
#endif

#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif


/*************************************************************************
#*	Member:		ScRuler										Datum:10.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Konstruktor der Klasse ScTableWithRuler
#*
#*  Input:		Fenster, Resource
#*
#*	Output:		---
#*
#************************************************************************/

ScRuler::ScRuler( Window* pParent, const ResId& rResId )
:Control(pParent,rResId),
		aVDev()
{
	aMousePos=Point(0,0);
	bMouseAktiv=FALSE;
	bSepAktiv=FALSE;
	nAktiveSep=-1;
	nActiveSepPos=-1;
	nOffset=0;
	nViewOffsetX=0;
	nScaleFactor=10;
	nSmallScaleFactor=5;

	if ( IsBackground() )
		aVDev.SetBackground( GetBackground() );
	else
		aVDev.SetBackground();
	SetBackground();

	InitScRuler();
}

/*************************************************************************
#*	Member:		ScRuler										Datum:10.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Konstruktor der Klasse ScTableWithRuler
#*
#*  Input:		Fenster, Style-Bits
#*
#*	Output:		---
#*
#************************************************************************/

ScRuler::ScRuler( Window* pParent, WinBits nWinStyle)
:Control(pParent,nWinStyle),
		aVDev()
{
	bMouseAktiv=FALSE;
	aMousePos=Point(0,0);
	bSepAktiv=FALSE;
	nAktiveSep=-1;
	nOffset=0;
	nViewOffsetX=0;
	nScaleFactor=10;
	nSmallScaleFactor=5;

	if ( IsBackground() )
		aVDev.SetBackground( GetBackground() );
	else
		aVDev.SetBackground();
	SetBackground();
}

/*************************************************************************
#*	Member:	~ScRuler										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Destruktor
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
ScRuler::~ScRuler()
{
	ClearSeparators();
}


/*************************************************************************
#*	Member:	InitScRuler										Datum:10.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Initialisiert das Lineal
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void ScRuler::InitScRuler()
{
	Size aPSize=GetOutputSizePixel();
	aVDev.SetOutputSizePixel(aPSize);
	String aStr('X');
	nDistance=(USHORT) GetTextWidth(aStr);
	nOffset=0;
	if(nDistance!=0)
		nMaxRulerPos=aPSize.Width()/nDistance;
}


/*************************************************************************
#*	Member:	ClearSeparators									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Loescht alle Separatoren
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScRuler::ClearSeparators()
{
   aSeparators.Remove(0,aSeparators.Count());
   Invalidate();
}

/*************************************************************************
#*	Member:		ScRuler										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Fuegt einen Separator ein.
#*
#*  Input:		Position
#*
#*	Output:		---
#*
#************************************************************************/

void ScRuler::InsertSeparator(USHORT nAt)
{
	aSeparators.Insert(nAt,aSeparators.Count());
}

/*************************************************************************
#*	Member:	RemoveSeparator									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Entfernt den Separator an der Position nAt
#*
#*  Input:		Position
#*
#*	Output:		---
#*
#************************************************************************/

void ScRuler::RemoveSeparator(USHORT nAt)
{
	if(aSeparators[nAktiveSep]==nAt) nAktiveSep=-1;
	for(int i=0;i<aSeparators.Count();i++)
	{
		if(nAt==aSeparators[i])
		{
			aSeparators.Remove(i);
			break;
		}
	}
	Invalidate();
}

/*************************************************************************
#*	Member:	SetStartPos										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Setzt die Startposition
#*
#*  Input:		neue Startposition
#*
#*	Output:		---
#*
#************************************************************************/
void ScRuler::SetStartPos(short nX)
{
	nOffset=nX;
	Invalidate();
}

/*************************************************************************
#*	Member:	GetStartPos										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Liefert die Startposition zurueck.
#*
#*  Input:		---
#*
#*	Output:		Startposition
#*
#************************************************************************/
short ScRuler::GetStartPos()
{
	return nOffset;
}

/*************************************************************************
#*	Member:		SetXViewPosOffset							Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Setzt einen Offset
#*
#*  Input:		Offset
#*
#*	Output:		---
#*
#************************************************************************/
void ScRuler::SetXViewPosOffset(USHORT nX)
{
	nViewOffsetX=nX;
	Invalidate();
}
/*************************************************************************
#*	Member:	GetMaxRulerPos()								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Liefert die maximal Position zurueck.
#*
#*  Input:		---
#*
#*	Output:		max. Pos.
#*
#************************************************************************/
short ScRuler::GetMaxRulerPos()
{
	return nMaxRulerPos;
}

/*************************************************************************
#*	Member:		ScRuler										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Setzt die maximale Position.
#*
#*  Input:		nMax
#*
#*	Output:		---
#*
#************************************************************************/
void ScRuler::SetMaxRulerPos(short nMax)
{
	nMaxRulerPos=nMax;
	Invalidate();
}

/*************************************************************************
#*	Member:	SetDistance										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Abstand zwischen den einzelnen Unterteilungen
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScRuler::SetDistance(short nD)
{
	nDistance=nD;
}

/*************************************************************************
#*	Member:		ScRuler										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Setzt den Skalierungsfaktor
#*
#*  Input:		Skalierungsfaktor
#*
#*	Output:		---
#*
#************************************************************************/
void ScRuler::SetScaleFactor(USHORT nSfactor)
{
	nScaleFactor=nSfactor;
	nSmallScaleFactor=nSfactor>>1;

	if(nScaleFactor!=nSmallScaleFactor<<1) nSmallScaleFactor=0xffff;
}

/*************************************************************************
#*	Member:	GetMinHeight									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Liefert die minimale Hoehe, die zum Zeichnen des
#*				Lineals benoetigt wird zurueck.
#*
#*  Input:		---
#*
#*	Output:		minimale Hoehe
#*
#************************************************************************/
short ScRuler::GetMinHeight()
{
	long nTextHeight = GetTextHeight();
	return (short) nTextHeight+SC_BOTTOM_DISTANCE+2;
}


/*************************************************************************
#*	Member:	MouseButtonDown									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Funktion die ausgeloest wird, wenn die Maustaste gedrueckt
#*				wird. Ermittelt ob ein Separator beruehrt wurde. Loest
#*				zusaetzlich einen installierten Handler aus.
#*
#*  Input:		MouseEvent
#*
#*	Output:		---
#*
#************************************************************************/

void ScRuler::MouseButtonDown( const MouseEvent& rMEvt)
{
	if(rMEvt.GetButtons()==MOUSE_LEFT)
	{
		CaptureMouse();
		Point aMPos=rMEvt.GetPosPixel();
		aMousePos=aMPos;
		USHORT nXPos=aMPos.X()-nViewOffsetX;
		double fXPos=nXPos;
		bMouseAktiv=TRUE;
		if(nDistance!=0)
			fXPos=((double)nXPos)/((double)nDistance)+0.5;
		nXPos=(USHORT) fXPos;
		nXPos+=nOffset;

		nAktiveSep=-1;
		nActiveSepPos=nXPos;
		for(int i=0;i<aSeparators.Count();i++)
		{
			if(aSeparators[i]==nXPos)
			{
				nAktiveSep=i;
				break;
			}
		}
		Invalidate();
		CtrMouseDown();
	}
	Control::MouseButtonDown(rMEvt);
}

/*************************************************************************
#*	Member:	MouseMove										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Funktion die ausgeloest wird, wenn die Maus bewegt
#*				wird. Ermittelt ob ein Separator beruehrt wurde und
#*				veraendert den Mauscursor. Loest zusaetzlich einen
#*				installierten Handler aus.
#*
#*  Input:		MouseEvent
#*
#*	Output:		---
#*
#************************************************************************/

void ScRuler::MouseMove( const MouseEvent& rMEvt)
{
	Point aMPos=rMEvt.GetPosPixel();
	//nMouseXPos=(USHORT)aMPos.X();
	long nXPos=aMPos.X()-nViewOffsetX;
	double fXPos=nXPos;
	if(nDistance!=0)
		fXPos=((double)nXPos)/((double)nDistance)+0.5;
	nXPos=(long) fXPos;
	aMousePos=aMPos;
	aMousePos.X()=nXPos*nDistance+nViewOffsetX;	   //@@
	nXPos+=nOffset;

	for(int i=0;i<aSeparators.Count();i++)
	{
		if(aSeparators[i]==nXPos)
		{
			SetPointer(Pointer(POINTER_HSPLIT));
			break;
		}
	}

	if(i==aSeparators.Count())
		SetPointer(Pointer(POINTER_ARROW));

	if((rMEvt.GetButtons()==MOUSE_LEFT && bMouseAktiv) || bSepAktiv)
	{
		CtrMouseMove();
	}
}


/*************************************************************************
#*	Member:	MouseButtonUp									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Funktion die ausgeloest wird, wenn die Maustaste losge-
#*				lassen wird. Wenn die Maus in einem gueltigen Bereich
#*				sich befindet, wird ein Separator eingefuegt bzw. der
#*				selektierte verschoben. Loest zusaetzlich einen
#*				installierten Handler aus.
#*
#*  Input:		MouseEvent
#*
#*	Output:		---
#*
#************************************************************************/

void ScRuler::MouseButtonUp( const MouseEvent& rMEvt)
{
	if(rMEvt.GetButtons()==MOUSE_LEFT)
	{
		ReleaseMouse();
		bMouseAktiv=FALSE;

		if(rMEvt.GetClicks()==1)
		{
			Point aMPos=rMEvt.GetPosPixel();
			USHORT nXPos=aMPos.X()-nViewOffsetX;
			double fXPos=nXPos;
			if(nDistance!=0)
				fXPos=((double)nXPos)/((double)nDistance)+0.5;
			nXPos=(USHORT) fXPos;
			nXPos+=nOffset;

			nActiveSepPos=nXPos;
			if(nAktiveSep<0)
			{
				if(nXPos<nMaxRulerPos)
				{
					aSeparators.Insert(nXPos,aSeparators.Count());
				}
			}
			Invalidate();
			CtrMouseUp();
		}
		else
			MouseDblClick(rMEvt);
	}
	Control::MouseButtonUp(rMEvt);
}

/*************************************************************************
#*	Member:	MouseDblClick									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Fuer DblClick
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScRuler::MouseDblClick( const MouseEvent& rMEvt)
{

}
/*************************************************************************
#*	Member:	GetActiveSepPos									Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Liefert die Position des aktiven Separator zurueck.
#*
#*  Input:		---
#*
#*	Output:		Position
#*
#************************************************************************/

short ScRuler::GetActiveSepPos()
{
	return nActiveSepPos;
}

/*************************************************************************
#*	Member:		GetActiveSep								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Liefert den aktiven Separator zurueck.
#*
#*
#*
#*  Input:		---
#*
#*	Output:		Separator
#*
#************************************************************************/

USHORT ScRuler::GetActiveSep()
{
	return nAktiveSep;
}

/*************************************************************************
#*	Member:	IsActiveNew										Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Ueberprueft ob der aktive Separator neu ist.
#*
#*
#*
#*  Input:		---
#*
#*	Output:		Flag
#*
#************************************************************************/

BOOL ScRuler::IsActiveNew()
{
	return (nAktiveSep<0);
}




/*************************************************************************
#*	Member:		DrawMyPoint									Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Zeichnet einen Punkt mit dem Radius PoiSize und
#*				der Farbe col, an der Position aPos
#*
#*  Input:		Position, Groesse, Farbe
#*
#*	Output:		---
#*
#************************************************************************/

void ScRuler::DrawMyPoint(Point aPos,short PoiSize,ColorData col)
{
	BOOL bHadFill = IsFillColor();
	Color aOldFill = GetFillColor();

	PoiSize=PoiSize>>1;
	Color aColor(col);
	SetFillColor(aColor);
	Rectangle aRect(aPos.X()-PoiSize,aPos.Y()-PoiSize,
						aPos.X()+PoiSize,aPos.Y()+PoiSize);
	DrawEllipse(aRect);

	if (bHadFill)
		SetFillColor(aOldFill);
	else
		SetFillColor();
}


/*************************************************************************
#*	Member:	Paint											Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Zeichnet den Control neu.
#*
#*
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void ScRuler::Paint( const Rectangle& rRect )
{
	Size aDevSize=aVDev.GetOutputSizePixel();
	USHORT aDevBottom=aDevSize.Height()-SC_BOTTOM_DISTANCE+1;

	aVDev.Erase();
	aVDev.SetFont(GetFont());
	DrawDivisionScale();
	Point aPos(0,0);
	Point a2Pos(0,0);
	DrawBitmap(aPos,
		aVDev.GetBitmap(aPos,aVDev.GetOutputSizePixel()));

	aPos.X()+=nViewOffsetX;
	aDevSize.Width()-=nViewOffsetX;
	SetClipRegion(Region(Rectangle(aPos,aDevSize)));

	aPos.Y()=aDevBottom-1;
	a2Pos.Y()=aDevSize.Height();

	for(int i=0;i<aSeparators.Count();i++)
	{
		aPos.X()=(aSeparators[i]-nOffset)*nDistance+nViewOffsetX;
		a2Pos.X()=aPos.X();
		DrawLine(a2Pos,aPos);
		DrawMyPoint(aPos,5,COL_BLUE);

	}
	SetClipRegion();
}

/*************************************************************************
#*	Member:	DrawDivisionScale								Datum:10.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Zeichnet die Skala
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void ScRuler::DrawDivisionScale()
{
	Size aDevSize=aVDev.GetOutputSizePixel();
	USHORT aDevBottom=aDevSize.Height()-SC_BOTTOM_DISTANCE+1;
	Point aP1;
	Point aP2;

	aP1.X()=nViewOffsetX;
	aP1.Y()=aDevBottom;
	aP2.X()=aDevSize.Width();
	aP2.Y()=aDevBottom;
	aVDev.SetLineColor(Color(COL_WHITE));
	aVDev.DrawLine(aP1,aP2);

	aDevBottom--;
	aP1.Y()=aDevBottom;
	aP2.Y()=aDevBottom;
	aVDev.SetLineColor(Color(COL_BLACK));
	aVDev.DrawLine(aP1,aP2);

	aP2.X()=aDevSize.Width();
	aP2.Y()=aDevBottom;

	aP1.X()=nViewOffsetX;
	aP1.Y()=aDevBottom;

	aP2.X()=nViewOffsetX;
	aP2.Y()=aDevBottom;


	for(int x=nOffset;x<=nMaxRulerPos;x++)
	{
		aP1.X()=(x-nOffset)*nDistance+nViewOffsetX;
		aP2.X()=aP1.X();

		if((x % nSmallScaleFactor)==0)
		{
			if((x % nScaleFactor)==0)
			{
				aP1.Y()=aDevBottom-4;
				aVDev.DrawLine(aP1,aP2);
				aP1.X()+=1;
				aP2.X()+=1;
				aVDev.DrawLine(aP1,aP2);
				if(x !=0 ) DrawScaleText( aP1, String::CreateFromInt32( x ) );
			}
			else
			{
				aP1.Y()=aDevBottom-3;
				aVDev.DrawLine(aP1,aP2);
			}
		}
		else
		{
			aP1.Y()=aDevBottom-1;
			aVDev.DrawLine(aP1,aP2);
		}
	}
}

/*************************************************************************
#*	Member:	DrawScaleText									Datum:10.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Zeichnet den Text fuer die Scala
#*
#*  Input:		Position, Text
#*
#*	Output:		---
#*
#************************************************************************/

void ScRuler::DrawScaleText(Point aPoint, String aString)
{
	Size aTextSize( aVDev.GetTextWidth(aString), aVDev.GetTextHeight() );
	aPoint.X()-=aTextSize.Width()>>1;
	aPoint.Y()-=aTextSize.Height()+1;
	aVDev.DrawText(aPoint,aString);
}

/*************************************************************************
#*	Member:	GetMousePos										Datum:10.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Liefert die Mausposition zurueck.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
Point ScRuler::GetMousePos()
{
	return aMousePos;
}


/*************************************************************************
#*	Member:	CtrMouseUp										Datum:11.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				die Maus losgelassen wurde.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScRuler::CtrMouseUp()
{
	aMouseUpLink.Call( this );
}

/*************************************************************************
#*	Member:	CtrMouseMove									Datum:11.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				die Maus bewegt wird.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScRuler::CtrMouseMove()
{
	aMouseMoveLink.Call( this );
}

/*************************************************************************
#*	Member:	CtrMouseDown									Datum:11.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScRuler
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				die Maus gedrueckt wird.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScRuler::CtrMouseDown()
{
	aMouseDownLink.Call( this );
}

void ScRuler::ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground )
{
	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();

	if ( bFont )
	{
		Font aFont = rStyleSettings.GetAppFont();
		if ( IsControlFont() )
			aFont.Merge( GetControlFont() );
		SetFont( aFont );
	}

	if ( bFont || bForeground )
	{
		Color aTextColor = rStyleSettings.GetButtonTextColor();
		if ( IsControlForeground() )
			aTextColor = GetControlForeground();
		SetTextColor( aTextColor );
		aVDev.SetTextColor( aTextColor );
	}

	if ( bBackground )
	{
		SetBackground( rStyleSettings.GetFaceColor() );
	}

	if ( IsBackground() )
	{
		SetFillColor( GetBackground().GetColor() );
		aVDev.SetBackground( GetBackground() );
	}
	else
	{
		SetFillColor();
		aVDev.SetBackground();
	}
	SetBackground();

	Invalidate();
}

// -----------------------------------------------------------------------

void ScRuler::StateChanged( StateChangedType nType )
{
	if ( (nType == STATE_CHANGE_ZOOM) ||
		 (nType == STATE_CHANGE_CONTROLFONT) )
	{
		ImplInitSettings( TRUE, FALSE, FALSE );
		Invalidate();
	}
	if ( nType == STATE_CHANGE_CONTROLFOREGROUND )
	{
		ImplInitSettings( FALSE, TRUE, FALSE );
		Invalidate();
	}
	else if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
	{
		ImplInitSettings( FALSE, FALSE, TRUE );
		Invalidate();
	}

	Control::StateChanged( nType );
}

// -----------------------------------------------------------------------

void ScRuler::DataChanged( const DataChangedEvent& rDCEvt )
{
	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
		 (rDCEvt.GetFlags() & SETTINGS_STYLE) )
	{
		ImplInitSettings( TRUE, TRUE, TRUE );
		Invalidate();
	}
	else
		Window::DataChanged( rDCEvt );
}


