/*************************************************************************
 *
 *  $RCSfile: datagrid.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dr $ $Date: 2001/05/30 13:33:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_DATAGRID_HXX
#define _SC_DATAGRID_HXX

#ifndef _WINDOW_HXX
#include <vcl/window.hxx>
#endif

#ifndef _COLOR_HXX
#include <vcl/color.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SV_CTRL_HXX //autogen
#include <vcl/ctrl.hxx>
#endif

#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>

#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif

#ifndef SC_POPMENU_HXX
#include "popmenu.hxx"
#endif

class ScEditEngineDefaulter;

class SvStrings;

typedef SvStrings * ScStringsPtr;

SV_DECL_PTRARR(ScStringsArray,ScStringsPtr,1,1);

class ScDataGrid : public Control
{
private:

	Link				aMouseUpLink;
	Link				aMouseMoveLink;
	Link				aMouseDownLink;
	Link				aContextMenuLink;

	ScPopupMenu			aContextMenu;
	long				nContextSelPos;
	String				aSelectedContextText;

	Pair				aSelectedCell;
	long				nSelectedCol;
	long				nSelectedRow;
	BOOL				bMouseAktiv;

	USHORT				nStdHeight;
	USHORT				nStdWidth;
	USHORT				nMouseXPos;

	USHORT				nNumberOfRows;
	USHORT				nNumberOfCols;
	SvUShorts			aWidthOfCols;
	SvUShorts			aHeightOfRows;
	ScStringsArray		aScStringsArray;

	Point				aTopWinPos;
	Point				aLeftWinPos;
	Point				aDataWinPos;
	Point				aOffsetPoint;

	Size				aTopWinSize;
	Size				aLeftWinSize;
	Size				aDataWinSize;

	VirtualDevice		aTopWinDev;
	VirtualDevice		aLeftWinDev;
	VirtualDevice		aDataWinDev;

	Font				aDefaultFont;
	ScEditEngineDefaulter* pEditEngine;

	void		CtrMouseUp();
	void		CtrMouseMove();
	void		CtrMouseDown();
	void		CtrCommand();
	void		ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground );
	void		Construct();

protected:

	virtual	void Paint( const Rectangle& rRect );
	virtual void MouseButtonUp( const MouseEvent& rMEvt);
	virtual void MouseMove( const MouseEvent& rMEvt);
	virtual void MouseButtonDown( const MouseEvent& rMEvt);
	virtual void MouseDblClick( const MouseEvent& rMEvt);
	virtual void Command( const CommandEvent& rCEvt );

	void		ActionForButtonDown( Point aMPos);
	void		DrawTop();
	void		DrawLeft();
    void        DrawData();

public:

	ScDataGrid( Window* pParent, const ResId& rResId );
	ScDataGrid( Window* pParent, WinBits nWinStyle = 0 );
	~ScDataGrid();

	void		SetLatinFont( const Font& rFont );

	void		InsertRow(USHORT nAt,USHORT nNum=1);
	void		InsertCol(USHORT nAt,USHORT nNum=1);
	void		DeleteRow(USHORT nAt,USHORT nNum=1);
	void		DeleteCol(USHORT nAt,USHORT nNum=1);
	void		UpdateArray(USHORT Rows,USHORT Cols);
	void		ClearTable();

	void		SetXTablePos(short nX);
	void		SetYTablePos(short nY);
	short		GetXTablePos();
	short		GetYTablePos();
	short		GetXMaxTableSize();
	short		GetYMaxTableSize();

	void		SetWidthOfCol(USHORT nCol, USHORT nWidth);
	void		SetWidthOfAllCols(USHORT nWidth);
	void		SetStdWidth(USHORT);
	USHORT		GetWidthOfCol(USHORT nCol);

	USHORT		GetNumberOfCols();
	USHORT		GetNumberOfRows();

	Pair		GetSelectedCell();			//Pair.A() -> Row
	void		SetSelectedCell(Pair);		//Pair.B() -> Col
	long		GetSelectedRow();
	void		SetSelectedRow(long);
	long		GetSelectedCol();
	void		SetSelectedCol(long);
	Pair		GetFirstVisibleCell();

	void		SetHeightOfRow(USHORT nRow, USHORT nHeight);
	void		SetHeightOfAllRows(USHORT nHeight);
	void		SetStdHeight(USHORT);
	USHORT		GetHeightOfRow(USHORT nCol);

	void		SetDataAtRowCol(USHORT,USHORT,String);
	String		GetDataAtRowCol(USHORT,USHORT);


	void		InsertContextEntry(USHORT nItemId, const String& rStr,
								MenuItemBits nItemBits = 0,
								USHORT nPos = MENU_APPEND );

	long		GetSelectedContextCmd();
	String		GetSelectedContextText();

	void            SetMouseUpHdl( const Link& rLink ) { aMouseUpLink = rLink; }
	const Link&     GetMouseUpLink() const { return aMouseUpLink; }
	void            SetMouseMoveHdl( const Link& rLink ) { aMouseMoveLink= rLink; }
	const Link&     GetMouseMoveLink() const { return aMouseMoveLink; }
	void            SetMouseDownHdl( const Link& rLink ) { aMouseDownLink= rLink; }
	const Link&     GetMouseDownLink() const { return aMouseDownLink; }
	void            SetContextMenuHdl( const Link& rLink ) { aContextMenuLink= rLink; }
	const Link&     GetContextMenuLink() const { return aContextMenuLink; }

	virtual	void StateChanged( StateChangedType nType );
	virtual	void DataChanged( const DataChangedEvent& rDCEvt );


};

#endif


