/*************************************************************************
 *
 *  $RCSfile: tabrul.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:45:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_TABRUL_HXX
#define _SC_TABRUL_HXX

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/imagebtn.hxx>
#endif

#include "ruler.hxx"
#include "datagrid.hxx"

class ScTableWithRuler : public Control
{
private:

	Link		aSelectionLink;
	Link		aModifyColLink;
	PushButton	aPButton;
	ScDataGrid  aPrivatDataGrid;
	ScRuler		aPrivatRuler;
	USHORT		nMousePos;
	String		DelColType;
	long		nDelCol;

protected:

	DECL_LINK( SepRulerHdl, void * );
	DECL_LINK( SepRulerMovHdl, void * );
	DECL_LINK( SepRulerDownHdl, void * );
	DECL_LINK( ContextMenuHdl, ScDataGrid * );
	DECL_LINK( ButtonHdl, PushButton * );





	void		UpdateOutput();
	void		CtrSelection();
	void		CtrModifyCol();

public:

	ScTableWithRuler( Window* pParent, const ResId& rResId );
	~ScTableWithRuler();

	void		InsertRow(USHORT nAt,USHORT nNum=1);
	void		InsertCol(USHORT nAt,USHORT nNum=1);
	void		DeleteRow(USHORT nAt,USHORT nNum=1);
	void		DeleteCol(USHORT nAt,USHORT nNum=1);
	void		UpdateArray(USHORT Rows,USHORT Cols);
	void		ClearTable();

	void		SetXTablePos(short nX);
	void		SetYTablePos(short nY);
	short		GetXTablePos();
	short		GetYTablePos();
	short		GetXMaxTableSize();
	short		GetYMaxTableSize();

	USHORT		GetXMaxVisChars();
	USHORT		GetYMaxVisChars();

	USHORT		GetNumberOfCols();

	void		SetFont( const Font& rNewFont );
	void		RulerEnabled(BOOL bFlag=TRUE);

	long		GetSelectedCol();
	void		SetSelectedCol(long);

	void		SetNumOfCharsForCol(USHORT nCol,xub_StrLen nCount);
	xub_StrLen	GetNumOfCharsForCol(USHORT nCol);

	void		SetDataAtRowCol(USHORT,USHORT,String);
	String		GetDataAtRowCol(USHORT,USHORT);

	void		InsertContextEntry(USHORT nItemId, const String& rStr,
								MenuItemBits nItemBits = 0,
								USHORT nPos = MENU_APPEND );

	void            SetSelectionHdl( const Link& rLink ) { aSelectionLink= rLink; }
	const Link&     GetSelectionLink() const { return aSelectionLink; }

	void            SetModifyColHdl( const Link& rLink ) { aModifyColLink= rLink; }
	const Link&     GetModifyColLink() const { return aModifyColLink; }


};

#endif


