/*************************************************************************
 *
 *  $RCSfile: printopt.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:45:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#ifndef PCH
#include <sv.hxx>
#include <sbx.hxx>
#include <sfxitems.hxx>
#include <segmentc.hxx>
#endif

#include "sc.hrc" // -> SCSTR_UNDEFINED

#include "printopt.hxx"
#include "printopt.hrc"

SEG_EOFGLOBALS()

//========================================================================
#pragma SEG_FUNCDEF(printopt_01)

ScPrintOptionsPage::ScPrintOptionsPage( Window* 			pParent,
										const SfxItemSet&	rCoreAttrs	) :
		SfxTabPage		( pParent,
						  ResId( RID_SCPAGE_PRINTOPTIONS ),
						  rCoreAttrs ),
		//
		aEdRepeatRow	( this, ResId( ED_REPEAT_ROW ) ),
		aEdRepeatCol	( this, ResId( ED_REPEAT_COL ) ),
		aFtRepeatRow	( this, ResId( FT_REPEAT_ROW ) ),
		aFtRepeatCol	( this, ResId( FT_REPEAT_COL ) ),
		//
		aEdScale		( this, ResId( ED_SCALE ) ),
		aFtScale		( this, ResId( FT_SCALE ) ),
		//
		aBtnHeader		( this, ResId( BTN_HEADER ) ),
		aBtnGrid		( this, ResId( BTN_GRID ) ),
		aBtnObjects 	( this, ResId( BTN_OBJECTS ) ),
		aBtnDiagrams	( this, ResId( BTN_DIAGRAMS ) ),
		aGbPrint		( this, ResId( GB_PRINT ) ),
		//
		aBtnTopDown 	( this, ResId( BTN_TOPDOWN ) ),
		aBtnLeftRight	( this, ResId( BTN_LEFTRIGHT ) ),
		aGbNumbering	( this, ResId( GB_NUMBERING ) ),
		//
		aBtnTable		( this, ResId( BTN_PAGES_TABLE ) ),
		aBtnFolder		( this, ResId( BTN_PAGES_FOLDER ) ),
		aBtnArea		( this, ResId( BTN_PAGES_AREA ) ),
		aLbArea 		( this, ResId( LB_PAGES_AREA ) ),
		aGbPages		( this, ResId( GB_PAGES ) ),
		//
		aBtnNotesNone	( this, ResId( BTN_NOTES_NONE ) ),
		aBtnNotesDocEnd ( this, ResId( BTN_NOTES_DOCEND ) ),
		aBtnNotesOnly	( this, ResId( BTN_NOTES_ONLY ) ),
		aBtnNotesPageEnd( this, ResId( BTN_NOTES_PAGEEND ) ),
		aGbNotes		( this, ResId( GB_NOTES ) )
{
	Init();
	FreeResource();
}

//------------------------------------------------------------------------
#pragma SEG_FUNCDEF(printopt_07)

__EXPORT ScPrintOptionsPage::~ScPrintOptionsPage()
{
}

//------------------------------------------------------------------------
#pragma SEG_FUNCDEF(printopt_02)

void ScPrintOptionsPage::Init()
{
	aBtnTable. SetClickHdl( LINK( this, ScPrintOptionsPage, AreaClickHdl) );
	aBtnFolder.SetClickHdl( LINK( this, ScPrintOptionsPage, AreaClickHdl) );
	aBtnArea.  SetClickHdl( LINK( this, ScPrintOptionsPage, AreaClickHdl) );

	// Dummy:
	aBtnTable.Check();
	aLbArea.Disable();
	aLbArea.Clear();
	aLbArea.InsertEntry( String( ResId( SCSTR_UNDEFINED ) ) );
	aLbArea.SelectEntryPos( 0 );
	aBtnDiagrams.Check();
	aBtnNotesNone.Check();
	aBtnLeftRight.Check();
	aEdScale.SetValue( 100 );
}

//------------------------------------------------------------------------
#pragma SEG_FUNCDEF(printopt_03)

SfxTabPage* __EXPORT ScPrintOptionsPage::Create( Window*			 pParent,
										const SfxItemSet&	rAttrSet )
{
	return ( new ScPrintOptionsPage( pParent, rAttrSet ) );
}

//------------------------------------------------------------------------
#pragma SEG_FUNCDEF(printopt_04)

BOOL ScPrintOptionsPage::FillItemSet( SfxItemSet& rCoreAttrs )
{
	return ( TRUE );
}

//------------------------------------------------------------------------
#pragma SEG_FUNCDEF(printopt_05)

void ScPrintOptionsPage::Reset( const SfxItemSet& )
{
}

//------------------------------------------------------------------------
// Handler
#pragma SEG_FUNCDEF(printopt_06)

long __EXPORT ScPrintOptionsPage::AreaClickHdl( RadioButton* pBtn )
{
	if (   (pBtn == &aBtnTable)
		|| (pBtn == &aBtnFolder)
		|| (pBtn == &aBtnArea) )
	{
		if ( aBtnArea.IsChecked() )
			aLbArea.Enable();
		else
			aLbArea.Disable();
	}

	return 0;
}

/*------------------------------------------------------------------------

	$Log: printopt.cxx,v $
	Revision 1.1.1.1  2000/09/18 16:45:03  hr
	initial import
	
	Revision 1.17  2000/09/17 14:09:14  willem.vandorp
	OpenOffice header added.
	
	Revision 1.16  2000/08/31 16:38:36  willem.vandorp
	Header and footer replaced
	
	Revision 1.15  1995/11/08 10:07:52  NN
	Change -> Set (301)
	

	  Rev 1.14   08 Nov 1995 11:07:52   NN
   Change -> Set (301)

	  Rev 1.13   30 Jun 1995 17:57:24   HJS
   exports fuer create

	  Rev 1.12	 04 Mar 1995 14:25:38	MO
   * String aus der Resource lesen
   -

	  Rev 1.11	 30 Jan 1995 12:34:04	TRI
   sbx.hxx include eingebaut

	  Rev 1.10	 29 Jan 1995 12:59:34	MO
   Dtor implementiert

	  Rev 1.9	22 Jan 1995 15:11:18   SC
   2.37 Anpassung

	  Rev 1.8	19 Jan 1995 16:07:02   TRI
   __EXPORT vor verschiedene LinkHandler gesetzt

	  Rev 1.7	18 Jan 1995 14:39:08   TRI
   Pragmas zur Segementierung eingebaut

	  Rev 1.6	11 Jan 1995 19:33:52   TRI
   Pragmas zur Segmentierung eingebaut

	  Rev 1.5	14 Dec 1994 13:34:02   MO
   ID-Namen geaendert

	  Rev 1.4	07 Dec 1994 17:17:44   MO
   Neues Design mit Wiederholungszeilen/-spalten etc.

------------------------------------------------------------------------*/

#pragma SEG_EOFMODULE

