@echo off
REM *****************************************************************
REM * LOCKED
REM * (c) Copyright 1992-1994 STAR DIVISION
REM * Beschreibung: Kopiert StarView-Projekte auf lokales Laufwerk,
REM *               abhaengig von gesetzter Umgebung
REM * Aufruf:       copyloc X: [VERSION]
REM * X             X == lokales Laufwerk bzw. Ziel
REM * VERSION       Bei Angabe von Version wird nur das entsprechende
REM *               Output-Verzeichnis kopiert
REM *****************************************************************

set PRJNAME=SD

IF "%GUI%"     == "" GOTO ErrorNoVer
IF "%COM%"     == "" GOTO ErrorNoVer
IF "%GUIBASE%" == "" GOTO ErrorNoVer
IF "%1"        == "" GOTO ErrorNoDest

set DEST=%1
IF EXIST %DEST%\NUL GOTO ParamOk
set DEST=%1:
IF EXIST %DEST%\NUL GOTO ParamOk
goto ErrorWrongDest
:ParamOk

set DEST=%DEST%\%PRJNAME%

IF NOT EXIST %DEST%\NUL md %DEST%

IF NOT "%2"    == "" GOTO CopyVer

IF NOT EXIST ..\inc\NUL GOTO NoInc
echo Kopiere ..\inc nach %DEST%\inc
md %DEST%\inc
xcopy ..\inc %DEST%\inc /e /s >NUL
IF NOT EXIST ..\res\NUL GOTO NoInc
echo Kopiere ..\res nach %DEST%\res
md %DEST%\res
xcopy ..\res %DEST%\res /e /s >NUL
:NoInc

IF NOT EXIST ..\source\NUL GOTO NoSource
echo Kopiere ..\source nach %DEST%\source
md %DEST%\source
xcopy ..\source %DEST%\source /e /s >NUL
:NoSource

IF NOT EXIST ..\%GUIBASE%\NUL GOTO NoGuiBase
echo Kopiere ..\%GUIBASE% nach %DEST%\%GUIBASE%
md %DEST%\%GUIBASE%
xcopy ..\%GUIBASE% %DEST%\%GUIBASE% /e /s >NUL
:NoGuiBase

IF NOT EXIST ..\util\NUL GOTO NoUtil
echo Kopiere ..\util nach %DEST%\util
md %DEST%\util
xcopy ..\util %DEST%\util /e /s >NUL
:NoUtil

IF NOT EXIST ..\workben\NUL GOTO NoWorkben
echo Kopiere ..\workben nach %DEST%\workben
md %DEST%\workben
xcopy ..\workben %DEST%\workben /e /s >NUL
:NoWorkben

IF NOT EXIST ..\prj\NUL GOTO NoPrj
echo Kopiere ..\prj nach %DEST%\prj
md %DEST%\prj
xcopy ..\prj %DEST%\prj /e /s >NUL
:NoPrj

echo Kopiere ..\%GUI%%COM%%CPU%%COMEX% nach %DEST%\%GUI%%COM%%CPU%%COMEX%
md %DEST%\%GUI%%COM%%CPU%%COMEX%
xcopy ..\%GUI%%COM%%CPU%%COMEX% %DEST%\%GUI%%COM%%CPU%%COMEX% /e /s >NUL

goto End

:CopyVer
IF NOT EXIST %DEST%\NUL GOTO ErrorWrongDest
IF NOT exist ..\%2\NUL GOTO ErrorFalseVer
echo Kopiere ..\%2 nach %DEST%\%2
md %DEST%\%2
xcopy ..\%2 %DEST%\%2 /e /s >NUL

goto End

:ErrorNoVer
echo Error: Keine Systemversion gesetzt !
goto End

:ErrorNoDest
echo Error : Kein Ziellaufwerk uebergeben !
echo Aufruf: COPYLOC X: oder COPYLOC X
goto End

:ErrorWrongDest
echo Error : Ziellaufwerk nicht vorhanden !
echo Aufruf: COPYLOC X: oder COPYLOC X
goto End

:ErrorFalseVersion
echo Error: Version %2 existiert nicht !
goto End

:End
set PRJNAME=
set DEST=
echo on
