/*************************************************************************
 *
 *  $RCSfile: objid.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: aw $ $Date: 2000/10/30 11:55:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include "objid.hxx"
#include "glob.hxx"

#include "defines.hxx"


/*************************************************************************
|*
|* Objekt-Id ermitteln;
|* Liefert -1, wenn das Objekt keine Id hat
|*
\************************************************************************/

SchObjectId* GetObjectId(const SdrObject& rObj)
{
	for (USHORT i = 0; i < rObj.GetUserDataCount(); i++)
	{
		SdrObjUserData *pData = rObj.GetUserData(i);
		if (pData && pData->GetId() == SCH_OBJECTID_ID)
			return (SchObjectId*)pData;
	}

	return NULL;
}

/*************************************************************************
|*
|* Objekt mit Id suchen;
|* liefert NULL, wenn kein Objekt gefunden wurde.
|*
\************************************************************************/

SdrObject* GetObjWithId(UINT16 nObjId, const SdrObjList& rObjList,
						ULONG* pIndex, SdrIterMode eMode)
{
	ULONG nIndex = 0;

	SdrObjListIter aIterator(rObjList, eMode);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pObjId = GetObjectId(*pObj);
		if (pObjId && pObjId->GetObjId() == nObjId)
		{
			if (pIndex)
				*pIndex = nIndex;
			return pObj;
		}

		nIndex++;
	}

	return NULL;
}
/*************************************************************************
|*
|* Alle Objekt mit Id=nObjId Attributieren,
|*
\************************************************************************/
void SetAttrWithId(UINT16 nObjId, const SdrObjList& rObjList,
						const SfxItemSet& rAttr, SdrIterMode eMode)
{
	ULONG nIndex = 0;

	SdrObjListIter aIterator(rObjList, eMode);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pObjId = GetObjectId(*pObj);
		if (pObjId && pObjId->GetObjId() == nObjId)
		{

//-/			pObj->NbcSetAttributes(rAttr,FALSE);
			pObj->SetItemSet(rAttr);

		}
		nIndex++;
	}
}
/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchObjectId::SchObjectId() :
	SdrObjUserData(SchInventor, SCH_OBJECTID_ID, 0),
	nObjId(0)
{
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchObjectId::SchObjectId(UINT16 nId) :
	SdrObjUserData(SchInventor, SCH_OBJECTID_ID, 0),
	nObjId(nId)
{
}

/*************************************************************************
|*
|* Kopier-Konstruktor
|*
\************************************************************************/

SchObjectId::SchObjectId(const SchObjectId& rObjectId) :
	SdrObjUserData(rObjectId),
	nObjId(rObjectId.nObjId)
{
}

/*************************************************************************
|*
|* Kopie erzeugen
|*
\************************************************************************/

SdrObjUserData* SchObjectId::Clone(SdrObject *pObj) const
{
	return new SchObjectId(*this);
}

/*************************************************************************
|*
|* Daten in Stream schreiben
|*
\************************************************************************/

void SchObjectId::WriteData(SvStream& rOut)
{
	SdrObjUserData::WriteData(rOut);

	rOut << nObjId;
}


/*************************************************************************
|*
|* Daten aus Stream lesen
|*
\************************************************************************/

void SchObjectId::ReadData(SvStream& rIn)
{
	SdrObjUserData::ReadData(rIn);

	rIn >> nObjId;
}

#ifdef DBG_UTIL

// this function is for debugging only
// therefore it is ok to use char* instead of UniString
char* GetCHOBJIDName( const long id )
{
	switch( id )
	{
		case CHOBJID_ANY:						return "CHOBJID_ANY";
		case CHOBJID_TEXT:						return "CHOBJID_TEXT";
		case CHOBJID_AREA:						return "CHOBJID_AREA";
		case CHOBJID_LINE:						return "CHOBJID_LINE";
		case CHOBJID_DIAGRAM_AREA:				return "CHOBJID_DIAGRAM_AREA";
		case CHOBJID_TITLE_MAIN:				return "CHOBJID_TITLE_MAIN";
		case CHOBJID_TITLE_SUB:					return "CHOBJID_TITLE_SUB";
		case CHOBJID_DIAGRAM:					return "CHOBJID_DIAGRAM";
		case CHOBJID_DIAGRAM_WALL:				return "CHOBJID_DIAGRAM_WALL";
		case CHOBJID_DIAGRAM_FLOOR:				return "CHOBJID_DIAGRAM_FLOOR";
		case CHOBJID_DIAGRAM_TITLE_X_AXIS:		return "CHOBJID_DIAGRAM_TITLE_X_AXIS";
		case CHOBJID_DIAGRAM_TITLE_Y_AXIS:		return "CHOBJID_DIAGRAM_TITLE_Y_AXIS";
		case CHOBJID_DIAGRAM_TITLE_Z_AXIS:		return "CHOBJID_DIAGRAM_TITLE_Z_AXIS";
		case CHOBJID_DIAGRAM_X_AXIS:			return "CHOBJID_DIAGRAM_X_AXIS";
		case CHOBJID_DIAGRAM_Y_AXIS:			return "CHOBJID_DIAGRAM_Y_AXIS";
		case CHOBJID_DIAGRAM_Z_AXIS:			return "CHOBJID_DIAGRAM_Z_AXIS";
		case CHOBJID_DIAGRAM_A_AXIS:			return "CHOBJID_DIAGRAM_A_AXIS";
		case CHOBJID_DIAGRAM_B_AXIS:			return "CHOBJID_DIAGRAM_B_AXIS";
		case CHOBJID_DIAGRAM_C_AXIS:			return "CHOBJID_DIAGRAM_C_AXIS";
		case CHOBJID_DIAGRAM_X_GRID_MAIN:		return "CHOBJID_DIAGRAM_X_GRID_MAIN";
		case CHOBJID_DIAGRAM_Y_GRID_MAIN:		return "CHOBJID_DIAGRAM_Y_GRID_MAIN";
		case CHOBJID_DIAGRAM_Z_GRID_MAIN:		return "CHOBJID_DIAGRAM_Z_GRID_MAIN";
		case CHOBJID_DIAGRAM_Y_GRID_HELP:		return "CHOBJID_DIAGRAM_Y_GRID_HELP";
		case CHOBJID_DIAGRAM_Z_GRID_HELP:		return "CHOBJID_DIAGRAM_Z_GRID_HELP";
		case CHOBJID_DIAGRAM_ROWGROUP:			return "CHOBJID_DIAGRAM_ROWGROUP";
		case CHOBJID_DIAGRAM_ROWS:				return "CHOBJID_DIAGRAM_ROWS";
		case CHOBJID_DIAGRAM_ROWSLINE:			return "CHOBJID_DIAGRAM_ROWSLINE";
		case CHOBJID_DIAGRAM_DATA:				return "CHOBJID_DIAGRAM_DATA";
		case CHOBJID_DIAGRAM_DESCRGROUP:		return "CHOBJID_DIAGRAM_DESCRGROUP";
		case CHOBJID_DIAGRAM_DESCR_ROW:			return "CHOBJID_DIAGRAM_DESCR_ROW";
		case CHOBJID_DIAGRAM_DESCR_COL:			return "CHOBJID_DIAGRAM_DESCR_COL";
		case CHOBJID_DIAGRAM_DESCR_SYMBOL:		return "CHOBJID_DIAGRAM_DESCR_SYMBOL";
		case CHOBJID_LEGEND:					return "CHOBJID_LEGEND";
		case CHOBJID_LEGEND_BACK:				return "CHOBJID_LEGEND_BACK";
		case CHOBJID_LEGEND_SYMBOL_ROW:			return "CHOBJID_LEGEND_SYMBOL_ROW";
		case CHOBJID_LEGEND_SYMBOL_COL:			return "CHOBJID_LEGEND_SYMBOL_COL";
		case CHOBJID_DIAGRAM_Z_AXIS_GROUP:		return "CHOBJID_DIAGRAM_Z_AXIS_GROUP";
		case CHOBJID_DIAGRAM_NET:				return "CHOBJID_DIAGRAM_NET";
		case CHOBJID_DIAGRAM_AVERAGEVALUE:		return "CHOBJID_DIAGRAM_AVERAGEVALUE";
		case CHOBJID_DIAGRAM_ERROR:				return "CHOBJID_DIAGRAM_ERROR";
		case CHOBJID_DIAGRAM_REGRESSION:		return "CHOBJID_DIAGRAM_REGRESSION";
		case CHOBJID_DIAGRAM_STACKEDGROUP:		return "CHOBJID_DIAGRAM_STACKEDGROUP";
		case CHOBJID_DIAGRAM_STATISTICS_GROUP:	return "CHOBJID_DIAGRAM_STATISTICS_GROUP";
		case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP:	return "CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP";
		case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP:	return "CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP";
		case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP:	return "CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP";
		case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP:	return "CHOBJID_DIAGRAM_X_GRID_HELP_GROUP";
		case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP:	return "CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP";
		case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP:	return "CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP";
		case CHOBJID_DIAGRAM_SPECIAL_GROUP:		return "CHOBJID_DIAGRAM_SPECIAL_GROUP";
		case CHOBJID_DIAGRAM_STOCKLINE_GROUP:	return "CHOBJID_DIAGRAM_STOCKLINE_GROUP";
		case CHOBJID_DIAGRAM_STOCKLOSS_GROUP:	return "CHOBJID_DIAGRAM_STOCKLOSS_GROUP";
		case CHOBJID_DIAGRAM_STOCKPLUS_GROUP:	return "CHOBJID_DIAGRAM_STOCKPLUS_GROUP";

		default:
			return "unknown Id";
	}
}

#endif	// DBG_UTIL



