/*************************************************************************
 *
 *  $RCSfile: datstat.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: af $ $Date: 2001/05/21 10:58:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include <sot/factory.hxx>
#include "schattr.hxx"
#define ITEMID_DOUBLE           0
#define ITEMID_CHARTKINDERROR   SCHATTR_STAT_KIND_ERROR
#define ITEMID_CHARTINDICATE    SCHATTR_STAT_INDICATE
#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif

#include "schresid.hxx"
#include "chtmodel.hxx"
#include "datstat.hxx"
#include "datstat.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"



enum StatIndicator
{
	INDICATE_NONE,
	INDICATE_BOTH,
	INDICATE_UP,
	INDICATE_DOWN
};

enum StatRegression
{
	REGRESSION_NONE,
	REGRESSION_LINE,
	REGRESSION_LOG,
	REGRESSION_EXP,
	REGRESSION_POW
};

/*************************************************************************
|*
|* Dialog fuer die Statistikfunktionen
|*
\************************************************************************/

SchDataStatisticsDlg::SchDataStatisticsDlg(Window           *pWindow,
										   const SfxItemSet &rMyAttrs) :
	ModalDialog(pWindow, SchResId(DLG_DATA_STAT)),
	aRbtNone (this, ResId (RBT_NONE)),
	aRbtVariant (this, ResId (RBT_VARIANT)),
	aRbtSigma (this, ResId (RBT_SIGMA)),
	aRbtPercent (this, ResId (RBT_PERCENT)),
	aRbtBigError (this, ResId (RBT_BIGERROR)),
	aRbtConst (this, ResId (RBT_CONST)),
	aCbxAverage (this, ResId (CBX_AVERAGE)),
	aFlDescr (this, ResId (FL_ERROR)),
	aBtnOK (this, ResId (BTN_OK)),
	aBtnCancel (this, ResId (BTN_CANCEL)),
	aBtnHelp (this, ResId (BTN_HELP)),
	aMtrFldPercent (this, ResId (MTR_FLD_PERCENT)),
	aMtrFldBigError (this, ResId (MTR_FLD_BIGERROR)),
	aMtrFldConstPlus (this, ResId (MTR_FLD_PLUS)),
	aMtrFldConstMinus (this, ResId (MTR_FLD_MINUS)),
	aFTConstPlus (this, ResId (FT_PERCENT_PLUS)),
	aFTConstMinus (this, ResId (FT_PERCENT_MINUS)),
	aFTIndicate (this, ResId (FT_INDICATE)),
	aFTRegress (this, ResId (FT_REGRESS)),
	aSet (this, ResId (CT_INDICATE)),
	aRegression (this, ResId (CT_REGRESS)),
	rInAttrs(rMyAttrs)
{
	FreeResource();

	aRbtNone.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aRbtVariant.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aRbtSigma.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aRbtPercent.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aRbtBigError.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aRbtConst.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aCbxAverage.SetClickHdl(LINK(this, SchDataStatisticsDlg, CbxClick));
	aMtrFldConstPlus.SetLoseFocusHdl(LINK(this, SchDataStatisticsDlg, EditLoseFocusHdl));
	aMtrFldConstMinus.SetLoseFocusHdl(LINK(this, SchDataStatisticsDlg, EditLoseFocusHdl));

	aSet.InsertItem(INDICATE_NONE + 1, Bitmap(SchResId(BMP_INDICATE_NONE)),
					String(SchResId(STR_INDICATE_NONE)));
	aSet.InsertItem(INDICATE_BOTH + 1, Bitmap(SchResId(BMP_INDICATE_BOTH)),
					String(SchResId(STR_INDICATE_BOTH)));
	aSet.InsertItem(INDICATE_DOWN + 1, Bitmap(SchResId(BMP_INDICATE_DOWN)),
					String(SchResId(STR_INDICATE_DOWN)));
	aSet.InsertItem(INDICATE_UP + 1, Bitmap(SchResId(BMP_INDICATE_UP)),
					String(SchResId(STR_INDICATE_UP)));

	aSet.SetStyle (aSet.GetStyle () /*| WB_ITEMBORDER | WB_DOUBLEBORDER*/ | WB_NAMEFIELD | WB_VSCROLL );
	aSet.SetColCount(2);
	aSet.SetLineCount(1);
	aSet.SetExtraSpacing(2);
	aSet.SetSelectHdl(LINK(this, SchDataStatisticsDlg, SelectIndicate));

	aRegression.InsertItem(REGRESSION_NONE + 1, Bitmap(SchResId(BMP_REGRESSION_NONE)),
						   String(SchResId(STR_REGRESSION_NONE)));
	aRegression.InsertItem(REGRESSION_LINE + 1, Bitmap(SchResId(BMP_REGRESSION_LINEAR)),
						   String(SchResId(STR_REGRESSION_LINEAR)));
	aRegression.InsertItem(REGRESSION_LOG + 1, Bitmap(SchResId(BMP_REGRESSION_LOG)),
						   String(SchResId(STR_REGRESSION_LOG)));
	aRegression.InsertItem(REGRESSION_EXP + 1, Bitmap(SchResId(BMP_REGRESSION_EXP)),
						   String(SchResId(STR_REGRESSION_EXP)));
	aRegression.InsertItem(REGRESSION_POW + 1, Bitmap(SchResId(BMP_REGRESSION_POWER)),
						   String(SchResId(STR_REGRESSION_POWER)));

	aRegression.SetStyle (aSet.GetStyle () /*| WB_ITEMBORDER | WB_DOUBLEBORDER*/ | WB_NAMEFIELD | WB_VSCROLL );
	aRegression.SetColCount(2);
	aRegression.SetLineCount(1);
	aRegression.SetExtraSpacing(2);
	aRegression.SetSelectHdl(LINK(this, SchDataStatisticsDlg, SelectRegression));

	Reset();
}

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

SchDataStatisticsDlg::~SchDataStatisticsDlg()
{
}

/*************************************************************************
|*
|*	Handler fuer Mittelwert-Button
|*
\*************************************************************************/

IMPL_LINK( SchDataStatisticsDlg, CbxClick, CheckBox *, pBtn )
{
	return 0;
}

/*************************************************************************
|*
|*	Handler fuer die Radiobuttons
|*
\*************************************************************************/

IMPL_LINK( SchDataStatisticsDlg, RBtnClick, Button *, pBtn )
{
	aMtrFldPercent.Enable (pBtn == &aRbtPercent);
	aMtrFldBigError.Enable (pBtn == &aRbtBigError);
	aMtrFldConstPlus.Enable (pBtn == &aRbtConst);
	aMtrFldConstMinus.Enable (pBtn == &aRbtConst);
	aSet.Enable (pBtn != &aRbtNone);
	aFTIndicate.Enable (pBtn != &aRbtNone);

	if (pBtn == &aRbtPercent) eKindError = CHERROR_PERCENT;
	if (pBtn == &aRbtBigError) eKindError = CHERROR_BIGERROR;
	if (pBtn == &aRbtConst) eKindError = CHERROR_CONST;

	if (pBtn == &aRbtNone)
	{
		aSet.Hide ();
		eKindError = CHERROR_NONE;
	}
	else
	{
		aSet.Show ();
		if (pBtn == &aRbtVariant) eKindError = CHERROR_VARIANT;
			else if (pBtn == &aRbtSigma) eKindError = CHERROR_SIGMA;
	}

	return 0;
}

/*************************************************************************
|*
|*	Initialisierung
|*
\*************************************************************************/

void SchDataStatisticsDlg::Reset()
{
	const SfxPoolItem *pPoolItem = NULL;

	if (rInAttrs.GetItemState(SCHATTR_STAT_AVERAGE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		aCbxAverage.Check(((const SfxBoolItem*) pPoolItem)->GetValue());

	if (rInAttrs.GetItemState(SCHATTR_STAT_KIND_ERROR, TRUE, &pPoolItem) == SFX_ITEM_SET)
		eKindError = (SvxChartKindError) ((const SfxInt32Item*) pPoolItem)->GetValue();
	else eKindError = CHERROR_NONE;

	aSet.Enable (eKindError != CHERROR_NONE);
	aFTIndicate.Enable (eKindError != CHERROR_NONE);

	if (eKindError == CHERROR_NONE) aSet.Hide ();
	else aSet.Show ();

	if (rInAttrs.GetItemState(SCHATTR_STAT_PERCENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
		aMtrFldPercent.SetValue (((const SvxDoubleItem*) pPoolItem)->GetValue());
	else aMtrFldPercent.SetValue (0.0);

	if (rInAttrs.GetItemState(SCHATTR_STAT_BIGERROR, TRUE, &pPoolItem) == SFX_ITEM_SET)
		aMtrFldBigError.SetValue (((const SvxDoubleItem*) pPoolItem)->GetValue());
	else aMtrFldBigError.SetValue (0.0);

	if (rInAttrs.GetItemState(SCHATTR_STAT_CONSTPLUS, TRUE, &pPoolItem) == SFX_ITEM_SET)
		aMtrFldConstPlus.SetValue (((const SvxDoubleItem*) pPoolItem)->GetValue() * 10.0);
	else aMtrFldConstPlus.SetValue (0.0);

	if (rInAttrs.GetItemState(SCHATTR_STAT_CONSTMINUS, TRUE, &pPoolItem) == SFX_ITEM_SET)
		aMtrFldConstMinus.SetValue (((const SvxDoubleItem*) pPoolItem)->GetValue() * 10.0);
	else aMtrFldConstMinus.SetValue (0.0);

	if (rInAttrs.GetItemState(SCHATTR_DUMMY0, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		SvxChartStyle eChartStyle = (SvxChartStyle) ((const SfxInt32Item*) pPoolItem)->GetValue();

		switch( eChartStyle )
		{
			case CHSTYLE_2D_CUBIC_SPLINE_XY :
			case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
			case CHSTYLE_2D_B_SPLINE_XY :
			case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
			case CHSTYLE_2D_XY :
			case CHSTYLE_2D_XYSYMBOLS :
			case CHSTYLE_2D_XY_LINE :
				bRegressionDisabled = FALSE;
				aFTRegress.Enable (TRUE);
				aRegression.Enable (TRUE);
				aRegression.Show ();
				break;

			default:
				aRegression.Enable (FALSE);
				aRegression.Hide ();
				aFTRegress.Enable (FALSE);
				bRegressionDisabled = TRUE;
				break;
		}
	}

	aRbtNone.Check (eKindError == CHERROR_NONE);
	aRbtVariant.Check (eKindError == CHERROR_VARIANT);
	aRbtSigma.Check (eKindError == CHERROR_SIGMA);
	aRbtPercent.Check (eKindError == CHERROR_PERCENT);
	aRbtBigError.Check (eKindError == CHERROR_BIGERROR);
	aRbtConst.Check (eKindError == CHERROR_CONST);

	if ((eKindError == CHERROR_NONE) ||
		(eKindError == CHERROR_VARIANT) ||
		(eKindError == CHERROR_SIGMA))
	{
		aMtrFldPercent.Enable (FALSE);
		aMtrFldBigError.Enable (FALSE);
		aMtrFldConstPlus.Enable (FALSE);
		aMtrFldConstMinus.Enable (FALSE);
	}
	else if (eKindError == CHERROR_PERCENT)
		 {
			 aMtrFldPercent.Enable (TRUE);
			 aMtrFldBigError.Enable (FALSE);
			 aMtrFldConstPlus.Enable (FALSE);
			 aMtrFldConstMinus.Enable (FALSE);
		 }
		 else if (eKindError == CHERROR_BIGERROR)
			  {
				  aMtrFldPercent.Enable (FALSE);
				  aMtrFldBigError.Enable (TRUE);
				  aMtrFldConstPlus.Enable (FALSE);
				  aMtrFldConstMinus.Enable (FALSE);
			  }
			  else if (eKindError == CHERROR_CONST)
				   {
					   aMtrFldPercent.Enable (FALSE);
					   aMtrFldBigError.Enable (FALSE);
					   aMtrFldConstPlus.Enable (TRUE);
					   aMtrFldConstMinus.Enable (TRUE);
				   }

	if (rInAttrs.GetItemState(SCHATTR_STAT_INDICATE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		eIndicate = (SvxChartIndicate) ((const SfxInt32Item*) pPoolItem)->GetValue();
	else eIndicate = CHINDICATE_NONE;

	switch (eIndicate)
	{
		case CHINDICATE_NONE :
			aSet.SelectItem(INDICATE_NONE + 1);
			break;

		case CHINDICATE_BOTH :
			aSet.SelectItem(INDICATE_BOTH + 1);
			break;

		case CHINDICATE_UP :
			aSet.SelectItem(INDICATE_UP + 1);
			break;

		case CHINDICATE_DOWN :
			aSet.SelectItem(INDICATE_DOWN + 1);
			break;
	}

	if (rInAttrs.GetItemState(SCHATTR_STAT_REGRESSTYPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		eRegression = (SvxChartRegress) ((const SfxInt32Item*) pPoolItem)->GetValue();
	else eRegression = CHREGRESS_NONE;

	switch (eRegression)
	{
		case CHREGRESS_NONE :
			aRegression.SelectItem(REGRESSION_NONE + 1);
			break;

		case CHREGRESS_LINEAR :
			aRegression.SelectItem(REGRESSION_LINE + 1);
			break;

		case CHREGRESS_LOG :
			aRegression.SelectItem(REGRESSION_LOG + 1);
			break;

		case CHREGRESS_EXP :
			aRegression.SelectItem(REGRESSION_EXP + 1);
			break;

		case CHREGRESS_POWER :
			aRegression.SelectItem(REGRESSION_POW + 1);
			break;
	}

}

/*************************************************************************
|*
|*    Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
\*************************************************************************/

void SchDataStatisticsDlg::GetAttr(SfxItemSet& rOutAttrs)
{
	rOutAttrs.Put (SfxBoolItem (SCHATTR_STAT_AVERAGE, aCbxAverage.IsChecked ()));
	rOutAttrs.Put (SfxInt32Item (SCHATTR_STAT_KIND_ERROR, (INT32) eKindError));
	rOutAttrs.Put (SfxInt32Item (SCHATTR_STAT_INDICATE, (INT32) eIndicate));

	if (!bRegressionDisabled) rOutAttrs.Put (SfxInt32Item (SCHATTR_STAT_REGRESSTYPE, (INT32) eRegression));

	switch (eKindError)
	{
		case CHERROR_PERCENT :
			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldPercent.GetValue (), SCHATTR_STAT_PERCENT));
			break;

		case CHERROR_BIGERROR :
			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldBigError.GetValue (), SCHATTR_STAT_BIGERROR));
			break;

		case CHERROR_CONST :
			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldConstPlus.GetValue () / 10.0, SCHATTR_STAT_CONSTPLUS));
			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldConstMinus.GetValue () / 10.0, SCHATTR_STAT_CONSTMINUS));
			break;
	}
}

/*************************************************************************
|*
|*    Bearbeitet das Werteset der Fehlerbalken
|*
\*************************************************************************/

IMPL_LINK( SchDataStatisticsDlg, SelectIndicate, void *, EMPTYARG )
{
	StatIndicator eSelection = (StatIndicator) aSet.GetSelectItemId();

	aSet.Clear ();
	aSet.InsertItem(INDICATE_NONE + 1, Bitmap(SchResId(BMP_INDICATE_NONE)),
					String(SchResId(STR_INDICATE_NONE)));
	aSet.InsertItem(INDICATE_BOTH + 1, Bitmap(SchResId(BMP_INDICATE_BOTH)),
					String(SchResId(STR_INDICATE_BOTH)));
	aSet.InsertItem(INDICATE_DOWN + 1, Bitmap(SchResId(BMP_INDICATE_DOWN)),
					String(SchResId(STR_INDICATE_DOWN)));
	aSet.InsertItem(INDICATE_UP + 1, Bitmap(SchResId(BMP_INDICATE_UP)),
					String(SchResId(STR_INDICATE_UP)));

	switch (eSelection - 1)
	{
		case INDICATE_NONE :
			eIndicate = CHINDICATE_NONE;
			break;

		case INDICATE_BOTH :
			eIndicate = CHINDICATE_BOTH;
			break;

		case INDICATE_UP :
			eIndicate = CHINDICATE_UP;
			break;

		case INDICATE_DOWN :
			eIndicate = CHINDICATE_DOWN;
			break;
	}

	aSet.SelectItem(eSelection);
	aSet.Show ();

	return 0;
}

/*************************************************************************
|*
|*    Bearbeitet das Werteset der Regression
|*
\*************************************************************************/

IMPL_LINK( SchDataStatisticsDlg, SelectRegression, void *, EMPTYARG )
{
	StatRegression eSelection = (StatRegression) aRegression.GetSelectItemId();

	aRegression.Clear ();
	aRegression.InsertItem(REGRESSION_NONE + 1, Bitmap(SchResId(BMP_REGRESSION_NONE)),
						   String(SchResId(STR_REGRESSION_NONE)));
	aRegression.InsertItem(REGRESSION_LINE + 1, Bitmap(SchResId(BMP_REGRESSION_LINEAR)),
						   String(SchResId(STR_REGRESSION_LINEAR)));
	aRegression.InsertItem(REGRESSION_LOG + 1, Bitmap(SchResId(BMP_REGRESSION_LOG)),
						   String(SchResId(STR_REGRESSION_LOG)));
	aRegression.InsertItem(REGRESSION_EXP + 1, Bitmap(SchResId(BMP_REGRESSION_EXP)),
						   String(SchResId(STR_REGRESSION_EXP)));
	aRegression.InsertItem(REGRESSION_POW + 1, Bitmap(SchResId(BMP_REGRESSION_POWER)),
						   String(SchResId(STR_REGRESSION_POWER)));

	switch (eSelection - 1)
	{
		case REGRESSION_NONE :
			eRegression = CHREGRESS_NONE;
			break;

		case REGRESSION_LINE :
			eRegression = CHREGRESS_LINEAR;
			break;

		case REGRESSION_LOG :
			eRegression = CHREGRESS_LOG;
			break;

		case REGRESSION_EXP :
			eRegression = CHREGRESS_EXP;
			break;

		case REGRESSION_POW :
			eRegression = CHREGRESS_POWER;
			break;
	}

	aRegression.SelectItem(eSelection);
	aRegression.Show ();

	return 0;
}

/*************************************************************************
|*
|*    Bearbeite das Valueset
|*
\*************************************************************************/

IMPL_LINK( SchDataStatisticsDlg, EditLoseFocusHdl, Control *, pControl )
{
	if ((double) aMtrFldConstPlus.GetValue () == 0.0)
	{
		if ((double) aMtrFldConstMinus.GetValue () == 0.0)
		{
			eIndicate = CHINDICATE_NONE;
			aSet.SelectItem(INDICATE_NONE + 1);
		}
		else if (eIndicate != CHINDICATE_NONE)
			 {
				 eIndicate = CHINDICATE_DOWN;
				 aSet.SelectItem(INDICATE_DOWN + 1);
			 }
	}
	else if ((double) aMtrFldConstMinus.GetValue () == 0.0)
		 {
			 if (eIndicate != CHINDICATE_NONE)
			 {
				 eIndicate = CHINDICATE_UP;
				 aSet.SelectItem(INDICATE_UP + 1);
			 }
		 }
		 else
		 {
			 eIndicate = CHINDICATE_BOTH;
			 aSet.SelectItem(INDICATE_BOTH + 1);
		 }

	return 0;
}



