/*************************************************************************
 *
 *  $RCSfile: diagrtyp.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: af $ $Date: 2001/05/18 10:20:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define OFFSET_PYRAMID 1000
#define OFFSET_ROUND   2000
#define OFFSET_CONE    3000



#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#include <sfx2/sfxsids.hrc>
#include <svx/eeitem.hxx>
#pragma hdrstop

#include "schdll.hxx"
#define ITEMID_CHARTSTYLE	CHATTR_DIAGRAM_STYLE
#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif

#include "strings.hrc"
#include "res_bmp.hrc"

#include "schresid.hxx"
#include "chtmodel.hxx"
#include "diagrtyp.hxx"
#include "diagrtyp.hrc"

#include "chmod3d.hxx"
#include "schattr.hxx"
/************************************************************************/
// TVM: CHTYPE wurde ins Model verschoben

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchDiagramTypeDlg::SchDiagramTypeDlg(Window* pWindow,
									 const SfxItemSet& rInAttrs) :
	ModalDialog(pWindow, SchResId(DLG_DIAGRAM_TYPE)),
	aRbt2D(this, ResId(RBT_2D)),
	aRbt3D(this, ResId(RBT_3D)),
	aFlDimension(this, ResId(FL_DIMENSION)),
	aFtDeep( this, ResId( FT_DEEP ) ),
	aMtrFldDeep( this, ResId( MTR_FLD_DEEP ) ),
	aFtGran( this, ResId( FT_GRAN ) ),
	aMtrFldGran( this, ResId( MTR_FLD_GRAN ) ),
	aFtType(this, ResId(FT_TYPE)),
	aCtlType(this, ResId(CTL_TYPE)),
	aFtVariant(this, ResId(FT_VARIANT)),
	aCtlVariant(this, ResId(CTL_VARIANT)),
	aBtnOK(this, ResId(BTN_OK)),
	aBtnCancel(this, ResId(BTN_CANCEL)),
	aBtnHelp(this, ResId(BTN_HELP)),
	eDimension(CHDIM_2D),
	rOutAttrs(rInAttrs),
	n3DGeometry(CHART_SHAPE3D_ANY)
{
	FreeResource();

	aRbt2D.SetClickHdl(LINK(this, SchDiagramTypeDlg,
							   SelectDimensionHdl));
	aRbt3D.SetClickHdl(LINK(this, SchDiagramTypeDlg,
							   SelectDimensionHdl));

	aCtlType.SetStyle(aCtlType.GetStyle() |
						 /*WB_ITEMBORDER | WB_DOUBLEBORDER |*/ WB_NAMEFIELD | WB_VSCROLL );

	aCtlType.SetColCount(4);
	aCtlType.SetLineCount(2);
	aCtlType.SetExtraSpacing(2);

	aCtlType.SetSelectHdl(LINK(this, SchDiagramTypeDlg, SelectTypeHdl));
	aCtlType.SetDoubleClickHdl(LINK(this, SchDiagramTypeDlg,
											 DoubleClickHdl));

	aCtlVariant.SetStyle(aCtlVariant.GetStyle() |
							/*WB_ITEMBORDER | WB_DOUBLEBORDER |*/ WB_NAMEFIELD | WB_VSCROLL );

	aCtlVariant.SetColCount(4);
	aCtlVariant.SetLineCount(1);
	aCtlVariant.SetExtraSpacing(2);
	aCtlVariant.SetDoubleClickHdl(LINK(this, SchDiagramTypeDlg,	DoubleClickHdl));
	aCtlVariant.SetSelectHdl(LINK(this, SchDiagramTypeDlg, ClickHdl));

	Reset();
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchDiagramTypeDlg::~SchDiagramTypeDlg()
{
}
/*************************************************************************
|*
|*	Initialisierung
|*
\*************************************************************************/

void SchDiagramTypeDlg::Reset()
{
	const SfxPoolItem *pPoolItem = NULL;

	if (rOutAttrs.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem)
			== SFX_ITEM_SET)
			n3DGeometry=((const SfxInt32Item*)pPoolItem)->GetValue();

	if (rOutAttrs.GetItemState(CHATTR_DIAGRAM_STYLE, TRUE, &pPoolItem)
			== SFX_ITEM_SET)
	{
		USHORT nType;
		ChartDimension eDim;

		//Hier sollte demnaechst folgendes ersatzweise stehen:
		//nType=pDoc->GetBaseType();
		//eDim=(pDoc->GetDisplayDimension()==3)?CHDIM_3D:CHDIM_2D;

		switch (((const SvxChartStyleItem*)pPoolItem)->GetValue())
		{
			case CHSTYLE_2D_B_SPLINE :
			case CHSTYLE_2D_B_SPLINE_SYMBOL :
			case CHSTYLE_2D_LINE:
			case CHSTYLE_2D_STACKEDLINE:
			case CHSTYLE_2D_PERCENTLINE:
			case CHSTYLE_2D_LINESYMBOLS:
			case CHSTYLE_2D_STACKEDLINESYM:
			case CHSTYLE_2D_PERCENTLINESYM:
			case CHSTYLE_2D_CUBIC_SPLINE :
			case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
				nType	= CHTYPE_LINE;
				eDim	= CHDIM_2D;
				break;

			case CHSTYLE_2D_COLUMN:
			case CHSTYLE_2D_STACKEDCOLUMN:
			case CHSTYLE_2D_PERCENTCOLUMN:
			case CHSTYLE_2D_LINE_COLUMN:
			case CHSTYLE_2D_LINE_STACKEDCOLUMN:

				nType	= CHTYPE_COLUMN;
				eDim	= CHDIM_2D;
				break;

			case CHSTYLE_2D_BAR:
			case CHSTYLE_2D_STACKEDBAR:
			case CHSTYLE_2D_PERCENTBAR:
				nType	= CHTYPE_BAR;
				eDim	= CHDIM_2D;
				break;

			case CHSTYLE_2D_AREA:
			case CHSTYLE_2D_STACKEDAREA:
			case CHSTYLE_2D_PERCENTAREA:
				nType	= CHTYPE_AREA;
				eDim	= CHDIM_2D;
				break;

			case CHSTYLE_2D_PIE:
			case CHSTYLE_2D_PIE_SEGOF1:
			case CHSTYLE_2D_PIE_SEGOFALL:
			case CHSTYLE_2D_DONUT1:
			case CHSTYLE_2D_DONUT2:
				nType	= CHTYPE_CIRCLE;
				eDim	= CHDIM_2D;
				break;

			case CHSTYLE_2D_B_SPLINE_XY :
			case CHSTYLE_2D_XY_LINE :
			case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
			case CHSTYLE_2D_XYSYMBOLS:
			case CHSTYLE_2D_XY:
			case CHSTYLE_2D_CUBIC_SPLINE_XY :
			case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
				nType	= CHTYPE_XY;
				eDim	= CHDIM_2D;
				break;

			case CHSTYLE_2D_NET:
			case CHSTYLE_2D_NET_SYMBOLS:
			case CHSTYLE_2D_NET_STACK:
			case CHSTYLE_2D_NET_SYMBOLS_STACK:
			case CHSTYLE_2D_NET_PERCENT:
			case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
				nType	= CHTYPE_NET;
				eDim	= CHDIM_2D;
				break;

			case CHSTYLE_3D_STRIPE:
				nType	= CHTYPE_LINE;
				eDim	= CHDIM_3D;
				break;

			case CHSTYLE_3D_COLUMN:
			case CHSTYLE_3D_FLATCOLUMN:
			case CHSTYLE_3D_STACKEDFLATCOLUMN:
			case CHSTYLE_3D_PERCENTFLATCOLUMN:
				nType	= CHTYPE_COLUMN;
				eDim	= CHDIM_3D;
				break;

			case CHSTYLE_3D_BAR:
			case CHSTYLE_3D_FLATBAR:
			case CHSTYLE_3D_STACKEDFLATBAR:
			case CHSTYLE_3D_PERCENTFLATBAR:
				nType	= CHTYPE_BAR;
				eDim	= CHDIM_3D;
				break;

			case CHSTYLE_3D_AREA:
			case CHSTYLE_3D_STACKEDAREA:
			case CHSTYLE_3D_PERCENTAREA:
				nType	= CHTYPE_AREA;
				eDim	= CHDIM_3D;
				break;

			case CHSTYLE_3D_PIE:
				nType	= CHTYPE_CIRCLE;
				eDim	= CHDIM_3D;
				break;

			case CHSTYLE_2D_STOCK_1:
			case CHSTYLE_2D_STOCK_2:
			case CHSTYLE_2D_STOCK_3:
			case CHSTYLE_2D_STOCK_4:
				nType	= CHTYPE_STOCK;
				eDim	= CHDIM_2D;
				break;

			default:
				DBG_ERROR("Invalid chart style given!");
				return;
		}

		if (eDim == CHDIM_3D)
		{
			aRbt3D.Check(TRUE);
			eDimension = CHDIM_2D;
			SelectDimensionHdl(&aRbt3D);
		}
		else
		{
			aRbt2D.Check(TRUE);
			eDimension = CHDIM_3D;
			SelectDimensionHdl(&aRbt2D);
		}

		aCtlType.SelectItem(nType);
		SelectTypeHdl(&aCtlType);
		SwitchDepth ((USHORT) ((const SvxChartStyleItem*)pPoolItem)->GetValue());
	}
}

/*************************************************************************
|*
|* Fuellt das Typ-Set mit Bitmaps
|*
\************************************************************************/

void SchDiagramTypeDlg::FillTypeSet(ChartDimension eDim)
{
	if (eDim != eDimension)
	{
		eDimension = eDim;

		USHORT nSelId = aCtlType.IsNoSelection() ?
						0 : aCtlType.GetSelectItemId();

		aCtlType.Clear();

		if (aRbt2D.IsChecked())
		{
			aCtlType.InsertItem(CHTYPE_LINE,
								Bitmap(SchResId(BMP_LINES_2D)),
								String(SchResId(STR_LINES)));
			aCtlType.InsertItem(CHTYPE_AREA,
								Bitmap(SchResId(BMP_AREAS_2D)),
								String(SchResId(STR_AREAS)));
			aCtlType.InsertItem(CHTYPE_COLUMN,
								Bitmap(SchResId(BMP_COLUMNS_2D)),
								String(SchResId(STR_COLUMNS)));
			aCtlType.InsertItem(CHTYPE_BAR,
								Bitmap(SchResId(BMP_BARS_2D)),
								String(SchResId(STR_BARS)));
			aCtlType.InsertItem(CHTYPE_CIRCLE,
								Bitmap(SchResId(BMP_CIRCLES_2D)),
								String(SchResId(STR_CIRCLES)));
			aCtlType.InsertItem(CHTYPE_XY,
								Bitmap(SchResId(BMP_XYSYMB_2D)),
								String(SchResId(STR_XY)));
			aCtlType.InsertItem(CHTYPE_NET,
								Bitmap(SchResId(BMP_NET_2D)),
								String(SchResId(STR_NET)));
			aCtlType.InsertItem(CHTYPE_STOCK,
								Bitmap(SchResId(BMP_STOCK_2)),
								String(SchResId(STR_STOCK)));
		}
		else
		{
			aCtlType.InsertItem(CHTYPE_LINE,
								Bitmap(SchResId(BMP_LINES_3D)),
								String(SchResId(STR_LINES)));
			aCtlType.InsertItem(CHTYPE_AREA,
								Bitmap(SchResId(BMP_AREAS_3D_1)),
								String(SchResId(STR_AREAS)));
			aCtlType.InsertItem(CHTYPE_BAR,
								Bitmap(SchResId(BMP_BARS_3D_1)),
								String(SchResId(STR_BARS)));
			aCtlType.InsertItem(CHTYPE_COLUMN,
								Bitmap(SchResId(BMP_COLUMNS_3D_1)),
								String(SchResId(STR_COLUMNS)));
			aCtlType.InsertItem(CHTYPE_CIRCLE,
								Bitmap(SchResId(BMP_CIRCLES_3D)),
								String(SchResId(STR_CIRCLES)));
		}

		aCtlType.Show();

		if (nSelId > 0)
		{
			if (aCtlType.GetItemPos(nSelId) == VALUESET_ITEM_NOTFOUND) nSelId = aCtlType.GetItemId(0);

			aCtlType.SelectItem(nSelId);
			SelectTypeHdl(&aCtlType);
		}
	}
}

/*************************************************************************
|*
|* Fuellt das Varianten-Set mit Bitmaps
|*
\************************************************************************/

void SchDiagramTypeDlg::FillVariantSet(USHORT nType)
{
	long nDefaultOffset = 0;
	
	aCtlVariant.Clear();

	if (eDimension == CHDIM_3D)
	{
		switch (nType)
		{
			case CHTYPE_LINE:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STRIPE + 1,
									   Bitmap(SchResId(BMP_LINES_3D)),
									   String(SchResId(STR_DEEP)));
				break;

			case CHTYPE_AREA:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDAREA + 1,
									   Bitmap(SchResId(BMP_AREAS_3D_1)),
									   String(SchResId(STR_STACKED)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTAREA + 1,
									   Bitmap(SchResId(BMP_AREAS_3D_2)),
									   String(SchResId(STR_PERCENT)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_AREA + 1,
									   Bitmap(SchResId(BMP_AREAS_3D)),
									   String(SchResId(STR_DEEP)));
				break;

			case CHTYPE_COLUMN:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATCOLUMN + 1,
									   Bitmap(SchResId(BMP_COLUMNS_3D_1)),
									   String(SchResId(STR_NORMAL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATCOLUMN + 1,
									   Bitmap(SchResId(BMP_COLUMNS_3D_2)),
									   String(SchResId(STR_STACKED)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATCOLUMN + 1,
									   Bitmap(SchResId(BMP_COLUMNS_3D_3)),
									   String(SchResId(STR_PERCENT)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_COLUMN + 1,
									   Bitmap(SchResId(BMP_COLUMNS_3D)),
									   String(SchResId(STR_DEEP)));

				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATCOLUMN + 1 + OFFSET_ROUND,
									   Bitmap(SchResId(BMP_SAEULE_3D_1)),
									   String(SchResId(STR_SAEULE_3D_1)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATCOLUMN + 1 + OFFSET_ROUND,
									   Bitmap(SchResId(BMP_SAEULE_3D_2)),
									   String(SchResId(STR_SAEULE_3D_2)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATCOLUMN + 1 + OFFSET_ROUND,
									   Bitmap(SchResId(BMP_SAEULE_3D_3)),
									   String(SchResId(STR_SAEULE_3D_3)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_COLUMN + 1 + OFFSET_ROUND,
									   Bitmap(SchResId(BMP_SAEULE_3D_4)),
									   String(SchResId(STR_SAEULE_3D_4)));

				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATCOLUMN + 1 + OFFSET_PYRAMID,
									   Bitmap(SchResId(BMP_PYRAMID_3D_1)),
									   String(SchResId(STR_PYRAMID_3D_1)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATCOLUMN + 1 + OFFSET_PYRAMID,
									   Bitmap(SchResId(BMP_PYRAMID_3D_2)),
									   String(SchResId(STR_PYRAMID_3D_2)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATCOLUMN + 1 + OFFSET_PYRAMID,
									   Bitmap(SchResId(BMP_PYRAMID_3D_3)),
									   String(SchResId(STR_PYRAMID_3D_3)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_COLUMN + 1 + OFFSET_PYRAMID,
									   Bitmap(SchResId(BMP_PYRAMID_3D_4)),
									   String(SchResId(STR_PYRAMID_3D_4)));

				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATCOLUMN + 1 + OFFSET_CONE,
									   Bitmap(SchResId(BMP_KEGEL_3D_1)),
									   String(SchResId(STR_KEGEL_3D_1)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATCOLUMN + 1 + OFFSET_CONE,
									   Bitmap(SchResId(BMP_KEGEL_3D_2)),
									   String(SchResId(STR_KEGEL_3D_2)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATCOLUMN + 1 + OFFSET_CONE,
									   Bitmap(SchResId(BMP_KEGEL_3D_3)),
									   String(SchResId(STR_KEGEL_3D_3)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_COLUMN + 1 + OFFSET_CONE,
									   Bitmap(SchResId(BMP_KEGEL_3D_4)),
									   String(SchResId(STR_KEGEL_3D_4)));
				break;

			case CHTYPE_CIRCLE:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PIE + 1,
									   Bitmap(SchResId(BMP_CIRCLES_3D)),
									   String(SchResId(STR_NORMAL)));
				break;

			case CHTYPE_BAR:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATBAR + 1,
									   Bitmap(SchResId(BMP_BARS_3D_1)),
									   String(SchResId(STR_NORMAL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATBAR + 1,
									   Bitmap(SchResId(BMP_BARS_3D_2)),
									   String(SchResId(STR_STACKED)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATBAR + 1,
									   Bitmap(SchResId(BMP_BARS_3D_3)),
									   String(SchResId(STR_PERCENT)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_BAR + 1,
									   Bitmap(SchResId(BMP_BARS_3D)),
									   String(SchResId(STR_DEEP)));



				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATBAR + 1 + OFFSET_ROUND,
									   Bitmap(SchResId(BMP_ROEHRE_3D_1)),
									   String(SchResId(STR_ROEHRE_3D_1)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATBAR + 1 + OFFSET_ROUND,
									   Bitmap(SchResId(BMP_ROEHRE_3D_2)),
									   String(SchResId(STR_ROEHRE_3D_2)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATBAR + 1 + OFFSET_ROUND,
									   Bitmap(SchResId(BMP_ROEHRE_3D_3)),
									   String(SchResId(STR_ROEHRE_3D_3)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_BAR + 1 + OFFSET_ROUND,
									   Bitmap(SchResId(BMP_ROEHRE_3D_4)),
									   String(SchResId(STR_ROEHRE_3D_4)));

				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATBAR + 1 + OFFSET_PYRAMID,
									   Bitmap(SchResId(BMP_PYRAMIDQ_3D_1)),
									   String(SchResId(STR_PYRAMIDQ_3D_1)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATBAR + 1 + OFFSET_PYRAMID,
									   Bitmap(SchResId(BMP_PYRAMIDQ_3D_2)),
									   String(SchResId(STR_PYRAMIDQ_3D_2)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATBAR + 1 + OFFSET_PYRAMID,
									   Bitmap(SchResId(BMP_PYRAMIDQ_3D_3)),
									   String(SchResId(STR_PYRAMIDQ_3D_3)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_BAR + 1 + OFFSET_PYRAMID,
									   Bitmap(SchResId(BMP_PYRAMIDQ_3D_4)),
									   String(SchResId(STR_PYRAMIDQ_3D_4)));

				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_FLATBAR + 1 + OFFSET_CONE,
									   Bitmap(SchResId(BMP_KEGELQ_3D_1)),
									   String(SchResId(STR_KEGELQ_3D_1)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_STACKEDFLATBAR + 1 + OFFSET_CONE,
									   Bitmap(SchResId(BMP_KEGELQ_3D_2)),
									   String(SchResId(STR_KEGELQ_3D_2)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_PERCENTFLATBAR + 1 + OFFSET_CONE,
									   Bitmap(SchResId(BMP_KEGELQ_3D_3)),
									   String(SchResId(STR_KEGELQ_3D_3)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_3D_BAR + 1 + OFFSET_CONE,
									   Bitmap(SchResId(BMP_KEGELQ_3D_4)),
									   String(SchResId(STR_KEGELQ_3D_4)));
				break;

		}
	}
	else		// 2D types
	{
		switch (nType)
		{
			case CHTYPE_LINE:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_LINE + 1,
									   Bitmap(SchResId(BMP_LINES_2D_1)),
									   String(SchResId(STR_NORMAL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STACKEDLINE + 1,
									   Bitmap(SchResId(BMP_LINES_2D_2)),
									   String(SchResId(STR_STACKED)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PERCENTLINE + 1,
									   Bitmap(SchResId(BMP_LINES_2D_3)),
									   String(SchResId(STR_PERCENT)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_LINESYMBOLS + 1,
									   Bitmap(SchResId(BMP_LINESYMB_2D_1)),
									   String(SchResId(STR_SYMBOL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STACKEDLINESYM + 1,
									   Bitmap(SchResId(BMP_LINESYMB_2D_2)),
									   String(SchResId(STR_SYMBOL_STACK)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PERCENTLINESYM + 1,
									   Bitmap(SchResId(BMP_LINESYMB_2D_3)),
									   String(SchResId(STR_SYMBOL_PERCENT)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_CUBIC_SPLINE + 1,
									   Bitmap(SchResId(BMP_SPLINE_CUBIC)),
									   String(SchResId(STR_SPLINE_CUBIC)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_CUBIC_SPLINE_SYMBOL + 1,
									   Bitmap(SchResId(BMP_SPLINE_CUBIC_SYMBOL)),
									   String(SchResId(STR_SPLINE_CUBIC_SYMBOL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_B_SPLINE + 1,
									   Bitmap(SchResId(BMP_SPLINE_B)),
									   String(SchResId(STR_SPLINE_B)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_B_SPLINE_SYMBOL + 1,
									   Bitmap(SchResId(BMP_SPLINE_B_SYMBOL)),
									   String(SchResId(STR_SPLINE_B_SYMBOL)));
				break;

			case CHTYPE_AREA:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_AREA + 1,
									   Bitmap(SchResId(BMP_AREAS_2D_1)),
									   String(SchResId(STR_NORMAL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STACKEDAREA + 1,
									   Bitmap(SchResId(BMP_AREAS_2D)),
									   String(SchResId(STR_STACKED)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PERCENTAREA + 1,
									   Bitmap(SchResId(BMP_AREAS_2D_3)),
									   String(SchResId(STR_PERCENT)));
				nDefaultOffset = 1;
				break;

			case CHTYPE_COLUMN:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_COLUMN + 1,
									   Bitmap(SchResId(BMP_COLUMNS_2D_1)),
									   String(SchResId(STR_NORMAL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STACKEDCOLUMN + 1,
									   Bitmap(SchResId(BMP_COLUMNS_2D_2)),
									   String(SchResId(STR_STACKED)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PERCENTCOLUMN + 1,
									   Bitmap(SchResId(BMP_COLUMNS_2D_3)),
									   String(SchResId(STR_PERCENT)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_LINE_COLUMN + 1,
									   Bitmap(SchResId(BMP_COLUMNS_2D_4)),
									   String(SchResId(STR_LINE_COLUMN)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_LINE_STACKEDCOLUMN + 1,
									   Bitmap(SchResId(BMP_COLUMNS_2D_5)),
									   String(SchResId(STR_LINE_STACKEDCOLUMN)));

				break;

			case CHTYPE_BAR:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_BAR + 1,
									   Bitmap(SchResId(BMP_BARS_2D_1)),
									   String(SchResId(STR_NORMAL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STACKEDBAR + 1,
									   Bitmap(SchResId(BMP_BARS_2D_2)),
									   String(SchResId(STR_STACKED)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PERCENTBAR + 1,
									   Bitmap(SchResId(BMP_BARS_2D_3)),
									   String(SchResId(STR_PERCENT)));
				break;

			case CHTYPE_CIRCLE:
			{
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_PIE + 1,
										Bitmap(SchResId(BMP_CIRCLES_2D)),
										String(SchResId(STR_NORMAL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_DONUT1 + 1,
										Bitmap(SchResId(BMP_DONUT1_2D)),
										String(SchResId(STR_DONUT1)));
				String aResStr( SchResId( STR_OFS ));
				String aOfsStr = aResStr;

				xub_StrLen nFound = aResStr.SearchAscii( "$(N)" );
				if( nFound != STRING_NOTFOUND )
					aOfsStr.Replace( nFound, RTL_CONSTASCII_LENGTH( "$(N)" ), String::CreateFromInt32( 1 ));

				aCtlVariant.InsertItem( (USHORT)CHSTYLE_2D_PIE_SEGOF1 + 1,
										Bitmap( SchResId( BMP_CIRCLES_2D_1 )),
										aOfsStr );

				aOfsStr = aResStr;
				if( nFound != STRING_NOTFOUND )
					aOfsStr.Replace( nFound, RTL_CONSTASCII_LENGTH( "$(N)" ), String::CreateFromInt32( 2 ));

				aCtlVariant.InsertItem( (USHORT)CHSTYLE_2D_PIE_SEGOFALL + 1,
										Bitmap( SchResId( BMP_CIRCLES_2D_2 )),
										aOfsStr );
				break;
			}

			case CHTYPE_XY:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_XYSYMBOLS + 1,
									   Bitmap(SchResId(BMP_XYSYMB_2D)),
									   String(SchResId(STR_ONLY_SYMBOLS)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_XY + 1,
									   Bitmap(SchResId(BMP_XY_2D)),
									   String(SchResId(STR_LINE_SYMBOLS)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_XY_LINE + 1,
									   Bitmap(SchResId(BMP_LINES_2D_1)),
									   String(SchResId(STR_ONLY_LINES)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_CUBIC_SPLINE_XY + 1,
									   Bitmap(SchResId(BMP_SPLINE_CUBIC)),
									   String(SchResId(STR_SPLINE_CUBIC)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY + 1,
									   Bitmap(SchResId(BMP_SPLINE_CUBIC_SYMBOL)),
									   String(SchResId(STR_SPLINE_CUBIC_SYMBOL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_B_SPLINE_XY + 1,
									   Bitmap(SchResId(BMP_SPLINE_B)),
									   String(SchResId(STR_SPLINE_B)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_B_SPLINE_SYMBOL_XY + 1,
									   Bitmap(SchResId(BMP_SPLINE_B_SYMBOL)),
									   String(SchResId(STR_SPLINE_B_SYMBOL)));
				break;
			case CHTYPE_NET:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET + 1,
									   Bitmap(SchResId(BMP_NET_2D)),
									   String(SchResId(STR_NORMAL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET_STACK + 1,
									   Bitmap(SchResId(BMP_NET_2D_STACK)),
									   String(SchResId(STR_STACKED)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET_PERCENT + 1,
									   Bitmap(SchResId(BMP_NET_2D_PERCENT)),
									   String(SchResId(STR_PERCENT)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET_SYMBOLS + 1,
									   Bitmap(SchResId(BMP_NETSYMB_2D)),
									   String(SchResId(STR_SYMBOL)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET_SYMBOLS_STACK + 1,
									   Bitmap(SchResId(BMP_NETSYMB_2D_STACK)),
									   String(SchResId(STR_SYMBOL_STACK)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_NET_SYMBOLS_PERCENT + 1,
									   Bitmap(SchResId(BMP_NETSYMB_2D_PERCENT)),
									   String(SchResId(STR_SYMBOL_PERCENT)));
				break;

			case CHTYPE_STOCK:
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STOCK_1 + 1,
									   Bitmap(SchResId(BMP_STOCK_1)),
									   String(SchResId(STR_STOCK_1)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STOCK_2 + 1,
									   Bitmap(SchResId(BMP_STOCK_2)),
									   String(SchResId(STR_STOCK_2)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STOCK_3 + 1,
									   Bitmap(SchResId(BMP_STOCK_3)),
									   String(SchResId(STR_STOCK_3)));
				aCtlVariant.InsertItem((USHORT)CHSTYLE_2D_STOCK_4 + 1,
									   Bitmap(SchResId(BMP_STOCK_4)),
									   String(SchResId(STR_STOCK_4)));
				nDefaultOffset = 1;
		}
	}

	aCtlVariant.Show();

	USHORT nSelId = aCtlVariant.GetItemId(0);
	const SfxPoolItem *pPoolItem = NULL;

	if( rOutAttrs.GetItemState(CHATTR_DIAGRAM_STYLE, TRUE, &pPoolItem) == SFX_ITEM_SET )
	{
		USHORT nId = (USHORT)((const SvxChartStyleItem*)pPoolItem)->GetValue() + 1;
		
		if( aCtlVariant.GetItemPos(nId) != VALUESET_ITEM_NOTFOUND )
		{
			nSelId = nId;
			nDefaultOffset = 0;
		}
	}
	long nShape3dOffset = 0;
	if( rOutAttrs.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem) == SFX_ITEM_SET )
	{
		long nId3D = ((const SfxInt32Item*)&pPoolItem)->GetValue();
		switch( n3DGeometry )
		{
			case CHART_SHAPE3D_CYLINDER:
				nShape3dOffset = OFFSET_ROUND;
				break;
			case CHART_SHAPE3D_CONE:
				nShape3dOffset = OFFSET_CONE;
				break;
			case CHART_SHAPE3D_PYRAMID:
				nShape3dOffset = OFFSET_PYRAMID;
				break;
		}
	}
	if( aCtlVariant.GetItemPos( nSelId + nShape3dOffset + nDefaultOffset ) != VALUESET_ITEM_NOTFOUND )
		nSelId += (nShape3dOffset + nDefaultOffset);

	aCtlVariant.SelectItem( nSelId );

	// make selected Item visible
	aCtlVariant.SetFirstLine( aCtlVariant.GetItemPos( aCtlVariant.GetSelectItemId() ) / aCtlVariant.GetColCount() );
								
	SwitchDepth( nSelId - 1 );
}

/*************************************************************************
|*
|* Select-Hdl der Dimensions-Buttons
|*
\************************************************************************/

IMPL_LINK( SchDiagramTypeDlg, SelectDimensionHdl, void *, EMPTYARG )
{
	FillTypeSet(aRbt3D.IsChecked() ? CHDIM_3D : CHDIM_2D);
	return 0;
}

/*************************************************************************
|*
|* Select-Hdl des ValueSets
|*
\************************************************************************/

IMPL_LINK( SchDiagramTypeDlg, SelectTypeHdl, void *, EMPTYARG )
{
	FillVariantSet(aCtlType.GetSelectItemId());
	return 0;
}

/*************************************************************************
|*
|* Select-Hdl des ValueSets
|*
\************************************************************************/

IMPL_LINK( SchDiagramTypeDlg, DoubleClickHdl, void *, EMPTYARG )
{
	EndDialog(RET_OK);
	return 0;
}

/*************************************************************************
|*
|*    Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
\*************************************************************************/

void SchDiagramTypeDlg::GetAttr(SfxItemSet& rOutAttrs)
{
	long nId=aCtlVariant.GetSelectItemId() - 1;
	long nGeo=CHART_SHAPE3D_ANY;
	if(nId>OFFSET_CONE)
	{
		nId-=OFFSET_CONE;
		nGeo=CHART_SHAPE3D_CONE;
	}
	if(nId>OFFSET_ROUND)
	{
		nId-=OFFSET_ROUND;
		nGeo=CHART_SHAPE3D_CYLINDER;
	}
	if(nId>OFFSET_PYRAMID)
	{
		nId-=OFFSET_PYRAMID;
		nGeo=CHART_SHAPE3D_PYRAMID;
	}
	if(nGeo != n3DGeometry)
		rOutAttrs.Put(SfxInt32Item(SCHATTR_STYLE_SHAPE,nGeo));
	else
		rOutAttrs.ClearItem(SCHATTR_STYLE_SHAPE);

	rOutAttrs.Put(SvxChartStyleItem((SvxChartStyle)	(nId)));
}

/*************************************************************************
|*
|* Gibt die eingestellte Intensitaet als double zurueck
|*
\************************************************************************/

int SchDiagramTypeDlg::GetDepth()
{
	return aMtrFldDeep.GetValue();
}

/*************************************************************************
|*
|* Setzt die uebergebene Intensitaet
|*
\************************************************************************/

void SchDiagramTypeDlg::SetDepth( int nDepth )
{
	 aMtrFldDeep.SetValue( nDepth );
}

/*************************************************************************
|*
|* Setzt die uebergebene Intensitaet
|*
\************************************************************************/

void SchDiagramTypeDlg::SwitchDepth (USHORT nID)
{
	aFtDeep.Hide ();
	aMtrFldDeep.Hide ();
	aFtGran.Hide ();
	aMtrFldGran.Hide ();

	switch (nID)
	{
		case CHSTYLE_2D_B_SPLINE :
		case CHSTYLE_2D_B_SPLINE_SYMBOL :
		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
			aFtDeep.Show ();
			aMtrFldDeep.Show ();

		case CHSTYLE_2D_CUBIC_SPLINE :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
			aFtGran.Show ();
			aMtrFldGran.Show ();
			break;

		default :
			break;
	}
}

/*************************************************************************
|*
|* Select-Hdl des ValueSets
|*
\************************************************************************/

IMPL_LINK( SchDiagramTypeDlg, ClickHdl, void *, EMPTYARG )
{
	SwitchDepth (aCtlVariant.GetSelectItemId() - 1);
	return 0;
}

/*************************************************************************
|*
|* Laedt die Splineaufloesung
|*
\************************************************************************/

int SchDiagramTypeDlg::GetGranularity()
{
	return aMtrFldGran.GetValue();
}

/*************************************************************************
|*
|* Setzt die Splineaufloesung
|*
\************************************************************************/

void SchDiagramTypeDlg::SetGranularity( int nGranularity )
{
	aMtrFldGran.SetValue( nGranularity );
}



