/*************************************************************************
 *
 *  $RCSfile: tplabel.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: af $ $Date: 2001/05/18 10:23:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// header for SfxItemSet
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
// header for SfxInt32Item
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
// header for SfxBoolItem
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif

#include "schattr.hxx"
#define ITEMID_CHARTTEXTORDER	SCHATTR_TEXT_ORDER
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
// header for SvxChartTextOrientItem / SvxChartTextOrderItem
#ifndef _SVX_CHRTITEM_HXX
#include <svx/chrtitem.hxx>
#endif

#include "chtmodel.hxx"
#include "schresid.hxx"
#include "app.hrc"

#include "tplabel.hxx"
#include "tplabel.hrc"

//  #include "strings.hrc"
//  #include "schmod.hxx"

// ====================
// class SchAxisLabelTabPage
// ====================

SchAxisLabelTabPage::SchAxisLabelTabPage( Window* pParent, const SfxItemSet& rInAttrs ) :
		SfxTabPage( pParent, SchResId( TP_AXIS_LABEL ), rInAttrs ),

		aCbShowDescription( this, SchResId( CB_AXIS_LABEL_SCHOW_DESCR ) ),

		aWOAngle( this,
				  SchResId( CT_AXIS_LABEL_DIAL ),
				  SchResId( PB_AXIS_LABEL_TEXTSTACKED ),
				  SchResId( FT_AXIS_LABEL_DEGREES ),
				  SchResId( NF_AXIS_LABEL_ORIENT ),
				  SchResId( FT_UNUSED ),
				  SchResId( CT_UNUSED ),
				  SchResId( FL_AXIS_LABEL_ORIENTATION ) ),

		aFlTextFlow( this, SchResId( FL_AXIS_LABEL_TEXTFLOW ) ),
		aCbTextOverlap( this, SchResId( CB_AXIS_LABEL_TEXTOVERLAP ) ),
		aCbTextBreak( this, SchResId( CB_AXIS_LABEL_TEXTBREAK ) ),

		aFlOrder( this, SchResId( FL_AXIS_LABEL_ORDER ) ),
		aRbSideBySide( this, SchResId( RB_AXIS_LABEL_SIDEBYSIDE ) ),
		aRbUpDown( this, SchResId( RB_AXIS_LABEL_UPDOWN ) ),
		aRbDownUp( this, SchResId( RB_AXIS_LABEL_DOWNUP ) ),
		aRbAuto( this, SchResId( RB_AXIS_LABEL_AUTOORDER ) ),

   		aFlSeparator( this, SchResId( FL_SEPARATOR ) ),

		eOrderMode( CHORDMODE_X_AXIS ),
		bAllowTextOverlap( TRUE )
{
	FreeResource();

	aCbShowDescription.SetClickHdl( LINK( this, SchAxisLabelTabPage, ToggleShowLabel ) );

    //	Make the fixed line separator vertical.    
    aFlSeparator.SetStyle (aFlSeparator.GetStyle() | WB_VERT);
    
	Construct();
}

SchAxisLabelTabPage::~SchAxisLabelTabPage()
{}

void SchAxisLabelTabPage::Construct()
{
}


SfxTabPage* SchAxisLabelTabPage::Create( Window* pParent, const SfxItemSet& rAttrs )
{
	return new SchAxisLabelTabPage( pParent, rAttrs );
}

BOOL SchAxisLabelTabPage::FillItemSet( SfxItemSet& rOutAttrs )
{
	SvxChartTextOrient eOrient;
	long nDegrees = aWOAngle.GetDegrees() * 100L;

	rOutAttrs.Put( SfxInt32Item( SCHATTR_TEXT_DEGREES, nDegrees ) );

	if( aWOAngle.IsStackedTxt() )
	{
		eOrient = CHTXTORIENT_STACKED;
		rOutAttrs.Put( SfxInt32Item( SCHATTR_TEXT_DEGREES, 0 ) );
	}
	else
	{
		if( nDegrees == 0L )
			eOrient = CHTXTORIENT_STANDARD;
		else if( nDegrees <= 18000L )
			eOrient = CHTXTORIENT_BOTTOMTOP;
		else
			eOrient = CHTXTORIENT_TOPBOTTOM;
	}

	rOutAttrs.Put( SvxChartTextOrientItem( eOrient ) );

	if( eOrderMode != CHORDMODE_NONE )
	{
		SvxChartTextOrder eOrder;

		if( aRbUpDown.IsChecked())
			eOrder = CHTXTORDER_UPDOWN;
		else if( aRbDownUp.IsChecked())
			eOrder = CHTXTORDER_DOWNUP;
		else if( aRbAuto.IsChecked())
			eOrder = CHTXTORDER_AUTO;
		else eOrder = CHTXTORDER_SIDEBYSIDE;

		rOutAttrs.Put( SvxChartTextOrderItem( eOrder ));
	}

	rOutAttrs.Put( SfxBoolItem( SCHATTR_TEXT_OVERLAP, aCbTextOverlap.IsChecked() ) );
	rOutAttrs.Put( SfxBoolItem( SID_TEXTBREAK, aCbTextBreak.IsChecked() ) );
	rOutAttrs.Put( SfxBoolItem( SCHATTR_AXIS_SHOWDESCR, aCbShowDescription.IsChecked() ) );

	return TRUE;
}

void SchAxisLabelTabPage::Reset( const SfxItemSet& rInAttrs )
{
	const SfxPoolItem* pPoolItem = NULL;

	if( rInAttrs.GetItemState( SCHATTR_TEXT_ORDER, TRUE, &pPoolItem) == SFX_ITEM_SET &&
		eOrderMode != CHORDMODE_NONE )
	{
		switch( ((const SvxChartTextOrderItem*)pPoolItem)->GetValue() )
		{
			case CHTXTORDER_SIDEBYSIDE:
				aRbSideBySide.Check( TRUE );
				break;

			case CHTXTORDER_UPDOWN:
				aRbUpDown.Check( TRUE );
				break;

			case CHTXTORDER_DOWNUP:
				aRbDownUp.Check( TRUE );
				break;

			case CHTXTORDER_AUTO:
				aRbAuto.Check( TRUE );
				break;
		}
	}

	long nDegrees = 0;
	pPoolItem =	GetItem( rInAttrs, SCHATTR_TEXT_DEGREES );
	if( pPoolItem )
	{
		nDegrees=((const SfxInt32Item*)pPoolItem)->GetValue() / 100L;
	}

	if( rInAttrs.GetItemState( SCHATTR_TEXT_ORIENT, TRUE, &pPoolItem ) == SFX_ITEM_SET )
	{
		SvxChartTextOrient eOrient = ((const SvxChartTextOrientItem*)pPoolItem)->GetValue();

		aWOAngle.SetDegrees( (short)nDegrees );
		switch( eOrient )
		{
			case CHTXTORIENT_AUTOMATIC:
				break;

			case CHTXTORIENT_STANDARD:
				break;

			case CHTXTORIENT_TOPBOTTOM:
				if( !nDegrees )
					aWOAngle.SetDegrees( 270 );
				break;
			case CHTXTORIENT_BOTTOMTOP:
				if( !nDegrees )
					aWOAngle.SetDegrees( 90 );
				break;

			case CHTXTORIENT_STACKED:
				aWOAngle.SetStackedTxt( TRUE );
				break;

		}
	}

	if( rInAttrs.GetItemState( SID_TEXTBREAK, FALSE, &pPoolItem ) >= SFX_ITEM_AVAILABLE )
	{
		BOOL bTextBreak = ((const SfxBoolItem*)pPoolItem)->GetValue();
		aCbTextBreak.Check( bTextBreak );
	}
	else
	{
		aCbTextBreak.Hide();
		aFlTextFlow.Hide();
	}

	if( (rInAttrs.GetItemState( SCHATTR_TEXT_OVERLAP, FALSE, &pPoolItem ) >= SFX_ITEM_AVAILABLE) && bAllowTextOverlap )
	{
		aCbTextOverlap.Check( ( (const SfxBoolItem*)pPoolItem)->GetValue() );
	}
	else
	{
		aCbTextOverlap.Hide();
	}

	if( rInAttrs.GetItemState( SCHATTR_AXIS_SHOWDESCR, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		aCbShowDescription.Check( SAL_STATIC_CAST( const SfxBoolItem*, pPoolItem )->GetValue() );
	else
		aCbShowDescription.Check( TRUE );

	ToggleShowLabel( (void*)0 );	
}

void SchAxisLabelTabPage::SetOrderMode( OrderMode eMode )
{
	eOrderMode = eMode;

	if (eOrderMode == CHORDMODE_NONE)
	{
		aRbSideBySide.Hide();
		aRbUpDown.Hide();
		aRbDownUp.Hide();
		aRbAuto.Hide();
		aFlOrder.Hide();
	}
}

// event handling routines
// -----------------------

IMPL_LINK ( SchAxisLabelTabPage, ToggleShowLabel, void *, EMPTYARG )
{
	BOOL bEnable = aCbShowDescription.IsChecked();

	if( bEnable )
		aWOAngle.Enable();
	else
		aWOAngle.Disable();

	aFlOrder.Enable( bEnable );
	aRbSideBySide.Enable( bEnable );
	aRbUpDown.Enable( bEnable );
	aRbDownUp.Enable( bEnable );
	aRbAuto.Enable( bEnable );

	aFlTextFlow.Enable( bEnable );
	aCbTextOverlap.Enable( bEnable );
	aCbTextBreak.Enable( bEnable );

	return 0L;
}

