/*************************************************************************
 *
 *  $RCSfile: docshell.cxx,v $
 *
 *  $Revision: 1.49.6.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 07:39:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#define ITEMID_FONTLIST 		SID_ATTR_CHAR_FONTLIST
#define ITEMID_NUMBERINFO		SID_ATTR_NUMBERFORMAT_INFO
#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_GRADIENT_LIST	SID_GRADIENT_LIST
#define ITEMID_HATCH_LIST		SID_HATCH_LIST
#define ITEMID_BITMAP_LIST		SID_BITMAP_LIST
#define ITEMID_DASH_LIST		SID_DASH_LIST
#define ITEMID_LINEEND_LIST 	SID_LINEEND_LIST

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#include <svx/svxids.hrc>
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _SO_CLSIDS_HXX //autogen
#include <so3/clsids.hxx>
#endif
#ifndef _SFX_PRINTER_HXX //autogen
#include <sfx2/printer.hxx>
#endif
#ifndef _UNDO_HXX
#include <svtools/undo.hxx>
#endif
#ifndef _CTRLTOOL_HXX
#include <svtools/ctrltool.hxx>
#endif
#ifndef _IPMENU_HXX
#include <so3/ipmenu.hxx>
#endif
#ifndef _SFXMNUMGR_HXX
#include <sfx2/mnumgr.hxx>
#endif
#ifndef _SFX_PROGRESS_HXX
#include <sfx2/progress.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXSTBMGR_HXX //autogen
#include <sfx2/stbmgr.hxx>
#endif
#ifndef _SFXECODE_HXX //autogen
#include <svtools/sfxecode.hxx>
#endif
#ifndef _SVX_DRAWITEM_HXX //autogen
#include <svx/drawitem.hxx>
#endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#ifndef _SCH_DLL_HXX //autogen
#include <schdll.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_SAVEOPT_HXX
#include <svtools/saveopt.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#include <sot/formats.hxx>
#include <svx/flstitem.hxx>
#include <svx/svxids.hrc>

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "schresid.hxx"
#include "schview.hxx"
#include "docshell.hxx"
#include "schmod.hxx"

#include "ChXChartDocument.hxx"
#include "ChXChartData.hxx"
#include "SchTransferable.hxx"

// header for class SfxFilter
#ifndef _SFX_DOCFILT_HACK_HXX
#include <sfx2/docfilt.hxx>
#endif

#ifndef	_RTL_LOGFILE_HXX_
#include <rtl/logfile.hxx>
#endif

// XML filter
#include "SchXMLWrapper.hxx"

#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif

#define POOL_BUFFER_SIZE		(USHORT)32768
#define BASIC_BUFFER_SIZE		(USHORT)8192
#define DOCUMENT_BUFFER_SIZE	(USHORT)32768

#define SCH_STYLE_SHEET_NAME	String( RTL_CONSTASCII_USTRINGPARAM( "SfxStyleSheets" ))

#define SCH_DEFAULT_CHART_SIZE_WIDTH  8000
#define SCH_DEFAULT_CHART_SIZE_HEIGHT 7000

using namespace com::sun::star::uno;


// STATIC DATA -----------------------------------------------------------

static const String __FAR_DATA aStarChartDoc = String( RTL_CONSTASCII_USTRINGPARAM( "StarChartDocument" ));

//----------------------------------------------------------------------

/*************************************************************************
|*
|* SFX-Slotmaps und -Definitionen
|*
\************************************************************************/

#define SchChartDocShell
#include "schslots.hxx"

SFX_IMPL_INTERFACE( SchChartDocShell, SfxObjectShell, SchResId( 0 ) )
// from macro: void SchChartDocShell::InitInterface_Impl()
{}

using namespace com::sun::star;

SFX_IMPL_OBJECTFACTORY_DLL(SchChartDocShell, schart,
						   SvGlobalName(SO3_SCH_CLASSID), Sch)

TYPEINIT1(SchChartDocShell, SfxObjectShell);

/*************************************************************************
|*
|* shared construction - used by internal CTOR and InitNew
|*
\************************************************************************/

void SchChartDocShell::Construct() throw()
{
	DBG_ASSERT( pChDoc, "SchChartDocShell::Construct() called with no valid model!" );
	//Wird fuer die ModelCollection benoetigt
	SetPool(&pChDoc->GetItemPool());
    if( pUndoManager )
        delete pUndoManager;
    pUndoManager = new SfxUndoManager;

	// Listen, bzw. Tables im ItemSet der DocShell anlegen
	UpdateTablePointers();

	if (pChDoc->GetPageCount() == 0L)
	{
		// Seite einfuegen
		SdrPage* pPage = pChDoc->AllocPage(FALSE);
		pPage->SetSize(GetVisArea(ASPECT_CONTENT).GetSize());
		pChDoc->InsertPage(pPage);
	}
}

void SchChartDocShell::DataModified( chart::ChartDataChangeEvent& aEvent ) throw()
{
	uno::Reference< chart::XChartDocument > xChartDoc( GetModel(), uno::UNO_QUERY );
	if( xChartDoc.is() )
	{
		uno::Reference< chart::XChartData > xData = xChartDoc->getData();
		if( xData.is() )
		{
			ChXChartData* pChXData = ChXChartData::getImplementation( xData );
			if( pChXData )
			{
				pChXData->DataModified( aEvent );
			}
		}
	}
}


/*************************************************************************
|*
|* Default CTOR - this one is called by the factory from SFX
|*
\************************************************************************/

SchChartDocShell::SchChartDocShell(SfxObjectCreateMode eMode) throw() :
	SfxObjectShell(eMode),
	pUndoManager(NULL),
	pPrinter(NULL),
	pFontList(NULL),
	pChDoc(NULL),
	bInitNewNoNewDoc(FALSE),
	bOwnPrinter(FALSE),
	mbClipboardExport( FALSE )
{
	CHART_TRACE( "SchChartDocShell::SchChartDocShell(SfxObjectCreateMode)" );
	SetShell(this);
	SetModel( new ChXChartDocument( this ));
}

/*************************************************************************
|*
|* CTOR used by dragserver
|*
\************************************************************************/

SchChartDocShell::SchChartDocShell(ChartModel* pDoc,
								   SfxObjectCreateMode eMode) throw() :
	SfxObjectShell(eMode),
	pUndoManager(NULL),
	pPrinter(NULL),
	pFontList(NULL),
	pChDoc(pDoc),
	bInitNewNoNewDoc(TRUE),
	bOwnPrinter(FALSE),
	mbClipboardExport( FALSE )
{
	CHART_TRACE1( "SchChartDocShell::SchChartDocShell(pDoc,eMode) pDoc=%lx", (long)pDoc );
	SetShell(this);
	SetModel( new ChXChartDocument( this ));
	Construct();
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchChartDocShell::~SchChartDocShell() throw()
{
	CHART_TRACE( "SchChartDocShell::~SchChartDocShell" );

	delete pFontList;

	delete pUndoManager;

	if( pChDoc )
	{
		pChDoc->ClearUndoBuffer();				// clear draw undo actions
		pChDoc->SetMaxUndoActionCount( 1 );		// don't add further undo actions
	}

	if(bOwnPrinter)
		delete pPrinter;

	delete pChDoc;
}

/*************************************************************************
|*
|* SFX-Requests bearbeiten
|*
\************************************************************************/

void SchChartDocShell::Execute(SfxRequest& rReq) throw()
{
	switch (rReq.GetSlot())
	{
		case SID_CLOSEDOC:
			SfxObjectShell::DoClose();
			break;

		case SID_UPDATE:
			pChDoc->InitDataAttrs();
			pChDoc->BuildChart(FALSE);
			break;
	}
}

/*************************************************************************
|*
|* Slot-Stati setzen
|*
\************************************************************************/

void SchChartDocShell::GetState(SfxItemSet &rSet) throw()
{
	SfxWhichIter aIter(rSet);
	USHORT nWhich = aIter.FirstWhich();

	while (nWhich)
	{
		USHORT nSlotId = SfxItemPool::IsWhich(nWhich) ?
						 GetPool().GetSlotId(nWhich) : nWhich;

		switch (nSlotId)
		{
/*            case SID_DOC_MODIFIED:
				rSet.Put( SfxStringItem( SID_DOC_MODIFIED,
										 IsModified() ? '*' : ' ' ) );
				//rSet.Put(SfxBoolItem(SID_DOC_MODIFIED, IsModified()));
				break;
*/
			case SID_DOCTEMPLATE :
				rSet.DisableItem (SID_DOCTEMPLATE);
				break;
		}

		nWhich = aIter.NextWhich();
	}
}

/*************************************************************************
|*
|* SFX-Aktivierung
|*
\************************************************************************/

void SchChartDocShell::Activate() throw()
{
}

/*************************************************************************
|*
|* SFX-Deaktivierung
|*
\************************************************************************/

void SchChartDocShell::Deactivate() throw()
{
}

/*************************************************************************
|*
|* SFX-Undomanager zurueckgeben
|*
\************************************************************************/

SfxUndoManager* SchChartDocShell::GetUndoManager() throw()
{
	return pUndoManager;
}

/*************************************************************************
|*
|* SfxPrinter ggf. erzeugen und zurueckgeben
|*
\************************************************************************/
SfxPrinter* SchChartDocShell::GetPrinter() throw()
{
	if (!pPrinter)
	{
		SfxBoolItem aItem(SID_PRINTER_NOTFOUND_WARN, TRUE);
		// ItemSet mit speziellem Poolbereich anlegen
		SfxItemSet* pSet = new SfxItemSet(GetPool(),
										  SID_PRINTER_NOTFOUND_WARN,
										  SID_PRINTER_NOTFOUND_WARN, 0);
		pSet->Put(aItem);
		pPrinter = new SfxPrinter(pSet);
		bOwnPrinter = TRUE;

		MapMode aMapMode = pPrinter->GetMapMode();
		aMapMode.SetMapUnit(MAP_100TH_MM);
		pPrinter->SetMapMode(aMapMode);

		if (pChDoc)
		{
			if (pPrinter != pChDoc->GetRefDevice())
				pChDoc->SetRefDevice(pPrinter);

			if (pPrinter != pChDoc->GetOutliner()->GetRefDevice())
				pChDoc->GetOutliner()->SetRefDevice(pPrinter);
		}
	}

	return pPrinter;
}


/*************************************************************************
|*
|* neuen SfxPrinter setzen
|*
\************************************************************************/
void SchChartDocShell::SetPrinter( SfxPrinter* pNewPrinter, BOOL bIsDeletedHere ) throw()
{
	if( pNewPrinter &&
        pNewPrinter->GetMapMode().GetMapUnit() == MAP_100TH_MM )
	{
		// Printer kann nur verwendet werden, wenn die MapUnit stimmt
		if (pPrinter && bOwnPrinter && (pPrinter != pNewPrinter))
		{
			delete pPrinter;
			bOwnPrinter = FALSE;
		}

		bOwnPrinter = bIsDeletedHere;

		pPrinter = pNewPrinter;
		if(pFontList)delete pFontList;
		OutputDevice* pOut = Application::GetDefaultDevice();	// #67730#
		pFontList = new FontList( pPrinter, pOut, FALSE );
		PutItem(SvxFontListItem(pFontList));

		if (pChDoc)
		{
			if (pPrinter != pChDoc->GetRefDevice())
				pChDoc->SetRefDevice(pPrinter);

			if (pPrinter != pChDoc->GetOutliner()->GetRefDevice())
				pChDoc->GetOutliner()->SetRefDevice(pPrinter);
		}
	}
	else
		if( bIsDeletedHere )
			delete pNewPrinter;
}



/*************************************************************************
|*
|*
|*
\************************************************************************/
Printer* SchChartDocShell::GetDocumentPrinter() throw()
{
	return GetPrinter();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/
void SchChartDocShell::OnDocumentPrinterChanged(Printer* pNewPrinter) throw()
{
    if( pPrinter )
        // we have no rtti, thus assert that we have an SfxPrinter
        SetPrinter( reinterpret_cast< SfxPrinter * >( pNewPrinter ) );
}



/*************************************************************************
|*
|* InitNew, (Dokument wird neu erzeugt): Streams oeffnen
|*
\************************************************************************/

BOOL SchChartDocShell::InitNew( SvStorage * pStor ) throw()
{
	CHART_TRACE1( "SchChartDocShell::InitNew pModel=%lx", (long)pChDoc );

	if( SfxInPlaceObject::InitNew( pStor ))
	{
		if(!pChDoc)
		{
			pChDoc = new ChartModel( SvtPathOptions().GetPalettePath(), this );
			// set new model at ChXChartDocument
			ChXChartDocument* pImpl = ChXChartDocument::getImplementation( GetModel() );
			if( pImpl )
				pImpl->SetChartModel( pChDoc );
			Construct();
		}
		if( pChDoc )
		{
			if(bInitNewNoNewDoc)
				pChDoc->NewOrLoadCompleted(DOC_LOADED);
			else
				pChDoc->NewOrLoadCompleted(NEW_DOC);
		}

		SetVisArea(Rectangle(Point(0, 0), Size( SCH_DEFAULT_CHART_SIZE_WIDTH, SCH_DEFAULT_CHART_SIZE_HEIGHT )));

		return TRUE;
	}

	return FALSE;
}

/*************************************************************************
|*
|* Load: Pools und Dokument laden
|*
\************************************************************************/

BOOL SchChartDocShell::Load(SvStorage * pStor) throw()
{
	RTL_LOGFILE_CONTEXT_AUTHOR (context, "sch", "af119097", "::SchChartDocShell::Load");

	CHART_TRACE( "SchChartDocShell::Load" );

	BOOL bRet = FALSE;

	pChDoc = new ChartModel( SvtPathOptions().GetPalettePath(), this );
	SetPool( &pChDoc->GetItemPool());
	SetModel( new ChXChartDocument( this ));

    sal_Bool bIsXML = pStor->GetVersion() >= SOFFICE_FILEFORMAT_60;

	if( bIsXML )
	{
		RTL_LOGFILE_CONTEXT_TRACE (context, "XML format");
		bRet = SfxInPlaceObject::Load( pStor );

		// create a new draw page etc.
		Construct();
		// The XML Filter expects a completely
		// initialized document. This is achieved by the
		// following statement
		pChDoc->NewOrLoadCompleted( NEW_DOC );

		if( bRet )
		{
			SetWaitCursor( TRUE );

			if( pStor )
			{
                Reference<com::sun::star::frame::XModel> xModel(GetModel());
				SchXMLWrapper aFilter( xModel, *pStor, TRUE );
                sal_Int32 nWarning = aFilter.Import();
                if( nWarning )
                    SetError( nWarning );

                // ok if there was no waring
				bRet = (nWarning == 0);

                // reset number format ids last set by calc
                pChDoc->ResetLastAxisNumFmt( -2 );

				if( bRet )
				{
					// during import the page size is set
					// the vis area has to be set to the whole page size
                    Size aPageSize = pChDoc->GetPage( 0 )->GetSize();
                    if( aPageSize.Width() <= 0 ||
                        aPageSize.Height() <= 0 )
                    {
                        // invalid page size
                        // assume that page size is uninitialized
                        DBG_ASSERT( aPageSize.Height() == 0 &&
                                    aPageSize.Width() == 0,
                                    "Invalid Page Size" );
                        aPageSize.setWidth( SCH_DEFAULT_CHART_SIZE_WIDTH );
                        aPageSize.setHeight( SCH_DEFAULT_CHART_SIZE_HEIGHT );
                    }
                    
					Rectangle aVisRect( Point( 0, 0 ), aPageSize );
					SetVisArea( aVisRect );

					pChDoc->SetChanged( FALSE );
					pChDoc->NewOrLoadCompleted( DOC_LOADED );
					SetModified( FALSE );

					FinishedLoading(SFX_LOADED_ALL);
				}
			}
			else
			{
				DBG_ERROR( "Load (XML): got no Storage in Medium!" );
			}
			SetWaitCursor( FALSE );
		}
		else
			DBG_ERROR( "Load (XML): SfxInPlaceObject::Load failed!" );
	}
	else
	{
		ULONG nStorFmt = pStor->GetFormat();
		RTL_LOGFILE_CONTEXT_TRACE1 (context, "binary format %lu", nStorFmt);

        if( pUndoManager )
            delete pUndoManager;
        pUndoManager = new SfxUndoManager;

        pProgress = NULL;

		if ( nStorFmt == SOT_FORMATSTR_ID_STARCHART_50 ||
			 nStorFmt == SOT_FORMATSTR_ID_STARCHART_40 ||
			 nStorFmt == SOT_FORMATSTR_ID_STARCHART    ||
			 nStorFmt == SOT_FORMATSTR_ID_STARCHARTDOCUMENT_50
			)
		{
			if( GetCreateMode() != SFX_CREATE_MODE_EMBEDDED )
				pProgress = new SfxProgress( this, String( SchResId( STR_OPEN_DOCUMENT )), 100 );

			if( pProgress )
				pProgress->SetState( 0, 100 );

			bRet = SfxInPlaceObject::Load( pStor );

			if( pProgress )
				pProgress->SetState( 30 );

			if( bRet )
			{
				SetWaitCursor( TRUE );

				// Pool und StyleSheet Pool laden
				String aStyleSheetsStr( SCH_STYLE_SHEET_NAME );

				if (pStor->IsStream(aStyleSheetsStr))
				{
					ULONG nError;
					SvStorageStreamRef rPoolStream = pStor->OpenStream( aStyleSheetsStr );
					rPoolStream->SetVersion( pStor->GetVersion());
					if( ! rPoolStream->GetError())
					{
						rPoolStream->SetBufferSize( POOL_BUFFER_SIZE );
						nError = rPoolStream->GetError();
						GetPool().SetFileFormatVersion( (USHORT)pStor->GetVersion ());
						GetPool().Load( *rPoolStream );
						nError = rPoolStream->GetError();
						if( nError )
						{
							DBG_ERROR1( "Errorcode 0x%x loading Pool", nError );
							rPoolStream->ResetError();
							SetError( ERRCODE_WARNING_MASK | nError );
						}
						GetStyleSheetPool()->Load( *rPoolStream );
						nError = rPoolStream->GetError();
						if( nError )
						{
							DBG_ERROR1( "Errorcode 0x%x loading StyleSheet-Pool", nError );
							rPoolStream->ResetError();
							SetError( ERRCODE_WARNING_MASK | nError );
						}
						rPoolStream->SetBufferSize( 0 );
					}
					else bRet = FALSE;
				}
				else bRet = FALSE;

				if( pProgress )
					pProgress->SetState( 70 );

				// wenn gewuenscht, das Dokument laden
				if (bRet && (GetCreateMode() != SFX_CREATE_MODE_ORGANIZER))
				{
					// Model der Drawing Engine laden
					if (pStor->IsStream( aStarChartDoc ))
					{
						SvStorageStreamRef rDocumentStream = pStor->OpenStream( aStarChartDoc );
						rDocumentStream->SetVersion( pStor->GetVersion());
						GetPool().SetFileFormatVersion ( (USHORT)pStor->GetVersion());
						if( ! rDocumentStream->GetError())
						{
							rDocumentStream->SetBufferSize( DOCUMENT_BUFFER_SIZE );
							rDocumentStream->SetKey( pStor->GetKey()); // set password

                            // read ChartModel
							*rDocumentStream >> *pChDoc;

                            bRet = ( rDocumentStream->GetError() == 0 );

							// garbled with password?
							if( ! bRet )
							{
								if( pStor->GetKey().Len() == 0 )
								{
									// no password set => cannot load
									SetError( ERRCODE_SFX_DOLOADFAILED );
								}
								else
								{
									// password was set, but obviously wrong
									SetError( ERRCODE_SFX_WRONGPASSWORD );
								}
							}

							rDocumentStream->SetBufferSize( 0 );
						}
						else bRet = FALSE;
					}
					else bRet = FALSE;
				}

				if( pProgress )
					pProgress->SetState( 100 );

				// (noch) keine ungesicherten Aenderungen im Model
				if (bRet)
				{
					pChDoc->SetChanged( FALSE );
					pChDoc->NewOrLoadCompleted( DOC_LOADED );
				}

				SetWaitCursor( FALSE );
			}

			if( pProgress )
				pProgress->SetState( 100 );

			if (bRet)
			{
				UpdateTablePointers();
				FinishedLoading( SFX_LOADED_ALL );
			}
		}
		else
		{
			pStor->SetError( SVSTREAM_WRONGVERSION );
		}

		if( pProgress )
		{
			delete pProgress;
			pProgress = NULL;
		}
	}
	
	return bRet;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

sal_Bool SchChartDocShell::ConvertTo( SfxMedium &rMedium )
{
	BOOL			bRet = FALSE;

	String aFilterName( rMedium.GetFilter()->GetFilterName() );
	if( aFilterName.EqualsAscii( "StarOffice XML (Chart)" ))
	{
		/**********************************************************************
		 * StarOffice XML-Filter Export
		 **********************************************************************/
		SvStorage* pStorage = rMedium.GetOutputStorage( sal_True );
		if( pStorage )
		{
            Reference<com::sun::star::frame::XModel> xModel(GetModel());
			SchXMLWrapper aFilter( xModel, *pStorage, TRUE );

			// update user info before writing
			UpdateDocInfoForSave();

			bRet = aFilter.Export();
		}
		else
		{
			DBG_ERROR( "ConvertTo: got no Storage in Medium!" );
		}
	}

	FinishedLoading( SFX_LOADED_ALL );

	return  bRet;
}

sal_Bool SchChartDocShell::ConvertFrom( SfxMedium &rMedium )
{
	BOOL bRet = FALSE;

	const String aFilterName(rMedium.GetFilter()->GetFilterName());

	if( aFilterName.EqualsAscii( "StarOffice XML (Chart)" ))
	{
		/**********************************************************************
		* StarOffice XML-Filter Import
		**********************************************************************/
		SvStorage* pStorage = rMedium.GetStorage();
		if( pStorage )
		{
            Reference<com::sun::star::frame::XModel> xModel(GetModel());
			SchXMLWrapper aFilter( xModel, *pStorage, TRUE );
            sal_Int32 nWarning = aFilter.Import();
            if( nWarning )
                SetError( nWarning );

            // ok if there was no waring
            bRet = (nWarning == 0);
		}
		else
		{
			DBG_ERROR( "ConvertFrom: got no Storage in Medium!" );
		}
	}

	FinishedLoading( SFX_LOADED_ALL );

	return bRet;
}

// ------------------------------------------------------------

void SchChartDocShell::HandsOff() throw()
{
	SfxInPlaceObject::HandsOff();

    if( pChDoc )
        pChDoc->HandsOff();
}

// ------------------------------------------------------------

BOOL SchChartDocShell::Save() throw()
{
	RTL_LOGFILE_CONTEXT_AUTHOR (context, "sch", "af119097", "::SchChartDocShell::Save");
	
	SvStorage* pStor = GetStorage();
	DBG_ASSERT( pStor, "Save() without Storage called!" );

    long nFileFormat = pStor->GetVersion();
    sal_Bool bIsXML = nFileFormat >= SOFFICE_FILEFORMAT_60;
	BOOL bRet = FALSE;

	if( bIsXML )
	{
		RTL_LOGFILE_CONTEXT_TRACE (context, "XML format");
		bRet = SfxInPlaceObject::Save();

		/**********************************************************************
		 * StarOffice XML-Filter Export
		 **********************************************************************/
		if( pStor )
		{
            Reference<com::sun::star::frame::XModel> xModel(GetModel());
			SchXMLWrapper aFilter( xModel, *pStor,
								   GetCreateMode() != SFX_CREATE_MODE_EMBEDDED );

			// update user info before writing
			UpdateDocInfoForSave();

			bRet = aFilter.Export();
		}
		else
		{
			DBG_ERROR( "SaveAs (XML): got no Storage in Medium!" );
		}

  		FinishedLoading( SFX_LOADED_ALL );
	}
	else		// binary format <= 5.0
	{
		pChDoc->PrepareAxisStorage();
		SvStorageStreamRef rDocumentStream = pStor->OpenStream( aStarChartDoc );

        if( rDocumentStream.Is() && ! rDocumentStream->GetError() )
		{
			rDocumentStream->SetVersion( pStor->GetVersion() );

            if( nFileFormat <= SOFFICE_FILEFORMAT_40 && pChDoc->IsReal3D())
            {
                CHART_TRACE( "Fileformat 4.0" );
                pChDoc->PrepareOld3DStorage();
            }

            bRet = SfxInPlaceObject::Save();
            SfxStatusBarManager* pStbMgr =
                (GetCreateMode() == SFX_CREATE_MODE_EMBEDDED) ?
                NULL : SFX_APP()->GetStatusBarManager();

            if (pStbMgr)
                pStbMgr->StartProgressMode(SchResId(STR_SAVE_DOCUMENT), 100);

            // komprimiert/native speichern?
            SvtSaveOptions							aOptions;
            const SvtSaveOptions::SaveGraphicsMode	eSaveMode( aOptions.GetSaveGraphicsMode() );
            const BOOL								bSaveNative = ( SvtSaveOptions::SaveGraphicsOriginal == eSaveMode );
            const BOOL								bSaveCompressed = ( bSaveNative || ( SvtSaveOptions::SaveGraphicsCompressed == eSaveMode ) );

            pChDoc->SetSaveCompressed( bSaveCompressed );
            pChDoc->SetSaveNative( bSaveNative );

            if( bRet )
            {
                pChDoc->PreSave();

                SetWaitCursor( TRUE );

                SvStorageStreamRef rPoolStream = pStor->OpenStream( SCH_STYLE_SHEET_NAME );
                if( ! rPoolStream->GetError())
                {
                    rPoolStream->SetSize( 0 );
                    rPoolStream->SetBufferSize( POOL_BUFFER_SIZE );
                    GetPool().Store( *rPoolStream );

                    if( pStbMgr )
                        pStbMgr->SetProgressState( 20 );

                    // the style sheet pool uses next() and first() methods without resetting
                    // the search mask (?) so it has to be done here
                    GetStyleSheetPool()->SetSearchMask( SFX_STYLE_FAMILY_ALL );
                    // FALSE = also save unused style sheets
                    GetStyleSheetPool()->Store( *rPoolStream, FALSE );
                    rPoolStream->SetBufferSize( 0 );

                    if( pStbMgr )
                        pStbMgr->SetProgressState( 50 );
                }
                else bRet = FALSE;
                if (bRet)
                    bRet = rPoolStream->GetError() == 0;
                DBG_ASSERT(bRet, "Fehler beim Schreiben der Pools");

                if( ! rDocumentStream->GetError())
                {
                    rDocumentStream->SetSize( 0 );
                    rDocumentStream->SetBufferSize( DOCUMENT_BUFFER_SIZE );
                    *rDocumentStream << *pChDoc;
                    rDocumentStream->SetBufferSize( 0 );
                }
                else
                    bRet = FALSE;

                if (bRet)
                    bRet = rDocumentStream->GetError() == 0;
                DBG_ASSERT(bRet, "Fehler beim Schreiben des Models");

                // finished
                if( pStbMgr )
                    pStbMgr->SetProgressState( 100 );

                SetWaitCursor( FALSE );

                pChDoc->PostSave();
            }

            if (pStbMgr)
                pStbMgr->EndProgressMode();

            if(nFileFormat <= SOFFICE_FILEFORMAT_40 && pChDoc->IsReal3D())
            {
                pChDoc->CleanupOld3DStorage();
            }
        }
	}

	return bRet;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchChartDocShell::SaveAs(SvStorage * pStor) throw()
{
	RTL_LOGFILE_CONTEXT_AUTHOR (context, "sch", "af119097", "::SchChartDocShell::SaveAs");
	
	CHART_TRACE( "SchChartDocShell::SaveAs" );

	BOOL bRet = FALSE;

    long nOldFormat = GetStorage()->GetVersion();
    long nNewFormat = pStor->GetVersion();

	BOOL bIsXML = nNewFormat >= SOFFICE_FILEFORMAT_60;
    BOOL bFormatChanges = (nOldFormat != nNewFormat);

	//	If chart was loaded from binary format it has never been built.
	if( ! pChDoc->IsInitialized())
		pChDoc->Initialize();

	if( bIsXML )
	{
		RTL_LOGFILE_CONTEXT_TRACE (context, "XML format");
		bRet = SfxInPlaceObject::SaveAs( pStor );

		/**********************************************************************
		 * StarOffice XML-Filter Export
		 **********************************************************************/
		if( pStor )
		{
            Reference<com::sun::star::frame::XModel> xModel(GetModel());
			SchXMLWrapper aFilter( xModel, *pStor,
								   GetCreateMode() != SFX_CREATE_MODE_EMBEDDED );

			// update user info before writing
			UpdateDocInfoForSave();

            // old storage was binary format
            if( bFormatChanges )
            {
                // convert SomeData-strings from Calc/Writer to data structure
                SvPersist* pParent = GetParent();
                if( pParent )
                {
                    // determine which is parent application
                    SvGlobalName aGlobalName;
                    ULONG nFileFormat;
                    String aAppName, aFullName, aShortName;
                    pParent->FillClass( &aGlobalName, &nFileFormat,
                                        &aAppName, &aFullName, &aShortName,
                                        SOFFICE_FILEFORMAT_60 );

                    // calc does this conversion itself except when object was
                    // copied to clipboard. In this case SomeData3 was filled before.
                    if( nFileFormat == SOT_FORMATSTR_ID_STARCALC_60 )
                    {
                        SchMemChart* pData = pChDoc->GetChartData();
                        if( pData &&
                            pData->SomeData3().Len() > 0 &&
                            (pData->GetChartRange().maRanges.size() == 0) )
                        {
                            pData->ConvertChartRangeForCalc( TRUE );
                        }
                    }
                    else if( nFileFormat == SOT_FORMATSTR_ID_STARWRITER_60 )
                        pChDoc->GetChartData()->ConvertChartRangeForWriter( TRUE );
                }
            }

			bRet = aFilter.Export();
		}
		else
		{
			DBG_ERROR( "SaveAs (XML): got no Storage in Medium!" );
		}
	}
	else		// binary format <= 5.0
	{
		pChDoc->PrepareAxisStorage();
		long nFileFormat = pStor->GetVersion();
		RTL_LOGFILE_CONTEXT_TRACE1 (context, "binary format %ld", nFileFormat);
		if(nFileFormat <= SOFFICE_FILEFORMAT_40 && pChDoc->IsReal3D())
		{
			pChDoc->PrepareOld3DStorage();
			CHART_TRACE( "Fileformat 4.0" );
		}

		bRet = SfxInPlaceObject::SaveAs( pStor );
		SfxStatusBarManager* pStbMgr =
			(GetCreateMode() == SFX_CREATE_MODE_EMBEDDED) ?
			NULL : SFX_APP()->GetStatusBarManager();
		if (pStbMgr)
			pStbMgr->StartProgressMode(SchResId(STR_SAVE_DOCUMENT), 100);

		// compressed or native format
		SvtSaveOptions							aOptions;
		const SvtSaveOptions::SaveGraphicsMode	eSaveMode( aOptions.GetSaveGraphicsMode() );
		const BOOL								bSaveNative = ( SvtSaveOptions::SaveGraphicsOriginal == eSaveMode );
		const BOOL								bSaveCompressed = ( bSaveNative || ( SvtSaveOptions::SaveGraphicsCompressed == eSaveMode ) );

		pChDoc->SetSaveCompressed( bSaveCompressed );
		pChDoc->SetSaveNative( bSaveNative );

		if (bRet)
		{
			pChDoc->PreSave();
			SvStorageStreamRef rPoolStream = pStor->OpenStream( SCH_STYLE_SHEET_NAME );
			rPoolStream->SetVersion( pStor->GetVersion ());

			SetWaitCursor( TRUE );

			if( ! rPoolStream->GetError())
			{
				rPoolStream->SetBufferSize(POOL_BUFFER_SIZE);
				GetPool().SetFileFormatVersion( (USHORT)pStor->GetVersion ());
				GetPool().Store( *rPoolStream );

				if( pStbMgr )
					pStbMgr->SetProgressState( 20 );

				// the style sheet pool uses next() and first() methods without resetting
				// the search mask (?) so it has to be done here
				GetStyleSheetPool()->SetSearchMask( SFX_STYLE_FAMILY_ALL );
				// FALSE = also save unused style sheets
				GetStyleSheetPool()->Store( *rPoolStream, FALSE );
				rPoolStream->SetBufferSize( 0 );

				if( pStbMgr )
					pStbMgr->SetProgressState( 50 );
			}
			else
				bRet = FALSE;

			if( bRet )
				bRet = rPoolStream->GetError() == 0;
			DBG_ASSERT( bRet, "Fehler beim Schreiben der Pools" );

			SvStorageStreamRef rDocumentStream = pStor->OpenStream( aStarChartDoc );
			rDocumentStream->SetVersion( pStor->GetVersion());
			GetPool().SetFileFormatVersion ( (USHORT)pStor->GetVersion ());

			if( ! rDocumentStream->GetError())
			{
                // old storage was XML format
                // always convert as internal storage is only the chart range
//                 if( bFormatChanges )
//                 {
                    // convert data structure from Calc/Writer to SomeData strings
                    SvPersist* pParent = GetParent();
                    if( pParent )
                    {
                        // determine which is parent application
                        SvGlobalName aGlobalName;
                        ULONG nFileFormat;
                        String aAppName, aFullName, aShortName;
                        pParent->FillClass( &aGlobalName, &nFileFormat,
                                            &aAppName, &aFullName, &aShortName,
                                            SOFFICE_FILEFORMAT_60 );

                        if( nFileFormat == SOT_FORMATSTR_ID_STARCALC_60 )
                            pChDoc->GetChartData()->ConvertChartRangeForCalc( FALSE );
                        else if( nFileFormat == SOT_FORMATSTR_ID_STARWRITER_60 )
                            pChDoc->GetChartData()->ConvertChartRangeForWriter( FALSE );
                    }
//                 }

                rDocumentStream->SetBufferSize( DOCUMENT_BUFFER_SIZE );
				rDocumentStream->SetKey( pStor->GetKey());	// set password
				*rDocumentStream << *pChDoc;
				rDocumentStream->SetBufferSize( 0 );
			}
			else bRet = FALSE;
			if( bRet )
				bRet = rDocumentStream->GetError() == 0;
			DBG_ASSERT( bRet, "Fehler beim Schreiben des Models" );

			// finished
			if( pStbMgr )
				pStbMgr->SetProgressState( 100 );

			SetWaitCursor( FALSE );

			pChDoc->PostSave();
		}

		if( pStbMgr )
			pStbMgr->EndProgressMode();

		if( nFileFormat <= SOFFICE_FILEFORMAT_40 && pChDoc->IsReal3D())
		{
			pChDoc->CleanupOld3DStorage();
		}
	}

	return bRet;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchChartDocShell::SaveCompleted( SvStorage * pStor ) throw()
{
	CHART_TRACE( "SchChartDocShell::SaveCompleted" );

	BOOL bRet = SfxInPlaceObject::SaveCompleted( pStor );

	if( bRet )
	{
	    if( pStor && pChDoc )
        {
            // #99758# SetChanged was called here which called SetModified().  I
            // removed this, since it is not clear why this was introduced in
            // rev. 1.48 (loading of files with additional graphics does not set
            // the modified flag to true)

            // throw away old graphics streams
		    pChDoc->HandsOff();
        }
	}
	return bRet;
}

/*************************************************************************
|*
|* Tabellenzeiger auffrischen
|*
\************************************************************************/
void SchChartDocShell::UpdateTablePointers() throw()
{
	PutItem(SvxColorTableItem(pChDoc->GetColorTable()));
	PutItem(SvxGradientListItem(pChDoc->GetGradientList()));
	PutItem(SvxHatchListItem(pChDoc->GetHatchList()));
	PutItem(SvxBitmapListItem(pChDoc->GetBitmapList()));
	PutItem(SvxDashListItem(pChDoc->GetDashList()));
	PutItem(SvxLineEndListItem(pChDoc->GetLineEndList()));

	if(pFontList)delete pFontList;

	if ( GetCreateMode() == SFX_CREATE_MODE_EMBEDDED && !pPrinter )
	{
		// OLE-Objekt: kein Printer anlegen
		pFontList = new FontList( Application::GetDefaultDevice(), NULL, FALSE );	// #67730#
	}
	else
	{
		pFontList = new FontList(GetPrinter(), NULL, FALSE);
	}

	SvxFontListItem aFontListItem(pFontList);
	PutItem(aFontListItem);

//	PutItem(SvxNumberInfoItem(pChDoc->GetNumFormatter()));
}

/*************************************************************************
|*
|* FillClass
|*
\************************************************************************/

void SchChartDocShell::FillClass(SvGlobalName* pClassName,
								 ULONG*  pFormat,
								 String* pAppName,
								 String* pFullTypeName,
								 String* pShortTypeName,
								 long    nFileFormat) const throw()
{
	SfxInPlaceObject::FillClass(pClassName, pFormat, pAppName, pFullTypeName,
								pShortTypeName, nFileFormat);

	if (nFileFormat == SOFFICE_FILEFORMAT_31)
	{
		*pClassName     = SvGlobalName(SO3_SCH_CLASSID_30);
		*pFormat        = SOT_FORMATSTR_ID_STARCHART;
		(*pAppName).AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Schart 3.1" ));
		*pFullTypeName  = String(SchResId(STR_CHART_DOCUMENT_FULLTYPE_31));
		*pShortTypeName = String(SchResId(STR_CHART_DOCUMENT));
	}
	else if (nFileFormat == SOFFICE_FILEFORMAT_40)
	{
		*pClassName     = SvGlobalName(SO3_SCH_CLASSID_40);
		*pFormat        = SOT_FORMATSTR_ID_STARCHART_40;
		*pFullTypeName  = String(SchResId(STR_CHART_DOCUMENT_FULLTYPE_40));
		*pShortTypeName = String(SchResId(STR_CHART_DOCUMENT));
	}
	else if (nFileFormat == SOFFICE_FILEFORMAT_50)
	{
		*pClassName		= SvGlobalName(SO3_SCH_CLASSID_50);
		*pFullTypeName  = String(SchResId(STR_CHART_DOCUMENT_FULLTYPE_50));
		*pShortTypeName = String(SchResId(STR_CHART_DOCUMENT));
	}
	else if (nFileFormat == SOFFICE_FILEFORMAT_60)
	{
		*pClassName		= SvGlobalName(SO3_SCH_CLASSID_60);
		*pFullTypeName  = String(SchResId(STR_CHART_DOCUMENT_FULLTYPE_60));
		*pShortTypeName = String(SchResId(STR_CHART_DOCUMENT));
	}
}

void SchChartDocShell::InPlaceActivate( BOOL b ) throw()
{
	if( pChDoc )
	{
		pChDoc->CatchUpBufferedData();
	}
	SfxInPlaceObject::InPlaceActivate( b );
}
