/*************************************************************************
 *
 *  $RCSfile: futransform.cxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 14:39:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "futransform.hxx"

// headers from chart
#include "schview.hxx"
#include "schresid.hxx"
#include "strings.hrc"
#include "chtmodel.hxx"
#include "schgroup.hxx"
#include "transform.hxx"

// headers from other dlls
#ifndef _E3D_POLYSC3D_HXX
#include <svx/polysc3d.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

TYPEINIT1( SchFuTransform, SchFuPoor );

SchFuTransform::SchFuTransform(
    SchViewShell* pViewShell, SchWindow* pWindow, SchView* pView,
    ChartModel* pModel, SfxRequest& rRequest ) :
        SchFuPoor( pViewShell, pWindow, pView, pModel, rRequest )
{
    if( pView->HasMarkedObj() )
    {
		// Undo
		String aString( pView->GetMarkDescription() );
		aString.Append( sal_Unicode(' ') );
		aString.Append( String( SchResId( STR_TRANSFORM ) ) );
		pView->BegUndo( aString );

		const SfxItemSet* pArgs = rRequest.GetArgs();

		if( NULL == pArgs )
		{
			// item set for size and position
			SfxItemSet aSet( pView->GetGeoAttrFromMarked() );
            aSet.DisableItem( SID_ATTR_TRANSFORM_PROTECT_POS );
            aSet.DisableItem( SID_ATTR_TRANSFORM_PROTECT_SIZE );

			const SdrMarkList& rMarkList = pView->GetMarkList();
			SdrObject* pObj = rMarkList.GetMark(0)->GetObj();

            bool bSizable = false;
            bool bRotatable = false;

            DBG_ASSERT( pObj, "Have Marked Object, but Object is NULL!" );

            UINT16 nObjId = CHOBJID_ANY;
            SchObjectId * pObjId = GetObjectId( *pObj );
            if( pObjId )
                nObjId = pObjId->GetObjId();

            if( CHOBJID_DIAGRAM == nObjId )
            {
                bSizable = true;
                bRotatable = ( TRUE == pChDoc->Is3DChart() );
            }

            SchTransformTabDialog* pDlg = new SchTransformTabDialog( NULL, &aSet, pView, bSizable, bRotatable );

            if( pDlg->Execute() == RET_OK )
            {
                rRequest.Done( *( pDlg->GetOutputItemSet() ) );
                pArgs = rRequest.GetArgs();
            }
            else
            {
                delete pDlg;
                pView->EndUndo();
                return; // RETURN
            }
            delete( pDlg );
        }
        // we get here only if the user pressed OK

        // apply changed attributes
        pView->SetGeoAttrToMarked( *pArgs );
		pView->SetAttributes( *pArgs );

        // do some special handling, so everything remains consistent
        NotifyChangeToModel();

        pView->EndUndo();        
    }
}

SchFuTransform::~SchFuTransform()
{}


/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void SchFuTransform::Activate()
{
	SchFuPoor::Activate();
}

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

void SchFuTransform::Deactivate()
{
	SchFuPoor::Deactivate();
}


/*************************************************************************
|*
|* Function ResizeObject
|*
\************************************************************************/

Point SchFuTransform::GetPoint( Rectangle aRect, RECT_POINT eRP )
{
    switch( eRP )
	{
		case RP_LT: return Point( aRect.Left(), aRect.Top() );
		case RP_MT: return Point( aRect.Center().X(), aRect.Top() );
		case RP_RT: return Point( aRect.Right(), aRect.Top() );
		case RP_LM: return Point( aRect.Left(), aRect.Center().Y() );
		case RP_MM: return Point( aRect.Center().X(), aRect.Center().Y() );
		case RP_RM: return Point( aRect.Right(), aRect.Center().Y() );
		case RP_LB: return Point( aRect.Left(), aRect.Bottom() );
		case RP_MB: return Point( aRect.Center().X(), aRect.Bottom() );
		case RP_RB: return Point( aRect.Right(), aRect.Bottom() );
	}
    return Point( 0, 0 );
}

void SchFuTransform::NotifyChangeToModel()
{
    // get currently marked object
    SdrObject* pObj = NULL;
    if( pView )
    {
        const SdrMarkList & rMarkList = pView->GetMarkList();
        if( rMarkList.GetMarkCount() > 0 )
            pObj = rMarkList.GetMark( 0 )->GetObj();
    }

    if( NULL != pObj )
    {
        // special handling for E3dPolyScene objects
        if( pObj->ISA( E3dPolyScene ))
        {
            static_cast< E3dPolyScene* >( pObj )->FitSnapRectToBoundVol();
        }

        // special handling for chart objects
        SchObjectId * pObjId = GetObjectId( *pObj );
        if( pObjId && pChDoc )
        {
            pChDoc->SetUseRelativePositions( TRUE );
            if( pObj->ISA( SchObjGroup ) )
            {
                SchObjGroup* pGrp = static_cast< SchObjGroup* >( pObj );
                pGrp->SetGroupMoved( TRUE );
                if( SchObjGroup::DIAGRAM == pGrp->GetGroupType())
                {
                    pChDoc->BuildChart( FALSE );
                    // remark diagram object
                    SdrPageView* pPV  = pView->GetPageViewPvNum( 0 );
                    pView->MarkObj( GetObjWithId( CHOBJID_DIAGRAM, *pChDoc->GetPage( 0 ), 0, IM_DEEPWITHGROUPS ), pPV );
                }
            }
            else if( pObj->ISA( SdrTextObj ))
            {
                pChDoc->SetHasBeenMoved( pObjId->GetObjId(), TRUE );
            }
        }
    }
}
