/*************************************************************************
 *
 *  $RCSfile: schview.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: bm $ $Date: 2001/11/26 16:24:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _SOT_EXCHANGE_HXX //autogen
#include <sot/exchange.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SOT_FORMATS_HXX //autogen
#include <sot/formats.hxx>
#endif
#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SVDOOLE2_HXX //autogen
#include <svx/svdoole2.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif
#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif
#ifndef _STRING_HXX //autogen wg. String
#include <tools/string.hxx>
#endif
// header for class INetURLObject
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
// header for class Svx3DChildWindow
#ifndef _SVX_F3DCHILD_HXX
#include <svx/f3dchild.hxx>
#endif

#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS

#include "schview.hxx"
#include "schmod.hxx"
#include "schresid.hxx"
#include "chwindow.hxx"
#include "docshell.hxx"
#include "objid.hxx"
#include "datarow.hxx"
#include "datapoin.hxx"
#include "uninstit.hxx"
#include "uninsleg.hxx"
#include "unmultdp.hxx"
#include "viewshel.hxx"
#include "strings.hrc"
#include "glob.hrc"
#include "schgroup.hxx"
#include "eetext.hxx"
#include "docshell.hxx"
#include "viewshel.hxx"
#include "chaxis.hxx"
#include "axisobj.hxx"
#include "memchrt.hxx"
#include "SchTransferable.hxx"

using namespace com::sun::star;
using namespace com::sun::star::uno;

/*************************************************************************
|*
|* Konstruktor 1
|*
\************************************************************************/

SchView::SchView(SchChartDocShell* pDocShell,
				 OutputDevice* pOutDev,
				 SchViewShell* pViewShell)
  : E3dView(&pDocShell->GetDoc(), pOutDev),
	pDoc(&pDocShell->GetDoc()),
	pDocSh(pDocShell),
	pViewSh(pViewShell),
	bDragActive (FALSE),
	nLogicalMarked(FALSE),
	nLogicalEntered(FALSE)
{
	Construct();
}

/*************************************************************************
|*
|* Konstruktor 2
|*
\************************************************************************/

SchView::SchView(ChartModel* pDocument,
				 OutputDevice* pOutDev)
  : E3dView(pDocument, pOutDev),
	pDoc(pDocument),
	pDocSh(NULL),
	pViewSh(NULL),
	bDragActive (FALSE),
	nLogicalMarked(FALSE),
	nLogicalEntered(FALSE)
{
	Construct();
}

/*************************************************************************
|*
|* Construct
|*
\************************************************************************/

void SchView::Construct()
{
	SetUseIncompatiblePathCreateInterface(TRUE);

	OutputDevice* pOut = GetWin(0);

	if( pOut )
		SetMinMoveDistancePixel( (USHORT)pOut->PixelToLogic( Size( 2, 0 )).Width());

	SetHitTolerancePixel (2);
	EnableExtendedKeyInputDispatcher (FALSE);
	EnableExtendedMouseEventDispatcher (FALSE);
	EnableExtendedCommandEventDispatcher (FALSE);
	bBordVisible = FALSE;

	if (pDocSh && pDocSh->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED)
		bPageVisible = FALSE;

	bGlueVisible  =
	bGlueVisible2 =
	bGlueVisible3 = TRUE;
	SetCurrentObj(OBJ_RECT, SdrInventor);

	if (pDoc->GetPageCount() == 0L)
	{
		// Seite einfuegen
		BOOL bChanged = pDoc->IsChanged();
		SdrPage* pPage = pDoc->AllocPage(FALSE);

		if (pDocSh)
			pPage->SetSize(pDocSh->GetVisArea(ASPECT_CONTENT).GetSize());

		pDoc->InsertPage(pPage);
		pDoc->BuildChart(FALSE);
		pDoc->SetChanged(bChanged);
	}
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchView::~SchView()
{
    // release content of selection clipboard, if we own the content
    UpdateSelectionClipboard( TRUE );

	aTimer.Stop();
	for (USHORT nWin = 0; nWin < GetWinCount(); nWin++)
	{
		OutputDevice* pOutDev = GetWin(nWin);

		if (pOutDev->GetOutDevType() == OUTDEV_WINDOW)
			DelWin((SchWindow*)pOutDev);
	}
}

/*************************************************************************
|*
|* virtuelle Methode von SdrView, der die anfallenden Undo-Aktionen
|* uebergeben werden
|*
\************************************************************************/

BOOL SchView::NotifyNewUndoAction()
{
	return TRUE;
}

/*************************************************************************
|*
|* virtuelle Methode von SdrView, wird bei Selektionsaenderung gerufen
|*
\************************************************************************/

void SchView::MarkListHasChanged()
{
	E3dView::MarkListHasChanged();
	if ( pViewSh )
		pViewSh->SelectionHasChanged();

	aTimer.SetTimeoutHdl( LINK( this, SchView, NotifySelection) );
	// Timer reset
	aTimer.SetTimeout(100);
	aTimer.Start();
}

/*************************************************************************
|*
|* Entfernt Chart-Userdaten
|*
\************************************************************************/

void SchView::DeleteChartUserData(ChartModel& rDoc)
{
	SdrPage* pPage = rDoc.GetPage(0);
	DBG_ASSERT(pPage, "Keine Seite vorhanden!");

	SdrObjListIter aIterator(*pPage, IM_DEEPWITHGROUPS);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();

		USHORT nPos = 0;

		do
		{
			SdrObjUserData *pData = pObj->GetUserData(nPos);

			if (pData)
				switch (pData->GetId())
				{
					case SCH_LIGHTFACTOR_ID:
						DBG_ERROR("SCH_LIGHTFACTOR_ID ist im Chart abgeschafft!");
					case SCH_OBJECTID_ID:
					case SCH_OBJECTADJUST_ID:
					case SCH_DATAROW_ID:
					case SCH_DATAPOINT_ID:
						pObj->DeleteUserData(nPos);
						break;

					default:
						nPos++;
						break;
				}
				else
				nPos++;
		}
		while (nPos < pObj->GetUserDataCount());
	}
}

/*************************************************************************
|*
|* Cut object to clipboard
|*
\************************************************************************/

BOOL SchView::DoCut(Window* pWindow)
{
	const OutlinerView* pOLV = GetTextEditOutlinerView();

	if( pDocSh->IsReadOnly())
		return FALSE;

	if( pOLV )
		((OutlinerView*)pOLV)->Cut();
	else if( HasMarkedObj() && CanDeleteMarkedObjects())
	{
		BrkAction();

		DoCopy();
		DeleteMarkedObjects( String( SchResId( STR_UNDO_CUT )));
	}
	else
		return FALSE;

	return TRUE;
}

/*************************************************************************
|*
|* Copy object to clipboard
|*
\************************************************************************/

void SchView::DoCopy(Window* pWindow)
{
	const OutlinerView* pOLV = GetTextEditOutlinerView();

	if( pOLV )
		( (OutlinerView*) pOLV)->Copy();
	else if( HasMarkedObj())
	{
		BrkAction();
		CreateClipboardDataObject();
	}
}

/*************************************************************************
|*
|* Paste object from clipboard
|*
\************************************************************************/

void SchView::DoPaste(Window* pWindow)
{
	if( pDocSh->IsReadOnly())
		return;

	const OutlinerView* pOLV = GetTextEditOutlinerView();

	if( pOLV )
	{
		((OutlinerView*)pOLV)->PasteSpecial();
	}
	else
	{
		Point aPos;
		SchTransferable* pTransferClip = SCH_MOD1()->GetClipboardTransferable();

		if( pWindow )
			aPos = pWindow->PixelToLogic( Rectangle( aPos, pWindow->GetOutputSizePixel()).Center());

		if( pTransferClip )
		{
			TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( pWindow ));

			if( aDataHelper.GetTransferable().is())
				InsertData( aDataHelper, aPos, DND_ACTION_COPY, FALSE );
		}
	}
}

/*************************************************************************
|*
|* Texteingabe beginnen
|*
\************************************************************************/

FASTBOOL SchView::BegTextEdit(SdrObject* pObj, SdrPageView* pPV, Window* pWin,
							  FASTBOOL bIsNewObj, SdrOutliner* pGivenOutliner,
							  OutlinerView* pGivenOutlinerView,
							  FASTBOOL bDontDeleteOutliner,
							  FASTBOOL bOnlyOneView)
{
	BOOL bReturn =
				E3dView::BegTextEdit(pObj, pPV, pWin, bIsNewObj, pGivenOutliner,
							 pGivenOutlinerView, bDontDeleteOutliner,
							 bOnlyOneView);

	if (bReturn)
	{
		// set undo manager at topmost shell ( SdDrawTextObjectBar )
		SdrOutliner* pOutliner = GetTextEditOutliner();
		if( pViewSh )
			pViewSh->GetViewFrame()->GetDispatcher()->GetShell( 0 )->
				SetUndoManager(&pOutliner->GetUndoManager());
	}

	return bReturn;
}

/*************************************************************************
|*
|* Texteingabe beenden
|*
\************************************************************************/

SdrEndTextEditKind SchView::EndTextEdit()
{
	SdrEndTextEditKind eKind = E3dView::EndTextEdit( TRUE );

	// UndoManager an der obersten Shell setzen
	SchChartDocShell* pDocShell = (SchChartDocShell*)pDoc->GetObjectShell();
	SfxUndoManager* pUndoMgr = pDocShell->GetUndoManager();

	SfxShell* pTopMostShell = NULL;
	if( pViewSh )
		pTopMostShell = pViewSh->GetViewFrame()->GetDispatcher()->GetShell( 0 );

	if( pTopMostShell->ISA( SchViewShell ))
	{
		pTopMostShell->SetUndoManager( pUndoMgr );
	}
	Window& rWin = (Window&)(*GetWin( 0 ));
	Rectangle aAll = Rectangle( 0, 0, 0, 0 );
	aAll.SetSize( rWin.GetOutputSize() );
	MakeVisible( aAll, rWin );

	return eKind;
}

/*************************************************************************
|*
|* Ermittelt, ob Chart-Objekt selektiert ist
|*
\************************************************************************/

BOOL SchView::IsChartObjSelected()
{
	if (HasMarkedObj())
	{
		ULONG nCount = aMark.GetMarkCount();

		for (ULONG i = 0; i < nCount; i++)
			if (GetObjectId(*aMark.GetMark(i)->GetObj()))
				return TRUE;
	}

	return FALSE;
}

/*************************************************************************
|*
|* Prueft, ob Objekte geloescht werden koennen
|*
\************************************************************************/

BOOL SchView::CanDeleteMarkedObjects()
{

	if(pDocSh->IsReadOnly())return FALSE;
	if (HasMarkedObj())
	{
		ULONG nCount = aMark.GetMarkCount();

		for (ULONG i = 0; i < nCount; i++)
		{
			SchObjectId* pId = GetObjectId(*aMark.GetMark(i)->GetObj());
			if (pId)
			{
				if (nCount > 1)
					return FALSE;

				switch (pId->GetObjId())
				{
					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					case CHOBJID_LEGEND:
						return TRUE;

					default:
						return FALSE;
				}
			}
		}
	}

	return TRUE;
}

/*************************************************************************
|*
|* Loescht ggf. markierte Objekte;
|* Liefert FALSE, wenn ein markiertes Chart-Objekt nicht geloescht
|* werden konnte.
|*
\************************************************************************/

BOOL SchView::DeleteMarkedObjects(const String& rUndoStr)
{
	if(pDocSh->IsReadOnly())return FALSE;
	if (HasMarkedObj())
	{
		ULONG nCount = aMark.GetMarkCount();

		for (ULONG i = 0; i < nCount; i++)
		{
			SchObjectId* pId = GetObjectId(*aMark.GetMark(i)->GetObj());
			if (pId)
			{
				if (nCount > 1)
					return FALSE;

				UINT16 nId = pId->GetObjId();

				switch (nId)
				{
					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					{
						BOOL bOldShowMain   = pDoc->ShowMainTitle();
						String aOldMain     = pDoc->MainTitle();
						BOOL bOldShowSub    = pDoc->ShowSubTitle();
						String aOldSub      = pDoc->SubTitle();
						BOOL bOldShowXAxis  = pDoc->ShowXAxisTitle();
						String aOldXAxis    = pDoc->XAxisTitle();
						BOOL bOldShowYAxis  = pDoc->ShowYAxisTitle();
						String aOldYAxis    = pDoc->YAxisTitle();
						BOOL bOldShowZAxis  = pDoc->ShowZAxisTitle();
						String aOldZAxis    = pDoc->ZAxisTitle();

						BOOL bNewShowMain	= (nId == CHOBJID_TITLE_MAIN) ?
											  FALSE : bOldShowMain;
						BOOL bNewShowSub	= (nId == CHOBJID_TITLE_SUB) ?
											  FALSE : bOldShowSub;
						BOOL bNewShowXAxis	= (nId == CHOBJID_DIAGRAM_TITLE_X_AXIS) ?
											  FALSE : bOldShowXAxis;
						BOOL bNewShowYAxis	= (nId == CHOBJID_DIAGRAM_TITLE_Y_AXIS) ?
											  FALSE : bOldShowYAxis;
						BOOL bNewShowZAxis	= (nId == CHOBJID_DIAGRAM_TITLE_Z_AXIS) ?
											  FALSE : bOldShowZAxis;

						pDoc->ChangeTitle(bNewShowMain, aOldMain,
											bNewShowSub, aOldSub,
											bNewShowXAxis, aOldXAxis,
											bNewShowYAxis, aOldYAxis,
											bNewShowZAxis, aOldZAxis);

						SchUndoInsertTitle* pUndo =
							new SchUndoInsertTitle(*pDoc, bOldShowMain,
												   aOldMain, bOldShowSub,
												   aOldSub, bOldShowXAxis,
												   aOldXAxis, bOldShowYAxis,
												   aOldYAxis, bOldShowZAxis,
												   aOldZAxis,
												   bNewShowMain, aOldMain,
												   bNewShowSub, aOldSub,
												   bNewShowXAxis, aOldXAxis,
												   bNewShowYAxis, aOldYAxis,
												   bNewShowZAxis, aOldZAxis);
						pUndo->SetComment(rUndoStr);

						pDoc->GetObjectShell()->
							GetUndoManager()->AddUndoAction(pUndo);
						return TRUE;
					}

					case CHOBJID_LEGEND:
					{
						SfxItemSet aAttr = pDoc->GetLegendAttr();
						const SfxPoolItem *pPoolItem = NULL;
						BOOL bVisible = pDoc->GetShowLegend ();
						SvxChartLegendPos eOldPos =	(aAttr.GetItemState(SCHATTR_LEGEND_POS,
																		TRUE, &pPoolItem) == SFX_ITEM_SET)
														? ((const SvxChartLegendPosItem*)pPoolItem)->GetValue()
														: CHLEGEND_NONE;
						aAttr.Put(SvxChartLegendPosItem(CHLEGEND_NONE));
						pDoc->SetShowLegend (FALSE);
						pDoc->ChangeLegendAttr(aAttr);//, TRUE);
						SchUndoInsertLegend* pUndo = new SchUndoInsertLegend(*pDoc, eOldPos, CHLEGEND_NONE,
																			 bVisible, FALSE);
						pUndo->SetComment(rUndoStr);

						pDoc->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
						return TRUE;
					}

					default:
						return FALSE;
				}
			}
		}

		BegUndo(rUndoStr);
		DeleteMarked();
		EndUndo();
	}

	return TRUE;
}

/*************************************************************************
|*
|* Ermittelt, ob Daten-Reihen/Punkt-Attribute gesetzt werden koennen
|*
\************************************************************************/

BOOL SchView::CanSetDataAttr()
{
	if (HasMarkedObj() && aMark.GetMarkCount() == 1)
	{
		SdrObject* pObj = aMark.GetMark(0)->GetObj();

		return GetDataRow(*pObj) || GetDataPoint(*pObj);
	}

	return FALSE;
}

/*************************************************************************
|*
|* Verschiebt die markierten Objekte an den angegebenen Objekt-Index
|*
\************************************************************************/

void SchView::PutMarkedToPos(ULONG nObjPos)
{
	if (HasMarkedObj())
	{
		ULONG nCount = aMark.GetMarkCount();

		for (ULONG i = 0; i < nCount; i++)
		{
			SdrObject*	pObj = aMark.GetMark(i)->GetObj();
			SdrObjList* pList = pObj->GetObjList();
			DBG_ASSERT(pList, "Objekt ist in keiner Liste");
			pList->SetObjectOrdNum(pObj->GetOrdNum(), nObjPos++);
			MarkListHasChanged();
		}
	}
}

/*************************************************************************
|*
|* Verschiebt die markierten Objekte um eine Indexposition zum
|* angegebenen Objekt-Index
|*
\************************************************************************/

void SchView::MovMarkedToPos(ULONG nObjPos)
{
	if (HasMarkedObj())
	{
		ULONG nCount = aMark.GetMarkCount();

		for (ULONG i = 0; i < nCount; i++)
		{
			SdrObject*	pObj = aMark.GetMark(i)->GetObj();
			SdrObjList* pList = pObj->GetObjList();
			DBG_ASSERT(pList, "Objekt ist in keiner Liste");
			ULONG nIndex = pObj->GetOrdNum();
			if (nIndex	> nObjPos)
			{
				pList->SetObjectOrdNum(pObj->GetOrdNum(), nIndex - 1);
				MarkListHasChanged();
			}
			else if (nIndex < nObjPos)
			{
				pList->SetObjectOrdNum(pObj->GetOrdNum(), nIndex + 1);
				MarkListHasChanged();
			}
		}
	}
}

/*************************************************************************
|*
|* Kontext-String fuer Statusbar
|*
\************************************************************************/

String SchView::GetContext()
{
	SdrObject	 *pObj  = NULL;
	SchDataRow	 *pRow  = NULL;
	SchDataPoint *pPoint= NULL;

	long nSubRow=-1;
	String aResult( SchResId( STR_MARKED ));

	if (HasMarkedObj())
	{
		ULONG nCount = aMark.GetMarkCount();
		if (nCount >= 1)//>=, da im 3D alle Unterobjekte markiert
		{
			pObj=aMark.GetMark(0)->GetObj();
			SchObjectId* pId = GetObjectId(*pObj);
			if (pId)
			{
				USHORT nId;

				switch (pId->GetObjId())
				{
					case CHOBJID_DIAGRAM_AREA:
						nId = STR_DIAGRAM_AREA;
						break;

					case CHOBJID_TITLE_MAIN:
						nId = STR_TITLE_MAIN;
						break;;

					case CHOBJID_TITLE_SUB:
						nId = STR_TITLE_SUB;
						break;

					case CHOBJID_DIAGRAM:
						nId = STR_DIAGRAM;
						break;

					case CHOBJID_DIAGRAM_WALL:
						nId = STR_DIAGRAM_WALL;
						break;

					case CHOBJID_DIAGRAM_FLOOR:
						nId = STR_DIAGRAM_FLOOR;
						break;

					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
						nId = STR_DIAGRAM_TITLE_X_AXIS;
						break;

					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
						nId = STR_DIAGRAM_TITLE_Y_AXIS;
						break;

					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
						nId = STR_DIAGRAM_TITLE_Z_AXIS;
						break;

					case CHOBJID_DIAGRAM_A_AXIS:
					case CHOBJID_DIAGRAM_X_AXIS:
						nId = STR_DIAGRAM_X_AXIS;
						break;

					case CHOBJID_DIAGRAM_B_AXIS:
					case CHOBJID_DIAGRAM_Y_AXIS:
						nId = STR_DIAGRAM_Y_AXIS;
						break;

					case CHOBJID_DIAGRAM_C_AXIS:
					case CHOBJID_DIAGRAM_Z_AXIS:
						nId = STR_DIAGRAM_Z_AXIS;
						break;

					case CHOBJID_DIAGRAM_X_GRID_MAIN:
						nId = STR_DIAGRAM_X_GRID_MAIN;
						break;

					case CHOBJID_DIAGRAM_Y_GRID_MAIN:
						nId = STR_DIAGRAM_Y_GRID_MAIN;
						break;

					case CHOBJID_DIAGRAM_Z_GRID_MAIN:
						nId = STR_DIAGRAM_Z_GRID_MAIN;
						break;

					case CHOBJID_DIAGRAM_X_GRID_HELP:
						nId = STR_DIAGRAM_X_GRID_HELP;
						break;

					case CHOBJID_DIAGRAM_Y_GRID_HELP:
						nId = STR_DIAGRAM_Y_GRID_HELP;
						break;

					case CHOBJID_DIAGRAM_Z_GRID_HELP:
						nId = STR_DIAGRAM_Z_GRID_HELP;
						break;

					case CHOBJID_DIAGRAM_ROWGROUP:
					case CHOBJID_DIAGRAM_ROWS:
					case CHOBJID_DIAGRAM_ROWSLINE:
					case CHOBJID_DIAGRAM_SPECIAL_GROUP:
					case CHOBJID_DIAGRAM_STACKEDGROUP:
						pRow = GetDataRow(*pObj);
						if(!pRow)
						{
							pPoint  = GetDataPoint(*pObj);
							nSubRow = pPoint->GetRow();
							pPoint  = NULL;
						}
						nId = STR_DIAGRAM_ROW;
						break;

					case CHOBJID_DIAGRAM_DATA:
						nId    = STR_STATUS_DATAPOINT_MARKED;
						pPoint = GetDataPoint(*pObj);
						break;

					case CHOBJID_DIAGRAM_DESCRGROUP:
						nId = STR_DIAGRAM_DESCRGROUP;
						break;

					case CHOBJID_DIAGRAM_DESCR_ROW:
						nId = STR_DIAGRAM_DESCR_ROW;
						break;

					case CHOBJID_DIAGRAM_DESCR_COL:
						nId = STR_DIAGRAM_DESCR_COL;
						break;

					case CHOBJID_LEGEND:
						nId = STR_LEGEND;
						break;

					case CHOBJID_LEGEND_SYMBOL_ROW:
						nId = STR_LEGEND_SYMBOL_ROW;
						//pRow = GetDataRow(*pObj);
						break;

					case CHOBJID_LEGEND_SYMBOL_COL:
						nId = STR_LEGEND_SYMBOL_COL;
						break;

					default:
						nId = 0;
						break;
				}

				if (nId != 0)
				{
					if(pRow)
					{
						SchResId aSchResId(nId);
						String aStrObj( aSchResId );
						aStrObj.SearchAndReplaceAscii( "$(ROW)", String::CreateFromInt32( pRow->GetRow() + 1 ));
						aResult.SearchAndReplaceAscii( "$(OBJ)", aStrObj);
						return aResult;
					}
					else if(nSubRow!=-1) //3D-Unterobjekte
					{
						SchResId aSchResId(nId);
						String aStrObj( aSchResId );
						aStrObj.SearchAndReplaceAscii( "$(ROW)", String::CreateFromInt32( nSubRow + 1 ));
						aResult.SearchAndReplaceAscii( "$(OBJ)", aStrObj);
						return aResult;
					}
					if(pPoint)
					{
						long nCol=pPoint->GetCol();
						long nRow=pPoint->GetRow();
						String aText;
						long nUId=((const SfxInt32Item&)pDoc->GetDataRowAttr(nRow).Get(SCHATTR_AXIS)).GetValue();
						ChartAxis *pAxis=pDoc->GetAxisByUID(nUId);
						long nNumf=pAxis->GetNumFormat(FALSE);

						Color* pDummy = NULL;
						pDoc->GetNumFormatter()->GetOutputString(
							pDoc->GetData(nCol,nRow),nNumf,aText,&pDummy);

						aResult = String( SchResId( STR_STATUS_DATAPOINT_MARKED ));
						aResult.SearchAndReplaceAscii( "$(PT_NUM)",  String::CreateFromInt32( nCol + 1 ) );
						aResult.SearchAndReplaceAscii( "$(ROW_NUM)", String::CreateFromInt32( nRow + 1 ) );
						aResult.SearchAndReplaceAscii( "$(VALUE)",   aText );

						return  aResult;
					}

					aResult.SearchAndReplaceAscii( "$(OBJ)", String( SchResId( nId )) );
					return  aResult;
				}
			}
		}
	}

	return E3dView::GetStatusText();
}

/*************************************************************************
|*
|* Kontext-Typ-String fuer Statusbar
|*
\************************************************************************/

String SchView::GetContextType()
{
	USHORT nDimId, nTypeId, nVariantId;
	String aString;

	switch (pDoc->ChartStyle())
	{
		case CHSTYLE_2D_LINE:
			nDimId		= STR_2D;
			nTypeId		= STR_LINES;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_2D_STACKEDLINE:
			nDimId		= STR_2D;
			nTypeId		= STR_LINES;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_2D_PERCENTLINE:
			nDimId		= STR_2D;
			nTypeId		= STR_LINES;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_2D_COLUMN:
			nDimId		= STR_2D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_2D_STACKEDCOLUMN:
			nDimId		= STR_2D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_2D_PERCENTCOLUMN:
			nDimId		= STR_2D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_2D_BAR:
			nDimId		= STR_2D;
			nTypeId		= STR_BARS;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_2D_STACKEDBAR:
			nDimId		= STR_2D;
			nTypeId		= STR_BARS;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_2D_PERCENTBAR:
			nDimId		= STR_2D;
			nTypeId		= STR_BARS;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_2D_AREA:
			nDimId		= STR_2D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_2D_STACKEDAREA:
			nDimId		= STR_2D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_2D_PERCENTAREA:
			nDimId		= STR_2D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_2D_PIE:
			nDimId		= STR_2D;
			nTypeId		= STR_CIRCLES;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_3D_STRIPE:
			nDimId		= STR_3D;
			nTypeId		= STR_LINES;
			nVariantId	= STR_DEEP;
			break;

		case CHSTYLE_3D_COLUMN:
			nDimId		= STR_3D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_DEEP;
			break;

		case CHSTYLE_3D_FLATCOLUMN:
			nDimId		= STR_3D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_NORMAL;
			break;

		case CHSTYLE_3D_STACKEDFLATCOLUMN:
			nDimId		= STR_3D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_3D_PERCENTFLATCOLUMN:
			nDimId		= STR_3D;
			nTypeId		= STR_COLUMNS;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_3D_AREA:
			nDimId		= STR_3D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_DEEP;
			break;

		case CHSTYLE_3D_STACKEDAREA:
			nDimId		= STR_3D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_STACKED;
			break;

		case CHSTYLE_3D_PERCENTAREA:
			nDimId		= STR_3D;
			nTypeId		= STR_AREAS;
			nVariantId	= STR_PERCENT;
			break;

		case CHSTYLE_3D_PIE:
			nDimId		= STR_3D;
			nTypeId		= STR_CIRCLES;
			nVariantId	= STR_NORMAL;
			break;

		default:
			return aString;
	}

	aString += String(SchResId(nDimId));
	aString += String(SchResId(nTypeId));
	aString += sal_Unicode( ' ' );
	aString += String(SchResId(nVariantId));

	return aString;
}

/*************************************************************************
|*
|* DragServer starten
|*
\************************************************************************/

BOOL SchView::BeginDrag( Window* pWindow, Point aStartPos )
{
	BOOL bReturn = FALSE;

	if( HasMarkedObj())
	{
		BrkAction();

		SdrMarkList aMarkList( GetMarkList());

//  		BegUndo( String( SchResId( STR_UNDO_DRAGDROP )));
		CreateDragDropDataObject( this, *pWindow, aStartPos );
	}

	return bReturn;
}

BOOL SchView::InsertGraphic( const Graphic& rGraphic, const Point& rPos )
{
	/**********************************************************************
	* Es wird ein neues Objekt erzeugt
	**********************************************************************/
	const SdrPage*	pPage = GetPageViewPvNum( 0 )->GetPage();
	const MapMode	aMap100( MAP_100TH_MM );
	Size			aPageSize( pPage->GetSize() );
	Size			aSize;

	// Falls der PrefMapMode der Graphic MAP_PIXEL ist,
	// machen wir die logische Umrechnung ueber das Fenster,
	// um eine 1:1-Abbildung auf Pixel zu erreichen
	OutputDevice* pOut = GetWin( 0 );
	if( pOut && rGraphic.GetPrefMapMode().GetMapUnit() == MAP_PIXEL )
		aSize = pOut->PixelToLogic( rGraphic.GetPrefSize(), aMap100 );	// #67730#
	else
		aSize = OutputDevice::LogicToLogic( rGraphic.GetPrefSize(), rGraphic.GetPrefMapMode(), aMap100 );

	// Groesse ggf. auf Seitengroesse begrenzen
	aPageSize.Width() -= pPage->GetLftBorder() + pPage->GetRgtBorder();
	aPageSize.Height() -= pPage->GetUppBorder() + pPage->GetLwrBorder();

	// Falls Grafik zu gross, wird die Grafik
	// in die Seite eingepasst
	if ( aSize.Height() && aPageSize.Height() &&
		( aSize.Height() > aPageSize.Height() ) || ( aSize.Width()	> aPageSize.Width() ) )
	{
		double fGrfWH =	(double) aSize.Width() / aSize.Height();
		double fWinWH =	(double) aPageSize.Width() / aPageSize.Height();

		// Grafik an Pagesize anpassen (skaliert)
		if ( fGrfWH < fWinWH )
		{
			aSize.Width() = (long) ( aPageSize.Height() * fGrfWH );
			aSize.Height()= aPageSize.Height();
		}
		else if ( fGrfWH > 0. )
		{
			aSize.Width() = aPageSize.Width();
			aSize.Height()= (long) ( aPageSize.Width() / fGrfWH );
		}
	}

	const Point	aPos( rPos.X() - ( aSize.Width() >> 1 ), rPos.Y() - ( aSize.Height() >> 1 ) );

    LeaveAllGroup();
	InsertObject( new SdrGrafObj( rGraphic, Rectangle( aPos, aSize ) ),
				  *GetPageViewPvNum( 0 ), SDRINSERT_SETDEFLAYER );

	return TRUE;
}

void SchView::InvalidateOneWin(Window& rWin, const Rectangle& rRect)
{
	rWin.Invalidate(rRect);
}

long SchView::GetSelectedRow() const
{
	long nRow=-1;

	if (HasMarkedObj())
	{
		const SdrMarkList& rMarkList = GetMarkList();

		for (USHORT nMark = 0;
			 nMark < rMarkList.GetMarkCount();// && bResult;
			 nMark++)
		{
			SdrMark* pMark = rMarkList.GetMark( 0 );
			SdrObject* pObj = pMark->GetObj();
			SchDataRow *pRow=GetDataRow(*pObj);
			if(pRow)
				nRow=pRow->GetRow();
		}
	}
	return nRow;
}

/*************************************************************************
|*
|* SetDefault, die Datenpunktattribute der selektierten Datenreihe(n) loeschen
|*
\************************************************************************/

void SchView::SetDefault()
{
	CHART_TRACE( "Chart SchView::SetDefault Datenpunktattribute der selektierten Datenreihe(n) loeschen" );
	const SdrMarkList& rMarkList = GetMarkList();

	for (USHORT nMark = 0; nMark < rMarkList.GetMarkCount(); nMark++)
	{
		SdrMark* pMark = rMarkList.GetMark(0);
		SdrObject* pObj = pMark->GetObj();
		SchObjectId* pObjId = GetObjectId(*pObj);

		UINT16 nObjId = pObjId->GetObjId();

		if (nObjId == CHOBJID_DIAGRAM_ROWGROUP)
		{
			// das MUSS eine Gruppe sein
			SchObjGroup* pGroup = (SchObjGroup*)pObj;
			SdrObjList* pSubList = pObj->GetSubList();

			USHORT nSubCount = (USHORT)pSubList->GetObjCount();


			if (nSubCount)
			{
				// UndoAction erzeugen
				SchUndoMultipleDataPoints* pUndoAction =
					new SchUndoMultipleDataPoints(*pDoc);

				SvxChartStyle aStyle = GetDoc().ChartStyle();

				// keine Datenpunkt-Objekte im Drawing-Layer?
				if (aStyle == CHSTYLE_2D_LINE           ||
					aStyle == CHSTYLE_2D_STACKEDLINE    ||
					aStyle == CHSTYLE_2D_PERCENTLINE    ||
					aStyle == CHSTYLE_2D_AREA           ||
					aStyle == CHSTYLE_2D_STACKEDAREA    ||
					aStyle == CHSTYLE_2D_PERCENTAREA    ||
					aStyle == CHSTYLE_3D_STRIPE         ||
					aStyle == CHSTYLE_3D_AREA           ||
					aStyle == CHSTYLE_3D_STACKEDAREA    ||
					aStyle == CHSTYLE_3D_PERCENTAREA    ||
					aStyle == CHSTYLE_3D_SURFACE        ||
					aStyle == CHSTYLE_2D_NET            ||
					aStyle == CHSTYLE_2D_NET_STACK      ||
					aStyle == CHSTYLE_2D_NET_PERCENT    ||
					aStyle == CHSTYLE_2D_CUBIC_SPLINE   ||
					aStyle == CHSTYLE_2D_B_SPLINE       ||
					aStyle == CHSTYLE_2D_CUBIC_SPLINE_XY ||
					aStyle == CHSTYLE_2D_B_SPLINE_XY    ||
					aStyle == CHSTYLE_3D_COLUMN         ||
					aStyle == CHSTYLE_3D_BAR)
				{
					SdrObject* pRow = pSubList->GetObj(0);
					SchDataRow* pDataRow = GetDataRow(*pRow);
					short nRow = pDataRow->GetRow();

					long nColCount = GetDoc().GetColCount();
					for( long nCol = 0; nCol < nColCount; nCol++ )
					{
						// an der UndoAction registrieren
						pUndoAction->AddPoint((short)nCol, (short)nRow);

						SfxItemSet aSet(GetDoc().GetDataPointAttr(nCol, nRow));
						aSet.ClearItem();
						GetDoc().PutDataPointAttr(nCol, nRow, aSet,FALSE);
					}
				}
				else
				{
					for (USHORT nObj = 0; nObj < nSubCount; nObj++)
					{
						SdrObject* pPoint = pSubList->GetObj(nObj);
						SchDataPoint* pDataPoint = GetDataPoint(*pPoint);
						short nCol = pDataPoint->GetCol();
						short nRow = pDataPoint->GetRow();

						// an der UndoAction registrieren
						pUndoAction->AddPoint(nCol, nRow);

						SfxItemSet aSet(GetDoc().GetDataPointAttr(nCol, nRow));
						aSet.ClearItem();
							// nicht mergen, nicht BuildChart rufen
						GetDoc().ChangeDataPointAttr(aSet, *pPoint, FALSE, FALSE);
					}
				}

				// die neuen Attribute in der UndoAction speichern und die
				// Action dem UndoManager uebergeben
				pUndoAction->CopyNewAttributes();

				// get undo manager from topmost shell
				if( pViewSh )
				{
					SfxUndoManager* pUndoMgr =
						pViewSh->GetViewFrame()->GetDispatcher()->GetShell( 0 )->GetUndoManager();

					pUndoMgr->AddUndoAction( pUndoAction );
				}
			}
		}
	}
}


/*************************************************************************
|*
|* Markierungs-Handles setzen, ggf. logische 3D-Gruppen beruecksichtigen
|*
\************************************************************************/

void SchView::SetMarkHandles()
{
	SdrView::SetMarkHandles();

	SdrMark* pMark = aMark.GetMark(0);
	if( pMark )
	{
		SdrPageView* pPageView = pMark->GetPageView();
		if( pPageView )
		{
			SdrObject* pObj = pMark->GetObj();

			if( pObj->ISA( Sch3dAxisObj ) )
			{
				aHdl.Clear();
				pObj->AddToHdlList( aHdl );
			}
			else
			if( ( nLogicalMarked != 0 && aMark.GetMarkCount() == 1 ) && pObj->ISA(E3dObject) )
			{
				E3dObject* p3DObj = (E3dObject*) pObj;
				USHORT nGroup = p3DObj->GetLogicalGroup();

				if ( nGroup > 0 )
				{
					SdrObjListIter a3DIterator(*((SdrObject*) p3DObj->GetScene()),
											   IM_DEEPWITHGROUPS);

					while ( a3DIterator.IsMore() )
					{
						p3DObj = (E3dObject*) a3DIterator.Next();
						DBG_ASSERT(p3DObj->ISA(E3dObject), "In Szenen sind nur 3D-Objekte erlaubt!");
						
						if ( p3DObj != pObj && p3DObj->GetLogicalGroup() == nGroup )
							p3DObj->AddToHdlList(aHdl);
					}
				}
			}
		}
	}
}

/*************************************************************************
|*
|* logische Gruppe betreten
|*
\************************************************************************/

FASTBOOL SchView::EnterMarkedGroup()
{
	if ( nLogicalMarked != 0 )
	{
		nLogicalEntered = nLogicalMarked;
		nLogicalMarked = 0;
		UnmarkAll();
		return TRUE;
	}
	else
	{
		nLogicalEntered = 0;
		return SdrView::EnterMarkedGroup();
	}
}

/*************************************************************************
|*
|* logische Gruppe verlassen
|*
\************************************************************************/

void SchView::LeaveOneGroup()
{
	nLogicalMarked = 0;

	if ( nLogicalEntered != 0 )
		nLogicalEntered = 0;
	else
		SdrView::LeaveOneGroup();
}

/*************************************************************************
|*
|* alle Gruppen verlassen
|*
\************************************************************************/

void SchView::LeaveAllGroup()
{
	nLogicalMarked = 0;
	nLogicalEntered = 0;
	SdrView::LeaveAllGroup();
}


/*************************************************************************
|*
|* logische Gruppe markieren
|*
\************************************************************************/

void SchView::MarkLogicalGroup()
{
	if ( nLogicalEntered == 0 && aMark.GetMarkCount() == 1 )
	{
		SdrObject* pObj = aMark.GetMark(0)->GetObj();

		if ( pObj->ISA(E3dObject) )
			nLogicalMarked = ((E3dObject*) pObj)->GetLogicalGroup();

		if ( nLogicalMarked )
		{
			FASTBOOL bVis = bHdlShown;
			if ( bVis ) HideMarkHdl(NULL);
			CheckMarked();
			SetMarkRects();
			SetMarkHandles();
			if ( bVis ) ShowMarkHdl(NULL);
		}
	}
	else
		nLogicalMarked = 0;
}

/*************************************************************************
|*
|* Objekt an Position vorhanden?
|*
\************************************************************************/

FASTBOOL SchView::PickObj(const Point& rPnt, short nTol, SdrObject*& prObj,
					 SdrPageView*& prPV,ULONG nOptions) const
{
	FASTBOOL bRet = SdrView::PickObj(rPnt, nTol, prObj, prPV, nOptions);

	if ( bRet && nLogicalEntered != 0 && prObj->ISA(E3dObject) )
	{
		E3dObject* p3DObj = (E3dObject*&) prObj;
		E3dObject* pParent = p3DObj->GetParentObj();

		if ( p3DObj->GetLogicalGroup() != nLogicalEntered && pParent &&
			 pParent->GetLogicalGroup() != nLogicalEntered )
		{
			bRet = FALSE;
			prObj = NULL;
			prPV = NULL;
		}
	}
	return bRet;
}

/*************************************************************************
|*
|* markiertes Objekt (auch von logischer Gruppe) getroffen?
|*
\************************************************************************/

FASTBOOL SchView::IsMarkedHit(const Point& rPnt, short nTol) const
{
	FASTBOOL bRet = SdrView::IsMarkedHit(rPnt, nTol);

	// falls SvDraw kein Objekt gefunden hat, ggf. auch logische Gruppe pruefen
	if ( !bRet && nLogicalMarked != 0 )
	{
		SdrObject*	 pObj;
		SdrPageView* pPV;

		// wenn Objekt vorhanden und Gruppe uebereinstimmt -> TRUE
		if ( PickObj(rPnt, nTol, pObj, pPV) && pObj->ISA(E3dObject) &&
			((E3dObject*) pObj)->GetLogicalGroup() == nLogicalMarked )
			bRet = TRUE;
	}
	return bRet;
}

/*************************************************************************
|*
|* Liste der markierten Objekte einer logischen Gruppe zurueckgeben
|*
\************************************************************************/

E3dLogicalObjList SchView::GetLogicalObjList()
{
	E3dLogicalObjList aObjList;

	if ( nLogicalMarked != 0 && aMark.GetMarkCount() == 1 )
	{
		SdrMark*	pMark = aMark.GetMark(0);
		SdrObject*	pObj = pMark->GetObj();

		if ( pObj->ISA(E3dObject) )
		{
			E3dObject* p3DObj = (E3dObject*) pObj;
			USHORT nGroup = p3DObj->GetLogicalGroup();

			if ( nGroup > 0 )
			{
				SdrObjListIter a3DIterator(*((SdrObject*) p3DObj->GetScene()),
											IM_DEEPWITHGROUPS);

				while ( a3DIterator.IsMore() )
				{
					p3DObj = (E3dObject*) a3DIterator.Next();
					DBG_ASSERT(p3DObj->ISA(E3dObject), "In Szenen sind nur 3D-Objekte erlaubt!");

					if ( p3DObj != pObj && p3DObj->GetLogicalGroup() == nGroup )
						aObjList.Insert(p3DObj, LIST_APPEND);
				}
			}
		}
	}
	return aObjList;
}

IMPL_LINK(SchView,NotifySelection ,void*, EMPTYARG)
//void ::NotifySelection()
{
	SchMemChart* pMemChart = (SchMemChart*)pDoc->GetMemChart();
	if( pMemChart == NULL )
		return 0;

	ChartSelectionInfo aInfo;

	SdrObject	 *pObj  = NULL;
	SchDataRow	 *pRow  = NULL;
	SchDataPoint *pPoint= NULL;

	aInfo.nSelection=CHART_SEL_NONE;

	if (HasMarkedObj())
	{
		ULONG nCount = aMark.GetMarkCount();
		if (nCount == 1)
		{
			pObj=aMark.GetMark(0)->GetObj();
			SchObjectId* pId = GetObjectId(*pObj);
			if (pId)
			{
				switch (pId->GetObjId())
				{
					case CHOBJID_DIAGRAM_AREA:
					case CHOBJID_DIAGRAM:
						aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_ALL;
						break;

					case CHOBJID_LEGEND_SYMBOL_ROW:
					case CHOBJID_DIAGRAM_ROWGROUP:
					case CHOBJID_DIAGRAM_ROWS:
					case CHOBJID_DIAGRAM_ROWSLINE:
					case CHOBJID_DIAGRAM_SPECIAL_GROUP:
						{
							pRow=GetDataRow(*pObj);
							if(pRow)
							{
								if(!pDoc->IsDataSwitched())
								{
									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_ROW;
									aInfo.nRow=pRow->GetRow();
								}
								else
								{
									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_COL;
									aInfo.nCol=pRow->GetRow();
								}
							}
						}
						break;
					case CHOBJID_LEGEND_SYMBOL_COL:
					case CHOBJID_DIAGRAM_DATA:
						{
							pPoint=GetDataPoint(*pObj);
							if(pPoint)
							{
							/*	SfxItemSet aAttr=pDoc->GetDataRowAttr(pPoint->GetRow());
								aAttr.Put(pDoc->GetDataPointAttr(pPoint->GetCol(),pPoint->GetRow()));	*/
								if(!pDoc->IsDataSwitched())
								{
									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_POINT;
									aInfo.nCol=pPoint->GetCol();
									aInfo.nRow=pPoint->GetRow();
								}
								else
								{
									aInfo.nSelection=CHART_SEL_NONE | CHART_SEL_POINT;
									aInfo.nCol=pPoint->GetRow();
									aInfo.nRow=pPoint->GetCol();
								}
							}
						}
						break;

/*					case CHOBJID_DIAGRAM_DESCRGROUP:
					case CHOBJID_DIAGRAM_DESCR_ROW:
					case CHOBJID_DIAGRAM_DESCR_COL:
					case CHOBJID_LEGEND:

					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
					case CHOBJID_DIAGRAM_WALL:
					case CHOBJID_DIAGRAM_FLOOR:
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					case CHOBJID_DIAGRAM_X_AXIS:
					case CHOBJID_DIAGRAM_Y_AXIS:       sowie auch A,B,C:
					case CHOBJID_DIAGRAM_Z_AXIS:
					case CHOBJID_DIAGRAM_X_GRID_MAIN:
					case CHOBJID_DIAGRAM_Y_GRID_MAIN:
					case CHOBJID_DIAGRAM_Z_GRID_MAIN:
					case CHOBJID_DIAGRAM_X_GRID_HELP:
					case CHOBJID_DIAGRAM_Y_GRID_HELP:
					case CHOBJID_DIAGRAM_Z_GRID_HELP:*/
					default:
						break;
				}
			}
		}
	}
	pMemChart->SubmitSelection(aInfo);
	return 0;
}


// ********************************************************************************
//
//  Drag and Drop / Clipboard
//
// ********************************************************************************

// ========================================
// create transferable for drag&drop
// ========================================

Reference< datatransfer::XTransferable > SchView::CreateDragDropDataObject(
	SchView* pView, Window& rWindow, const Point& rDragPos )
{
	// create descriptor
	TransferableObjectDescriptor aObjDesc;

	aObjDesc.maSize = GetAllMarkedRect().GetSize();
	aObjDesc.maDragStartPos = rDragPos;
	aObjDesc.mbCanLink = FALSE;

	SchChartDocShell* pDocShell = (SchChartDocShell*)pDoc->GetObjectShell();
	if( pDocShell )
    {
        pDocShell->FillTransferableObjectDescriptor( aObjDesc );
		aObjDesc.maDisplayName = pDocShell->GetMedium()->GetURLObject().GetURLNoPass();
    }

	SchTransferable* pTransferable = new SchTransferable( NULL, pView, aObjDesc, sal_False );
	Reference< datatransfer::XTransferable > xRet( pTransferable );

	SCH_MOD1()->SetDragTransferable( pTransferable );

	pTransferable->StartDrag( &rWindow, DND_ACTION_COPYMOVE | DND_ACTION_LINK );

	return xRet;
}

// ========================================
// create transferable for clipboard
// ========================================

Reference< datatransfer::XTransferable > SchView::CreateClipboardDataObject()
{
	// create descriptor
	TransferableObjectDescriptor aObjDesc;
	const Rectangle aMarkRect = GetAllMarkedRect();

	aObjDesc.maSize = aMarkRect.GetSize();
	aObjDesc.mbCanLink = FALSE;

    SdrModel* pModel = GetMarkedObjModel();

	SchTransferable* pTransferable = new SchTransferable( pModel, NULL, aObjDesc, sal_False );
	Reference< datatransfer::XTransferable > xRet( pTransferable );

	SCH_MOD1()->SetClipboardTransferable( pTransferable );

	pTransferable->CopyToClipboard( GetWindow());

	return xRet;
}

// ========================================
// create transferable for selection clipboard
// ========================================

Reference< datatransfer::XTransferable > SchView::CreateSelectionDataObject( SchView* pWorkView, Window& rWindow )
{
	// create descriptor
	TransferableObjectDescriptor aObjDesc;
	const Rectangle aMarkRect = GetAllMarkedRect();

	aObjDesc.maSize = aMarkRect.GetSize();
	aObjDesc.mbCanLink = FALSE;

//    SdrModel* pModel = GetMarkedObjModel();

	SchTransferable* pTransferable = new SchTransferable( NULL, pWorkView, aObjDesc, sal_True );
	Reference< datatransfer::XTransferable > xRet( pTransferable );
	
	SCH_MOD1()->SetSelectionClipboardTransferable( pTransferable );

    pTransferable->CopyToSelection( &rWindow );

	return xRet;
}

void SchView::UpdateSelectionClipboard( BOOL bForceDeselect )
{
    if( pViewSh && pViewSh->GetWindow() )
    {
        if( ! bForceDeselect && GetMarkList().GetMarkCount() )
            CreateSelectionDataObject( this, *pViewSh->GetWindow() );
        else if( SCH_MOD1()->GetSelectionClipboardTransferable() &&
				 ( SCH_MOD1()->GetSelectionClipboardTransferable()->GetView() == this ) )
        {
            TransferableHelper::ClearSelection( pViewSh->GetWindow() );
            SCH_MOD1()->SetSelectionClipboardTransferable( NULL );
        }
    }
}

// ========================================
// drag action requested for this view
// ========================================

sal_Int8 SchView::AcceptDrop( const AcceptDropEvent& rEvt, SchWindow* pWin )
{
	sal_Int8 nRet = DND_ACTION_NONE;

	if( pDocSh->IsReadOnly())
		return nRet;

	SdrPageView* pPV = GetPageViewPvNum( 0 );

	if( ! pPV->IsLayerLocked( GetActiveLayer()) )
	{
		sal_Bool bIsInsideOutlinerView = sal_False;

		const OutlinerView* pOLV = GetTextEditOutlinerView();

		if( pOLV && pWin )
		{
			Rectangle aRect( pOLV->GetOutputArea() );

			Point aPos = pWin->PixelToLogic( rEvt.maPosPixel );

			if( aRect.IsInside( aPos ))
			{
				bIsInsideOutlinerView = sal_True;
			}
		}

		if( ! bIsInsideOutlinerView )
		{
			SchTransferable* pDragTransferable = SCH_MOD1()->GetDragTransferable();

			if( pDragTransferable )
			{
//  				const SchView* pSourceView = pDragTransferable->GetView();

//  				if( pSourceView )
//  				{
//  					if( !( rEvt.maDragEvent.DropAction & DND_ACTION_LINK ) ||
//  						pSourceView->GetDocShell()->GetMedium()->GetName().Len() )
//  						nRet = rEvt.maDragEvent.DropAction;
//  				}
			}
			// else: support of alien formats
		}
	}

	return nRet;
}

// ========================================
// drop an object into this view
// ========================================

sal_Int8 SchView::ExecuteDrop( const ExecuteDropEvent& rEvt, SchWindow* pWin )
{
	sal_Int8 nRet = DND_ACTION_NONE;

	if( pDocSh->IsReadOnly())
		return nRet;

	sal_Int8 nDropAction = rEvt.mnAction;
	SdrPageView* pPV = GetPageViewPvNum( 0 );

	if( ! pPV->IsLayerLocked( GetActiveLayer()))
	{
		const OutlinerView* pOLV = GetTextEditOutlinerView();
		sal_Bool bIsInsideOutlinerView = sal_False;

		if( pOLV && pWin )
		{
			Rectangle aRect( pOLV->GetOutputArea());
			Point aPos = pWin->PixelToLogic( rEvt.maPosPixel );

			if( aRect.IsInside( aPos ))
			{
				bIsInsideOutlinerView = sal_True;
			}
		}

		if( ! bIsInsideOutlinerView )
		{
			SchTransferable* pDragTransferable = SCH_MOD1()->GetDragTransferable();

			if( pDragTransferable )
			{
//  				const SchView* pSourceView = pDragTransferable->GetView();

//  				if( pSourceView )
//  				{
//  					if( !( nDropAction & DND_ACTION_LINK ) ||
//  						pSourceView->GetDocShell()->GetMedium()->GetName().Len() )
//  						nRet = nDropAction;
//  				}
			}
			// else: support of alien formats
		}
	}

	return nRet;
}

// ========================================
// insert object into document
// ========================================

sal_Bool SchView::InsertData( TransferableDataHelper& rDataHelper, const Point& rPos, BOOL bCopy, ULONG nFormat )
{
    sal_Bool     bReturn  = sal_False;
    SdrPage*     pPage    = GetDoc().GetPage( 0 );

//      Reference< XInterface > xInterface( rDataHelper.GetTransferable(), UNO_QUERY );
//      SchTransferable* pOwnData = SchTransferable::getImplementation( xInterface );

//      if( pOwnData &&
//          ! ( pOwnData == SCH_MOD1()->GetDragTransferable() ||
//              pOwnData == SCH_MOD1()->GetClipboardTransferable()))
//          pOwnData = NULL;
        
//  	if( pOwnData && nFormat == 0 )
//  	{
        // own data
//  		const SchView* pSourceView = pOwnData->GetView();

//  		if( pSourceView )
//  		{
//  			if( pSourceView == this )
//  			{
//                  // same view
//                  TransferableObjectDescriptor aDescr;
//                  if( rDataHelper.GetTransferableObjectDescriptor( SOT_FORMAT_PRIVATE, aDescr ))
//                  {
                    
//                      Size aVector( rPos.X() - aDescr.maDragStartPos.X(),
//                                    rPos.Y() - aDescr.maDragStartPos.Y());
//                      MoveAllMarked( aVector, bCopy );
//                  }
//  			}
//  			else
//  			{
//                  // different views

                // insert selected objects in current page
//  				ChartModel* pDoc = SAL_STATIC_CAST( ChartModel*, pSourceView->GetAllMarkedModel() );
//  				DeleteChartUserData( *pDoc );
//  				bReturn = Paste( *pDoc, rPos, pPage );
//  				delete pDoc;
//  			}
//  		}
//  		else
//  		{
//  			// internal paste

//  			ChartModel* pDoc = pOwnData->GetWorkDocument();
//  			DeleteChartUserData( *pDoc );
//  			bReturn = Paste( *pDoc, rPos, pPage );
//  		}
//  	}
//  	else
    if( ( nFormat == SOT_FORMATSTR_ID_SVXB || nFormat == 0 )&&
        rDataHelper.HasFormat( SOT_FORMATSTR_ID_SVXB ))
    {
        // graphic exchange format

		SotStorageStreamRef xStm;

		if( rDataHelper.GetSotStorageStream( SOT_FORMATSTR_ID_SVXB, xStm ) )
		{
			Graphic aGraphic;
            *xStm >> aGraphic;

            InsertGraphic( aGraphic, rPos );
            bReturn = TRUE;
        }
    }
	else if( ( nFormat == FORMAT_GDIMETAFILE || nFormat == 0 )&&
             rDataHelper.HasFormat( FORMAT_GDIMETAFILE ))
    {
		GDIMetaFile aMtf;

		if( rDataHelper.GetGDIMetaFile( FORMAT_GDIMETAFILE, aMtf ) )
		{
			InsertGraphic( aMtf, rPos );
			bReturn = TRUE;
        }
    }
	else if( ( nFormat == FORMAT_BITMAP || nFormat == 0 )&&
             rDataHelper.HasFormat( FORMAT_BITMAP ))
    {
        Bitmap aBmp;

        if( rDataHelper.GetBitmap( FORMAT_BITMAP, aBmp ) )
		{
            InsertGraphic( aBmp, rPos );
            bReturn = TRUE;
        }
    }
	else if( ( nFormat == FORMAT_STRING || nFormat == 0 )&&
             rDataHelper.HasFormat( FORMAT_STRING ))
	{
        String aString;

        if( rDataHelper.GetString( FORMAT_STRING, aString ) )
            bReturn = SdrExchangeView::Paste( aString, rPos, pPage );
	}

	MarkListHasChanged();

	return bReturn;
}

Window* SchView::GetWindow() const
{
    if( pViewSh )
        return pViewSh->GetWindow();
    return NULL;
}

/// SfxListener::Notify
void SchView::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
    if( rHint.ISA( SfxSimpleHint ) &&
        SAL_STATIC_CAST( const SfxSimpleHint&, rHint ).GetId() == SFX_HINT_MODECHANGED &&
        rBC.ISA( ChartModel ))
    {
        if( pViewSh )
            pViewSh->UIFeatureChanged();
    }
    else
        E3dView::Notify( rBC, rHint );
}
