/*************************************************************************
 *
 *  $RCSfile: newfoil.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: ka $ $Date: 2001/10/22 13:36:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif
#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SVTOOLS_CJKOPTIONS_HXX
#include <svtools/cjkoptions.hxx>
#endif

#include "helpids.h"
#include "app.hrc"
#include "res_bmp.hrc"
#include "strings.hrc"
#include "sdresid.hxx"
#include "new_foil.hxx"
#include "new_foil.hrc"
#include "sdattr.hxx"
#include "docshell.hxx"

/************************************************************************/

#define MAX_AUTO_LAYOUT 25

static AutoLayout LayoutArray[ MAX_AUTO_LAYOUT ] =
{
	AUTOLAYOUT_NONE, // nur Dummy, um nicht immer 1 addieren, bzw.
					 // subtrahieren zu muessen
	AUTOLAYOUT_NONE,
	AUTOLAYOUT_TITLE,
	AUTOLAYOUT_ENUM,
	AUTOLAYOUT_2TEXT,
	AUTOLAYOUT_ONLY_TITLE,
	AUTOLAYOUT_OBJ,
	AUTOLAYOUT_CHART,
	AUTOLAYOUT_TAB,
	AUTOLAYOUT_CLIPTEXT,
	AUTOLAYOUT_TEXTCHART,
	AUTOLAYOUT_TEXTCLIP,
	AUTOLAYOUT_CHARTTEXT,
	AUTOLAYOUT_TEXTOBJ,
	AUTOLAYOUT_TEXT2OBJ,
	AUTOLAYOUT_OBJTEXT,
	AUTOLAYOUT_OBJOVERTEXT,
	AUTOLAYOUT_2OBJTEXT,
	AUTOLAYOUT_2OBJOVERTEXT,
	AUTOLAYOUT_TEXTOVEROBJ,
	AUTOLAYOUT_4OBJ,
//	  AUTOLAYOUT_ORG,
	AUTOLAYOUT_VERTICAL_TITLE_TEXT_CHART,
	AUTOLAYOUT_VERTICAL_TITLE_VERTICAL_OUTLINE,
	AUTOLAYOUT_TITLE_VERTICAL_OUTLINE,
	AUTOLAYOUT_TITLE_VERTICAL_OUTLINE_CLIPART
};

#define MAX_AUTO_HANDOUTLAYOUT 6

static AutoLayout HandoutLayoutArray[ MAX_AUTO_HANDOUTLAYOUT ] =
{
	AUTOLAYOUT_NONE, // nur Dummy, um nicht immer 1 addieren, bzw.
					 // subtrahieren zu muessen
	AUTOLAYOUT_HANDOUT1,
	AUTOLAYOUT_HANDOUT2,
	AUTOLAYOUT_HANDOUT3,
	AUTOLAYOUT_HANDOUT4,
	AUTOLAYOUT_HANDOUT6
};

#define MAX_AUTO_NOTESLAYOUT 2

static AutoLayout NotesLayoutArray[ MAX_AUTO_NOTESLAYOUT ] =
{
	AUTOLAYOUT_NONE, // nur Dummy, um nicht immer 1 addieren, bzw.
					 // subtrahieren zu muessen
	AUTOLAYOUT_NOTES
};

/*************************************************************************
|*
|* Dialog zur Auswahl eines Folienlayouts
|*
\************************************************************************/

SdNewFoilDlg::SdNewFoilDlg( Window* pWindow, const SfxItemSet& rInAttrs,
							PageKind ePgKind, SdDrawDocShell* pDocShell, BOOL bChangeFoil ) :
				ModalDialog         ( pWindow, SdResId( DLG_NEW_FOIL ) ),
				aEdtName            ( this, SdResId( EDT_NAME ) ),
				aFlName             ( this, SdResId( FL_NAME ) ),
				aFtLayout           ( this, SdResId( FT_LAYOUT ) ),
				aCtlLayout          ( this, SdResId( CTL_LAYOUT )),
				aCbxBackground      ( this, SdResId( CBX_BACKGROUND ) ),
				aCbxObjects         ( this, SdResId( CBX_OBJECTS ) ),
				aFlDisplay          ( this, SdResId( FL_DISPLAY ) ),
				aBtnDelete          ( this, SdResId( BTN_DELETE ) ),
				aBtnOK              ( this, SdResId( BTN_OK ) ),
				aBtnCancel          ( this, SdResId( BTN_CANCEL ) ),
				aBtnHelp            ( this, SdResId( BTN_HELP ) ),
				rOutAttrs			( rInAttrs ),
				ePageKind           ( ePgKind ),
				pDocSh              ( pDocShell )
{
	FreeResource();

	aCtlLayout.SetStyle( WB_3DLOOK | WB_BORDER | WB_ITEMBORDER |
	                     WB_DOUBLEBORDER | WB_VSCROLL | WB_FLATVALUESET );
	aCtlLayout.EnableFullItemMode( FALSE );

	if( bChangeFoil )
	{
		SetText( String( SdResId(STR_MODIFYPAGE) ) );
		SetHelpId( SID_MODIFYPAGE );
		aEdtName.SetHelpId(HID_SD_CHGFOIL_NAME);
		aCtlLayout.SetHelpId(HID_SD_CHGFOIL_LAYOUT);
		aCbxBackground.SetHelpId(HID_SD_CHGFOIL_BACKGROUND);
		aCbxObjects.SetHelpId(HID_SD_CHGFOIL_OBJECTS);
	}
	else
	{
		SetText( String( SdResId(STR_INSERTPAGE) ) );
		SetHelpId( SID_INSERTPAGE );
	}

	if (ePageKind == PK_NOTES)
	{
		aEdtName.Disable();
		aFlName.Disable();
		aCbxBackground.Disable();
		aBtnDelete.Disable();
	}
	else if (ePageKind == PK_HANDOUT)
	{
		aEdtName.Disable();
		aFlName.Disable();
		aCbxBackground.Disable();
		aCbxObjects.Disable();
		aBtnDelete.Disable();
		aFlDisplay.Disable();
	}

	FillValueSet( aCtlLayout );

	aCtlLayout.SetDoubleClickHdl( LINK( this, SdNewFoilDlg, ClickLayoutHdl ) );
	aBtnCancel.SetClickHdl( LINK( this, SdNewFoilDlg, ClickCancelHdl ) );
	aBtnOK.SetClickHdl( LINK( this, SdNewFoilDlg, ClickLayoutHdl ) );

	// Wird z.Z. nicht unterstuetzt
	aBtnDelete.Hide();

	Reset();
}

/*************************************************************************
|*
|*	Dtor
|*
*************************************************************************/

SdNewFoilDlg::~SdNewFoilDlg()
{
}

/*************************************************************************
|*
|*	  Initialisierung
|*
*************************************************************************/

void SdNewFoilDlg::Reset()
{
	const SfxPoolItem *pPoolItem = NULL;

	if( rOutAttrs.GetItemState( ATTR_PAGE_NAME, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		aEdtName.SetText( ( ( const SfxStringItem* ) pPoolItem )->GetValue() );

	if( rOutAttrs.GetItemState( ATTR_PAGE_BACKGROUND, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		aCbxBackground.Check( ( ( const SfxBoolItem* ) pPoolItem )->GetValue() );

	if( rOutAttrs.GetItemState( ATTR_PAGE_OBJECTS, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		aCbxObjects.Check( ( ( const SfxBoolItem* ) pPoolItem )->GetValue() );

	if( rOutAttrs.GetItemState( ATTR_PAGE_LAYOUT, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		SetAutoLayout( (AutoLayout) ( ( const SfxAllEnumItem* ) pPoolItem )->GetValue() );
	else
		aCtlLayout.SelectItem( 1 );

	aBtnDelete.Disable();
}

/*************************************************************************
|*
|*	  Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
*************************************************************************/

void SdNewFoilDlg::GetAttr( SfxItemSet& rOutAttrs )
{
	rOutAttrs.Put( SfxStringItem( ATTR_PAGE_NAME,
						aEdtName.GetText() ) );
	rOutAttrs.Put( SfxBoolItem( ATTR_PAGE_BACKGROUND,
						aCbxBackground.IsChecked() ) );
	rOutAttrs.Put( SfxBoolItem( ATTR_PAGE_OBJECTS,
						aCbxObjects.IsChecked() ) );
	rOutAttrs.Put( SfxAllEnumItem( ATTR_PAGE_LAYOUT,
						GetAutoLayout() ) );
}

/*************************************************************************
|*
|* Fuellt das ValueSet mit Bitmaps
|*
\************************************************************************/

void SdNewFoilDlg::FillValueSet( ValueSet& rVs )
{
	rVs.SetStyle( rVs.GetStyle() | WB_ITEMBORDER | WB_DOUBLEBORDER
								 | WB_VSCROLL | WB_NAMEFIELD | WB_FLATVALUESET );

	rVs.SetColCount( 4 );
	rVs.SetLineCount( 3 );
	rVs.SetExtraSpacing( 2 );

	if (ePageKind == PK_NOTES)
	{
		rVs.InsertItem( 1,  Bitmap( SdResId( BMP_FOILN_01 ) ), String( SdResId( STR_AUTOLAYOUT_NOTES ) ) );
	}
	else if (ePageKind == PK_HANDOUT)
	{
		rVs.InsertItem( 1,  Bitmap( SdResId( BMP_FOILH_01 ) ), String( SdResId( STR_AUTOLAYOUT_HANDOUT1 ) ) );
		rVs.InsertItem( 2,  Bitmap( SdResId( BMP_FOILH_02 ) ), String( SdResId( STR_AUTOLAYOUT_HANDOUT2 ) ) );
		rVs.InsertItem( 3,  Bitmap( SdResId( BMP_FOILH_03 ) ), String( SdResId( STR_AUTOLAYOUT_HANDOUT3 ) ) );
		rVs.InsertItem( 4,  Bitmap( SdResId( BMP_FOILH_04 ) ), String( SdResId( STR_AUTOLAYOUT_HANDOUT4 ) ) );
		rVs.InsertItem( 5,  Bitmap( SdResId( BMP_FOILH_06 ) ), String( SdResId( STR_AUTOLAYOUT_HANDOUT6 ) ) );
	}
	else
	{
		rVs.InsertItem( 1,  Bitmap( SdResId( BMP_FOIL_20 ) ), String( SdResId( STR_AUTOLAYOUT_NONE ) ) );
		rVs.InsertItem( 2,  Bitmap( SdResId( BMP_FOIL_00 ) ), String( SdResId( STR_AUTOLAYOUT_TITLE ) ) );
		rVs.InsertItem( 3,  Bitmap( SdResId( BMP_FOIL_01 ) ), String( SdResId( STR_AUTOLAYOUT_ENUM ) ) );
		rVs.InsertItem( 4, Bitmap( SdResId( BMP_FOIL_03 ) ), String( SdResId( STR_AUTOLAYOUT_2TEXT ) ) );
		rVs.InsertItem( 5,  Bitmap( SdResId( BMP_FOIL_19 ) ), String( SdResId( STR_AUTOLAYOUT_ONLY_TITLE ) ) );
		rVs.InsertItem( 6,  Bitmap( SdResId( BMP_FOIL_11 ) ), String( SdResId( STR_AUTOLAYOUT_OBJ ) ) );
		rVs.InsertItem( 7,  Bitmap( SdResId( BMP_FOIL_02 ) ), String( SdResId( STR_AUTOLAYOUT_CHART ) ) );
		rVs.InsertItem( 8,  Bitmap( SdResId( BMP_FOIL_08 ) ), String( SdResId( STR_AUTOLAYOUT_TAB ) ) );
		rVs.InsertItem( 9,  Bitmap( SdResId( BMP_FOIL_09 ) ), String( SdResId( STR_AUTOLAYOUT_CLIPTEXT ) ) );
		rVs.InsertItem( 10, Bitmap( SdResId( BMP_FOIL_04 ) ), String( SdResId( STR_AUTOLAYOUT_TEXTCHART ) ) );
		rVs.InsertItem( 11, Bitmap( SdResId( BMP_FOIL_06 ) ), String( SdResId( STR_AUTOLAYOUT_TEXTCLIP ) ) );
		rVs.InsertItem( 12, Bitmap( SdResId( BMP_FOIL_07 ) ), String( SdResId( STR_AUTOLAYOUT_CHARTTEXT ) ) );
		rVs.InsertItem( 13, Bitmap( SdResId( BMP_FOIL_10 ) ), String( SdResId( STR_AUTOLAYOUT_TEXTOBJ ) ) );
		rVs.InsertItem( 14, Bitmap( SdResId( BMP_FOIL_12 ) ), String( SdResId( STR_AUTOLAYOUT_TEXT2OBJ ) ) );
		rVs.InsertItem( 15, Bitmap( SdResId( BMP_FOIL_13 ) ), String( SdResId( STR_AUTOLAYOUT_OBJTEXT ) ) );
		rVs.InsertItem( 16, Bitmap( SdResId( BMP_FOIL_14 ) ), String( SdResId( STR_AUTOLAYOUT_OBJOVERTEXT ) ) );
		rVs.InsertItem( 17, Bitmap( SdResId( BMP_FOIL_15 ) ), String( SdResId( STR_AUTOLAYOUT_2OBJTEXT ) ) );
		rVs.InsertItem( 18, Bitmap( SdResId( BMP_FOIL_16 ) ), String( SdResId( STR_AUTOLAYOUT_2OBJOVERTEXT ) ) );
		rVs.InsertItem( 19, Bitmap( SdResId( BMP_FOIL_17 ) ), String( SdResId( STR_AUTOLAYOUT_TEXTOVEROBJ ) ) );
		rVs.InsertItem( 20, Bitmap( SdResId( BMP_FOIL_18 ) ), String( SdResId( STR_AUTOLAYOUT_4OBJ ) ) );

        SvtCJKOptions aCJKOptions;
        if( aCJKOptions.IsVerticalTextEnabled() )
        {
			rVs.InsertItem( 21, Bitmap( SdResId( BMP_FOIL_21 ) ), String( SdResId( STR_AL_VERT_TITLE_TEXT_CHART ) ) );
			rVs.InsertItem( 22, Bitmap( SdResId( BMP_FOIL_22 ) ), String( SdResId( STR_AL_VERT_TITLE_VERT_OUTLINE ) ) );
			rVs.InsertItem( 23, Bitmap( SdResId( BMP_FOIL_23 ) ), String( SdResId( STR_AL_TITLE_VERT_OUTLINE ) ) );
			rVs.InsertItem( 24, Bitmap( SdResId( BMP_FOIL_24 ) ), String( SdResId( STR_AL_TITLE_VERT_OUTLINE_CLIPART ) ) );
		}

//        rVs.InsertItem( 7,  Bitmap( SdResId( BMP_FOIL_05 ) ), String( SdResId( STR_AUTOLAYOUT_ORG ) ) );
	}

	rVs.Show();
}

/*************************************************************************
|*
|* Gibt das Autolayout zurueck
|*
\************************************************************************/

AutoLayout SdNewFoilDlg::GetAutoLayout() const
{
	short nId = aCtlLayout.GetSelectItemId();

	if (ePageKind == PK_NOTES)
	{
		return( NotesLayoutArray[ nId ] );
	}
	else if (ePageKind == PK_HANDOUT)
	{
		return( HandoutLayoutArray[ nId ] );
	}
	else
	{
		return( LayoutArray[ nId ] );
	}
}

/*************************************************************************
|*
|* setzt das AutoLayout
|*
\************************************************************************/

BOOL SdNewFoilDlg::SetAutoLayout( const AutoLayout eAutoLayout )
{
	short nArray;
    USHORT nCount = MAX_AUTO_LAYOUT;
	SvtCJKOptions aCJKOptions;
    if( !aCJKOptions.IsVerticalTextEnabled() )
		nCount -= 4;

	for( USHORT i = 1; i < nCount; i++ )
	{
		if (ePageKind == PK_NOTES)
		{
			nArray = NotesLayoutArray[ i ];
		}
		else if (ePageKind == PK_HANDOUT)
		{
			nArray = HandoutLayoutArray[ i ];
		}
		else
		{
			nArray = LayoutArray[ i ];
		}

		if( nArray == eAutoLayout )
		{
			aCtlLayout.SelectItem( i );
			return( TRUE );
		}
	}
	return( FALSE );
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SdNewFoilDlg::Close()
{
	BOOL bEnd = FALSE;
	String aNewName( aEdtName.GetText() );
	String aOldName;

	// alten Namen ermitteln
	const SfxPoolItem *pPoolItem = NULL;
	if( rOutAttrs.GetItemState( ATTR_PAGE_NAME, TRUE, &pPoolItem ) == SFX_ITEM_SET )
		aOldName = ( ( const SfxStringItem* ) pPoolItem )->GetValue();

	if( aOldName == aNewName )
		bEnd = TRUE;
	else if( pDocSh->CheckPageName( this, aNewName ) )
		bEnd = TRUE;

	if( bEnd )
	{
		aEdtName.SetText( aNewName );
		EndDialog( RET_OK );
	}
	else
		EndDialog( RET_CANCEL );

	return( bEnd );
}

/*************************************************************************
|*
|* DoppelClick-Handler
|*
\************************************************************************/

IMPL_LINK_INLINE_START( SdNewFoilDlg, ClickLayoutHdl, void *, p )
{
	//EndDialog( RET_OK );
	Close();
	return 0;
}
IMPL_LINK_INLINE_END( SdNewFoilDlg, ClickLayoutHdl, void *, p )

/*************************************************************************
|*
|* Cancel-Handler
|*
\************************************************************************/

IMPL_LINK_INLINE_START( SdNewFoilDlg, ClickCancelHdl, void *, p )
{
	EndDialog( RET_CANCEL );
	return 0;
}
IMPL_LINK_INLINE_END( SdNewFoilDlg, ClickCancelHdl, void *, p )

/*************************************************************************

	  Source Code Control System - History

	  $Log: newfoil.cxx,v $
	  Revision 1.7  2001/10/22 13:36:42  ka
	  #93586#: removed __EXPORT compiler flag
	
	  Revision 1.6  2001/05/17 14:12:17  af
	  #86988# Change of dialog box layout.
	
	  Revision 1.5  2001/04/27 08:55:41  dl
	  Disable CJK AutoLayouts if necessary
	
	  Revision 1.4  2001/02/19 14:21:31  dl
	  ValueSet arranged

	  Revision 1.3  2001/02/19 10:42:54  dl
	  Vertical AutoLayouts added

	  Revision 1.2  2000/09/21 16:11:35  ka
	  SFX_BINDINGS/SFX_DISPATCHER macros removed

	  Revision 1.1.1.1  2000/09/18 16:48:33  hr
	  initial import

	  Revision 1.24  2000/09/17 15:23:36  willem.vandorp
	  OpenOffice header added.

	  Revision 1.23  2000/09/06 13:47:52  willem.vandorp
	  Header and footer replaced.

	  Revision 1.22  2000/09/05 10:40:09  pw
	  Use ValueSet::SetStyle instead of ValueSet::SetWinStyle

	  Revision 1.21  2000/02/11 12:47:00  hr
	  #70473# changes for unicode ( patched by automated patchtool )

	  Revision 1.20  1999/02/17 15:35:04  CL
	  #60167# Neue HelpIds fuer Dialog Seitenlayout Aendern


	  Rev 1.19   17 Feb 1999 16:35:04   CL
   #60167# Neue HelpIds fuer Dialog Seitenlayout Aendern

	  Rev 1.18   14 Jan 1998 17:40:34   DL
   includes

	  Rev 1.17   29 Apr 1997 16:38:24   DL
   #39440# Ctor erweitert

	  Rev 1.16   29 Oct 1996 10:51:34   DL
   Neu: SdResId

	  Rev 1.15   27 Sep 1996 11:18:00   SOH
   * CheckPageName(): Window-Parameter (this)

	  Rev 1.14   25 Sep 1996 16:25:00   SOH
   + Close(); + ClickCancelHdl(); geaendertes Handling (Seitennamen pruefen)

	  Rev 1.13   04 Dec 1995 13:32:28   DL
   Neuer Link

	  Rev 1.12   07 Nov 1995 16:15:50   TRI
   Change->Set

	  Rev 1.11   04 Oct 1995 08:20:28   SOH
   DoubleClickHdl() fuer ValueSet

	  Rev 1.10   19 Jul 1995 17:39:32   DL
   OrgChart entfernt

	  Rev 1.9	10 Jul 1995 16:20:10   DL
   Notizseiten

	  Rev 1.8	26 Jun 1995 09:24:08   DL
   BtnDelete: Hide

	  Rev 1.7	23 May 1995 13:49:08   DL
   Handoutmodus: 3x3 Matrix

	  Rev 1.6	22 May 1995 18:35:58   DL
   Handout-Modus

	  Rev 1.5	02 May 1995 09:22:16   DL
   Neue Folie implementiert (4OBJ)

	  Rev 1.4	26 Apr 1995 12:04:02   SOH
   Grundsaetzliche Umstellung des Dialogs

	  Rev 1.3	23 Mar 1995 11:58:06   TRI
   Segmentierung

	  Rev 1.2	24 Jan 1995 11:28:58   SOH
   Auf 20 Layouts erweitert

	  Rev 1.1	20 Jan 1995 09:54:14   SOH
   Neu: Set/GetAutoLayout()

	  Rev 1.0	07 Dec 1994 11:15:34   SOH
   Initial revision.

*************************************************************************/

