/*************************************************************************
 *
 *  $RCSfile: sdtbxctl.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ka $ $Date: 2001/10/22 13:36:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include <svx/drawdlgs.hxx>
#include <svx/svxids.hrc>

#include "app.hrc"
#include "res_bmp.hrc"
#include "strings.hrc"
#include "docshell.hxx"
#include "sdtbxctl.hxx"
#include "tbx_ww.hxx"
#include "sdresid.hxx"
#include "tbx_ww.hrc"


SFX_IMPL_TOOLBOX_CONTROL( SdTbxCtlAlignment, TbxDummyItem )

/*************************************************************************
|*
|* Klasse fuer SdToolbox
|*
\************************************************************************/

SdTbxCtlAlignment::SdTbxCtlAlignment( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings ) :
		SfxToolBoxControl( nId, rTbx, rBindings )
{
}

/*************************************************************************
|*
|* Benachrichtigung, wenn sich der Applikationsstatus geaendert hat
|*
\************************************************************************/

void SdTbxCtlAlignment::StateChanged( USHORT nSId,
						SfxItemState eState, const SfxPoolItem* pState )
{
	SfxToolBoxControl::StateChanged( nSId, eState, pState );
}

/*************************************************************************
|*
|* Wenn man ein PopupWindow erzeugen will
|*
\************************************************************************/

SfxPopupWindowType SdTbxCtlAlignment::GetPopupWindowType() const
{
	switch( GetId() )
	{
		case SID_OBJECT_ALIGN:
			return( SFX_POPUPWINDOW_ONCLICK );

		case SID_ZOOM_TOOLBOX:
			return( SFX_POPUPWINDOW_ONCLICK );

		case SID_OBJECT_SELECT:
			return( SFX_POPUPWINDOW_ONCLICK );
	}
	return( SFX_POPUPWINDOW_ONCLICK );
}

/*************************************************************************
|*
|* Hier wird das Fenster erzeugt
|* Lage der Toolbox mit GetToolBox() abfragbar
|* rItemRect sind die Screen-Koordinaten
|*
\************************************************************************/

SfxPopupWindow*	SdTbxCtlAlignment::CreatePopupWindow()
{
	if( GetId() == SID_OBJECT_ALIGN )
	{
		SdPopupWindowTbx *pWin = new SdPopupWindowTbx( GetId(), this,
							SdResId( RID_ALIGNMENT ), SdResId( TBX_ALIGNMENT ),
							GetBindings() );
		pWin->StartPopupMode( &GetToolBox(), TRUE );
		pWin->StartSelection();
		pWin->Show();
		return( pWin );
	}
	else if( GetId() == SID_ZOOM_TOOLBOX )
	{
		SdPopupWindowTbx *pWin = new SdPopupWindowTbx( GetId(), this,
							SdResId( RID_ZOOM ), SdResId( TBX_ZOOM ),
							GetBindings() );
		pWin->StartPopupMode( &GetToolBox(), TRUE );
		pWin->StartSelection();
		pWin->Show();
		return( pWin );
	}
	else if( GetId() == SID_OBJECT_SELECT )
	{
		SdPopupWindowTbx *pWin = new SdPopupWindowTbx( GetId(), this,
							SdResId( RID_CONTROLS ), SdResId( TBX_CONTROLS ),
							GetBindings() );
		pWin->StartPopupMode( &GetToolBox(), TRUE );
		pWin->StartSelection();
		pWin->Show();
		return( pWin );
	}
	return( 0 );
}




