/*************************************************************************
 *
 *  $RCSfile: fuslsel.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: ka $ $Date: 2001/10/26 12:34:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "sdresid.hxx"
#include "fuslsel.hxx"
#include "slidvish.hxx"
#include "sdwindow.hxx"
#include "slidview.hxx"
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "pres.hxx"
#include "fader.hxx"
#include "showview.hxx"
#include "frmview.hxx"
#include "strings.hrc"
#include "app.hrc"                  // SID_STATUS_PAGE

using namespace ::com::sun::star;

// --------------------
// - FuSlideSelection -
// --------------------

// -----------------------------------------------------------------------------

TYPEINIT1( FuSlideSelection, FuSlide );

// -----------------------------------------------------------------------------

FuSlideSelection::FuSlideSelection(SdSlideViewShell* pViewSh,
								   SdWindow*		 pWin,
								   SdSlideView* 	 pView,
								   SdDrawDocument*	 pDoc,
								   SfxRequest&		 rReq)
				: FuSlide(pViewSh, pWin, pView, pDoc, rReq),
				  bSubstShown(FALSE),
				  bPageHit(FALSE),
				  bDragSelection(FALSE)
{
	pSound = new Sound;

	pIsShowingEffectInfo = new FSS_IsShowingEffectInfo;
	pIsShowingEffectInfo->bDisposed = FALSE;
	pIsShowingEffectInfo->bIsShowingEffect = FALSE;

	aDelayToScrollTimer.SetTimeout(50);
	aDragTimer.SetTimeoutHdl( LINK( this, FuSlideSelection, DragSlideHdl ) );
}

// -----------------------------------------------------------------------------

FuSlideSelection::~FuSlideSelection()
{
    aDragTimer.Stop();
	delete pSound;

	if( pIsShowingEffectInfo && pIsShowingEffectInfo->bIsShowingEffect )
	{
		// we can not delete the info because its
		// used in ShowFade(), but mark it as
		// dispose so ShowFade() will clear it
		pIsShowingEffectInfo->bDisposed = TRUE;
	}
	else
	{
		delete pIsShowingEffectInfo;
	}
}

// -----------------------------------------------------------------------------

BOOL FuSlideSelection::MouseButtonDown(const MouseEvent& rMEvt)
{
	BOOL			bReturn = FALSE;
	Point			aPos( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
    SdPage*         pHitPage = pSlView->GetHitPage( aPos );
    SdPage*         pFadePage = pSlView->GetFadePage( aPos );
	USHORT			nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
	USHORT			nPage;

	pWindow->CaptureMouse();

	if( ( rMEvt.GetButtons() == MOUSE_LEFT ) && ( rMEvt.GetClicks() == 1 )	&& pHitPage )
	{
		bPageHit = TRUE;		 // Seite getroffen, merken fuer MouseMove

		// erweiterte Selektion
		if (rMEvt.IsShift())
		{
			BOOL bAddSel = TRUE;
			// bereits selektiert? dann deselektieren, sonst selektieren
			if (pHitPage->IsSelected())
			{
				bAddSel = FALSE;
			}
			pDoc->SetSelected(pHitPage, bAddSel);

			// PK_STANDARD berechnen
			nPage =  (pHitPage->GetPageNum() - 1) / 2;
			pSlView->DrawSelectionRect(nPage);
			pSlViewShell->SelectionHasChanged();
		}

		// einfache Selektion, alle selektierten deselektieren, getroffene
		// Seite selektieren
		else if (!pHitPage->IsSelected())
		{
			for (nPage = 0; nPage < nNoOfPages; nPage++)
			{
				SdPage* pTestPage = pDoc->GetSdPage(nPage, PK_STANDARD);
				if (pTestPage->IsSelected() && pTestPage != pHitPage)
				{
					pDoc->SetSelected(pTestPage, FALSE);
					pSlView->DrawSelectionRect (nPage);
				}
			}

			nPage = pHitPage->GetPageNum();

			// PK_STANDARD berechnen
			nPage = (nPage - 1) / 2;
			pDoc->SetSelected(pHitPage, TRUE);
			pSlView->DrawSelectionRect (nPage);
			pSlViewShell->SelectionHasChanged();
		}

		// Position und Status der Ersatzdarstellung merken
		aDragPos = aPos;
		bSubstShown = FALSE;
		bFirstMouseMove = TRUE;
		aDragTimer.Start();
	}

	// bei Doppelklick: einfache Selektion und in Zeichenmodus gehen
	if( ( rMEvt.GetButtons() == MOUSE_LEFT ) && ( rMEvt.GetClicks() == 2 ) && pHitPage )
	{
		for (nPage = 0; nPage < nNoOfPages; nPage++)
		{
			SdPage* pTestPage = pDoc->GetSdPage(nPage, PK_STANDARD);
			pDoc->SetSelected(pTestPage, FALSE);
		}
		
        pDoc->SetSelected(pHitPage, TRUE);
		bReturn = TRUE;
		pViewShell->GetFrameView()->SetSelectedPage((pHitPage->GetPageNum()-1)/2);
		pViewShell->GetViewFrame()->GetDispatcher()->Execute(SID_DRAWINGMODE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
	}

	// eines der Diawechselsymbole getroffen?
	if( ( rMEvt.GetButtons() == MOUSE_LEFT ) && ( rMEvt.GetClicks() == 1 ) && pFadePage )
	{
    	ShowEffect( ( pFadePage->GetPageNum() - 1 ) >> 1 );
        return TRUE;
	}

	// Selektionsrechteck aufziehen
	if( !pHitPage && !bReturn )
	{
		// keine erweiterte Selektion: alle Seiten deselektieren
		if( !rMEvt.IsShift() )
		{
			BOOL bChanged = FALSE;
			
            for (USHORT nPage = 0; nPage < nNoOfPages; nPage++)
			{
				SdPage* pSelPage = pDoc->GetSdPage(nPage, PK_STANDARD);
				if (pSelPage->IsSelected())
				{
					pDoc->SetSelected(pSelPage, FALSE);
					pSlView->DrawSelectionRect(nPage);
					bChanged = TRUE;
				}
			}
			if (bChanged)
                pSlViewShell->SelectionHasChanged();
		}

		bDragSelection = TRUE;
		pSlView->BegEncirclement(aPos);
	}

	return bReturn;
}

// -----------------------------------------------------------------------------

BOOL FuSlideSelection::MouseMove(const MouseEvent& rMEvt)
{
	Point   aPix( rMEvt.GetPosPixel() );
	Point   aPos( pWindow->PixelToLogic( aPix ) );
    BOOL    bReturn = FALSE;

    if( aDragTimer.IsActive() )
	{
        if( bFirstMouseMove )
			bFirstMouseMove = FALSE;
		else
            aDragTimer.Stop();
	}

	if( rMEvt.GetButtons() == MOUSE_LEFT && bPageHit && !rMEvt.IsShift() || bSubstShown )
	{										
		ForceScroll( aPix );

		// wenn DragRect erzeugt, an alter Pos. loeschen, Position aendern
		if (bSubstShown)
		{
			DrawSubst();
			ChangeSubstPos(aPos- aDragPos);
			aDragPos = aPos;
		}
		// sonst Ersatzdarstellungen erzeugen
		else
		{
			CreateSubst();
			bSubstShown = TRUE;
		}

		// Aenderung der Einfuegeposition
		Point aTemp = CalcPosOfInsertMarker (aPos);
		if (aTemp != aPosOfInsertMarker)
		{
			DrawInsertMarker(FALSE);
			aPosOfInsertMarker = aTemp;
			DrawInsertMarker(TRUE);
		}

		// wenn Ersatzdarstellungen erzeugt, an neuer Pos. zeichnen
		if (bSubstShown)
		{
			DrawSubst();
		}

		bReturn = TRUE;
	}
	else if (bDragSelection)
	{
		ForceScroll( aPix );
		pSlView->MovEncirclement(aPos);
	}

	return bReturn;
}

// -----------------------------------------------------------------------------

BOOL FuSlideSelection::MouseButtonUp(const MouseEvent& rMEvt)
{
	SdDrawDocument* pDoc = pSlView->GetDoc();
	BOOL            bReturn = FALSE;

	if( aDragTimer.IsActive() )
		aDragTimer.Stop();

	if (rMEvt.GetButtons() == MOUSE_LEFT && bSubstShown)
	{
		Point aPos = pWindow->PixelToLogic(rMEvt.GetPosPixel());

		// Ersatzdarstellung loeschen
		DrawSubst();					// vom Bildschirm
		DeleteSubst();					// und aus dem Speicher
		bSubstShown = FALSE;

		// Einfuegemarke loeschen
		DrawInsertMarker(FALSE);

		// Seiten ablegen wenn Ziel gueltig
		USHORT nTargetPage = GetTargetPage( aPos );

		pSlView->MoveMarked( nTargetPage );
		pViewShell->GetViewFrame()->GetBindings().Invalidate(SID_STATUS_PAGE);
		bReturn = TRUE;
	}

	if (bDragSelection)
	{
		aDragSelRect = pSlView->EndEncirclement();

		bDragSelection = FALSE;
		USHORT nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
		BOOL   bChanged = FALSE;
		for (USHORT nPage = 0; nPage < nNoOfPages; nPage++)
		{
			SdPage*   pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
			Rectangle aPageRect(pSlView->CalcPagePos(nPage), pPage->GetSize());
			if (aDragSelRect.IsInside(aPageRect))
			{
				// erweiterte Selektion: Selektionsstati umsetzen
				if (rMEvt.IsShift())
				{
					if (pPage->IsSelected()) pDoc->SetSelected(pPage, FALSE);
					else					 pDoc->SetSelected(pPage, TRUE);

				}
				// einfache Selektion
				else
				{
					pDoc->SetSelected(pPage, TRUE);
				}
				pSlView->DrawSelectionRect(nPage);
				bChanged = TRUE;
			}
		}
		if (bChanged) pSlViewShell->SelectionHasChanged();
	}

	bPageHit = FALSE;				  // ab jetzt keine Seite mehr "am Haken"
    pWindow->ReleaseMouse();

	return bReturn;
}

// -----------------------------------------------------------------------------

BOOL FuSlideSelection::KeyInput(const KeyEvent& rKEvt)
{
	BOOL bReturn = FALSE;

	switch ( rKEvt.GetCharCode() )
	{
		case '+':
		{
			pViewShell->SetZoom(pWindow->GetZoom() * 3 / 2);
			bReturn = TRUE;
			break;
		}
		case '-':
		{
			pViewShell->SetZoom(pWindow->GetZoom() * 2 / 3);
			bReturn = TRUE;
			break;
		}
	}

	if (!bReturn)
	{
		if (rKEvt.GetKeyCode().GetFunction() == KEYFUNC_DELETE &&
			pView->ISA(SdSlideView))
		{
			SdSlideView* pSlideView = (SdSlideView*)pView;

			BOOL bHasObjects = FALSE;
			USHORT nMarkedPages = 0;

			USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);
			for( USHORT nPgNum = 0; nPgNum < nCount; nPgNum++ )
			{
				SdPage* pPage = pDoc->GetSdPage(nPgNum, PK_STANDARD);
				if(pPage && pPage->IsSelected())
				{
					nMarkedPages++;
					if(pPage->GetObjCount() > 0)
						bHasObjects = TRUE;
				}
			}

			if( nMarkedPages > 0 )
			{
				String aString(SdResId(nMarkedPages == 1?STR_WARN_DEL_SEL_PAGE:STR_WARN_DEL_SEL_PAGES));
				if( !bHasObjects || QueryBox(pWindow, WB_YES_NO, aString).Execute() == RET_YES)
				{
					((SdSlideView*) pView)->DeleteMarked();
				}
			}

			bReturn = TRUE;
		}
		else
		{
			bReturn = FuSlide::KeyInput(rKEvt);
		}
	}

	return(bReturn);
}

// -----------------------------------------------------------------------------

void FuSlideSelection::Activate()
{
	FuSlide::Activate();
}

// -----------------------------------------------------------------------------

void FuSlideSelection::Deactivate()
{
	// Sound nicht mehr blockieren, damit er in der Show gespielt werden kann
	if (pSound)
		pSound->Stop();

	FuSlide::Deactivate();
}

// -----------------------------------------------------------------------------

void FuSlideSelection::DrawSubst() const
{
	ULONG nNoOfSubst = aSubstList.Count();
	ULONG nSubst;
	for (nSubst = 0; nSubst < nNoOfSubst; nSubst++)
	{
		pViewShell->DrawMarkRect(*(Rectangle*)aSubstList.GetObject(nSubst));
	}
}

// -----------------------------------------------------------------------------

void FuSlideSelection::DrawDragSelectionRect() const
{
	pViewShell->DrawMarkRect(aDragSelRect);
}

// -----------------------------------------------------------------------------

void FuSlideSelection::DrawInsertMarker (BOOL bShow)
{
	Color aNewColor;

	if (bShow)
		aNewColor = Color(COL_BLACK);
	else
		aNewColor = pWindow->GetBackground().GetColor();


	Size  aMarkerSize	= pDoc->GetSdPage(0, PK_STANDARD)->GetSize();
	aMarkerSize.Width() = pSlView->GetPageGap() / pSlView->GetPagesPerRow();

	Rectangle aMarkerRect(aPosOfInsertMarker, aMarkerSize);
	pViewShell->DrawFilledRect( aMarkerRect, aNewColor, aNewColor );
}

// -----------------------------------------------------------------------------

USHORT FuSlideSelection::GetTargetPage(const Point& rPoint) const
{
	USHORT			nResult;
	SdDrawDocument* pDoc		  = pSlView->GetDoc();
	USHORT			nNumOfPages   = pDoc->GetSdPageCount(PK_STANDARD);

	USHORT			nPagesPerRow  = pSlView->GetPagesPerRow();
	Size			aPageSize	  = pDoc->GetSdPage(0, PK_STANDARD)->GetSize();
	ULONG			nGap		  = pSlView->GetPageGap();

	USHORT			nColumn;
	USHORT			nRow;
	Point			aWorkPoint;

	if (rPoint.X() < (long)(nGap + aPageSize.Width()))
	{
		nColumn = 0;
	}
	else
	{
		aWorkPoint = rPoint;
		aWorkPoint.X() += aPageSize.Width() / 2;
		nColumn = (USHORT)(aWorkPoint.X() / (aPageSize.Width() + nGap));
		nColumn = Min(nColumn, (USHORT)(nPagesPerRow - 1));
	}

	if (rPoint.Y() < (long)(nGap + aPageSize.Height()))
	{
		nRow = 0;
	}
	else
	{
		aWorkPoint = rPoint;
		aWorkPoint.Y() -= nGap / 2;
		nRow = (USHORT)(aWorkPoint.Y() / (aPageSize.Height() + nGap));
		nRow = Min(nRow, (USHORT)(nNumOfPages / nPagesPerRow));
	}

	nResult = nRow * nPagesPerRow + nColumn;		// die getroffene Seite
	nResult = Min(nResult, (USHORT)(nNumOfPages - 1));

	// linke oder rechte Hlfte getroffen?
	Rectangle	aPageRect(pSlView->GetPageArea(nResult));
	long		nCenter = aPageRect.TopLeft().X();
	nCenter += aPageRect.GetWidth() / 2;

	// links getroffen, also hinter Vorgaengerseite einfuegen
	if (rPoint.X() < nCenter)
		nResult--;

	return nResult;
}

// -----------------------------------------------------------------------------

Point FuSlideSelection::CalcPosOfInsertMarker( const Point& rPoint )
{
	Point  aResult;
	USHORT nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);

	USHORT nTargetPage = GetTargetPage(rPoint);

	if (nTargetPage == (USHORT)-1)
	{
		nTargetPage = 0;
	}

	Size  aPageSize   = pDoc->GetSdPage(0, PK_STANDARD)->GetSize();

	Point aTargetPagePoint	= pSlView->CalcPagePos(nTargetPage);
	Point aWorkPoint(aTargetPagePoint);
	aWorkPoint.X()	 += aPageSize.Width() / 2;		// Seitenzentrum
	aWorkPoint.Y()	 += aPageSize.Height() / 2;

	// wenn es eine Folgeseite gibt: Marke hinter Zielseite oder vor Folgeseite
	if (nTargetPage < nNoOfPages - 1)
	{
		Point aNextPagePoint = pSlView->CalcPagePos(nTargetPage + 1);
		Point aNextCenter	 = aNextPagePoint;
		aNextCenter.X() 	+= aPageSize.Width() / 2;
		aNextCenter.Y() 	+= aPageSize.Height() / 2;

		Point aToTarget = rPoint - aWorkPoint;
		float fToTarget = aToTarget.X() * (float)aToTarget.X() +
						  aToTarget.Y() * (float)aToTarget.Y();

		Point aToNext	= rPoint - aNextCenter;
		float fToNext	= aToNext.X() * (float)aToNext.X() +
							aToNext.Y() * (float)aToNext.Y();

		if (fToNext < fToTarget)
		{
			aWorkPoint = aNextCenter;
		}
	}

	if (rPoint.X() < aWorkPoint.X())
	{
		aWorkPoint.X() -= aPageSize.Width() / 2;	  // zurueck zum Ursprung
		aWorkPoint.Y() -= aPageSize.Height() / 2;
		aResult 		= aWorkPoint;
		aResult.X()    -= pSlView->GetPageGap() * 5 / 8;
	}
	else
	{
		aWorkPoint.X() -= aPageSize.Width() / 2;	  // zurueck zum Ursprung
		aWorkPoint.Y() -= aPageSize.Height() / 2;
		aResult 		= aWorkPoint;
		aResult.X()    += aPageSize.Width() + pSlView->GetPageGap() * 3 / 8;
	}
	return aResult;
}

// -----------------------------------------------------------------------------

void FuSlideSelection::CreateSubst()
{
    for( USHORT nPage = 0, nNoOfPages = pDoc->GetSdPageCount( PK_STANDARD ); nPage < nNoOfPages; nPage++ )
	{
		SdPage* pTestPage = pDoc->GetSdPage( nPage, PK_STANDARD );

		if( pTestPage->IsSelected() )
			aSubstList.Insert( new Rectangle( pSlView->GetPageArea( nPage ) ), LIST_APPEND ); 
	}
}

// -----------------------------------------------------------------------------

void FuSlideSelection::DeleteSubst()
{
	while (aSubstList.Count() > 0)
	{
		delete (Rectangle*)aSubstList.Remove((ULONG)0);
	}
}

// -----------------------------------------------------------------------------

void FuSlideSelection::ChangeSubstPos(const Point& rVector)
{
	Rectangle * pRect	   = NULL;
	ULONG		nNoOfSubst = aSubstList.Count();
	ULONG		nSubst;
	for (nSubst = 0; nSubst < nNoOfSubst; nSubst++)
	{
		pRect = (Rectangle*)aSubstList.GetObject(nSubst);
		pRect->SetPos(rVector + pRect->TopLeft());
	}
}

// -----------------------------------------------------------------------------

void FuSlideSelection::ShowEffect(USHORT nPageNo)
{
	FSS_IsShowingEffectInfo* pInfo = pIsShowingEffectInfo;

	if( pInfo )
		pInfo->bIsShowingEffect = TRUE;

	SdPage* 	 pPage	   = pDoc->GetSdPage(nPageNo, PK_STANDARD);
	Size		 aPageSize = pPage->GetSize();

	// korrigierte Seitengroesse, sonst kommt die letzte Pixelreihe(spalte)
	// nicht mit
	Size aCPageSize(aPageSize);
	Size aPixelSize = pWindow->PixelToLogic(Size(1,1));
	aCPageSize.Width()	+= aPixelSize.Width();
	aCPageSize.Height() += aPixelSize.Height();

	Point aPagePos = pSlView->CalcPagePos(nPageNo);

	// virtuelle Devices anlegen
	MapMode aMapMode = pWindow->GetMapMode();
	aMapMode.SetOrigin(Point(0,0));

	VirtualDevice* pVDev = new VirtualDevice(*pWindow);
	pVDev->SetMapMode(aMapMode);
	pVDev->SetOutputSize(aCPageSize);

	VirtualDevice* pVDevOld = new VirtualDevice(*pWindow);
	pVDevOld->SetMapMode(aMapMode);
	pVDevOld->SetOutputSize(aCPageSize);

	// Views fuer die virtuellen Devices
	ShowView aShowView(pDoc, pVDev, pViewShell);
	aShowView.SetAllowMasterPageCaching(FALSE);
	aShowView.SetLineDraft(pView->IsLineDraft());
	aShowView.SetFillDraft(pView->IsFillDraft());
	aShowView.SetTextDraft(pView->IsTextDraft());
	aShowView.SetGrafDraft(pView->IsGrafDraft());

	ShowView aShowViewOld(pDoc, pVDevOld, pViewShell);
	aShowViewOld.SetAllowMasterPageCaching(FALSE);
	aShowViewOld.SetLineDraft(pView->IsLineDraft());
	aShowViewOld.SetFillDraft(pView->IsFillDraft());
	aShowViewOld.SetTextDraft(pView->IsTextDraft());
	aShowViewOld.SetGrafDraft(pView->IsGrafDraft());

	// ein Fader zum Ueberblenden
	Fader* pFader = new Fader(pWindow);
	pFader->SetEffect(pPage->GetFadeEffect());
	pFader->SetSpeed(pPage->GetFadeSpeed());
	pFader->SetSource(Rectangle(Point(), aPageSize));
	pFader->SetTarget(Rectangle(aPagePos, aPageSize));

	// Bitmaps in virtuellen Devices bereitstellen
	long nWinZoom = pWindow->GetZoom();
	long nZoom;

    if (nPageNo == 0)
	{
		Rectangle aRect(Point(0,0), aCPageSize);
		pVDevOld->SetFillColor( Color( COL_BLACK ) );
		pVDevOld->DrawRect(aRect);
	}
	else
	{
		// Vorgaengerdia bestimmen
		short nPrevPage = nPageNo - 1;

		nZoom = nWinZoom;
		GraphicObject* pOld = const_cast< GraphicObject* >( pSlView->GetFromCache( pDoc->GetSdPage(nPrevPage, PK_STANDARD), nZoom, -10 ) );
		
        if( !pOld )
		{
			SdPage* pPrevPage = pDoc->GetSdPage(nPrevPage, PK_STANDARD);
			aShowViewOld.ShowPage(pPrevPage, Point(0,0));

			SdrPageView* pPageView = aShowViewOld.GetPageView(pPrevPage);
			FrameView* pFrameView = pViewShell->GetFrameView();
			pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
			pPageView->SetLockedLayers( pFrameView->GetLockedLayers() );
			pPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );
			aShowViewOld.InitRedraw(pVDevOld, Region(Rectangle(Point(), aCPageSize)));
    		while (!aShowViewOld.IsRedrawReady()){}
		}
        else
            pOld->Draw( pVDevOld, Point(), aCPageSize );
	}

	nZoom = nWinZoom;
	GraphicObject* pNew = const_cast< GraphicObject* >( pSlView->GetFromCache( pDoc->GetSdPage(nPageNo, PK_STANDARD), nZoom, -10 ) );
	
    if( !pNew )
	{
		SdPage* pPage = pDoc->GetSdPage(nPageNo, PK_STANDARD);
		aShowView.ShowPage(pPage, Point(0,0));

		SdrPageView* pPageView = aShowView.GetPageView(pPage);
		FrameView* pFrameView = pViewShell->GetFrameView();
		pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
		pPageView->SetLockedLayers( pFrameView->GetLockedLayers() );
		pPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );

		aShowView.InitRedraw(pVDev, Region(Rectangle(Point(0,0), aCPageSize)));
		while (!aShowView.IsRedrawReady()){}
	}
    else
		pNew->Draw( pVDev, Point(), aCPageSize );

	// virtuelle Devices an Fader uebergeben
	pFader->SetOldVirtualDevice(pVDevOld);
	pFader->SetNewVirtualDevice(pVDev);

	// Sound beim Ueberblenden
	if (pPage->IsSoundOn())
	{
		String aSoundFile(pPage->GetSoundFile());
		if (aSoundFile.Len() > 0)
		{
			pSound->Stop();
			pSound->SetSoundName(aSoundFile);
			pSound->Play();
		}
	}

	// ueberblenden
	pFader->Fade();

	delete pFader;
	delete pVDev;
	delete pVDevOld;

	// check IsShowingEffectInfo if we were disposed
	// inside pFader->Fade()
	if( pInfo && !pInfo->bDisposed )
	{
		pInfo->bIsShowingEffect = FALSE;
	}
	else
	{
		// were already dead, so kill the info and quit silently
		delete pInfo;
	}
}

// -----------------------------------------------------------------------------

void FuSlideSelection::ScrollStart()
{
	if ( pView->IsShownXorVisible(pWindow) )
		pView->HideShownXor(pWindow);

	DrawInsertMarker( FALSE );

	if( bSubstShown )
		DrawSubst();
}

// -----------------------------------------------------------------------------

void FuSlideSelection::ScrollEnd()
{
	if( bSubstShown )
		DrawSubst();

	if ( !pView->IsShownXorVisible(pWindow) )
		pView->ShowShownXor(pWindow);
}

// -----------------------------------------------------------------------------

void FuSlideSelection::Paint(const Rectangle& rRect, SdWindow* pWin)
{
	if (bSubstShown && pView->IsShownXorVisible(pWindow))
	{
		DrawSubst();
	}
}

// -----------------------------------------------------------------------------

IMPL_LINK( FuSlideSelection, DragSlideHdl, Timer*, pTimer )
{
	if( bPageHit )
	{
		DrawSubst();
		DeleteSubst();
		DrawInsertMarker( FALSE );
		bPageHit = bSubstShown = FALSE;
		pWindow->ReleaseMouse();
		pView->StartDrag( aDragPos, pWindow );
	}
	
    return 0;
}
