/*************************************************************************
 *
 *  $RCSfile: fuslshw6.cxx,v $
 *
 *  $Revision: 1.10.8.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/06/01 03:12:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#define FUSLIDESHOW_INTERN

#include <vcl/gradient.hxx>
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SVX_XFLHTIT_HXX //autogen
#include <svx/xflhtit.hxx>
#endif
#ifndef _SVX_XGRAD_HXX //autogen
#include <svx/xgrad.hxx>
#endif
#ifndef _SVX_XHATCH_HXX //autogen
#include <svx/xhatch.hxx>
#endif
#ifndef _SVX_XFLHTIT_HXX //autogen
#include <svx/xflhtit.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif
#ifndef _SVX_XLNTRIT_HXX //autogen
#include <svx/xlntrit.hxx>
#endif
#ifndef _SVX_XFLTRIT_HXX //autogen
#include <svx/xfltrit.hxx>
#endif
#ifndef _SVX_XFLFTRIT_HXX //autogen
#include <svx/xflftrit.hxx>
#endif
#ifndef _XOUTX_HXX //autogen
#include <svx/xoutx.hxx>
#endif
#ifndef _SVDOGRP_HXX //autogen
#include <svx/svdogrp.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _SVDOTEXT_HXX //autogen
#include <svx/svdotext.hxx>
#endif
#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif
#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SVDOOLE2_HXX //autogen
#include <svx/svdoole2.hxx>
#endif
#ifndef _SVDITER_HXX //autogen
#include <svx/svditer.hxx>
#endif
#ifndef _IPENV_HXX //autogen
#include <so3/ipenv.hxx>
#endif
#ifndef _SFXSMPLHINT_HXX //autogen
#include <svtools/smplhint.hxx>
#endif
#ifndef _OUTLOBJ_HXX //autogen
#include <svx/outlobj.hxx>
#endif

#include "showview.hxx"
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "anminfo.hxx"
#include "mover.hxx"
#include "glob.hrc"
#include "showview.hxx"
#include "outlinfo.hxx"
#include "fader.hxx"
#include "sprite.hxx"
#include "fuslshow.hxx"

using namespace ::com::sun::star;

// ---------------
// - FuSlideShow -
// ---------------

BOOL FuSlideShow::AnimateObject( SdrObject* pSubstitute )
{
	SdrObject*			pAnmObject = (SdrObject*) pCurAnmList->First();
	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo( pSubstitute ? pSubstitute : pAnmObject );
	BOOL				bAbort = FALSE;

	DBG_ASSERT( pInfo, "keine Animationsinformation gefunden" );

    ( (SdrView*) pView )->SetAnimationPause( TRUE );

	// Animation einer Gliederung ( auch Compound)?
    if( ( pLayoutText == pAnmObject || pCompoundText != NULL ) && pInfo->bShow && !pSubstitute )
		bAbort = !AnimateLayoutText();
    // getrennter Grafik- und Texteffekt?
    else if( pInfo->eTextEffect != presentation::AnimationEffect_NONE )
        bAbort = !CompoundEffect();
	else
	{
		// eine Gliederung? (unsichtbar machen von Gliederungstext geschieht wie bei normalen Objekten)
		if( ( pAnmObject->GetObjInventor() == SdrInventor ) && 
            ( pAnmObject->GetObjIdentifier() == OBJ_OUTLINETEXT ) &&
            pInfo->bShow && ( presentation::AnimationEffect_PATH != pInfo->eEffect ) &&
            !pSubstitute )
		{
			if( pLayoutText && ( pLayoutText != pAnmObject ) )
				pLayoutText = NULL;

			bAbort = !AnimateLayoutText();
		}
		else
		{
			// oder was anderes
			Rectangle						aAnimRect;
			presentation::AnimationEffect	eEffect = pInfo->eEffect;
			presentation::AnimationSpeed	eSpeed = pInfo->eSpeed;
			BOOL							bIsMovie = pInfo->bIsMovie;
			BOOL							bIsSlow = ( GetSlowObjRecord( (SdrAttrObj*) pAnmObject ) != NULL );

			if( eEffect == presentation::AnimationEffect_RANDOM )
				eEffect = RandomAnimationEffect( pInfo->bShow );

			eObjectEffect = eEffect;

			// Abblendinformationen in Membern sichern
			if( pInfo->bDimPrevious && pInfo->bShow )
			{
				aDimColor = pInfo->aDimColor;
				pDimObject = pAnmObject;
                pHideObject = NULL;
			}
            else if( pInfo->bDimHide )
            {
                pHideObject = pAnmObject;
                pDimObject = NULL;
            }
            else
			{
                pHideObject = NULL;
				pDimObject = NULL;
			}

			aAnimRect = pAnmObject->GetBoundRect();

			Size  aTolSize( pShowWindow->PixelToLogic( Size( VDEV_TOLERANCE, VDEV_TOLERANCE ) ) );
			Point aStart, aEnd( aAnimRect.Left() - aTolSize.Width(), aAnimRect.Top() - aTolSize.Height() );

            // jetzt kommt eine kleine Sauerei:
            // presentation::AnimationEffect_NONE wird vom Mover bearbeitet; damit koennen
            // die einzelnen Phasen eines Animationsobjektes an einem Punkt
            // dargestellt werden (macht also nur Sinn fuer Animationsobjekte,
            // pInfo->bIsMovie == TRUE). Ist das Objekt kein Animationsobjekt,
            // so wird angenommen, dass es ohne besonderen Effekt erscheinen soll.
            // Dazu wird der Effekt auf ANIMATION_EFFECT_HIDE umgesetzt, das
            // von EffectAToF() wieder auf NONE gemappt wird. Sinn der ganzen
            // Sache: Abarbeitung im zweiten case-Zweig (Fader, nicht Mover).
            // Das gleiche machen wir fuer ein Objekt, das einen inaktivierten Effekt hat.
            if( eEffect == presentation::AnimationEffect_NONE && !pInfo->bIsMovie || !pInfo->bActive )
                eEffect = presentation::AnimationEffect_HIDE;

			StopTextOrGraphicAnimation( pAnmObject, TRUE );
			
			switch( eEffect )
			{
				case presentation::AnimationEffect_MOVE_FROM_LEFT:
				case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:
				case presentation::AnimationEffect_MOVE_FROM_TOP:
				case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:
				case presentation::AnimationEffect_MOVE_FROM_RIGHT :
				case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:
				case presentation::AnimationEffect_MOVE_FROM_BOTTOM:
				case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:
				case presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT:
				case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT:
				case presentation::AnimationEffect_MOVE_SHORT_FROM_TOP:
				case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT:
				case presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT:
				case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT:
				case presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM:
				case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT:
				case presentation::AnimationEffect_MOVE_TO_LEFT:
				case presentation::AnimationEffect_MOVE_TO_UPPERLEFT:
				case presentation::AnimationEffect_MOVE_TO_TOP:
				case presentation::AnimationEffect_MOVE_TO_UPPERRIGHT:
				case presentation::AnimationEffect_MOVE_TO_RIGHT :
				case presentation::AnimationEffect_MOVE_TO_LOWERRIGHT:
				case presentation::AnimationEffect_MOVE_TO_BOTTOM:
				case presentation::AnimationEffect_MOVE_TO_LOWERLEFT:
				case presentation::AnimationEffect_MOVE_SHORT_TO_LEFT:
				case presentation::AnimationEffect_MOVE_SHORT_TO_UPPERLEFT:
				case presentation::AnimationEffect_MOVE_SHORT_TO_TOP:
				case presentation::AnimationEffect_MOVE_SHORT_TO_UPPERRIGHT:
				case presentation::AnimationEffect_MOVE_SHORT_TO_RIGHT:
				case presentation::AnimationEffect_MOVE_SHORT_TO_LOWERRIGHT:
				case presentation::AnimationEffect_MOVE_SHORT_TO_BOTTOM:
				case presentation::AnimationEffect_MOVE_SHORT_TO_LOWERLEFT:
				case presentation::AnimationEffect_STRETCH_FROM_LEFT:
				case presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT:
				case presentation::AnimationEffect_STRETCH_FROM_TOP:
				case presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT:
				case presentation::AnimationEffect_STRETCH_FROM_RIGHT:
				case presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT:
				case presentation::AnimationEffect_STRETCH_FROM_BOTTOM:
				case presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT:
				case presentation::AnimationEffect_HORIZONTAL_STRETCH:
				case presentation::AnimationEffect_VERTICAL_STRETCH:
				case presentation::AnimationEffect_HORIZONTAL_ROTATE:
				case presentation::AnimationEffect_VERTICAL_ROTATE:
				case presentation::AnimationEffect_PATH:
				case presentation::AnimationEffect_NONE:
                {
					Point			aUpperLeft( pActualPage->GetLftBorder(), pActualPage->GetUppBorder() );
					Point			aLowerRight( pActualPage->GetSize().Width() - pActualPage->GetRgtBorder(),
												 pActualPage->GetSize().Height() - pActualPage->GetLwrBorder() );
					List			aListOfImages;
					double			fStartScaleX = 1.0, fEndScaleX = 1.0, fStartScaleY = 1.0, fEndScaleY = 1.0;

					pMetaFile->Play( pVDev, MTF_START, OBJ_START( pAnmObject, bIsSlow ) );
					UpdateVDevWithAnimations();

					switch( eEffect )
					{
						case presentation::AnimationEffect_MOVE_FROM_LEFT:
							aStart.X() = aUpperLeft.X() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aStart.Y() = aEnd.Y();
						break;

						case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:
							aStart.X() = aUpperLeft.X() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aStart.Y() = aUpperLeft.Y() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_FROM_TOP:
							aStart.X() = aEnd.X();
							aStart.Y() = aUpperLeft.Y() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:
							aStart.X() = aLowerRight.X();
							aStart.Y() = aUpperLeft.Y() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_FROM_RIGHT:
							aStart.X() = aLowerRight.X();
							aStart.Y() = aEnd.Y();
						break;

						case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:
							aStart.X() = aLowerRight.X();
							aStart.Y() = aLowerRight.Y();
						break;

						case presentation::AnimationEffect_MOVE_FROM_BOTTOM:
							aStart.X() = aEnd.X();
							aStart.Y() = aLowerRight.Y();
						break;

						case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:
							aStart.X() = aUpperLeft.X() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aStart.Y() = aLowerRight.Y();
						break;

						case presentation::AnimationEffect_MOVE_TO_LEFT:
							aStart = aEnd;
							aEnd.X() = aUpperLeft.X() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aEnd.Y() = aStart.Y();
						break;

						case presentation::AnimationEffect_MOVE_TO_UPPERLEFT:
							aStart = aEnd;
							aEnd.X() = aUpperLeft.X() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aEnd.Y() = aUpperLeft.Y() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_TO_TOP:
							aStart = aEnd;
							aEnd.X() = aStart.X();
							aEnd.Y() = aUpperLeft.Y() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_TO_UPPERRIGHT:
							aStart = aEnd;
							aEnd.X() = aLowerRight.X();
							aEnd.Y() = aUpperLeft.Y() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_TO_RIGHT:
							aStart = aEnd;
							aEnd.X() = aLowerRight.X();
							aEnd.Y() = aStart.Y();
						break;

						case presentation::AnimationEffect_MOVE_TO_LOWERRIGHT:
							aStart = aEnd;
							aEnd.X() = aLowerRight.X();
							aEnd.Y() = aLowerRight.Y();
						break;

						case presentation::AnimationEffect_MOVE_TO_BOTTOM:
							aStart = aEnd;
							aEnd.X() = aStart.X();
							aEnd.Y() = aLowerRight.Y();
						break;

						case presentation::AnimationEffect_MOVE_TO_LOWERLEFT:
							aStart = aEnd;
							aEnd.X() = aUpperLeft.X() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aEnd.Y() = aLowerRight.Y();
						break;

						// ---

						case presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT:
							aStart.X() = aAnimRect.Left() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aStart.Y() = aEnd.Y();
						break;

						case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT:
							aStart.X() = aAnimRect.Left() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aStart.Y() = aAnimRect.Top() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_SHORT_FROM_TOP:
							aStart.X() = aEnd.X();
							aStart.Y() = aAnimRect.Top() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT:
							aStart.X() = aAnimRect.Right();
							aStart.Y() = aAnimRect.Top() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT:
							aStart.X() = aAnimRect.Right();
							aStart.Y() = aEnd.Y();
						break;

						case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT:
							aStart.X() = aAnimRect.Right();
							aStart.Y() = aAnimRect.Bottom();
						break;

						case presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM:
							aStart.X() = aEnd.X();
							aStart.Y() = aAnimRect.Bottom();
						break;

						case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT:
							aStart.X() = aAnimRect.Left() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aStart.Y() = aAnimRect.Bottom();
						break;

						// ----

						case presentation::AnimationEffect_MOVE_SHORT_TO_LEFT:
							aStart = aEnd;
							aEnd.X() = aAnimRect.Left() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aEnd.Y() = aStart.Y();
						break;

						case presentation::AnimationEffect_MOVE_SHORT_TO_UPPERLEFT:
							aStart = aEnd;
							aEnd.X() = aAnimRect.Left() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aEnd.Y() = aAnimRect.Top() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_SHORT_TO_TOP:
							aStart = aEnd;
							aEnd.X() = aStart.X();
							aEnd.Y() = aAnimRect.Top() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_SHORT_TO_UPPERRIGHT:
							aStart = aEnd;
							aEnd.X() = aAnimRect.Right();
							aEnd.Y() = aAnimRect.Top() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
						break;

						case presentation::AnimationEffect_MOVE_SHORT_TO_RIGHT:
							aStart = aEnd;
							aEnd.X() = aAnimRect.Right();
							aEnd.Y() = aStart.Y();
						break;

						case presentation::AnimationEffect_MOVE_SHORT_TO_LOWERRIGHT:
							aStart = aEnd;
							aEnd.X() = aAnimRect.Right();
							aEnd.Y() = aAnimRect.Bottom();
						break;

						case presentation::AnimationEffect_MOVE_SHORT_TO_BOTTOM:
							aStart = aEnd;
							aEnd.X() = aStart.X();
							aEnd.Y() = aAnimRect.Bottom();
						break;

						case presentation::AnimationEffect_MOVE_SHORT_TO_LOWERLEFT:
							aStart = aEnd;
							aEnd.X() = aAnimRect.Left() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
							aEnd.Y() = aAnimRect.Bottom();
						break;

						// ----

						case presentation::AnimationEffect_STRETCH_FROM_LEFT:
							aStart = aEnd;
							fStartScaleX = 0.0;
						break;

						case presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT:
							aStart = aEnd;
							fStartScaleX = fStartScaleY = 0.0;
						break;

						case presentation::AnimationEffect_STRETCH_FROM_TOP:
							aStart = aEnd;
							fStartScaleY = 0.0;
						break;

						case presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT:
							aStart = aAnimRect.TopRight();
							fStartScaleX = fStartScaleY = 0.0;
						break;

						case presentation::AnimationEffect_STRETCH_FROM_RIGHT:
							aStart.X() = aAnimRect.Right();
							aStart.Y() = aEnd.Y();
							fStartScaleX = 0.0;
						break;

						case presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT:
							aStart.X() = aAnimRect.Right();
							aStart.Y() = aAnimRect.Bottom();
							fStartScaleX = fStartScaleY = 0.0;
						break;

						case presentation::AnimationEffect_STRETCH_FROM_BOTTOM:
							aStart.X() = aEnd.X();
							aStart.Y() = aAnimRect.Bottom();
							fStartScaleY = 0.0;
						break;

						case presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT:
							aStart.X() = aEnd.X();
							aStart.Y() = aAnimRect.Bottom();
							fStartScaleX = fStartScaleY = 0.0;
						break;

						// ----

						case presentation::AnimationEffect_HORIZONTAL_STRETCH:
						case presentation::AnimationEffect_HORIZONTAL_ROTATE:
							aStart.X() = aAnimRect.Center().X();
							aStart.Y() = aEnd.Y();
							fStartScaleX = 0.0;
						break;

						case presentation::AnimationEffect_VERTICAL_STRETCH:
						case presentation::AnimationEffect_VERTICAL_ROTATE:
							aStart.X() = aEnd.X();
							aStart.Y() = aAnimRect.Center().Y();
							fStartScaleY = 0.0;
						break;

						// ----
						
						case presentation::AnimationEffect_NONE:
							DBG_ASSERT( bIsMovie, "NONE works only with Movies" );
							aStart = aEnd;
						break;

					}

					const Marker	aStartMarker( OBJ_START( pAnmObject, bIsSlow ) );
					const Marker	aEndMarker( OBJ_END( pAnmObject, bIsSlow ) );
					Region			aClipRegion;

					// short effect or normal effect => set correct clip region
					if( presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_TOP == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT == eEffect ||
					
						presentation::AnimationEffect_MOVE_SHORT_TO_LEFT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_TO_UPPERLEFT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_TO_TOP == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_TO_UPPERRIGHT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_TO_RIGHT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_TO_LOWERRIGHT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_TO_BOTTOM == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_TO_LOWERLEFT == eEffect ||

						presentation::AnimationEffect_STRETCH_FROM_LEFT == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_TOP == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_RIGHT == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_BOTTOM == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT == eEffect ||

						presentation::AnimationEffect_HORIZONTAL_STRETCH == eEffect ||
						presentation::AnimationEffect_VERTICAL_STRETCH == eEffect ||

						presentation::AnimationEffect_HORIZONTAL_ROTATE == eEffect ||
						presentation::AnimationEffect_VERTICAL_ROTATE == eEffect )
					{
						pMover->SetClipRegion( aAnimRect );
					}
					else
						pMover->SetClipRegion( Rectangle( aUpperLeft, aLowerRight ) );

					// fill list of images
					if( ( bAbort = !AdjustAnmVDev( aAnimRect, COL_WHITE ) ) == TRUE )
						HandleError( STR_NOT_ENOUGH_MEMORY );
					else
					{
						ExtOutputDevice aOut( pAnmVDev );
						SdrPaintInfoRec aPaintInfoRec;

						SetPaintModes((SdrView*)pView, NULL, &aOut, &aPaintInfoRec);
						pAnmVDev->SetDrawMode( pShowWindow->GetDrawMode() );
						DisableFontSmoothing();

						if( pInfo->bIsMovie )
						{
							SdrObjList* pObjList = ( (SdrObjGroup*) pAnmObject )->GetSubList();

							for( USHORT nObject = 0; nObject < pObjList->GetObjCount(); nObject++ )
								aListOfImages.Insert( new BitmapEx( CreateReplacement( (SdrObject*) pObjList->GetObj( (ULONG) nObject ), &aOut ) ) );
						}
						else if( pAnmObject == pLayoutText )
						{
							PaintLayoutClone( pAnmVDev );
							aListOfImages.Insert( new BitmapEx( pAnmVDev->GetBitmap( pAnmVDev->PixelToLogic( Point() ),
																					 pAnmVDev->GetOutputSize() ), COL_WHITE ),
												  LIST_APPEND );
						}
						else
						{
							aListOfImages.Insert( new BitmapEx( CreateReplacement( ( !pInfo->bDimmed && pSubstitute ) ?
																				   pSubstitute : pAnmObject, &aOut ) ),
												  LIST_APPEND );
						}
						
						EnableFontSmoothing();
						pAnmVDev->SetDrawMode( DRAWMODE_DEFAULT );
					}

					if( !bAbort && aListOfImages.Count() )
					{
						pMover->SetGraphicInfo( pVDev, &pMetaFile, aStartMarker, aEndMarker );
						pMover->SetListOfImages( &aListOfImages );
						pMover->SetSpeed( SpeedAToM( eSpeed ), 1 );

						// set correct path
						if( ( eEffect == presentation::AnimationEffect_PATH ) && pInfo->pPathObj )
						{
							XPolyPolygon			aXPolyPoly( pInfo->pPathObj->GetPathPoly() );
							const presentation::AnimationEffect	eOldTextEffect = pInfo->eTextEffect;
							const BOOL				bOldShow = pInfo->bShow;

							pCurAnmList->Remove( pLayoutText );
							pDimObject = NULL;
							pHideObject = NULL;
							pInfo->bShow = FALSE;
							pInfo->eEffect = presentation::AnimationEffect_HIDE;
							pInfo->eTextEffect = presentation::AnimationEffect_NONE;
							AnimateObject();

							// und jetzt Objekt noch einmal am Pfad animieren
							pCurAnmList->Insert( pAnmObject, (ULONG) 0 );
							pInfo->eEffect = presentation::AnimationEffect_PATH;
							pInfo->eTextEffect = eOldTextEffect;
							pInfo->bShow = bOldShow;

							if( aXPolyPoly.Count() )
							{
								const XPolygon& rLastPoly = aXPolyPoly[ aXPolyPoly.Count() - 1 ];
								
								if( rLastPoly.GetPointCount() )
								{
									const long nDiffX = ( aAnimRect.GetWidth() >> 1 ) + aTolSize.Width();
									const long nDiffY = ( aAnimRect.GetHeight() >> 1 ) + aTolSize.Height();

									aXPolyPoly.Move( -nDiffX, -nDiffY );
									pMover->SetPath( aXPolyPoly );
								} 
							}
						}
						else
							pMover->SetPath( aStart, aEnd, &fStartScaleX, &fEndScaleX, &fStartScaleY, &fEndScaleY );

						if( pInfo->bSoundOn )
						{
							bPlayFull = pInfo->bPlayFull;
							StartSound(pInfo->aSoundFile);
						}

						bAbort = !pMover->Move();

						if( !bAbort && 
							eEffect == presentation::AnimationEffect_HORIZONTAL_ROTATE || 
							eEffect == presentation::AnimationEffect_VERTICAL_ROTATE )
						{
							const Point	aMediumPos( aStart ), aFinalPos( aEnd );

							for( long i = 0; ( i < 4 ) && !bAbort; i++ )
							{
								const BOOL		bOdd = ( ( i & 1 ) != 0 );
								const Point*	pStart = bOdd ? &aMediumPos : &aFinalPos;
								const Point*	pEnd = bOdd ? &aFinalPos : &aMediumPos;

								if( eEffect == presentation::AnimationEffect_HORIZONTAL_ROTATE )
								{
									fStartScaleX = bOdd ? 0.0 : 1.0;
									fEndScaleX = bOdd ? 1.0 : 0.0;
								}
								else
								{
									fStartScaleY = bOdd ? 0.0 : 1.0;
									fEndScaleY = bOdd ? 1.0 : 0.0;
								}

								pMover->SetPath( *pStart, *pEnd, &fStartScaleX, &fEndScaleX, &fStartScaleY, &fEndScaleY );
								bAbort = !pMover->Move();

                                if( nMagic != SLIDESHOW_MAGIC )
                                {
                                    break;
                                }
							}
						}

						for( void* pBmpEx = aListOfImages.First(); pBmpEx; pBmpEx = aListOfImages.Next() )
							delete (BitmapEx*) pBmpEx;
						
						if( nMagic != SLIDESHOW_MAGIC )
							return TRUE;
					}

					// merken fuers abblenden
					aDimRect = Rectangle( pAnmVDev->PixelToLogic( Point() ), pAnmVDev->GetOutputSize() );
				}
				break;

				case presentation::AnimationEffect_APPEAR:
				case presentation::AnimationEffect_FADE_FROM_LEFT:
				case presentation::AnimationEffect_FADE_FROM_UPPERLEFT:
				case presentation::AnimationEffect_FADE_FROM_TOP:
				case presentation::AnimationEffect_FADE_FROM_UPPERRIGHT:
				case presentation::AnimationEffect_FADE_FROM_RIGHT:
				case presentation::AnimationEffect_FADE_FROM_BOTTOM:
				case presentation::AnimationEffect_FADE_FROM_LOWERRIGHT:
				case presentation::AnimationEffect_FADE_FROM_LOWERLEFT:
				case presentation::AnimationEffect_FADE_TO_CENTER:
				case presentation::AnimationEffect_FADE_FROM_CENTER:
				case presentation::AnimationEffect_VERTICAL_STRIPES:
				case presentation::AnimationEffect_HORIZONTAL_STRIPES:
				case presentation::AnimationEffect_VERTICAL_LINES:
				case presentation::AnimationEffect_HORIZONTAL_LINES:
				case presentation::AnimationEffect_VERTICAL_CHECKERBOARD:
				case presentation::AnimationEffect_HORIZONTAL_CHECKERBOARD:
				case presentation::AnimationEffect_CLOCKWISE:
				case presentation::AnimationEffect_COUNTERCLOCKWISE:
				case presentation::AnimationEffect_CLOSE_VERTICAL:
				case presentation::AnimationEffect_CLOSE_HORIZONTAL:
				case presentation::AnimationEffect_OPEN_VERTICAL:
				case presentation::AnimationEffect_OPEN_HORIZONTAL:
				case presentation::AnimationEffect_SPIRALIN_LEFT:
				case presentation::AnimationEffect_SPIRALIN_RIGHT:
				case presentation::AnimationEffect_SPIRALOUT_LEFT:
				case presentation::AnimationEffect_SPIRALOUT_RIGHT:
				case presentation::AnimationEffect_DISSOLVE:
				case presentation::AnimationEffect_WAVYLINE_FROM_LEFT:
				case presentation::AnimationEffect_WAVYLINE_FROM_TOP:
				case presentation::AnimationEffect_WAVYLINE_FROM_RIGHT:
				case presentation::AnimationEffect_WAVYLINE_FROM_BOTTOM:
				case presentation::AnimationEffect_HIDE:
				{
					bAbort = !AdjustAnmVDev( aAnimRect, COL_WHITE );

					if( bAbort )
						HandleError( STR_NOT_ENOUGH_MEMORY );
					else
					{
						Rectangle aTolRect( aAnimRect );

						aTolRect.Left() -= aTolSize.Width(); aTolRect.Top() -= aTolSize.Height();
						aTolRect.Right() += aTolSize.Height(); aTolRect.Bottom() += aTolSize.Height();

						pMetaFile->Play( pAnmVDev, MTF_START, FIRST_START );

                        // soll das Objekt nicht aus dem Metafile sondern durch
                        // eine Ersatzdarstellung gezeichnet werden?
                        if( pSubstitute )
                        {
							pMetaFile->Play( pAnmVDev, FIRST_START, OBJ_START( pAnmObject, bIsSlow ) );
                            ExtOutputDevice aOut(pAnmVDev);
							SdrPaintInfoRec aPaintInfoRec;
							SetPaintModes((SdrView*)pView, NULL, &aOut, &aPaintInfoRec);
							pAnmVDev->SetDrawMode( pShowWindow->GetDrawMode() );
                            pSubstitute->Paint(aOut, aPaintInfoRec);
							pAnmVDev->SetDrawMode( DRAWMODE_DEFAULT );
							pMetaFile->Play( pAnmVDev, OBJ_END( pAnmObject, bIsSlow ), MTF_END );
                        }
						else if( ( eEffect != presentation::AnimationEffect_HIDE ) && OBJIS_GRAFANIM( pAnmObject ) )
						{
							// Animation muss getrennt aufbereitet werden, da diese nicht im MetaFile enthalten ist
							pMetaFile->Play( pAnmVDev, FIRST_START, OBJ_START( pAnmObject, bIsSlow ) );
							DrawOrStartAnimation( pAnmObject, pAnmVDev, FALSE, FALSE );
							pMetaFile->Play( pAnmVDev, OBJ_END( pAnmObject, bIsSlow ), MTF_END );
						}
                        else
							pMetaFile->Play( pAnmVDev, FIRST_START, MTF_END );

						pFader->SetNewVirtualDevice( pAnmVDev );

						Point		aUpperLeft(pActualPage->GetLftBorder(), pActualPage->GetUppBorder());
						Point		aLowerRight(pActualPage->GetSize().Width() - pActualPage->GetRgtBorder(),
												pActualPage->GetSize().Height() - pActualPage->GetLwrBorder());

						aTolRect.Intersection( Rectangle( aUpperLeft, aLowerRight ) );
						pFader->SetTarget( aTolRect );
						pFader->SetSource( aTolRect );
						pFader->SetSpeed( SpeedAToF( eSpeed ) );
						pFader->SetEffect( EffectAToF( eEffect ) );

						if( pInfo->bSoundOn )
						{
							bPlayFull = pInfo->bPlayFull;
							StartSound( pInfo->aSoundFile );
						}

						pFader->Fade();
                        
						if( nMagic != SLIDESHOW_MAGIC )
                            return TRUE;

						// merken fuers abblenden, falls das Objekt nicht
						// versteckt wurde
						if( pInfo->bShow )
							aDimRect = Rectangle( pAnmVDev->PixelToLogic( Point() ), pAnmVDev->GetOutputSize() );
					}
				}
				break;
			}

			// GGf. die Animation wieder starten
			if( pInfo->bShow )
			{
				// animierte Grafik starten
				if( OBJIS_GRAFANIM( pAnmObject ) )
				{
					Rectangle aRect( ( (SdrGrafObj*) pAnmObject )->GetAnimationRect( pShowWindow ) );

					pMetaFile->Play( pAnmVDev, MTF_START, MTF_END );
					pShowWindow->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
											 aRect.TopLeft(), aRect.GetSize(),
											 *pAnmVDev);

					// Animation starten oder zeichnen
					DrawOrStartAnimation( (SdrGrafObj*) pAnmObject, pShowWindow, bAnimationAllowed, TRUE );
					pCurAnimGraphs->Insert( pAnmObject, LIST_APPEND );
				}
			}

			pCurAnmList->Remove( (ULONG) 0 );
		}
	}

    ( (SdrView*) pView )->SetAnimationPause( FALSE );

	if( bAbort )
		StopShow();

	return( !bAbort );
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::AnimateLayoutText()
{
	BOOL bAbort = FALSE, bInit = FALSE;

	// beim ersten Durchlauf Membervariablen initialisieren
	if( !pLayoutText )
	{
		if( pCompoundText )
		{
			// Zuweisung des TextClones, der in CompoundEffect erzeugt wurde
			pLayoutClone = pCompoundText;
			pLayoutText = (SdrRectObj*) pCurAnmList->First();
			pCompoundText = NULL;
			bIsCompoundLayoutText = TRUE;
		}
		else
		{
			pLayoutText = (SdrRectObj*) pCurAnmList->First();
			pLayoutClone = (SdrRectObj*)((SdrTextObj*)pLayoutText)->Clone();
			bIsCompoundLayoutText = FALSE;
		}

		bInit = TRUE;
		nParaPos = nDimPos = 0L;		
		eRandomLayout = presentation::AnimationEffect_NONE;
		bFullBckgnd = FALSE;
		
		delete pLayoutClip;
		pLayoutClip = NULL;
		
		delete pLayoutBmpEx;
		pLayoutBmpEx = NULL;
	}

	// die Animationsinformation holen
	SdAnimationInfo*				pInfo = pDoc->GetAnimationInfo( pLayoutText );
	presentation::AnimationEffect	eEffect;
	presentation::AnimationSpeed	eSpeed = pInfo->eSpeed;

	// richtigen Effekt bestimmen
	if( !bIsCompoundLayoutText )
		eEffect = pInfo->eEffect;
	else
	{
		// nach der Initalisierung ( ab 2. Absatz ) wird der TextEffekt
		// des CompoundEffects an der OutlinerInfo gehalten, da der
		// LayoutClone (init. ==pCompoundText) waehrend der Animation
		// evtl. geloescht und neu erzeugt wird, wodurch der Texteffekt
		// verloren geht und auf den Objekteffekt zurueckgesetzt wird
		if( bInit )
			eEffect = pDoc->GetAnimationInfo( pLayoutClone )->eEffect;
		else
			eEffect = (presentation::AnimationEffect) pOutlInfo->GetExtraData();
	}

	// Zufallseffekt bevorzugen bzw. erzeugen
	if( eRandomLayout != presentation::AnimationEffect_NONE )
		eEffect = eRandomLayout;
	else if( eEffect == presentation::AnimationEffect_RANDOM )
		eEffect = eRandomLayout = RandomAnimationEffect( TRUE );

	// merken ( z.B. fuer DimLayoutParagraph )
	eObjectEffect = eEffect;

    // Abblendinformationen in Membern sichern
    if( pInfo->bDimPrevious )
    {
       if( bInit )
           aDimColor = pInfo->aDimColor;

       // muss bei jedem Durchlauf neu gesetzt werden, da es nach dem
       // Abblenden eines Absatzes zurueckgesetzt wird
       pDimObject = pLayoutText;
    }
    else
        pDimObject = NULL;

	pHideObject = NULL;

	Rectangle	aObjRect( pLayoutText->GetBoundRect() );
	const Size	aTolSize( pShowWindow->PixelToLogic( Size( VDEV_TOLERANCE, VDEV_TOLERANCE ) ) );

	// MapMode, Groesse und Hintergrundfarbe des Animationsdevice setzen
	if( bInit )
	{
		BOOL bIsSlow = GetSlowObjRecord( (SdrAttrObj*) pLayoutText ) != NULL;

		bAbort = !AdjustAnmVDev( aObjRect, COL_WHITE );
		pMetaFile->Play( pVDev, MTF_START, OBJ_START( pLayoutText, bIsSlow ) );

		// wenn der Fader benutzt wird, muss alles ins Animationsdevice gezeichnet werden
		switch( eEffect )
		{
			case( presentation::AnimationEffect_APPEAR ):
			case( presentation::AnimationEffect_FADE_FROM_LEFT ):
			case( presentation::AnimationEffect_FADE_FROM_UPPERLEFT ):
			case( presentation::AnimationEffect_FADE_FROM_TOP ):
			case( presentation::AnimationEffect_FADE_FROM_UPPERRIGHT ):
			case( presentation::AnimationEffect_FADE_FROM_RIGHT ):
			case( presentation::AnimationEffect_FADE_FROM_LOWERRIGHT ):
			case( presentation::AnimationEffect_FADE_FROM_BOTTOM ):
			case( presentation::AnimationEffect_FADE_FROM_LOWERLEFT ):
			case( presentation::AnimationEffect_FADE_TO_CENTER ):
			case( presentation::AnimationEffect_FADE_FROM_CENTER ):
			case( presentation::AnimationEffect_VERTICAL_STRIPES ):
			case( presentation::AnimationEffect_HORIZONTAL_STRIPES ):
			case( presentation::AnimationEffect_VERTICAL_LINES ):
			case( presentation::AnimationEffect_HORIZONTAL_LINES ):
			case( presentation::AnimationEffect_VERTICAL_CHECKERBOARD ):
			case( presentation::AnimationEffect_HORIZONTAL_CHECKERBOARD ):
			case( presentation::AnimationEffect_CLOCKWISE ):
			case( presentation::AnimationEffect_COUNTERCLOCKWISE ):
			case( presentation::AnimationEffect_CLOSE_VERTICAL ):
			case( presentation::AnimationEffect_CLOSE_HORIZONTAL ):
			case( presentation::AnimationEffect_OPEN_VERTICAL ):
			case( presentation::AnimationEffect_OPEN_HORIZONTAL ):
			case( presentation::AnimationEffect_SPIRALIN_LEFT ):
			case( presentation::AnimationEffect_SPIRALIN_RIGHT ):
			case( presentation::AnimationEffect_SPIRALOUT_LEFT ):
			case( presentation::AnimationEffect_SPIRALOUT_RIGHT ):
			case( presentation::AnimationEffect_DISSOLVE	):
			case( presentation::AnimationEffect_WAVYLINE_FROM_LEFT ):
			case( presentation::AnimationEffect_WAVYLINE_FROM_TOP ):
			case( presentation::AnimationEffect_WAVYLINE_FROM_RIGHT ):
			case( presentation::AnimationEffect_WAVYLINE_FROM_BOTTOM ):
			{
				Rectangle	aTolRect( aObjRect );
				const ULONG	nTrueParaPos = nParaPos;

				aTolRect.Left() -= aTolSize.Width();
				aTolRect.Top() -= aTolSize.Height();
				aTolRect.Right() += aTolSize.Height();
				aTolRect.Bottom() += aTolSize.Height();

				pMetaFile->Play( pVDev, OBJ_END( pLayoutText, bIsSlow ), MTF_END );
				UpdateVDevWithAnimations();

				// den Hintergrund SCHNELL zeichnen
				pAnmVDev->DrawOutDev( aTolRect.TopLeft(), aTolRect.GetSize(),
									  aTolRect.TopLeft(), aTolRect.GetSize(), *pVDev );

				// den Rest einschliesslich des Objektes aus dem
				// Metafile zeichnen
				// Beim Abspielen des Metafiles wird eine animierte Gliederung
				// immer durch die Darstellung des Layout-Clones ersetzt.
				// Paint LayoutClone() zeichnet aber nur bis ausschliesslich
				// nParaPos; darum nParaPos kurzfristig auf die Absatzanzahl
				// setzen, damit alle Absaetze gezeichnet werden.
				nParaPos = pLayoutText->GetOutlinerParaObject()->Count();
				pMetaFile->Play( pAnmVDev, FIRST_START, MTF_END );
				nParaPos = nTrueParaPos;
			}
			break;

			case( presentation::AnimationEffect_MOVE_FROM_LEFT ):
			case( presentation::AnimationEffect_MOVE_FROM_UPPERLEFT ):
			case( presentation::AnimationEffect_MOVE_FROM_TOP ):
			case( presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT ):
			case( presentation::AnimationEffect_MOVE_FROM_RIGHT ):
			case( presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT ):
			case( presentation::AnimationEffect_MOVE_FROM_BOTTOM ):
			case( presentation::AnimationEffect_MOVE_FROM_LOWERLEFT ):
			case( presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT ):
			case( presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT ):
			case( presentation::AnimationEffect_MOVE_SHORT_FROM_TOP ):
			case( presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT ):
			case( presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT ):
			case( presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT ):
			case( presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM ):
			case( presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT ):
			case( presentation::AnimationEffect_STRETCH_FROM_LEFT ):
			case( presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT ):
			case( presentation::AnimationEffect_STRETCH_FROM_TOP ):
			case( presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT ):
			case( presentation::AnimationEffect_STRETCH_FROM_RIGHT ):
			case( presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT ):
			case( presentation::AnimationEffect_STRETCH_FROM_BOTTOM ):
			case( presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT ):
			case( presentation::AnimationEffect_HORIZONTAL_STRETCH ):
			case( presentation::AnimationEffect_VERTICAL_STRETCH ):
			case( presentation::AnimationEffect_HORIZONTAL_ROTATE ):
			case( presentation::AnimationEffect_VERTICAL_ROTATE ):
			{
				ExtOutputDevice aOut( pAnmVDev );
				SdrPaintInfoRec aPaintInfoRec;

				UpdateVDevWithAnimations();
				SetPaintModes( (SdrView*) pView, NULL, &aOut, &aPaintInfoRec );
				pAnmVDev->SetDrawMode( pShowWindow->GetDrawMode() );

				// create substitution bitmap
				if( bIsCompoundLayoutText )
				{
					ExtOutputDevice aBackOut( pVDev );
					SdrPaintInfoRec aPaintInfoRec;
					SfxItemSet		aAttr( pDoc->GetPool(), XATTR_LINESTYLE, XATTR_LINESTYLE,
															XATTR_FILLSTYLE, XATTR_FILLSTYLE, 0 );

					// paint object without text into VDev
					SdrRectObj*		pBackClone = (SdrRectObj*) pLayoutText->Clone();
 					const Rectangle	aLogicRect( pBackClone->GetLogicRect() );
					
					pVDev->SetDrawMode( pShowWindow->GetDrawMode() );
					pBackClone->NbcSetOutlinerParaObject( NULL );
					pBackClone->NbcSetLogicRect( aLogicRect );
					SetPaintModes( (SdrView*) pView, NULL, &aBackOut, &aPaintInfoRec );
					pBackClone->Paint( aBackOut, aPaintInfoRec );
					delete pBackClone;

					// create substitute for text
					SdrRectObj*	pTextClone = (SdrRectObj*) pLayoutText->Clone();

    				aAttr.Put(pTextClone->GetItemSet());
					aAttr.Put( XLineStyleItem( XLINE_NONE ) );
					aAttr.Put( XFillStyleItem( XFILL_NONE ) );

					pTextClone->SetItemSet(aAttr);
					
					pLayoutBmpEx = new BitmapEx( CreateReplacement( pTextClone, &aOut ) );
					delete pTextClone;
				}
				else
					pLayoutBmpEx = new BitmapEx( CreateReplacement( pLayoutText, &aOut ) );

				pAnmVDev->SetDrawMode( DRAWMODE_DEFAULT );
			}
			break;
		}

		pOutlInfo->SetTextObj( pDoc, pLayoutText, pAnmVDev );
		pOutlInfo->SetExtraData( (const long) eEffect );
	}

	if( !bAbort )
	{
		Point		aUpperLeft( pActualPage->GetLftBorder(), pActualPage->GetUppBorder() );
		Point		aLowerRight( pActualPage->GetSize().Width() - pActualPage->GetRgtBorder(),
								 pActualPage->GetSize().Height() - pActualPage->GetLwrBorder() );
		Rectangle	aClip( Rectangle( aUpperLeft, aLowerRight ) );
        Rectangle   aVDevRect( pAnmVDev->PixelToLogic( Point() ), pAnmVDev->GetOutputSize() );
		Rectangle	aAnimRect;
		ULONG		nNextParaPos = nParaPos + 1;

		if( !nParaPos )
		{
			if( pOutlInfo->GetParaCount() == 1 )
				aAnimRect = aVDevRect;
			else
			{
                if( pOutlInfo->IsVertical() )
                {
				    aAnimRect.SetPos( Point( pOutlInfo->GetParaRect( 0 ).Left(), aVDevRect.Top() ) );
				    aAnimRect.SetSize( Size( aVDevRect.Right() - pOutlInfo->GetParaRect( 0 ).Left() + 1, aVDevRect.GetHeight() ) );
                }
                else
                {
				    aAnimRect.SetPos( aVDevRect.TopLeft() );
				    aAnimRect.SetSize( Size( aVDevRect.GetWidth(), pOutlInfo->GetParaRect( 0 ).Bottom() - aVDevRect.Top() + 1 ) );
                }
			}
		}
		else if( nParaPos < ( pOutlInfo->GetParaCount() - 1 ) )
		{
            if( pOutlInfo->IsVertical() )
            {
			    aAnimRect.SetPos( Point( pOutlInfo->GetParaRect( nParaPos ).Left(), aVDevRect.Top() ) );
				aAnimRect.SetSize( Size( pOutlInfo->GetParaRect( nParaPos ).GetWidth(), aVDevRect.GetHeight() ) );
            }
            else
            {
			    aAnimRect.SetPos( Point( aVDevRect.Left(), pOutlInfo->GetParaRect( nParaPos ).Top() ) );
			    aAnimRect.SetSize( Size( aVDevRect.GetWidth(), pOutlInfo->GetParaRect( nParaPos ).GetHeight() ) );
            }
		}
		else
		{
            if( pOutlInfo->IsVertical() )
            {
			    aAnimRect.SetPos( aVDevRect.TopLeft() );
				aAnimRect.SetSize( Size( pOutlInfo->GetParaRect( nParaPos ).Right() - aVDevRect.Left() + 1, aVDevRect.GetHeight() ) );
            }
            else
            {
			    aAnimRect.SetPos( Point( aVDevRect.Left(), pOutlInfo->GetParaRect( nParaPos ).Top() ) );
			    aAnimRect.SetSize( Size( aVDevRect.GetWidth(), aVDevRect.Bottom() - pOutlInfo->GetParaRect( nParaPos ).Top() + 1 ) );
            }
		}

		while( ( nNextParaPos < pOutlInfo->GetParaCount() ) && !pOutlInfo->GetParaCharCount( nNextParaPos ) )
		{
   			Size                aSize( aAnimRect.GetSize() );
            const Rectangle&    rNextRect = pOutlInfo->GetParaRect( nNextParaPos++ );

            if( pOutlInfo->IsVertical() )
            {
			    aAnimRect.SetPos( Point( rNextRect.Left(), aVDevRect.Top() ) );
                aSize.Width() += rNextRect.GetWidth();
            }
            else
    			aSize.Height() += rNextRect.GetHeight();

   			aAnimRect.SetSize( aSize );
		}

		Point   aStart, aEnd( aAnimRect.TopLeft() );
        double	fStartScaleX = 1.0, fEndScaleX = 1.0, fStartScaleY = 1.0, fEndScaleY = 1.0;

		switch( eEffect )
		{
			case presentation::AnimationEffect_MOVE_FROM_LEFT:
			case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:
			case presentation::AnimationEffect_MOVE_FROM_TOP:
			case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:
			case presentation::AnimationEffect_MOVE_FROM_RIGHT :
			case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:
			case presentation::AnimationEffect_MOVE_FROM_BOTTOM:
			case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_TOP:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT:
			case presentation::AnimationEffect_STRETCH_FROM_LEFT:
			case presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT:
			case presentation::AnimationEffect_STRETCH_FROM_TOP:
			case presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT:
			case presentation::AnimationEffect_STRETCH_FROM_RIGHT:
			case presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT:
			case presentation::AnimationEffect_STRETCH_FROM_BOTTOM:
			case presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT:
			case presentation::AnimationEffect_HORIZONTAL_STRETCH:
			case presentation::AnimationEffect_VERTICAL_STRETCH:
			case presentation::AnimationEffect_HORIZONTAL_ROTATE:
			case presentation::AnimationEffect_VERTICAL_ROTATE:
			{
				switch( eEffect )
				{				 
					case presentation::AnimationEffect_MOVE_FROM_LEFT:
						aStart.X() = aUpperLeft.X() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
						aStart.Y() = aEnd.Y();
					break;

					case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:
						aStart.X() = aUpperLeft.X() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
						aStart.Y() = aUpperLeft.Y() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
					break;

					case presentation::AnimationEffect_MOVE_FROM_TOP:
						aStart.X() = aEnd.X();
						aStart.Y() = aUpperLeft.Y() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
					break;

					case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:
						aStart.X() = aLowerRight.X();
						aStart.Y() = aUpperLeft.Y() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
					break;

					case presentation::AnimationEffect_MOVE_FROM_RIGHT:
						aStart.X() = aLowerRight.X();
						aStart.Y() = aEnd.Y();
					break;

					case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:
						aStart.X() = aLowerRight.X();
						aStart.Y() = aLowerRight.Y();
					break;

					case presentation::AnimationEffect_MOVE_FROM_BOTTOM:
						aStart.X() = aEnd.X();
						aStart.Y() = aLowerRight.Y();
					break;

					case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:
						aStart.X() = aUpperLeft.X() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
						aStart.Y() = aLowerRight.Y();
					break;

					case presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT:
						aStart.X() = aAnimRect.Left() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
						aStart.Y() = aEnd.Y();
					break;

					case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT:
						aStart.X() = aAnimRect.Left() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
						aStart.Y() = aAnimRect.Top() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
					break;

					case presentation::AnimationEffect_MOVE_SHORT_FROM_TOP:
						aStart.X() = aEnd.X();
						aStart.Y() = aAnimRect.Top() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
					break;

					case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT:
						aStart.X() = aAnimRect.Right();
						aStart.Y() = aAnimRect.Top() - aAnimRect.GetHeight() - ( aTolSize.Height() << 1 );
					break;

					case presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT:
						aStart.X() = aAnimRect.Right();
						aStart.Y() = aEnd.Y();
					break;

					case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT:
						aStart.X() = aAnimRect.Right();
						aStart.Y() = aAnimRect.Bottom();
					break;

					case presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM:
						aStart.X() = aEnd.X();
						aStart.Y() = aAnimRect.Bottom();
					break;

					case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT:
						aStart.X() = aAnimRect.Left() - aAnimRect.GetWidth() - ( aTolSize.Width() << 1 );
						aStart.Y() = aAnimRect.Bottom();
					break;

					// ----

					case presentation::AnimationEffect_STRETCH_FROM_LEFT:
						aStart = aEnd;
						fStartScaleX = 0.0;
					break;

					case presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT:
						aStart = aEnd;
						fStartScaleX = fStartScaleY = 0.0;
					break;

					case presentation::AnimationEffect_STRETCH_FROM_TOP:
						aStart = aEnd;
						fStartScaleY = 0.0;
					break;

					case presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT:
						aStart = aAnimRect.TopRight();
						fStartScaleX = fStartScaleY = 0.0;
					break;

					case presentation::AnimationEffect_STRETCH_FROM_RIGHT:
						aStart.X() = aAnimRect.Right();
						aStart.Y() = aEnd.Y();
						fStartScaleX = 0.0;
					break;

					case presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT:
						aStart.X() = aAnimRect.Right();
						aStart.Y() = aAnimRect.Bottom();
						fStartScaleX = fStartScaleY = 0.0;
					break;

					case presentation::AnimationEffect_STRETCH_FROM_BOTTOM:
						aStart.X() = aEnd.X();
						aStart.Y() = aAnimRect.Bottom();
						fStartScaleY = 0.0;
					break;

					case presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT:
						aStart.X() = aEnd.X();
						aStart.Y() = aAnimRect.Bottom();
						fStartScaleX = fStartScaleY = 0.0;
					break;

					// ----

					case presentation::AnimationEffect_HORIZONTAL_STRETCH:
					case presentation::AnimationEffect_HORIZONTAL_ROTATE:
						aStart.X() = aAnimRect.Center().X();
						aStart.Y() = aEnd.Y();
						fStartScaleX = 0.0;
					break;

					case presentation::AnimationEffect_VERTICAL_STRETCH:
					case presentation::AnimationEffect_VERTICAL_ROTATE:
						aStart.X() = aEnd.X();
						aStart.Y() = aAnimRect.Center().Y();
						fStartScaleY = 0.0;
					break;
				}

				if( bAbort )
					HandleError( STR_NOT_ENOUGH_MEMORY );
				else
				{
					List				aListOfImages;
					Rectangle			aTextRectPix( pAnmVDev->LogicToPixel( aAnimRect.TopLeft() ), 
													  pAnmVDev->LogicToPixel( aAnimRect.GetSize() ) );
					const BOOL			bSlow = GetSlowObjRecord( pLayoutText ) != NULL;
					const Marker		aStartMarker( OBJ_START( pLayoutText, bSlow ) );
					const Marker		aEndMarker( OBJ_END( pLayoutText, bSlow ) );
					const Size			aTextRectSize( aTextRectPix.GetSize() );
					VirtualDevice*		pCropVDev = new VirtualDevice;
					BitmapEx*			pPartBmpEx;

					// get cropped bitmap
					if( pCropVDev->SetOutputSizePixel( aTextRectSize ) )
					{
						Bitmap aPaint, aMask;

						pCropVDev->DrawBitmap( Point(), aTextRectSize, aTextRectPix.TopLeft(), aTextRectSize, pLayoutBmpEx->GetBitmap() );
						aPaint = pCropVDev->GetBitmap( Point(), aTextRectSize );

						if( pLayoutBmpEx->IsTransparent() )
						{
							pCropVDev->DrawBitmap( Point(), aTextRectSize, aTextRectPix.TopLeft(), aTextRectSize, pLayoutBmpEx->GetMask() );
							aMask = pCropVDev->GetBitmap( Point(), aTextRectSize );
						}

						pPartBmpEx = new BitmapEx( aPaint, aMask );
						delete pCropVDev;
					}
					else
					{	
						delete pCropVDev;
						pPartBmpEx = new BitmapEx( *pLayoutBmpEx );
						pPartBmpEx->Crop( aTextRectPix );
					}

					aListOfImages.Insert( pPartBmpEx );
					pVDev->SetDrawMode( pShowWindow->GetDrawMode() );

					if( presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_TOP == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM == eEffect ||
						presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT == eEffect ||

						presentation::AnimationEffect_STRETCH_FROM_LEFT == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_TOP == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_RIGHT == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_BOTTOM == eEffect ||
						presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT == eEffect ||

						presentation::AnimationEffect_HORIZONTAL_STRETCH == eEffect ||
						presentation::AnimationEffect_VERTICAL_STRETCH == eEffect ||

						presentation::AnimationEffect_HORIZONTAL_ROTATE == eEffect ||
						presentation::AnimationEffect_VERTICAL_ROTATE == eEffect )
					{
						pMover->SetClipRegion( aAnimRect );
					}
					else
						pMover->SetClipRegion( aClip );

					pMover->SetGraphicInfo( pVDev, &pMetaFile, aStartMarker, aEndMarker );
					pMover->SetListOfImages( &aListOfImages );
					pMover->SetSpeed( SpeedAToM( eSpeed ), 1 );
					pMover->SetPath( aStart, aEnd, &fStartScaleX, &fEndScaleX, &fStartScaleY, &fEndScaleY );

					if( pInfo->bSoundOn )
					{
						bPlayFull = pInfo->bPlayFull;
						StartSound( pInfo->aSoundFile );
					}

					bAbort = !pMover->Move();

					if( !bAbort && 
						eEffect == presentation::AnimationEffect_HORIZONTAL_ROTATE || 
						eEffect == presentation::AnimationEffect_VERTICAL_ROTATE )
					{
						const Point	aMediumPos( aStart ), aFinalPos( aEnd );

						for( long i = 0; ( i < 4 ) && !bAbort; i++ )
						{
							const BOOL		bOdd = ( ( i & 1 ) != 0 );
							const Point*	pStart = bOdd ? &aMediumPos : &aFinalPos;
							const Point*	pEnd = bOdd ? &aFinalPos : &aMediumPos;

							if( eEffect == presentation::AnimationEffect_HORIZONTAL_ROTATE )
							{
								fStartScaleX = bOdd ? 0.0 : 1.0;
								fEndScaleX = bOdd ? 1.0 : 0.0;
							}
							else
							{
								fStartScaleY = bOdd ? 0.0 : 1.0;
								fEndScaleY = bOdd ? 1.0 : 0.0;
							}

							pMover->SetPath( *pStart, *pEnd, &fStartScaleX, &fEndScaleX, &fStartScaleY, &fEndScaleY );
							bAbort = !pMover->Move();

                            if( nMagic != SLIDESHOW_MAGIC )
                            {
                                break;
                            }
						}
					}

                    if( nMagic != SLIDESHOW_MAGIC )
					{
						delete (BitmapEx*) aListOfImages.First();
						return TRUE;
					}
					else
						pVDev->DrawBitmapEx( aAnimRect.TopLeft(), *(BitmapEx*) aListOfImages.First() );

					pVDev->SetDrawMode( DRAWMODE_DEFAULT );
					delete (BitmapEx*) aListOfImages.First();
				}
			}
			break;

			case presentation::AnimationEffect_APPEAR:
			case presentation::AnimationEffect_FADE_FROM_LEFT:
			case presentation::AnimationEffect_FADE_FROM_UPPERLEFT:
			case presentation::AnimationEffect_FADE_FROM_TOP:
			case presentation::AnimationEffect_FADE_FROM_UPPERRIGHT:
			case presentation::AnimationEffect_FADE_FROM_RIGHT:
			case presentation::AnimationEffect_FADE_FROM_LOWERRIGHT:
			case presentation::AnimationEffect_FADE_FROM_BOTTOM:
			case presentation::AnimationEffect_FADE_FROM_LOWERLEFT:
			case presentation::AnimationEffect_FADE_TO_CENTER:
			case presentation::AnimationEffect_FADE_FROM_CENTER:
			case presentation::AnimationEffect_VERTICAL_STRIPES:
			case presentation::AnimationEffect_HORIZONTAL_STRIPES:
			case presentation::AnimationEffect_VERTICAL_LINES:
			case presentation::AnimationEffect_HORIZONTAL_LINES:
			case presentation::AnimationEffect_VERTICAL_CHECKERBOARD:
			case presentation::AnimationEffect_HORIZONTAL_CHECKERBOARD:
			case presentation::AnimationEffect_CLOCKWISE:
			case presentation::AnimationEffect_COUNTERCLOCKWISE:
			case presentation::AnimationEffect_CLOSE_VERTICAL:
			case presentation::AnimationEffect_CLOSE_HORIZONTAL:
			case presentation::AnimationEffect_OPEN_VERTICAL:
			case presentation::AnimationEffect_OPEN_HORIZONTAL:
			case presentation::AnimationEffect_SPIRALIN_LEFT:
			case presentation::AnimationEffect_SPIRALIN_RIGHT:
			case presentation::AnimationEffect_SPIRALOUT_LEFT:
			case presentation::AnimationEffect_SPIRALOUT_RIGHT:
			case presentation::AnimationEffect_DISSOLVE:
			case presentation::AnimationEffect_WAVYLINE_FROM_LEFT:
			case presentation::AnimationEffect_WAVYLINE_FROM_TOP:
			case presentation::AnimationEffect_WAVYLINE_FROM_RIGHT:
			case presentation::AnimationEffect_WAVYLINE_FROM_BOTTOM:
			{
				aAnimRect.Intersection( aClip );
				pFader->SetNewVirtualDevice( pAnmVDev );
				pFader->SetTarget( aAnimRect );
				pFader->SetSource( aAnimRect );
				pFader->SetSpeed( SpeedAToF( eSpeed ) );
				pFader->SetEffect( EffectAToF( eEffect ) );

				if( pInfo->bSoundOn )
				{
					bPlayFull = pInfo->bPlayFull;
					StartSound(pInfo->aSoundFile);
				}

				pFader->Fade();
				
				if( nMagic != SLIDESHOW_MAGIC )
					return TRUE;
			}
			break;

			case presentation::AnimationEffect_LASER_FROM_LEFT:
			case presentation::AnimationEffect_LASER_FROM_UPPERLEFT:
			case presentation::AnimationEffect_LASER_FROM_TOP:
			case presentation::AnimationEffect_LASER_FROM_UPPERRIGHT:
			case presentation::AnimationEffect_LASER_FROM_RIGHT:
			case presentation::AnimationEffect_LASER_FROM_LOWERRIGHT:
			case presentation::AnimationEffect_LASER_FROM_BOTTOM:
			case presentation::AnimationEffect_LASER_FROM_LOWERLEFT:
			{
				Point		aStart;
				Rectangle	aPageRect( aPageOrigin, aPageSize );

				switch( eEffect )
				{
					case presentation::AnimationEffect_LASER_FROM_LEFT:
						aStart = aPageRect.LeftCenter();
					break;

					case presentation::AnimationEffect_LASER_FROM_UPPERLEFT:
						aStart = aPageRect.TopLeft();
					break;

					case presentation::AnimationEffect_LASER_FROM_TOP:
						aStart = aPageRect.TopCenter();
					break;

					case presentation::AnimationEffect_LASER_FROM_UPPERRIGHT:
						aStart = aPageRect.TopRight();
					break;

					case presentation::AnimationEffect_LASER_FROM_RIGHT:
						aStart = aPageRect.RightCenter();
					break;

					case presentation::AnimationEffect_LASER_FROM_LOWERRIGHT:
						aStart = aPageRect.BottomRight();
					break;

					case presentation::AnimationEffect_LASER_FROM_BOTTOM:
						aStart = aPageRect.BottomCenter();
					break;

					case presentation::AnimationEffect_LASER_FROM_LOWERLEFT:
						aStart = aPageRect.BottomLeft();
					break;
				}

				bFullBckgnd = TRUE;
                bAbort = !LaserEffect( (SdrRectObj*) pLayoutText, (USHORT) nParaPos, aStart );

                // im Reschedule des Effekts zerstoert?
                if( nMagic != SLIDESHOW_MAGIC )
                    return TRUE;
            }
			break;
		}

		// naechster Gliederungspunkt
		nParaPos = nNextParaPos;

		// altes Clipping des LayoutClones jetzt ungueltig
		delete pLayoutClip;
		pLayoutClip = NULL;

		// Textposition weitersetzen
		aDimRect = aAnimRect;

		// wenn das der letzte Absatz war
		if( nParaPos == pOutlInfo->GetParaCount() )
		{
 			delete pMskVDev, pMskVDev = NULL;
 			delete pTopLayer, pTopLayer = NULL;

			pOutlInfo->Clear();
			pCurAnmList->Remove( (ULONG) 0 ); // das Gliederungsobjekt austragen

            // wenn die Gliederung auf Klick verschwinden kann
            if( pInfo->bDimHide )
                pHideObject = pLayoutText;

			delete pLayoutBmpEx;
			pLayoutBmpEx = NULL;
		}
	}

	return !bAbort;
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::LaserEffect( SdrRectObj* pObject, USHORT nPara, const Point& rStart )
{
	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo( pObject );
	Rectangle			aObjRect( pObject->GetBoundRect() );
	Point				aPos;
	Size				aSize;
	Size				aTolSize( pShowWindow->PixelToLogic( Size( VDEV_TOLERANCE, VDEV_TOLERANCE ) ) );
	USHORT				nParaCount = 0;
	BOOL				bText = pObject->GetOutlinerParaObject() != NULL;
	BOOL				bIsSlow = (GetSlowObjRecord( pObject ) != NULL );
	BOOL				bAbort = FALSE;

	// Animationsdevice initialisieren
	if( !nPara || ( LASER_ALL_PARAS == nPara ) )
	{
		bAbort = !AdjustAnmVDev( aObjRect, COL_WHITE );

		// Hintergrund und Objektflaeche ohne Text einblenden
		if( !bAbort )
		{
			ExtOutputDevice aOut( pVDev );
			SdrPaintInfoRec aPaintInfoRec;
			SdrObject*		pClone = pObject->Clone();
			const Rectangle	aLogicRect( pClone->GetLogicRect() );

			SetPaintModes( (SdrView*) pView, NULL, &aOut, &aPaintInfoRec );
			aPos = Point( aObjRect.Left() - aTolSize.Width(), aObjRect.Top() - aTolSize.Height() );
			aSize = pAnmVDev->GetOutputSize();

			pClone->NbcSetOutlinerParaObject( NULL );
			pClone->NbcSetLogicRect( aLogicRect );
			pMetaFile->Play( pVDev, MTF_START, OBJ_START( pObject, bIsSlow ) );
			UpdateVDevWithAnimations();
			pVDev->SetDrawMode( pShowWindow->GetDrawMode() );
			pClone->Paint( aOut, aPaintInfoRec );
			pVDev->SetDrawMode( DRAWMODE_DEFAULT );
			delete pClone;

			// TopLayer erzeugen
			if( !CreateTopLayer( pVDev, OBJ_END( pObject, bIsSlow ), MTF_END ) )
				bAbort = TRUE;
		}

		// Den Text des Objekts ohne Rand und Flaeche ins Animationsdevice zeichnen.
		if( bText && !bAbort )
		{
			const Color		aBlack( COL_BLACK );
			ExtOutputDevice aOut( pAnmVDev );
			SdrPaintInfoRec aPaintInfoRec;
			SdrObject*		pClone = pObject->Clone();
			SfxItemSet		aPntAttr( pDoc->GetPool(), XATTR_FILLSTYLE, XATTR_FILLSTYLE, 
													   XATTR_LINESTYLE, XATTR_LINESTYLE, 
													   0 );
			SfxItemSet		aMskAttr( pDoc->GetPool(), SDRATTR_SHADOWCOLOR, SDRATTR_SHADOWCOLOR,
													   0 );

			SetPaintModes((SdrView*)pView, NULL, &aOut, &aPaintInfoRec);
		
			// Hintergrund und Rand dieses Clones transparent machen
			aPntAttr.Put(pClone->GetItemSet());

			aPntAttr.Put( XLineStyleItem( XLINE_NONE ) );
			aPntAttr.Put( XFillStyleItem( XFILL_NONE ) );

			pClone->SetItemSet(aPntAttr);

			// bei Grafikobjekten einfach die Grafik am Clone zuruecksetzen
			if( pObject->ISA( SdrGrafObj ) )
				( (SdrGrafObj*) pClone )->SetGraphic( Graphic() );

			DisableFontSmoothing();

			pAnmVDev->SetDrawMode( pShowWindow->GetDrawMode() );
			pClone->Paint( aOut, aPaintInfoRec );
			pAnmVDev->SetDrawMode( DRAWMODE_DEFAULT );

			// Zeichen- und Schattenfarbe fuer Maske auf Schwarz setzen
			aMskAttr.Put(pClone->GetItemSet());

			aMskAttr.Put( SdrShadowColorItem( String(), aBlack ) );
			
			pClone->SetItemSet(aMskAttr);
			
			pMskVDev = new VirtualDevice( *pAnmVDev, 1 );
			pMskVDev->SetMapMode( pAnmVDev->GetMapMode() );
			pMskVDev->SetOutputSize( pAnmVDev->GetOutputSize() );
			pMskVDev->SetDrawMode( DRAWMODE_BLACKTEXT );
			aOut.SetOutDev( pMskVDev );
			SetPaintModes((SdrView*)pView, NULL, &aOut, &aPaintInfoRec);
			pClone->Paint( aOut, aPaintInfoRec );
			pMskVDev->SetDrawMode( DRAWMODE_DEFAULT );
			delete pClone;
			EnableFontSmoothing();
		}
	}
	// Falls dies ein Gliederungstext ist und nicht dessen erster Absatz, so
	// koennten die vorhergehenden Absaetze abgeblendet worden sein. Dann
	// muss das Image ebenfalls mit der Abblendung versehen werden.
	else if( pObject == pLayoutText && pInfo->bDimmed )
		PaintLayoutClone( pVDev );

	if( bText && !bAbort )
	{
		nParaCount = (USHORT) pObject->GetOutlinerParaObject()->Count();
		nParaCount = ( nPara != LASER_ALL_PARAS ) ? ( nPara + 1 ) : 0;

		List			aListOfImages;
		Point			aUpperLeft( pActualPage->GetLftBorder(), pActualPage->GetUppBorder() );
		Point			aLowerRight( pActualPage->GetSize().Width() - pActualPage->GetRgtBorder(),
									 pActualPage->GetSize().Height() - pActualPage->GetLwrBorder() );
		const Marker	aObjStartMarker( OBJ_START( pObject, bIsSlow ) );
		const Marker	aObjEndMarker( OBJ_END( pObject, bIsSlow ) );
		Rectangle		aAncRect;
		Point			aRotOffset;
		const GeoStat&	rGeo = pObject->GetGeoStat();

		// Grundeinstellungen fuer Mover
		if( !bAbort ) 
		{	
			pMover->SetSpeed( SpeedAToM( pInfo->eSpeed ), 4 );
			pMover->SetClipRegion( Rectangle( aUpperLeft, aLowerRight ) );
		}

		// Drehung rueckgaengig
		if( rGeo.nDrehWink )
		{
			pObject->TakeTextAnchorRect( aAncRect );
			aRotOffset = pOutlInfo->GetTextOffset();
			RotatePoint( aRotOffset, aAncRect.TopLeft(), -rGeo.nSin, rGeo.nCos );
			aRotOffset -= pOutlInfo->GetTextOffset();
		}

		// Buchstaben aller Absaetze hereinfliegen lassen
		for( USHORT nCurPara = nPara; nCurPara < nParaCount && !bAbort; nCurPara++ )
		{
			OutlinerCharacter* pChar = pOutlInfo->GetFirstCharacter();

			// erst einmal bis auf den aktuellen Absatz kommen
			while( pChar && pChar->nPara < nCurPara )
				pChar = pOutlInfo->GetNextCharacter();

			// und auswerten
			while( !bAbort && pChar && pChar->nPara == nCurPara )
			{
				// keine Leerzeichen
				if( pChar->nCharCode != 32 )
				{
					Rectangle aCharRect( pChar->aRect );

					// ggf. Drehung beruecksichtigen
					if( rGeo.nDrehWink )
					{
						aCharRect.Move( aRotOffset.X(), aRotOffset.Y() );

						VirtualDevice	aRotVDev( (OutputDevice&) *pAnmVDev );
						Polygon			aCharPoly( aCharRect );
						Polygon			aPixPoly;
						Rectangle		aPixBound;
						Size			aSizePix;	
						
						RotatePoly( aCharPoly, aAncRect.TopLeft(), rGeo.nSin, rGeo.nCos );
						aCharRect = aCharPoly.GetBoundRect();
						aPixPoly = pAnmVDev->LogicToPixel( aCharPoly );
						aPixBound = aPixPoly.GetBoundRect();
						aPixPoly.Move( -aPixBound.TopLeft().X(), -aPixBound.TopLeft().Y() );
						aRotVDev.SetOutputSizePixel( aSizePix = pAnmVDev->LogicToPixel( aCharRect.GetSize() ) );
						aRotVDev.SetClipRegion( aPixPoly );
						
						aRotVDev.DrawOutDev( Point(), aSizePix, aCharRect.TopLeft(), aCharRect.GetSize(), *pAnmVDev );
						Bitmap aPaint( aRotVDev.GetBitmap( Point(), aSizePix ) );

						aRotVDev.DrawOutDev( Point(), aSizePix, aCharRect.TopLeft(), aCharRect.GetSize(), *pMskVDev );
						aListOfImages.Insert( new BitmapEx( aPaint, aRotVDev.GetBitmap( Point(), aSizePix ) ) );
					}
					else
					{
						aCharRect.Intersection( aObjRect );
						aListOfImages.Insert( new BitmapEx( pAnmVDev->GetBitmap( aCharRect.TopLeft(), aCharRect.GetSize() ),
															pMskVDev->GetBitmap( aCharRect.TopLeft(), aCharRect.GetSize() ) ) );
					}

					if( !bAbort )
					{
						// Mover parametrieren
						pMover->SetListOfImages( &aListOfImages );
						pMover->SetPath( rStart, aCharRect.TopLeft() );
						pMover->SetGraphicInfo( pVDev, pTopLayer );

						// ggfs. Sound anschalten
						if( pInfo->bSoundOn )
						{
							bPlayFull = pInfo->bPlayFull;
							StartSound( pInfo->aSoundFile );
						}

						// und los (aber keine internen Waits)
						bAbort = bAbort || !pMover->Move();

                        // im Reschedule des Effekts zerstoert?
                        if( nMagic != SLIDESHOW_MAGIC )
						{
							delete (BitmapEx*) aListOfImages.First();
							return TRUE;
						}

						// Hintergrund mit neuem Zeichen aktualisieren
						pVDev->DrawBitmapEx( aCharRect.TopLeft(), *(BitmapEx*) aListOfImages.First() );
					}

					delete (BitmapEx*) aListOfImages.First();
					aListOfImages.Clear();
				}

				pChar = pOutlInfo->GetNextCharacter();
			}
		}
	}

	return( !bAbort );
}

// -----------------------------------------------------------------------------

BitmapEx FuSlideShow::CreateReplacement( SdrObject* pObj, ExtOutputDevice* pOut )
{
	DisableFontSmoothing();

	SdrPaintInfoRec		aPaintInfoRec;
	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo( pObj );
	BitmapEx			aRet;
	OutputDevice*		pRealOut = pOut->GetOutDev();

	SetPaintModes( (SdrView*) pView, NULL, pOut, &aPaintInfoRec );
	pRealOut->Push();
	pRealOut->SetBackground( Wallpaper( Color( COL_WHITE ) ) );
	pRealOut->Erase();
	pRealOut->Pop();

	if( IsAlphaObj( (SdrAttrObj*) pObj ) )
	{
		// create alpha mask
		PaintDimmedObject( (SdrAttrObj*) pObj, pRealOut, Color( COL_BLACK ), FALSE );
		AlphaMask aAlpha( pRealOut->GetBitmap( pRealOut->PixelToLogic( Point() ), pRealOut->GetOutputSize() ) );

		// create paint bitmap
		SdrObjGroup* pClone;

		if( pObj->ISA( SdrObjGroup ) )
			pClone = (SdrObjGroup*) pObj->Clone(); 
		else
		{
			pClone = new SdrObjGroup; 
			pClone->GetSubList()->NbcInsertObject( pObj->Clone() );
		}

		pClone->SetModel( pDoc );

		SdrObjListIter aIter( *pClone->GetSubList(), IM_DEEPWITHGROUPS );
		
		for( SdrObject*	pO = aIter.Next(); pO; pO = aIter.Next() )
		{
			if( !pO->ISA( SdrObjGroup ) )
			{
				SfxItemSet	aAttr( pDoc->GetPool(), XATTR_FILLTRANSPARENCE, XATTR_FILLTRANSPARENCE,
													XATTR_LINETRANSPARENCE, XATTR_LINETRANSPARENCE,
													XATTR_FILLFLOATTRANSPARENCE, XATTR_FILLFLOATTRANSPARENCE,
													0, 0 );

				aAttr.Put(pO->GetItemSet());

				// set minimal transparence values to get same results (as alpha painting) 
				if( ( ( aAttr.GetItemState( XATTR_FILLFLOATTRANSPARENCE ) == SFX_ITEM_SET ) &&
					( (const XFillFloatTransparenceItem&) aAttr.Get( XATTR_FILLFLOATTRANSPARENCE ) ).IsEnabled() ) )
				{
					const Color aTransCol( 1, 1, 1 );
					aAttr.Put( XFillFloatTransparenceItem( String(), XGradient( aTransCol, aTransCol, XGRAD_LINEAR, 0, 0, 0, 0, 100, 100, 3 ) ) );
				}
				else if( ( ( (const XFillTransparenceItem&) aAttr.Get( XATTR_FILLTRANSPARENCE ) ).GetValue() ) )
					aAttr.Put( XFillTransparenceItem( 1 ) );

				if( ( (const XLineTransparenceItem&) aAttr.Get( XATTR_LINETRANSPARENCE ) ).GetValue() )
					aAttr.Put( XLineTransparenceItem( 1 ) );
			
				pO->SetItemSet(aAttr);
			}
		}

		pRealOut->Push();
		pRealOut->SetBackground( Wallpaper( Color( COL_WHITE ) ) );
		pRealOut->Erase();
		pRealOut->Pop();
		pClone->Paint( *pOut, aPaintInfoRec );
		aRet = BitmapEx( pRealOut->GetBitmap( pRealOut->PixelToLogic( Point() ), pRealOut->GetOutputSize() ), aAlpha );

		delete pClone;
	}
	else
	{
		pObj->Paint( *pOut, aPaintInfoRec );
		Bitmap aPaint( pRealOut->GetBitmap( pRealOut->PixelToLogic( Point() ), pRealOut->GetOutputSize() ) );
		pRealOut->Push();
		pRealOut->SetBackground( Wallpaper( Color( COL_WHITE ) ) );
		pRealOut->Erase();
		pRealOut->Pop();
		PaintDimmedObject( (SdrAttrObj*) pObj, pRealOut, Color( COL_BLACK ), TRUE );
		aRet = BitmapEx( aPaint, pRealOut->GetBitmap( pRealOut->PixelToLogic( Point() ), pRealOut->GetOutputSize() ) );
	}

	EnableFontSmoothing();

	return aRet;
}
