/*************************************************************************
 *
 *  $RCSfile: sdmtf.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:48:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVDOATTR_HXX //autogen
#include <svx/svdoattr.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif
#ifndef _SV_IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif

#define FUSLIDESHOW_INTERN

#include "sdmtf.hxx"
#include "fuslshow.hxx"
#include "anminfo.hxx"
#include "drawdoc.hxx"


#define MARKEROBJ( nMarker )	( (Marker*) pMarkerList->GetObject( nMarker ) )
#define FIRSTMARKER()			( (Marker*) pMarkerList->First() )
#define NEXTMARKER()			( (Marker*) pMarkerList->Next() )


/******************************************************************************
|*
|*
|*
\******************************************************************************/

SdMetaFile::SdMetaFile( FuSlideShow* pShow ) :
			pFuSlideShow( pShow )
{
	pMarkerList = new List;
}


/******************************************************************************
|*
|*
|*
\******************************************************************************/

SdMetaFile::~SdMetaFile()
{
	Clear();
	delete pMarkerList;
}


/******************************************************************************
|*
|*
|*
\******************************************************************************/

void SdMetaFile::Clear()
{
	GDIMetaFile::Clear();

	Marker*	pMarker = FIRSTMARKER();

	while( pMarker )
	{
		delete pMarker;
		pMarker = NEXTMARKER();
	}

	pMarkerList->Clear();
}


/******************************************************************************
|*
|*
|*
\******************************************************************************/

void SdMetaFile::InsertMarker( const Marker& rMarker )
{
	Marker* pMarker = new Marker( rMarker );

	pMarker->nMtfPos = GetActionCount();
	pMarkerList->Insert( pMarker, LIST_APPEND );
}


/******************************************************************************
|*
|*
|*
\******************************************************************************/

BOOL SdMetaFile::ReplaceMarker( const Marker& rMarker, const Marker& rNewMarker )
{
	const ULONG	nMarkerPos = ImpGetMarkerPos( rMarker );

	if ( nMarkerPos != METAFILE_END )
	{
		Marker* pNewMarker = new Marker( rNewMarker );
		Marker* pOldMarker = (Marker*) pMarkerList->Replace( pNewMarker, nMarkerPos );

		pNewMarker->nMtfPos = pOldMarker->nMtfPos;
		delete pOldMarker;

		return TRUE;
	}
	else
		return FALSE;
}

/******************************************************************************
|*
|*
|*
\******************************************************************************/

BOOL SdMetaFile::HasMarker( const Marker& rMarker ) const
{
	BOOL bRet = FALSE;

	for( ULONG i = 0, nCount = pMarkerList->Count(); i < nCount; i++ )
	{
		if( rMarker == *MARKEROBJ( i ) )
		{
			bRet = TRUE;
			break;
		}
	}

	return bRet;
}

/******************************************************************************
|*
|*
|*
\******************************************************************************/

ULONG SdMetaFile::ImpGetMarkerPos( const Marker& rMarker )
{
	ULONG nMarkerPos = METAFILE_END;

	for( ULONG i = 0, nCount = pMarkerList->Count(); i < nCount; i++ )
	{
		if( rMarker == *MARKEROBJ( i ) )
		{
			nMarkerPos = i;
			break;
		}
	}

	return nMarkerPos;
}


/******************************************************************************
|*
|*
|*
\******************************************************************************/

void SdMetaFile::ImpPlayToNextStart( ULONG& rMarker, OutputDevice* pOut )
{
	const ULONG nCount = pMarkerList->Count();
	ULONG		nMtfPos;
	BOOL		bFound = FALSE;

	while( TRUE )
	{
		if ( ++rMarker < nCount )
		{
			const Marker* pMarker = MARKEROBJ( rMarker );

			if ( pMarker->IsObjStart() )
			{
				nMtfPos = pMarker->nMtfPos;
				break;
			}
		}
		else
		{
			nMtfPos = rMarker = METAFILE_END;
			break;
		}
	}

	GDIMetaFile::Play( pOut, nMtfPos );
}


/******************************************************************************
|*
|*
|*
\******************************************************************************/

void SdMetaFile::ImpPlayToNextMarker( ULONG& rMarker, OutputDevice* pOut )
{
	ULONG nMtfPos;

	if ( ++rMarker < pMarkerList->Count() )
		nMtfPos = MARKEROBJ( rMarker )->nMtfPos;
	else
		nMtfPos = rMarker = METAFILE_END;

	GDIMetaFile::Play( pOut, nMtfPos );
}


/******************************************************************************
|*
|*
|*
\******************************************************************************/

void SdMetaFile::ImpSkipActualObject( ULONG& rMarker, OutputDevice* pOut )
{
	const void*	pObject = MARKEROBJ( rMarker )->pObj;
	ULONG		nMtfPos = METAFILE_END;
	const ULONG	nCount = pMarkerList->Count();
	BOOL		bEndFound = FALSE;

	// wir ueberspringen bis zum naechsten Marker, der
	// das gleiche Objekt kennzeichnet und ein Ende-Marker ist
	while ( ++rMarker < nCount )
	{
		const Marker* pMarker = MARKEROBJ( rMarker );

		if ( ( pMarker->pObj == pObject ) && pMarker->IsObjEnd() )
		{
			// der letzte Marker ist der letzte Marker fuer das Object
			nMtfPos = pMarker->nMtfPos;
			break;
		}
	}

	Wind( nMtfPos );
	ImpPlayToNextMarker( rMarker, pOut );
}


/******************************************************************************
|*
|*
|*
\******************************************************************************/

void SdMetaFile::ImpPlaySlowObj( ULONG& rMarker, OutputDevice* pOut )
{
	const SdSlowObjRecord* pRec = pFuSlideShow->GetSlowObjRecord( (SdrAttrObj*) MARKEROBJ( rMarker )->pObj );

	if( pRec  )
	{
		if( pRec->pImage )
			pOut->DrawImage( pRec->aPos, *pRec->pImage );
		else if( pRec->pBmpEx )
			pOut->DrawBitmapEx( pRec->aPos, *pRec->pBmpEx );

		// dieses Objekt im Mtf ueberspringen
		ImpSkipActualObject( rMarker, pOut );
	}
	else
		ImpPlayToNextStart( rMarker, pOut );
}


/******************************************************************************
|*
|*
|*
\******************************************************************************/

void SdMetaFile::Play( OutputDevice* pOut,
					   const Marker& rStartMarker, const Marker& rEndMarker,
					   BOOL bUseOutDevDrawMode )
{
	const ULONG nOldDrawMode = pOut->GetDrawMode();

	if( !bUseOutDevDrawMode )
		pOut->SetDrawMode( DRAWMODE_DEFAULT );

	// keine Marker im Metafile => alles abspielen
	if ( !pMarkerList->Count() )
	{
		WindStart();
		GDIMetaFile::Play( pOut );
	}
	else
	{
		ULONG		nCurMarker = ImpGetMarkerPos( rStartMarker );
		const ULONG nEndMarker = ImpGetMarkerPos( rEndMarker );
		Marker		aActMarker;

		// auf Startposition
		if ( nCurMarker != METAFILE_END )
		{
			aActMarker = *MARKEROBJ( nCurMarker );
			Wind( aActMarker.nMtfPos );
		}
		else
		{
			// bis zum ersten Marker abspielen
			WindStart();
			GDIMetaFile::Play( pOut, FIRSTMARKER()->nMtfPos );
		}

		while ( nCurMarker < nEndMarker )
		{
			SdrObject*			pObject = (SdrObject*) aActMarker.pObj;
			SdAnimationInfo*	pInfo;
			BOOL				bGrouped;

			if ( pObject )
			{
				bGrouped = pObject->IsGrouped();
				pInfo = ( (SdDrawDocument*) pObject->GetModel() )->GetAnimationInfo( pObject );
			}
			else
				pInfo = NULL;

			// Start eines Animationsobjekts?
			if ( pInfo && aActMarker.IsObjStart() )
			{
				// wenn das Objekt gezeichnet werden soll, gleich bis zum
				// naechsten Startlabel bzw. Metafileende abspielen
				if ( !pInfo->bInvisibleInPresentation && pInfo->bShow )
				{
					// langsame Objekte
					if ( aActMarker.IsSlowObj() && !pInfo->bDimmed )
						ImpPlaySlowObj( nCurMarker, pOut );
					else if ( pInfo->bDimmed )
					{
						// abgeblendete Objekte koennen nicht aus dem Metafile
						// gezeichnet werden, die muessen wir selbst zeichnen
						if ( pObject == (SdrObject*) pFuSlideShow->GetLayoutText() )
							pFuSlideShow->PaintLayoutClone( pOut );
						else
							pFuSlideShow->PaintDimmedObject( (SdrAttrObj*) pObject, pOut, pInfo->aDimColor, TRUE );

						// dieses Objekt im Mtf ueberspringen
						ImpSkipActualObject( nCurMarker, pOut );
					}
					else if ( pObject == (SdrObject*) pFuSlideShow->GetLayoutText() )
					{
						// animierte Gliederung, kann TEILWEISE sichtbar sein
						pFuSlideShow->PaintLayoutClone( pOut );
						ImpSkipActualObject( nCurMarker, pOut );
					}
					else
						ImpPlayToNextStart( nCurMarker, pOut );
				}
				else
					ImpSkipActualObject( nCurMarker, pOut );
			}
			else if ( aActMarker.IsStart() && aActMarker.IsSlowObj() )
				ImpPlaySlowObj( nCurMarker, pOut );
			else
				ImpPlayToNextMarker( nCurMarker, pOut );

			if ( nCurMarker != METAFILE_END )
				aActMarker = *MARKEROBJ( nCurMarker );
		}
	}

	pOut->SetDrawMode( nOldDrawMode );
}



