/*************************************************************************
 *
 *  $RCSfile: preview.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: thb $ $Date: 2001/11/27 15:16:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SD_PREVIEW_HXX
#define _SD_PREVIEW_HXX

#ifndef _SFXCTRLITEM_HXX //autogen
#include <sfx2/ctrlitem.hxx>
#endif
#ifndef _SFXDOCKWIN_HXX //autogen
#include <sfx2/dockwin.hxx>
#endif

#ifndef _SD_SDRESID_HXX
#include "sdresid.hxx"
#endif
#ifndef _SD_PREVCHLD_HXX
#include "prevchld.hxx"
#endif

class SdDrawDocument;
class SdView;
class FuSlideShow;
class SdDrawView;
class SdShowWindow;
class FrameView;
class SdrObject;

#define SDPREVIEWWIN_MAGIC 0x456789AB

#define PREVIEW_DRAWMODE_COLOR		DRAWMODE_DEFAULT
#define PREVIEW_DRAWMODE_GRAYSCALE	(DRAWMODE_GRAYLINE | DRAWMODE_GRAYFILL | DRAWMODE_BLACKTEXT | \
									 DRAWMODE_GRAYBITMAP | DRAWMODE_GRAYGRADIENT)
#define PREVIEW_DRAWMODE_BLACKWHITE	(DRAWMODE_BLACKLINE | DRAWMODE_BLACKTEXT | DRAWMODE_WHITEFILL | \
									 DRAWMODE_GRAYBITMAP | DRAWMODE_WHITEGRADIENT)

//------------------------------------------------------------------------

class SdPreviewWin : public SfxDockingWindow, public SfxControllerItem
{
 friend class SdPreviewChildWindow;
 friend class SdPreviewCtrlItem;

private:
	SdDrawDocument*		pDoc;
	SdDrawView*         pView;
	FuSlideShow*        pFuSlideShow;
	SdShowWindow*       pShowWindow;
	BOOL                bInAnimation;
	Point               aDownPos;
	ULONG               nMagic;

	SfxBindings* 		pBindings;
	SdPreviewCtrlItem*	pControllerItem;

	//DECL_LINK( ClickPreviewHdl, void * );

protected:
	virtual BOOL	Close();
	virtual void	Resize();

public:
			SdPreviewWin( SfxBindings* pBindings, SfxChildWindow *pCW,
						Window* pParent, const SdResId& rSdResId );
			~SdPreviewWin();

	void    SetContext(SdDrawDocument* pDrawDoc, USHORT nSdPage,
					   FrameView* pFrm);

	void    PaintContents(const Rectangle& rRect);
	void    KeyInputFromContents(const KeyEvent& rKEvt);
	void    MouseMoveFromContents(const MouseEvent& rMEvt);
	void    MouseButtonUpFromContents(const MouseEvent& rMEvt);
	void    MouseButtonDownFromContents(const MouseEvent& rMEvt);

	FuSlideShow*    GetSlideShow()   { return pFuSlideShow; }
	SdDrawDocument* GetDoc()         { return pDoc; }

	virtual void StateChanged( StateChangedType );

	void    HideAndAnimateObject(SdrObject* pObject);
	void    AnimatePage();
	BOOL    IsInAnimation() const { return bInAnimation; }

	SdShowWindow*	GetShowWindow() const { return pShowWindow; };
};

/*************************************************************************
|*
|* ControllerItem fuer Preview Window (Floating/Docking)
|*
\************************************************************************/

class SdPreviewCtrlItem : public SfxControllerItem
{
	SdPreviewWin* pPreviewWin;
	SfxStatusForwarder* pForwarder1;
	SfxStatusForwarder* pForwarder2;
	SfxStatusForwarder* pForwarder3;

 protected:
	virtual void StateChanged( USHORT nSId, SfxItemState eState,
								const SfxPoolItem* pState );

 public:
	SdPreviewCtrlItem( USHORT, SdPreviewWin*, SfxBindings* );
	~SdPreviewCtrlItem();
};

#endif		// _SD_PREVIEW_HXX

