/*************************************************************************
 *
 *  $RCSfile: slidvish.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2001/06/26 15:45:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SD_SLIDVISH_HXX
#define _SD_SLIDVISH_HXX

#ifndef _SD_VIEWSHEL_HXX
#include "viewshel.hxx"
#endif
#ifndef _SD_SLIDVIEW_HXX
#include "slidview.hxx"
#endif

#ifndef _VIEWFAC_HXX //autogen
#include <sfx2/viewfac.hxx>
#endif
#ifndef _SFXVIEWSH_HXX //autogen
#include <sfx2/viewsh.hxx>
#endif
class SdWindow;
class SdPage;

/*************************************************************************
|*
|*	  Beschreibung		SdSlideViewShell ist die ViewShell fuer den Diamodus
|*
\************************************************************************/

class SdSlideViewShell : public SdViewShell
{
	SdSlideView* pSlideView;

	Point		 aDisplayPos;
	Size		 aDisplaySize;

	BOOL		 bSetInitialZoomFactor;
	BOOL		 bInitializeWinPos;

	void Construct(SdDrawDocument* pDoc);

 protected:
	virtual void InnerResizePixel(const Point &rPos, const Size &rSize);
	virtual void OuterResizePixel(const Point &rPos, const Size &rSize);
	virtual Size GetOptimalSizePixel() const;

 public:
	TYPEINFO();

	SFX_DECL_VIEWFACTORY(SdSlideViewShell);
	SFX_DECL_INTERFACE(SD_IF_SDSLIDEVIEWSHELL);

	 SdSlideViewShell(SfxViewFrame *pFrame, const SdSlideViewShell& rShell);
	 SdSlideViewShell(SfxViewFrame* pFrame, SfxViewShell* pOldShell);
	~SdSlideViewShell();

	virtual void Paint(const Rectangle& rRect, SdWindow* pWin);
	virtual void AdjustPosSizePixel(const Point &rPos, const Size &rSize);

	virtual void AddWindow(SdWindow* pWin) { pSlideView->AddWin((OutputDevice*) pWin); }
	virtual void RemoveWindow(SdWindow* pWin) { pSlideView->DelWin((OutputDevice*) pWin); }

			void SelectionHasChanged();

	virtual BOOL KeyInput(const KeyEvent& rKEvt, SdWindow* pWin);
	virtual void MouseMove(const MouseEvent& rMEvt, SdWindow* pWin);
	virtual void MouseButtonUp(const MouseEvent& rMEvt, SdWindow* pWin);
	virtual void MouseButtonDown(const MouseEvent& rMEvt, SdWindow* pWin);
	virtual void Command(const CommandEvent& rCEvt, SdWindow* pWin);

	virtual SdPage*	GetActualPage();

	String GetPageRangeString();

	void ExecCtrl(SfxRequest &rReq);
	void GetCtrlState(SfxItemSet &rSet);
	void GetMenuState(SfxItemSet &rSet);
	void GetAttrState(SfxItemSet &rSet);

        void SetPagesPerRow( USHORT nPagesPerRow );

	void ExecStatusBar(SfxRequest& rReq);
	void GetStatusBarState(SfxItemSet& rSet);

	void FuTemporary(SfxRequest &rReq);
	void FuPermanent(SfxRequest &rReq);
	void FuSupport(SfxRequest &rReq);

	virtual void ReadFrameViewData(FrameView* pView);
	virtual void WriteFrameViewData();

	virtual void	SetZoom(long nZoom);
	virtual void	SetZoomRect(const Rectangle& rZoomRect);

	virtual BOOL    HasSelection( BOOL bText = TRUE ) const;

	void			DrawSelectionRect(USHORT nPage);

    virtual void WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse = sal_False );
    virtual void ReadUserDataSequence ( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse = sal_False );
};



#endif		// _SD_SLIDVISH_HXX

