/*************************************************************************
 *
 *  $RCSfile: slidview.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: ka $ $Date: 2001/11/23 14:13:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <math.h>

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _VIEW3D_HXX
#include <svx/view3d.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <sfx2/app.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXDOCFILE_HXX
#include <sfx2/docfile.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SV_POLY_HXX //autogen
#include <vcl/poly.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SVDUNDO_HXX //autogen
#include <svx/svdundo.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _GRFMGR_HXX
#include <goodies/grfmgr.hxx>
#endif

#include "docshell.hxx"
#include "slidview.hxx"
#include "slidvish.hxx"
#include "sdwindow.hxx"
#include "viewshel.hxx"
#include "frmview.hxx"
#include "sdpage.hxx"
#include "pres.hxx"
#include "drawdoc.hxx"
#include "sdresid.hxx"
#include "bmcache.hxx"
#include "showview.hxx"
#include "glob.hrc"
#include "fuslsel.hxx"
#include "sdxfer.hxx"
#include "sdmod.hxx"
#include "sdresid.hxx"
#include "strings.hrc"
#include "app.hrc"

using namespace ::com::sun::star;

#define NAME_HEIGHT_FRACTION  (ULONG)	   25
#define NAME_OFFSET_FRACTION  (ULONG)		4
#define SELRECT_OFFSET		  (ULONG)		2
#define SELRECT_THICKNESS	  (ULONG)		2
#define BITMAPCACHE_SIZE	  (ULONG) 4000000
#define ZOOM_TOLERANCE		  (long)	  -10
#define DELAYED_PAINT_TIMEOUT (ULONG)	   50

// ---------------------
// - DelayedPaintEvent -
// ---------------------

struct DelayedPaintEvent
{
	OutputDevice* pOut;
	Rectangle	  aRect;
};

// ---------------
// - SdSlideView -
// ---------------

TYPEINIT1( SdSlideView, SdView );

// -----------------------------------------------------------------------------

SdSlideView::SdSlideView(SdDrawDocument* pDoc, Window* pWindow, SdSlideViewShell* pSlideVShell) :
    SdView(pDoc, pWindow, pSlideVShell),
	nAllowInvalidateSmph(0),
	nPagesPerRow(4),
	pCache(NULL),
	pShowView(NULL),
	pVDev(NULL),
	bInDelayedPaint(FALSE),
	pSlideViewShell(pSlideVShell)
{
	SetAnimationEnabled( FALSE );
	ArrangePages();

	aDelayedPaintTimer.SetTimeout( DELAYED_PAINT_TIMEOUT );
	aDelayedPaintTimer.SetTimeoutHdl( LINK( this,SdSlideView,PaintDelayed ) );
	aDelayedPaintTimer.Start();
}

// -----------------------------------------------------------------------------

SdSlideView::~SdSlideView()
{
    aDelayedPaintTimer.Stop();

	delete pCache;
	delete pShowView;
	delete pVDev;

    for(  void* pEvt = aDelayedPaints.First(); pEvt; pEvt = aDelayedPaints.Next() )
        delete static_cast< DelayedPaintEvent* >( pEvt );
}

// -----------------------------------------------------------------------------

USHORT SdSlideView::ChangePagesPerRow(USHORT nNum)
{
	USHORT nResult = nPagesPerRow;
	
    nPagesPerRow = nNum;
	
    return nResult;
}

// -----------------------------------------------------------------------------

void SdSlideView::InvalidateOneWin( Window& rWin )
{
	if( IsInvalidateAllowed() )
		SdrPaintView::InvalidateOneWin(rWin);
}

// -----------------------------------------------------------------------------

void SdSlideView::InvalidateOneWin( Window& rWin, const Rectangle& rRect )
{
	if( IsInvalidateAllowed() )
		SdrPaintView::InvalidateOneWin(rWin, rRect);
}

// -----------------------------------------------------------------------------

void SdSlideView::Paint( const Rectangle& rRect, OutputDevice* pOut )
{

	const Color aOldLineColor( pOut->GetLineColor() );
	const Color aOldFillColor( pOut->GetFillColor() );
	SdPage*     pPage = 0;
	USHORT	    nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
	USHORT	    nPage;
	Point	    aPos;					// Position fuer Name
	Font	    aOldFont( pOut->GetFont() );
	Font	    aNewFont( OutputDevice::GetDefaultFont( DEFAULTFONT_SANS_UNICODE,
	                      pOut->GetSettings().GetInternational().GetLanguage(), FALSE, pOut ) );

	if( nNoOfPages > 0 )
	{
		pPage = pDoc->GetSdPage( 0, PK_STANDARD );
		
        Size    aPageSize( pPage->GetSize() );
		Size    aPixelSize( pOut->PixelToLogic(Size( 1, 1 ) ) );
		Size    aCPageSize( aPageSize.Width() + aPixelSize.Width(), aPageSize.Height() + aPixelSize.Height() );
		Size    aFontSize ( 0, pPage->GetSize().Height() / NAME_HEIGHT_FRACTION );
        Point   aNullPt;

		aNewFont.SetSize( aFontSize );
		aNewFont.SetTransparent( TRUE );
		pOut->SetFont( aNewFont );

		if( pShowView )
		{
			// ShowView und VDev existieren schon
			MapMode aMapMode( pOut->GetMapMode() );
			aMapMode.SetOrigin( aNullPt);
			pVDev->SetMapMode( aMapMode );
			pVDev->SetOutputSize( aCPageSize );
			pShowView->HideAllPages();
		}

		for( nPage = 0; nPage < nNoOfPages; nPage++ )
		{
			// Seitenbereich getroffen?
			if( rRect.IsOver( GetPageArea( nPage ) ) )
			{
				pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
				
                Rectangle aPageRect( CalcPagePos( nPage ), aPageSize );

				// die Seite selbst getroffen
				if( rRect.IsOver( aPageRect ) )
				{
					Fraction                aScale( pOut->GetMapMode().GetScaleX() );
					long	                nZoom = aScale.GetNumerator() * 100L / aScale.GetDenominator();
					long                    nZoomOfBitmap = nZoom;
					const GraphicObject*    pGraphicObject = GetFromCache( pPage, nZoomOfBitmap, ZOOM_TOLERANCE );

					// die Seite selbst zeichnen?
					if( bInDelayedPaint || pGraphicObject )
					{
						// nicht im Cache, erzeugen und in Cache stellen
						if( !pGraphicObject )
						{
                        	// wenn noetig, virtuelles Device und View erzeugen
							if( !pShowView )
							{
								pVDev = new VirtualDevice;
								MapMode aMapMode( pOut->GetMapMode() );
								aMapMode.SetOrigin( aNullPt );
								pVDev->SetMapMode( aMapMode );
								pVDev->SetOutputSize( aCPageSize );

    							pShowView = new ShowView( pDoc, pVDev, pSlideViewShell );
								pShowView->SetLineDraft( IsLineDraft() );
								pShowView->SetFillDraft( IsFillDraft() );
								pShowView->SetTextDraft( IsTextDraft() );
								pShowView->SetGrafDraft( IsGrafDraft() );
							}

							pShowView->ShowPage( pPage, aNullPt ); 

							SdrPageView*    pPageView = pShowView->GetPageView( pPage );
							FrameView*      pFrameView = pSlideViewShell->GetFrameView();
							Region          aRegion( Rectangle( aNullPt, aCPageSize ) );
							
							pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
                            pShowView->InitRedraw( pVDev,aRegion );
                            while(!pShowView->IsRedrawReady()) {}

							AddToCache( pPage, pVDev->GetBitmap( aNullPt, aCPageSize ), nZoom );
                           
                            pShowView->HidePage( pPageView );
                            pPage->ForceSwapOutObjects();
                            pGraphicObject = GetFromCache( pPage, nZoomOfBitmap, ZOOM_TOLERANCE );
						}

                        if( pGraphicObject )
                            const_cast< GraphicObject* >( pGraphicObject )->Draw( pOut, aPageRect.TopLeft(), aCPageSize );
					}
					else
					{
    					// spaeter zeichnen (kommt Zeit, kommt Paint)
						DelayedPaintEvent* pEvent = new DelayedPaintEvent;

						pEvent->aRect = aPageRect.GetIntersection(rRect);
						pEvent->aRect.Right() += aPixelSize.Width();
						pEvent->aRect.Bottom() += aPixelSize.Height();
						pEvent->pOut  = pOut;
						
                        aDelayedPaints.Insert(pEvent, LIST_APPEND);
					}

					// draw border around page (in every case)
					pOut->SetLineColor( Color( COL_BLACK ) );
					pOut->SetFillColor();
					pOut->DrawRect( aPageRect );
				}

				if( !bInDelayedPaint )
				{
					// Symbol fuer Ueberblendeffekt
					Rectangle aRect( GetFadeIconArea(nPage) );
					
                    if (pPage->GetFadeEffect() != presentation::FadeEffect_NONE )
					{
						pOut->SetLineColor( Color( COL_BLACK ) );
						pOut->SetFillColor();
						pOut->DrawRect(aRect);

						pOut->SetLineColor();
						pOut->SetFillColor( Color( COL_BLACK ) );

						Point aTriangle[3];
						aTriangle[0] = aRect.TopLeft();
						aTriangle[1] = aRect.Center();
						aTriangle[2] = aRect.BottomLeft();
						pOut->DrawPolygon(Polygon(3, aTriangle));
					}

					// Name der Seite
					aPos = CalcPagePos(nPage);
					
                    Size    aPageSize( pPage->GetSize() );
					Size    aSize( pOut->PixelToLogic( Size( 0, SELRECT_OFFSET + SELRECT_THICKNESS + 2 ) ) );
					String  aName (pPage->GetName());

					aPos.Y() += aPageSize.Height() + aSize.Height();


				    if( !aName.Len() )
					{
						String aStandardName( SdResId(STR_PAGE) );
						aName = aStandardName;
						aName += String::CreateFromInt32( nPage + 1 );
					}

					if( pOut->GetTextWidth(aName) > aPageSize.Width() - 2 * aRect.GetWidth() )
					{
						aName.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
						
                        while( pOut->GetTextWidth( aName ) > aPageSize.Width() - 2 * aRect.GetWidth() )
							aName.Erase(aName.Len() - 4, 1);
					}

					// rechtsbuendig unter der Seite
					aPos.X() += aPageSize.Width() - pOut->GetTextWidth( aName );

					// grau hinterlegen, wenn Seite ausgeschlossen
					if( pPage->IsExcluded() )
					{
						Size aTextSize( Size( pOut->GetTextWidth( aName ), pOut->GetTextHeight() ) );

						pOut->SetFillColor( Color( COL_LIGHTGRAY ) );
						pOut->SetLineColor();
						pOut->DrawRect( Rectangle( aPos, aTextSize ) );
					}

					pOut->DrawText( aPos, aName );
					DrawSelectionRect( nPage );
                }
			}
		}
	}

	pOut->SetFont( aOldFont );
	pOut->SetFillColor( aOldLineColor );
	pOut->SetFillColor( aOldFillColor );
}

// -----------------------------------------------------------------------------

void SdSlideView::DrawSelectionRect( USHORT nPage )
{
	pSlideViewShell->DrawSelectionRect( nPage );
}

// -----------------------------------------------------------------------------

Point SdSlideView::CalcPagePos( USHORT nPageNo ) const
{
	Point aResult;

	if( pDoc->GetSdPageCount( PK_STANDARD ) > 0 )
	{
		Size            aPageSize( pDoc->GetSdPage( 0, PK_STANDARD )->GetSize() );
		ULONG           nGapX = GetPageGap();
		ULONG           nGapY = nGapX;
		OutputDevice*   pOut = reinterpret_cast< OutputDevice* >( pSlideViewShell->GetActiveWindow() );
		Size            aSize( 0, SELRECT_OFFSET + SELRECT_THICKNESS + 2 );
		
        aSize = pOut->PixelToLogic( aSize );
		aSize.Height() += aPageSize.Height() / NAME_HEIGHT_FRACTION;
		
        if( (long) nGapY < aSize.Height() )
			nGapY = aSize.Height() * 2;

		aResult.X() = nPageNo % nPagesPerRow * ( nGapX + aPageSize.Width() ) + nGapX;
		aResult.Y() = nPageNo / nPagesPerRow * ( nGapY + aPageSize.Height() ) + nGapY;
	}
	
    return( aResult );
}

// -----------------------------------------------------------------------------

void SdSlideView::ArrangePages()
{
	USHORT  nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
	USHORT  nPage;
	Point   aOffset;

	if( nNoOfPages > 0 )
	{
		for( nPage = 0; nPage < nNoOfPages; nPage++ )
		{
			SetAllowInvalidate( FALSE );
			aOffset = CalcPagePos( nPage );
			SdrPage* pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
			SetAllowInvalidate( TRUE );
		}
	}
}

// -----------------------------------------------------------------------------

Rectangle SdSlideView::GetPageArea( USHORT nPageNo ) const
{
	Size    aSize( pDoc->GetSdPage( nPageNo, PK_STANDARD )->GetSize() );
	Point   aPos( CalcPagePos( nPageNo ) );

	aSize.Height() += aSize.Height() / NAME_HEIGHT_FRACTION + aSize.Height() / NAME_HEIGHT_FRACTION / NAME_OFFSET_FRACTION;
	Rectangle aResult( aPos, aSize );

	// dazu auf jeder Seite SELRECT_OFFSET Pixel Abstand + SELRECT_THICKNESS Pixel Selektionsrahmen + 2 Pixel Toleranz
	OutputDevice*   pOut = reinterpret_cast< OutputDevice* >( pSlideViewShell->GetActiveWindow() );
	Size            aPixelSize( pOut->PixelToLogic( Size( 1, 1 ) ) );
	USHORT          nFactor = SELRECT_OFFSET + SELRECT_THICKNESS + 2;
	
    aResult.Left() -= nFactor * aPixelSize.Width();
	aResult.Right() += nFactor * aPixelSize.Width();
	aResult.Top() -= nFactor * aPixelSize.Height();
	aResult.Bottom() += nFactor * aPixelSize.Height();

	return( aResult );
}

// -----------------------------------------------------------------------------

ULONG SdSlideView::GetPageGap() const
{
	ULONG nResult;
	
    if( pDoc->GetSdPageCount( PK_STANDARD ) > 0 )
		nResult = pDoc->GetSdPage( 0, PK_STANDARD )->GetSize().Width() / 8;
    else
        nResult = 0;

	return nResult;
}

// -----------------------------------------------------------------------------

Rectangle SdSlideView::GetFadeIconArea(USHORT nPageNo) const
{
	SdPage*         pPage = pDoc->GetSdPage( nPageNo, PK_STANDARD );
	Size	        aPageSize( pPage->GetSize() );
	Point	        aPos( CalcPagePos( nPageNo ) );
	OutputDevice*   pOut = reinterpret_cast< OutputDevice* >( pSlideViewShell->GetActiveWindow() );
	Size            aSize( 0, SELRECT_OFFSET + SELRECT_THICKNESS + 2 );
	
    aSize = pOut->PixelToLogic( aSize );
	aPos.Y() += aPageSize.Height() + aSize.Height();

	return Rectangle(aPos, Size( aPageSize.Height() / NAME_HEIGHT_FRACTION, aPageSize.Height() / NAME_HEIGHT_FRACTION ) );
}

// -----------------------------------------------------------------------------

SdPage* SdSlideView::GetHitPage( const Point& rPos ) const
{
    SdPage* pRet = NULL;
    
    for( USHORT nPage = 0, nCount = pDoc->GetSdPageCount( PK_STANDARD ); ( nPage < nCount ) && !pRet; nPage++ )
        if( GetPageArea( nPage ).IsInside( rPos ) )
            pRet = pDoc->GetSdPage( nPage, PK_STANDARD );

    return pRet;
}

// -----------------------------------------------------------------------------

SdPage* SdSlideView::GetNearestPage( const Point& rPos ) const
{
    SdPage* pRet = NULL;
    USHORT  nPageCount = pDoc->GetSdPageCount( PK_STANDARD );

    if( nPageCount )
    {
        Point       aCenter( GetPageArea( 0 ).Center() );
        USHORT      nBestPage = 0;
        double      fBestDist = hypot( rPos.X() - aCenter.X(), rPos.Y() - aCenter.Y() );

        for( USHORT nPage = 1; nPage < nPageCount; nPage++ )
        {
            aCenter = GetPageArea( nPage ).Center();
            const double fDist = hypot( rPos.X() - aCenter.X(), rPos.Y() - aCenter.Y() );

            if( fDist < fBestDist )
            {
                nBestPage = nPage;
                fBestDist = fDist;
                
            }
        }

        pRet = pDoc->GetSdPage( nBestPage, PK_STANDARD );
    }

    return pRet;
}

// -----------------------------------------------------------------------------

SdPage* SdSlideView::GetFadePage( const Point& rPos ) const
{
    SdPage* pRet = NULL;
    
    for( USHORT nPage = 0, nCount = pDoc->GetSdPageCount( PK_STANDARD ); ( nPage < nCount ) && !pRet; nPage++ )
        if( GetFadeIconArea( nPage ).IsInside( rPos ) )
            pRet = pDoc->GetSdPage( nPage, PK_STANDARD );

    return pRet;
}

// -----------------------------------------------------------------------------

void SdSlideView::AddToCache( SdPage* pPage, const Bitmap& rBitmap, long nZoom )
{
	if( !pCache )
        pCache = new BitmapCache( BITMAPCACHE_SIZE );
	
    pCache->Add(pPage, rBitmap, nZoom);
}

// -----------------------------------------------------------------------------

const GraphicObject* SdSlideView::GetFromCache( SdPage* pPage, long& rZoom, long nZoomTolerance) const
{
	const GraphicObject* pGraphicObject = NULL;
	
    if( pCache )
		pGraphicObject = pCache->Get( pPage, rZoom, nZoomTolerance );

	return pGraphicObject;
}

// -----------------------------------------------------------------------------

IMPL_LINK( SdSlideView, PaintDelayed, Timer *, pTimer )
{
	do
	{
		if( aDelayedPaints.Count() > 0 )
		{
			FuPoor* pFu = pSlideViewShell->GetActualFunction();
			
            if (!pFu									||
				(pFu && !pFu->ISA(FuSlideSelection))	||
				(pFu && pFu->ISA(FuSlideSelection) &&
				!((FuSlideSelection*)pFu)->IsShowingEffect()))
			{
				DelayedPaintEvent* pEvent = static_cast< DelayedPaintEvent* >( aDelayedPaints.Remove( (ULONG) 0 ) );
				
                bInDelayedPaint = TRUE;

				if( OUTDEV_WINDOW == pEvent->pOut->GetOutDevType() )
				{
					static_cast< Window* >( pEvent->pOut )->Invalidate( pEvent->aRect );
					static_cast< Window* >( pEvent->pOut )->Update();
				}
				else
					Paint( pEvent->aRect, pEvent->pOut );

				bInDelayedPaint = FALSE;
				delete pEvent;
			}
		}
	}
	while (!GetpApp()->AnyInput() && aDelayedPaints.Count() > 0 );

	pTimer->Start();
	
    return 0;
}

// -----------------------------------------------------------------------------

void SdSlideView::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							           const SfxHint& rHint, const TypeId& rHintType)
{
	SdrHint* pSdrHint = PTR_CAST( SdrHint, &rHint );

	if( pSdrHint )
	{
		SdrHintKind eHint = pSdrHint->GetKind();

		if( eHint == HINT_PAGEORDERCHG )
		{
			ArrangePages();
			InvalidateAllWin();
		}
		else
		{
			const SdrPage* pChangedPage = pSdrHint->GetPage();

			if( pChangedPage )
			{
				if( pChangedPage->IsMasterPage() )
				{
					if( pCache )
						delete pCache, pCache = NULL;
				}
				else
				{
					SdrPageView* pPageView = GetPageView( pChangedPage );

					if( pPageView && pCache )
					    pCache->Remove( (SdPage*) pChangedPage );
				}
			}
		}
	}

	FmFormView::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
}

// -----------------------------------------------------------------------------

void SdSlideView::SetAllowInvalidate(BOOL bFlag)
{
	if( !bFlag )
		nAllowInvalidateSmph++;
	else if( nAllowInvalidateSmph > 0 )
		nAllowInvalidateSmph--;
}

// -----------------------------------------------------------------------------

BOOL SdSlideView::IsInvalidateAllowed() const
{
	return( nAllowInvalidateSmph == 0 );
}

// -----------------------------------------------------------------------------

void SdSlideView::DeleteMarked()
{
	String  aStr( SdResId( STR_UNDO_DELETEPAGES ) );
	USHORT  nPage = 0;
	SdPage* pPage = pDoc->GetSdPage( nPage, PK_STANDARD );

	BegUndo( aStr );

	while( pPage )
	{
		pPage = pDoc->GetSdPage( nPage, PK_STANDARD );

		if( pPage->IsSelected() && pDoc->GetSdPageCount( PK_STANDARD ) > 1 )
		{
			AddUndo( new SdrUndoDelPage( *pPage ) );
			pDoc->RemovePage( pPage->GetPageNum() );
			pPage = pDoc->GetSdPage( nPage, PK_NOTES );
			AddUndo( new SdrUndoDelPage( *pPage ) );
			pDoc->RemovePage( pPage->GetPageNum() );
		}
		else
			nPage++;

		pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
	}

	EndUndo();
}

// -----------------------------------------------------------------------------

void SdSlideView::MoveMarked( USHORT nTargetPage )
{
	String                      aComment ( SdResId( STR_UNDO_SLIDE_MOVE ) );
	USHORT	                    nPage, nNoOfPages = pDoc->GetSdPageCount( PK_STANDARD );
    ::std::vector< SdPage* >    aOldPageVect( nNoOfPages );

	for( nPage = 0; nPage < nNoOfPages; nPage++ )
		aOldPageVect[ nPage ] = pDoc->GetSdPage( nPage, PK_STANDARD );

	SetAllowInvalidate( FALSE );
	BOOL bMoved = pDoc->MovePages( nTargetPage );
	SetAllowInvalidate( TRUE );

	if( bMoved )
	{
        ::std::vector< SdPage* > aNewPageVect( nNoOfPages );

		for( nPage = 0; nPage < nNoOfPages; nPage++ )
		    aNewPageVect[ nPage ] = pDoc->GetSdPage( nPage, PK_STANDARD );

		ArrangePages();

		for( nPage = 0; nPage < nNoOfPages; nPage++ )
		{
			if( aNewPageVect[ nPage ] != aOldPageVect[ nPage ] )
			{
				InvalidateAllWin( GetPageArea( nPage ) );
				pViewSh->UpdateWindows();
			}
		}
	}
}

// -----------------------------------------------------------------------------

void SdSlideView::CreateSlideTransferable( Window* pWindow, BOOL bDrag )
{
	List	aBookmarkList;
	SdPage* pPage = NULL;

	for( USHORT nPage = 0, nPgCnt = pDoc->GetSdPageCount( PK_STANDARD ); nPage < nPgCnt; nPage++ )
	{
		pPage = pDoc->GetSdPage( nPage, PK_STANDARD );

		if( pPage->IsSelected() )
			aBookmarkList.Insert( new String( pPage->GetName() ), LIST_APPEND );
	}

	if( aBookmarkList.Count() )
	{
		BrkAction();

    	SdTransferable* pTransferable = new SdTransferable( pDoc, NULL, FALSE );
	    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > xRet( pTransferable );
    	TransferableObjectDescriptor aObjDesc;

        if( bDrag )
    	    SD_MOD()->pTransferDrag = pTransferable;
        else
    	    SD_MOD()->pTransferClip = pTransferable;

	    pDoc->CreatingDataObj( pTransferable );
	    pTransferable->SetWorkDocument( (SdDrawDocument*) GetAllMarkedModel() );
	    pDoc->CreatingDataObj( NULL );
        pTransferable->GetWorkDocument()->GetDocSh()->FillTransferableObjectDescriptor( aObjDesc );

	    if( pDocSh )
		    aObjDesc.maDisplayName = pDocSh->GetMedium()->GetURLObject().GetURLNoPass();

        Window* pActionWindow = ( pWindow ? pWindow : pViewSh->GetActiveWindow() );
   
    	pTransferable->SetStartPos( pActionWindow->PixelToLogic( pActionWindow->GetPointerPosPixel() ) );
    	pTransferable->SetObjectDescriptor( aObjDesc );
		pTransferable->SetPageBookmarks( aBookmarkList, !bDrag );

		for( void* p = aBookmarkList.First(); p; p = aBookmarkList.Next() )
			delete static_cast< String* >( p );

        if( bDrag )
        {
            pTransferable->SetView( this );
    	    pTransferable->StartDrag( pActionWindow, DND_ACTION_COPY | DND_ACTION_MOVE );
        }
        else
    	    pTransferable->CopyToClipboard( pActionWindow );
	}
}

// -----------------------------------------------------------------------------

void SdSlideView::DoCut( Window* pWindow )
{
	String aString( SdResId( STR_WARN_DEL_SEL_PAGES ) );

	if( pDoc->GetSdPageCount( PK_STANDARD ) > 1 && QueryBox( pWindow, WB_YES_NO, aString ).Execute() == RET_YES )
	{
		DoCopy( pWindow );
		DeleteMarked();
	}
}

// -----------------------------------------------------------------------------

void SdSlideView::DoCopy( Window* pWindow )
{
    CreateSlideTransferable( pWindow, FALSE );
}

// -----------------------------------------------------------------------------

void SdSlideView::DoPaste(Window* pWindow)
{
    SdTransferable* pClipTransferable = SD_MOD()->pTransferClip;

    if( pClipTransferable && pClipTransferable->IsPageTransferable() )
     {
	    pDocSh->SetWaitCursor( TRUE );

	    SdView::DoPaste( pWindow );

	    SfxUInt16Item aItem( SID_PAGES_PER_ROW, nPagesPerRow);

	    ( pDocSh->GetViewShell() ? pDocSh->GetViewShell()->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher()->Execute(
		    SID_PAGES_PER_ROW, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L, 0L );

	    pDocSh->SetWaitCursor( FALSE );
    }
}

// -----------------------------------------------------------------------------

void SdSlideView::StartDrag( const Point& rDragPt, Window* pWindow )
{
    CreateSlideTransferable( pWindow, TRUE );
}

// -----------------------------------------------------------------------------

void SdSlideView::DragFinished( sal_Int8 nDropAction )
{
	SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;

	if( pDragTransferable )
		pDragTransferable->SetView( NULL );

	if( nDropAction & DND_ACTION_MOVE )
        DeleteMarked();
}

// -----------------------------------------------------------------------------

sal_Int8 SdSlideView::AcceptDrop( const AcceptDropEvent& rEvt, DropTargetHelper& rTargetHelper, 
                                  SdWindow* pTargetWindow, USHORT nPage, USHORT nLayer )
{
    SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;
    sal_Int8        nRet = DND_ACTION_NONE;

    if( pDragTransferable && pDragTransferable->IsPageTransferable() )
        nRet = rEvt.mnAction;

    return nRet;
}

// -----------------------------------------------------------------------------

sal_Int8 SdSlideView::ExecuteDrop( const ExecuteDropEvent& rEvt, DropTargetHelper& rTargetHelper,
                                   SdWindow* pTargetWindow, USHORT nPage, USHORT nLayer )
{
    SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;
    sal_Int8        nRet = DND_ACTION_NONE;

    if( pDragTransferable && pDragTransferable->IsPageTransferable() )
    {
        const Point aEvtPos( pTargetWindow->PixelToLogic( rEvt.maPosPixel ) );
        const BOOL  bCont = ( pDragTransferable->GetView() != this ) ||
                            ( ( labs( pDragTransferable->GetStartPos().X() - aEvtPos.X() ) >= 2 ) &&
                              ( labs( pDragTransferable->GetStartPos().Y() - aEvtPos.Y() ) >= 2 ) );

        if( bCont )
        {
            SdPage* pNearestSdPage = GetNearestPage( aEvtPos );
            USHORT  nNearestSdPagePos = pNearestSdPage ? ( ( pNearestSdPage->GetPageNum() - 1 ) / 2 ) : ( pDoc->GetSdPageCount( PK_STANDARD ) - 1 );

            if( ( pDragTransferable->GetView() == this ) && ( DND_ACTION_MOVE == rEvt.mnAction ) )
            {
                MoveMarked( nNearestSdPagePos );
                nRet = DND_ACTION_NONE;
            }
            else
            {
		        USHORT	nInsertPgCnt, nInsertPos = ( nNearestSdPagePos + 1 ) * 2 + 1;
                BOOL    bMergeMasterPages = !pDragTransferable->HasSourceDoc( pDoc );

                if( pDragTransferable->HasPageBookmarks() )
                {
                    const List& rBookmarkList = pDragTransferable->GetPageBookmarks();
		            
                    nInsertPgCnt = (USHORT) rBookmarkList.Count();
		            pDoc->InsertBookmarkAsPage( const_cast< List* >( &rBookmarkList ), NULL, FALSE, FALSE, nInsertPos, TRUE, pDragTransferable->GetPageDocShell(), TRUE, bMergeMasterPages );
                }
                else
                {
		            SvEmbeddedObject*	pObj = pDragTransferable->GetDocShell();
		            SdDrawDocShell*		pDataDocSh = pDragTransferable->HasPageBookmarks() ? pDragTransferable->GetPageDocShell() : ( (SdDrawDocShell*) pObj );
		            SdDrawDocument*		pDataDoc = pDataDocSh->GetDoc();
		            
                    nInsertPgCnt = pDataDoc->GetSdPageCount( PK_STANDARD );
		            pDoc->InsertBookmarkAsPage( NULL, NULL, FALSE, FALSE, nInsertPos, TRUE, pDataDocSh, TRUE, bMergeMasterPages );
                }

		        // deselect all pages
		        for( USHORT nPage = 0, nPgCnt = pDoc->GetSdPageCount( PK_STANDARD ); nPage < nPgCnt; nPage++ )
			        pDoc->GetSdPage( nPage, PK_STANDARD )->SetSelected( FALSE );

		        // select inserted pages
                for( USHORT i = 1; i <= nInsertPgCnt; i++ )
                {
    		        SdPage*	pPage = pDoc->GetSdPage( nNearestSdPagePos + i, PK_STANDARD );

	    	        if( pPage )
		    	        pPage->SetSelected( TRUE );
                }

                // Update
                ( (SdSlideViewShell*) pViewSh )->SetPagesPerRow( nPagesPerRow );
                nRet = rEvt.mnAction;
            }
        }
    }

	return nRet;
}

// -----------------------------------------------------------------------------

void SdSlideView::UpdateAllPages()
{
	delete pCache, pCache = NULL;
	InvalidateAllWin();
}
