/*************************************************************************
 *
 *  $RCSfile: sihelp.hxx,v $
 *
 *  $Revision: 1.7.2.2 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 11:07:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SIHELP_HXX
#define _SIHELP_HXX

class SiDirEntry;
class SiCompiledScript;
class SiEnvironment;
class SiFileStream;
class SiModule;
class SiModuleSet;
class SiFile;
class SiDirectory;
class SiProfileItem;
class RegistryLoader;
class SiCustom;
class SiStarRegistry;

#define UNX_LICENSE_FILE_NAME	"LICENSE"
#define MAC_LICENSE_FILE_NAME	"LICENSE"
#define WIN_LICENSE_FILE_NAME	"license.txt"

#define UNX_README_FILE_NAME	"README"
#define MAC_README_FILE_NAME	"readme_me"
#define WIN_README_FILE_NAME	"readme.txt"


#if defined(UNX)
#define LICENSE_FILE_NAME	UNX_LICENSE_FILE_NAME
#elif defined(MAC)
#define LICENSE_FILE_NAME	MAC_LICENSE_FILE_NAME
#else
#define LICENSE_FILE_NAME	WIN_LICENSE_FILE_NAME
#endif

#if defined(UNX)
#define README_FILE_NAME	UNX_README_FILE_NAME
#elif defined(MAC)
#define README_FILE_NAME	MAC_README_FILE_NAME
#else
#define README_FILE_NAME	WIN_README_FILE_NAME
#endif

#define README_ZIP			"readme.zip"

struct SiHelpImpl;

class SiHelp
{
	static SiHelpImpl* 	pHelpImpl;
	static void			_ModuleDump( SiModule* pMod, SiFileStream& rStrm, USHORT nLevel );
public:
		SiHelp() {}
		~SiHelp() {}

	static ByteString  	FindInstallation(SiProfileItem const*, ByteString const& aKey = ByteString());
	static BOOL			IsVersionAlreadyInstalled(ByteString& rPath, SiCompiledScript* pCS, SiEnvironment* pEnv);

	static SiModule* 	FindModuleByID(SiModule* pRoot, const ByteString& rID);
	static SiModule* 	FindModuleByName(SiModule* pRoot, const ByteString& rName, const ByteString* pParentName = NULL);
	static SiModuleSet* FindModuleSetByName(SiEnvironment* pEnv, const ByteString& rName);
	static SiModule* 	FindModuleByFileName(SiModule* pRoot, const ByteString& rFileName);
	static SiDirectory* FindDirectoryByName(SiModule* pRoot, const ByteString& rName);
	static SiFile*		FindFileByName(SiModule* pRoot, const ByteString& rName);
	static SiStarRegistry* FindRegistryByName(SiModule* pRoot, const ByteString& rName);

	static USHORT 		GetSelectedModuleCount(SiModule* pRoot);
	static USHORT	 	CountInstalledRefs(SiModule* pRoot, const ByteString& rFileName);
	static ULONG 		CountAllFiles(SiModule* pRoot);
	static BOOL			ModuleDump( SiModule* pRoot, const ByteString& rFileName );

	static void			SelectAllDontSelectByUser(SiModule* pMod);
	static void			TransferSelection(SiModule* pSrc, SiModule* pDest);

	static ULONG		GetClusterSizeForFirstFreeVolume( ULONG nSize, BOOL& rIsFat );
	static BOOL			CheckInstallationSize( SiCompiledScript* pCS, SiEnvironment* pEnv,
                                               const SiDirEntry& rDestPath,
                                               ULONG *pSysVol = 0,
                                               ULONG *pDestVol = 0 );
	static BOOL			CorrectToFirstFreeVolume(SiCompiledScript* pCS, SiEnvironment* pEnv);

	static RegistryLoader* GetStaticRegistryLoader(const SiEnvironment& rEnv);
	static void			DisposeUNOImpl();

	static BOOL			RawRegister( const UniString aFilename, const UniString& rAbsRegistryname, ByteString& rErrMsg, BOOL bRegister );
	static BOOL 		RegisterUnoComponent( const ByteString& rFilename, BOOL bRegister );
	static BOOL			RegisterUnoComponent( SiFile* pFile, const SiEnvironment& rEnv, BOOL bRegister, ByteString& rErrMsg );

	static USHORT       GetUIPageIdByName(const ByteString& rName);
	static ByteString 	GetUIPageByteStringById(USHORT nId);

	static ByteString	GetReadmeFilename( USHORT nLanguage, USHORT nType );
	static ByteString 	UnzipReadmeZIP( USHORT nLanguage, SiCompiledScript* pCS, SiEnvironment* pEnv );
	static void			MakeOffice_AuthFile(SiCompiledScript* pCS, SiEnvironment* pEnv);

	static BOOL 		IsOfficeRunning( const ByteString& rInstalledPath );

	static ByteString	Get2AlphaCountryCode(USHORT nIdx);
	static ByteString	Get3AlphaCountryCode(USHORT nIdx);

	static SiCustom*	GetMigrationPlugin(SiModule* pModule);
	static void 		InitMigration(SiCompiledScript* pCS, SiEnvironment* pEnv);

	static void         KillQuickStarter(SiEnvironment* pEnv, SiCompiledScript *);
};

class SiInstallation;

namespace setup
{
	BOOL isAdabas(SiInstallation const* pInst);
}

#endif

