/*************************************************************************
 *
 *  $RCSfile: nwinos.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: iha $ $Date: 2001/09/18 21:37:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <windows.h>
#include <winbase.h>
#include <shlobj.h>

#include <direct.h>
#include <stdio.h>
#include <io.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "svunzip.h"

#ifndef _NWINOS_HXX
#include "nwinos.hxx"
#endif

// ============================================================================
// ============================================================================
// ============================================================================

void _SHFree( void *pv )
{
	IMalloc	*pMalloc;
	if( NOERROR == SHGetMalloc(&pMalloc) )
	{
		pMalloc->Free( pv );
		pMalloc->Release();
	}
}

BOOL __SHGetSpecialFolder( int nFolderID, char* buf )
{
	//returns true if no error occured
	LPITEMIDLIST	pidl;
	HRESULT			hHdl = SHGetSpecialFolderLocation( NULL, nFolderID, &pidl );
	if( hHdl == NOERROR )
	{
		char pszPath[_MAX_PATH];
		SHGetPathFromIDList( pidl, pszPath );
		strcpy( buf, pszPath );
		_SHFree( pidl );
		return true;
	}
	return false;
}

void _SHGetSpecialFolder( int nFolderID, char* buf )
{
	if( !__SHGetSpecialFolder( nFolderID, buf ) )
		GetWindowsDirectory( buf, MAX_PATH );
}

HRESULT WINAPI SHCoCreateInstance( LPVOID lpszReserved, REFCLSID clsid, LPUNKNOWN pUnkUnknown, REFIID iid, LPVOID *ppv )
{
	HRESULT	hResult = E_NOTIMPL;
	HMODULE	hModShell = GetModuleHandle( "SHELL32" );

	if ( hModShell != NULL )
	{
		typedef	HRESULT (WINAPI *SHCoCreateInstance_PROC)( LPVOID lpszReserved, REFCLSID clsid, LPUNKNOWN pUnkUnknwon, REFIID iid, LPVOID *ppv );

		SHCoCreateInstance_PROC	lpfnSHCoCreateInstance = (SHCoCreateInstance_PROC)GetProcAddress( hModShell, MAKEINTRESOURCE(102) );

		if ( lpfnSHCoCreateInstance )
			hResult = lpfnSHCoCreateInstance( lpszReserved, clsid, pUnkUnknown, iid, ppv );
	}
	return hResult;
}

unsigned short __GetGUIVersion()
{
	WORD  nGUIVersion = (WORD) GetVersion();
	unsigned short nVer = ((((USHORT)LOBYTE(nGUIVersion))*100)+HIBYTE(nGUIVersion));
	return nVer;
}

// ============================================================================
// ============================================================================
// ============================================================================

DWORD FAR PASCAL __PingThread( LPSTR lpData )
{
	WinOS* pOS = (WinOS*)lpData;


	while(true)
	{
		time_t ltime;
		time( &ltime );

		if( pOS->GetLastPing() < (unsigned long)(ltime-30) )
			exit( -1 );

		::Sleep( 1000 );
	}

	return 1;
}

// ============================================================================

WinOS::WinOS( int argc, char* argv[] )
{
	nLastPing = 0;
	m_cCleanupAfterRebootFile = 0;
}

int WinOS::Startup( int argc, char* argv[] )
{
	HWND hWnd;
	char Title[256];
	if( (GetConsoleTitle(Title, sizeof(Title)) > 0) && ((hWnd = FindWindow(NULL, Title)) != NULL) )
		ShowWindow(hWnd, SW_HIDE);

	ping();

	DWORD dwThreadID;
	hThread = ::CreateThread( (LPSECURITY_ATTRIBUTES)NULL,
				0,
				(LPTHREAD_START_ROUTINE)__PingThread,
				(LPVOID)this,
				0, &dwThreadID );

	return 0;
}

void WinOS::Terminate()
{
	return;
}

void WinOS::ShowCMDWindow()
{
	HWND hWnd;
	char Title[256];
	if ((GetConsoleTitle(Title, sizeof(Title)) > 0) &&
		((hWnd = FindWindow(NULL, Title)) != NULL))
		ShowWindow(hWnd, SW_SHOW);
}

void WinOS::GetSVersion( char* buf, int len )
{
	_SHGetSpecialFolder( CSIDL_APPDATA, buf );
	strcat( buf, "\\sversion.ini" );
}

void WinOS::ping()
{
	time_t ltime;
	time( &ltime );
	nLastPing = ltime;
}

// ============================================================================
// ============================================================================
// ============================================================================

BOOL WinOS::makeDir( char* path, int rights )
{
	return mkdir( path ) == 0 ? TRUE : FALSE;
}

BOOL WinOS::removeDir( char* path )
{
	return rmdir( path ) == 0 ? TRUE : FALSE;
}

void WinOS::setDateTime(char* filename, int hour, int min, int sec,
	int day, int month, int year )
{
	if( day == 17 && month == 2 && year == 1969 ) return;

	HANDLE hFile = CreateFile( filename, GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
							   OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
	if( hFile != INVALID_HANDLE_VALUE )
	{
		SYSTEMTIME aTime;
		aTime.wYear			= year;
		aTime.wMonth		= month;
		aTime.wDayOfWeek	= 0;
		aTime.wDay			= day;
		aTime.wHour			= hour;
		aTime.wMinute		= min;
		aTime.wSecond		= sec;
		aTime.wMilliseconds	= 0;

		FILETIME aFileTime;
		SystemTimeToFileTime( &aTime, &aFileTime );

		FILETIME aLocalFileTime;
		LocalFileTimeToFileTime( &aFileTime, &aLocalFileTime );

		SetFileTime( hFile, &aLocalFileTime, &aLocalFileTime, &aLocalFileTime );
		CloseHandle( hFile );
	}
}

void WinOS::setRights(char* filename, int rights)
{
}

// ============================================================================
// ============================================================================
// ============================================================================

ULONG WinOS::GetFreeDriveSize( char* _cDrive )
{
	ULONG nFreeSize = 0;

	USHORT nDrive = strupr(_cDrive)[0] - 'A';

	char cDrive[4];
	cDrive[0] = 'A' + nDrive;
	strcpy( cDrive+1, ":\\" );

	HINSTANCE hModule;
	hModule = LoadLibrary("kernel32.dll");
	if( !(hModule <= (HINSTANCE)HINSTANCE_ERROR) )
	{
		typedef BOOL (WINAPI *WIN_GETDISKFREESPACE_EX) (
				LPCTSTR strDirName,
				PULARGE_INTEGER lpFreeCaller,
				PULARGE_INTEGER lpTotal,
				PULARGE_INTEGER lpTotalFree );

		WIN_GETDISKFREESPACE_EX fnc_GetDiskFreeSpaceEx =
				(WIN_GETDISKFREESPACE_EX) GetProcAddress(hModule, "GetDiskFreeSpaceExA");

		if( fnc_GetDiskFreeSpaceEx )
		{
			ULARGE_INTEGER nFreeCaller;
			ULARGE_INTEGER nTotal;
			ULARGE_INTEGER nTotalFree;

			if( fnc_GetDiskFreeSpaceEx((LPCTSTR)cDrive, &nFreeCaller, &nTotal, &nTotalFree) )
				nFreeSize = (ULONG) (nFreeCaller.QuadPart / 1024);
		}
	}

	if( !nFreeSize )
	{
		DWORD nSectorsPerCluster;
		DWORD nBytesPerSector;
		DWORD nFreeClusters;
		DWORD nClusters;

		GetDiskFreeSpace( (LPCTSTR)cDrive, &nSectorsPerCluster, &nBytesPerSector,
			&nFreeClusters, &nClusters );

		nFreeSize  = nFreeClusters;
		nFreeSize *= nBytesPerSector;
		nFreeSize /= 1024;
		nFreeSize *= nSectorsPerCluster;
	}

	return nFreeSize;
}

ULONG WinOS::GetClusterSize( char* _cDrive )
{
	ULONG nSize = 0;
	USHORT nDrive = strupr(_cDrive)[0] - 'A';

	char cDrive[4];
	cDrive[0] = 'A' + nDrive;
	strcpy( cDrive+1, ":\\" );

	DWORD nSectorsPerCluster;
	DWORD nBytesPerSector;
	DWORD nFreeClusters;
	DWORD nClusters;

	GetDiskFreeSpace( (LPCTSTR)cDrive, &nSectorsPerCluster, &nBytesPerSector,
		&nFreeClusters, &nClusters );

	ULONG nReturn = nBytesPerSector * nSectorsPerCluster;
	if( !nReturn || nReturn > 65536 )
		nReturn = 32768;
	return nReturn;
}

// ============================================================================
// ============================================================================
// ============================================================================

void WinOS::getOSDir(char* buf)
{
	GetWindowsDirectory( buf, MAX_PATH );
}

void WinOS::getOSSystemDir(char* buf)
{
 	GetSystemDirectory( buf, MAX_PATH );
}

void WinOS::getOSsystemFontDir(char* buf)
{
	if( __GetGUIVersion() >= 400 )
	{
		char cOSDir[MAX_PATH];
		getOSDir(cOSDir);
		sprintf( buf, "%s\\Fonts", cOSDir );
	}
	else
		getOSSystemDir( buf );
}

void WinOS::getHomeDir(char* buf)
{
	_SHGetSpecialFolder( CSIDL_APPDATA, buf );
}

void WinOS::getConfigDir(char* buf)
{
	_SHGetSpecialFolder( CSIDL_APPDATA, buf );
}

void WinOS::getServiceDir(char* buf)
{
		char cOSDir[MAX_PATH];
		getOSSystemDir(cOSDir);
		sprintf( buf, "%s\\drivers\\etc\\", cOSDir );
}

void WinOS::getOSShellnewDir(char* buf)
{
	_SHGetSpecialFolder( CSIDL_TEMPLATES, buf );
}

void WinOS::getAutoStart(char* buf)
{
	_SHGetSpecialFolder( CSIDL_STARTUP, buf );
}

void WinOS::getOSDesktopDir(char* buf)
{
	_SHGetSpecialFolder( CSIDL_DESKTOPDIRECTORY, buf );
}

void WinOS::getBookmarkDir(char* buf)
{
	_SHGetSpecialFolder( CSIDL_FAVORITES, buf );
}

void WinOS::getPersonalDir(char* buf)
{
	_SHGetSpecialFolder( CSIDL_PERSONAL, buf );
}

void WinOS::getIEPluginDir(char* buf, BOOL bPlugin )
{
	HKEY hKey;
	TCHAR arCurrent[MAX_PATH];
	DWORD dwType, dwCurrentSize = sizeof(arCurrent);
	if( ::RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\IE4\\SETUP", 0, KEY_READ, &hKey) == ERROR_SUCCESS )
	{
		if( ::RegQueryValueEx( hKey, "Path", NULL, &dwType, (LPBYTE)arCurrent, &dwCurrentSize ) == ERROR_SUCCESS )
		{
			if( bPlugin )
			{
				if( strlen(arCurrent) && arCurrent[strlen(arCurrent)-1]!='\\')
					strcat( arCurrent, "\\" );
				strcat( arCurrent, "Plugins" );
			}
			if( strncmp(arCurrent, "%programfiles%", 14) == 0 )
			{
				strcpy( buf, getenv("programfiles") );
				strcat( buf, &(arCurrent[14]) );
			}
			else
				strcpy( buf, arCurrent );
		}
		::RegCloseKey( hKey );
	}
}

void WinOS::getIEDir(char* buf)
{
	getIEPluginDir(buf, FALSE );
}

void WinOS::getNSPluginDir(char* buf)
{
	HKEY hKey1, hKey2;
	TCHAR arCurrent[MAX_PATH];
	DWORD dwType, dwCurrentSize = sizeof(arCurrent);

	if (::RegOpenKeyEx( HKEY_LOCAL_MACHINE, "Software\\Netscape\\Netscape Navigator",
						0, KEY_READ, &hKey1 ) == ERROR_SUCCESS)
	{
		if (::RegQueryValueEx( hKey1, "CurrentVersion", NULL, &dwType,
							   (LPBYTE)arCurrent, &dwCurrentSize ) == ERROR_SUCCESS &&
			(dwType == REG_SZ) &&
			::RegOpenKeyEx( hKey1, strcat( arCurrent, "\\Main" ),
							0, KEY_READ, &hKey2 ) == ERROR_SUCCESS)
		{
			dwCurrentSize = sizeof(arCurrent);
			if (::RegQueryValueEx( hKey2, "Plugins Directory", NULL, &dwType,
								   (LPBYTE)arCurrent, &dwCurrentSize ) == ERROR_SUCCESS &&
				(dwType == REG_SZ))
			{
				strcpy( buf, arCurrent );
			}
			::RegCloseKey( hKey2 );
		}
		::RegCloseKey( hKey1 );
	}
}

void WinOS::getNS6PluginDir(char* buf)
{
	HKEY hKey1, hKey2;
	TCHAR arCurrent[MAX_PATH];
	DWORD dwType, dwCurrentSize = sizeof(arCurrent);

	if (::RegOpenKeyEx( HKEY_LOCAL_MACHINE, "Software\\Netscape\\Netscape 6",
						0, KEY_READ, &hKey1 ) == ERROR_SUCCESS)
	{
		if (::RegQueryValueEx( hKey1, "CurrentVersion", NULL, &dwType,
							   (LPBYTE)arCurrent, &dwCurrentSize ) == ERROR_SUCCESS &&
			(dwType == REG_SZ) &&
			::RegOpenKeyEx( hKey1, strcat( arCurrent, "\\Main" ),
							0, KEY_READ, &hKey2 ) == ERROR_SUCCESS)
		{
			dwCurrentSize = sizeof(arCurrent);
			if (::RegQueryValueEx( hKey2, "Install Directory", NULL, &dwType,
								   (LPBYTE)arCurrent, &dwCurrentSize ) == ERROR_SUCCESS &&
				(dwType == REG_SZ))
			{
				strcpy( buf, arCurrent );
				if( strlen(buf) && buf[strlen(buf)-1]!='\\')
					strcat( buf, "\\" );
				strcat( buf, "Plugins" );
			}
			::RegCloseKey( hKey2 );
		}
		::RegCloseKey( hKey1 );
	}
}

#define _CSIDL_PROGRAM_FILES			0x26
//#define _CSIDL_PROGRAM_FILES_COMMON		0x2b

void WinOS::getUserProgramFilesFolder(char* buf)
{
	if( !__SHGetSpecialFolder(_CSIDL_PROGRAM_FILES, buf) )
	{
		HKEY hKey1;
		TCHAR arCurrent[MAX_PATH];
		DWORD dwType, dwCurrentSize = sizeof(arCurrent);
	
		if (::RegOpenKeyEx( HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion",
							0, KEY_READ, &hKey1 ) == ERROR_SUCCESS)
		{
			if (::RegQueryValueEx( hKey1, "ProgramFilesDir", NULL, &dwType,
								   (LPBYTE)arCurrent, &dwCurrentSize ) == ERROR_SUCCESS &&
				(dwType == REG_SZ) )
			{
				strcpy( buf, arCurrent );
			}
			::RegCloseKey( hKey1 );
		}
	}
}

// ============================================================================
// ============================================================================
// ============================================================================

void _createLNKFile( char* source, char* destination, char* path, char* description, char* param )
{
	HRESULT		hres;
	IShellLink*	psl;
	CLSID		clsid_ShellLink = CLSID_ShellLink;
	CLSID		clsid_IShellLink = IID_IShellLink;

	hres = CoCreateInstance( clsid_ShellLink, NULL, CLSCTX_INPROC_SERVER,
							 clsid_IShellLink, (void**)&psl );
	if( FAILED(hres) )
		hres = SHCoCreateInstance( NULL, clsid_ShellLink, NULL, clsid_IShellLink, (void**)&psl );

	if( SUCCEEDED(hres) )
	{
		IPersistFile* ppf;
		psl->SetPath( source );
		psl->SetWorkingDirectory( path );
		psl->SetDescription( description );
		if( param && strlen(param) )
			psl->SetArguments( param );

		CLSID clsid_IPersistFile = IID_IPersistFile;
		hres = psl->QueryInterface( clsid_IPersistFile, (void**)&ppf );

		if( SUCCEEDED(hres) )
		{
			WORD wsz[MAX_PATH];
			MultiByteToWideChar( CP_ACP, 0, destination, -1, wsz, MAX_PATH );
			hres = ppf->Save( wsz, TRUE );
			ppf->Release();
		}
		psl->Release();
	}
}

void WinOS::createShortcut(char* source, char* destination, char* path, char* description, char* parameters)
{
	char cbuf[512];
	strcpy( cbuf, destination );
	strcat( cbuf, ".lnk" );

	_createLNKFile( source, cbuf, path, description, parameters );
}

void WinOS::createProgramFolder( char* name, BOOL user )
{
	char buf[MAX_PATH];
	if( user )
		_SHGetSpecialFolder(CSIDL_PROGRAMS, buf);
	else
		_SHGetSpecialFolder(CSIDL_COMMON_PROGRAMS, buf);
	strcat( buf, "\\" );
	strcat( buf, name );

	makeDir( buf, 0 );
}

void WinOS::createProgramFolderItem( char* foldername, char* itemname,
	char* destpath, char* destexec, char* param, BOOL user )
{
	char lnkFile[MAX_PATH];
	if( user )
		_SHGetSpecialFolder(CSIDL_PROGRAMS, lnkFile);
	else
		_SHGetSpecialFolder(CSIDL_COMMON_PROGRAMS, lnkFile);
	strcat( lnkFile, "\\" );
	strcat( lnkFile, foldername );
	strcat( lnkFile, "\\" );
	strcat( lnkFile, itemname );
	strcat( lnkFile, ".lnk" );

	char absFile[MAX_PATH];
	strcpy( absFile, destpath );
	strcat( absFile, "\\" );
	strcat( absFile, destexec );

	_createLNKFile( absFile, lnkFile, destpath, "", param );
}

void WinOS::removeProgramFolder(char* name, BOOL user)
{
	char buf[MAX_PATH];
	if( user )
		_SHGetSpecialFolder(CSIDL_PROGRAMS, buf);
	else
		_SHGetSpecialFolder(CSIDL_COMMON_PROGRAMS, buf);
	strcat( buf, "\\" );
	strcat( buf, name );

	removeDir( buf );
}

void WinOS::removeProgramFolderItem(char* foldername, char* itemname, BOOL user )
{
	char lnkFile[MAX_PATH];
	if( user )
		_SHGetSpecialFolder(CSIDL_PROGRAMS, lnkFile);
	else
		_SHGetSpecialFolder(CSIDL_COMMON_PROGRAMS, lnkFile);
	strcat( lnkFile, "\\" );
	strcat( lnkFile, foldername );
	strcat( lnkFile, "\\" );
	strcat( lnkFile, itemname );
	strcat( lnkFile, ".lnk" );

	unlink( lnkFile );
}

// ============================================================================
// ============================================================================
// ============================================================================

HKEY StringToHKEY( char* key )
{
	if( strcmp(key, "HKEY_CLASSES_ROOT") == 0 )
		return HKEY_CLASSES_ROOT;
	else if( strcmp(key, "HKEY_CURRENT_USER") == 0 )
		return HKEY_CURRENT_USER;
	else if( strcmp(key, "HKEY_LOCAL_MACHINE") == 0 )
		return HKEY_LOCAL_MACHINE;
	else if( strcmp(key, "HKEY_USERS") == 0 )
		return HKEY_USERS;
	else
		return HKEY_CLASSES_ROOT;
}

DWORD HexStringToDWORD( char* value )
{
	DWORD lValue = 0;
	int nLen = strlen( value );
	for( unsigned short i = 0; i < nLen; i++ )
	{
		char aDigit = toupper( value[i] );
		if( aDigit >= '0' && aDigit <= '9' )
			lValue += aDigit - '0';
		else
		{
			if( aDigit >= 'A' && aDigit <= 'F' )
				lValue += 10 + (aDigit-'A');
			else
				return 0;
		}
		if( i < nLen - 1 )
			lValue *= 16;
	}
	return lValue;
}

void WinOS::winRegistry( char* key, char* subkey, char* name, char* value,
		BOOL create, BOOL hex, BOOL deleteall, BOOL expand, BOOL bKeyOnly )
{
	if( create )
	{
		HKEY hNewKey;
		HKEY hMainKey = StringToHKEY(key);
		LONG nErr	  = RegCreateKey(hMainKey, subkey, &hNewKey );

		if( nErr == ERROR_SUCCESS )
		{
			if( strlen(name) )
			{
				DWORD lHex = hex ? HexStringToDWORD(value) : 0;

				nErr = RegSetValueEx( hNewKey, name, 0,
							hex ? REG_DWORD	: expand? REG_EXPAND_SZ : REG_SZ,
							hex ? (LPBYTE)& lHex : (LPBYTE)value,
							hex ? sizeof lHex : strlen(value) + 1 );
			}
			else if( strlen(value) )
			{
				nErr = RegSetValueEx( hNewKey, 0, 0, expand? REG_EXPAND_SZ : REG_SZ,
							(LPBYTE)value, strlen(value) + 1 );
			}
		}
	}
	else
	{
		if( strlen(subkey) )
			return;

		HKEY hMainKey = StringToHKEY( key );
		BOOL bKeyOnly = strlen(value) == 0 ? TRUE : FALSE;

		if( !bKeyOnly && !deleteall )
 		{
			HKEY hKey;
			LONG lErr = RegOpenKeyEx( hMainKey, subkey, 0, KEY_ALL_ACCESS, &hKey );

			if( lErr != ERROR_SUCCESS )
				return;

			lErr = RegDeleteValue( hKey, name );
			RegCloseKey(hKey);
			return;
		}
		else
		{
			HKEY hKey;
			LONG lErr = RegOpenKeyEx( hMainKey, subkey, 0, KEY_QUERY_VALUE | KEY_ENUMERATE_SUB_KEYS, &hKey );

			if( lErr != ERROR_SUCCESS )
				return;

			DWORD	 dwDummy = 0;
			char	 szDummy[10];
			FILETIME ftDummy;

			DWORD	 dwSubKeys = 0;
			DWORD	 dwValues = 0;

			lErr = RegQueryInfoKey( hKey, szDummy, &dwDummy, NULL, &dwSubKeys, &dwDummy, &dwDummy,
						&dwValues, &dwDummy, &dwDummy, &dwDummy, &ftDummy );

			if( lErr != ERROR_SUCCESS )
			{
				RegCloseKey( hKey );
				return;
			}

			if( dwSubKeys == 0 && dwValues == 0 )
			{
				RegCloseKey( hKey );
				RegDeleteKey( hMainKey, subkey );
				return;
			}
			else if( deleteall )
			{
				LONG lErr = ERROR_SUCCESS;

				char tmpSubKey[16*1024];
				for (DWORD i=0; i<dwSubKeys && lErr == ERROR_SUCCESS; i++)
				{
					char szSubKey[50];
					DWORD dwSubKey = sizeof szSubKey;
					FILETIME ftLastWrite;

					memset( szSubKey, 0, dwSubKey );

					lErr = RegEnumKeyEx( hKey, 0, szSubKey, &dwSubKey, NULL, NULL, NULL, &ftLastWrite );
					if( lErr == ERROR_SUCCESS )
					{
						memset( tmpSubKey, 0, 16*1024 );
						strcpy( tmpSubKey, subkey );
						strcat( tmpSubKey, "\\" );
						strcat( tmpSubKey, szSubKey );

						winRegistry( key, tmpSubKey, name, value, create, hex, deleteall, expand, bKeyOnly );
					}
				}

				RegCloseKey( hKey );
				if( lErr == ERROR_SUCCESS )
				{
					RegDeleteKey( hMainKey, subkey );
					return ;
				}
				else
					return;
			}
		}
	}
}

void WinOS::registerActiveX(char* path, BOOL bregister)
{
	if(FAILED(OleInitialize(NULL)))
		return; //@todo?: report error
	HINSTANCE hModule = LoadLibrary((LPCTSTR)path);
	if( !(hModule <= (HINSTANCE)HINSTANCE_ERROR) )
	{
		FARPROC lpfnDLLProc = GetProcAddress(hModule, bregister
								? "DllRegisterServer" : "DllUnregisterServer");
		if(lpfnDLLProc!=NULL)
			(*lpfnDLLProc)();
		//@todo?: else report error
		FreeLibrary(hModule);
	}
	//@todo?: else report error
	OleUninitialize();
}

// ============================================================================
// ============================================================================
// ============================================================================

BOOL _isNTWindows()
{
	WORD  nGUIVersion = (WORD) GetVersion();
	USHORT nVer = ((((USHORT)LOBYTE(nGUIVersion))*100)+HIBYTE(nGUIVersion));
	BOOL bRet = FALSE;

	if( nVer == 351 )
	{
		return TRUE;
	}
	if( nVer == 400 || nVer == 395 )    // win95 || w16 unter win95
		bRet = FALSE;
	else
	if( nVer == 410 ) //win98
		bRet = FALSE;

#ifdef WNT
	OSVERSIONINFO aVerInfo;
	aVerInfo.dwOSVersionInfoSize = sizeof( aVerInfo );
	if ( GetVersionEx( &aVerInfo ) )
	{
		if ( aVerInfo.dwPlatformId == VER_PLATFORM_WIN32_NT )
			if( aVerInfo.dwBuildNumber >= 1382 )
				bRet = TRUE;
			else
				bRet = TRUE;
	}
#endif
	return bRet;
}

void WinOS::addFont(char* fontfile, char* fontname)
{
	char TTF_File[16*1024];
	getOSsystemFontDir( TTF_File );

	strcat( TTF_File, "\\" );
	strcat( TTF_File, fontfile );

	if( !AddFontResource(TTF_File) )
		return ;

	char regFontname[16*1024];
	strcpy( regFontname, fontname );
	strcat( regFontname, " (TrueType)" );

	strupr( fontfile );

	if( _isNTWindows() )
		winRegistry( "HKEY_LOCAL_MACHINE", "Software\\Microsoft\\Windows NT\\CurrentVersion\\Fonts\\",
			regFontname, fontfile, TRUE, FALSE, FALSE, FALSE );
	else
		winRegistry( "HKEY_LOCAL_MACHINE", "Software\\Microsoft\\Windows\\CurrentVersion\\Fonts\\",
			regFontname, fontfile, TRUE, FALSE, FALSE, FALSE );

	::PostMessage( HWND_BROADCAST, WM_FONTCHANGE, 0, 0 );
}

void WinOS::removeFont(char* fontfile, char* fontname)
{
	char TTF_File[16*1024];
	getOSsystemFontDir( TTF_File );

	strcat( TTF_File, "\\" );
	strcat( TTF_File, fontfile );

	RemoveFontResource( TTF_File );
	::PostMessage( HWND_BROADCAST, WM_FONTCHANGE, 0, 0 );

	chmod( TTF_File, _S_IREAD | _S_IWRITE );
	unlink( TTF_File );
}

// ============================================================================
// ============================================================================
// ============================================================================

BOOL WinOS::deleteFile( char* path, char* pattern, BOOL testdate,
						int hour, int min, int sec, int day, int month, int year )
{
	char buf[16*1024];
	strcpy( buf, path );
	if( buf[strlen(buf)-1] != '\\' )
		strcat( buf, "\\" );
	strcat( buf, pattern );

	WIN32_FIND_DATA wfData;
	HANDLE hfnd = FindFirstFile( buf, &wfData );
	int nNextFile = 1;

	while( hfnd != INVALID_HANDLE_VALUE && nNextFile != 0 )
	{
		char delfile[16*1024];
		strcpy( delfile, path );
		if( delfile[strlen(delfile)-1] != '\\' )
			strcat( delfile, "\\" );
		strcat( delfile, wfData.cFileName );

		BOOL deletefile = TRUE;
		if( testdate )
		{
			SYSTEMTIME systm;
			FILETIME ftm;

			systm.wYear			= year;
			systm.wMonth		= month;
			systm.wDayOfWeek	= 0;
			systm.wDay			= day;
			systm.wHour			= hour;
			systm.wMinute		= min;
			systm.wSecond		= sec;
			systm.wMilliseconds	= 0;

			if( SystemTimeToFileTime(&systm, &ftm) )
			{
				FILETIME localftm;
				LocalFileTimeToFileTime( &ftm, &localftm );

				if( wfData.ftLastWriteTime.dwLowDateTime != localftm.dwLowDateTime ||
					wfData.ftLastWriteTime.dwHighDateTime != localftm.dwHighDateTime )
					deletefile = FALSE;
			}
			else
				deletefile = FALSE;
		}

		if( deletefile )
		{
			chmod( delfile, _S_IREAD | _S_IWRITE );
			if( unlink(delfile) == -1 )
			{
				{	//try to move the file

					//create a filename to move to
					char moveFileName[16*1024];
					strcpy( moveFileName, delfile );
					
					char* pFoundSlash = strrchr( moveFileName, '\\');
					if( pFoundSlash != 0 )
					{
						char* pPureFileName = strrchr( delfile, '\\');
						if(pPureFileName)
							pPureFileName+=1;
						BOOL bFileExists = TRUE;

						//add one ore more underscores before the filename
						//it is important to change the filename at the start
						//-> the IE does not detect the file as a plugin anymore
						while( bFileExists )
						{
							pFoundSlash++;
							*(pFoundSlash) = '_';
							strcpy( pFoundSlash+1, pPureFileName );

							//check wether the new file exists
							FILE* pFileExists = fopen( moveFileName, "r" );
							if( pFileExists!=0 )
								fclose( pFileExists );
							else
								bFileExists = FALSE;
						}
						
						//try to move the file now
						if( MoveFile( delfile, moveFileName ) )
							strcpy( delfile, moveFileName );
					}
				}
				nLastError = RETURN_ERROR_REBOOT_DELFILE;
				addToCleanupAfterRebootList( delfile, "NUL" );
			}
		}
		nNextFile = FindNextFile( hfnd, &wfData );
	}

	FindClose( hfnd );
	return TRUE;
}

void WinOS::moveFileAfterReboot(char* source, char* destination)
{
	//this will not be done via the windows system tools ("MoveFileEx", "wininit.ini"),
	//because that mechanism does not work on old windows (95/98) with files wich are named longer than 8.3 on old windows
	//and furthermore double keys are overwritten, so you can not have a list with two equal targets
	
	nLastError = RETURN_ERROR_REBOOT_MOVELFILE;
	addToCleanupAfterRebootList( source, destination );
}

BOOL WinOS::copyFile(char* source, char* destination)
{
	chmod( destination, _S_IREAD | _S_IWRITE );
	CopyFile( source, destination, FALSE );
	return TRUE;
}

BOOL WinOS::unzipFile(char* source, char* pattern, char* destination)
{
/* 	_chdrive( toupper(destination[0]) - 'A' + 1 );
 	chdir( destination );
	::SVUnzip( source, pattern, (const char*)"qq", NULL );
*/
	return TRUE;
}

void WinOS::getDriveList(char* buf)
{
	BOOL bFirst = TRUE;
	for( int drive = 1; drive <= 26; drive++ )
	{
		char c = drive + 'A' - 1;
		if( c != 'A' && c != 'B' && !_chdrive(drive) )
		{
			if( !bFirst ) strcat( buf, "," ); else bFirst = FALSE;
			char drivebuf[10];
			sprintf( drivebuf, "%c", c );
			strcat( buf, drivebuf );
		}
	}
}

/*
void WinOS::getShortPath(char* path )
{
	//this method shortens the given path to 8.3 convention

	//this is necessary because the 'setProfileString'-method or rather the wininit.exe
	//is not able to write files named longer than 8.3
	
	TCHAR arShort[MAX_PATH];
	DWORD dwBufferSize = sizeof(arShort);
	DWORD dwNeededSize = GetShortPathName(path,arShort,dwBufferSize);
	if(dwNeededSize==0)//error
		return;
	if(dwNeededSize<=dwBufferSize)
		strcpy(path,arShort);
}
*/

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

#define TODOFILE_CLEANUPAFTERREBOOT "\\cleanup.ini"

void WinOS::prepareCleanupAfterReboot( char* sourceLocationOfExecuteable, char* destinationWorkingDirectory )
{
	//assign the todofile
	if( m_cCleanupAfterRebootFile == 0)
		m_cCleanupAfterRebootFile = (char*) malloc(strlen(destinationWorkingDirectory)+strlen(TODOFILE_CLEANUPAFTERREBOOT)+1 );
	strcpy( m_cCleanupAfterRebootFile, destinationWorkingDirectory );
	strcat( m_cCleanupAfterRebootFile, TODOFILE_CLEANUPAFTERREBOOT );
	
	//create destination directory
	mkdir(destinationWorkingDirectory);
	
	//assign executeable and copy it to the working directory
	char cExe[MAX_PATH];
	strcpy( cExe, destinationWorkingDirectory);
	strcat( cExe, "\\jsetup.exe" );
	copyFile(sourceLocationOfExecuteable, cExe);
	
	//check wether todofile already exists, if so there should exist already a link in the autostart directory
	FILE* pTodo = fopen( m_cCleanupAfterRebootFile,"r" );
	if(pTodo)
	{
		fclose(pTodo);
		return;
	}
	
	//create shortcut in the autostart directory
	
	//get autostart directory
	char cAutostart[MAX_PATH];
	getAutoStart( cAutostart );
	
	strcat( cAutostart, "\\cleanup.lnk" ); //location + half of the name for the new link
	
	//make sure to use a non existent link in the autostart directory:
	FILE* pShortCut = 0;
	while( true )
	{
		pShortCut = fopen( cAutostart, "r" );
		char* ptr = strrchr( cAutostart, '.' );
		if( pShortCut ) //append another underscore
		{
			*ptr = '_';
			strcpy( ptr+1, ".lnk" );
		}
		else //remove ".lnk" from the end of the linkname
		{
			*ptr = 0;
			break;
		}
	}
	
	//write autostartlink as first line into the todofile
	pTodo = fopen( m_cCleanupAfterRebootFile,"a+" );
	if(pTodo)
	{
		fprintf(pTodo,"autostart=%s.lnk\n",cAutostart);
		fclose(pTodo);
	}
	
	//create the shortcut:
	char cParams[MAX_PATH];
	//Params for jsnsative  to cleanup:
	//1. 'cleanup'
	//2. path to file with ToDos
	//3. link to be removed after runing
	strcpy( cParams, "cleanup " );
	strcat( cParams, "\"" );
	strcat( cParams, m_cCleanupAfterRebootFile );
	strcat( cParams, "\"" );
	strcat( cParams, " \"" );
	strcat( cParams, cAutostart );
	strcat( cParams, ".lnk" );
	strcat( cParams, "\"" );
	
	createShortcut(cExe, cAutostart, 0, 0, cParams );
}

void WinOS::removeCleanupAfterRebootPreparation( char* destinationWorkingDirectory )
{
	// within "::prepareCleanupAfterReboot()" there was created a link in the autostart directory, a todo-file
	// and a copy of this executeable.
	// If the todo-file exists and is not empty this method will do nothing, otherwise this method will remove all above listed things.
	
	char* cAutostartLink = NULL;
	
	//read autostartlink from the todofile and check wether it contains any further data
	char* cTodo = (char*) malloc(strlen(destinationWorkingDirectory)+strlen(TODOFILE_CLEANUPAFTERREBOOT)+1 );
	strcpy( cTodo, destinationWorkingDirectory );
	strcat( cTodo, TODOFILE_CLEANUPAFTERREBOOT );
	
	FILE* pFile = fopen(cTodo,"r");
	if(pFile)
	{
		//read autostartlink from the todofile
		cAutostartLink = (char*) malloc(MAX_PATH);
		fgets(cAutostartLink,MAX_PATH,pFile);
		{//check wether the read data is really the autostart link
			char* pP = strstr( cAutostartLink, "autostart=" );
			if( pP &&						//yes, "autostart=" is contained
				((pP-cAutostartLink)==0))  	//yes, "autostart=" is contained at first position
			{
				cAutostartLink += strlen("autostart="); //move the pointer to the start of the link
				pP = strrchr(cAutostartLink,'\n');
				*pP=0;//replace '\n' at end of line with 0
			}
			else
				cAutostartLink = NULL;//@todo?: report error
		}
		
		//check for further data
		char cContent[2];
		if( fgets(cContent,2,pFile)!=NULL && strlen(cContent) )
		{
			fclose(pFile);
			return; //remove nothing here because the cleanupAfterReboot will be needed
		}
		fclose(pFile);
	}
	//delete the files
	unlink(cTodo);
	unlink(cAutostartLink);
	{//remove the copied executeable
		char cExe[MAX_PATH];
		strcpy(cExe, destinationWorkingDirectory);
		strcat(cExe, "\\jsetup.exe" );
		unlink(cExe);
	}
	rmdir(destinationWorkingDirectory);
}

void WinOS::addToCleanupAfterRebootList( char* sourcefile, char* targetfile )
{
	//this will not be done via the windows system tools ("MoveFileEx", "wininit.ini"),
	//because that mechanism does not work on old windows (95/98) with files wich are named longer than 8.3 on old windows
	//and furthermore double keys are overwritten, so you can not have a list with two equal targets
	
	FILE* pToDos = fopen(m_cCleanupAfterRebootFile,"a+");
	if(pToDos)
	{
		fprintf(pToDos,"%s=%s\n", targetfile, sourcefile );
		fclose(pToDos);
	}
}

BOOL WinOS::isFileRegisteredForRemoveAfterReboot( char* filename )
{
	//load file, which contains the todos for this cleanup
	FILE* pToDos = fopen(m_cCleanupAfterRebootFile,"r");
	if(pToDos!=0)
	{
		char* find = (char*) malloc(strlen("NUL=")+strlen(filename)+2 );
		strcpy(find,"NUL=");
		strcat(find,filename);
		strcat(find,"\n");
		char cLine[MAX_PATH];
		while(fgets(cLine,MAX_PATH,pToDos)!=NULL)
		{
			if( strcmp(cLine,find)==0 )
			{
				fclose(pToDos);
				return true;
			}
		}
		fclose(pToDos);
	}
	return false;
}

void WinOS::removeLineFromAfterRebootList( char* find )
{
	//be sure to not having appended '\n' at the end of the given parameter 'find'
				
	//all lines in the todofile which equal 'find' will be set in comment (with ';')
	FILE* pToDos = fopen(m_cCleanupAfterRebootFile,"r+");
	if(pToDos)
	{
		fpos_t oLastLine,oNextLine;
		fgetpos(pToDos,&oLastLine);
		char cLine[MAX_PATH];
		while(fgets(cLine,MAX_PATH,pToDos)!=NULL)
		{
			fgetpos(pToDos,&oNextLine);
			{//remove '\n' from end of line
				char* ptr = strrchr(cLine,'\n');
				*ptr=0;//replace '\n' at end of line with 0
			}
			if(strcmp(cLine,find)==0)
			{
				if( fsetpos(pToDos,&oLastLine) )
				{
					//@todo? report error
					fclose(pToDos);
					return;
				}
				putc(';',pToDos);
				if( fsetpos(pToDos,&oNextLine) )
				{
					//@todo? report error
					fclose(pToDos);
					return;
				}
			}
			fgetpos(pToDos,&oLastLine);
		}
		fclose(pToDos);
	}
}

BOOL WinOS::isStartedForCleanupAfterReboot( int argc, char* argv[] )
{
	//Params for jsnsative to cleanup:
	//1. 'cleanup'
	//2. path to file with ToDos
	//3. link to be removed after successful runing
	static const char* CLEANUP= "cleanup";
	if( argc==4 && (strcmp( argv[1], CLEANUP )==0) )
		return true;
	return false;
}

int WinOS::cleanupAfterReboot( int argc, char* argv[] )
{
	//Params for jsnsative  to cleanup:
	//1. 'cleanup'
	//2. path to file with ToDos
	//3. link to be removed after running

	m_cCleanupAfterRebootFile = argv[2];
	char* cFileToBeRemoved = argv[3];	
	
	chmod( m_cCleanupAfterRebootFile, _S_IREAD | _S_IWRITE );
	chmod( cFileToBeRemoved, _S_IREAD | _S_IWRITE );
	
	//load file, which contains the todos for this cleanup
	FILE* pToDos = fopen(m_cCleanupAfterRebootFile,"r");
	if(pToDos!=0)
	{
		char cLine[MAX_PATH];
		char* cArg1;
		char* cArg2;
		static const char* DELETE_CMD= "NUL";
		while(fgets(cLine,MAX_PATH,pToDos)!=NULL)
		{
			char* ptr = strchr(cLine,'=');
			if(ptr)
			{
				if(ptr==";")//do not execute comments
					continue;
				cArg1=cLine;
				cArg2 = ptr;
				cArg2+=1;
				*ptr=0;//terminate argument1 with 0
				ptr = strrchr( cArg2, '\n');
				*ptr=0;//terminate argument2 with 0
				
				if( strcmp(cArg1,DELETE_CMD)==0 )
				{
					chmod( cArg2, _S_IREAD | _S_IWRITE );
					unlink(cArg2);
				}
				else
				{
					chmod( cArg1, _S_IREAD | _S_IWRITE );
					CopyFile( cArg2, cArg1, FALSE );
					chmod( cArg2, _S_IREAD | _S_IWRITE );
					unlink(cArg2);
				}
			}
		}
		fclose(pToDos);
	}
	unlink(m_cCleanupAfterRebootFile);
	unlink(cFileToBeRemoved);
	return 0;
}
