/*************************************************************************
 *
 *  $RCSfile: macos.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dv $ $Date: 2001/11/15 12:33:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <mac_start.h>
#include <Aliases.h>
#include <AppleEvents.h>
#include <AERegistry.h>
#include <Devices.h>
#include <Errors.h>
#include <Fcntl.h>
#include <Files.h>
#include <Folders.h>
#include <GestaltEqu.h>
#include <Icons.h>
#include <PLByteStringFuncs.h>
#include <Processes.h>
#include <Resources.h>
#include <StdDef.h>
#include <Stdio.h>
#include <StdLib.h>
#include <ByteStrings.h>
#include <ByteString.h>
#include <toolutils.h>

#ifdef MWERKS
	#include <unistd.h>
#endif

#include <mac_end.h>

#include "os.hxx"  		// fuer diese Quelle
#include <tools/solar.h>
#include <vcl/system.hxx>
#include <vcl/msgbox.hxx>
#include <vcl/sysdep.hxx>
#include <tools/debug.hxx>
#include "error.hrc"

// ist in den Tools
extern char *PathNameFromDirID( long DirID, short vRefNum, char *s);

// -----------------------------------------------------------------------

short GetVolType( HParmBlkPtr paramBlock )
{
	DCtlHandle	theDCTL;
	MAC_ByteStringPtr	thePtr;

	theDCTL = GetDCtlEntry( paramBlock->volumeParam.ioVDRefNum );
	if ( (**theDCTL).dCtlFlags & 0x40 )
		thePtr = (MAC_ByteStringPtr) *(Handle)((**theDCTL).dCtlDriver);
	else
		thePtr = (MAC_ByteStringPtr) (**theDCTL).dCtlDriver;
	thePtr += 18;
	char* cpTmp = (char*)thePtr;
	if ( strstr(cpTmp,"Sony") )
		return 1;
	return 0;
}

// -----------------------------------------------------------------------


ByteString GetFolder(OSType aFolderType)
{
	short	vRef;
	long	parID;
	short	aErr;
	Str255	aPath;
	ByteString	aFileName;

	// Wo ist unserer Folder ?
	aErr = FindFolder( kOnSystemDisk, aFolderType,
					   kCreateFolder, &vRef, &parID );

	if (aErr == noErr)
	{
		PathNameFromDirID( parID, vRef, (char*)aPath);
		return ByteString((char*)(aPath + 1), aPath[0]);
	}
	else
		return ByteString();
}


// class OS --------------------------------------------------------------
//
// Hier stehen die Funktionen, die auf allen Plattformen vorhanden sind,
// aber unterschiedlich implementiert werden.

const char* OS::GetAllFilesWildCard()
{
	return "*"; // richtig?
}

ByteString OS::GetGUIPath()
{
	return GetFolder(kPreferencesFolderType);
}

ByteString OS::GetSystemPath()
{
	return GetFolder(kExtensionFolderType);
}

ByteString OS::GetSystemFontPath()
{
	return GetFolder(kFontsFolderType);
}

void OS::SetDateTime
(
	ByteString const& rFilename,
	Date   const& rNewDate,
	Time   const& rNewTime
)
{
	Str255 aFile;

	strncpy( (char*)aFile+1, rFilename.GetBuffer(), 255 );
	aFile[0] = strlen( rFilename.GetBuffer() );

	// init parameter block
	HParamBlockRec aParaBlock;
	memset(&aParaBlock,0,sizeof(HParamBlockRec));
	aParaBlock.fileParam.ioCompletion = 0;  // no completion function
	aParaBlock.fileParam.ioNamePtr = aFile; // file name
	aParaBlock.fileParam.ioVRefNum = 0;     // search with file name
	aParaBlock.fileParam.ioFDirIndex = -1;  // search with file name
	if ( PBHGetFInfoSync( &aParaBlock ) )
		return;

	// convert new date and time in seconds
	DateTimeRec aDTRec;
	aDTRec.year 	= rNewDate.GetYear();
	aDTRec.month 	= rNewDate.GetMonth();
	aDTRec.day   	= rNewDate.GetDay();
	aDTRec.hour 	= rNewTime.GetHour();
	aDTRec.minute 	= rNewTime.GetMin();
	aDTRec.second 	= rNewTime.GetSec();

	switch (rNewDate.GetDayOfWeek())
	{
		case MONDAY:    aDTRec.dayOfWeek = 2; break;
		case TUESDAY:   aDTRec.dayOfWeek = 3; break;
		case WEDNESDAY: aDTRec.dayOfWeek = 4; break;
		case THURSDAY:  aDTRec.dayOfWeek = 5; break;
		case FRIDAY:    aDTRec.dayOfWeek = 6; break;
		case SATURDAY:  aDTRec.dayOfWeek = 7; break;
		case SUNDAY:    aDTRec.dayOfWeek = 1; break;
	}

	ULONG nSeconds = 0;
	DateToSeconds( &aDTRec, &nSeconds );
	aParaBlock.fileParam.ioFlCrDat = nSeconds;
	aParaBlock.fileParam.ioFlMdDat = nSeconds;
	PBHSetFInfoSync( &aParaBlock );
}

// -----------------------------------------------------------------------

ULONG OS::GetDriveSize(SiDirEntry const& rVol)
{
	// a volume name must end with ':'
	ByteString aVolume = rVol.GetFull();
	aVolume.EraseTrailingChars();

	if ( (char)aVolume[ (USHORT)(aVolume.Len()-1) ] != ':' )
		aVolume.Insert( ':' );

	Str255 aVol;
	strncpy( (char*)aVol+1, aVolume.GetBuffer(), 255 );
	aVol[0] = strlen( aVolume.GetBuffer() );

	// init parameter block
	HParamBlockRec aParaBlock;
	memset(&aParaBlock,0,sizeof(HParamBlockRec));
	aParaBlock.volumeParam.ioCompletion = 0; // no completion function
	aParaBlock.volumeParam.ioNamePtr = aVol; // volume name
	aParaBlock.volumeParam.ioVRefNum = 0;  	 // search with volume name
	aParaBlock.volumeParam.ioVolIndex = -1;  // search with volume name

	if ( PBHGetVInfoSync( &aParaBlock ) )
		return 0;

	// return free allocation blocks * allocation block size in bytes
	return (ULONG)((aParaBlock.volumeParam.ioVFrBlk *
					aParaBlock.volumeParam.ioVAlBlkSiz) / 1024 );
}

// -----------------------------------------------------------------------

ULONG OS::GetClusterSize(SiDirEntry const& rVol)
{
	// a volume name must end with ':'
	ByteString aVolume = rVol.GetFull();
	aVolume.EraseTrailingChars();

	if ( (char)aVolume[ (USHORT)(aVolume.Len()-1) ] != ':' )
		aVolume.Insert( ':' );

	Str255 aVol;
	strncpy( (char*)aVol+1, aVolume.GetBuffer(), 255 );
	aVol[0] = strlen( aVolume.GetBuffer() );

	// init parameter block
	HParamBlockRec aParaBlock;
	memset(&aParaBlock,0,sizeof(HParamBlockRec));
	aParaBlock.volumeParam.ioCompletion = 0; // no completion function
	aParaBlock.volumeParam.ioNamePtr = aVol; // volume name
	aParaBlock.volumeParam.ioVRefNum = 0;  	 // search with volume name
	aParaBlock.volumeParam.ioVolIndex = -1;  // search with volume name

	if ( PBHGetVInfoSync( &aParaBlock ) )
		return 4096;

	// return free allocation blocks * allocation block size in bytes
	return aParaBlock.volumeParam.ioVAlBlkSiz;
}

// -----------------------------------------------------------------------

BOOL OS::InstallFont (ByteString const& /*rFontFile*/, ByteString const& /*rFontName*/)
{
	return TRUE;
}

BOOL OS::IsFontInstalled(ByteString const& /*rFontFile*/, ByteString const& rFontName)
{
	SiDirEntry aFontPath( OS::GetSystemFontPath() );
	if( !aFontPath.Exists() )
		return FALSE;

	Dir		aFontDir	( aFontPath, FSYS_KIND_FILE );
	ByteString	aFontName	= rFontName.Lower();
	USHORT	nCnt		= aFontDir.Count();
	BOOL	bInstalled	= FALSE;

	for( USHORT i = 0; i < nCnt; ++i )
	{
		ByteString aSysFontName = aFontDir[i].GetName().Lower();
		if( (bInstalled = aSysFontName == aFontName) == TRUE )
			break;
	}
	return bInstalled;
}

BOOL OS::UnInstallFont (ByteString const& /*rFontFile*/, ByteString const& /*rFontName*/)
{
	return TRUE;
}

BOOL OS::MakeWritable(ByteString const&)
{
	return TRUE;
}

ULONG GetFreeMemory()
{
	long nSize = 0;
	Gestalt( gestaltPhysicalRAMSize, &nSize );
	return (ULONG)( nSize >> 10 );
}

BOOL OS::IsConfigurationValid(Window* pParent)
{
	CPUType aType = System::GetCPUType();
	ByteString aVerStr = System::GetGUIVersion();
	USHORT nGUIVersion = (USHORT)aVerStr * 100;
	nGUIVersion += (USHORT)aVerStr.Erase( aVerStr.Search( "." ) + 1 );

	if ( aType != CPU_M68030  &&
		 aType != CPU_M68040  &&
		 aType != CPU_POWERPC &&
		 aType != CPU_DONTKNOW )
		WarningBox( pParent, WB_OK, ByteString( ResId( ERR_CONFIG_CPU_MAC ) ) ).Execute();

	if ( nGUIVersion < 0 ) //!!!
		WarningBox( pParent, WB_OK, ByteString( ResId( ERR_CONFIG_VER ) ) ).Execute();

	if ( GetFreeMemory() < 6000 )
		WarningBox( pParent, WB_OK, ByteString( ResId( ERR_CONFIG_MEM ) ) ).Execute();

	return TRUE;
}

// -----------------------------------------------------------------------
// Mac only
// -----------------------------------------------------------------------

BOOL RestoreAliases( FSSpec* pSpec )
{
	short nRef = FSpOpenResFile( pSpec, fsRdWrPerm );

	if ( -1 == nRef )
		return FALSE;

	INT16			nCountAlis;
	AliasHandle		hAlias;

	nCountAlis = Count1Resources( 'alis' );

	for ( short i = 1; i <= nCountAlis; i++ )
	{
		hAlias = (AliasHandle)Get1IndResource( 'alis', i );

		if ( hAlias != nil )
		{
			FSSpec			aMyTargetFSSpec;
			MAC_Boolean			nWasChanged;
			OSErr			nAnErr;

			aMyTargetFSSpec.vRefNum	= pSpec->vRefNum;
			aMyTargetFSSpec.parID	= pSpec->parID;
			aMyTargetFSSpec.name[0]	= 1;
			aMyTargetFSSpec.name[1]	= ':';

			nAnErr = ResolveAlias( &aMyTargetFSSpec, hAlias,
								   &aMyTargetFSSpec, &nWasChanged );

			if ( !nAnErr && nWasChanged )
				ChangedResource( (Handle)hAlias );
			ReleaseResource( (Handle)hAlias );
		}
	}
	CloseResFile( nRef );
	return TRUE;
}

const OSType kAEFinderSuit	= 'fndr';
const OSType kAEUpdate		= 'fupd';

BOOL MacOS::AddApplication(ByteString const& rAppName /*, OSType nCreator , OSType IconTypes[]*/)
{
	OSType 			nFinder = 'MACS';
	AEAddressDesc 	aFinderTarget;
	AppleEvent		anUpdateEvent,aReply;
	FSSpec			theSpec;
	OSErr			nErr = FSMakeFSSpec(0,0,rAppName.GetPascalStr(),&theSpec);

	if (nErr != noErr)
		return FALSE;

	// Update Event an Finder schicken, siehe FinderAE-Suite

	AECreateDesc( typeApplSignature, (MAC_Ptr)&nFinder,
					sizeof(OSType), &aFinderTarget );

	AECreateAppleEvent(kAEFinderSuit , kAEUpdate,
					&aFinderTarget, kAutoGenerateReturnID,
					kAnyTransactionID,&anUpdateEvent);

	AEDisposeDesc(&aFinderTarget);

	AEPutParamPtr(&anUpdateEvent, keyDirectObject,typeFSS, &theSpec,sizeof(FSSpec));

	nErr = AESend( &anUpdateEvent, &aReply, kAEWaitReply,kAENormalPriority, kAEDefaultTimeout,
			Sysdepen::GetAEIdleProc(), NULL );

	AEDisposeDesc(&anUpdateEvent);
	AEDisposeDesc(&aReply);

	RestoreAliases( &theSpec );
	return TRUE;
}

// -----------------------------------------------------------------------

OSType ByteStringToOSType(ByteString const& s)
{
	if (s.Len() != 4)
	{
		DBG_ERROR("ByteStringToOSType() wrong length");
		return 0;
	}

	// Packen
	return
		  (OSType(s[0]) << 24)
		+ (OSType(s[1]) << 16)
		+ (OSType(s[2]) <<  8)
		+ (OSType(s[3]))
		;
}

// -----------------------------------------------------------------------

ByteString MacOS::SearchApplication(ByteString Creator /* genau 4 Zeichen */)
{
	ByteString	aFoundAppPath;
	DTPBRec aDTRec;
	Str255  aVolName;
	BOOL    bFound = FALSE;
	OSErr	nErr;

	// init volume parameter block
	HParamBlockRec aParaBlock;
	short nIndex = 1;
	memset(&aParaBlock,0,sizeof(HParamBlockRec));
	aParaBlock.volumeParam.ioVolIndex = nIndex;
	aParaBlock.volumeParam.ioNamePtr = aVolName;

	while(  !bFound &&
			(PBHGetVInfoSync( &aParaBlock ) == noErr))
	{
		nIndex ++;
		aParaBlock.volumeParam.ioVolIndex = nIndex;

		if	((aParaBlock.volumeParam.ioVFSID != 0)	||	// kein lokales HFS_System
			 ((aParaBlock.volumeParam.ioVAtrb & (1 << 7 | 1 << 15)) != 0 )) // gelocked
			continue;

		// init the parameter block
		short  nVRefNum = aParaBlock.volumeParam.ioVRefNum;
		memset( &aDTRec, 0, sizeof(aDTRec) );
		aDTRec.ioVRefNum = aParaBlock.volumeParam.ioVRefNum;
		aDTRec.ioNamePtr = aVolName;

		// open or create desktop database
		nErr = PBDTGetPath( &aDTRec );

		if ( !nErr )
		{
			Str255 aAppName;
			aDTRec.ioNamePtr = aAppName;
			aDTRec.ioIndex = 0;
			aDTRec.ioFileCreator = ByteStringToOSType(Creator);

			// get the application
			nErr = PBDTGetAPPLSync( &aDTRec );

			if ( !nErr )
			{
				FSSpec theSpec;
				nErr = FSMakeFSSpec(nVRefNum,aDTRec.ioAPPLParID,aAppName,&theSpec);
				if (nErr != noErr)	// inkl. fnfnErr !
					continue;	// woanders weitersuchen

				// get trash in this volume
				short nTrashRefNum = 0;
				long  nTrashParID = 0;
				nErr = FindFolder( nVRefNum, 'trsh', kDontCreateFolder,
					&nTrashRefNum, &nTrashParID );

				// filter name (Entwicklung:Trash: -> :Trash:)
				Str255 aTrashName;
				PathNameFromDirID( nTrashParID, nVRefNum, (char*)aTrashName );
				p2cstr( aTrashName );
				*( strrchr( (char*)aTrashName, ':' ) ) = 0;
				char cpTrash[100];
				strcpy( cpTrash, strrchr( (char*)aTrashName, ':' ) );
				strcat( cpTrash, ":" );

				Str255 aPath;
				if ( PathNameFromDirID( aDTRec.ioAPPLParID, nVRefNum, (char*)aPath ) )
				{
					aFoundAppPath = ByteString( (char*) &aPath[1], aPath[0]);
					if ( aFoundAppPath.Search( cpTrash ) == STRING_NOTFOUND )
						bFound = TRUE;
					else
						aFoundAppPath.Erase();
				}
			}
		}
	}

	return aFoundAppPath;
}

// -----------------------------------------------------------------------

BOOL MacOS::RemoveApplication(ByteString const& rAppName, ByteString Creator /* genau 4 Zeichen */)
{
	DTPBRec aDTRec;
	FSSpec	theSpec;
	OSErr	anErr = FSMakeFSSpec(0,0,rAppName.GetPascalStr(),&theSpec);

	if (anErr != noErr && anErr != fnfErr)
		return anErr;

	// init the parameter block
	memset( &aDTRec, 0, sizeof(aDTRec) );
	aDTRec.ioVRefNum  = theSpec.vRefNum;

	// open or create desktop database on the destination volume
	if ( PBDTGetPath( &aDTRec )  )
		return FALSE;

	// init parameter block
	aDTRec.ioCompletion  = 0;
	aDTRec.ioNamePtr 	 = (MAC_ByteStringPtr) rAppName.GetPascalStr();
	aDTRec.ioIndex 		 = 0;
	aDTRec.ioFileCreator = ByteStringToOSType(Creator);

	// get the application from the desktop database
	if ( PBDTGetAPPLSync( &aDTRec ) )
		return FALSE;

	// init parameter block
	short nDTNum = aDTRec.ioDTRefNum;
	memset( &aDTRec, 0, sizeof(aDTRec) );

	aDTRec.ioCompletion  = 0;
	aDTRec.ioNamePtr 	 = (MAC_ByteStringPtr) rAppName.GetPascalStr();
	aDTRec.ioDTRefNum 	 = nDTNum;
	aDTRec.ioDirID 		 = theSpec.parID;
	aDTRec.ioFileCreator = ByteStringToOSType(Creator);

	// remove our application from the desktop database and save this changes
	PBDTRemoveAPPLSync( &aDTRec );
	PBDTFlushSync( &aDTRec );

	return TRUE;
}

// -----------------------------------------------------------------------

BOOL MacOS::IsFloppy(ByteString const& rVol)
{
	Str255  aName;

	// a volume name must end with ':'
	ByteString aVolume(SiDirEntry(rVol).GetVolume());
	aVolume.Insert(':');
	strncpy( (char*)aName+1, aVolume.GetBuffer(), 255 );
	aName[0] = strlen( aVolume.GetBuffer() );

	// get volume reference number
	HParamBlockRec aParaBlock;
	memset(&aParaBlock,0,sizeof(HParamBlockRec));
	aParaBlock.volumeParam.ioCompletion = 0;
	aParaBlock.volumeParam.ioNamePtr = aName;
	aParaBlock.volumeParam.ioVRefNum = 0;
	aParaBlock.volumeParam.ioVolIndex = -1;

	if ( PBHGetVInfoSync( &aParaBlock ) )
		return FALSE;

	if ( GetVolType( &aParaBlock ) )
		return TRUE;

	return FALSE;
}

void MacOS::EjectDisk(ByteString const& rVol)
{
	OSErr 	nErr;
	Str255 	aVolName;

	strncpy( (char*)aVolName+1, rVol, rVol.Len());
	aVolName[0] = rVol.Len();

	// get volume reference number
	HParamBlockRec aParaBlock;
	memset(&aParaBlock,0,sizeof(HParamBlockRec));
	aParaBlock.volumeParam.ioCompletion = 0;
	aParaBlock.volumeParam.ioVolIndex = -1;
	aParaBlock.volumeParam.ioNamePtr = aVolName;
	aParaBlock.volumeParam.ioVRefNum = 0;
	if ( PBHGetVInfoSync( &aParaBlock ) )
		return;
	short nDrvNumber = aParaBlock.volumeParam.ioVDrvInfo;
	nErr = UnmountVol( NULL, nDrvNumber );

	if ( !nErr || nErr == fBsyErr )
		nErr = Eject( NULL, nDrvNumber );
}

void MacOS::Shutdown()
{
	OSErr nErr;
	OSType nFinder = 'MACS';
	AEDesc aFinderTarget;
	AppleEvent aRestartEvt, aReply;
	aFinderTarget.dataHandle = nil;
	aRestartEvt.dataHandle = nil;
	aReply.dataHandle = nil;

	nErr = AECreateDesc( typeApplSignature, (MAC_Ptr)&nFinder,
						 sizeof(OSType), &aFinderTarget );
	if ( nErr != noErr )
		return;

	nErr = AECreateAppleEvent( kAEFinderEvents, kAERestart, &aFinderTarget,
							   kAutoGenerateReturnID, kAnyTransactionID,
							   &aRestartEvt );
	AEDisposeDesc( &aFinderTarget );

	if ( nErr != noErr )
		return;

	nErr = AESend( &aRestartEvt, &aReply,
				   kAENoReply + kAECanSwitchLayer + kAEAlwaysInteract,
				   kAENormalPriority, kAEDefaultTimeout,
				   Sysdepen::GetAEIdleProc(), nil );

	AEDisposeDesc( &aRestartEvt );
	AEDisposeDesc( &aReply );
	return;
}

ByteString MacOS::GetSystemVolumeName()
{
	short 	nDrive = -1; /* first volume */
	Str27 	aVolName;
	short 	nVolRefNum;
	long  	nFreeBytes;
	OSErr 	nErr = GetVInfo( nDrive, aVolName, &nVolRefNum, &nFreeBytes );
	ByteString 	aValume;

	if ( !nErr )
		aValume = p2cstr(aVolName);

	return aValume;
}

BOOL MacOS::IsKeyPressed(int nKey)
{
	KeyMap aKeyMap;
	GetKeys(aKeyMap);

	return BitTst((char*) aKeyMap, nKey) != 0;
}
