/*************************************************************************
 *
 *  $RCSfile: installu.cxx,v $
 *
 *  $Revision: 1.22.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 10:05:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include <com/sun/star/util/DateTime.hpp>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#include "agenda.hxx"
#include "action.hxx"
#include "script.hxx"
#include "environ.hxx"
#include "zipfile.hxx"
#include "sihelp.hxx"
#include "os.hxx"

#include "webaction.hxx"
#include "service.hxx"


///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiFile
//
BOOL SiAgenda::UninstallShortcut( SiFile const* pFile )
{
	const SiShortcutList* pLst = pFile->GetShortcutList();
	if( pLst->Count() )
	{
		for( USHORT i = 0; i < pLst->Count(); ++i )
		{
			SiShortcut* pSCut = pLst->GetObject(i);
			ByteString aSName( pSCut->GetName() );
			if( !m_bWebMode )
			{
				#ifdef WNT
				aSName += ".lnk";
				#endif

				Add( new SiDeleteFileAction(this,
							NULL,
							pSCut->GetDirectory()->GetName(),
							aSName,
							Date(),
							Time(), FALSE), TRUE );
			}
			else
			{
				com::sun::star::util::DateTime aDateTime;

				char cOSDelim = m_pEnv->GetWebOSType() == OSType_WIN? '\\' : '/';

				UniString aPath( UniString(pSCut->GetDirectory()->GetWebName(), osl_getThreadTextEncoding()) );
				aPath.SearchAndReplaceAll( '/',  cOSDelim );
				aPath.SearchAndReplaceAll( '\\', cOSDelim );

				UniString aFilename(aSName, osl_getThreadTextEncoding());
				if( m_pEnv->GetWebOSType() == OSType_WIN )
					aFilename += UniString::CreateFromAscii(".lnk");

				SiWebDeleteFileAction* pNew = new SiWebDeleteFileAction( this,
					aPath, aFilename, FALSE, FALSE, FALSE, aDateTime );
				Add( pNew );
			}
		}
	}

	return TRUE;
}

BOOL SiAgenda::Uninstall(SiFile const* pFile, SiDoneList& aDoneList)
{
	if( m_bWebMode ) return UninstallWeb( pFile, aDoneList );

	if( pFile->IsAgentLoader() || pFile->IsProcessGuard() || pFile->DontInstall() )
		return TRUE;

	if( GetInstallMode() == IM_WORKSTATION	&&
		!pFile->InstallOnWorkstation()		&&
		!pFile->IsFont() )
	{
		UninstallShortcut( pFile );
		return TRUE;
	}

	if( pFile->DontDelete() && InstallLocal() && m_pEnv->GetInstallType() != IT_CHANGE )
		return TRUE;

	if( (m_pEnv->IsUpdateOldVersion() || m_pEnv->IsUpgradeOldVersion()) &&
		(pFile->GetName().CompareIgnoreCaseToAscii("so5dbt.dll") == COMPARE_EQUAL) )
		return TRUE;

	if( aDoneList.Find(pFile->GetID()) != 0 )
		return TRUE;

	aDoneList.Insert(pFile->GetID(), 1);

	ByteString aDestDir	= GetDestDir(pFile);
	if( pFile->IsFont() && InstallLocal() )
	{
		aDestDir = OS::GetSystemFontPath();
		ByteString aFontFilename = pFile->GetName();
		Add( new SiUninstallFontAction(this, pFile->GetFontName(), aFontFilename) );
	}

	if( pFile->GetName().CompareIgnoreCaseToAscii(README_ZIP) == COMPARE_EQUAL )
	{
		Add(new SiDeleteFileAction(this,
			(SiFile*)pFile, aDestDir, pFile->GetName(), pFile->GetDate(), pFile->GetTime(), FALSE) );
	}
	else if( !pFile->IsArchive() )
	{
		if( !pFile->IsFont() || GetInstallMode() == IM_NETWORK )
		{
			if( pFile->IsCompHelpFile() || pFile->IsHelpFile() )
			{
				if( pFile->IsCompHelpFile() )
				{
					if( pFile == NULL )
						return TRUE;

					// vom Setup comp. HilfeDateien
					ByteString aHelpFileName = pFile->GetName();
					aHelpFileName += ".dir";

					Add(new SiDeleteFileAction(this,
							NULL,
							aDestDir,
							aHelpFileName, pFile->GetDate(), pFile->GetTime() ));

					aHelpFileName = pFile->GetName();
					aHelpFileName += ".dat";

					Add(new SiDeleteFileAction(this,
							NULL,
							aDestDir,
							aHelpFileName, pFile->GetDate(), pFile->GetTime() ));
				}
				else
				{
					BOOL bDoDelete = FALSE;
					SiLangCtxList& rCtxDelete = m_pEnv->GetSwitchContextDelete();

					if( m_eInstallSubMode == ISM_CHANGE )
					{
						if( rCtxDelete.Count() )
						{
							for( USHORT xx = 0; xx < rCtxDelete.Count(); ++xx )
							{
								USHORT nFileLang = pFile->GetLanguage() == LANG_DEFAULT?
												   (USHORT)pFile->GetCompiler()->GetCScript()->GetInstallation()->GetDefLanguage().ToInt32() :
												   (USHORT)pFile->GetLanguage();
								if( rCtxDelete.GetObject(xx)->nLanguage == nFileLang ) {
									bDoDelete = TRUE;
									break;
								}
							}
						}
						if( !bDoDelete &&
							!AddHelpFileList((SiFile*)pFile, FALSE) )
							bDoDelete = TRUE;
					}
					else bDoDelete = TRUE;

					if( bDoDelete )
						Add(new SiDeleteFileAction(this, (SiFile*)pFile, aDestDir,
							pFile->GetName(), pFile->GetDate(), pFile->GetTime()));
				}
			}
			else
			{
				BOOL bDontDelete = FALSE;

				if( AddHelpFileList((SiFile*)pFile, FALSE) &&
					m_eInstallSubMode == ISM_CHANGE )
					bDontDelete = TRUE;

				if( !bDontDelete )
				{
					BOOL bTimeCheck	 = TRUE;
					SiDirEntry aEntry( pFile->GetName() );
					if( m_pEnv->GetInstallMode() == IM_PATCH ||
						aEntry.GetExtension().CompareIgnoreCaseToAscii("rdb") == COMPARE_EQUAL )
						bTimeCheck = FALSE;

					Add(new SiDeleteFileAction(this,
							(SiFile*)pFile,
							aDestDir,
							pFile->GetName(),
							pFile->GetDate(),
							pFile->GetTime(), bTimeCheck) );
				}
			}
		}
	}
	else
	{
		char cSysDelim = (char)SiDirEntry::GetAccessDelimiter().GetChar(0);
		for (USHORT i=0; i<pFile->GetSubfileList().Count(); i++)
		{
			ByteString aFile = (pFile->GetSubfileList().GetObject(i))->aFilename;

			// ist es ein leeres Verzeichniss im Archiv?
			if( aFile.Len() &&
				aFile.GetChar(aFile.Len()-1) == cSysDelim ||
				aFile.GetChar(aFile.Len()-1) == '/' )
			{
				SiDirEntry aEntry(aDestDir);
				aEntry += aFile;
				Add( new SiDeleteDirAction(this, aEntry.GetFull()) );
			}
			else
			{
				// von ZIP angelegte Verzeichnisse loeschen
				SiDirEntry aEntry( aFile );
				SiDirEntry aPath( aEntry.GetPath() );
				for( USHORT x = aPath.Level(); x > 0; --x )
				{
					SiDirEntry aDelPath(aDestDir);
					aDelPath += aPath.GetFull();
					Add( new SiDeleteDirAction(this, aDelPath.GetFull()) );
					if( aPath.Level() > 1 )
						aPath = aPath[1];
				}

				BOOL bDontDelete = FALSE;
				if( AddHelpFileList((SiFile*)pFile, FALSE) &&
					m_eInstallSubMode == ISM_CHANGE )
					bDontDelete = TRUE;
				if( !bDontDelete )
					Add(new SiDeleteFileAction(this,
								(SiFile*)pFile,
								aDestDir,
								aFile,
								pFile->GetDate(),
								pFile->GetTime(), TRUE) );
			}
		}
		((SiFile*)pFile)->RemoveAllSubfiles();
	}

	if( pFile->IsActiveX() ) Add( new SiActiveXAction(this, (SiFile*)pFile, FALSE) );

	if( pFile->GetRegistryList()->Count() && m_pEnv->GetInstallType() != IT_CHANGE )
	{
		const SiStarRegistryList* pLst = pFile->GetRegistryList();
		for( USHORT i = 0; i < pLst->Count(); ++i )
		{
			const SiStarRegistry* pReg = pLst->GetObject(i);
			Uninstall( pReg, aDoneList );
		}
	}

	UninstallShortcut( pFile );

	// Mac: Dateien mit Creator abmelden
	if( InstallLocal() && pFile->GetMacCreator().Len() != 0 )
	{
		Add( new SiMacDeleteApplicationAction(this,
					aDestDir,
					pFile->GetName(),
					pFile->GetMacCreator()) );
	}

	// Directories bearbeiten
	SiDirectory* pDir = (SiDirectory*) pFile->GetDirectory();
	while( pDir )
	{
		SiDirectory* pLangRef = (SiDirectory*) pDir->GetLangRef( pFile->GetLanguage() );
		if( pLangRef ) {
			pLangRef->JoinWithParent();
			pDir = pLangRef;
		}
		Uninstall(pDir, aDoneList);
		pDir = pDir->GetParent();
	}

	if( !InstallLocal() )
	{
		if( !Uninstall(pFile->GetNetDirectory(), aDoneList) )
			return FALSE;
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::UninstallWeb( SiFile const* pFile, SiDoneList& aDoneList )
{
	if( m_pEnv->IsInUpdate() && pFile->IsNoUpdate() ) return TRUE;
	if( pFile->DontDelete() ) return TRUE;

	SiDirectory* pDir			= (SiDirectory*) pFile->GetDirectory();
	SiDirectory* pDirLangRef	= (SiDirectory*) pDir->GetLangRef( pFile->GetLanguage() );
	if( pDirLangRef )
		pDirLangRef->JoinWithParent();

	pDir = pDirLangRef? pDirLangRef : pDir;

	UniString aBasePath;
	if( pDir->IsSystemObject() || pDir->IsThisSystem() )
	{
		aBasePath = '<';
		aBasePath += UniString( pDir->GetID(), osl_getThreadTextEncoding() );
		aBasePath += '>';
	}
	else
		aBasePath = UniString( pDir->GetWebName(), osl_getThreadTextEncoding() );

	char cOSDelim = m_pEnv->GetWebOSType() == OSType_WIN? '\\' : '/';
	aBasePath.SearchAndReplaceAll( '/',  cOSDelim );
	aBasePath.SearchAndReplaceAll( '\\', cOSDelim );

	com::sun::star::util::DateTime aDateTime( 0, pFile->GetTime().GetSec(), pFile->GetTime().GetMin(),
		pFile->GetTime().GetHour(), pFile->GetDate().GetDay(), pFile->GetDate().GetMonth(), pFile->GetDate().GetYear() );

	if( !pFile->IsArchive() )
	{
		SiWebDeleteFileAction* pNew = new SiWebDeleteFileAction( this,
			aBasePath,
			UniString(pFile->GetName(), osl_getThreadTextEncoding()),
			pFile->IsUnoComponent(),
			pFile->IsActiveX(),
			m_pEnv->IsTimeCheck(),
			aDateTime );
		Add( pNew );
	}
	else
	{
		const SiSubfileList& rProofLst = pFile->GetSubfileList();
		if( !rProofLst.Count() )
		{
			SiDirEntry aEntry( ((SiWebAgenda*)this)->GetCachedConfig()->aScriptLocation );

			ByteString aSourceStr( ((SiDirEntry&)aEntry.GetPath()).GetFull() );
			#ifdef UNX
			aSourceStr += '/';
			#else
			aSourceStr += '\\';
			#endif
			aSourceStr += pFile->GetPackedName();

			SiZipFile aZipFile;
			aZipFile.AddSubfileListTo( aSourceStr, (SiFile*)pFile, "*" );
		}

		const SiSubfileList& rLst = pFile->GetSubfileList();
		for( USHORT x = 0; x < rLst.Count(); x++ )
		{
			SiSubfile* pSubFile = rLst.GetObject( x );
			UniString  aFilename;
			UniString  aSubBasePath = aBasePath;

			if( pSubFile->aFilename.GetChar(pSubFile->aFilename.Len()-1) == '/' )
			{
				aSubBasePath += UniString( cOSDelim );
				aSubBasePath += UniString( pSubFile->aFilename, osl_getThreadTextEncoding() );

//! fprintf( stderr, "* %s\n", ByteString(aSubBasePath,osl_getThreadTextEncoding()).GetBuffer() );

				SiWebDeleteDirAction* pNew = new SiWebDeleteDirAction( this, aSubBasePath );
				Add( pNew );
				continue;
			}

			USHORT a = pSubFile->aFilename.SearchBackward( '/' );
			if( a != STRING_NOTFOUND )
			{
				UniString aZipPath( UniString(pSubFile->aFilename.Copy(0,a), osl_getThreadTextEncoding()) );
				aSubBasePath += UniString(cOSDelim);
				aSubBasePath += aZipPath;

				aFilename = UniString(pSubFile->aFilename.Copy(a+1), osl_getThreadTextEncoding() );
			}
			else
				aFilename = UniString( pSubFile->aFilename, osl_getThreadTextEncoding() );

			aFilename.SearchAndReplaceAll( '/',  cOSDelim );
			aFilename.SearchAndReplaceAll( '\\', cOSDelim );

//! fprintf( stderr, "> %s\n", ByteString(aSubBasePath,osl_getThreadTextEncoding()).GetBuffer() );
//! fprintf( stderr, "> %s\n\n", ByteString(aFilename,osl_getThreadTextEncoding()).GetBuffer() );

			SiWebDeleteFileAction* pNew = new SiWebDeleteFileAction( this,
				aSubBasePath, aFilename, pFile->IsUnoComponent(), pFile->IsActiveX(),
				m_pEnv->IsTimeCheck(), aDateTime );

			Add( pNew );
		}
	}

	UninstallShortcut( pFile );

	if( pFile->IsUnoComponent() )
	{
		ByteString aFilename = "<PREDEFINED_PROGDIR>";
		aFilename += cOSDelim;
		aFilename += "program";
		aFilename += cOSDelim;
		aFilename += "initialize.ini";

		#ifdef UNX
		aFilename.SearchAndReplaceAll( '/', cOSDelim );
		#else
		aFilename.SearchAndReplaceAll( '\\', cOSDelim );
		#endif

		SiWebProfileItemAction* pNewProf = new SiWebProfileItemAction( this,
				UniString( aFilename, osl_getThreadTextEncoding()),
				UniString::CreateFromAscii("UnoComponents"),
    			UniString( pFile->GetName(), osl_getThreadTextEncoding() ),
				UniString::CreateFromAscii("0"), 0,  // deinstall with no order
				TRUE );
		Add( pNewProf );
	}

	if( pFile->IsFont() )
	{
		SiWebFontAction* pNewFont = new SiWebFontAction( this,
			UniString(pFile->GetName(), osl_getThreadTextEncoding()),
			UniString(pFile->GetFontName(), osl_getThreadTextEncoding()), FALSE );
		Add( pNewFont );
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall( SiFileList const& aFileList, SiDoneList& aDoneList )
{
	for( USHORT x = 0; x < aFileList.Count(); x++ )
	{
		SiFile* pFile = aFileList.GetObject(x);
		if( pFile->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiFile* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pFile;
					else
						pLangRef = (SiFile*) pFile->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						if( !m_bWebMode )
							Uninstall( pLangRef, aDoneList );
						else
							UninstallWeb( pLangRef, aDoneList );

					}
					else
						if( !m_bWebMode )
							Uninstall( pFile, aDoneList );
						else
							UninstallWeb( pFile, aDoneList );
				}
			}
		}
		else
			if( !m_bWebMode )
				Uninstall( pFile, aDoneList );
			else
				UninstallWeb( pFile, aDoneList );
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiDirectory
//

BOOL SiAgenda::Uninstall( SiDirectory const* pDir, SiDoneList &aDoneList )
{
	for( USHORT i = 0; i < pDir->GetSubDirList().Count(); i++ )
		Uninstall( pDir->GetSubDirList().GetObject(i), aDoneList );

	if( m_pEnv->GetInstallType() == IT_CHANGE && pDir->DoCreate() )
		return TRUE;

	if( pDir->IsSystem() || (pDir->GetID().CompareIgnoreCaseToAscii("PREDEFINED_PROGDIR") == COMPARE_EQUAL) )
		return TRUE;

	if( pDir->IsDontDelete() && m_pEnv->GetInstallType() != IT_UNINSTALL )
		return TRUE;

	if( aDoneList.Find(pDir->GetID()) == 0 )
	{
		aDoneList.Insert( pDir->GetID(), 1 );
		if( !m_bWebMode )
			Add( new SiDeleteDirAction(this, pDir->GetName(), pDir->IsDeleteAll()) );
		else
		{
			UniString aPath( pDir->GetWebName(), osl_getThreadTextEncoding() );
			char cOSDelim = m_pEnv->GetWebOSType() == OSType_WIN? '\\' : '/';

			aPath.SearchAndReplaceAll( '/',  cOSDelim );
			aPath.SearchAndReplaceAll( '\\', cOSDelim );

			SiWebDeleteDirAction* pNew = new SiWebDeleteDirAction( this, aPath );
			Add( pNew );
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall( SiDirectoryList const& aDirList, SiDoneList& aDoneList )
{
	for( ULONG x = 0; x < aDirList.Count(); ++x )
//	for( ULONG x = aDirList.Count() - 1; x > 0; x-- )
	{
		SiDirectory* pDir = aDirList.GetObject(aDirList.Count()-x-1);
//		SiDirectory* pDir = aDirList.GetObject(x);
		if( pDir->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiDirectory* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pDir;
					else
						pLangRef = (SiDirectory*) pDir->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Uninstall( pLangRef, aDoneList );
					}
					else
						Uninstall( pDir, aDoneList );
				}
			}
		}
		else
			Uninstall( pDir, aDoneList );
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiProcedure
//

BOOL SiAgenda::Uninstall( const SiProcedure* pProc, SiDoneList& aDoneList, SiCompiledScript &rCS )
{
	if( pProc->RunAtUninstall() &&
		((pProc->RunAtStandalone() && GetInstallMode() == IM_STANDALONE)	||
		 (pProc->RunAtNetwork() && GetInstallMode() == IM_NETWORK)			||
		 (pProc->RunAtWorkstation() && GetInstallMode() == IM_WORKSTATION)) )
	{
		if( aDoneList.Find(pProc->GetID()) == 0 )
		{
			aDoneList.Insert( pProc->GetID(), 1 );
			Add( new SiRunProcedureAction(this, pProc->GetProcName(), pProc->GetCode(), &rCS),
				 pProc->ExecuteBefore() );
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall(SiProcedureList const& aProcList, SiDoneList& aDoneList, SiCompiledScript& rCS)
{
	for (USHORT x = 0; x < aProcList.Count(); x++)
	{
		SiProcedure* pProc = aProcList.GetObject(x);
		if( pProc->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiProcedure* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pProc;
					else
						pLangRef = (SiProcedure*) pProc->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Uninstall( pLangRef, aDoneList, rCS );
					}
					else
						Uninstall( pProc, aDoneList, rCS );
				}
			}
		}
		else
			Uninstall( pProc, aDoneList, rCS );
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiProcedure
//

BOOL SiAgenda::Uninstall( const SiProfile* pProfile, SiDoneList& aDoneList )
{
	if( (GetInstallMode() != IM_NETWORK ||pProfile->InstallOnNetwork()) &&
		!pProfile->DontDelete() )
	{
		if( aDoneList.Find(pProfile->GetID()) == 0 )
		{
			aDoneList.Insert( pProfile->GetID(), 1 );
			Date aDate;
			Time aTime;

			if( !m_bWebMode )
			{
				Add( new SiDeleteFileAction(this,
						NULL,
						pProfile->GetDirectory()->GetName(),
						pProfile->GetName(),
						aDate, aTime) );
				Uninstall( pProfile->GetDirectory(), aDoneList );
			}
			else
			{
				com::sun::star::util::DateTime aDateTime;
				SiWebDeleteFileAction* pNew = new SiWebDeleteFileAction( this,
					UniString(pProfile->GetDirectory()->GetWebName(), osl_getThreadTextEncoding()),
					UniString(pProfile->GetName(), osl_getThreadTextEncoding()),
					FALSE, FALSE, FALSE, aDateTime );
				Add( pNew );
			}
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall( SiProfileList const& aList, SiDoneList& aDoneList )
{
	for( USHORT x = 0; x < aList.Count(); x++ )
	{
		SiProfile* pItem = aList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiProfile* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiProfile*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Uninstall( pLangRef, aDoneList );
					}
					else
						Uninstall( pItem, aDoneList );
				}
			}
		}
		else
			Uninstall( pItem, aDoneList );
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiProfileItem
//

BOOL SiAgenda::Uninstall(const SiProfileItem* pItem, SiDoneList& aDoneList)
{
	if( aDoneList.Find(pItem->GetProfile()->GetID()) == 0 )
	{
		if( GetInstallMode() != IM_NETWORK || pItem->GetProfile()->InstallOnNetwork() )
		{
			if( aDoneList.Find(pItem->GetID()) == 0 && !pItem->DontDelete() )
			{
				aDoneList.Insert(pItem->GetID(), 1);

				if( !m_bWebMode )
				{
					Add(new SiProfileItemAction(this,
								PIA_REMOVE,
								pItem->GetProfile(),
								pItem->GetSection(),
								pItem->GetKey()));
				}
				else
				{
					UniString aFilename;
					if( pItem->GetProfile()->GetDirectory()->IsSystemObject() ||
						pItem->GetProfile()->GetDirectory()->IsThisSystem() )
					{
						aFilename = '<';
						aFilename += UniString( pItem->GetProfile()->GetDirectory()->GetID(), osl_getThreadTextEncoding() );
						aFilename += '>';
					}
					else
						aFilename = UniString( pItem->GetProfile()->GetDirectory()->GetWebName(), osl_getThreadTextEncoding() );

					char cOSDelim = m_pEnv->GetWebOSType() == OSType_WIN? '\\' : '/';

					aFilename.SearchAndReplaceAll( '/',  cOSDelim );
					aFilename.SearchAndReplaceAll( '\\', cOSDelim );

					aFilename += cOSDelim;
					aFilename += UniString( pItem->GetProfile()->GetName(), osl_getThreadTextEncoding() );

					SiWebProfileItemAction* pNew = new SiWebProfileItemAction( this,
						aFilename,
						UniString( pItem->GetSection(), osl_getThreadTextEncoding() ),
   						UniString( pItem->GetKey(), osl_getThreadTextEncoding() ),
   		 				UniString( "", osl_getThreadTextEncoding() ), 0, FALSE );
					Add( pNew );
				}
			}
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall(SiProfileItemList const& aItemList, SiDoneList& aDoneList)
{
	for (USHORT x = 0; x < aItemList.Count(); x++)
	{
		SiProfileItem* pItem = aItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiProfileItem* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiProfileItem*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Uninstall( pLangRef, aDoneList );
					}
					else
						Uninstall( pItem, aDoneList );
				}
			}
		}
		else
			Uninstall( pItem, aDoneList );
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiStarRegistryItem
//

BOOL SiAgenda::Uninstall( const SiStarRegistry* pReg, SiDoneList& aDoneList )
{
	if( aDoneList.Find(pReg->GetID()) )
		return TRUE;
	aDoneList.Insert(pReg->GetID(), 1);

	Add(new SiDeleteFileAction(this, NULL,
		pReg->GetDir()->GetName(), pReg->GetName(), 0, 0, FALSE));
	return TRUE;
}

BOOL SiAgenda::Uninstall(const SiStarRegistryItem* pItem, SiDoneList& aDoneList, SiCompiledScript &rCS)
{
	if( aDoneList.Find(pItem->GetID()) )
		return TRUE;
	aDoneList.Insert(pItem->GetID(), 1);

	if( !pItem->InstallOnNetwork() )
	{
		Uninstall( pItem->GetRegistry(), aDoneList );
		Add(new SiStarRegistryAction(this, PIA_REMOVE, pItem));
	}

	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall(const SiStarRegistryItemList& rRegLst, SiDoneList& aDoneList, SiCompiledScript &rCS)
{
	for( USHORT x = 0; x < rRegLst.Count(); ++x )
	{
		SiStarRegistryItem* pItem = rRegLst.GetObject(x);
		if( pItem->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiStarRegistryItem* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiStarRegistryItem*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Uninstall( pLangRef, aDoneList, rCS );
					}
					else
						Uninstall( pItem, aDoneList, rCS );
				}
			}
		}
		else
			Uninstall( pItem, aDoneList, rCS );
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiFolder
//

BOOL SiAgenda::Uninstall(SiFolder const* pFolder, SiDoneList& aDoneList)
{
	if( pFolder->GetItemCount() > 0 )
		return TRUE;

	if( aDoneList.Find(pFolder->GetID()) == 0 &&
		!pFolder->IsSystemObject() )
	{
		aDoneList.Insert(pFolder->GetID(), 1);

		if( !m_bWebMode )
		{
			Add( new SiDeleteFolderAction(this,
						ByteString(pFolder->GetName(), osl_getThreadTextEncoding()),
						pFolder->GetOs2ID(), (SiFolder*)pFolder) );
		}
		else
		{
			SiWebDeleteFolderAction* pNew = new SiWebDeleteFolderAction( this,
				pFolder->GetName() );
			Add( pNew );
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall(SiFolderItem const* pItem, SiDoneList& aDoneList)
{
	if( aDoneList.Find(pItem->GetID()) == 0 )
	{
		aDoneList.Insert(pItem->GetID(), 1);
		SiFolder* pFolder = pItem->GetFolder();

		if( !m_bWebMode )
		{
			UniString suFolder = pFolder->GetName();
			Add(new SiDeleteFolderItemAction(this,
					suFolder,
					pItem->GetName(),
					pItem->GetOs2ID(), (SiFolderItem*)pItem));
		}
		else
		{
			SiWebDeleteFolderItemAction* pNew = new SiWebDeleteFolderItemAction( this,
				pFolder->GetName(),
				UniString(pItem->GetName(), osl_getThreadTextEncoding()) );
			Add( pNew );
		}
		pFolder->AddItemCount(-1);
		return Uninstall(pItem->GetFolder(), aDoneList);
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall(SiFolderItemList const& aFolderItemList, SiDoneList& aDoneList)
{
	BOOL bSuccess = TRUE;
	for( USHORT x = 0; x < aFolderItemList.Count(); x++ )
	{
		SiFolderItem* pItem = aFolderItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiFolderItem* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiFolderItem*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						if( !Uninstall(pLangRef, aDoneList) )
							bSuccess = FALSE;
					}
					else
					{
						if( !Uninstall(pItem, aDoneList) )
							bSuccess = FALSE;
					}
				}
			}
		}
		else
		{
			if( !Uninstall(pItem, aDoneList) )
				bSuccess = FALSE;
		}
	}

	return bSuccess;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiRegistryItem
//

BOOL SiAgenda::Uninstall(const SiRegistryItem* pItem,
                         SiDoneList& aDoneList)
{
    return Uninstall( pItem, aDoneList, GetAppLanguage() );
}

BOOL SiAgenda::Uninstall(const SiRegistryItem* pItem,
                         SiDoneList& aDoneList,
                         USHORT nLanguage)
{
	if( aDoneList.Find(pItem->GetID()) == 0 )
	{
		aDoneList.Insert(pItem->GetID(), 1);
		if( !pItem->DontDelete() )
		{
			if( !m_bWebMode )
			{
				Add( new SiRegistryItemAction(this,
							RIA_REMOVE,
                            nLanguage,
							pItem->GetKey(),
							pItem->GetSubkey(),
							pItem->GetName(),
							pItem->GetValue(),
							FALSE,
							pItem->DeleteAll()) );
			}
			else
			{
				SiWebWindowsRegistryAction* pNew = new SiWebWindowsRegistryAction( this,
					UniString(pItem->GetKey(), osl_getThreadTextEncoding()),
					UniString(pItem->GetSubkey(), osl_getThreadTextEncoding()),
					UniString(pItem->GetName(), osl_getThreadTextEncoding()),
					UniString(pItem->GetValue(), osl_getThreadTextEncoding()),
					FALSE,
					pItem->IsHexValue(),
					pItem->DeleteAll() );
				Add( pNew );
			}
		}
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall(SiRegistryItemList const& aItemList, SiDoneList& aDoneList)
{
	for( USHORT x = 0; x < aItemList.Count(); x++ )
	{
		SiRegistryItem* pItem = aItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiRegistryItem* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiRegistryItem*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Uninstall(pLangRef, aDoneList, pCtx->nLanguage);
					}
					else
						Uninstall(pItem, aDoneList, GetAppLanguage());
				}
			}
		}
		else
			Uninstall(pItem, aDoneList, GetAppLanguage());
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiRegistryItem
//

BOOL SiAgenda::Uninstall(const SiRegistryArea* pArea, SiDoneList& aDoneList)
{
	if (aDoneList.Find(pArea->GetID()) == 0)
	{
		aDoneList.Insert(pArea->GetID(), 1);
		Add( new SiUnregisterAreaAction(this,
					pArea->GetSubKey(),
					pArea->GetFromKey(),
					pArea->GetToKey()) );
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall(SiRegistryAreaList const& anAreaList, SiDoneList& aDoneList)
{
	for( USHORT x = 0; x < anAreaList.Count(); x++ )
	{
		SiRegistryArea* pArea = anAreaList.GetObject(x);
		if( pArea->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiRegistryArea* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pArea;
					else
						pLangRef = (SiRegistryArea*) pArea->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Uninstall(pLangRef, aDoneList);
					}
					else
						Uninstall(pArea, aDoneList);
				}
			}
		}
		else
			Uninstall(pArea, aDoneList);
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiOs2Class
//

BOOL SiAgenda::Uninstall(const SiOs2Class* pItem, SiDoneList& aDoneList)
{
	if( pItem->GetName().CompareIgnoreCaseToAscii("WPProgram") == COMPARE_EQUAL )
		return TRUE;

	if( aDoneList.Find(pItem->GetID()) == 0 )
	{
		aDoneList.Insert(pItem->GetID(), 1);
		Add( new SiOs2UnregisterClassAction(this,
					pItem->GetName()) );
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall(SiOs2ClassList const& aItemList, SiDoneList& aDoneList)
{
	for( USHORT x = 0; x < aItemList.Count(); x++ )
	{
		SiOs2Class *pItem = aItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiOs2Class* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiOs2Class*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Uninstall(pLangRef, aDoneList);
					}
					else
						Uninstall(pItem, aDoneList);
				}
			}
		}
		else
			Uninstall(pItem, aDoneList);
	}
	return TRUE;
}



///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall SiOs2Template
//

BOOL SiAgenda::Uninstall(class SiOs2Template* pItem, SiDoneList& aDoneList)
{
	if( aDoneList.Find(pItem->GetID()) == 0 )
	{
		aDoneList.Insert(pItem->GetID(), 1);
		Add( new SiOs2DeleteTemplateAction(this, pItem->GetID()) );
	}
	return TRUE;
}

// ----------------------------------------------------------------------------

BOOL SiAgenda::Uninstall(SiOs2TemplateList const& aItemList, SiDoneList& aDoneList)
{
	for( USHORT x = 0; x < aItemList.Count(); x++ )
	{
		SiOs2Template* pItem = aItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiOs2Template* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiOs2Template*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Uninstall(pLangRef, aDoneList);
					}
					else
						Uninstall(pItem, aDoneList);
				}
			}
		}
		else
			Uninstall(pItem, aDoneList);
	}
	return TRUE;
}

BOOL SiAgenda::Uninstall( const SiConfigurationItem* pItem, SiDoneList& aDoneList )
{
    return Uninstall( pItem, aDoneList, GetAppLanguage() );
}

BOOL SiAgenda::Uninstall( const SiConfigurationItem* pItem,
                          SiDoneList& aDoneList,
                          USHORT nLanguage )
{
	if( GetInstallMode() == IM_WORKSTATION && !pItem->IsWorkstation() ||
		m_pEnv->GetInstallType() != IT_CHANGE )
		return TRUE;

	if( aDoneList.Find(pItem->GetID()) == 0 )
	{
		aDoneList.Insert( pItem->GetID(), 1 );
		if( !m_bWebMode )
		{
			Add( new SiConfigurationAction(this, PIA_REMOVE, pItem, nLanguage) );
		}
		else
		{
			; // TODO
		}
	}
	return TRUE;
}

BOOL SiAgenda::Uninstall( const SiConfigurationItemList& aItemList, SiDoneList& aDoneList )
{
	for( USHORT x = 0; x < aItemList.Count(); x++ )
	{
		SiConfigurationItem* pItem = aItemList.GetObject(x);
		if( pItem->HasLangRef() )
		{
			SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				LanguageContext* pCtx = rLst.GetObject(i);
				if( pCtx )
				{
					SiConfigurationItem* pLangRef = NULL;
					if( pCtx->nLanguage == LANG_DEFAULT )
						pLangRef = pItem;
					else
						pLangRef = (SiConfigurationItem*) pItem->GetLangRef( pCtx->nLanguage );

					if( pLangRef )
					{
						pLangRef->JoinWithParent();
						Uninstall(pLangRef, aDoneList, pCtx->nLanguage );
					}
					else
						Uninstall(pItem, aDoneList, GetAppLanguage());
				}
			}
		}
		else
			Uninstall(pItem, aDoneList, GetAppLanguage());
	}
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
//
//		Uninstall
//

BOOL SiAgenda::Uninstall(SiModule const* pModule, SiDoneList& aDoneList, SiCompiledScript& rCS)
{
	//////////////////////////////////////////////////////////////////
	// Das Profile suchen in dem die INSTALL_INFO liegt und ggf.
	// auf DONT_DELETE setzten, damit Schluessel einzeln deinstalliert
	// werden und alte Schluessel nicht verloren gehen!
	for( USHORT i=0; i < pModule->GetProfileItemList().Count(); i++ )
	{
		SiProfileItem* pItem = pModule->GetProfileItemList().GetObject(i);
		if( pItem && pItem->IsInstallInfo() && pItem->GetProfile() )
		{
			((SiProfile*)pItem->GetProfile())->SetDontDelete( TRUE );
			break;
		}
	}

	Uninstall(pModule->GetFileList(), aDoneList);
	Uninstall(pModule->GetDirList(), aDoneList);
	Uninstall(pModule->GetProcedureList(), aDoneList, rCS);

	//////////////////////////////////////////////////////////////////
	// Profiles zuerst loeschen, dann muessen die enthaltenen
	// Items nicht noch separat geloescht werden.
	if( !m_pEnv->IsUpdateOldVersion() && ! m_pEnv->IsUpgradeOldVersion() )
	{
		Uninstall(pModule->GetProfileList(),	 aDoneList);
		Uninstall(pModule->GetProfileItemList(), aDoneList);
	}

	if( !m_pEnv->IsNoRegistration() )
		Uninstall(pModule->GetStarRegistryItemList(), aDoneList, rCS);

	Uninstall(pModule->GetConfigurationItemList(),	aDoneList);

	if( InstallLocal() )
	{
		Uninstall(pModule->GetFolderItemList(),   aDoneList);
		Uninstall(pModule->GetRegistryItemList(), aDoneList);
		Uninstall(pModule->GetRegistryAreaList(), aDoneList);
		Uninstall(pModule->GetOs2ClassList(),     aDoneList);
		Uninstall(pModule->GetOs2TemplateList(),  aDoneList);
	}
	return TRUE;
}

