/*************************************************************************
 *
 *  $RCSfile: sisreg.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "decltor.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "instdb.hxx"

TYPEINIT1(SiStarRegistry,SiDeclarator)
TYPEINIT1(SiStarRegistryItem,SiDeclarator)

///////////////////////////////////////////////////////////////////////////////
//
//		SiStarRegistry
//

SiStarRegistry::SiStarRegistry(SiIdentifier const& ID, SiCompiler *pCompiler) :
	SiDeclarator(ID,pCompiler)
{
	INIT_MULTI_LANG_MEMBER( aName );
	INIT_MULTI_LANG_MEMBER( pDirectory );

	m_pDirectory = NULL;
}

// ----------------------------------------------------------------------------

void SiStarRegistry::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiStarRegistry* pParent = (SiStarRegistry*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( aName );
	JOIN_MULTI_LANG_MEMBER( pDirectory );
}

// ----------------------------------------------------------------------------

BOOL SiStarRegistry::SetProperty(const ByteString& aProperty, const ByteString& aValue)
{
	if( aProperty == PROPERTY_NAME )
	{
		SET_MULTI_LANG_MEMBER( aName, aValue );
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiStarRegistry::SetProperty(const ByteString& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_DIR )
	{
		m_pDirectory = PTR_CAST(SiDirectory,aValue);
		if( m_pDirectory == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a directory";
			Error( aMsg );
			return FALSE;
		}
		m_pDirectory->AddRefCount();
		m_IspDirectory = TRUE;
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiStarRegistry::Check()
{
	BOOL bOk = TRUE;
	bOk = bOk && CheckField(m_aName, PROPERTY_NAME);
	bOk = bOk && CheckField(m_pDirectory, PROPERTY_DIR);

	return bOk? SiDeclarator::Check() : FALSE;
}

// ----------------------------------------------------------------------------

BOOL SiStarRegistry::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("StarRegistry", this);

	// PROPERTY_NAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_NAME, aName );

	// PROPERTY_DIR
	WRITE_MULTI_LANG_MEMBER( PROPERTY_DIR, pDirectory );

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiStarRegistry* pStarReg = (SiStarRegistry*) m_aLangRefs.GetObject(nIdx);
		pStarReg->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiStarRegistry::GetNaturalID() const
{
	ByteString aNatID( m_aName );
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiStarRegistryItem
//


SiStarRegistryItem::SiStarRegistryItem(SiIdentifier const& ID, SiCompiler *pCompiler) :
	SiDeclarator(ID,pCompiler)
{
	INIT_MULTI_LANG_MEMBER( pModule );
	INIT_MULTI_LANG_MEMBER( pRegistry );
	INIT_MULTI_LANG_MEMBER( aKey );

	INIT_MULTI_LANG_MEMBER( aStrValue );
	INIT_MULTI_LANG_MEMBER( aSeqValue );
	INIT_MULTI_LANG_MEMBER( nNumValue );

	INIT_MULTI_LANG_MEMBER( bHasStrValue );
	INIT_MULTI_LANG_MEMBER( bHasSeqValue );
	INIT_MULTI_LANG_MEMBER( bHasNumValue );

	INIT_MULTI_LANG_MEMBER( bNetwork );

	m_pModule		= NULL;
	m_pRegistry		= NULL;
	m_nNumValue 	= 0;
	m_bHasStrValue 	= FALSE;
	m_bHasSeqValue 	= FALSE;
	m_bHasNumValue 	= FALSE;
	m_bNetwork		= FALSE;
}

// ----------------------------------------------------------------------------

void SiStarRegistryItem::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiStarRegistryItem* pParent = (SiStarRegistryItem*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( pModule );
	JOIN_MULTI_LANG_MEMBER( pRegistry );
	JOIN_MULTI_LANG_MEMBER( aKey );

	JOIN_MULTI_LANG_MEMBER( aStrValue );
	JOIN_MULTI_LANG_MEMBER( aSeqValue );
	JOIN_MULTI_LANG_MEMBER( nNumValue );

	JOIN_MULTI_LANG_MEMBER( bHasStrValue );
	JOIN_MULTI_LANG_MEMBER( bHasSeqValue );
	JOIN_MULTI_LANG_MEMBER( bHasNumValue );

	JOIN_MULTI_LANG_MEMBER( bNetwork );
}

// ----------------------------------------------------------------------------

BOOL SiStarRegistryItem::SetProperty(const ByteString& aProperty, long aValue)
{
	if( aProperty == PROPERTY_LONGVALUE )
	{
		SET_MULTI_LANG_MEMBER( nNumValue, aValue );
		SET_MULTI_LANG_MEMBER( bHasNumValue, TRUE );
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiStarRegistryItem::SetProperty(const ByteString& aProperty, const ByteString& aValue)
{
	if( aProperty == PROPERTY_KEY )
	{
		SET_MULTI_LANG_MEMBER( aKey, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_VALUE )
	{
		SET_MULTI_LANG_MEMBER( aStrValue, aValue );
		SET_MULTI_LANG_MEMBER( bHasStrValue, TRUE );
		return TRUE;
	}

	if( aProperty == PROPERTY_SEQ_VALUE )
	{
		SET_MULTI_LANG_MEMBER( aSeqValue, aValue );
		SET_MULTI_LANG_MEMBER( bHasSeqValue, TRUE );
		return TRUE;
	}

	if( aProperty == PROPERTY_FLAGS )
	{
		if( aValue == VALUE_NETWORK )
		{
			SET_MULTI_LANG_MEMBER( bNetwork, TRUE );
			return TRUE;
		}
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiStarRegistryItem::SetProperty(const ByteString& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_MODULEID )
	{
		m_pModule = PTR_CAST(SiModule,aValue);
		if( m_pModule == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a Module";
			Error( aMsg );
			return FALSE;
		}
		m_pModule->Add(this);
		m_IspModule = TRUE;
		return TRUE;
	}
	if( aProperty == PROPERTY_REGISTRYID )
	{
		m_pRegistry = PTR_CAST(SiStarRegistry,aValue);
		if( m_pRegistry == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a StarRegistry";
			Error( aMsg );
			return FALSE;
		}
		m_IspRegistry = TRUE;
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiStarRegistryItem::Check()
{
	BOOL bOk = TRUE;
	bOk = bOk && CheckField(m_pModule, PROPERTY_MODULEID);
	bOk = bOk && CheckField(m_pRegistry, PROPERTY_REGISTRYID);
	bOk = bOk && CheckField(m_aKey, PROPERTY_KEY);

	if( m_aStrValue.Len() && m_bHasNumValue )
	{
		Error("StarRegistryItem declare both a Value and LongValue");
		bOk = FALSE;
	}

	return bOk? SiDeclarator::Check() : FALSE;
}

// ----------------------------------------------------------------------------

BOOL SiStarRegistryItem::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("StarRegistryItem", this);

	// PROPERTY_MODULEID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_MODULEID, pModule );

	// PROPERTY_REGISTRYID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_REGISTRYID, pRegistry );

	// PROPERTY_KEY
	WRITE_MULTI_LANG_MEMBER( PROPERTY_KEY, aKey );

	// PROPERTY_VALUE
	if( m_bHasStrValue )
	{
		WRITE_MULTI_LANG_MEMBER( PROPERTY_VALUE, aStrValue );
	}
	// PROPERTY_SEQ_VALUE
	else if( m_bHasSeqValue )
	{
		WRITE_MULTI_LANG_MEMBER( PROPERTY_SEQ_VALUE, aSeqValue );
	}
	// PROPERTY_LONGVALUE
	else if( m_bHasNumValue )
	{
		WRITE_MULTI_LANG_MEMBER( PROPERTY_LONGVALUE, nNumValue );
	}

	if( m_bNetwork )
	{
		aStream.BeginProperty(PROPERTY_FLAGS, m_nLanguage );
		aStream.BeginList();

		if( m_bNetwork )
			aStream.AddListValue(SiIdentifier(VALUE_NETWORK));

		aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiStarRegistryItem* pStarRegItem = (SiStarRegistryItem*) m_aLangRefs.GetObject(nIdx);
		pStarRegItem->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiStarRegistryItem::GetNaturalID() const
{
	ByteString aNatID = m_pRegistry->GetNaturalID();
	aNatID += NSEP;
	aNatID += m_aKey;
	if( m_bHasNumValue )
	{
		aNatID += NSEP;
		aNatID += m_nNumValue;
	}
	else
	if( m_aStrValue.Len() )
	{
		aNatID += NSEP;
		aNatID += m_aStrValue;
	}

	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

