/*************************************************************************
 *
 *  $RCSfile: siui.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: ok $ $Date: 2001/11/29 15:42:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "decltor.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "instdb.hxx"
#include "sihelp.hxx"

TYPEINIT1(SiSlide,SiDeclarator)
TYPEINIT1(SiHelpText,SiDeclarator)
TYPEINIT1(SiScpAction,SiDeclarator)

///////////////////////////////////////////////////////////////////////////////
//
//		SiSlide
//

SiSlide::SiSlide(SiIdentifier const& ID, SiCompiler *pCompiler) :
	SiDeclarator	( ID, pCompiler ),
	m_aBmpPos		( 0, 0 ),
	m_aTextSize		( 0, 0 ),
	m_nOrder		( 0 )
{
	INIT_MULTI_LANG_MEMBER( nOrder );
	INIT_MULTI_LANG_MEMBER( aText );
	INIT_MULTI_LANG_MEMBER( aTextSize );
	INIT_MULTI_LANG_MEMBER( nFontSize );
	INIT_MULTI_LANG_MEMBER( aBmpFileName );
	INIT_MULTI_LANG_MEMBER( aBmpPos );
	INIT_MULTI_LANG_MEMBER( aWaveFileName );
	INIT_MULTI_LANG_MEMBER( aFadeType );
	INIT_MULTI_LANG_MEMBER( aFadeSpeed );
}

// ----------------------------------------------------------------------------

void SiSlide::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiSlide* pParent = (SiSlide*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( nOrder );
	JOIN_MULTI_LANG_MEMBER( aText );
	JOIN_MULTI_LANG_MEMBER( aTextSize );
	JOIN_MULTI_LANG_MEMBER( nFontSize );
	JOIN_MULTI_LANG_MEMBER( aBmpFileName );
	JOIN_MULTI_LANG_MEMBER( aBmpPos );
	JOIN_MULTI_LANG_MEMBER( aWaveFileName );
	JOIN_MULTI_LANG_MEMBER( aFadeType );
	JOIN_MULTI_LANG_MEMBER( aFadeSpeed );
}

// ----------------------------------------------------------------------------

BOOL SiSlide::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if( aProperty == PROPERTY_TEXT )
	{
		SET_MULTI_LANG_MEMBER( aText, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_BITMAP )
	{
		SET_MULTI_LANG_MEMBER( aBmpFileName, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_WAVE )
	{
		SET_MULTI_LANG_MEMBER( aWaveFileName, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_FADETYPE )
	{
		SET_MULTI_LANG_MEMBER( aFadeType, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_FADESPEED )
	{
		SET_MULTI_LANG_MEMBER( aFadeSpeed, aValue );
		return TRUE;
	}
	return SiDeclarator::SetProperty( aProperty, aValue );
}

// ----------------------------------------------------------------------------

BOOL SiSlide::SetProperty(ByteString const& aProperty, long aValue)
{
	if( aProperty == PROPERTY_ORDER )
	{
		SET_MULTI_LANG_MEMBER( nOrder, (USHORT)aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_TEXTWIDTH )
	{
		m_IsaTextSize = TRUE;
		m_aTextSize.Width() = aValue;
		return TRUE;
	}
	if( aProperty == PROPERTY_TEXTHEIGHT )
	{
		m_IsaTextSize = TRUE;
		m_aTextSize.Height() = aValue;
		return TRUE;
	}
	if( aProperty == PROPERTY_FONTSIZE )
	{
		SET_MULTI_LANG_MEMBER( nFontSize, (USHORT)aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_BMPPOSX )
	{
		m_IsaBmpPos = TRUE;
		m_aBmpPos.X() = aValue;
		return TRUE;
	}
	if( aProperty == PROPERTY_BMPPOSY )
	{
		m_IsaBmpPos = TRUE;
		m_aBmpPos.Y() = aValue;
		return TRUE;
	}
	return SiDeclarator::SetProperty( aProperty, aValue );
}

// ----------------------------------------------------------------------------

BOOL SiSlide::Check()
{
	BOOL bOk = TRUE;
	return bOk ? SiDeclarator::Check() : FALSE;
}

// ----------------------------------------------------------------------------

BOOL SiSlide::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("Slide", this);

	// PROPERTY_ORDER
	WRITE_MULTI_LANG_MEMBER( PROPERTY_ORDER, nOrder );

	// PROPERTY_TEXT
	WRITE_MULTI_LANG_MEMBER( PROPERTY_TEXT, aText );

	// PROPERTY_FONTSIZE
	WRITE_MULTI_LANG_MEMBER( PROPERTY_FONTSIZE, nFontSize );

	// PROPERTY_BITMAP
	WRITE_MULTI_LANG_MEMBER( PROPERTY_BITMAP, aBmpFileName );

	// PROPERTY_WAVE
	WRITE_MULTI_LANG_MEMBER( PROPERTY_WAVE, aWaveFileName );

	// PROPERTY_FADETYPE
	if( m_IsaFadeType )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_FADETYPE, aFadeType );

	// PROPERTY_FADESPEED
	if( m_IsaFadeSpeed )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_FADESPEED, aFadeSpeed );

	if( m_IsaTextSize )
	{
		aStream.WriteProperty( PROPERTY_TEXTWIDTH,		m_aTextSize.Width()		);
		aStream.WriteProperty( PROPERTY_TEXTHEIGHT,		m_aTextSize.Height()	);
	}

	if( m_IsaBmpPos )
	{
		aStream.WriteProperty( PROPERTY_BMPPOSX,		m_aBmpPos.X()	   		);
		aStream.WriteProperty( PROPERTY_BMPPOSY,		m_aBmpPos.Y()	   		);
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiSlide* pSlide = (SiSlide*) m_aLangRefs.GetObject(nIdx);
		pSlide->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiSlide::GetNaturalID() const
{
	ByteString aNatID( GetID() );
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiHelpText
//

SiHelpText::SiHelpText( SiIdentifier const& ID, SiCompiler *pCompiler ) :
	SiDeclarator	( ID, pCompiler ),
	m_nPageId		( 0 )
{
	INIT_MULTI_LANG_MEMBER( aText );
	INIT_MULTI_LANG_MEMBER( nPageId );
}

// ----------------------------------------------------------------------------

void SiHelpText::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiHelpText* pParent = (SiHelpText*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( aText );
	JOIN_MULTI_LANG_MEMBER( nPageId );
}

// ----------------------------------------------------------------------------

BOOL SiHelpText::SetProperty( ByteString const& aProperty, ByteString const& aValue )
{
	if( aProperty == PROPERTY_TEXT )
	{
		SET_MULTI_LANG_MEMBER( aText, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_ID )
	{
		USHORT n = SiHelp::GetUIPageIdByName( aValue );
		if( !n ) return FALSE;

		SET_MULTI_LANG_MEMBER( nPageId, n );
		return TRUE;
	}

	return SiDeclarator::SetProperty( aProperty, aValue );
}

// ----------------------------------------------------------------------------

BOOL SiHelpText::Check()
{
	return SiDeclarator::Check();
}

// ----------------------------------------------------------------------------

BOOL SiHelpText::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration( "HelpText", this );

	// PROPERTY_ID
	BOOL  m_IsaId = TRUE;
	ByteString m_aId = SiHelp::GetUIPageByteStringById(m_nPageId);
	WRITE_MULTI_LANG_MEMBER( PROPERTY_ID, aId );

	// PROPERTY_TEXT
	WRITE_MULTI_LANG_MEMBER( PROPERTY_TEXT, aText );

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiHelpText* pHelp = (SiHelpText*) m_aLangRefs.GetObject(nIdx);
		pHelp->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiHelpText::GetNaturalID() const
{
	ByteString aNatID( GetID() );
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiScpAction
//

SiScpAction::SiScpAction( SiIdentifier const& ID, SiCompiler *pCompiler ) :
	SiDeclarator	( ID, pCompiler )
{
	INIT_MULTI_LANG_MEMBER( aCpySource );
	INIT_MULTI_LANG_MEMBER( aCpyDestination );
	INIT_MULTI_LANG_MEMBER( aFlatLoaderZip );
}

// ----------------------------------------------------------------------------

void SiScpAction::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiScpAction* pParent = (SiScpAction*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( aCpySource );
	JOIN_MULTI_LANG_MEMBER( aCpyDestination );
	JOIN_MULTI_LANG_MEMBER( aFlatLoaderZip );
}

// ----------------------------------------------------------------------------

BOOL SiScpAction::SetProperty( ByteString const& aProperty, ByteString const& aValue )
{
	if( aProperty == PROPERTY_COPY )
	{
		SET_MULTI_LANG_MEMBER( aCpySource, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_NAME )
	{
		SET_MULTI_LANG_MEMBER( aCpyDestination, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_FLATLOADERZIP )
	{
		SET_MULTI_LANG_MEMBER( aFlatLoaderZip, aValue );
		return TRUE;
	}

	return SiDeclarator::SetProperty( aProperty, aValue );
}

// ----------------------------------------------------------------------------

BOOL SiScpAction::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration( "ScpAction", this );

	if( m_IsaCpySource )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_COPY, aCpySource );

	if( m_IsaCpyDestination )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_NAME, aCpyDestination );

	if( m_IsaFlatLoaderZip )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_FLATLOADERZIP, aFlatLoaderZip );

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiScpAction::GetNaturalID() const
{
	ByteString aNatID( GetID() );
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

