/*************************************************************************
 *
 *  $RCSfile: jvmdlg.cxx,v $
 *
 *  $Revision: 1.6.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:47:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



// INCLUDE ---------------------------------------------------------------

#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif

#ifndef _SVT_FILEDLG_HXX //autogen
#include <svtools/filedlg.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#include "environ.hxx"

#pragma hdrstop

#include <vcl/msgbox.hxx>

#include "jvmdlg.hxx"
#include "jvmdlg.hrc"
#include "jvmsetup.hxx"
#include "jvmscan.hxx"
#include "sicustom.hxx"

using namespace rtl;

JVMDialog::JVMDialog (	Window*					pParent,
						ResMgr*					pResMgr,
						SiCustomEnvironment*	pEnv,
						SiCustomModuleList*		pModList,
						ByteString					srcPath,
						ByteString					destPath,
						ByteString					instPackage,
						BOOL					isSetupMode
	):
	ModalDialog			(pParent, 		ResId(DLG_JVM,				pResMgr) ),
	maOK				(this,			ResId(BT_OK,				pResMgr) ),
	maCancel			(this,			ResId(BT_CANCEL,			pResMgr) ),
	maHelp				(this,			ResId(BT_HELP,				pResMgr) ),
	maLine				(this,			ResId(FL_LINE,				pResMgr) ),
	maHelpEdit			(this,			ResId(HELP_EDIT,			pResMgr) ),
	maContainer			(this,			ResId(TAB_WND,				pResMgr) ),
	maInstall			(&maContainer,	ResId(BT_INSTALL,			pResMgr) ),
	maBrowse			(&maContainer,	ResId(BT_BROWSE,			pResMgr) ),
	maInstallNewText	(&maContainer,	ResId(FT_NEW_ENVIRONMENT,	pResMgr) ),
	maRbtUseExisting	(&maContainer,	ResId(RBT_USESELECTED,		pResMgr) ),
	maRbtNoJava			(&maContainer,	ResId(RBT_NOJAVA,			pResMgr) ),
	maJavaVMs			(&maContainer,	ResId(LB_JAVAVMS,			pResMgr) ),
	maQuestion			(&maContainer,	ResId(FT_QUESTION,			pResMgr) ),
	maComment			(&maContainer,	ResId(FT_COMMENT,			pResMgr) ),
	maJavaHomeText		(&maContainer,	ResId(FT_JAVA_HOME,			pResMgr) )

{
	Link aLnk( STATIC_LINK(this, JVMDialog, ImplSelectionChanged ) );
	maRbtUseExisting.SetClickHdl( aLnk );
	maRbtNoJava.SetClickHdl( aLnk );

	maHelp.SetClickHdl( LINK(this, JVMDialog, HelpHdl) );
	maBrowse.SetClickHdl( LINK(this, JVMDialog, BrowseHdl) );
	maCancel.SetClickHdl( LINK(this, JVMDialog, CancelHdl) );
	maOK.SetClickHdl( LINK(this, JVMDialog, OKHdl) );
	maInstall.SetClickHdl( LINK(this, JVMDialog, InstallHdl) );

	maJavaVMs.SetSelectHdl( LINK(this, JVMDialog, SelectHdl) );

	this->pResMgr		= pResMgr;
	this->pParent		= pParent;

	this->pModuleList	= pModList;

	aSourcePath			= srcPath;
	aDestPath			= destPath;
	aInstallPackage		= instPackage;

	bIsSetupMode 		= isSetupMode;

	bAbort = FALSE;

	bHelpMode = FALSE;
	maHelpEdit.Hide();

#if defined (OS2)
	maHelpEdit.SetText( ResId(STR_HELP_TEXT_OS2, pResMgr) );
#elif defined (LINUX)
	maHelpEdit.SetText( ResId(STR_HELP_TEXT_LINUX, pResMgr) );
#elif defined (SOLARIS)
	maHelpEdit.SetText( ResId(STR_HELP_TEXT_SOLARIS, pResMgr) );
#else
	maHelpEdit.SetText( ResId(STR_HELP_TEXT_WIN32, pResMgr) );
#endif

	pCustomEnv = pEnv;

	if ( aJavaInstProps.find(INSTALLATION_PACKAGE) !=  aJavaInstProps.end() )
	{
		UniString javaInstallTxt = UniString( ResId(STR_INSTALL_NEW_ENVIRONMENT, pResMgr) );

		javaInstallTxt.SearchAndReplaceAll(	UniString::CreateFromAscii("%1"),
											UniString::CreateFromAscii(aJavaInstProps[VERSION].GetBuffer()));
		javaInstallTxt.SearchAndReplaceAll(	UniString::CreateFromAscii("%2"),
											UniString::CreateFromAscii(aJavaInstProps[VENDOR].GetBuffer()));

		maInstallNewText.SetText( javaInstallTxt ) ;
	}
	else
	{
		maInstall.Hide();
		maInstallNewText.Hide();

		Size aSize = maJavaVMs.GetSizePixel();
		maJavaVMs.SetSizePixel( Size(aSize.getWidth(), aSize.getHeight() + 26 ) );

		Point aPoint = maJavaHomeText.GetPosPixel();
		maJavaHomeText.SetPosPixel( Point(aPoint.getX(), aPoint.getY() + 26) );
	}

	//if ( ! bIsSetupMode )
	//	InfoBox(this, ResId( DLG_CLOSE_STAROFFICE )).Execute();
}

// -----------------------------------------------------------------------

JVMDialog::~JVMDialog()
{
	FreeResource();
}

void JVMDialog::StateChanged( StateChangedType nStateChange )
{
	ModalDialog::StateChanged( nStateChange );

	//if ( (nStateChange == STATE_CHANGE_VISIBLE) && (! bIsSetupMode) )
	//	InfoBox(this, ResId( DLG_CLOSE_STAROFFICE )).Execute();
}

//------------------------------------------------------------------------
BOOL JVMDialog::isUseExisting()
{
	return maRbtUseExisting.IsChecked();
}

//------------------------------------------------------------------------
BOOL JVMDialog::isNoJava()
{
	return maRbtNoJava.IsChecked();
}

//------------------------------------------------------------------------

void JVMDialog::selectUseExisting( BOOL bEnable )
{
	maRbtUseExisting.Check( bEnable );
}


//------------------------------------------------------------------------

void JVMDialog::selectNoJava( BOOL bEnable )
{
	maRbtNoJava.Check( bEnable );
}


//------------------------------------------------------------------------

BOOL JVMDialog::insertEntry( const UniString& rEntry, ULONG pUserData)
{
	USHORT nPos = maJavaVMs.InsertEntry( rEntry );

	maJavaVMs.SetEntryData( nPos, (void*) pUserData );

	return TRUE;
}

//------------------------------------------------------------------------

void JVMDialog::clearList()
{
	maJavaVMs.Clear();
}

//------------------------------------------------------------------------

BOOL JVMDialog::getSelectedEntry( ULONG &nUserData )
{
	USHORT nPos = maJavaVMs.GetSelectEntryPos ();
	if( maJavaVMs.IsEntryPosSelected( nPos ) )
	{
		nUserData = (ULONG) maJavaVMs.GetEntryData( nPos );

		return TRUE;
	}

	return FALSE;
}

//------------------------------------------------------------------------

void JVMDialog::selectEntry( USHORT nPos )
{
	maJavaVMs.SelectEntryPos( nPos , TRUE );
}

//------------------------------------------------------------------------

USHORT JVMDialog::getEntryCount()
{
	return maJavaVMs.GetEntryCount();
}

//------------------------------------------------------------------------

void JVMDialog::enableListBox( BOOL bEnable )
{
	maJavaVMs.Enable( bEnable );
}

//------------------------------------------------------------------------
void JVMDialog::enableInstallBtn( BOOL bEnable )
{
	maInstall.Enable( bEnable );
}

//------------------------------------------------------------------------

void JVMDialog::enableUseExistingRbt( BOOL bEnable )
{
	maRbtUseExisting.Enable( bEnable ) ;
	maJavaVMs.Enable( bEnable );
}

//------------------------------------------------------------------------

void JVMDialog::setCommentText( UniString const& _sComment )
{
	maComment.SetText( _sComment );
}

//------------------------------------------------------------------------

void JVMDialog::update(USHORT nCount, USHORT nSelect, const JVMEntry* pEntryList )
{
	maJavaVMs.Clear();
	for (USHORT i=0; i<nCount; i++)
	{
		UniString aListEntry = UniString::CreateFromAscii( pEntryList[i].mName.GetBuffer() );
		aListEntry += UniString::CreateFromAscii(" (");
		aListEntry += UniString( ResId( STR_JVM_VERSION, pResMgr ) );
		aListEntry += UniString::CreateFromAscii(" ");
		aListEntry += UniString::CreateFromAscii( pEntryList[i].mVersion.GetBuffer() );

/*		if ( pEntryList[i].bIsVerified )
		{
			aListEntry += UniString::CreateFromAscii(", ");
			aListEntry += UniString( ResId( STR_JVM_VALID_VERIFIED, pResMgr ) );
		}
*/
		aListEntry += UniString::CreateFromAscii(")");
		aListEntry.EraseAllChars( '"' );
		insertEntry( aListEntry.GetBuffer(), i+1 );
	}

	if( nCount )
	{
		selectEntry( nSelect );
		selectUseExisting( TRUE );
		enableUseExistingRbt( TRUE );
		setCommentText( UniString( ResId( STR_ONE_OR_MORE_JVM_FOUND, pResMgr ) ) );
		updateJavaHomeComment();
	}
	else
	{
		// GetJavaVMEntryCount() == 0 -> Kopieren
		insertEntry( ResId( STR_NO_JAVA_ENTRIES, pResMgr ), 1 );
		selectUseExisting( FALSE );
		selectNoJava( TRUE );
		enableUseExistingRbt( FALSE );
		setCommentText( UniString(ResId( STR_NO_JVM_FOUND, pResMgr )) );
		maJavaHomeText.SetText(UniString::CreateFromAscii(""));
	}
}


void JVMDialog::updateJavaHomeComment()
{
	UniString javaHome = UniString::CreateFromAscii("Java Home = ");

	const JVMEntry* pEntry = GetEntry( maJavaVMs.GetSelectEntryPos() );

	if ( pEntry )
	{
		javaHome += UniString( ByteString(pEntry->mHome), osl_getThreadTextEncoding() );

		maJavaHomeText.SetText( javaHome );
	}
	else
	   maJavaHomeText.SetText( UniString::CreateFromAscii("") );
}


//------------------------------------------------------------------------

IMPL_STATIC_LINK( JVMDialog, ImplSelectionChanged, RadioButton *, EMPTYARG )
{
	if ( pThis->maRbtNoJava.IsChecked() )
	{
		pThis->maJavaVMs.Enable( FALSE ) ;
		pThis->maJavaHomeText.SetText( UniString::CreateFromAscii("") );
	}
	else
	{
		pThis->maJavaVMs.Enable( TRUE ) ;
		pThis->updateJavaHomeComment();
	}

	return 0;
}

IMPL_LINK( JVMDialog, HelpHdl, Button *, EMPTYARG )
{
	if (bHelpMode)
	{
		maHelp.SetText( ResId(STR_HELP, pResMgr) );
		maHelpEdit.Hide();
		maContainer.Show();
		maOK.Show();
		maCancel.Show();
	}
	else
	{
		maHelp.SetText( ResId(STR_BACK, pResMgr) );
		maHelpEdit.Show();
		maContainer.Hide();
		maOK.Hide();
		maCancel.Hide();
	}

	bHelpMode = !bHelpMode;

	return 0;
}

IMPL_LINK( JVMDialog, BrowseHdl, PushButton *, EMPTYARG )
{
	SiDirEntry currentDir(".");
	currentDir.ToAbs();

	PathDialog dlg(NULL, 0, FALSE);
	dlg.SetPath( UniString(currentDir.GetFull(), osl_getThreadTextEncoding()) );

	if ( dlg.Execute() )
	{
		JVMEntry entry;

		ByteString uhome( dlg.GetPath(), osl_getThreadTextEncoding() );

		entry.mHome = uhome;

		if ( CheckJava( entry ) )
		{
			AddEntry( entry, this );
		}
		else
		{
			InfoBox(this, ResId(DLG_NO_VALID_VM_FOUND)).Execute();
		}
	}

	return 0;
}

IMPL_LINK( JVMDialog, CancelHdl, CancelButton *, EMPTYARG )
{
	bAbort = FALSE;

	if ( bIsSetupMode )
	{
		if ( QueryBox(this, ResId(DLG_QUERYEXITBOX)).Execute() == RET_YES )
		{
				bAbort = TRUE;
				EndDialog( FALSE );
		}
	}
	else
	{
			bAbort = TRUE;
			EndDialog( FALSE );
	}

	return 0;
}

IMPL_LINK( JVMDialog, OKHdl, OKButton *, EMPTYARG )
{
/*
	if ( isNoJava() )
		switch ( QueryBox(this, ResId(DLG_QUERYNOJAVA)).Execute() )
		{
			case RET_YES :
							EndDialog( FALSE );
							return 0;
							break;
			case RET_NO :
							return 0;
							break;
		}
*/
	if ( ! bIsSetupMode )
	{
		InfoBox(this, ResId(DLG_INFORESTARTBOX)).Execute();
		EndDialog( FALSE );
	}
	else
	{
#ifdef UNX
		if ( isNoJava() && pModuleList )
		{
			SiCustomModuleInfo *pPGPModule = NULL;

			unsigned int i = 0;
			while ( i<pModuleList->Count() && !pPGPModule )
			{
				SiCustomModuleInfo* pCurrentModule = pModuleList->GetObject( i++ );
				ByteString aCurrentModuleID = pCurrentModule->GetModuleID();
				if ( aCurrentModuleID == PGP_MODULE_ID )
				{
					pPGPModule = pCurrentModule;
				}
			}

			if ( pPGPModule && pPGPModule->IsSelected() )
			{
				switch ( QueryBox(this, ResId(DLG_QUERYNOPGPBOX)).Execute() )
				{
					case RET_YES :
									EndDialog( FALSE );
									break;
					case RET_NO :
									pPGPModule->DeselectModule();
									EndDialog( FALSE );
									break;
					case RET_CANCEL : // back to the dialog
									break;

				}
			} else
				EndDialog( FALSE );
		} else
#endif  // if not UNX always end dialog
		EndDialog( FALSE );
	}

	return 0;
}

IMPL_LINK( JVMDialog, InstallHdl, PushButton *, EMPTYARG )
{
	InstallNewJavaEnvironment( aSourcePath, aDestPath, aInstallPackage, this );
	return 0;
}

IMPL_LINK( JVMDialog, SelectHdl, ListBox *, EMPTYARG )
{
	updateJavaHomeComment();
	return 0;
}

