/*
 *
 *  $RCSfile: jvmsetup.cxx,v $
 *
 *  $Revision: 1.32.2.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:47:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _VOS_PROCESS_HXX_ //autogen
#include <vos/process.hxx>
#endif

#ifndef _VOS_THREAD_HXX_ //autogen
#include <vos/thread.hxx>
#endif

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#include <tools/solar.h>
#include <sifsys.hxx>
#include <tools/debug.hxx>
#include <tools/stream.hxx>
#include <tools/string.hxx>
#include <vos/profile.hxx>
#include <rtl/string.hxx>

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

#include "environ.hxx"

#include "sicustom.hxx"
#include "jvmscan.hxx"
#include "jvmdlg.hxx"
#include "jvmdlg.hrc"

#include "jvmsetup.hxx"

#include <stdio.h>

#ifdef UNX
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <grp.h>
#endif

#ifdef UNX
#define	JAVA_INI    "javarc"
#else
#define	JAVA_INI    "java.ini"
#endif



#if defined ( UNX ) || defined( MAC )
#include <limits.h>
#define _MAX_PATH PATH_MAX
#endif

#define	JAVA_SECTION			"Java"
#define INSTALL_SECTION			"Install"
#define	JAVA_VERSION			"Version"
#define	JAVA_HOME				"Home"
#define JAVA_SUPPORT			"Java"
#define JAVASCRIPT_SUPPORT		"JavaScript"
#define APPLET_SUPPORT			"Applets"
#define SYSTEM_CLASSPATH		"SystemClasspath"
#define JAVA_RUNTIME			"RuntimeLib"
#define	JAVA_LIBPATH			"JavaLibPath"
#define	JAVA_CPLD				"com.sun.star.comp.loader.CPLD_ACCESSPATH"

#define MAX_LIST_ENTRIES		30

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace rtl;
using namespace osl;
#endif


// unschoene Loesung...
// Die verschiedenen Plattformabhaengigen erlaubten Java Versionsnummern
// fuer die Kontrolle in IsValidJVMEntry( const JVMEntry& aJvmEntry );
// Das v hinter der Verisonsnummer gibt an, ob diese Version uns schon verifiziert
// worden ist.

SiSetupFnc aSetupFnc;

static ResMgr* pResMgr = 0;

const char *	envPath = NULL;
JVMEntry		aEntryList[ MAX_LIST_ENTRIES ];
USHORT			nEntriesCount	= 0;
USHORT			nBestEntry		= 0;
BOOL			bHasInstPackage = FALSE;
JavaInstProps	aJavaInstProps;

ByteString 		strDestinationPath;
UniString 		strResourceHook_ProductName;
UniString 		strResourceHook_ProductVersion;
ResHookProc		fncOldResourceHook = NULL;

class OJavaInstallThread : public OThread
{
	OProcess::TProcessError m_ProcessError;
	JVMDialog* 				pDialog;
	ByteString 				m_ProgramName;
	ByteString 				mSourcePath;
	ByteString 				mDestPath;
	ByteString 				mInstallPackage;

	//NAMESPACE_VOS(OCondition) aWaitCondition;

	BOOL bInstalled;

	void install();

public:
	NAMESPACE_VOS(OCondition) aWaitCondition;

	OJavaInstallThread( const ByteString& srcPath,
						const ByteString& destPath,
						const ByteString& package,
						JVMDialog* pDialog = NULL
	);
	virtual void SAL_CALL run();
	virtual void SAL_CALL onTerminated();
	vos::OProcess::TProcessError getError() { return m_ProcessError; }

};

OJavaInstallThread::OJavaInstallThread( const ByteString& srcPath,
										const ByteString& destPath,
										const ByteString& package,
										JVMDialog* pDialog )
{
	this->pDialog	= pDialog;
	mSourcePath		= srcPath;
	mDestPath		= destPath;
	mInstallPackage = package;
	bInstalled		= FALSE;

	if (!pDialog)
	{
		aWaitCondition.set();
		aWaitCondition.reset();
	}
}

#ifdef UNX
BOOL _findImage( const char* pImg )
{
	BOOL bReturn 				= FALSE;
	rtl_uString* ustrImage		= NULL;
	rtl_uString* ustrSrchPath	= NULL;
	rtl_uString* ustrPath		= NULL;

	rtl_uString_newFromAscii( &ustrImage, pImg );
	rtl_uString_newFromAscii( &ustrSrchPath, getenv("PATH") );

	if( osl_File_E_None == osl_searchFileURL(ustrImage, ustrSrchPath, &ustrPath) )
		if( ustrPath != 0 )
			bReturn = TRUE;

	rtl_uString_release( ustrImage );
	rtl_uString_release( ustrSrchPath );

	return bReturn;
}
#endif

void OJavaInstallThread::install()
{
	if (bHasInstPackage)
	{
#ifdef UNX
		// change current working directory to install path
		SiDirEntry aCurrentDir(".");
		SiDirEntry( mDestPath ).SetCWD();

		ByteString savePath = "PATH=";
		savePath += getenv ( "PATH" );

		ByteString path = savePath;
		path += ":/usr/openwin/bin:/usr/X11R6/bin:/usr/bin/X11";
		putenv ( strdup( path.GetBuffer() ) );

		// start the installation in a new xterm

		rtl::OUString sArgs[8];
		sArgs[0] = OUString::createFromAscii("-T");
		sArgs[1] = OUString::createFromAscii("JavaInstall");
		sArgs[2] = OUString::createFromAscii("-e");
		sArgs[3] = OUString::createFromAscii( mInstallPackage.GetBuffer() );
		sArgs[4] = OUString::createFromAscii("-bg");
		sArgs[5] = OUString::createFromAscii("white");
		sArgs[6] = OUString::createFromAscii("-fg");
		sArgs[7] = OUString::createFromAscii("black");

		OUString auCommand;
		OUString auSearchPath;
		rtl_uString* xxx = NULL;
		rtl_uString* yyy = NULL;
		rtl_uString* ttt = NULL;
		char cTerm[200];

		if( _findImage("dtterm") )
		{
			strcpy( cTerm, "dtterm" );
			sArgs[0] = OUString::createFromAscii("-title");
		}
		else if( _findImage("kterm") )
		{
			strcpy( cTerm, "kterm" );
		}
		else
		{
			strcpy( cTerm, "xterm" );
		}

		rtl_uString_newFromAscii(&xxx, cTerm);
		rtl_uString_new(&yyy);

		osl_searchFileURL( xxx, yyy, &ttt);

        FileBase::RC result = File::searchFileURL( OUString::createFromAscii(cTerm), auSearchPath, auCommand );

		VOS_ASSERT(result == File::E_None);

		//fprintf(stdout, "path to xterm %s\n", OUStringToOString(auCommand, osl_getThreadTextEncoding()).getStr());
		vos::OProcess aProcess( auCommand );
		//aProcess.addEnvironment("PATH", path);

		m_ProcessError = aProcess.execute( (vos::OProcess::TProcessOption)
			(vos::OProcess::TOption_Normal | vos::OProcess::TOption_SearchPath), vos::OArgumentList(sArgs, 8) );

		if ( m_ProcessError != vos::OProcess::E_None  )// if an error occured try it without the xterm
		{
			FileBase::RC result = File::getFileURLFromSystemPath(OUString(mInstallPackage.GetBuffer(), mInstallPackage.Len(), osl_getThreadTextEncoding()), auCommand);
            VOS_ASSERT(result == File::E_None);
			vos::OProcess aProcess2(auCommand);
			m_ProcessError = aProcess2.execute( (vos::OProcess::TProcessOption)
				(vos::OProcess::TOption_Normal | vos::OProcess::TOption_SearchPath));
		}

		putenv ( strdup( savePath.GetBuffer() ) );
		m_ProcessError = aProcess.join();
#else
		vos::OProcess aProcess( OUString(mInstallPackage.GetBuffer(), mInstallPackage.Len(), osl_getThreadTextEncoding()) );
		m_ProcessError = aProcess.execute( vos::OProcess::TOption_Normal );

#endif
		m_ProcessError = aProcess.join();

#ifdef UNX
		aCurrentDir.SetCWD();
#endif

	}
}

void OJavaInstallThread::run()
{
	install();
	bInstalled = TRUE;

	UpdateList();

	if ( !pDialog )
	{
		aWaitCondition.set();
	}
	else
	{
		NAMESPACE_VOS(OGuard) aGuard( Application::GetSolarMutex() );
		pDialog->update( nEntriesCount, nBestEntry, aEntryList );
		pDialog->Enable();
		pDialog->ToTop(); // for Windows 2000
		pDialog->GrabFocusToFirstControl();
	}

}

void OJavaInstallThread::onTerminated()
{
	if ( pDialog )
	{
		delete this;
	}
}

void ReadInstallSection( ByteString iniFile );

BOOL VerifyInstallProperties();

void WriteInstallSection( ByteString iniFile );

////////////////////////////////////////////////////////////////////////////////
//
//	EntryPoint
//
extern "C"
{
BOOL _SV_CALL CustomInit(SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc)
{
	// inkompatibel oder nicht vorhanden ?
	if( !pSetupFnc || pSetupFnc->nVersion > SICUSTOM_VERSION )
		return FALSE;

	pCustomFnc->fncMain = (FncPtrCustomMain)CustomMain;

	aSetupFnc.nVersion 				= pSetupFnc->nVersion;
	aSetupFnc.fncHideSetup			= pSetupFnc->fncHideSetup;
	aSetupFnc.fncShowSetup			= pSetupFnc->fncShowSetup;
	aSetupFnc.fncGetCodeFilename	= pSetupFnc->fncGetCodeFilename;

	return TRUE;
};
}

void ResourceHook( UniString& rStr )
{
	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTNAME"), strResourceHook_ProductName );
	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTVERSION"), strResourceHook_ProductVersion );
}

ResMgr* GetResourceManager( const ByteString resName, const ByteString resPath, const LanguageType langType )
{
	ResMgr* pResMgr;
	LanguageType eLangType;
	if( !langType )
		pResMgr = ResMgr::SearchCreateResMgr( resName.GetBuffer(), eLangType );
	else
		pResMgr = ResMgr::CreateResMgr( resName.GetBuffer(), langType );


	if( !fncOldResourceHook ) fncOldResourceHook = ResMgr::GetReadStringHook();
	ResMgr::SetReadStringHook( ResourceHook );

	if ( !pResMgr )
	{
		SiDirEntry resource( resPath );
		resource += SiDirEntry( "resource" );
		resource += SiDirEntry( resName );

		pResMgr	  = ResMgr::SearchCreateResMgr( resource.GetFull().GetBuffer(), eLangType );
	}

	return pResMgr;
};

////////////////////////////////////////////////////////////////////////////////
//
//	CustomMain
//
BOOL _SV_CALL CustomMain( SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList )
{
	enum { INST_NONE, INST_NEW, INST_PRE, INST_PRE_NONE };

	ULONG		nSelectedEntry		= 0;
	UINT32		nInstallType		= INST_PRE;
	BOOL		bIsSetupMode		= pModuleList != NULL;
	BOOL		bIsWorkstation		= FALSE;

	ByteString		aResFileName("jvm");

	ByteString		aDestIniName;
	ByteString		aSrcIniName;

	aResFileName	+= MAKE_NUMSTR( SUPD );

	ByteString aSourcePath 	= pEnv->GetSourcePath();
	ByteString aDestPath	= pEnv->GetDestPath();
	strDestinationPath = aDestPath;
	ByteString aClassDir;
	ByteString aInstallPackage;
	ByteString aInstallPath;

	if(bIsSetupMode)
	{
		strResourceHook_ProductName		= UniString(pEnv->GetBigEnv()->GetSingleProductName(), osl_getThreadTextEncoding());
		strResourceHook_ProductVersion	= UniString(pEnv->GetBigEnv()->GetProductVersion(), osl_getThreadTextEncoding());
	}
	else
	{
		strResourceHook_ProductName		= pEnv->getProductName();
        bIsWorkstation                  = IsWorkstation( aSourcePath );
		// strResourceHook_ProductVersion	= UniString(pEnv->GetBigEnv()->GetProductVersion(), osl_getThreadTextEncoding());
	}

#ifdef UNX
	SiCustomModuleInfo* pPgpModule = NULL;
#endif
	//WarningBox( NULL, WB_OK, UniString::CreateFromAscii("Debug Stop.")).Execute();
	if ( bIsSetupMode )
	{

#ifdef UNX
		// looking up for PGP
		unsigned int i = 0;
		while ( i<pModuleList->Count() && !pPgpModule )
		{
			SiCustomModuleInfo* pCurrentModule = pModuleList->GetObject( i++ );
			ByteString aCurrentModuleID = pCurrentModule->GetModuleID();
			if ( aCurrentModuleID == PGP_MODULE_ID )
			{
				pPgpModule = pCurrentModule;
			}
		}
#endif

		bIsWorkstation = pEnv->GetBigEnv()->GetInstallType() == IT_WORKSTATION || pEnv->GetBigEnv()->InstallFromNet();
	}

	// look for the resource
	if ( ! pEnv->IsResponseFileMode() )
	{
		ByteString	aResFileName("jvm");
		aResFileName += MAKE_NUMSTR( SUPD );

		ByteString aStartPath = pEnv->GetStartPath();

		pResMgr = GetResourceManager( aResFileName, aStartPath, 0 );

		if (!pResMgr)
		{
			LanguageType nLangType = LANGUAGE_ENGLISH;
			GetResourceManager( aResFileName, aStartPath, nLangType );
		}

		if ( ! pResMgr )
		{
			UniString errMsg = UniString::CreateFromAscii("Java Setup : can't find resource:\n");
			errMsg += UniString( aResFileName, osl_getThreadTextEncoding() );
			WarningBox( NULL, WB_OK, errMsg).Execute();
			if( fncOldResourceHook ) ResMgr::SetReadStringHook( fncOldResourceHook );
			return TRUE; // return FALSE -> Setup exit
		}

	}

	if ( bIsWorkstation && bIsSetupMode )
	{
#ifdef UNIX
		aSourcePath += "/program/";
#else
		aSourcePath += "\\program\\";
#endif
	}
	else
	{
#ifdef UNIX
	    aSourcePath += "/";
#else
		aSourcePath += "\\";
#endif
	}

#ifdef UNIX
	aDestPath += "/program/";
#else
	aDestPath += "\\program\\";
#endif
	aClassDir = bIsWorkstation? aSourcePath : aDestPath;
	aClassDir += "classes";

//      OUString aTempSrc = UniString( aClassDir, osl_getThreadTextEncoding() );
//      OUString aTemp;
//	FileBase::getSystemPathFromFileURL( aTempSrc, aTemp );
//	aClassDir = ByteString( UniString(aTemp), osl_getThreadTextEncoding() );

	// fprintf(stderr, "set source path to %s\n", aSourcePath.GetBuffer());
	// fprintf(stderr, "set dest path to %s\n", aDestPath.GetBuffer());


	if ( bIsSetupMode ) // seems to be the setup
	{
        OUString aUDestIniName;
	OUString aOUStr( pEnv->GetDestPath().GetBuffer(), pEnv->GetDestPath().Len(), osl_getThreadTextEncoding() );

	FileBase::RC result = File::getFileURLFromSystemPath( aOUStr, aUDestIniName);

        aUDestIniName += OUString::createFromAscii("/");
        aUDestIniName += ( pEnv->GetBigEnv()->IsLocal() )? OUString::createFromAscii("user") : OUString::createFromAscii("share");
        aUDestIniName += OUString::createFromAscii("/config/");
        aUDestIniName += OUString::createFromAscii(JAVA_INI);

        aDestIniName = OUStringToOString(aUDestIniName, osl_getThreadTextEncoding());

		aSrcIniName = aSetupFnc.fncGetCodeFilename();
		ReadInstallSection( aSrcIniName );

		//WriteInstallSection( aDestIniName );
	}
	else
	{
		// first look at $OFFICEHOME$/user/config
		ByteString aInstalledOfficePath = pEnv->GetInstalledPath();
#ifdef UNX
		aInstalledOfficePath += "/user/config/javarc";
#else
		aInstalledOfficePath += "\\user\\config\\java.ini";
#endif
		// fprintf(stderr, "looking for javasrc in %s\n", aJavaIniPath.GetBuffer() );

		OUString _normPath;

		FileBase::RC eError = File::getFileURLFromSystemPath( UniString(aInstalledOfficePath, osl_getThreadTextEncoding()), _normPath );
		// we are allready a FileURL
//		_normPath = UniString(aInstalledOfficePath, osl_getThreadTextEncoding());

		aDestIniName = OUStringToOString( _normPath, osl_getThreadTextEncoding() );

		if ( SiDirEntry( aInstalledOfficePath ).Exists() )
		{
			// looks like an user installation
			aSrcIniName = aInstalledOfficePath;
		}
		else
		{
			ByteString aSrcOfficePath = pEnv->GetInstalledPath();
#ifdef UNX
			aSrcOfficePath += "/share/config/javarc";
#else
			aSrcOfficePath += "\\share\\config\\java.ini";
#endif
			OUString __normPath;
		    // #92976#
			File::getFileURLFromSystemPath( UniString(aSrcOfficePath, osl_getThreadTextEncoding()), __normPath );
//			__normPath = UniString(aSrcOfficePath, osl_getThreadTextEncoding());
			aDestIniName = OUStringToOString( __normPath, osl_getThreadTextEncoding() );

			if ( SiDirEntry( aSrcOfficePath ).Exists() )
			{
				aSrcIniName = aSrcOfficePath;
			}
			else
			{
				// now we have a problem
#ifdef UNX
				UniString errMsg(RTL_CONSTASCII_USTRINGPARAM("Java Setup : can't find javarc"));
#else
				UniString errMsg(RTL_CONSTASCII_USTRINGPARAM("Java Setup : can't find java.ini"));
#endif
				WarningBox( NULL, WB_OK, errMsg).Execute();
				if( fncOldResourceHook ) ResMgr::SetReadStringHook( fncOldResourceHook );
				return TRUE; // return FALSE -> Setup exit
			}
		}

		ReadInstallSection( aSrcIniName );
	}

	if ( !VerifyInstallProperties() )
	{
		if( fncOldResourceHook ) ResMgr::SetReadStringHook( fncOldResourceHook );
		return TRUE;
	}

	if ( aJavaInstProps.find(INSTALLATION_PACKAGE) != aJavaInstProps.end() )
	{
		if ( bIsSetupMode && pEnv->GetBigEnv()->IsBigMode() )
		{
			ArchDirectory* pArchive = pEnv->GetBigEnv()->GetArchive();

			if ( pArchive->ExistsFile( aJavaInstProps[INSTALLATION_PACKAGE].GetBuffer() ) )
			{
				pArchive->GetFile( aJavaInstProps[INSTALLATION_PACKAGE].GetBuffer(), pEnv->GetStartPath().GetBuffer() );

				SiDirEntry aEntry( pEnv->GetStartPath() );
				aEntry += SiDirEntry( aJavaInstProps[INSTALLATION_PACKAGE] );
				bHasInstPackage = aEntry.Exists();
				if( bHasInstPackage )
				{
					aInstallPackage = aEntry.GetFull();
#ifdef UNX
					chmod( aInstallPackage.GetBuffer(), S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH );
#endif
				}
			}
		}
		else
		{
			aInstallPackage = aSourcePath;
			aInstallPackage += aJavaInstProps[INSTALLATION_PACKAGE];
			bHasInstPackage = SiDirEntry( aInstallPackage ).Exists();
		}

		aInstallPath     = aDestPath;
        aInstallPath    += aJavaInstProps[PACKAGE_INSTALL_DIR];

		// fprintf(stderr, "set install package to %s\n", aInstallPackage.GetBuffer());
		// fprintf(stderr, "set install path to %s\n", aInstallPath.GetBuffer());
	}

#ifdef UNX

	// append the Java installation path to PATH
	// so the scan routine can find the installation
	ByteString aNewPath( "PATH=" );
	aNewPath += aInstallPath;
	aNewPath += "/bin:";
	aNewPath += getenv ("PATH");

	if ( envPath )
	{
		free( const_cast<char*>(envPath) );
	}

	envPath = strdup( aNewPath.GetBuffer() );
	putenv( const_cast<char*>(envPath) );

	// fprintf( stderr, "adding %s to search path\n", aNewPath.GetBuffer() );

#endif

	UpdateList();

	nSelectedEntry = nBestEntry;

	if ( pEnv->IsResponseFileMode() ) // response mode enabled
	{
		rtl::OUString aResFileName = rtl::OUString(pEnv->GetResponseFileName().GetBuffer(),
				pEnv->GetResponseFileName().Len(), osl_getThreadTextEncoding() );

		// #92976#
        FileBase::RC res = File::getFileURLFromSystemPath( aResFileName,  aResFileName);
        // VOS_ENSURE(res == FileBase::E_None, "Can't convert responce file name in unc notation!");

        OProfile aResposeFile( aResFileName );
		char buffer[256];

		WriteInstallSection( aDestIniName );

		if ( aResposeFile.readString("Java", "JavaSupport", buffer, 256, "") )
		{
			rtl::OString aValue( buffer );

			if ( aValue.equalsIgnoreAsciiCase("none") )
			{
				nInstallType = INST_NONE;
#ifdef UNX
				if ( pPgpModule && pPgpModule->IsSelected() )
					pPgpModule->DeselectModule();
#endif
			}
			else
			if ( aValue.equalsIgnoreAsciiCase("newinstall") )
			{
				if (bHasInstPackage)
				{
					if ( InstallNewJavaEnvironment( aSourcePath, aDestPath, aInstallPackage, NULL ) )
					{
						JVMEntry entry;

						if ( GetInstalledVM( entry, aInstallPath ) )
						{
							WriteVMInfoToFile( entry, aDestIniName, aClassDir );
							WriteJavaSupportToFile(TRUE, aDestIniName );
							if( fncOldResourceHook ) ResMgr::SetReadStringHook( fncOldResourceHook );
							return TRUE;
						}
					}
				}

#ifdef UNX
				if ( pPgpModule && pPgpModule->IsSelected() )
					pPgpModule->DeselectModule();
#endif
				WriteJavaSupportToFile( FALSE, aDestIniName );
				if( fncOldResourceHook ) ResMgr::SetReadStringHook( fncOldResourceHook );
				return TRUE;
			}
			else
			if ( aValue.equalsIgnoreAsciiCase("preinstalled_or_none") )
			{
				if ( nEntriesCount )
				{
					WriteVMInfoToFile( aEntryList[nBestEntry], aDestIniName, aClassDir );
					WriteJavaSupportToFile( TRUE, aDestIniName );
				}
				else
				{
#ifdef UNX
					if ( pPgpModule && pPgpModule->IsSelected() )
						pPgpModule->DeselectModule();
#endif
					WriteJavaSupportToFile( FALSE, aDestIniName );
				}

				if( fncOldResourceHook ) ResMgr::SetReadStringHook( fncOldResourceHook );
				return TRUE;
			}
			else //	preinstalled and all other (default)
			{
				if ( nEntriesCount )
				{
					WriteVMInfoToFile( aEntryList[nBestEntry], aDestIniName, aClassDir );
					WriteJavaSupportToFile( TRUE, aDestIniName );
				}
				else
				{
					if ( bHasInstPackage )
					{
						if ( InstallNewJavaEnvironment( aSourcePath, aDestPath, aInstallPackage, NULL ) )
						{
							JVMEntry entry;

							if ( GetInstalledVM( entry, aInstallPath ) )
							{
								WriteVMInfoToFile( entry, aDestIniName, aClassDir );
								WriteJavaSupportToFile( TRUE, aDestIniName );
								if( fncOldResourceHook ) ResMgr::SetReadStringHook( fncOldResourceHook );
								return TRUE;
							}
						}
					}
#ifdef UNX
					if ( pPgpModule && pPgpModule->IsSelected() )
						pPgpModule->DeselectModule();
#endif
					WriteJavaSupportToFile( FALSE, aDestIniName );
				}
				if( fncOldResourceHook ) ResMgr::SetReadStringHook( fncOldResourceHook );
				return TRUE;
			}
		}
	}
	else // no response mode
	{
		JVMDialog aDlg ( NULL, pResMgr, pEnv, pModuleList,
						 aSourcePath, aDestPath, aInstallPackage,
						 bIsSetupMode );
		aDlg.update( nEntriesCount, nBestEntry, aEntryList );

		if ( bHasInstPackage )
		{
			// fprintf( stderr, "looking for package %s\n", aInstallPackage.GetBuffer() );
			aDlg.enableInstallBtn( SiDirEntry( aInstallPackage ).Exists() );
		}

		aDlg.ToTop(); // for Windows 2000
		aDlg.GrabFocusToFirstControl();
		aDlg.Execute();

		if ( aDlg.abort() )
		{
			if( fncOldResourceHook ) ResMgr::SetReadStringHook( fncOldResourceHook );
			return FALSE;
		}

		// ok - we are here - we should write out the properties
		WriteInstallSection( aDestIniName );

		if ( aDlg.isNoJava() )
		{
			nInstallType = INST_NONE;
		}
		else
		{
			nInstallType = INST_PRE;
			aDlg.getSelectedEntry( nSelectedEntry );

			if (nSelectedEntry)
			{
				nSelectedEntry --;
			}

		}
	} // end of else IsResponseFileMode

	switch ( nInstallType )
	{
		case INST_NONE		:
			WriteJavaSupportToFile(FALSE, aDestIniName );
			break;

		case INST_NEW		:
			WriteJavaSupportToFile(TRUE, aDestIniName );
			break;

		case INST_PRE_NONE	:
			if ( nEntriesCount )
			{
				WriteVMInfoToFile( aEntryList[ nSelectedEntry ], aDestIniName, aClassDir );
				WriteJavaSupportToFile(TRUE, aDestIniName );
			}
			else // no pre installed VM found -- now do nothing
			if ( nInstallType == INST_PRE_NONE )
				WriteJavaSupportToFile(FALSE, aDestIniName );
			break;

		case INST_PRE		:
		default				:
			if ( nEntriesCount )
			{
				WriteVMInfoToFile( aEntryList[ nSelectedEntry ], aDestIniName, aClassDir );
				WriteJavaSupportToFile( TRUE, aDestIniName );
			}
			else // no pre installed VM found -- now install new
			{
				WriteJavaSupportToFile(TRUE, aDestIniName );
			}
			break;
	};

	if( fncOldResourceHook ) ResMgr::SetReadStringHook( fncOldResourceHook );
	return TRUE;
}

void UpdateList()
{
	nEntriesCount = GetJavaVirtualMachine( aEntryList );

	int i = 0;

	while (i < nEntriesCount )
	{
		if ( aEntryList[ i ].bIsBestVersion )
		{
			nBestEntry = i;
			i = nEntriesCount;
		}
		i++;
	}
}

BOOL _compareJVMEntries( const JVMEntry& a, const JVMEntry& b )
{
	if( a.mVendor  		== b.mVendor &&
		a.mName			== b.mName &&
		a.mVersion		== b.mVersion &&
		a.mHome			== b.mHome &&
		a.mRuntimeLib	== b.mRuntimeLib &&
		a.mClasspath	== b.mClasspath &&
		a.mLibPath		== b.mLibPath &&
		a.mJVMType		== b.mJVMType &&
		a.mEnvType		== b.mEnvType )
		return TRUE;
	return FALSE;
}

void AddEntry(const JVMEntry entry, JVMDialog* pDlg)
{
	int i;
	for( i = 0; i < nEntriesCount; i++ )
		if( _compareJVMEntries(entry, aEntryList[ i ]) )
			return;

	for( i = 0; i < nEntriesCount; i++ )
		aEntryList[ i ].bIsBestVersion  = FALSE;

	aEntryList[ nEntriesCount ] = entry;
	aEntryList[ nEntriesCount ].bIsBestVersion  = TRUE;
	nBestEntry = nEntriesCount ++;

	if (pDlg)
		pDlg->update( nEntriesCount, nBestEntry, aEntryList );
}

BOOL WriteVMInfoToFile( const JVMEntry& rJvmEntry, const ByteString& aIniFile, const ByteString& aClassDir )
{
	BOOL bRetVal = FALSE;

	OProfile aSoIni( OUString( aIniFile.GetBuffer(), aIniFile.Len(), osl_getThreadTextEncoding() ) );

	ByteString aCPLDPath( strDestinationPath );
	aCPLDPath += "/program;";
	aCPLDPath += strDestinationPath;
	aCPLDPath += "/program/classes";

	bRetVal = aSoIni.writeString( JAVA_SECTION, JAVA_HOME, rJvmEntry.mHome.GetBuffer() );

	if( bRetVal && aJavaInstProps.find(CPLD_PATH) != aJavaInstProps.end() )
	{
		ByteString val = aJavaInstProps[CPLD_PATH];
		if( val.ToInt32() == 1 )
			bRetVal = aSoIni.writeString( JAVA_SECTION, JAVA_CPLD, aCPLDPath.GetBuffer() );
	}

	if( bRetVal )
        bRetVal = aSoIni.writeString( JAVA_SECTION, VM_TYPE, rJvmEntry.mEnvType.GetBuffer() );

	if( bRetVal )
		bRetVal = aSoIni.writeString( JAVA_SECTION, JAVA_VERSION, rJvmEntry.mVersion.GetBuffer() );


	if( bRetVal )
		bRetVal = aSoIni.writeString( JAVA_SECTION, JAVA_RUNTIME, rJvmEntry.mRuntimeLib.GetBuffer() );

#ifdef UNIX
	if( bRetVal )
		bRetVal = aSoIni.writeString( JAVA_SECTION, JAVA_LIBPATH, rJvmEntry.mLibPath.GetBuffer() );
#endif

	if( bRetVal )
	{
		ByteString classpath = rJvmEntry.mClasspath;

		if (aJavaInstProps.find(ADDITIONAL_CLASSPATH) != aJavaInstProps.end() )
		{
			ByteString addClasspath = aJavaInstProps[ADDITIONAL_CLASSPATH];
			addClasspath.SearchAndReplaceAll( CLASSDIR, aClassDir );

#ifdef UNIX
			classpath += ":";
#else
			classpath += ";";
#endif
			classpath += addClasspath;
		}

		bRetVal = aSoIni.writeString( JAVA_SECTION, SYSTEM_CLASSPATH, classpath.GetBuffer() );
	}

	return bRetVal;
}

BOOL WriteJavaSupportToFile( BOOL bSupport, const ByteString& aIniFile )
{
	BOOL bRetVal = FALSE;

	OProfile aSoIni( OUString(aIniFile.GetBuffer(), aIniFile.Len(), osl_getThreadTextEncoding()) );

	ByteString aEnable = bSupport? "1" : "0";

	bRetVal = aSoIni.writeString(JAVA_SECTION, JAVA_SUPPORT, aEnable.GetBuffer());

	if( bRetVal )
		bRetVal = aSoIni.writeString(JAVA_SECTION, JAVASCRIPT_SUPPORT, aEnable.GetBuffer());

	if( bRetVal )
		bRetVal = aSoIni.writeString(JAVA_SECTION, APPLET_SUPPORT, aEnable.GetBuffer());

	return bRetVal;
}

BOOL InstallNewJavaEnvironment( const ByteString& sourcePath,
								const ByteString& destPath,
								const ByteString& instPackage,
								JVMDialog * pDialog )
{
	if ( pDialog )
		pDialog->Disable();

	SiDirEntry aDestDir( destPath );

	if ( !aDestDir.Exists() )
	{
		aDestDir.MakeDir();
	}

	OJavaInstallThread* pInstallThread = new OJavaInstallThread ( sourcePath, destPath, instPackage, pDialog );
	pInstallThread->create();

	if ( !pDialog )
	{
		pInstallThread->aWaitCondition.wait();

		while ( pInstallThread->isRunning() )
			NAMESPACE_VOS(OThread)::yield();

		delete pInstallThread;
	}

	return TRUE;
}

const JVMEntry* GetEntry( USHORT nIndex )
{
	if ( nIndex < nEntriesCount )
		return & aEntryList[nIndex];
	else
		return NULL;
}

void ReadInstallSection( ByteString iniFile )
{
    OUString profileFile;
    FileBase::RC res = File::getFileURLFromSystemPath( UniString(iniFile, osl_getThreadTextEncoding()),  profileFile);

    OProfile aProfile ( profileFile );

    UINT32 nMaxLen = aProfile.getSectionEntries(INSTALL_SECTION, NULL, 0);

    sal_Char* entry_buffer = new sal_Char[nMaxLen];
	sal_Char value_buffer[1024];

    nMaxLen = aProfile.getSectionEntries( INSTALL_SECTION, entry_buffer, nMaxLen );

    UINT32 nPos = 0;

	for ( ULONG nCharPos = 0; nCharPos < nMaxLen; )
    {
        ByteString aEntryTag ( entry_buffer + nCharPos );
		nCharPos += aEntryTag.Len() + 1;
		if ( aEntryTag.Len() )
		{
			aProfile.readString( INSTALL_SECTION, aEntryTag.GetBuffer(), value_buffer, 1024, "" );

			ByteString aValueStr( value_buffer );

			if ( aValueStr.Len() )
				aJavaInstProps[aEntryTag] = aValueStr;
		}
    }

	delete[] entry_buffer;
}

void WriteInstallSection( ByteString iniFile )
{
	UniString aFileName = UniString( iniFile, osl_getThreadTextEncoding() );

	USHORT nStartIndex;
	nStartIndex	= aFileName.SearchCharBackward( UniString::CreateFromAscii("/").GetBuffer() );

	UniString aIniHome = aFileName.Erase(nStartIndex, aFileName.Len() - nStartIndex);

	DirEntry aPath = DirEntry( aIniHome );

	aPath.ToAbs();

	if ( ! aPath.Exists() )
		aPath.MakeDir();

	OProfile aProfile( UniString(iniFile, osl_getThreadTextEncoding()) );
	typedef JavaInstProps::iterator IT;

	for ( IT it= aJavaInstProps.begin(); it != aJavaInstProps.end(); it++)
	{
		ByteString aKey((*it).first);
		ByteString aValue(aJavaInstProps[aKey]);

		aProfile.writeString( INSTALL_SECTION, aKey.GetBuffer(), aValue.GetBuffer() );
	}
}

BOOL VerifyInstallProperties()
{
	UniString errMsg;

	if ( aJavaInstProps.find(REQUIRED_VERSION) == aJavaInstProps.end() )
	{
		errMsg = UniString::CreateFromAscii("Java Setup - invalid Java install properties:\n"
		"No \"required version\" is specified.");
		errMsg += UniString(RTL_CONSTASCII_USTRINGPARAM("No \"required version\" is specified."));
		WarningBox( NULL, WB_OK, errMsg).Execute();
	}

	if ( aJavaInstProps.find(VERIFIED_VERSION) == aJavaInstProps.end() )
	{
		errMsg  = UniString::CreateFromAscii("Java Setup - invalid Java install properties:\n");
		errMsg += UniString::CreateFromAscii("No \"verified version\" is specified.");
		WarningBox( NULL, WB_OK, errMsg).Execute();
	}

	if ( aJavaInstProps.find(INSTALLATION_PACKAGE) != aJavaInstProps.end() )
	{
		if ( aJavaInstProps.find(VENDOR) == aJavaInstProps.end() )
		{
			errMsg  = UniString::CreateFromAscii("Java Setup - invalid Java install properties:\n");
			errMsg += UniString::CreateFromAscii("The Vendor of the installation package must be specified.");
			errMsg += UniString::CreateFromAscii("\nJava Setup - abort");
			ErrorBox( NULL, WB_OK, errMsg).Execute();
			return FALSE;
		}

		if ( aJavaInstProps.find(VERSION) == aJavaInstProps.end() )
		{
			errMsg = UniString::CreateFromAscii("Java Setup - invalid Java install properties:\n");
			errMsg += UniString::CreateFromAscii("The Version of the installation package must be specified.");
			errMsg += UniString::CreateFromAscii("\nJava Setup - abort");
			ErrorBox( NULL, WB_OK, errMsg).Execute();
			return FALSE;
		}
#ifdef UNX
		if ( aJavaInstProps.find(PACKAGE_INSTALL_DIR) == aJavaInstProps.end() )
		{
			errMsg = UniString::CreateFromAscii("Java Setup - invalid Java install properties:\n");
			errMsg += UniString::CreateFromAscii("The directory of the installation package must be specified.");
			errMsg += UniString::CreateFromAscii("\nJava Setup - abort");
			ErrorBox( NULL, WB_OK, errMsg).Execute();
			return FALSE;
		}
#endif
	}

	return TRUE;
}

// -----------
BOOL IsWorkstation( const ByteString& rSourcePath )
{
    BOOL bWorkstation = FALSE;

    SiDirEntry aBootstrapfile( rSourcePath );
	aBootstrapfile.ToAbs();
#ifdef UNX
	aBootstrapfile += UniString::CreateFromAscii("bootstraprc");
#else
	aBootstrapfile += UniString::CreateFromAscii("bootstrap.ini");
#endif

	if( aBootstrapfile.Exists() )
	{
		Config aCfg( aBootstrapfile.GetFullUni() );
		aCfg.SetGroup( "Bootstrap" );

        ByteString aInstallMode = aCfg.ReadKey( "InstallMode" );
        if ( ( aInstallMode.CompareIgnoreCaseToAscii( "NETWORK" ) == COMPARE_EQUAL ) ||
             ( aInstallMode.CompareIgnoreCaseToAscii( "ALL_USERS" ) == COMPARE_EQUAL ) )
        {
            bWorkstation = TRUE;
        }
	}

    return bWorkstation;
}

