/*************************************************************************
 *
 *  $RCSfile: jvmscan.cxx,v $
 *
 *  $Revision: 1.7.2.4 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:47:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//#if _MSC_VER <= 1200
#define VCL_NEED_BASETSD
//#endif
#include <tools/presys.h>
#include <windows.h>
#include <sys\stat.h>

#include <process.h>
#include <tools/postsys.h>
#include <stdio.h>

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#include <tools/string.hxx>
#include "../jvmscan.hxx"

#include <errno.h>

#define MS_VALID_SINCE_VERSION	"5,0,3165,0"
#define MS_VERIFIED_VERSIONS	"5,0,3165,0"

#define HKEY_SUN_JRE "Software\\JavaSoft\\Java Runtime Environment"
#define HKEY_SUN_JDK "Software\\JavaSoft\\Java Development Kit"
#define HKEY_MS_JRE	 "Software\\Microsoft\\Java VM"
#define HKEY_IBM_JRE_1 "Software\\IBM\\IBM WIN32 Runtime Environment, Java(TM) Edition"
#define HKEY_IBM_JRE_2 "Software\\IBM\\IBM Runtime Environment, Java(TM) Tech. Edition"
#define HKEY_IBM_JDK "Software\\IBM\\IBM Developer Kit, Java(TM) Tech. Edition"


//#define SETUP_JVM_VALID_JVM_NAMES			"Java Runtime, Java Runtime Environment, Java Development Kit, Microsoft Java VM"
// Abklemmen der Microsoft VM
#define SETUP_JVM_VALID_JVM_NAMES			"Java Runtime Environment, Java Development Kit"

//#define MS_JAVA_VM ON
#define IBM_JAVA_VM ON

BOOL GetVersion( ByteString aCommand, ByteString& version );
BOOL GetRuntime(ByteString home, ByteString version, BOOL isJRE, ByteString& runtime);
BOOL GetClasspath( ByteString home, ByteString version, BOOL isJRE, ByteString& classpath );

// Installing j2re-1_3_1-win-i.exe results in two entries in the registry one with the key
// 1.3 and one with the key 1.3.1. This function is called from within GetJavaVirtualMachine
// after reading the home directory ("JavaHome"). If the funciton returns true then we can
// proceed otherwise we have read allready an entry that points to that JavaHome directory.
// params:
// arJVM - array of JVMEntry structures,
// nEntry - number of entries in the array
// Home - a string with the JavaHome path. We compare this string with the entries in the array.
// return: TRUE - there is no entry that contains a JavaHome dir like Home.
// FALSE: There is an entry that has got an JavaHome entry like Home.
static BOOL checkForDoubleEntry( JVMEntry* arJVM, USHORT nEntry, char* Home)
{
	BOOL ret= TRUE;
	for( INT i= 0; i < nEntry; i++)
	{
		if( arJVM[i].mHome == ByteString( Home))
		{
			// found same entry
			ret= FALSE;
			break;
		}
	}
	return ret;
}

BOOL ExistFile(ByteString const& _sFilename)
{
/*
  // UNIX Code
	if (access(_sFilename.getBuffer(), F_OK) == 0)		// file does not exists
	{
		return TRUE;
	}
	return FALSE;
*/
	struct _stat aStat;
	if (_stat(_sFilename.GetBuffer(), &aStat) != 0)  // nicht vorhanden
	{
		return FALSE;
	}
	return TRUE;
}

USHORT GetJavaVirtualMachine( JVMEntry* pJVM )
{
	DWORD	dwType;
	DWORD	dwBytes;
	HKEY	hRoot, hKey;
	USHORT	nEntries = 0;

	char	Version[32];
	char	Home[MAX_PATH];
	char	RuntimeLib[MAX_PATH];
	char	Classes[2048];

	int		nBestVerifiedVersion = -1;
	USHORT  nBestVersion =0;

	/* First try Java Runtime Environment */
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, HKEY_SUN_JRE, 0, KEY_ENUMERATE_SUB_KEYS, &hRoot) == ERROR_SUCCESS)
	{
		DWORD dwIndex = 0;
		DWORD nNameLen;
		char buffer[1024];

		FILETIME fileTime;

		nNameLen = sizeof(buffer);

		while (RegEnumKeyEx(hRoot, dwIndex, buffer, &nNameLen, NULL, NULL, NULL, &fileTime) != ERROR_NO_MORE_ITEMS)
		{
			if (RegOpenKeyEx(hRoot, buffer, 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
			{
				strcpy(Version, buffer);
				dwBytes = sizeof(Home);

				if (RegQueryValueEx(hKey, "JavaHome", 0, &dwType, (unsigned char*) Home, &dwBytes) == ERROR_SUCCESS)
				{
					// check if there was already an entry that points to the same directory.
					if( checkForDoubleEntry( pJVM, nEntries, Home) )
					{
						dwBytes = sizeof(buffer);

						/* complete version information */
						if ( (strlen(Version) < 4 ) &&
							 (RegQueryValueEx(hKey, "MicroVersion", 0, &dwType, (unsigned char*) buffer, &dwBytes) == ERROR_SUCCESS)
							)
						{
							strcat(Version, ".");
							strcat(Version, buffer);
						}

						if ( aJavaInstProps[REQUIRED_VERSION] <= Version )
						{

							/* build path to runtimelib */
							strcpy(RuntimeLib, Home);
							if ( ByteString("1.2") > Version )
								strcat(RuntimeLib, "\\bin\\javai.dll");			// JRE 1.1.x
							else if( ByteString("1.3") > Version)
								strcat(RuntimeLib, "\\bin\\classic\\jvm.dll");  // JRE 1.2.x
							else if( ByteString("1.4") > Version)
								strcat( RuntimeLib, "\\bin\\hotspot\\jvm.dll");  // JRE 1.3.x
							else
								strcat( RuntimeLib, "\\bin\\client\\jvm.dll");  // JRE 1.4

							/* build default classpath */
							strcpy(Classes, "");

							pJVM[nEntries].mVendor			= "SUN";
							pJVM[nEntries].mName			= "Java Runtime Environment";
							pJVM[nEntries].mEnvType         = JRE_TYPE;
							pJVM[nEntries].mHome			= Home;
							pJVM[nEntries].mVersion			= Version;
							pJVM[nEntries].mRuntimeLib		= RuntimeLib;
							pJVM[nEntries].mClasspath		= Classes;

							pJVM[nEntries].bIsVerified		= aJavaInstProps[VERIFIED_VERSION].Search( Version ) != STRING_NOTFOUND;
							pJVM[nEntries].bIsBestVersion	= FALSE;

							if ( pJVM[nEntries].bIsVerified )
							{
								if ( nBestVerifiedVersion == -1 )
									nBestVerifiedVersion = nEntries;
								else
								{
									if ( pJVM[nEntries].mVersion >  pJVM[nBestVerifiedVersion].mVersion )
										nBestVerifiedVersion =  nEntries;
								}
							}

							if ( pJVM[nEntries].mVersion >=  pJVM[nBestVersion].mVersion )
								nBestVersion = nEntries;

							nEntries++;
						}
					}
				}
				RegCloseKey(hKey);
			}
			dwIndex ++;
			nNameLen = sizeof(buffer);
		}
		RegCloseKey(hRoot);
	}

	/* Next try Java Development Kit */
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, HKEY_SUN_JDK, 0, KEY_ENUMERATE_SUB_KEYS, &hRoot) == ERROR_SUCCESS)
	{
		DWORD dwIndex = 0;
		DWORD nNameLen;
		char buffer[1024];

		FILETIME fileTime;

		nNameLen = sizeof(buffer);

		while (RegEnumKeyEx(hRoot, dwIndex, buffer, &nNameLen, NULL, NULL, NULL, &fileTime) != ERROR_NO_MORE_ITEMS)
		{
			if (RegOpenKeyEx(hRoot, buffer, 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
			{
				strcpy(Version, buffer);
				dwBytes = sizeof(Home);

				if (RegQueryValueEx(hKey, "JavaHome", 0, &dwType, (unsigned char*) Home, &dwBytes) == ERROR_SUCCESS)
				{
					// check if there was already an entry that points to the same directory.
					if( checkForDoubleEntry( pJVM, nEntries, Home) )
					{

						dwBytes = sizeof(buffer);

						/* complete version information */
						if ( (strlen(Version) < 4) &&
							 (RegQueryValueEx(hKey, "MicroVersion", 0, &dwType, (unsigned char*) buffer, &dwBytes) == ERROR_SUCCESS))
						{
							strcat(Version, ".");
							strcat(Version, buffer);
						}

						if (aJavaInstProps[REQUIRED_VERSION] <= Version )
						{
							/* build path to runtimelib */
							strcpy(RuntimeLib, Home);

							if ( ByteString("1.2") > Version )
							{	// JDK 1.1.X
								strcat(RuntimeLib, "\\bin\\javai.dll");
								strcpy(Classes, Home);
								strcat(Classes, "\\lib\\classes.zip;");
								strcat(Classes, Home);
								strcat(Classes, "\\lib");
							}
							else if ( ByteString("1.3") > Version)
							{	// JDK 1.2.X
								strcat(RuntimeLib, "\\jre\\bin\\classic\\jvm.dll");
								strcpy(Classes, "");
							}
							else if( ByteString("1.4") > Version)
							{
								ByteString sRuntimeLibCheck(RuntimeLib);
								sRuntimeLibCheck += "\\bin\\hotspot\\jvm.dll";  // JRE 1.3.x
								if (ExistFile(sRuntimeLibCheck))
								{
									strcpy( RuntimeLib, sRuntimeLibCheck.GetBuffer());
								}
								else
								{
									// there is a JDK but no JRE
									strcat( RuntimeLib, "\\jre\\bin\\hotspot\\jvm.dll");  // JRE 1.3.x
								}
							}
							else
							{	// JDK 1.3.X
								strcat(RuntimeLib, "\\jre\\bin\\client\\jvm.dll");
                                strcpy(Classes, ";");
								strcat(Classes, Home);
								strcat(Classes, "\\lib\\ext\access-bridge.jar");
							}


							pJVM[nEntries].mVendor			= "SUN";
							pJVM[nEntries].mName			= "Java Development Kit";
							pJVM[nEntries].mEnvType         = JDK_TYPE;
							pJVM[nEntries].mHome			= Home;
							pJVM[nEntries].mVersion			= Version;
							pJVM[nEntries].mRuntimeLib		= RuntimeLib;
							pJVM[nEntries].mClasspath		= Classes;
							pJVM[nEntries].bIsVerified		= aJavaInstProps[VERIFIED_VERSION].Search( Version ) != STRING_NOTFOUND;
							pJVM[nEntries].bIsBestVersion	= FALSE;

							if ( pJVM[nEntries].bIsVerified )
							{
								if ( nBestVerifiedVersion == -1 )
									nBestVerifiedVersion = nEntries;
								else
								{
									if ( pJVM[nEntries].mVersion >=  pJVM[nBestVerifiedVersion].mVersion )
										nBestVerifiedVersion =  nEntries;
								}
							}

							if ( pJVM[nEntries].mVersion >=  pJVM[nBestVersion].mVersion )
								nBestVersion = nEntries;

							nEntries++;
						}
					}
				}
				RegCloseKey(hKey);
			}
			dwIndex ++;
			nNameLen = sizeof(buffer);
		}
		RegCloseKey(hRoot);
	}

#ifdef IBM_JAVA_VM

	/* First try Java Runtime Environment */
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, HKEY_IBM_JRE_1, 0, KEY_ENUMERATE_SUB_KEYS, &hRoot) == ERROR_SUCCESS)
	{
		DWORD dwIndex = 0;
		DWORD nNameLen;
		char buffer[1024];

		FILETIME fileTime;


		nNameLen = sizeof(buffer);

		while (RegEnumKeyEx(hRoot, dwIndex, buffer, &nNameLen, NULL, NULL, NULL, &fileTime) != ERROR_NO_MORE_ITEMS)
		{
			if (RegOpenKeyEx(hRoot, buffer, 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
			{
				strcpy(Version, buffer);
				dwBytes = sizeof(Home);

				if (RegQueryValueEx(hKey, "JavaHome", 0, &dwType, (unsigned char*) Home, &dwBytes) == ERROR_SUCCESS)
				{
					dwBytes = sizeof(buffer);

					/* complete version information */
					if ( (strlen(Version) < 4 ) &&
						(RegQueryValueEx(hKey, "MicroVersion", 0, &dwType, (unsigned char*) buffer, &dwBytes) == ERROR_SUCCESS)
					   )
					{
						strcat(Version, ".");
						strcat(Version, buffer);
					}

					if (aJavaInstProps[REQUIRED_VERSION] <= Version )
					{

						/* build path to runtimelib */
						strcpy(RuntimeLib, Home);
						if ( ByteString("1.2") > Version )
							strcat(RuntimeLib, "\\bin\\javai.dll");			// JRE 1.1.x
						else if( ByteString("1.3") > Version)
							strcat(RuntimeLib, "\\bin\\classic\\jvm.dll");  // JRE 1.2.x
						else if( ByteString("1.4") > Version)
							strcat( RuntimeLib, "\\bin\\hotspot\\jvm.dll");  // JRE 1.3.x
						else
							strcat( RuntimeLib, "\\bin\\client\\jvm.dll");  // JRE 1.4

						/* build default classpath */
						strcpy(Classes, "");

						pJVM[nEntries].mVendor			= "IBM";
						pJVM[nEntries].mName			= "Java Runtime Environment";
						pJVM[nEntries].mEnvType         = JRE_TYPE;
						pJVM[nEntries].mHome			= Home;
						pJVM[nEntries].mVersion			= Version;
						pJVM[nEntries].mRuntimeLib		= RuntimeLib;
						pJVM[nEntries].mClasspath		= Classes;
						pJVM[nEntries].bIsVerified		= aJavaInstProps[VERIFIED_VERSION].Search( Version ) != STRING_NOTFOUND;
						pJVM[nEntries].bIsBestVersion	= FALSE;

						if ( pJVM[nEntries].bIsVerified )
							if ( nBestVerifiedVersion == -1 )
								nBestVerifiedVersion = nEntries;
							else
								if ( pJVM[nEntries].mVersion >=  pJVM[nBestVerifiedVersion].mVersion )
									nBestVerifiedVersion =  nEntries;

						if ( pJVM[nEntries].mVersion >=  pJVM[nBestVersion].mVersion )
							nBestVersion = nEntries;

						nEntries++;
					}
				}
				RegCloseKey(hKey);
			}
			dwIndex ++;
			nNameLen = sizeof(buffer);
		}
		RegCloseKey(hRoot);
	}

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, HKEY_IBM_JRE_2, 0, KEY_ENUMERATE_SUB_KEYS, &hRoot) == ERROR_SUCCESS)
	{
		DWORD dwIndex = 0;
		DWORD nNameLen;
		char buffer[1024];

		FILETIME fileTime;


		nNameLen = sizeof(buffer);

		while (RegEnumKeyEx(hRoot, dwIndex, buffer, &nNameLen, NULL, NULL, NULL, &fileTime) != ERROR_NO_MORE_ITEMS)
		{
			if (RegOpenKeyEx(hRoot, buffer, 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
			{
				strcpy(Version, buffer);
				dwBytes = sizeof(Home);

				if (RegQueryValueEx(hKey, "JavaHome", 0, &dwType, (unsigned char*) Home, &dwBytes) == ERROR_SUCCESS)
				{
					dwBytes = sizeof(buffer);

					/* complete version information */
					if ( (strlen(Version) < 4 ) &&
						(RegQueryValueEx(hKey, "MicroVersion", 0, &dwType, (unsigned char*) buffer, &dwBytes) == ERROR_SUCCESS)
					   )
					{
						strcat(Version, ".");
						strcat(Version, buffer);
					}

					if (aJavaInstProps[REQUIRED_VERSION] <= Version )
					{

						/* build path to runtimelib */
						strcpy(RuntimeLib, Home);
						if ( ByteString("1.2") > Version )
							strcat(RuntimeLib, "\\bin\\javai.dll");			// JRE 1.1.x
						else if( ByteString("1.3") > Version)
							strcat(RuntimeLib, "\\bin\\classic\\jvm.dll");  // JRE 1.2.x
						else if( ByteString("1.4") > Version)
							strcat( RuntimeLib, "\\bin\\hotspot\\jvm.dll");  // JRE 1.3.x
						else
							strcat( RuntimeLib, "\\bin\\client\\jvm.dll");  // JRE 1.4

						/* build default classpath */
						strcpy(Classes, "");

						pJVM[nEntries].mVendor			= "IBM";
						pJVM[nEntries].mName			= "Java Runtime Environment";
						pJVM[nEntries].mEnvType         = JRE_TYPE;
						pJVM[nEntries].mHome			= Home;
						pJVM[nEntries].mVersion			= Version;
						pJVM[nEntries].mRuntimeLib		= RuntimeLib;
						pJVM[nEntries].mClasspath		= Classes;
						pJVM[nEntries].bIsVerified		= aJavaInstProps[VERIFIED_VERSION].Search( Version ) != STRING_NOTFOUND;
						pJVM[nEntries].bIsBestVersion	= FALSE;

						if ( pJVM[nEntries].bIsVerified )
						{
							if ( nBestVerifiedVersion == -1 )
								nBestVerifiedVersion = nEntries;
							else
							{
								if ( pJVM[nEntries].mVersion >=  pJVM[nBestVerifiedVersion].mVersion )
									nBestVerifiedVersion =  nEntries;
							}
						}

						if ( pJVM[nEntries].mVersion >=  pJVM[nBestVersion].mVersion )
							nBestVersion = nEntries;

						nEntries++;
					}
				}
				RegCloseKey(hKey);
			}
			dwIndex ++;
			nNameLen = sizeof(buffer);
		}
		RegCloseKey(hRoot);
	}


	/* Next try Java Development Kit */
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, HKEY_IBM_JDK, 0, KEY_ENUMERATE_SUB_KEYS, &hRoot) == ERROR_SUCCESS)
	{
		DWORD dwIndex = 0;
		DWORD nNameLen;
		char buffer[1024];

		FILETIME fileTime;

		nNameLen = sizeof(buffer);

		while (RegEnumKeyEx(hRoot, dwIndex, buffer, &nNameLen, NULL, NULL, NULL, &fileTime) != ERROR_NO_MORE_ITEMS)
		{
			if (RegOpenKeyEx(hRoot, buffer, 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
			{
				strcpy(Version, buffer);
				dwBytes = sizeof(Home);

				if (RegQueryValueEx(hKey, "JavaHome", 0, &dwType, (unsigned char*) Home, &dwBytes) == ERROR_SUCCESS)
				{
					dwBytes = sizeof(buffer);

					/* complete version information */
					if ( (strlen(Version) < 4) &&
						(RegQueryValueEx(hKey, "MicroVersion", 0, &dwType, (unsigned char*) buffer, &dwBytes) == ERROR_SUCCESS))
					{
						strcat(Version, ".");
						strcat(Version, buffer);
					}

					if (aJavaInstProps[REQUIRED_VERSION] <= Version )
					{
						/* build path to runtimelib */
						strcpy(RuntimeLib, Home);

						if ( ByteString("1.2") > Version )
						{	// JDK 1.1.X
							strcat(RuntimeLib, "\\bin\\javai.dll");

							/* build default classpath */
							strcpy(Classes, Home);
							strcat(Classes, "\\lib\\classes.zip;");
							strcat(Classes, Home);
							strcat(Classes, "\\lib");
						}
						else if( ByteString("1.3") > Version)
						{	// JDK 1.2.X

							strcat(RuntimeLib, "\\jre\\bin\\classic\\jvm.dll");
							/* build default classpath */
							strcpy(Classes, "");
						}
						else if( ByteString("1.4") > Version)
						{
							strcat( RuntimeLib, "\\bin\\hotspot\\jvm.dll");  // JRE 1.3.x
						}
						else
						{	// JDK 1.3.X
							strcat(RuntimeLib, "\\jre\\bin\\client\\jvm.dll");
							strcpy(Classes, "");
						}


						pJVM[nEntries].mVendor			= "IBM";
						pJVM[nEntries].mName			= "Java Development Kit";
						pJVM[nEntries].mEnvType         = JDK_TYPE;
						pJVM[nEntries].mHome			= Home;
						pJVM[nEntries].mVersion			= Version;
						pJVM[nEntries].mRuntimeLib		= RuntimeLib;
						pJVM[nEntries].mClasspath		= Classes;
						pJVM[nEntries].bIsVerified		= aJavaInstProps[VERIFIED_VERSION].Search( Version ) != STRING_NOTFOUND;
						pJVM[nEntries].bIsBestVersion	= FALSE;

						if ( pJVM[nEntries].bIsVerified )
						{
							if ( nBestVerifiedVersion == -1 )
								nBestVerifiedVersion = nEntries;
							else
							{
								if ( pJVM[nEntries].mVersion >=  pJVM[nBestVerifiedVersion].mVersion )
									nBestVerifiedVersion =  nEntries;
							}
						}

						if ( pJVM[nEntries].mVersion >=  pJVM[nBestVersion].mVersion )
							nBestVersion = nEntries;

						nEntries++;
					}
				}
				RegCloseKey(hKey);
			}
			dwIndex ++;
			nNameLen = sizeof(buffer);
		}
		RegCloseKey(hRoot);
	}

#endif

#ifdef MS_JAVA_VM

	/* Last try Microsoft Java VM */
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, HKEY_MS_JRE, 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
	{
		char buffer[1024];

		GetSystemDirectory(RuntimeLib, sizeof(RuntimeLib));

		//strcpy(RuntimeLib, "msjava.dll"); //msjava.dll should be found in path (default system directory)
		if (RuntimeLib[strlen(RuntimeLib) - 1] != '\\')
			strcat(RuntimeLib, "\\msjava.dll");

		//if (access(RuntimeLib, 0) == -1)		// file does not exists in system directory
		//   strcpy(RuntimeLib, "msjava.dll");	// then it should be found in path

		dwBytes = sizeof(Home);

		if (RegQueryValueEx(hKey, "LibsDirectory", 0, &dwType, (unsigned char*) Home, &dwBytes) == ERROR_SUCCESS)
		{
			char *pChr;
			HKEY hActiveSetupKey;

			/* remove trail																																																																																																																																																																																																																																																																																																																																																																																																						ing 'lib'-subdirectory */
			if ((pChr = strrchr(Home, '\\')) != NULL)
				*pChr = '\0';

			dwBytes = sizeof(buffer);
			if (RegQueryValueEx(hKey, "Classpath", 0, &dwType, (unsigned char*) buffer, &dwBytes) == ERROR_SUCCESS)
			{
				strcpy(Classes, buffer);
			}

			dwBytes = sizeof(Version);
			strcpy(Version, "unknown");

			if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,
							"Software\\Microsoft\\Active Setup\\Installed Components",
							0,
							KEY_ENUMERATE_SUB_KEYS, &hActiveSetupKey
				) == ERROR_SUCCESS)
			{
				DWORD dwIndex = 0;
				DWORD nNameLen;
				char componentID[1024];

				BOOL bVMFound = FALSE;
				LONG result = 0;
				FILETIME fileTime;

				nNameLen = sizeof(buffer);
				dwBytes = sizeof(componentID);

				while (!bVMFound && (RegEnumKeyEx(hActiveSetupKey, dwIndex, buffer, &nNameLen, NULL, NULL, NULL, &fileTime) != ERROR_NO_MORE_ITEMS))
				{
					HKEY hSubKey;

					if (RegOpenKeyEx(hActiveSetupKey, buffer, 0, KEY_QUERY_VALUE, &hSubKey) == ERROR_SUCCESS)
					{
						if (RegQueryValueEx(hSubKey, "ComponentID", 0, &dwType, (unsigned char*) componentID, &dwBytes) == ERROR_SUCCESS)
						{
							if (strcmp(componentID, "JAVAVM") == 0)
							{
								dwBytes = sizeof(Version);

								if (RegQueryValueEx(hSubKey, "Version", 0, &dwType, (unsigned char*) Version, &dwBytes) != ERROR_SUCCESS)
								{
									strcpy(Version, "unknown");
								}

								bVMFound = TRUE;
							}
						}
						RegCloseKey(hSubKey);
					}

					dwIndex ++;
					if (!bVMFound)
						nNameLen = sizeof(buffer);
				}
			}

			RegCloseKey(hActiveSetupKey);

			if (validVersion <= Version )
			{
				pJVM[nEntries].mVendor			= "Microsoft"
				pJVM[nEntries].mName			= "Java Runtime Environment";
				pJVM[nEntries].mEnvType         = JRE_TYPE;
				pJVM[nEntries].mHome			= Home;
				pJVM[nEntries].mVersion			= Version;
				pJVM[nEntries].mRuntimeLib		= RuntimeLib;
				pJVM[nEntries].mClasspath		= Classes;
				pJVM[nEntries].bIsVerified		= aJavaInstProps[VERIFIED_VERSION].Search( Version ) != STRING_NOTFOUND;
				pJVM[nEntries].bIsBestVersion	= FALSE;

				nEntries++;
			}
		}

		RegCloseKey(hKey);
	}

#endif //MS_JAVA_VM

	if ( nEntries )
		if ( nBestVerifiedVersion != -1 )
			pJVM[nBestVerifiedVersion].bIsBestVersion = TRUE;
		else
			pJVM[nBestVersion].bIsBestVersion = TRUE;


	return nEntries;
}

BOOL GetInstalledVM( JVMEntry& entry, const ByteString destPath )
{
	// die Funktion sucht nach dem Registry-Eintrag des gerade installierten JRE, das mitgeliefert wird.

	HKEY hRoot, hKey;

	/* First try Java Runtime Environment */
	if (RegOpenKeyEx( HKEY_LOCAL_MACHINE, HKEY_SUN_JRE, 0, KEY_QUERY_VALUE, &hRoot) == ERROR_SUCCESS)
	{
		char	buffer [MAX_PATH];

		DWORD	dwType;
		DWORD	dwBytes;

		dwBytes = sizeof( buffer );
		if (RegQueryValueEx(hRoot, "CurrentVersion", 0, &dwType, (unsigned char*) buffer, &dwBytes) == ERROR_SUCCESS)
		{
			entry.mVersion = buffer;
			if (RegOpenKeyEx(hRoot, buffer, 0, KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
			{
				dwBytes = sizeof( buffer );
				if (RegQueryValueEx(hKey, "JavaHome", 0, &dwType, (unsigned char*) buffer, &dwBytes) == ERROR_SUCCESS)
				{
					entry.mHome = buffer;
					dwBytes = sizeof( buffer );

					if (RegQueryValueEx(hKey, "MicroVersion", 0, &dwType, (unsigned char*) buffer, &dwBytes) == ERROR_SUCCESS)
					{
						entry.mVersion += ".";
						entry.mVersion += buffer;

						entry.mRuntimeLib	= entry.mHome;
						entry.mName			= "Java Runtime Environment";

						if ( ByteString("1.2") > entry.mVersion )
							entry.mRuntimeLib += "\\bin\\javai.dll"; // JRE 1.1.x
						else if ( ByteString("1.3") > entry.mVersion)
							entry.mRuntimeLib += "\\bin\\classic\\jvm.dll";  // JRE 1.2.x
						else if( ByteString("1.4") > entry.mVersion)
							entry.mRuntimeLib += "\\bin\\hotspot\\jvm.dll";  // JRE 1.3.x
						else
							entry.mRuntimeLib += "\\bin\\client\\jvm.dll";

						/* build default classpath */
/*						entry.mClasspath = entry.mHome;
						entry.mClasspath += "\\lib\\rt.jar;";
						entry.mClasspath += entry.mHome;
						entry.mClasspath += "\\lib\\i18n.jar;";
						entry.mClasspath += entry.mHome;
						entry.mClasspath += "\\lib";
*/
						entry.bIsVerified = aJavaInstProps[VERIFIED_VERSION].Search( entry.mVersion ) != STRING_NOTFOUND;
						entry.bIsBestVersion = TRUE;

						return TRUE;
					}
				}

				RegCloseKey( hKey );
			}
			RegCloseKey( hRoot );
		}
	}
	return FALSE;
}


BOOL CheckJava( JVMEntry& entry )
{
	BOOL bResult = FALSE;

	BOOL bIsJRE = FALSE;

	if ( entry.mHome.Len() )
	{
		ByteString exec = entry.mHome;
		exec += "\\bin\\java.exe";
		if ( SiDirEntry(exec).Exists() )
		{
			// seems to be JDK
			entry.mVendor	= "SUN";
			entry.mName		= "Java Development Kit";
			bIsJRE			= FALSE;
			exec += " -version";
			bResult = GetVersion( exec,  entry.mVersion );

			if ( bResult && !( entry.mVersion < ByteString("1.2") ) )
			{
				ByteString classes = entry.mHome;
				classes += "\\lib\\tools.jar";

				if (!SiDirEntry(classes).Exists()) // the JRE in 1.2 called with java
				{
					entry.mName		= "Java Runtime Environment";
					bIsJRE			= TRUE;
				}
			}
		}
		else
		{
			// seems to be JRE
			exec = entry.mHome;
			exec += "\\bin\\jre.exe";
			if ( SiDirEntry(exec).Exists() )
			{
				entry.mVendor	= "SUN";
				entry.mName		= "Java Runtime Environment";
				bIsJRE			= TRUE;
				bResult = GetVersion( exec,  entry.mVersion );
			}
		}
	}

	if ( entry.mVersion < aJavaInstProps[REQUIRED_VERSION] )
		bResult = FALSE;
	else
		bResult = GetRuntime(entry.mHome, entry.mVersion, bIsJRE, entry.mRuntimeLib );

	if ( bResult )
	   bResult = GetClasspath( entry.mHome, entry.mVersion, bIsJRE, entry.mClasspath );

	entry.bIsVerified = aJavaInstProps[VERIFIED_VERSION].Search( entry.mVersion ) != STRING_NOTFOUND;

	return bResult;
}

BOOL GetRuntime(ByteString home, ByteString version, BOOL isJRE, ByteString& runtime)
{
	runtime = home;
	if ( ByteString("1.2") > version )
		runtime += "\\bin\\javai.dll";			// JRE 1.1.x
	else
		if ( isJRE )
		{
			runtime += "\\bin\\classic\\jvm.dll";	// JRE 1.2.x
			if( !SiDirEntry(runtime).Exists() )
			{
				runtime = home;
				runtime += "\\bin\\client\\jvm.dll";	// JRE 1.3.x
			}
		}
		else
		{
			runtime += "\\jre\\bin\\classic\\jvm.dll";	// JRE 1.2.x
			if( !SiDirEntry(runtime).Exists() )
			{
				runtime = home;
				runtime += "\\bin\\client\\jvm.dll";	// JRE 1.3.x
			}
		}

		return SiDirEntry(runtime).Exists();
}


BOOL GetClasspath( ByteString home, ByteString version, BOOL isJRE, ByteString& classpath )
{
	ByteString classes = home;

	if ( ByteString("1.2") > version ) //1.1
	{
		if ( isJRE )
		{
/*			classes += "\\lib\\rt.jar";

			if ( !SiDirEntry(classes).Exists() )
				return FALSE;

			classpath = classes;
			classpath += ";";

			classes = home;
			classes += "\\lib\\i18n.jar";

			if ( SiDirEntry(classes).Exists() )
			{
				classpath += classes;
				classpath += ";";
			}

			classpath += home;
			classpath += "\\lib";
*/		}
		else
		{
			classes += 	"\\lib\\classes.zip";

			if ( !SiDirEntry(classes).Exists() )
				return FALSE;

			classpath = classes;
			classpath += ";";
/*			classpath += home;
			classpath += "\\lib";
*/		}
	}
	else // 1.2
	{
		if ( isJRE ) // JRE 1.2
		{
/*			classes = home;
			classes += "\\lib\\rt.jar";

			if ( !SiDirEntry(classes).Exists() )
				return FALSE;

			classpath = classes;
			classpath += ";";

			classes = home;
			classes += "\\lib\\i18n.jar";


			if ( SiDirEntry(classes).Exists() )
			{
				classpath += classes;
				classpath += ";";
			}

			classpath += home;
			classpath += "\\lib";
*/		}
		else // JDK 1.2
		{
/*			classes = home;
			classes += "\\jre\\lib\\rt.jar";

			if ( !SiDirEntry(classes).Exists() )
				return FALSE;

			classpath = classes;
			classpath += ";";

			classes = home;
			classes += "\\jre\\lib\\i18n.jar";

			if ( SiDirEntry(classes).Exists() )
			{
				classpath += classes;
				classpath += ";";
			}

			classpath += home;
			classpath += "\\lib\\tools.jar;";
			classpath += home;
			classpath += "\\lib\\dt.jar;";
			classpath += home;
			classpath += "\\lib";
*/		}

	}

	return TRUE;

}

BOOL GetVersion( ByteString aCommand, ByteString& version )
{
	HANDLE	hChildStdoutRd, hChildStdoutWr, hChildStdoutRdDup,
			hSaveStdout, hSaveStderr;

	BOOL fSuccess;

	PROCESS_INFORMATION piProcInfo;
	STARTUPINFO siStartInfo;

	char command[MAX_PATH];

	SECURITY_ATTRIBUTES saAttr;
	saAttr.nLength = sizeof(SECURITY_ATTRIBUTES);
	saAttr.bInheritHandle = TRUE;
	saAttr.lpSecurityDescriptor = NULL;

	hSaveStdout = GetStdHandle( STD_OUTPUT_HANDLE );
	hSaveStderr = GetStdHandle( STD_ERROR_HANDLE );

	// Create a pipe for the child process's STDOUT.
	if (! CreatePipe(&hChildStdoutRd, &hChildStdoutWr, &saAttr, 0))
		return FALSE;

	// Set a write handle to the pipe to be STDOUT.
	if (! SetStdHandle(STD_OUTPUT_HANDLE, hChildStdoutWr))
		return FALSE;

	// Set a write handle to the pipe to be STDERR.
	if (! SetStdHandle(STD_ERROR_HANDLE, hChildStdoutWr))
	{
		// restore STDOUT
		SetStdHandle(STD_OUTPUT_HANDLE, hSaveStdout);
		return FALSE;
	}

	// Create noninheritable read handle and close the inheritable read
	// handle.
	fSuccess = DuplicateHandle(GetCurrentProcess(), hChildStdoutRd,
		GetCurrentProcess(), &hChildStdoutRdDup , 0,
		FALSE,
		DUPLICATE_SAME_ACCESS);

	if( !fSuccess )
		return FALSE;

	CloseHandle( hChildStdoutRd );

	// Set up members of STARTUPINFO structure.
	ZeroMemory( &siStartInfo, sizeof(STARTUPINFO) );

	siStartInfo.hStdOutput = hChildStdoutWr;
	siStartInfo.hStdError  = hChildStdoutWr;
	siStartInfo.wShowWindow = SW_SHOWMINIMIZED;
	siStartInfo.dwFlags	   += STARTF_USESTDHANDLES + STARTF_USESHOWWINDOW;


	siStartInfo.cb = sizeof(STARTUPINFO);

	// Create the child process.

	strcpy( command, aCommand.GetBuffer() );

	fSuccess = CreateProcess(NULL,
			command,       // command line
			NULL,          // process security attributes
			NULL,          // primary thread security attributes
			TRUE,          // handles are inherited
			0,             // creation flags
			NULL,          // use parent's environment
			NULL,          // use parent's current directory
			&siStartInfo,  // STARTUPINFO pointer
			&piProcInfo);  // receives PROCESS_INFORMATION

	if ( fSuccess )
	{
		DWORD dwRead;
		CHAR chBuf[16000];
		memset( chBuf, 0, 16000 );

		//HANDLE hStdout = GetStdHandle(STD_OUTPUT_HANDLE);

		// Close the write end of the pipe before reading from the
		// read end of the pipe.

		CloseHandle( hChildStdoutWr );
		// Read output from the child process, and write to parent's STDOUT.

		if ( ReadFile( hChildStdoutRdDup, chBuf, 256, &dwRead, NULL) )
		{

			USHORT nIndex;
			ByteString aOutLine( chBuf );
			aOutLine.ToLowerAscii();

			if ( (nIndex = aOutLine.Search( "version" )) == STRING_NOTFOUND )
				version = "unknown";
			else
			{
				aOutLine.Erase(0, nIndex + ByteString("version").Len() );
				if ( (nIndex = aOutLine.Search( '\n' )) != STRING_NOTFOUND )
					aOutLine.Erase( nIndex );
				aOutLine.EraseAllChars( ); // remove all spaces
				aOutLine.EraseAllChars('\"' ); // remove all "
				aOutLine.EraseAllChars('\n' );
				aOutLine.EraseAllChars('\r' );

				version = aOutLine;
			}

			for (;;)
			{
				if( !ReadFile( hChildStdoutRdDup, chBuf, 256, &dwRead,
					NULL) || dwRead == 0) break;
			}
		}
	}

	//restore STDOUT & STDERR
	SetStdHandle(STD_OUTPUT_HANDLE, hSaveStdout);
	SetStdHandle(STD_ERROR_HANDLE, hSaveStderr);

	return fSuccess;
}

