/*************************************************************************
 *
 *  $RCSfile: registrywnt.cxx,v $
 *
 *  $Revision: 1.1.2.3 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:47:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//---------------------------------------
// 
//---------------------------------------
 
#include <malloc.h>
#include "registrywnt.hxx"

//---------------------------------------
//
//---------------------------------------

using rtl::OUString;

//---------------------------------------
// 
//---------------------------------------

const sal_Int32 MAX_TMP_BUFF_SIZE = 1024 * sizeof(sal_Unicode);

//---------------------------------------
// 
//---------------------------------------

CRegistryKeyWNt::CRegistryKeyWNt( HKEY hRootKey, const OUString& aSubKeyName, REGSAM samDesired ) :
    CRegistryKey( hRootKey, aSubKeyName, samDesired )    
{    
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyWNt::Create()
{
    OSL_PRECOND( m_hRootKey, "invalid root key" );

    DWORD dwDisp;

    LONG rc = RegCreateKeyExW(
        m_hRootKey,
        m_SubKeyName.getStr(),
        0,
        L"",
        REG_OPTION_NON_VOLATILE,
        m_samDesired,
        NULL,
        &m_hSubKey,
        &dwDisp );

    return rc;
}

//---------------------------------------
//
//---------------------------------------

LONG CRegistryKeyWNt::DeleteRecursively(HKEY hRootKey, const wchar_t* lpKeyName)
{
	OSL_PRECOND(hRootKey && lpKeyName && wcslen(lpKeyName),"DeleteRecursive: Invalid parameter");

	HKEY hKey;

	int rc = RegOpenKeyExW(
		hRootKey,
		lpKeyName,
		0,
		KEY_READ | DELETE,
		&hKey);
	
	if (ERROR_SUCCESS == rc)
	{	
		wchar_t* lpSubKey;
		DWORD    nMaxSubKeyLen;

		rc = RegQueryInfoKeyW(
			hKey, 0, 0, 0, 0,
			&nMaxSubKeyLen,
			0, 0, 0, 0, 0, 0);
	
		nMaxSubKeyLen++; // space for trailing '\0'

		lpSubKey = reinterpret_cast<wchar_t*>(
			_alloca(nMaxSubKeyLen*sizeof(wchar_t)));

		while (ERROR_SUCCESS == rc)
        {
			DWORD nLen = nMaxSubKeyLen;

			rc = RegEnumKeyExW(
				hKey,
                0,       // always index zero
                lpSubKey,
                &nLen,
                0, 0, 0, 0);

            if (ERROR_NO_MORE_ITEMS == rc)
            {
				rc = RegDeleteKeyW(hRootKey, lpKeyName);
                break;
            }
            else if (rc == ERROR_SUCCESS)
			{
				rc = DeleteRecursively(hKey, lpSubKey);
			}

		} // while

        RegCloseKey(hKey);        

	} // if

	return rc;
}

//---------------------------------------
// RegDeleteKey doesn't work recursively
// under Win NT/2000/XP so we have to do
// it ourself see MS Knowledgebase article
// Q142491
//---------------------------------------

LONG CRegistryKeyWNt::Delete()
{
    if (IsOpen()) 
		Close();

    return DeleteRecursively(
		m_hRootKey, m_SubKeyName.getStr());
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyWNt::Open()
{
    OSL_PRECOND( m_hRootKey, "invalid root key" );
    OSL_PRECOND( !IsOpen(), "key already open" );
    
    LONG rc;

    if (!IsOpen())
        rc = RegOpenKeyExW( 
            m_hRootKey,
            m_SubKeyName.getStr(),
            0,
            m_samDesired,
            &m_hSubKey );

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyWNt::SetValue( const rtl::OUString& aValueName, const rtl::OUString& aValue )
{
    OSL_PRECOND( IsOpen(), "key not open or doesn't exist" );

    LONG rc = RegSetValueExW(
        m_hSubKey,
        aValueName.getStr(),
        0,
        REG_SZ,
        (BYTE*)aValue.getStr(),
        (aValue.getLength() + 1) * sizeof(sal_Unicode) );

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyWNt::SetValue( const OUString& aValueName, const OUString& aValue, const OUString& aFallbackValue )
{
    return SetValue( aValueName, aValue );
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyWNt::GetValue( const OUString& aValueName, OUString& aValue )
{    
    OSL_PRECOND( IsOpen(), "key not open or doesn't exist" );

    sal_Unicode* pBuff = reinterpret_cast<sal_Unicode*>(_alloca(MAX_TMP_BUFF_SIZE));
    DWORD dwSizeData = MAX_TMP_BUFF_SIZE;
    
    DWORD dwType;

    LONG rc = RegQueryValueExW(
        m_hSubKey,
        aValueName.getStr(),
        0,
        &dwType,
        (BYTE*)pBuff,
        &dwSizeData );

    if ( ERROR_SUCCESS == rc )
    {
		if (dwSizeData > 0)
		{
            //dwSizeData -= 1; // the returned size includes the terminating '\0'
            if (0 == pBuff[(dwSizeData/sizeof(sal_Unicode)) - 1]) // '\0' terminated
            	aValue = OUString(pBuff);
            else // not '\0' terminated
                aValue = OUString(pBuff, dwSizeData/sizeof(sal_Unicode));
		}
		else
		{
			aValue = OUString();
		}
    }

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyWNt::SetValue( const OUString& aValueName, const sal_Int32 aValue )
{
    OSL_PRECOND( IsOpen(), "key not open or doesn't exist" );

    LONG rc = RegSetValueExW(
        m_hSubKey,
        aValueName.getStr(),
        0,
        REG_DWORD,
        (BYTE*)&aValue,
        sizeof(sal_Int32) );

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyWNt::GetValue( const OUString& aValueName, int* pValue )
{
    OSL_PRECOND( pValue, "invalid parameter" );
    OSL_PRECOND( IsOpen(), "key not open or doesn't exist" );

    DWORD dwType;
    DWORD dwDataSize = sizeof(int);

    LONG rc = RegQueryValueExW(
        m_hSubKey,
        aValueName.getStr(),
        0,
        &dwType,
        (BYTE*)pValue,
        &dwDataSize );

    return rc;
}

//---------------------------------------
// 
//---------------------------------------

LONG CRegistryKeyWNt::DeleteValue( const OUString& aValueName )
{
    OSL_PRECOND( IsOpen(), "key not open or doesn't exist" );
    
    LONG rc = RegDeleteValueW(
        m_hSubKey,
        aValueName.getStr() );

    if ( ERROR_SUCCESS == rc )
        m_hSubKey = 0;

    return rc;
}
