/*************************************************************************
 *
 *  $RCSfile: sicustom.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: lla $ $Date: 2001/12/17 12:34:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#include <osl/thread.hxx>

#include "environ.hxx"

#include "custimpl.hxx"
#include "sicustom.hxx"

////////////////////////////////////////////////////////////////////////////////
//
//	SiCustomEnvironment
//
SiCustomEnvironment::SiCustomEnvironment()
{ pImpl = new EnvironmentImpl; }

SiCustomEnvironment::~SiCustomEnvironment()
{ delete pImpl; }

BOOL SiCustomEnvironment::IsResponseFileMode() const
{ return pImpl->bResponse; }

ByteString SiCustomEnvironment::GetResponseFileName()	const
{ return pImpl->aResponseFileName; }

BOOL SiCustomEnvironment::IsPre() const
{ return pImpl->bPre; }

BOOL SiCustomEnvironment::IsPost() const
{ return !pImpl->bPre; }

BOOL SiCustomEnvironment::IsInstallation() const
{ return pImpl->bInstallation; }

BOOL SiCustomEnvironment::IsDeinstallation() const
{ return !pImpl->bInstallation; }

BOOL SiCustomEnvironment::IsModify() const
{ return pImpl->bIsModify; }

BOOL SiCustomEnvironment::IsRepair() const
{ return pImpl->bIsRepair; }

BOOL SiCustomEnvironment::IsFirstInstallation()	const
{ return pImpl->bFirstInstallation; }

const ByteString& SiCustomEnvironment::GetStartPath() const
{ return pImpl->aStartPath; }

const ByteString& SiCustomEnvironment::GetSourcePath() const
{ return pImpl->aSourcePath; }

const ByteString& SiCustomEnvironment::GetDestPath() const
{ return pImpl->aDestPath; }

const ByteString& SiCustomEnvironment::GetInstalledPath() const
{ return pImpl->anInstalledPath; }

SiEnvironment* SiCustomEnvironment::GetBigEnv() const
{ return pImpl->pEnvPtr; }

SiCompiledScript* SiCustomEnvironment::GetCompiledScript() const
{ return pImpl->pCScript; }

void SiCustomEnvironment::SetPreFlag(BOOL bPre)
{ pImpl->bPre = bPre; }

void SiCustomEnvironment::SetInstallContext(BOOL bInst)
{ pImpl->bInstallation = bInst; }

void SiCustomEnvironment::SetModifyContext(BOOL bModify)
{ pImpl->bIsModify = bModify; }

void SiCustomEnvironment::SetRepairContext(BOOL bRepair)
{ pImpl->bIsRepair = bRepair; }

void SiCustomEnvironment::SetFirstInstallation(BOOL bNew)
{ pImpl->bFirstInstallation = bNew; }

void SiCustomEnvironment::SetStartPath(const ByteString& rStr)
{ pImpl->aStartPath = rStr; }

void SiCustomEnvironment::SetSourcePath(const ByteString& rStr)
{ pImpl->aSourcePath = rStr; }

void SiCustomEnvironment::SetDestPath(const ByteString& rStr)
{ pImpl->aDestPath = rStr; }

void SiCustomEnvironment::SetInstalledPath(const ByteString& rStr)
{ pImpl->anInstalledPath = rStr; }

void SiCustomEnvironment::SetResponse(BOOL bNew)
{ pImpl->bResponse = bNew; }

void SiCustomEnvironment::SetResponseFileName(const ByteString& rStr)
{ pImpl->aResponseFileName = rStr; }

void SiCustomEnvironment::SetEnvPtr(SiEnvironment* pPtr)
{ pImpl->pEnvPtr = pPtr; }

void SiCustomEnvironment::SetCompiledScript( SiCompiledScript* pCScript )
{ pImpl->pCScript = pCScript; }

UniString SiCustomEnvironment::getProductName() const 
{
	if (GetBigEnv())
	{
		return UniString( GetBigEnv()->GetSingleProductName(), osl_getThreadTextEncoding() );
	}
	return UniString();
}

////////////////////////////////////////////////////////////////////////////////
//
//	SiCustomModuleInfo
//
SiCustomModuleInfo::SiCustomModuleInfo()
{
	pImpl = new ModuleInfoImpl;
	pImpl->bSelected = FALSE;
	pImpl->bInstalled = FALSE;
}

SiCustomModuleInfo::~SiCustomModuleInfo()
{ delete pImpl; }

void SiCustomModuleInfo::SetModuleID(const ByteString& rStr)
{ pImpl->aModuleID = rStr; }

void SiCustomModuleInfo::SetModuleName(const ByteString& rStr)
{ pImpl->aModuleName = rStr; }

const ByteString& SiCustomModuleInfo::GetModuleID() const
{ return pImpl->aModuleID; }

const ByteString& SiCustomModuleInfo::GetModuleName() const
{ return pImpl->aModuleName; }

BOOL SiCustomModuleInfo::IsSelected() const
{ return pImpl->bSelected; }

BOOL SiCustomModuleInfo::IsInstalled() const
{ return pImpl->bInstalled; }

void SiCustomModuleInfo::SelectModule()
{ pImpl->bSelected = TRUE; }

void SiCustomModuleInfo::DeselectModule()
{ pImpl->bSelected = FALSE; }

void SiCustomModuleInfo::SetInstalled( BOOL bIsInstalled )
{ pImpl->bInstalled = bIsInstalled; }
