/*************************************************************************
 *
 *  $RCSfile: critical.cxx,v $
 *
 *  $Revision: 1.6.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 11:07:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef UNX
#include <unistd.h>
#endif

#ifdef WNT
#include <tools/prewin.h>
#include <windows.h>
#include <io.h>
#include <fcntl.h>
#include <tools/postwin.h>
#endif

#include <stdlib.h>
#include <stdio.h>

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "critical.hxx"

// We need some special code here, so we can write to stderr on windows, too
#ifdef WNT

static int WINAPI Setup_HandlerRoutine(
  DWORD dwCtrlType   //  control signal type
)
{
	switch ( dwCtrlType )
	{
	case CTRL_C_EVENT:
	case CTRL_BREAK_EVENT:
	case CTRL_CLOSE_EVENT:
		FreeConsole();
		return TRUE;
	default:
		return FALSE;
	}
}

extern "C" BOOL WINAPI Setup_InitializeConsole()
{
	BOOL	fSuccess = AllocConsole();

	if ( fSuccess )
	{
		HANDLE	hStdInput = GetStdHandle( STD_INPUT_HANDLE );
		HANDLE	hStdOutput = GetStdHandle( STD_OUTPUT_HANDLE );
		HANDLE	hStdError = GetStdHandle( STD_ERROR_HANDLE );

		*stdin = *_fdopen( _open_osfhandle( (long)hStdInput, _O_TEXT ), "r" );
		setvbuf( stdin, NULL, _IONBF, 0 );

		*stdout = *_fdopen( _open_osfhandle( (long)hStdOutput, _O_TEXT ), "w" );
		setvbuf( stdout, NULL, _IONBF, 0 );

		*stderr = *_fdopen( _open_osfhandle( (long)hStdError, _O_TEXT ), "w" );
		setvbuf( stderr, NULL, _IONBF, 0 );

		SetConsoleCtrlHandler( Setup_HandlerRoutine, TRUE );
	}

	return fSuccess;
}

#endif

Critical* static_Critical = NULL;

struct _ErrCode {
	USHORT		nCode;
	BOOL		bExit;
	int			nExit;
	char		cMsg[200];
};

static const _ErrCode aErrCodes[ERR_END] =
{
	// errcode							exit	exitcode	message
	{ ERR_NOERROR,						FALSE,	0,			"" },
	{ ERR_RESFILE_NOTFOUND,				TRUE,	1,			"resource file cannot be found" },

	{ ERR_RESPONSEFILE_NOTFOUND,		TRUE,	2,			"response file cannot be found" },
	{ ERR_WRONG_INSATALLATIONMODE,		TRUE,	3,	   		"illegal installationmode" },
	{ ERR_WRONG_INSATALLATIONTYPE,		TRUE,	4,	   		"illegal installationtype" },

	{ ERR_OLDSCRIPTVERSION,				TRUE,	5,	   		"script version to old" },
	{ ERR_WRONGPARAMETER,				TRUE,	6,	   		"wrong command line parameter" },
	{ ERR_SCRIPT_NOTFOUND,				TRUE,	7,	   		"setup script file cannot be found" },
	{ ERR_SETUPSCRIPT,					TRUE,	8,	   		"script error" },
	{ ERR_INSTALLINFOMISSING,			TRUE,	9,	   		"INSTALL_INFO flag is missing" },
	{ ERR_UIPROCNOTFOUND,				TRUE,	10,	   		"ui-procedure cannot be found" },
	{ ERR_NOMODULES,					TRUE,	11,	   		"no modules accessible" },
	{ ERR_NOUPDATEVERSIONFOUND,			TRUE,	12,	   		"update installation cannot be found" },
	{ ERR_NOUPDATETRYBUY,				TRUE,	13,	   		"no updates for try&buy versions" },
	{ ERR_XTERMNOTFOUND,				FALSE,	0,	   		"xterm cannot be found" },
	{ ERR_COULDNOTSTARTXTERM,			FALSE,	0,	   		"could not start xterm" },
	{ ERR_XTERMERRORCODE,				FALSE,	0,	   		"start xterm return errorcode" },
	{ ERR_INSTFILENOTFOUND,				TRUE,	14,	   		"installation file cannot be found" },
	{ ERR_COPY_FILE,					FALSE,	0,	   		"an error occurred while copying a file" },
	{ ERR_ZIP_FILE,				   		FALSE,	0,	   		"an error occured while unpacking a file" },
	{ ERR_MAKE_DIR,				   		FALSE,	0,	   		"an error occured while creating a directory" },
	{ ERR_NONETWORKINSTALLTION,			TRUE,	15,	   		"type WORKSTATION only possible on a netinstallation" },
	{ ERR_WHILEREADINGPROCEDURES,		TRUE,	16,	   		"error while reading PROCEDURE section" },
	{ ERR_VERSIONALLREADYINSTALLED,		TRUE,	17,	   		"version already installed" },
	{ ERR_NOFIRSTFREE,					TRUE,	18,			"<firstfree> wrong system" },
	{ ERR_NOHOME,						TRUE,	19,			"could not determine <home>" },
	{ ERR_DISK_FULL,					TRUE,	20,			"not enough space on the destination drive" },
	{ ERR_INVALID_DESTPATH,				TRUE,	21,			"invalid destination path" },
	{ ERR_MODULENOTFOUND,				TRUE,	22,			"module cannot be found" },
	{ ERR_VERSIONNOTINSTALLED,		 	TRUE,	23,			"need an installed version for this type" },
	{ ERR_INSTALLPROCEDURE_NOTFOUND, 	TRUE,	24,			"installprocedure cannot be found" },
	{ ERR_INSTALLMODULESET_NOTFOUND, 	TRUE,	25,			"installmoduleset cannot be found" },
	{ ERR_DEINSTALLPROCEDURE_NOTFOUND,	TRUE,	26,			"deinstallprocedure cannot be found" },
	{ ERR_DEINSTALLMODULESET_NOTFOUND,	TRUE,	27,			"deinstallmoduleset cannot be found" },

	{ ERR_INVALID_LICENSEKEY,  			TRUE,	28,			"wrong or invalid licensekey" },
	{ ERR_INVALID_LICENSE,  			TRUE,	29,			"invalid license" },

    { ERR_INVALID_APPLICAT_RDB,         TRUE,	30,			"applicat.rdb not found or damaged" },
};

Critical::Critical()
{
	bStdOut	= FALSE;
	bLog	= FALSE;
	bDebug  = FALSE;
	bNoExit = FALSE;
    bHasConsole = FALSE;
}

void Critical::WriteLog( ByteString& rMsg )
{
	if( bStdOut )
		fprintf( stderr, "%s\n", rMsg.GetBuffer() );

	SiFileStream aStream;
	aStream.Open( UniString::CreateFromAscii(aLogFile.GetBuffer()), STREAM_STD_WRITE );

	if( aStream.IsOpen() )
	{
		aStream.Seek( STREAM_SEEK_TO_END );
		rMsg.ConvertLineEnd();
		aStream << rMsg;
		aStream << '\n';
	}
}

void Critical::Error( USHORT nErrCode, const ByteString& rMsg )
{
	BOOL bExit = FALSE;
	int  nExit = 0;
	ByteString aErrMsg;
	for( USHORT i = 0; i <= ERR_END; ++i )
		if( aErrCodes[i].nCode == nErrCode )
		{
			nExit = aErrCodes[i].nExit;
			bExit = aErrCodes[i].bExit;

			aErrMsg = aErrCodes[i].cMsg;
			aErrMsg += "\nExitCode: ";
			aErrMsg += ByteString::CreateFromInt32(nExit);

			if( rMsg.Len() )
			{
				aErrMsg += "\n\n";
				aErrMsg += rMsg;
			}
			break;
		}

	if( bLog )
		WriteLog( aErrMsg );
	else
	{
        if( bStdOut )
        {
            #ifdef WNT
            if ( !bHasConsole )
                bHasConsole = Setup_InitializeConsole();
            #endif
            fprintf( stderr, "%s\n", aErrMsg.GetBuffer() );
        }
    }

	if( bDebug )
		ErrorBox(NULL, WB_OK, UniString::CreateFromAscii(aErrMsg.GetBuffer())).Execute();

	if( bExit && !bNoExit )
    {
        #ifdef WNT
        if ( bHasConsole )
        {
            fprintf( stderr, "\nPress <return> to continue.\n", aErrMsg.GetBuffer() );
            fgetc( stdin );
        }
        #endif
        #ifdef UNX
        _exit( nExit );
  	    #else
        exit( nExit );
        #endif
    }
}

void Critical::AllocStaticInstance()
{
	if( !static_Critical )
		static_Critical = new Critical();
}

void Critical::DeleteStaticInstance()
{
	if( !static_Critical )
		delete static_Critical;
}

Critical* Critical::GetStaticInstance()
{
	return static_Critical;
}
