/*************************************************************************
 *
 *  $RCSfile: main.cxx,v $
 *
 *  $Revision: 1.67.2.5 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 11:07:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef UNX
#include <unistd.h>
#endif

#include <stdlib.h>

#ifndef _SAL_MAIN_H_
#include <sal/main.h>
#endif

#ifndef _SV_HELP_HXX //autogen
#include <vcl/help.hxx>
#endif

#ifndef NOOLDSV //autogen
#include <vcl/system.hxx>
#endif

#include <sot/factory.hxx>

#ifndef _SV_RESMGR_HXX //autogen
#include <vcl/resmgr.hxx>
#endif

#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _PVER_HXX
#include <svtools/pver.hxx>
#endif

#include <tools/list.hxx>
#include <tools/rcid.h>

#if SUPD < 600
#ifndef SVTOOLS_TESTTOOL_HXX
#include <svtools/testtool.hxx>
#endif
#else
#ifndef AUTOMATION_HXX
#include <automation/automation.hxx>
#endif
#endif

#ifndef _OSL_MODULE_H_
#include <osl/module.h>
#endif
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif
#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include <com/sun/star/uno/XComponentContext.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>

#include <cppuhelper/bootstrap.hxx>

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::cppu;


#include "main.hxx"
#include "mainwnd.hxx"
#include "maindlg.hxx"
#include "arch.hxx"
#include "critical.hxx"
#include "script.hxx"
#include "sihelp.hxx"
#include "respfile.hxx"
#include "texec.hxx"

#include "agenda.hxx"
#include "environ.hxx"
#include "sibasic.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "infodlg.hxx"

#include <svtools/solar.hrc>
#include "strings.hrc"
#include "app.hrc"
#include "error.hrc"


#define WEBRESPONSE_FILENAME 			"response.ini"
#define WEBRESPONSE_SEC_INSTALLATION 	"Installation"
#define WEBRESPONSE_SEC_USERDATA	 	"UserData"
#define WEBRESPONSE_SEC_MODULE 		 	"Modules"

#define SETUP_ERROR_LOG_FILE 		 	"Setup_err.txt"
#define MAX_LOOKUPS                     5

static BOOL param_bAutoPilot			= FALSE;
static BOOL param_bEvil					= FALSE;
static BOOL param_bModuleDump			= FALSE;
static BOOL param_bRepair				= FALSE;
static BOOL param_bOfficeMode			= FALSE;
static ByteString param_aModuleSet;

const char SETUP_INI[]					= "setup.ini";
const char SETUP_TEMPFILE[] 			= "_setup.tmp";

#if defined(WIN) || defined(WNT)
char SETUP_SCRIPT_FILE[] 				= "setup.inf";
char SETUP_INSTDB_FILE[] 				= "instdb.inf";
#else
char SETUP_SCRIPT_FILE[] 				= "setup.ins";
char SETUP_INSTDB_FILE[] 				= "instdb.ins";
#endif



// ----------------------------------------------------------------------------

struct SetupEventData
{
    ULONG            m_nEvent;
    SetupEventData  *m_pNext;

    SetupEventData( ULONG nEvent ) { m_nEvent = nEvent; m_pNext = NULL; }
};

// ----------------------------------------------------------------------------

oslModule InitTestToolLib()
{
	OUString	aFuncName( RTL_CONSTASCII_USTRINGPARAM( "CreateRemoteControl" ));
	OUString	aModulePath;

	::vos::OStartupInfo().getExecutableFile( aModulePath );
	sal_uInt32 	lastIndex = aModulePath.lastIndexOf('/');
	if ( lastIndex > 0 )
		aModulePath = aModulePath.copy( 0, lastIndex+1 );

	aModulePath += OUString::createFromAscii( SVLIBRARY( "sts" ) );

	// Shortcut for Performance: We expect that the test tool library is not installed
	// (only for testing purpose). It should be located beside our executable.
	// We don't want to pay for searching through LD_LIBRARY_PATH so we check for
	// existence only in our executable path!!
	osl::DirectoryItem	aItem;
	osl::FileBase::RC	nResult = osl::DirectoryItem::get( aModulePath, aItem );

	if ( nResult == osl::FileBase::E_None )
	{
		oslModule aTestToolModule = osl_loadModule( aModulePath.pData, SAL_LOADMODULE_DEFAULT );
		if ( aTestToolModule )
		{
			void* pInitFunc = osl_getSymbol( aTestToolModule, aFuncName.pData );
			if ( pInitFunc )
				(*(pfunc_CreateRemoteControl)pInitFunc)();
		}

		return aTestToolModule;
	}

	return 0;
}

void DeInitTestToolLib( oslModule aTestToolModule )
{
	if ( aTestToolModule )
	{
		OUString	aFuncName( RTL_CONSTASCII_USTRINGPARAM( "DestroyRemoteControl" ));

		void* pDeInitFunc = osl_getSymbol( aTestToolModule, aFuncName.pData );
		if ( pDeInitFunc )
			(*(pfunc_DestroyRemoteControl)pDeInitFunc)();

		osl_unloadModule( aTestToolModule );
	}
}

// -----------------------------------------------------------------------

Evil::Evil()
{}

Evil::~Evil()
{}

void Evil::run()
{
	ULONG nsz = 1;
	while( TRUE )
	{
		char* foo = new char[nsz];
		memset( foo, 0x77, nsz );
		aList.Insert( foo, LIST_APPEND );
		nsz += 10;
		if( aList.Count() > 300 )
		{
			for( USHORT n = 0; n < aList.Count(); ++n )
				delete aList.GetObject(n);
				aList.Clear();
				nsz = 1;
		}
	}
}

// -----------------------------------------------------------------------

SetupApp::SetupApp()
		:m_pSecondResMgr(NULL)
{
	#if defined(OS2)
	if( Os2OS::DoesTempFileExists() )
	{
		Os2OS::KillTempFile();
		exit(0);
	}
	#endif

	m_pEvil1 = NULL;
	m_pEvil2 = NULL;
	m_pEvil3 = NULL;
	m_pEvil4 = NULL;
	m_pEvil5 = NULL;
	m_pEvil6 = NULL;
	m_pEvil7 = NULL;

	m_pMainWin			= NULL;
	m_bPerformInstall	= FALSE;
	m_bInterrupt		= FALSE;
	m_bParamDoCRCCheck	= FALSE;
	m_bOfficeMode		= FALSE;
	m_bResponseWizard	= FALSE;
    m_bNoVcl            = FALSE;

	m_nLanguage			= 0;
	m_nWorkStationCnt	= 0;
	m_nWorkStationIdx	= 0;

	#if defined WIN || defined WNT
	m_bShare            = TRUE;
	#endif

	m_pExecuter			= NULL;
	m_pExitAccel      	= NULL;
	m_pEnv            	= new SiEnvironment;
	m_pCompiledScript	= NULL;
	m_pOldCompiledScript = NULL;
	m_pResponseFile		= NULL;
    m_pFirstEvent       = NULL;

	pSetupApp 			= this;

	Critical::AllocStaticInstance();
	Critical::GetStaticInstance()->SetStdOut( FALSE );
}

SetupApp::~SetupApp()
{
	if( param_bEvil )
	{
		delete m_pEvil1;
		delete m_pEvil2;
		delete m_pEvil3;
		delete m_pEvil4;
		delete m_pEvil5;
		delete m_pEvil6;
		delete m_pEvil7;
	}

	if( m_pMainDlg )
	{
		Application::SetDefDialogParent( NULL );
		delete m_pMainDlg;
	}

	delete m_pEnv;
	delete m_pCompiledScript;

//	if( m_pOldCompiledScript )
//		delete m_pOldCompiledScript;

	if( m_pResponseFile )
	{
		delete m_pResponseFile;
		m_pResponseFile = NULL;
	}

	Critical::DeleteStaticInstance();
}

// -----------------------------------------------------------------------

SetupApp aSetupApp;
SetupApp *pSetupApp = &aSetupApp;

// -----------------------------------------------------------------------

void SetupApp::Main()
{
    // bootstrap an initial context and set it as process service manager
	// #91782#

    BOOL bHasApplicatProblems = FALSE;
    Reference<XMultiServiceFactory> xMS;

    try
    {
        Reference<XComponentContext> xComponentContext = defaultBootstrap_InitialComponentContext();
    	xMS.set(xComponentContext->getServiceManager(), UNO_QUERY);
    	comphelper::setProcessServiceFactory(xMS);
    }
    catch (::com::sun::star::uno::Exception e )
    {
        ByteString aError( UniString( e.Message ), (rtl_TextEncoding) RTL_TEXTENCODING_ASCII_US );
        Critical::GetStaticInstance()->SetLogFile( ByteString( SETUP_ERROR_LOG_FILE ) );
        Critical_Log( aError );
        bHasApplicatProblems = TRUE;
    }

	m_pResMan = LoadRessources();
	if( !m_pResMan )
	{
		Critical_Error( ERR_RESFILE_NOTFOUND, "" );
	}

	m_pEnv->InitStartPath();
	UniString aParamError = ReadParams();

	USHORT nResponseStep = m_pEnv->GetResponseStep();
    if( m_pEnv->GetResponseFilename().Len() &&
        ( ( nResponseStep == 1 ) || ( nResponseStep == 2 ) ) )
    {
        m_bNoVcl = TRUE;
		m_pEnv->SetHasVCL( FALSE );
    }
    else
    {
        #ifdef UNX
        #ifndef MACOSX
        extern unsigned char check_fontpath();
        if( check_fontpath() )
        {
            fprintf( stderr, "error in fontpath (salvaged)\n" );
        }
        #endif
        #endif
        InitVCL( xMS );
    }

    if( m_pEnv->GetResponseFilename().Len() )
		Critical::GetStaticInstance()->SetStdOut( TRUE );

	oslModule aTestToolModule = InitTestToolLib();
//	m_pRemoteControl = new RemoteControl;

	if ( ! m_bNoVcl )
    {
        Help::EnableBalloonHelp();
	    SetAccelerators();
	    EnableAutoHelpId();
    }

	m_pEnv->SetUILanguage( m_nLanguage );

	if ( ! m_bNoVcl )
    {
        m_pMainWin = new SetupWindow( m_pResMan );
        m_pMainWin->SetPen( Pen(PEN_NULL) );
    }

	if( aParamError.Len() )
	{
		ErrorBox aBox(NULL, WB_OK, aParamError);
		aBox.Execute();
		Quit();
	}

	if( param_bEvil )
	{
		m_pEvil1 = new Evil();
		m_pEvil2 = new Evil();
		m_pEvil3 = new Evil();
		m_pEvil4 = new Evil();
		m_pEvil5 = new Evil();
		m_pEvil6 = new Evil();
		m_pEvil7 = new Evil();

		m_pEvil1->create();
		m_pEvil2->create();
		m_pEvil3->create();
		m_pEvil4->create();
		m_pEvil5->create();
		m_pEvil6->create();
		m_pEvil7->create();
	}

	if( !FindAndReadScript() )
	{
		Exit();
		return;
	}

	if ( bHasApplicatProblems )
    {
        UniString anErrorText;

        if ( m_pEnv->IsFirstInstallation() )
            anErrorText = UniString( ResId( ERR_NO_APPLICAT_RDB ) );
        else
        {
            anErrorText = UniString( ResId( ERR_NO_APPLICAT_RDB_2 ) );
            anErrorText.SearchAndReplaceAll( UniString::CreateFromAscii("%1"),
                                             UniString( m_pEnv->GetSourcePath(),
                                                        osl_getThreadTextEncoding() ) );

        }

        ErrorBox aBox( GetAppWindow(), WB_OK, anErrorText );
        UniString aTitle = GetAppName();
        if ( ! aTitle.Len() )
            aTitle = GetAppFileName();
        aBox.SetText( aTitle );
        aBox.Execute();
   	    Critical_Error( ERR_INVALID_APPLICAT_RDB, "" );
    }

    if ( ! m_bNoVcl )
    {
        Application::SetDefDialogParent( m_pMainWin );
	    m_pMainWin->SetVendorBMP( m_pCompiledScript->GetInstallation()->GetVendorBMP() );

	    if( m_pEnv->GetInstallMode() == IM_APPSERVER &&
		    !m_bResponseWizard && !m_pEnv->GetResponseStep() && !m_bParamDoCRCCheck )
	    {
		    UniString anError(ResId(ERR_ONLY_RESPONSE));
		    ErrorBox aBox( GetAppWindow(), WB_OK, anError );
		    aBox.Execute();
		    Quit();
	    }
    }

    if( m_pEnv->IsFirstInstallation() && !m_pEnv->InstallFromNet() )
	{
		// es wird alles fuer Default voreingestellt, wenn die Page InstallMode
		// angezeigt wird passt diese den Mode event. wieder an!
		m_pEnv->SetInstallType( IT_MAXIMAL );
		m_pCompiledScript->GetRootModule()->Select( SiModule::ALL_DEFAULT );
	}

	if ( ! m_bNoVcl )
    {
        m_pMainWin->ShowFullScreenMode(FALSE);

	    // Set MainWindow title
	    String aTitle( m_pMainWin->GetText() );
	    aTitle += String( m_pEnv->GetProductName(), osl_getThreadTextEncoding() );
	    aTitle += ' ';

        if ( ( m_pEnv->GetInstallMode() == IM_PATCH ) && m_pSecondResMgr )
        {
			aTitle += String( ResId( STR_DLG_TITLE_PATCH, m_pSecondResMgr ) );
		}
        else
        {
			aTitle += String( ResId( STR_DLG_TITLE ) );
		}
		
        m_pMainWin->SetText( aTitle );
    }

	////////////////////////////////
	// crc check
	if( m_bParamDoCRCCheck ) {
		PostUserEvent(EVT_START);
		Execute();
		DeInitTestToolLib( aTestToolModule );
//		delete m_pRemoteControl;
		return;
	}

	////////////////////////////////
	// webinstall mode
	SiDirEntry aWebResponse( m_pEnv->GetStartPath() );
	aWebResponse += ByteString( WEBRESPONSE_FILENAME );
	if( !aWebResponse.Exists() )
	{
		aWebResponse  = m_pEnv->GetSourcePath();
		aWebResponse += ByteString( WEBRESPONSE_FILENAME );
	}
	if( aWebResponse.Exists() )
	{
		Config aCfg( aWebResponse.GetFullUni() );

		aCfg.SetGroup( WEBRESPONSE_SEC_INSTALLATION );
		m_pEnv->SetDestPath( aCfg.ReadKey("installDir") );
		ByteString aLanguages = aCfg.ReadKey("installLang");

		USHORT nDelimTok = 0;
		USHORT nTokCount = aLanguages.GetTokenCount(';');
		for( USHORT x = 0; x < nTokCount; ++x )
		{
			ByteString a( aLanguages.GetToken(0, ';', nDelimTok) );

			LanguageContext* pCtx = new LanguageContext;
			pCtx->nLanguage	= (USHORT) a.GetToken( 0, ':' ).ToInt32();
			pCtx->isProg   	= a.GetToken( 1, ':' ) == "1"? TRUE : FALSE;
			pCtx->isDoc		= a.GetToken( 2, ':' ) == "1"? TRUE : FALSE;

			m_pEnv->AddLanguageContext( pCtx );
		}

		aCfg.SetGroup( WEBRESPONSE_SEC_USERDATA );
		m_pEnv->SetUserName			( aCfg.ReadKey("lastName") );
		m_pEnv->SetUserFirstName	( aCfg.ReadKey("firstName") );
		m_pEnv->SetUserEMail		( aCfg.ReadKey("email") );
		m_pEnv->SetCompanyName		( aCfg.ReadKey("firm") );
		m_pEnv->SetStreet			( aCfg.ReadKey("address") );
		m_pEnv->SetZip				( aCfg.ReadKey("zip") );
		m_pEnv->SetCity				( aCfg.ReadKey("city") );
		m_pEnv->SetTitle			( aCfg.ReadKey("title") );
		m_pEnv->SetPosition			( aCfg.ReadKey("position") );
		m_pEnv->SetFax				( aCfg.ReadKey("fax") );
		m_pEnv->SetTelefonWork		( aCfg.ReadKey("telOffice") );
		m_pEnv->SetTelefonHome		( aCfg.ReadKey("telHome") );
		m_pEnv->SetState			( aCfg.ReadKey("state") );
		m_pEnv->SetCountry			( aCfg.ReadKey("country") );
		m_pEnv->SetUserFatherName	( aCfg.ReadKey("fatherName") );
		m_pEnv->SetApartment   		( aCfg.ReadKey("apartment") );

		m_pCompiledScript->GetRootModule()->Select(SiModule::ALL_UNSEL);
		aCfg.SetGroup( WEBRESPONSE_SEC_MODULE );
		for( USHORT i = 0; i < aCfg.GetKeyCount(); ++i )
		{
			BOOL bRegister = aCfg.ReadKey(i) == "1" ? TRUE : FALSE;
			if( bRegister )
			{
				ByteString aModuleID( aCfg.GetKeyName(i) );
				SiModule* pMod = PTR_CAST( SiModule, m_pCompiledScript->Find(aModuleID) );
				if( pMod ) pMod->Select( SiModule::THIS_SEL );
			}
		}

    	if ( ! m_bNoVcl )
        {
		    m_pMainWin->Show();
		    m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_ADD );
		    if( m_pCompiledScript->GetInstallation()->GetProductBMP().Len() )
			    m_pMainWin->SetProductBMP( m_pCompiledScript->GetInstallation()->GetProductBMP() );
		    else
			    m_pMainWin->SetProductName( UniString(m_pEnv->GetProductName(), osl_getThreadTextEncoding()) );
		    PostUserEvent( EVT_START_INSTALL );

		    Execute();
        }
        else
        {
            Critical_Error( ERR_WRONG_INSATALLATIONMODE, "" );
        }
		aWebResponse.Kill();
	}
	else
	////////////////////////////////
	// moduledump mode
	if( param_bModuleDump )
	{
		SiDirEntry aEntry( m_pEnv->GetSourcePath() );
		if( m_aParamDestPath.Len() )
			aEntry += m_aParamDestPath;
		aEntry += ByteString( "script.htm" );
		aEntry.ToAbs();
		if( aEntry.GetPath().Exists() ) aEntry.GetPath().MakeDir();
		SiHelp::ModuleDump( m_pCompiledScript->GetRootModule(), aEntry.GetFull() );
		Exit();
		return;
	}
	else
	////////////////////////////////
	// Response Wizard mode
	if( m_bResponseWizard )
	{
		Critical::GetStaticInstance()->SetDebug( TRUE );
		m_pEnv->SetUINiceLangDefault( FALSE );
		m_pEnv->SetResponsefileWizardMode( TRUE );
		BOOL bSetDefaults = TRUE;

		if( m_pEnv->GetResponseFilename().Len() )
		{
			SiDirEntry aAbsRspFile = m_pEnv->GetSourcePath();
			aAbsRspFile += m_pEnv->GetResponseFilename();
			aAbsRspFile.ToAbs();

			m_pEnv->SetResponseFilename( aAbsRspFile.GetFull() );
		}

		m_pResponseFile = new ResponseFile( m_pEnv, m_pCompiledScript );

		if( m_pEnv->GetResponseFilename().Len() )
		{
			if( !(bSetDefaults = m_pResponseFile->Read(m_pEnv->GetResponseFilename())? FALSE : TRUE) )
			{
				SiLangCtxList& rLst = m_pEnv->GetLanguageContext();
				SiLangCtxList& rUILst = m_pEnv->GetUILanguageContext();
				USHORT nDefLang = (USHORT) m_pCompiledScript->GetInstallation()->GetDefLanguage().ToInt32();

				for( USHORT x = 0; x < rUILst.Count(); ++x )
					rUILst.GetObject(x)->isProg = FALSE;

				for( USHORT i = 0; i < rLst.Count(); ++i )
				{
    				LanguageContext* pAct = rLst.GetObject(i);
					for( USHORT x = 0; x < rUILst.Count(); ++x )
					{
						USHORT nLang = rUILst.GetObject(x)->nLanguage == nDefLang ?
									   LANG_DEFAULT : rUILst.GetObject(x)->nLanguage;
						if( nLang == pAct->nLanguage )
							rUILst.GetObject(x)->isProg = TRUE;
					}
				}

				if( m_pResponseFile->GetDestinationPath().Len() )
					m_pEnv->SetDestPath( m_pResponseFile->GetDestinationPath() );
			}
		}
		else
		{
			SiDirEntry aDefRespFilename( m_pEnv->GetDestPath() );
			if( aDefRespFilename.Level() > 1 )
				aDefRespFilename = aDefRespFilename[1];
			aDefRespFilename += ByteString("responsefile.txt");

			m_pEnv->SetResponseFilename( aDefRespFilename.GetFull() );
		}

		if( bSetDefaults )
		{
			m_pResponseFile->SetInstallationMode	( INSTALL_NETWORK );
			m_pResponseFile->SetInstallationType	( SPECIFY );
		}

		PostUserEvent(EVT_START);
		Execute();
	}
	else
	////////////////////////////////
	// repair mode
	if( param_bRepair )
	{
		ByteString aInstalledPath;
		if( SiHelp::IsVersionAlreadyInstalled(aInstalledPath, m_pCompiledScript, m_pEnv) &&
			aInstalledPath.CompareIgnoreCaseToAscii(m_pEnv->GetStartPath()) != COMPARE_EQUAL  )
		{
			// Setup wurde vom Installations-Medium aufgerufen.
			ByteString strInstDB( SETUP_INSTDB_FILE );
			SiDirEntry aInstDB( aInstalledPath );
			aInstDB += strInstDB;
			while( (!aInstDB.Exists()) && (aInstDB.Level() > 2) )
			{
				aInstDB = aInstDB[2];
				aInstDB += strInstDB;
			}

			if( aInstDB.Exists() )
				ReadScript( aInstDB );

			m_pEnv->SetInstalledPath( aInstalledPath );
			m_pEnv->SetDestPath( aInstalledPath );
			m_pEnv->SetFirstInstallation( FALSE );
            m_pEnv->SetInstallMode( m_pCompiledScript->GetInstallation()->GetInstallMode() );

			if( m_pCompiledScript->GetInstallation() )
				m_pEnv->SetSourcePath( m_pCompiledScript->GetInstallation()->GetSourcePath() );
		}

		if ( ! m_bNoVcl )
        {
            m_pMainWin->Show();
		    m_pMainWin->Update();
		    if( m_pCompiledScript->GetInstallation()->GetProductBMP().Len() )
			    m_pMainWin->SetProductBMP( m_pCompiledScript->GetInstallation()->GetProductBMP() );
		    else
			    m_pMainWin->SetProductName( UniString(m_pEnv->GetProductName(), osl_getThreadTextEncoding()) );

		    m_pEnv->SetInstallType( IT_RECOVER );
		    PostUserEvent( EVT_REINST_RECOVER );
		    Execute();
        }
        else
        {
            Critical_Error( ERR_WRONG_INSATALLATIONMODE, "" );
        }

	}
	else
	////////////////////////////////
	// response mode
	if( m_pEnv->GetResponseFilename().Len() )
	{
		Critical::GetStaticInstance()->SetStdOut( TRUE );

		SiDirEntry aFile( m_pEnv->GetResponseFilename() );
		if( !aFile.Exists() )
		{
			aFile = m_pEnv->GetStartPath();
			aFile += m_pEnv->GetResponseFilename();
			if( !aFile.Exists() )
			{
				aFile = m_pEnv->GetSourcePath();
				aFile += m_pEnv->GetResponseFilename();
				if( !aFile.Exists() )
					Critical_Error( ERR_RESPONSEFILE_NOTFOUND, "" );
			}
		}

		aFile.ToAbs();
		m_pEnv->SetResponseFilename( aFile.GetFull() );

		m_pResponseFile = new ResponseFile( m_pEnv, m_pCompiledScript );
		m_pEnv->SetResponsefileMode( TRUE );

		if( m_aParamDestPath.Len() )
			m_pResponseFile->SetDestinationPath( m_aParamDestPath );
		m_pResponseFile->Read( aFile.GetFull() );

        if( m_pEnv->GetResponseStep() == 1 )
        {
            // Response step one requires a module set
            // We will exit, when there is none
            if ( ! param_aModuleSet.Len() )
                Critical_Error( ERR_NOMODULES, "" );
        }

		if( param_aModuleSet.Len() )
		{
			SiModuleSet* pSet = SiHelp::FindModuleSetByName(m_pEnv, param_aModuleSet);
			if( !pSet )
			{
				Critical_Error( ERR_INSTALLMODULESET_NOTFOUND, "" );
			}
			else
			{
				m_pCompiledScript->GetRootModule()->Select(SiModule::ALL_UNSEL);
				pSet->Select();
				m_pResponseFile->SetPreModuleSet(TRUE);
			}
		}

		if( m_pEnv->GetResponseStep() == 2 )
		{
			m_pEnv->SetFirstInstallation(TRUE);
			m_pEnv->SetInstallType( IT_MAXIMAL );

			SiModuleSetList& rLst = m_pEnv->GetModuleSetList();
			for( USHORT i = 0; i < rLst.Count(); ++i )
			{
				SiModuleSet* pSet = rLst.GetObject(i);
				pSet->Select();
			}
			m_pResponseFile->SetPreModuleSet( TRUE );
		}

		USHORT nEvt = m_pResponseFile->ProcessEvents();

		if ( ! m_bNoVcl )
        {
            if( ( nEvt == EVT_START_INSTALL ) )
			    m_pMainWin->GetLeftWin()->ShowInstInfo( TRUE, ISM_ADD );

		    if( m_pCompiledScript->GetInstallation()->GetProductBMP().Len() )
			    m_pMainWin->SetProductBMP( m_pCompiledScript->GetInstallation()->GetProductBMP() );
		    else
			    m_pMainWin->SetProductName( UniString(m_pEnv->GetProductName(), osl_getThreadTextEncoding()) );
        }

		m_pResponseFile->ExecStartProcedure();

        PostUserEvent( nEvt );

        if ( m_bNoVcl )
            HandleUserEvents();
        else
		    Execute();
	}
	else
	////////////////////////////////
	// normal- & officemode
	{
		if( param_bOfficeMode && m_pEnv->GetInstallMode() != IM_NETWORK )
			m_bOfficeMode = TRUE;

		if ( ! m_bNoVcl )
        {
#ifdef UNX /* #95450# */
			if (m_pEnv->IsLocal() == FALSE)
			{
				// Network installation
				String suText( ResId(STR_NETWORK_WARNING_IF_NO_ROOT, (ResMgr*)m_pResMan) );
				suText.SearchAndReplace( UniString::CreateFromAscii("%1"),
										 UniString::CreateFromAscii(m_pEnv->GetProductName().GetBuffer()) );
				if (getuid() != 0)
				{
					QueryBox aBox(NULL, WB_YES_NO | WB_DEF_NO, suText);
					if ( aBox.Execute() == RET_NO)
					{
						Quit();
					}
				}
			}
#endif
            m_pMainWin->Show();
		    m_pMainWin->Update();
		    if( m_pCompiledScript->GetInstallation()->GetProductBMP().Len() )
			    m_pMainWin->SetProductBMP( m_pCompiledScript->GetInstallation()->GetProductBMP() );
		    else
			    m_pMainWin->SetProductName( UniString(m_pEnv->GetProductName(), osl_getThreadTextEncoding()) );

		    PostUserEvent( EVT_START );
		    Execute();
        }
	}

	if ( ! m_bNoVcl )
        Application::SetDefDialogParent( NULL );

	DeInitTestToolLib( aTestToolModule );
//	DELETEZ( m_pRemoteControl );
	DELETEZ( m_pExitAccel );
	Resource::SetResManager( NULL );
	DELETEZ( m_pResMan );

    if ( ! m_bNoVcl )
    {
        DELETEZ( m_pMainWin );
        DeInitVCL();
    }
}

void ResourceHook( UniString& rStr )
{
	UniString aSingleName, aName, aProductPatchName;
	if( param_bAutoPilot )
	{
		aSingleName = UniString( pSetupApp->GetEnvironment()->GetVendorName(), osl_getThreadTextEncoding() );
		aName = UniString( pSetupApp->GetEnvironment()->GetVendorVersion(), osl_getThreadTextEncoding() );
	}
	else
	{
		aSingleName = UniString( pSetupApp->GetEnvironment()->GetSingleProductName(), osl_getThreadTextEncoding() );
		aName = UniString( pSetupApp->GetEnvironment()->GetProductVersion(), osl_getThreadTextEncoding() );
	}

	aProductPatchName = pSetupApp->GetProductPatchName();

	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTNAME"), aSingleName );
	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTVERSION"), aName );

	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%PRODUCTPATCHNAME"), aProductPatchName );


/*
	sal_Int16 nPatchLevel = 0;
	if (pSetupApp && pSetupApp->GetCScript() && pSetupApp->GetCScript()->GetInstallation())
	{
		pSetupApp->GetCScript()->GetInstallation()->GetPatchLevel();
	}
	UniString aBackupDirectory(UniString::CreateFromAscii("Backup_PP"));
	aBackupDirectory += UniString::CreateFromInt32(nPatchLevel);
	rStr.SearchAndReplaceAll( UniString::CreateFromAscii("%BACKUP_DIRECTORY"), aBackupDirectory );
*/
}

// -----------------------------------------------------------------------------
namespace setup
{
    ResMgr* LoadRessourcesByName(ByteString const& _sName, LanguageType& _nType)
    {
        ByteString aMgrName(_sName);
        aMgrName += ByteString::CreateFromInt32( SOLARUPD );
        ResMgr* pResMgr = ResMgr::SearchCreateResMgr( aMgrName.GetBuffer(), _nType );

        return pResMgr;
    }
}

// -----------------------------------------------------------------------------

ResMgr* SetupApp::LoadRessources()
{
	LanguageType nType = GetSystemLanguage();

	ByteString aMgrName( "set" );
	ResMgr* pResMgr = setup::LoadRessourcesByName(aMgrName, nType);

	ResMgr::SetReadStringHook( ResourceHook );

	// load a second resource file
    	LanguageType nLastType = nType;
    	m_pSecondResMgr = setup::LoadRessourcesByName("set_pp1", nLastType);
	// m_pSecondResMgr->SetReadStringHook( ResourceHook );

	if( pResMgr )
	{
		Resource::SetResManager( pResMgr );
		AllSettings aSettings = Application::GetSettings();
        aSettings.SetUILanguage( nType );
        SetSettings( aSettings );
	}
	else
		return NULL;

#ifndef UNX
	// init icon, svlook
	InitAppRes(ResId(APP_ID));
#endif

	UniString aUniFilename( pResMgr->GetFileName() );
	ByteString aFileName = ByteString(aUniFilename, osl_getThreadTextEncoding()).ToLowerAscii();
	m_nLanguage = aFileName.Copy( aFileName.Search(aMgrName.ToLowerAscii()) + aMgrName.Len() + 3, 2).ToInt32();

	// get Product Patch Brand Name from resources
	if( m_pSecondResMgr )
	{
		ResId aResId(STR_PRODUCTPATCH);
		ResId aResId2(STR_PRODUCTPATCH, m_pSecondResMgr);
		aResId2.SetRT(RSC_STRING);
		if( aResId2.GetResMgr()->IsAvailable(aResId2) )
		{
			aResId.SetResMgr( m_pSecondResMgr );
		}
		m_aProductPatchName = String( aResId );
	}
	return pResMgr;
}

// -----------------------------------------------------------------------
BOOL SetupApp::IsResponseMode() const
{
	return m_pEnv && m_pEnv->GetResponseFilename().Len()? TRUE : FALSE;
}

// -----------------------------------------------------------------------
BOOL SetupApp::GetAdditionalParam( int &i, ByteString& rExtendedParam )
{
    rExtendedParam  = ByteString( GetCommandLineParam(i), osl_getThreadTextEncoding() );
    xub_StrLen nPos = rExtendedParam.Search( ':' );
    
    if ( nPos == STRING_NOTFOUND )
    {
        rExtendedParam = ByteString( GetCommandLineParam(i+1), osl_getThreadTextEncoding() );
        if ( !rExtendedParam.Len() || ( PAR_UNKNOWN != GetParameter( rExtendedParam ) ) )
            return FALSE;
        else
            i += 1;                 // skip this parameter as it is already handled
    }
    else
    {
        rExtendedParam.Erase( 0, nPos+1 );
        if ( !rExtendedParam.Len() )
            return FALSE;
    }

    return TRUE;
}

// -----------------------------------------------------------------------
SetupParameter SetupApp::GetParameter( const ByteString& rParameter )
{
    SetupParameter  eParameter;
    ByteString      aParameter = rParameter.GetToken( 0, ':' );

    if ( ( aParameter.GetChar(0) == '-' ) ||
         ( aParameter.GetChar(0) == '/' ) )
        aParameter.Erase( 0, 1 );
    else
        return PAR_UNKNOWN;

    aParameter.ToUpperAscii();

    if( aParameter == "CRC" || aParameter == "C" )          // CRC
        eParameter = PAR_CRC_CHECK;
    else if( aParameter == "NET" || aParameter == "N" )     // NET
        eParameter = PAR_NET_INSTALL;
    else if( aParameter == "VIRTUAL" )                      // VIRTUAL
        eParameter = PAR_VIRTUAL;
    else if( aParameter == "V" )                            // VERBOSE
        eParameter = PAR_VERBOSE;
    else if( aParameter == "DEBUG" )                        // DEBUG
        eParameter = PAR_DEBUG;
    else if( aParameter == "NOEXIT" )                       // NOEXIT
        eParameter = PAR_NOEXIT;
    else if( aParameter == "RESPONSEFILEAUTOPILOT" ||       // RESPONSEWIZARD
             aParameter == "RSPA" )
        eParameter = PAR_RESPONSEFILEAUTOPILOT;
    else if( aParameter == "RSP1" )                         // RSP1:(RESPONSE FILE first step)
        eParameter = PAR_RSP1;
    else if( aParameter == "RSP2" )                         // RSP2:(RESPONSE FILE second step)
        eParameter = PAR_RSP2;
    else if( aParameter == "MSET" )                         // module set for response file mode
        eParameter = PAR_MSET;
    else if( aParameter == "R" )                            // R:(RESPONSE FILE)
        eParameter = PAR_RESPONSEFILE;
    else if( aParameter == "SDUMP" )                        // SDUMP
        eParameter = PAR_SDUMP;
    else if( aParameter == "OFFICEMODE" )                   // OFFICEMODE
        eParameter = PAR_OFFICEMODE;
    else if( aParameter == "REPAIR" )                       // REPAIR
        eParameter = PAR_REPAIR;
    else if( aParameter == "REINSTALL" )                    // REINSTALL
        eParameter = PAR_REINSTALL;
    else if( aParameter == "DEINSTALL" )                    // DEINSTALL
        eParameter = PAR_DEINSTALL;
    else if( aParameter == "NOREG" )                        // NOREG
        eParameter = PAR_NOREG;
    else if( aParameter == "AUSE" )                         // AUSE
        eParameter = PAR_AUSE;
    else if( aParameter == "EVIL" )                         // EVIL
        eParameter = PAR_EVIL;
    else if( aParameter == "UNOEVIL" )                      // UNOEVIL
        eParameter = PAR_UNOEVIL;
    else if( aParameter == "D" )                            // D:(DESTINATION PATH)
        eParameter = PAR_DESTINATION_PATH;
    else if( aParameter == "F" )                            // F:(FOLLOW APP)
        eParameter = PAR_FOLLOW_APP;
    else if (aParameter == "DONTDELETETEMP")                // DONTDELETETEMP
        eParameter = PAR_DONT_DELETE_TEMP;
    else if( aParameter == "PATCH" )                        // Patch
        eParameter = PAR_PATCH;
    else
        eParameter = PAR_UNKNOWN;

    if ( ( eParameter == PAR_UNKNOWN ) &&
         ( aParameter.CompareTo( "SOW", 3 ) == COMPARE_EQUAL ) )
        eParameter = PAR_IGNORE;

    return eParameter;
}

// -----------------------------------------------------------------------
UniString SetupApp::ReadParams()
{
    SiDirEntry aSetupIni  = m_pEnv->GetStartPath();
               aSetupIni += SiDirEntry(SETUP_INI);

	if (aSetupIni.Exists())
	{
		Config aCfg(aSetupIni.GetFullUni());

		aCfg.SetGroup("Source");
		m_SetupIniSourcePath = aCfg.ReadKey("Path");
		m_pEnv->SetSourcePath(m_SetupIniSourcePath);

		ByteString aTmpBool( aCfg.ReadKey("big", "0") );
		m_pEnv->SetBigMode( (BOOL)(USHORT)aTmpBool.ToInt32() );

		if( m_pEnv->IsBigMode() )
		{
			ByteString aTmpOffset( aCfg.ReadKey("offset", "0") );
		}
		
        // Share geladen?
        #ifdef WIN
        aCfg.SetGroup( "share" );
        ByteString sKey = aCfg.ReadKey( "load" );
        m_bShare = ( sKey == "1" );
        #endif
	}

#ifdef OS2

	if (!GetCommandLineParamCount())
	{
		if (aSetupIni.Exists())
		{
			Config aIniCfg(aSetupIni.GetFull());
			aIniCfg.SetGroup( "extra" );
			ByteString aVal = aIniCfg.ReadKey( "network" );
			m_pEnv->SetLocal( aVal != "1" );
		}
	}

#endif

    int nCount = GetCommandLineParamCount();

    for ( int i = 0; i < nCount; ++i )
    {
        ByteString  aExtendedParam;
        ByteString  aParam = ByteString( GetCommandLineParam(i), osl_getThreadTextEncoding() );
        BOOL        bExtParamError = FALSE;
        BOOL        bParameterError = FALSE;

        SetupParameter eParameter = GetParameter( aParam );

        switch ( eParameter )
        {
        case PAR_CRC_CHECK: m_bParamDoCRCCheck = TRUE; break;

        case PAR_NET_INSTALL: m_pEnv->SetLocal( FALSE ); break;

        case PAR_VIRTUAL:   m_pEnv->SetVirtualMode( TRUE ); break;

        case PAR_VERBOSE:   m_pEnv->SetVerboseMode( TRUE ); break;

        case PAR_DEBUG:     if( Critical::GetStaticInstance() )
                                Critical::GetStaticInstance()->SetDebug( TRUE );
                            break;

        case PAR_NOEXIT:    if( Critical::GetStaticInstance() )
                                Critical::GetStaticInstance()->SetNoExit( TRUE );
                            break;
        case PAR_RESPONSEFILEAUTOPILOT:
                            m_bResponseWizard = TRUE;
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_pEnv->SetResponseFilename( aExtendedParam );
                                param_bAutoPilot = TRUE;  // static 4 reource hook
                            }
                            break;
        case PAR_RSP1:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_pEnv->SetResponseStep( 1 );
                                m_pEnv->SetResponseFilename( aExtendedParam );
                            }
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_RSP2:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_pEnv->SetResponseStep( 2 );
                                m_pEnv->SetResponseFilename( aExtendedParam );
                            }
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_MSET:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                                param_aModuleSet = aExtendedParam;
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_RESPONSEFILE:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_pEnv->SetResponseStep( 0 );
                                m_pEnv->SetResponseFilename( aExtendedParam );
                            }
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_SDUMP:     param_bModuleDump = TRUE; break;

        case PAR_OFFICEMODE: param_bOfficeMode = TRUE; break;

        case PAR_REPAIR:    param_bRepair = TRUE; break;

        case PAR_REINSTALL: m_pEnv->SetForceReinstall( TRUE ); break;

        case PAR_DEINSTALL: m_pEnv->SetForceDeinstall( TRUE ); break;

        case PAR_NOREG:     m_pEnv->SetNoRegistration( TRUE ); break;

        case PAR_AUSE:      m_pEnv->SetAUSEStreamFlush( TRUE ); break;

        case PAR_EVIL:      param_bEvil = TRUE; break;

        case PAR_UNOEVIL:   m_pEnv->SetUNOEvil( TRUE ); break;

        case PAR_DESTINATION_PATH:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                            {
                                m_aParamDestPath = aExtendedParam;
                                m_pEnv->SetParamDestPath(TRUE);
                            }
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_FOLLOW_APP:
                            if ( GetAdditionalParam( i, aExtendedParam ) )
                                m_aParamFollowApp = aExtendedParam;
                            else
                                bExtParamError = TRUE;
                            break;
        case PAR_IGNORE:    break;

        case PAR_DONT_DELETE_TEMP: break;

        case PAR_PATCH:     if ( GetAdditionalParam( i, aExtendedParam ) )
                                m_aParamDestPath = aExtendedParam;
                            else
                                bExtParamError = TRUE;
                            break;

        default:            bParameterError = TRUE;
        } // end switch ( eParameter )

        if( bParameterError || bExtParamError )
        {
            if( !IsResponseMode() )
            {
                UniString anError( ResId( ERR_COMMAND_PARAM ) );
                          anError.SearchAndReplace( UniString::CreateFromAscii( "%1" ),
                                                    UniString::CreateFromAscii( aParam.GetBuffer() ) );
				return anError;
            }
            else
                Critical_Error( ERR_WRONGPARAMETER, "" );
        }
    } // end for ( int i = 0; i < nCount; ++i )

    return UniString();
}

// -----------------------------------------------------------------------

BOOL SetupApp::FindAndReadScript()
{
	BOOL bWorkstation = FALSE;

	ByteString aScriptName( SETUP_INSTDB_FILE );
	SiDirEntry aScript (m_pEnv->GetStartPath());
	aScript += aScriptName;

	while( (!aScript.Exists()) && (aScript.Level() > 2) )
	{
		aScript = aScript[2];
		aScript += aScriptName;
	}

	if( aScript.Exists() )
	{
		m_pEnv->SetFirstInstallation(FALSE);
	}
	else
	{
		m_pEnv->SetFirstInstallation();

		if( m_pEnv->IsBigMode() )
		{
			ArchDirectory* pArch = new ArchDirectory;
			SiDirEntry aEntry( m_SetupIniSourcePath );
			if( !pArch->SetArchFile(aEntry.GetFull().GetBuffer()) )
			{
				if( !IsResponseMode() )
				{
					aEntry.ToAbs();
					m_pEnv->SetInstalledPath(aEntry.GetFull());
					ShowScriptNotFound();

					delete pArch;
					return FALSE;
				}
				else
					Critical_Error( ERR_SCRIPT_NOTFOUND, "" );
			}
			else
				m_pEnv->SetArchive( pArch, FindArch );

			ByteString aScrt(SETUP_SCRIPT_FILE);
			pArch->GetFile( aScrt.GetBuffer(), m_pEnv->GetStartPath().GetBuffer() );
		}

		aScript  = m_pEnv->GetStartPath();
		aScript += ByteString(SETUP_SCRIPT_FILE);

		if (!aScript.Exists())
		{
			aScript	 = m_SetupIniSourcePath;
			aScript += ByteString(SETUP_SCRIPT_FILE);

			if( !aScript.Exists() )
			{
				if( !IsResponseMode() )
				{
					aScript.ToAbs();
					m_pEnv->SetInstalledPath(aScript.GetFull());
					ShowScriptNotFound();
					return FALSE;
				}
				else
					Critical_Error( ERR_SCRIPT_NOTFOUND, "" );
			}
		}
	}

	if( !ReadScript(aScript) )
	{
		if( !IsResponseMode() )
		{
			ErrorBox( NULL, WB_OK, ResId(ERR_SCRIPT) ).Execute();
			return FALSE;
		}
		else
			Critical_Error( ERR_SCRIPT_NOTFOUND, "" );
	}

	if( !m_pCompiledScript->GetInstallation() )
		return FALSE;

	m_pEnv->SetDefLanguage( (USHORT) m_pCompiledScript->GetInstallation()->GetDefLanguage().ToInt32() );

	m_pEnv->SetSingleProductName( m_pCompiledScript->GetInstallation()->GetProductName() );
	m_pEnv->SetProductVersion( m_pCompiledScript->GetInstallation()->GetProductVersion() );
	m_pEnv->SetVendorName( m_pCompiledScript->GetInstallation()->GetVendorName() );
	m_pEnv->SetVendorVersion( m_pCompiledScript->GetInstallation()->GetVendorVersion() );
	m_pEnv->SetInternalVersion( m_pCompiledScript->GetInstallation()->GetInternalProductVersion() );
	m_pEnv->SetSuiteName( m_pCompiledScript->GetInstallation()->GetSuiteName() );
    m_pEnv->SetInstallMode( m_pCompiledScript->GetInstallation()->GetInstallMode() );

	if( !m_pEnv->GetVendorName().Len() )
		param_bAutoPilot = FALSE;       // so resource hook dont use this...

	ByteString aProductname = m_pEnv->GetSingleProductName();
	aProductname += ' ';
	aProductname += m_pEnv->GetProductVersion();

	if ( m_pCompiledScript->GetInstallInfo() )
        m_pEnv->SetProductKey( m_pCompiledScript->GetInstallInfo()->GetKey() );

    m_pEnv->SetProductName( aProductname );

	if( !m_pEnv->IsFirstInstallation() )
	{
		m_pEnv->SetInstalledPath( m_pCompiledScript->GetInstallation()->GetDestPath() );
		m_pEnv->SetDestPath( m_pCompiledScript->GetInstallation()->GetDestPath() );
		if( m_pEnv->GetInstallMode() == IM_NETWORK )
		{
			SiDirEntry aStartRoot( m_pEnv->GetStartPath() );
			aStartRoot = aStartRoot[1];
			aStartRoot.ToAbs();
			m_pEnv->SetSourcePath( aStartRoot.GetFull() );
			m_pEnv->SetInstallFromNet( TRUE );
		}
		else
			m_pEnv->SetSourcePath( m_pCompiledScript->GetInstallation()->GetSourcePath() );

		if( !(m_pEnv->IsLocal() && m_pEnv->GetInstallMode() == IM_NETWORK) )
		{
			ArchDirectory* pArch = new ArchDirectory;
			if( pArch->SetArchFile(m_pCompiledScript->GetInstallation()->GetSourcePath().GetBuffer()) )
			{
				m_pEnv->SetBigMode( TRUE );
				m_pEnv->SetArchive( pArch, FindArch );
				m_pEnv->SetSourcePath( m_pCompiledScript->GetInstallation()->GetSourcePath() );
			}
			else
				delete pArch;
		}
	}

	// Wenn der MODE == APPSERVER m_bIsLocal auf FALSE setzen
	if( m_pEnv->IsLocal() &&
		m_pEnv->GetInstallMode() == IM_APPSERVER )
		m_pEnv->SetLocal( FALSE );

	// Bei Netzinstallation noch ermitteln, ob vielleicht die
	// Arbeitsplatzinstallation gemeint war.
	if( m_pEnv->IsLocal() &&
		m_pEnv->GetInstallMode() == IM_NETWORK)
	{
		// In z.B. sversion.ini nachschauen, ob es dort einen Verweis auf das installierte
		// Programm gibt.
		SiProfileItem *pItem = m_pCompiledScript->GetInstallInfo();

		if (pItem != NULL)
		{
			aScript  = GetValue(pItem,"__empty__");
			aScript += ByteString(SETUP_INSTDB_FILE);

			// Eintrag muss existieren und gueltig sein
			if( aScript.Exists() )
			{
				if( !ReadScript(aScript) )
				{
					if( !IsResponseMode() )
					{
						ErrorBox(NULL,WB_OK,ResId(ERR_SCRIPT)).Execute();
						return FALSE;
					}
					else
						Critical_Error( ERR_SETUPSCRIPT, "" );
				}

				m_pEnv->SetInstalledPath( ((SiDirEntry&)aScript.GetPath()).GetFull() );
				m_pEnv->SetDestPath( ((SiDirEntry&)aScript.GetPath()).GetFull() );
				m_pEnv->SetFirstInstallation(FALSE); // in bezug auf Arbeitsplatz ...
                m_pEnv->SetInstallMode( m_pCompiledScript->GetInstallation()->GetInstallMode() );
			}
			else
			{
				bWorkstation = TRUE;
				m_pEnv->SetFirstInstallation(); // in bezug auf Arbeitsplatz ...
			}
		}
		else
			bWorkstation = TRUE;
	}

	// Wenn eine Erstinstallation basierend auf einer Netzinstallation
	// durchgefuhert werden soll.
	if( bWorkstation &&
		m_pEnv->IsFirstInstallation() &&
		m_pEnv->GetInstallMode() == IM_NETWORK )
	{
		m_pCompiledScript->PrepareForLocalInstallation();
	}

	if( m_pEnv->IsFirstInstallation() )
	{
		if( m_pEnv->GetInstallMode() == IM_PATCH )
		{
			BOOL        bPathFound  = FALSE;
            short       nLookups    = 0;
            ByteString  aInstalledPath;

            if( !SiHelp::IsVersionAlreadyInstalled(aInstalledPath, m_pCompiledScript, m_pEnv) )
			{
				SiProfileItem* pItem = m_pCompiledScript->GetInstallInfo();
				pItem->SetProperty( "Key", "StarSuite 6.0" );
				SiHelp::IsVersionAlreadyInstalled( aInstalledPath, m_pCompiledScript, m_pEnv );
			}

            if ( ! aInstalledPath.Len() )
                aInstalledPath = m_aParamDestPath;

            BOOL bHadPatchInstallError = FALSE;

            while ( !bPathFound && ( nLookups++ < MAX_LOOKUPS ) )
            {
                ByteString aScriptName( SETUP_INSTDB_FILE );
			    SiDirEntry aOldScript( aInstalledPath );
			    aOldScript += ByteString("program");
			    aOldScript += aScriptName;

                while( !aOldScript.Exists() && (aOldScript.Level() > 2) )
                {
                    aOldScript  = aOldScript[2];
                    aOldScript += aScriptName;
                }

                if ( !aOldScript.Exists() )
                    Critical_Error( ERR_INSTALLINFOMISSING, "" );

			    delete m_pOldCompiledScript;
                m_pOldCompiledScript = new SiCompiledScript;
			    ReadScript( aOldScript, m_pOldCompiledScript );

			    if ( m_pOldCompiledScript->GetInstallation() )
                {
                    m_pEnv->SetSingleProductName( m_pOldCompiledScript->GetInstallation()->GetProductName() );
			        m_pEnv->SetProductVersion( m_pOldCompiledScript->GetInstallation()->GetProductVersion() );
                }
                else
                    Critical_Error( ERR_INSTALLINFOMISSING, "" );

				if( m_pOldCompiledScript->GetInstallation()->GetPatchLevel() &&
					m_pOldCompiledScript->GetInstallation()->GetPatchLevel() >= m_pCompiledScript->GetInstallation()->GetPatchLevel() &&
                    ! bHadPatchInstallError )
				{
					// #104439# show the error msg only once
                    bHadPatchInstallError = TRUE;

                    ResId aResId(STR_PATCH_ALREADY_INSTALLED);
					if( m_pSecondResMgr )
					{
						ResId aResId2(STR_PATCH_ALREADY_INSTALLED, m_pSecondResMgr);
						aResId2.SetRT(RSC_STRING);
						if( aResId2.GetResMgr()->IsAvailable(aResId2) )
							aResId.SetResMgr( m_pSecondResMgr );
					}
					UniString anError( aResId );

					// Set Window title
					String aTitle;
					aTitle += String( m_pEnv->GetProductName(), osl_getThreadTextEncoding() );
				    aTitle += ' ';

					{
						ResId aResId( STR_DLG_TITLE_PATCH );
						if( m_pSecondResMgr )
						{
							ResId aResId2(STR_DLG_TITLE_PATCH, m_pSecondResMgr);
							aResId2.SetRT(RSC_STRING);
							if( aResId2.GetResMgr()->IsAvailable(aResId2) )
								aResId.SetResMgr( m_pSecondResMgr );
						}
						aTitle += String( aResId );
					}

                    if( !IsResponseMode() )
                    {
                        ErrorBox aBox( NULL, WB_OK, anError );
                        aBox.SetText( aTitle );
                        aBox.Execute();
#ifdef UNX
                        _exit(1);
#endif
                        Quit();
                    }
                    else
                        Critical_Error( ERR_VERSIONALLREADYINSTALLED, ByteString(anError, osl_getThreadTextEncoding()) );
                }

                // We are only patching the network part of a office installation, but we use
                // the sverion.ini ( and therefor the workstation installation ) to find the
                // location.
                SiInstallMode eInstallMode = m_pOldCompiledScript->GetInstallation()->GetInstallMode();

                if ( eInstallMode == IM_STANDALONE )
                {
                    m_pEnv->SetLocal( TRUE );
                    aInstalledPath = m_pOldCompiledScript->GetInstallation()->GetDestPath();
                    bPathFound = TRUE;
                }
                else
                {
                    m_pEnv->SetLocal( FALSE );

                    if ( eInstallMode == IM_NETWORK )
                    {
                        aInstalledPath = m_pOldCompiledScript->GetInstallation()->GetDestPath();
                        bPathFound = TRUE;
                    }
                    else
                    {
                        aInstalledPath = m_pOldCompiledScript->GetInstallation()->GetSourcePath();
                        // Quick hack for remembering the path to the workstation installation
                        // (needed for #99441# test for running office )
                        m_pEnv->SetLicenseKey( m_pOldCompiledScript->GetInstallation()->GetDestPath() );
                    }
                }
            }

            if ( nLookups >= MAX_LOOKUPS )
                Critical_Error( ERR_INSTALLINFOMISSING, "" );

            m_pEnv->SetInstalledPath	( aInstalledPath );
			m_pEnv->SetDestPath			( aInstalledPath );

            aProductname = m_pEnv->GetSingleProductName();
			aProductname += ' ';
			aProductname += m_pEnv->GetProductVersion();

			m_pEnv->SetProductName( aProductname );
		}
		else
		{
			ByteString aRelativPath = m_pCompiledScript->GetInstallation()->GetDefaultDestPath();
#if defined(UNX)
			SiDirEntry aUNXDefPath( UnixOS::GetHomeDir() );
			aUNXDefPath += aRelativPath;
			aUNXDefPath.ToAbs();
			m_pEnv->SetDestPath( aUNXDefPath.GetFull() );
#elif defined(MAC)
			ByteString aTemp = MacOS::GetSystemVolumeName();
			ByteString aRelPath = aRelativPath;
			if (aRelPath[(USHORT)0] != ':')
				aTemp += ':';
			aTemp += aRelPath;
			m_pEnv->SetDestPath(aTemp);
#else
#ifdef WNT
			ByteString aStr(WinOS::SHGetUserProgramFilesFolder(), osl_getThreadTextEncoding());
			aRelativPath.SearchAndReplace("<winprogpath>", aStr );
#endif
			m_pEnv->SetDestPath(aRelativPath);
#endif

			if (m_aParamDestPath.Len() != 0)
				m_pEnv->SetDestPath(m_aParamDestPath);
		}
	}
	else
	{
		DBG_ASSERT(m_pEnv->GetDestPath().Len() != 0, "kein Zielpfad");
	}

	if( m_pCompiledScript && !m_pCompiledScript->GetInstallInfo() )
	{
		if( !IsResponseMode() )
		{
			ErrorBox aBox(NULL, WB_OK, UniString::CreateFromAscii("INSTALL_INFO\nis missing!") );
			aBox.Execute();
		}
		else
			Critical_Error( ERR_INSTALLINFOMISSING, "" );
		return FALSE;
	}

	// Installation FollowApp
	if( m_pCompiledScript->GetInstallation()->GetFollowApp().Len() &&
		m_pEnv->IsFirstInstallation() && m_pEnv->IsLocal() )
	{
		SiDirEntry aEntry( m_pCompiledScript->GetInstallation()->GetFollowApp() );
		if( !aEntry.Exists() )
		{
			aEntry = m_pEnv->GetSourcePath();
			aEntry += m_pCompiledScript->GetInstallation()->GetFollowApp();
		}
		if( aEntry.Exists() )
		{
			aEntry.ToAbs();
			ByteString* pNew = new ByteString( aEntry.GetFull() );
			m_pEnv->AddFollowAppList( pNew );
		}
	}

	// Languages
	SiInstallation* pInst;
	if( m_pEnv->GetInstallMode() == IM_PATCH )
		pInst = m_pOldCompiledScript->GetInstallation();
	else
		pInst = m_pCompiledScript->GetInstallation();

	ByteString aLanguages( pInst->GetLanguages() );

	USHORT nDelimTok = 0;
	USHORT nTokCount = aLanguages.GetTokenCount(',');

	for( USHORT x = 0; x < nTokCount; ++x )
	{
		USHORT nLang = (USHORT) aLanguages.GetToken(0, ',', nDelimTok).ToInt32();
		LanguageContext* pNew = new LanguageContext;

		// nLang = nLang == (USHORT)pInst->GetDefLanguage()? LANG_DEFAULT : nLang;
		pNew->nLanguage = nLang;

		BOOL bProg	= FALSE;
		BOOL bDoc	= FALSE;
		pInst->IsLanguageInstalled(nLang, bProg, bDoc);

		pNew->isProg	= bProg;
		pNew->isDoc		= bDoc;

		m_pEnv->AddUILanguageContext( pNew );
	}

	// Execute PreSelectProcedure
	if( m_pEnv->IsFirstInstallation() )
	{
		SiProcedure* pProc = (SiProcedure*)m_pCompiledScript->FindPreSelectProc();
		if( pProc )
		{
			SiBasic aBasic( *m_pCompiledScript, *m_pEnv );
        	if ( m_pEnv->HasVCL() )
            {
                NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
                aBasic.Call( pProc->GetProcName(), pProc->GetCode() );
            }
            else
                aBasic.Call( pProc->GetProcName(), pProc->GetCode() );
		}
	}

#ifdef WNT
	// Adabas check.
	if (setup::isAdabas(pInst))
	{
		ByteString aRelativPath = m_pCompiledScript->GetInstallation()->GetDefaultDestPath();
		ByteString aStr(WinOS::SHGetUserProgramFilesFolder(), osl_getThreadTextEncoding());
		if (aStr.Len() >= 2)
		{
			aStr = aStr.Copy(0,2);
		}
		else
		{
			// Fallback
			aStr = "C:";
		}
		aRelativPath.SearchAndReplace("<winprogpath>", aStr );
		m_pEnv->SetDestPath(aRelativPath);
	}
#endif
	
	return TRUE;
}

BOOL SetupApp::ReadScript(SiDirEntry const& aScript)
{
	// eventuell vorhandenes Script loeschen
	if (m_pCompiledScript != NULL)
		delete m_pCompiledScript;
	m_pCompiledScript = new SiCompiledScript;

	SetupInfoDialog* pInfDlg = NULL;
	if( !IsResponseMode() )
	{
		pInfDlg = new SetupInfoDialog( m_pMainWin->GetContWin() );
		pInfDlg->Show();
		pInfDlg->Update(); // sonst ist event. der Dialog nicht zu sehen
	}

	BOOL bSuccess = ReadScript( aScript, m_pCompiledScript );

	if( bSuccess )
	{
		SiModule *pModule = m_pCompiledScript->GetRootModule();
		if( pModule == NULL )
			bSuccess = FALSE; // nicht mal ein Modul!
	}

	if( !IsResponseMode() )
	{
		pInfDlg->Hide();
		delete pInfDlg;
	}
	return bSuccess;
}

BOOL SetupApp::ReadScript(SiDirEntry const& aScript, SiCompiledScript *pCS)
{
	SiAnsiFileStream aStream;

	aStream.Open( aScript.GetFullUni(), STREAM_READ );

	if( !aStream.IsOpen() )
		if( aScript.GetName().CompareIgnoreCaseToAscii("instdb.inf") == COMPARE_EQUAL )
		{	// wir suchten nach einer installierten Version!
			// Probieren wir es noch einmal mit dem 'alten' Scriptnamen
			SiDirEntry aOldScript = aScript;
			aOldScript.SetName(UniString::CreateFromAscii("setup.inf"));
			aStream.Open( aOldScript.GetFullUni(), STREAM_READ );
			if( !aStream.IsOpen() )
				return FALSE;
		}

	SiCompilerRef xCompiler = new SiCompiler( aStream, OS::GetType() );

	if ( m_bNoVcl )
        xCompiler->NoVCL();

    char aFirstChar;
	aStream >> aFirstChar;
	aStream.Seek(0);

	if( aFirstChar == '[' )
	{
		if( !IsResponseMode() )
		{
			InfoBox aBox(NULL, UniString::CreateFromAscii("Alte Scripts werden nicht mehr unterstuetzt!"));
			aBox.Execute();
		}
		else
			Critical_Error( ERR_OLDSCRIPTVERSION, "" );
		return FALSE;
	}
	else
		return xCompiler->CompileTo( pCS );
}

void SetupApp::PrepareLanguageContext()
{
	SiLangCtxList& rUILst = m_pEnv->GetUILanguageContext();
	SiInstallation* pInst = m_pCompiledScript->GetInstallation();
	USHORT nDefLang = (USHORT) pInst->GetDefLanguage().ToInt32();

	for( USHORT i = 0; i < rUILst.Count(); ++i )
	{
		LanguageContext* pAct = rUILst.GetObject(i);

		BOOL isprog = FALSE;
		BOOL isdoc  = FALSE;
		BOOL isInst = pInst->IsLanguageInstalled(pAct->nLanguage, isprog, isdoc);

		if( m_pEnv->GetInstallMode() != IM_PATCH &&
			!isInst && !pAct->isProg && !pAct->isDoc )
			// war noch nie installiert und soll auch nicht;
			// also weiter
			continue;

		LanguageContext* pCtx = new LanguageContext;
		pCtx->nLanguage	= pAct->nLanguage == nDefLang? LANG_DEFAULT : pAct->nLanguage;
		pCtx->isProg   	= pAct->isProg;
		pCtx->isDoc		= pAct->isDoc;

		m_pEnv->AddLanguageContext( pCtx );
	}

	// bei einem event. Languagewechsel mssen die Switch Ctx'e fuer
	// die Agenda aufgebaut werden.
	if( m_pEnv->GetInstallType() == IT_CHANGE )
	{
		ByteString aInstLanguages = pInst->GetLanguages();
		USHORT nDelimTok = 0;
		USHORT nTokCount = aInstLanguages.GetTokenCount(',');

		for( USHORT x = 0; x < nTokCount; ++x )
		{
			USHORT nLang = (USHORT) aInstLanguages.GetToken(0, ',', nDelimTok).ToInt32();
			LanguageContext* pUICtx = NULL;

			for( USHORT xx = 0; xx < rUILst.Count(); ++xx )
			{
				pUICtx = rUILst.GetObject(xx);
				if( pUICtx->nLanguage == nLang )
					break;
			}
			if( !pUICtx ) continue;

			BOOL isprog = FALSE;
			BOOL isdoc  = FALSE;
			BOOL isInst = pInst->IsLanguageInstalled(pUICtx->nLanguage, isprog, isdoc);

			if( isprog != pUICtx->isProg )
			{
				LanguageContext* pSwitch = new LanguageContext;
				pSwitch->nLanguage	= nLang;
				pSwitch->isProg		= TRUE;
				pSwitch->isDoc		= FALSE;

				if( pUICtx->isProg )
					m_pEnv->AddSwitchContextInstall(pSwitch);
				else
					m_pEnv->AddSwitchContextDelete(pSwitch);
			}
			if( isdoc != pUICtx->isDoc )
			{
				LanguageContext* pSwitch = new LanguageContext;
				pSwitch->nLanguage	= nLang;
				pSwitch->isProg		= FALSE;
				pSwitch->isDoc		= TRUE;
				if( pUICtx->isDoc )
					m_pEnv->AddSwitchContextInstall(pSwitch);
				else
					m_pEnv->AddSwitchContextDelete(pSwitch);
			}
		}
	}

	pInst->SetInstalledLanguages( m_pEnv );
}

ByteString SetupApp::GetValue(SiProfileItem const* pItem, ByteString const& aDefault) const
{
	SiDirEntry anIniPath  = pItem->GetProfile()->GetDirectory()->GetName();
			 anIniPath += pItem->GetProfile()->GetName();
	Config   anIni(anIniPath.GetFullUni());

	anIni.SetGroup(pItem->GetSection());

	return anIni.ReadKey(pItem->GetKey(),aDefault);
}

// -----------------------------------------------------------------------

void SetupApp::SetAccelerators()
{
#ifdef MAC
	m_pExitAccel = new Accelerator;
	m_pExitAccel->InsertItem( 1, KeyCode( KEY_ESCAPE ) );
	m_pExitAccel->InsertItem( 2, KeyCode( KEY_POINT, KEY_MOD1 ) );
	m_pExitAccel->PushSelectHdl( LINK( this, SetupApp, ExitHdl ) );
	InsertAccel(m_pExitAccel, ACCEL_STANDARD );
#else
	m_pExitAccel = new Accelerator;
	#if !defined(UNX) && !defined(OS2)
	m_pExitAccel->InsertItem( 1, KeyCode(KEY_I, KEY_SHIFT | KEY_MOD1) );
	#endif
	m_pExitAccel->SetSelectHdl( LINK( this, SetupApp, ExitHdl ) );
	InsertAccel( m_pExitAccel );
#endif
}

// -----------------------------------------------------------------------

#ifdef MAC
void SetupApp::AppEvent(ApplicationEvent const& rAppEvent)
{
}
#endif

// -----------------------------------------------------------------------

IMPL_LINK( SetupApp, WindowHideHdl, void*, pFoo )
{
	if( pFoo )
		m_pMainWin->Hide();
	else
	{
		m_pMainWin->Show();
		m_pMainWin->GrabFocus();
	}
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( SetupApp, ExitHdl, Accelerator*, pAccel )
{
	if( m_pExitAccel == pAccel )
	{
		if( m_pMainWin->IsFullScreenMode() )
			m_pMainWin->EndFullScreenMode();
		else
			m_pMainWin->ShowFullScreenMode();
		return 0;
	}

	if (m_bPerformInstall)
	{
		m_bInterrupt = TRUE;

		if( QueryBox( GetAppWindow(), ResId( DLG_QUERYEXITBOX ) ).Execute() ==
			RET_YES )
		{
			m_bPerformInstall = FALSE;
			if( m_pAgenda != NULL )
				m_pAgenda->StopRunning();
		}
		m_bInterrupt = FALSE;
	}
	else
		PostUserEvent(EVT_END);

	return 0;
}

// -----------------------------------------------------------------------

#ifdef MAC

IMPL_LINK( SetupApp, ExitMenuHdl, Menu *, pMenu )
{
	if ( pMenu->GetCurItemId() == MN_ABOUT )
		InfoBox( GetAppWindow(), ByteString( ResId( STR_ABOUT ) ) ).Execute();

	if ( pMenu->GetCurItemId() == MN_QUIT )
	{
		ExitHdl(NULL);
	}
	return 0;
}

#endif

// -----------------------------------------------------------------------

void SetupApp::MainWindowResize()
{
	if( m_pMainDlg )
	{
		Point aPnt = m_pMainWin->GetContWin()->GetPosPixel();
		Size aSiz = m_pMainDlg->GetSizePixel(),
			aWinSiz = m_pMainWin->GetContWin()->GetSizePixel();

		long nXDelta = ( aWinSiz.Width() - aSiz.Width()  ) / 2;
		long nYDelta = ( aWinSiz.Height() - aSiz.Height()  ) / 2;

		if ( nXDelta > 0 )
			aPnt.X() += nXDelta;
		if ( nYDelta > 0 )
			aPnt.Y() += nYDelta;
		m_pMainDlg->SetPosPixel( aPnt );
	}
}

// -----------------------------------------------------------------------

void SetupApp::ShowScriptNotFound()
{
	m_pMainDlg = new SetupAgentDialog( ((SetupWindow*)GetAppWindow())->GetContWin(), m_pResMan );

	m_pMainDlg->SetLanguage(GetLanguage());
	m_pMainDlg->SetEnv(m_pEnv);

	m_pMainDlg->CreateModel_ScriptNotFound();
	m_pMainDlg->StartAgentDlg();
	m_pMainDlg->Show();

	m_pMainDlg->DoModal();

	delete m_pMainDlg;
	m_pMainDlg = NULL;
}

// -----------------------------------------------------------------------

void SetupApp::PostUserEvent( ULONG nEvent )
{
    if ( m_bNoVcl )
    {
    	MutexGuard aGuard( &m_aMutex );

        if ( m_pFirstEvent )
        {
            SetupEventData* pEvent = m_pFirstEvent;
            while ( pEvent->m_pNext )
                pEvent = pEvent->m_pNext;
            pEvent->m_pNext = new SetupEventData( nEvent );
        }
        else
            m_pFirstEvent = new SetupEventData( nEvent );
    }
    else
        Application::PostUserEvent( nEvent );
}

// -----------------------------------------------------------------------

void SetupApp::HandleUserEvents()
{
    while ( m_pFirstEvent )
    {
    	MutexGuard aGuard( &m_aMutex );
        SetupEventData* pData = m_pFirstEvent;
        m_pFirstEvent = pData->m_pNext;
        UserEvent( pData->m_nEvent, NULL );
        delete pData;
    }
}

// -----------------------------------------------------------------------

// Forward declaration
void Main();

// -----------------------------------------------------------------------

SAL_IMPLEMENT_MAIN()
{
#if 0
    // bootstrap an initial context and set it as process service manager
	Reference<XComponentContext> xComponentContext = defaultBootstrap_InitialComponentContext();
	Reference<XMultiServiceFactory> xMS(xComponentContext->getServiceManager(), UNO_QUERY);

	comphelper::setProcessServiceFactory(xMS);

    InitVCL( xMS );
    aSetupApp.Main();
    DeInitVCL();
#endif

    aSetupApp.Main();

	#ifdef UNX
	_exit(0);
	#endif

    return 0;
}
