/*************************************************************************
 *
 *  $RCSfile: pimode.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: lla $ $Date: 2001/09/03 12:25:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _INTN_HXX //autogen
#include <tools/intn.hxx>
#endif

#include "maindlg.hxx"
#include "script.hxx"
#include "environ.hxx"
#include "agenda.hxx"
//#include "script.hxx"
#include "sihelp.hxx"
#include "os.hxx"

#include "pimode.hxx"
#include "pimode.hrc"

#define PROP_MAXIMAL		1
#define PROP_MINIMAL		2
#define PROP_USERDEFINED	3
#define PROP_WORKSTATION	4

String GetSizeStr(ULONG lSize)
{
	ULONG lMB = ((1024L * 1024L) / 10L); // Umrechnung: Bytes -> 100 KB
	lSize /= lMB;

	String aSize;
	FormatTable aIntl;

	aSize  = UniString::CreateFromInt32( lSize / 10 );
	aSize += aIntl.GetNumDecimalSep();
	aSize += UniString::CreateFromInt32( lSize % 10 );

	return aSize;
}

// -----------------------------------------------------------------------------
// ------------------------------- static Values -------------------------------
// -----------------------------------------------------------------------------
namespace
{
	bool           static_bUserMode        = false;
	CalculatedSize static_aCalculatedSizes;
}

// -----------------------------------------------------------------------------
PageInstallMode::PageInstallMode( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	m_aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	m_aRBMaximal		( this, ResId(RB_MAXIMAL, rResId.GetResMgr()) ),
	m_aRBUserDefined	( this, ResId(RB_USERDEFINED, rResId.GetResMgr()) ),
	m_aRBMinimal		( this, ResId(RB_MINIMAL, rResId.GetResMgr()) ),
	m_aRBWorkstation	( this, ResId(RB_WORKSTATION, rResId.GetResMgr()) ),
	m_aFTMaximal		( this, ResId(FT_MAXIMAL, rResId.GetResMgr()) ),
	m_aFTUserDefined	( this, ResId(FT_USERDEFINED, rResId.GetResMgr()) ),
	m_aFTMinimal		( this, ResId(FT_MINIMAL, rResId.GetResMgr()) ),
	m_aFTWorkstation	( this, ResId(FT_WORKSTATION, rResId.GetResMgr()) ),
	m_aStr_NetRBTextMax( ResId(STR_RB_TEXT_MAX, rResId.GetResMgr()) ),
	m_aStr_NetFTTextMax( ResId(STR_FT_TEXT_MAX, rResId.GetResMgr()) )
{
	SiEnvironment* pEnv = GETDLG()->GetEnv();

	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(pEnv->GetProductName().GetBuffer()) );
	pParent->SetTitleStr( aTitle );

	FreeResource();

	Font aBold( m_aRBMaximal.GetFont() );
	aBold.SetWeight(WEIGHT_BOLD);

	m_aRBMaximal.		SetFont(aBold);
	m_aRBUserDefined.	SetFont(aBold);
	m_aRBMinimal.		SetFont(aBold);
	m_aRBWorkstation.	SetFont(aBold);

	String aProductName( UniString::CreateFromAscii(pEnv->GetProductName().GetBuffer()) );
	String aText;

	aText = m_aFTMaximal.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%s"), aProductName );
	m_aFTMaximal.SetText( aText );

	aText = m_aFTUserDefined.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%s"), aProductName );
	m_aFTUserDefined.SetText( aText );

	m_aStr_NetFTTextMax.SearchAndReplace( UniString::CreateFromAscii("%s"), aProductName );

	SiInstallation* pInst = GETDLG()->GetCScript()->GetInstallation();
	if( pInst != NULL && pInst->GetInstallMode() != IM_NETWORK )
	{
		m_aRBWorkstation.Hide();
		m_aFTWorkstation.Hide();
	}
	else
	{
		m_aRBUserDefined.Hide();
		m_aFTUserDefined.Hide();
		m_aRBMinimal.Hide();
		m_aFTMinimal.Hide();

		if( pInst->IsHideStandard() )
		{
			m_aRBMaximal.Hide();
			m_aFTMaximal.Hide();
		}
		else
		{
			m_aRBMaximal.SetText( m_aStr_NetRBTextMax );
			m_aFTMaximal.SetText( m_aStr_NetFTTextMax );

#define DEF_Y_OFFSET 100

			Point aPt( m_aRBMaximal.GetPosPixel() );
			aPt.Y() += DEF_Y_OFFSET;
			m_aRBMaximal.SetPosPixel( aPt );

			aPt = m_aFTMaximal.GetPosPixel();
			aPt.Y() += DEF_Y_OFFSET;
			m_aFTMaximal.SetPosPixel( aPt );
			m_aRBMaximal.Check(TRUE);
		}
	}

	if (static_bUserMode == false)
	{
		// do the size calculation only once.
		InitSizes(static_aCalculatedSizes);
	}
	replaceSizeInText(static_aCalculatedSizes);
}

PageInstallMode::~PageInstallMode()
{
}

SvAgentPage* PageInstallMode::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageInstallMode( pParent, rResId );
}

USHORT PageInstallMode::GetReturnVal()
{
	SiEnvironment* pEnv = GETDLG()->GetEnv();
	SiCompiledScript* pCS = GETDLG()->GetCScript();

	SiModule* pRoot = GETDLG()->GetCScript()->GetRootModule();
	DBG_ASSERT( pRoot, "no rootmodule" );

	SiInstallType eOldType = pEnv->GetInstallType();

	// Maximal Installation
	if(	m_aRBMaximal.IsChecked() )
	{
		if( pRoot )
			pRoot->Select( SiModule::ALL_DEFAULT );
		pEnv->SetInstallType( IT_MAXIMAL );
		static_bUserMode = false;
	}
	// Userdefined Installation
	else if( m_aRBUserDefined.IsChecked() )
	{
		if( pRoot && (static_bUserMode==false))
		{
			// #89234# set values only if we run the first time in the setup.
			// second time, all values should set.
			pRoot->Select( SiModule::ALL_DEFAULT );
			static_bUserMode = true;
		}
		pEnv->SetInstallType( IT_USERDEFINED );
	}
	// Minimal Installation
	else if( m_aRBMinimal.IsChecked() )
	{
		if( pRoot )
			pRoot->Select( SiModule::ALL_MINIMAL );
		pEnv->SetInstallType( IT_MINIMAL );
		static_bUserMode = false;
	}
	// Workstation Installation
	else if( m_aRBWorkstation.IsChecked() )
	{
		if( pRoot )
			pRoot->Select( SiModule::ALL_SEL );
/*		if( pRoot )
			pRoot->Select( SiModule::ALL_INSTALLED );
*/		pEnv->SetInstallType( IT_WORKSTATION );
		static_bUserMode = false;
	}

	if( eOldType != pEnv->GetInstallType() )
	{	// wenn der Installationstype geaendert wurde mussen die Properties der
		// Pathseite geloescht werden, damit sie eine erneute Korrektur auf das
		// erste Volume mit genuegend Platz faehrt.
		Model* pModel = GetAgentDlg()->GetModel( RESID_PAGE_PAGEINSTPATH );
		if( pModel )
			pModel->SetProperty( PROP_NOTSET );
	}

	if( pEnv->GetInstallType() == IT_USERDEFINED ||
		pCS->GetInstallation()->IsOnlyCustom() )
		return RETURN_USERDEFINED;

	return RETURN_NORMAL;
}

ULONG PageInstallMode::GetProperty()
{
	ULONG nPropReturn = PROP_NOTSET;

	if(	m_aRBMaximal.IsChecked() )
		nPropReturn = PROP_MAXIMAL;
	else if( m_aRBUserDefined.IsChecked() )
		nPropReturn = PROP_USERDEFINED;
	else if( m_aRBMinimal.IsChecked() )
		nPropReturn = PROP_MINIMAL;
	else if( m_aRBWorkstation.IsChecked() )
		nPropReturn = PROP_WORKSTATION;

	return nPropReturn;
}

void PageInstallMode::InitProperty(ULONG nProp)
{
	SiInstallation* pInst = GETDLG()->GetCScript()->GetInstallation();
	BOOL bIsNet = (pInst != NULL && pInst->GetInstallMode() == IM_NETWORK)? TRUE : FALSE;

	if( (nProp == PROP_NOTSET && !bIsNet) ||
		nProp == PROP_MAXIMAL )
		m_aRBMaximal.Check(TRUE);
	else if( nProp == PROP_MINIMAL )
		m_aRBMinimal.Check();
	else if( nProp == PROP_USERDEFINED )
		m_aRBUserDefined.Check();
	else if( (nProp == PROP_NOTSET && bIsNet) ||
			 nProp == PROP_WORKSTATION )
		m_aRBWorkstation.Check();
}

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
void PageInstallMode::InitSizes(CalculatedSize &_aCS)
{
	// IMPORTANT: This function has side effects to the old selected Modules

	SiEnvironment* pEnv = GETDLG()->GetEnv();
	ULONG				lCluster = OS::GetClusterSize( SiDirEntry(OS::GetGUIPath()) );
	ULONG				lRealCluster;
	SiCompiledScript*	pCScript = GETDLG()->GetCScript();
	SiModule*			pRoot;

	BOOL bIsFat = FALSE;
#ifdef OS2
	bIsFat = Os2OS::IsFATFileSystem( OS::GetGUIPath() );
#endif

	if( !pCScript ||
		(pRoot = pCScript->GetRootModule()) == NULL )
		return;

	pRoot->Select( SiModule::ALL_DEFAULT );
	ULONG lDefault = pRoot->CalculateSize( *pEnv, SiModule::DEFAULT, lCluster, FALSE, FALSE, bIsFat );

	lRealCluster = SiHelp::GetClusterSizeForFirstFreeVolume( lDefault, bIsFat );
	if( lRealCluster && lRealCluster != lCluster )
		lDefault = pRoot->CalculateSize( *pEnv, SiModule::DEFAULT, lRealCluster, FALSE, FALSE, bIsFat );

#ifdef OS2
	bIsFat = Os2OS::IsFATFileSystem( OS::GetGUIPath() );
#endif
	ULONG lTemp = pRoot->CalculateSize( *pEnv, SiModule::TEMP, lCluster, FALSE, FALSE, bIsFat );

	pRoot->Select( SiModule::ALL_MINIMAL );
	ULONG lMinimal = pRoot->CalculateSize( *pEnv, SiModule::MINIMAL, lCluster, FALSE, FALSE, bIsFat );

	lRealCluster = SiHelp::GetClusterSizeForFirstFreeVolume( lMinimal, bIsFat );
	if( lRealCluster && lRealCluster != lCluster )
		lMinimal = pRoot->CalculateSize( *pEnv, SiModule::MINIMAL, lRealCluster, FALSE, FALSE, bIsFat );

#ifdef OS2
	bIsFat = Os2OS::IsFATFileSystem( OS::GetGUIPath() );
#endif

	ULONG lTempMini = pRoot->CalculateSize( *pEnv, SiModule::TEMP, lCluster, FALSE, FALSE, bIsFat );
	ULONG lWork = pRoot->CalculateSize( *pEnv, SiModule::DEFAULT, lCluster, FALSE, TRUE, bIsFat );

	lDefault += GETDLG()->GetEnv()->GetMigrationSize();
	lMinimal += GETDLG()->GetEnv()->GetMigrationSize();
	lWork	 += GETDLG()->GetEnv()->GetMigrationSize();

	_aCS.lDefault  = lDefault;
	_aCS.lMinimal  = lMinimal;
	_aCS.lWork     = lWork;
	_aCS.lTemp     = lTemp;
	_aCS.lTempMini = lTempMini;
}

// -----------------------------------------------------------------------------

void PageInstallMode::replaceSizeInText(CalculatedSize const& _aCS)
{
	String aText( m_aFTMaximal.GetText() );
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), GetSizeStr(_aCS.lDefault) );
	aText.SearchAndReplace( UniString::CreateFromAscii("%2"), GetSizeStr(_aCS.lDefault + _aCS.lTemp) );
	m_aFTMaximal.SetText( aText );

	aText = m_aFTMinimal.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), GetSizeStr(_aCS.lMinimal) );
	aText.SearchAndReplace( UniString::CreateFromAscii("%2"), GetSizeStr(_aCS.lMinimal + _aCS.lTempMini) );
	m_aFTMinimal.SetText( aText );

	aText = m_aFTWorkstation.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), GetSizeStr(_aCS.lWork) );
	m_aFTWorkstation.SetText( aText );
}

