/*************************************************************************
 *
 *  $RCSfile: plicense.cxx,v $
 *
 *  $Revision: 1.4.4.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 11:07:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#include "maindlg.hxx"
#include "event.hxx"

#include "plicense.hxx"
#include "plicense.hrc"

PageLicense::PageLicense( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aTextEdit		( this, ResId(LICENCE_TEXT, rResId.GetResMgr()) ),
	aStrAccept		( ResId(LICENCE_ACCEPT, rResId.GetResMgr()) ),
	aStrNotAccept	( ResId(LICENCE_NOTACCEPT, rResId.GetResMgr()) )
{
	pParent->SetTitleStr( String(ResId(STR_TITLE, rResId.GetResMgr())) );
	FreeResource();

//	Font aTextFont( ByteString( ResId(RESID_LICENSE_FONTNAME)), GetFont().GetSize() );
//	aTextEdit.SetFont( aTextFont );

	pParent->SetNextText( aStrAccept );
//	pParent->SetBackText( aStrNotAccept );

	String aText( aFTInfo2.GetText() );

	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), aStrAccept );
	aText.SearchAndReplace( UniString::CreateFromAscii("%2"), pParent->GetCancelText() );
	while( aText.SearchAndReplace(UniString::CreateFromAscii("~"), UniString::CreateFromAscii("") ) != STRING_NOTFOUND );

	aFTInfo2.SetText( aText );
    aTextEdit.SetLeftMargin( 5 );
}

PageLicense::~PageLicense()
{
}

SvAgentPage* PageLicense::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageLicense( pParent, rResId );
}

BOOL PageLicense::SetLicenseFile( const String& rFileName )
{
	SvFileStream aReadStrm(rFileName, STREAM_READ);
	if( !aReadStrm.IsOpen() )
		return FALSE;

    aReadStrm.Seek( STREAM_SEEK_TO_END );
    ULONG nLength = aReadStrm.Tell();
    aReadStrm.Seek( STREAM_SEEK_TO_BEGIN );

    char* pBuf1 = new char[nLength+1];
    char* pBuf2 = pBuf1;
	ULONG nRead = aReadStrm.Read( pBuf1, nLength );
	aReadStrm.Close();
	pBuf1[nRead] = 0x00;

    // Skip leading byte order mark if present #104965#
    if ( ( nRead > 2 ) && ( 0 == strncmp( pBuf1, "\xEF\xBB\xBF", 3 ) ) )
        pBuf2 += 3;

	UniString aStr( pBuf2, RTL_TEXTENCODING_UTF8 );
	delete pBuf1;

	ULONG nPos;
	while ( ( nPos = aStr.Search( (char) 12 ) ) != STRING_NOTFOUND )
		aStr.Erase( (USHORT)nPos, 1 );

    aTextEdit.SetText( aStr );
    
    return TRUE;
}

BOOL PageLicense::NotifyBack() const
{
//	Application::PostUserEvent( EVT_EXIT );
	return TRUE;
}
