/*************************************************************************
 *
 *  $RCSfile: pmigrate.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: ok $ $Date: 2001/12/12 17:56:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SVT_FILEDLG_HXX //autogen
#include <svtools/filedlg.hxx>
#endif

#include "maindlg.hxx"
#include "maindlg.hrc"
#include "environ.hxx"
#include "script.hxx"
#include "sihelp.hxx"
#include "action.hxx"

#include "pmigrate.hxx"
#include "pmigrate.hrc"

PageMigration::PageMigration( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aCBDoMigration	( this, ResId(CB_DOMIGRATION, rResId.GetResMgr()) ),
	aEDPath			( this, ResId(ED_MIGRATIONPATH, rResId.GetResMgr()) ),
	aBtnBrowse		( this, ResId(BTN_MIGRATIONPATH_BROWSE, rResId.GetResMgr()) )
{
	String aText( ResId(STR_TITLE, rResId.GetResMgr()) );
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );

	pParent->SetTitleStr( aText );
	FreeResource();

	aCBDoMigration.SetClickHdl( LINK(this, PageMigration, ClickHdl) );
	aBtnBrowse.SetClickHdl( LINK(this, PageMigration, BrowseHdl) );

	aBtnBrowse.Hide( TRUE );
	aEDPath.Enable( FALSE );
}

PageMigration::~PageMigration()
{
}

SvAgentPage* PageMigration::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageMigration( pParent, rResId );
}

USHORT PageMigration::GetReturnVal()
{
	if( GETDLG()->GetEnv()->DoMigration() )
		return PMIGRATION_YES;
	return PMIGRATION_NO;
}

ULONG PageMigration::GetProperty()
{
	return 0;
}

void PageMigration::InitProperty(ULONG nProp)
{
	aCBDoMigration.Check( GETDLG()->GetEnv()->DoMigration() );
	aEDPath.SetText( UniString::CreateFromAscii(GETDLG()->GetEnv()->GetMigrationPath().GetBuffer()) );

//	aEDPath.Enable( aCBDoMigration.IsChecked() );
//	aBtnBrowse.Enable( aCBDoMigration.IsChecked() );
}

BOOL PageMigration::AllowNext()
{
	GETDLG()->GetEnv()->SetMigration( aCBDoMigration.IsChecked() );
	GETDLG()->GetEnv()->SetMigrationPath( ByteString(aEDPath.GetText(), osl_getThreadTextEncoding()) );
	GETDLG()->GetEnv()->SetMigrationSize( 0 );

	if( GETDLG()->GetEnv()->DoMigration() )
	{
		SiDirEntry aEntry( GETDLG()->GetEnv()->GetMigrationPath() );
		aEntry += ByteString("user");
	#ifdef UNX
		aEntry += ByteString("sofficerc");
	#else
		aEntry += ByteString("soffice.ini");
	#endif

		if( !aEntry.Exists() )
		{
			ErrorBox( this, WB_OK, String(ResId(STR_NOMIGRATIONDATA)) ).Execute();
			return FALSE;
		}

		if( GETDLG()->GetEnv()->IsFirstInstallation() &&
			GETDLG()->GetEnv()->IsLocal() )
		{
			SiModule* pRoot = GETDLG()->GetCScript()->GetRootModule();
			SiCustom* pMigPlugin = SiHelp::GetMigrationPlugin( pRoot );

			if( pMigPlugin )
			{
				SiCustomAction* pNew = new SiCustomAction( NULL,
							pRoot,
							pMigPlugin->GetDllName(),
							GETDLG()->GetEnv()->GetStartPath(),
							FALSE,
							FALSE,
							pMigPlugin,
                            GETDLG()->GetCScript() );

				pNew->SetKeepAlive();
				pNew->Execute( *(GETDLG()->GetEnv()) );

				GETDLG()->GetEnv()->SetMigrationSize( pNew->GetCustomFnc().fncPtrExecuteCalc() );
				pNew->SetKeepAlive( FALSE );
				pNew->GetCustomFnc().fncKill();
				delete pNew;
			}
		}
	}
	return TRUE;
}

IMPL_LINK( PageMigration, ClickHdl, Button*, pBtn )
{
//	aEDPath.Enable( aCBDoMigration.IsChecked() );
//	aBtnBrowse.Enable( aCBDoMigration.IsChecked() );
	return 0;
}

IMPL_LINK( PageMigration, BrowseHdl, Button*, pBtn )
{
	SiDirEntry aPath( aEDPath.GetText() );
	SiDirEntry aMyPath( GETDLG()->GetEnv()->GetStartPath() );

	if( !aPath.Exists() ||
		aPath == aMyPath )
	{
		aPath = aPath.GetDevice();
		aPath.ToAbs();
	}

	SiDirEntry aOldPath;
	aPath.SetCWD();

	PathDialog aDlg( GetAgentDlg(), 0, FALSE );
	aDlg.SetPath( aPath.GetFullUni() );

	if( aDlg.Execute() == RET_OK )
	{
		aEDPath.SetText( aDlg.GetPath() );
	}

	aOldPath.SetCWD();
	return 1;
}


