/*************************************************************************
 *
 *  $RCSfile: prepair.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ok $ $Date: 2001/05/29 15:38:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#include "maindlg.hxx"
#include "environ.hxx"
#include "decltor.hxx"
#include "script.hxx"

#include "prepair.hxx"
#include "prepair.hrc"

PageRepair::PageRepair( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aBtnText		( ResId(STR_BTNTEXT, rResId.GetResMgr()) ),
	aFILogo			( this, ResId(IMG_EXPMARK, rResId.GetResMgr()) ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aFTInfo3		( this, ResId(FT_INFO3, rResId.GetResMgr()) ),
	aFTInfo4		( this, ResId(FT_INFO4, rResId.GetResMgr()) )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	pParent->SetTitleStr( aTitle );
	FreeResource();

	aTitle = aFTInfo1.GetText();
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	aFTInfo1.SetText( aTitle );

	const SiProfile* pItem = GETDLG()->GetCScript()->GetOfficeINI();
	SiDirEntry aEntry( GETDLG()->GetEnv()->GetDestPath() );
	aEntry += pItem->GetDirectory()->GetName();
	aEntry += pItem->GetName();

	Font aBold( aFTInfo2.GetFont() );
	aBold.SetWeight( WEIGHT_BOLD );

	aFTInfo2.SetFont( aBold );
	aFTInfo2.SetText( aEntry.GetFullUni() );

	aTitle = aFTInfo3.GetText();
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	aFTInfo3.SetText( aTitle );

	aTitle = aFTInfo4.GetText();
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"), aBtnText );
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%2"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%3"), GETDLG()->GetCancelText() );
	aFTInfo4.SetText( aTitle );

	pParent->SetNextText( pParent->GetRepairText() );
}

PageRepair::~PageRepair()
{
}

SvAgentPage* PageRepair::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageRepair( pParent, rResId );
}

