/*************************************************************************
 *
 *  $RCSfile: fader.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 16:46:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#ifdef WNT
#include <tools/svwin.h>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#include <vcl/poly.hxx>
#include <vcl/sound.hxx>

#include "fader.hxx"
#include "speedctl.hxx"

#include <algorithm>

using namespace ::com::sun::star;

#define FADE_SPEED_SLOW_MS		1500UL
#define FADE_SPEED_MEDIUM_MS	 800UL
#define FADE_SPEED_FAST_MS		 300UL
#define FADESCROLL				(SCROLL_NOCHILDREN|SCROLL_NOERASE|SCROLL_NOINVALIDATE|SCROLL_NOWINDOWINVALIDATE)
#define TESTMAGIC()				if( FADER_MAGIC != nMagic ) return;
#define DIAG_WAIT(_def_eSpeed)	((FADE_SPEED_SLOW==(_def_eSpeed)) ? 30 : (FADE_SPEED_FAST==(_def_eSpeed)) ? 10 : 20)

// ----------------
// - SpeedControl -
// ----------------

ULONG ImplGetUnitsPerSec( FadeSpeed eSpeed, ULONG nDist )
{
	ULONG nResult = nDist * 1000UL;

	switch( eSpeed )
	{
		case( FADE_SPEED_SLOW ):
			nResult /= FADE_SPEED_SLOW_MS;
		break;

		case( FADE_SPEED_MEDIUM ):
			nResult /= FADE_SPEED_MEDIUM_MS;
		break;

		case( FADE_SPEED_FAST ):
			nResult /= FADE_SPEED_FAST_MS;
		break;
	}

	return nResult;
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

Fader::Fader( Window* pWindow, FuSlideShow* pShow ) :
		pWin		( pWindow ),
		pFuslShow	( pShow ),
		pVDev		( NULL ),
		pVDevOld	( NULL ),
		eEffect		( presentation::FadeEffect_NONE ),
		eSpeed		( FADE_SPEED_MEDIUM ),
		nMagic		( FADER_MAGIC ),
		bPixelMode	( FALSE )
{
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

Fader::~Fader()
{
	nMagic = 0L;
	SwitchToLogic();
}


/*************************************************************************
|*
|* altes Bild als virtuelles Device setzen
|*
\************************************************************************/

void Fader::SetOldVirtualDevice( VirtualDevice* pDev )
{
	pVDevOld = pDev;
}

/*************************************************************************
|*
|* neues Bild als virtuelles Device setzen
|*
\************************************************************************/

void Fader::SetNewVirtualDevice( VirtualDevice* pDev )
{
	pVDev = pDev;
}

/*************************************************************************
|*
|* ergibt die Schrittanzahl des Effektes fuer die uebergebene Geschwindigkeit
|*
\************************************************************************/

ULONG Fader::GetEffectSteps(FadeSpeed eSpeed) const
{
	ULONG nResult;

	switch( eSpeed )
	{
		case FADE_SPEED_SLOW:	nResult = FADE_SPEED_SLOW_MS;	break;
		case FADE_SPEED_MEDIUM: nResult = FADE_SPEED_MEDIUM_MS; break;
		case FADE_SPEED_FAST:	nResult = FADE_SPEED_FAST_MS;	break;
	}

	nResult /= WAIT_IN_EFFECT_MS; // alle WAIT_IN_... ms ein Schritt

	return nResult;
}


/*************************************************************************
|*
|* Warteroutine fuer die Zeitschleife im Ueberblendeffekt
|*
\************************************************************************/

void Fader::WaitInEffect( ULONG nMilliSeconds ) const
{
#ifdef WNT
	Sleep( nMilliSeconds );
#else
	ULONG		nCurrent = Time::GetSystemTicks();
	const ULONG	nEnd = nCurrent + nMilliSeconds;

	while( nCurrent < nEnd )
		nCurrent = Time::GetSystemTicks();
#endif
}

/*************************************************************************
|*
|* auf den Pixelmodus umstellen
|*
\************************************************************************/

void Fader::SwitchToPixel()
{
	if( !bPixelMode )
	{
		bPixelMode = TRUE;
		aOldMMWin = pWin->GetMapMode();
		aOldMMVDev = pVDev->GetMapMode();

		if( pVDevOld )
			aOldMMVDevOld = pVDevOld->GetMapMode();

		aTarget = pWin->LogicToPixel(aTargetLog);
		aSource = pVDev->LogicToPixel(aSourceLog);

		// Manchmal kommt es durch Rundungen in LogicToPixel dazu, dass die
		// Rechtecke nicht gleich gross sind; dann wird mit DrawOutDev nichts
		// uebertragen.
		Size aMinSize(aTarget.GetSize());
		aMinSize.Width() = Min(aMinSize.Width(), aSource.GetWidth());
		aMinSize.Height() = Min(aMinSize.Height(), aSource.GetHeight());
		aSource.SetSize(aMinSize);
		aTarget.SetSize(aMinSize);

		MapMode aNewMM(aOldMMWin);
		aNewMM.SetMapUnit(MAP_PIXEL);
		Fraction aFrac(1, 1);
		aNewMM.SetScaleX(aFrac);
		aNewMM.SetScaleY(aFrac);
		aNewMM.SetOrigin(Point(0, 0));

		pWin->SetMapMode(aNewMM);
		pVDev->SetMapMode(aNewMM);

		if( pVDevOld )
			pVDevOld->SetMapMode( aNewMM );
	}
}

/*************************************************************************
|*
|* auf den logischen Koordinatenmodus umstellen
|*
\************************************************************************/

void Fader::SwitchToLogic()
{
	if( bPixelMode )
	{
		bPixelMode = FALSE;

		if( pWin )
			pWin->SetMapMode(aOldMMWin);

		if( pVDev )
			pVDev->SetMapMode(aOldMMVDev);

		if( pVDevOld )
			pVDevOld->SetMapMode(aOldMMVDevOld);
	}
}

/*************************************************************************
|*
|* Effekt durchfuehren
|*
\************************************************************************/

void Fader::Fade()

{
	DBG_ASSERT( pWin, "kein Fenster gesetzt" );
	DBG_ASSERT( pVDev, "kein Quelldevice gesetzt" );
	DBG_ASSERT( aSourceLog.GetSize() == aTargetLog.GetSize(), "Quell- und Zielbereich unterschiedlich gross" );

	BOOL			bGrid = FALSE;
	const ULONG		nOldDrawMode = pWin->GetDrawMode();

	pWin->SetDrawMode( DRAWMODE_DEFAULT );
	SwitchToPixel();

	switch( eEffect )
	{
		case presentation::FadeEffect_NONE:					None( FALSE ); break;
		case presentation::FadeEffect_FADE_FROM_LEFT:		FadeFromLeft(); break;
		case presentation::FadeEffect_FADE_FROM_TOP:		FadeFromTop(); break;
		case presentation::FadeEffect_FADE_FROM_RIGHT:		FadeFromRight(); break;
		case presentation::FadeEffect_FADE_FROM_BOTTOM:		FadeFromBottom(); break;

		case presentation::FadeEffect_FADE_TO_CENTER:		FadeToCenter(); break;
		case presentation::FadeEffect_FADE_FROM_CENTER:		FadeFromCenter(); break;

		case presentation::FadeEffect_MOVE_FROM_LEFT:		MoveFromLeft(); break;
		case presentation::FadeEffect_MOVE_FROM_TOP:		MoveFromTop(); break;
		case presentation::FadeEffect_MOVE_FROM_RIGHT:		MoveFromRight(); break;
		case presentation::FadeEffect_MOVE_FROM_BOTTOM:		MoveFromBottom(); break;

		case presentation::FadeEffect_ROLL_FROM_LEFT:		RollFromLeft(); break;
		case presentation::FadeEffect_ROLL_FROM_TOP:		RollFromTop(); break;
		case presentation::FadeEffect_ROLL_FROM_RIGHT:		RollFromRight(); break;
		case presentation::FadeEffect_ROLL_FROM_BOTTOM:		RollFromBottom(); break;

		case presentation::FadeEffect_HORIZONTAL_STRIPES:	HorizontalStripes(); break;
		case presentation::FadeEffect_VERTICAL_STRIPES:		VerticalStripes(); break;

		case presentation::FadeEffect_CLOCKWISE:			Clockwise(); break;
		case presentation::FadeEffect_COUNTERCLOCKWISE:		CounterClockwise(); break;

		case presentation::FadeEffect_FADE_FROM_UPPERLEFT:	FadeFromUpperLeft(); break;
		case presentation::FadeEffect_FADE_FROM_UPPERRIGHT:	FadeFromUpperRight(); break;
		case presentation::FadeEffect_FADE_FROM_LOWERLEFT:	FadeFromLowerLeft(); break;
		case presentation::FadeEffect_FADE_FROM_LOWERRIGHT:	FadeFromLowerRight(); break;

		case presentation::FadeEffect_CLOSE_VERTICAL:		CloseVertical(); break;
		case presentation::FadeEffect_CLOSE_HORIZONTAL:		CloseHorizontal(); break;
		case presentation::FadeEffect_OPEN_VERTICAL:		OpenVertical(); break;
		case presentation::FadeEffect_OPEN_HORIZONTAL:		OpenHorizontal(); break;

		case presentation::FadeEffect_SPIRALIN_LEFT:		CellsSpiralInClockwise(); break;
		case presentation::FadeEffect_SPIRALIN_RIGHT:		CellsSpiralInCounterClockwise(); break;
		case presentation::FadeEffect_SPIRALOUT_LEFT:		CellsSpiralOutClockwise(); break;
		case presentation::FadeEffect_SPIRALOUT_RIGHT:		CellsSpiralOutCounterClockwise(); break;

		case presentation::FadeEffect_DISSOLVE:				CellsRandom(); break;

		case presentation::FadeEffect_WAVYLINE_FROM_LEFT:	CellsWavyLineFromLeft(); break;
		case presentation::FadeEffect_WAVYLINE_FROM_TOP:	CellsWavyLineFromTop(); break;
		case presentation::FadeEffect_WAVYLINE_FROM_RIGHT:	CellsWavyLineFromRight(); break;
		case presentation::FadeEffect_WAVYLINE_FROM_BOTTOM:	CellsWavyLineFromBottom(); break;

		case presentation::FadeEffect_RANDOM:				RandomEffect(); break;

		case presentation::FadeEffect_STRETCH_FROM_LEFT:    StretchFromLeft(); break;
		case presentation::FadeEffect_STRETCH_FROM_TOP:     StretchFromTop(); break;
		case presentation::FadeEffect_STRETCH_FROM_RIGHT:   StretchFromRight(); break;
		case presentation::FadeEffect_STRETCH_FROM_BOTTOM:  StretchFromBottom(); break;

		case presentation::FadeEffect_HORIZONTAL_LINES:     HorizontalLines(); break;
		case presentation::FadeEffect_VERTICAL_LINES:       VerticalLines(); break;

		default:											None( TRUE ); break;
	}

	// nicht im Reschedule des Effekts zerstoert?
	if( nMagic == FADER_MAGIC )
	{
		SwitchToLogic();
		pWin->SetDrawMode( nOldDrawMode );
	}
}
/*************************************************************************
|*
|* Ueberblenden ohne Effekt
|*
\************************************************************************/

void Fader::None( BOOL bWithBeep )
{
	if( bWithBeep )
		Sound::Beep();

	pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
					  aSource.TopLeft(), aSource.GetSize(), *pVDev);
}

/*************************************************************************
|*
|* Ueberblenden: von links drueberschieben
|*
\************************************************************************/

void Fader::MoveFromLeft()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
	nStep = aCtrl.GetNextStep();

	// alten Hintergrund zeichnen, wenn vorhanden
	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(),
						 *pVDevOld);
	}

	while( nOffset < aTarget.GetWidth() )
	{
		ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);
		Size  aSize;

		if (!pVDevOld)
		{
			// den gezeigten Teil der neuen Seite scrollen, dann einen neuen
			// Streifen dazuzeichnen
			Rectangle aScroll(aTarget);
			aScroll.Right() = aTarget.Left() + nOffset - 1;
			pWin->Scroll( nThisStep, 0, aScroll, FADESCROLL );
			nOffset += nThisStep;
			aSize.Width()   = nThisStep;
			aSize.Height()  = aTarget.GetHeight();
		}
		else
		{
			// den gesamten jetzt sichtbaren Teil der neuen Seite zeichnen
			nOffset += nThisStep;
			aSize.Width()  = nOffset;
			aSize.Height() =  aTarget.GetHeight();
		}

		pWin->DrawOutDev(
				aTarget.TopLeft(), aSize,
				Point(aSource.Right() - nOffset + 1, aSource.Top()), aSize,
				*pVDev);

		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}
}

/*************************************************************************
|*
|* Ueberblenden: von rechts drueberschieben
|*
\************************************************************************/

void Fader::MoveFromRight()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
	nStep = aCtrl.GetNextStep();

	// alten Hintergrund zeichnen, wenn vorhanden
	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(),
						 *pVDevOld);
	}

	while( nOffset < aTarget.GetWidth() )
	{
		ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);
		Size  aSize;

		if (!pVDevOld)
		{
			// den gezeigten Teil der neuen Seite scrollen, dann einen neuen
			// Streifen dazuzeichnen
			Rectangle aScroll(aTarget);
			aScroll.Left() = aTarget.Right() - nOffset + 1;
			pWin->Scroll( -(long)nThisStep, 0, aScroll, FADESCROLL );
			aSize.Width() = nThisStep;
			aSize.Height() = aTarget.GetHeight();
			pWin->DrawOutDev(
					Point(aTarget.Right() - nThisStep + 1, aTarget.Top()),aSize,
					Point(aSource.Left() + nOffset, aSource.Top()), aSize,
					*pVDev);
			nOffset += nThisStep;
		}
		else
		{
			// den gesamten jetzt sichtbaren Teil der neuen Seite zeichnen
			nOffset += nThisStep;
			aSize.Width()  = nOffset;
			aSize.Height() =  aTarget.GetHeight();
			pWin->DrawOutDev(
					Point(aTarget.Right() - nOffset + 1, aTarget.Top()), aSize,
					aSource.TopLeft(), aSize,
					*pVDev);
		}

		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}
}

/*************************************************************************
|*
|* Ueberblenden: von oben drueberschieben
|*
\************************************************************************/

void Fader::MoveFromTop()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
	nStep = aCtrl.GetNextStep();

	// alten Hintergrund zeichnen, wenn vorhanden
	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(),
						 *pVDevOld);
	}

	while (nOffset < aTarget.GetHeight())
	{
		ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
		Size  aSize;

		if (!pVDevOld)
		{
			// den gezeigten Teil der neuen Seite scrollen, dann einen neuen
			// Streifen dazuzeichnen
			Rectangle aScroll(aTarget);
			aScroll.Bottom() = aTarget.Top() + nOffset - 1;
			pWin->Scroll( 0, nThisStep, aScroll, FADESCROLL );
			nOffset += nThisStep;
			aSize.Width()  = aTarget.GetWidth();
			aSize.Height() = nThisStep;
		}
		else
		{
			// den gesamten jetzt sichtbaren Teil der neuen Seite zeichnen
			nOffset += nThisStep;
			aSize.Width()  = aTarget.GetWidth();
			aSize.Height() = nOffset;
		}

		pWin->DrawOutDev(
				aTarget.TopLeft(), aSize,
				Point(aSource.Left(), aSource.Bottom() - nOffset + 1), aSize,
				*pVDev);

		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}
}

/*************************************************************************
|*
|* Ueberblenden: von unten drueberschieben
|*
\************************************************************************/

void Fader::MoveFromBottom()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
	nStep = aCtrl.GetNextStep();

	// alten Hintergrund zeichnen, wenn vorhanden
	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(),
						 *pVDevOld);
	}

	while (nOffset < aTarget.GetHeight())
	{
		ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
		Size  aSize;

		if (!pVDevOld)
		{
			// den gezeigten Teil der neuen Seite scrollen, dann einen neuen
			// Streifen dazuzeichnen
			Rectangle aScroll(aTarget);
			aScroll.Top() = aTarget.Bottom() - nOffset + 1;
			pWin->Scroll( 0, -(long)nThisStep, aScroll, FADESCROLL );
			aSize.Width() = aTarget.GetWidth();
			aSize.Height() = nThisStep;
			pWin->DrawOutDev(
					Point(aTarget.Left(), aTarget.Bottom() - nThisStep + 1),aSize,
					Point(aSource.Left(), aSource.Top() + nOffset), aSize,
					*pVDev);
			nOffset += nThisStep;
		}
		else
		{
			// den gesamten jetzt sichtbaren Teil der neuen Seite zeichnen
			nOffset += nThisStep;
			aSize.Width()  = aTarget.GetWidth();
			aSize.Height() = nOffset;
			pWin->DrawOutDev(
					Point(aTarget.Left(), aTarget.Bottom() - nOffset + 1), aSize,
					aSource.TopLeft(), aSize,
					*pVDev);
		}

		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}
}

/*************************************************************************
|*
|* Ueberblenden: von links druebermalen
|*
\************************************************************************/

void Fader::FadeFromLeft()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
	nStep = aCtrl.GetNextStep();

	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while( nOffset != aTarget.GetWidth() )
	{
		ULONG nThisStep = std::min ( (long) nStep, aTarget.GetWidth() - nOffset );

		nOffset += nThisStep;

		Size aSize( nThisStep, aTarget.GetHeight() );

		pWin->DrawOutDev(
			Point(aTarget.Left() + nOffset - nThisStep, aTarget.Top()), aSize,
			Point(aSource.Left() + nOffset - nThisStep, aSource.Top()), aSize,
			*pVDev);

		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}
}

/*************************************************************************
|*
|* ueberblenden von links oben
|*
\************************************************************************/

void Fader::FadeFromUpperLeft()
{
	const long	nMaxX = aTarget.GetWidth() + aTarget.GetHeight();
	const long	nExt = Max( nMaxX / 30L, 10L );
	const Size	aSize( nExt, nExt );
	long		nStartX = 0, nStartY = 0;
	long		nX, nY;
	const ULONG	nWait = DIAG_WAIT( eSpeed );

	if( pVDevOld )
		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(), aSource.TopLeft(), aSource.GetSize(), *pVDevOld );

	do
	{
		nX = nStartX, nY = nStartY, nStartX += nExt;

		do
		{
			Point aDstPt( nX + aTarget.Left(), nY + aTarget.Top() );

			if( !Rectangle( aDstPt, aSize ).Intersection( aTarget ).IsEmpty() )
				pWin->DrawOutDev( aDstPt, aSize, Point( nX + aSource.Left(), nY + aSource.Top() ), aSize, *pVDev );

			nX -= nExt, nY += nExt;
		}
		while( nX >= 0 );

		WaitInEffect( nWait );
		// Application::Reschedule();
		TESTMAGIC();
	}
	while( nStartX <= nMaxX );
}

/*************************************************************************
|*
|* Ueberblenden: von oben druebermalen
|*
\************************************************************************/

void Fader::FadeFromTop()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
	nStep = aCtrl.GetNextStep();

	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while (nOffset != aTarget.GetHeight())
	{
		ULONG nThisStep = std::max( std::min ((long)nStep, aTarget.GetHeight() - nOffset), 0L );

		Size aSize(aTarget.GetWidth(), nThisStep);

		pWin->DrawOutDev(Point(aTarget.Left(), aTarget.Top() + nOffset), aSize,
						 Point(aSource.Left(), aSource.Top() + nOffset), aSize,
						 *pVDev);

		nOffset += nThisStep;

		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}
}

/*************************************************************************
|*
|* ueberblenden von rechts oben
|*
\************************************************************************/

void Fader::FadeFromUpperRight()
{
	const long	nWidth = aTarget.GetWidth();
	const long	nMaxX = nWidth + aTarget.GetHeight();
	const long	nExt = Max( nMaxX / 30L, 10L );
	const Size	aSize( nExt, nExt );
	long		nStartX = nWidth - nExt, nStartY = 0;
	long		nFirstX = nStartX - nMaxX;
	long		nX, nY;
	const ULONG	nWait = DIAG_WAIT( eSpeed );

	if( pVDevOld )
		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(), aSource.TopLeft(), aSource.GetSize(), *pVDevOld );

	do
	{
		nX = nStartX, nY = nStartY, nStartX -= nExt;

		do
		{
			Point aDstPt( nX + aTarget.Left(), nY + aTarget.Top() );

			if( !Rectangle( aDstPt, aSize ).Intersection( aTarget ).IsEmpty() )
				pWin->DrawOutDev( aDstPt, aSize, Point( nX + aSource.Left(), nY + aSource.Top() ), aSize, *pVDev );

			nX += nExt, nY += nExt;
		}
		while( nX < nWidth );

		WaitInEffect( nWait );
		// Application::Reschedule();
		TESTMAGIC();
	}
	while( nStartX >= nFirstX );
}

/*************************************************************************
|*
|* Ueberblenden: von rechts druebermalen
|*
\************************************************************************/

void Fader::FadeFromRight()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
	nStep = aCtrl.GetNextStep();

	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while (nOffset != aTarget.GetWidth())
	{
		ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);

		nOffset += nThisStep;

		Size aSize(nThisStep, aTarget.GetHeight());

		pWin->DrawOutDev(
				Point(aTarget.Right() + 1 - nOffset, aTarget.Top()), aSize,
				Point(aSource.Right() + 1 - nOffset, aSource.Top()), aSize,
					  *pVDev);

		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}
}

/*************************************************************************
|*
|* ueberblenden von rechts unten
|*
\************************************************************************/

void Fader::FadeFromLowerRight()
{
	const long	nWidth = aTarget.GetWidth();
	const long	nMaxX = nWidth + aTarget.GetHeight();
	const long	nExt = Max( nMaxX / 30L, 10L );
	const Size	aSize( nExt, nExt );
	long		nStartX = nWidth - nExt, nStartY = aTarget.GetHeight() - nExt;
	long		nFirstX = nStartX - nMaxX;
	long		nLastY = -nExt;
	long		nX, nY;
	const ULONG	nWait = DIAG_WAIT( eSpeed );

	if( pVDevOld )
		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(), aSource.TopLeft(), aSource.GetSize(), *pVDevOld );

	do
	{
		nX = nStartX, nY = nStartY, nStartX -= nExt;

		do
		{
			Point aDstPt( nX + aTarget.Left(), nY + aTarget.Top() );

			if( !Rectangle( aDstPt, aSize ).Intersection( aTarget ).IsEmpty() )
				pWin->DrawOutDev( aDstPt, aSize, Point( nX + aSource.Left(), nY + aSource.Top() ), aSize, *pVDev );

			nX += nExt, nY -= nExt;
		}
		while( nY >= nLastY );

		WaitInEffect( nWait );
		// Application::Reschedule();
		TESTMAGIC();
	}
	while( nStartX >= nFirstX );
}

/*************************************************************************
|*
|* Ueberblenden: von unten druebermalen
|*
\************************************************************************/

void Fader::FadeFromBottom()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
	nStep = aCtrl.GetNextStep();

	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while (nOffset != aTarget.GetHeight())
	{
		ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);

		nOffset += nThisStep;

		Size aSize(aTarget.GetWidth(), nThisStep);

		pWin->DrawOutDev(
				Point(aTarget.Left(), aTarget.Bottom() + 1 - nOffset), aSize,
				Point(aSource.Left(), aSource.Bottom() + 1 - nOffset), aSize,
				*pVDev);

		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}
}

/*************************************************************************
|*
|* ueberblenden von links unten
|*
\************************************************************************/

void Fader::FadeFromLowerLeft()
{
	const long	nMaxX = aTarget.GetWidth() + aTarget.GetHeight();
	const long	nExt = Max( nMaxX / 30L, 10L );
	const Size	aSize( nExt, nExt );
	const long	nLastX = nMaxX + nExt;
	const long	nLastY = -nExt;
	long		nStartX = 0, nStartY = aTarget.GetHeight() - nExt;
	long		nX, nY;
	const ULONG	nWait = DIAG_WAIT( eSpeed );

	if( pVDevOld )
		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(), aSource.TopLeft(), aSource.GetSize(), *pVDevOld );

	do
	{
		nX = nStartX, nY = nStartY, nStartX += nExt;

		do
		{
			Point aDstPt( nX + aTarget.Left(), nY + aTarget.Top() );

			if( !Rectangle( aDstPt, aSize ).Intersection( aTarget ).IsEmpty() )
				pWin->DrawOutDev( aDstPt, aSize, Point( nX + aSource.Left(), nY + aSource.Top() ), aSize, *pVDev );

			nX -= nExt, nY -= nExt;
		}
		while( nY >= nLastY );

		WaitInEffect( nWait );
		// Application::Reschedule();
		TESTMAGIC();
	}
	while( nStartX <= nLastX );
}

/*************************************************************************
|*
|* Ueberblenden: von der Mitte aus druebermalen
|*
\************************************************************************/

void Fader::FadeFromCenter()
{
	SpeedControl	aCtrl( pWin );
	const long		nWidth = aTarget.GetWidth();
	const double	fFact = (double) aTarget.GetHeight() / ( nWidth ? nWidth : 1 );
	const Point		aCenter( aTarget.Left() + ( nWidth >> 1 ), aTarget.Top() + ( aTarget.GetHeight() >> 1 ) );
	Rectangle		aRect;
	ULONG			nHorStep = 0UL, nVertStep = 0UL;
	BOOL			bEnd = FALSE;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, nWidth ) );

	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while( !bEnd )
	{
		bEnd = ( aRect.Left() <= aTarget.Left() ) && ( aRect.Top() <= aTarget.Top() ) &&
			   ( aRect.Right() >= aTarget.Right() ) && ( aRect.Bottom() >= aTarget.Bottom() );

		if( nHorStep || nVertStep )
		{
			pWin->SetClipRegion( aRect );
			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
							  aSource.TopLeft(), aSource.GetSize(), *pVDev);
		}

		nHorStep += aCtrl.GetNextStep() ;
		nVertStep = (ULONG) ( fFact * nHorStep + 0.5 );
		TESTMAGIC();

		aRect.Left() = aCenter.X() - ( nHorStep >> 1 );
		aRect.Top() = aCenter.Y() - ( nVertStep >> 1 );
		aRect.Right() = aCenter.X() + ( nHorStep >> 1 );
		aRect.Bottom() = aCenter.Y() + ( nVertStep >> 1 );
	}

	pWin->SetClipRegion();
}

/*************************************************************************
|*
|* Ueberblenden: zur Mitte hin druebermalen
|*
\************************************************************************/

void Fader::FadeToCenter()
{
	SpeedControl	aCtrl( pWin );
	const long		nWidth = aTarget.GetWidth();
	ULONG			nHorzStep = 0UL, nVertStep = 0UL;
	const double	fFact = (double) aTarget.GetHeight() / ( nWidth ? nWidth : 1 );
	const Point		aCenter( aTarget.Left() + ( nWidth >> 1 ), aTarget.Top() + ( aTarget.GetHeight() >> 1 ) );
	Rectangle		aInner( aTarget );
	Rectangle		aOuter( aTarget );

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, nWidth ) );

	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	do
	{
		if( nHorzStep && nVertStep )
		{
			PolyPolygon	aPolyPoly;

			aPolyPoly.Insert( aInner );
			aPolyPoly.Insert( aOuter );
			aOuter = aInner;

			pWin->SetClipRegion( aPolyPoly );
			pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
							  aSource.TopLeft(), aSource.GetSize(), *pVDev );
		}

		nHorzStep += aCtrl.GetNextStep() ;
		nVertStep = (ULONG) ( fFact * nHorzStep + 0.5 );
		TESTMAGIC();

		aInner.Left() = aTarget.Left() + ( nHorzStep >> 1 );
		aInner.Top() = aTarget.Top() + ( nVertStep >> 1 );
		aInner.Right() = aTarget.Right() - ( nHorzStep >> 1 );
		aInner.Bottom() = aTarget.Bottom() - ( nVertStep >> 1 );
	}
	while( ( aInner.Left() < aCenter.X() ) || ( aInner.Top() < aCenter.Y() ) ||
		   ( aInner.Right() > aCenter.X() ) || ( aInner.Bottom() > aCenter.Y() ) );

	pWin->SetClipRegion( aOuter );
	pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
					  aSource.TopLeft(), aSource.GetSize(), *pVDev );
	pWin->SetClipRegion();
}

/*************************************************************************
|*
|* Ueberblenden: von links rollen
|*
\************************************************************************/

void Fader::RollFromLeft()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
	nStep = aCtrl.GetNextStep();

	// alte Bitmap nicht gesetzt, Window::Scroll() benutzen
	if( !pVDevOld )
	{
		while( nOffset != aTarget.GetWidth() )
		{
			ULONG nThisStep = std::min ( (long) nStep, aTarget.GetWidth() - nOffset );

			nOffset += nThisStep;

			Rectangle aScroll (aTarget);
			aScroll.Right() -= nThisStep;
			pWin->Scroll( nThisStep, 0, aScroll, FADESCROLL );

			Size aSize(nThisStep, aTarget.GetHeight());

			pWin->DrawOutDev(
					 aTarget.TopLeft(), aSize,
					 Point(aSource.Right() - nOffset + 1, aSource.Top()), aSize,
					 *pVDev);

			nStep = aCtrl.GetNextStep();
			TESTMAGIC();
		}
	}
	else
	{
		// alte Bitmap gesetzt, alles zeichnen statt Window::Scroll()
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);

		while( nOffset < aTarget.GetWidth() )
		{
			ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);

			nOffset += nThisStep;

			Size aSizeOfNew(nOffset, aTarget.GetHeight());
			Size aSizeOfOld(aTarget.GetWidth() - nOffset, aTarget.GetHeight());

			pWin->DrawOutDev(
					 aTarget.TopLeft(),
					 aSizeOfNew,
					 Point(aSource.Right() - nOffset + 1, aSource.Top()),
					 aSizeOfNew,
					 *pVDev);

			pWin->DrawOutDev(Point(aTarget.Left() + nOffset, aTarget.Top()),
							 aSizeOfOld,
							 aSource.TopLeft(),
							 aSizeOfOld,
							 *pVDevOld);

			nStep = aCtrl.GetNextStep();
			TESTMAGIC();
		}
	}
}

/*************************************************************************
|*
|* Ueberblenden: von rechts rollen
|*
\************************************************************************/

void Fader::RollFromRight()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() ) );
	nStep = aCtrl.GetNextStep();

	// alte Bitmap nicht gesetzt, Window::Scroll() benutzen
	if( !pVDevOld )
	{
		while (nOffset != aTarget.GetWidth())
		{
			ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);

			Rectangle aScroll(aTarget);
			aScroll.Left() += nThisStep;
			pWin->Scroll( -(long)nThisStep, 0, aScroll, FADESCROLL );
			Size aSize(nThisStep, aTarget.GetHeight());

			pWin->DrawOutDev(
					 Point(aTarget.Right() - nThisStep + 1, aTarget.Top()), aSize,
					 Point(aSource.Left() + nOffset, aSource.Top()), aSize,
					 *pVDev);

			nOffset += nThisStep;
			nStep = aCtrl.GetNextStep();
			TESTMAGIC();
		}
	}
	else
	{
		// alte Bitmap gesetzt, alles zeichnen statt Window::Scroll()
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);

		while (nOffset < aTarget.GetWidth())
		{
			ULONG nThisStep = std::min ((long)nStep, aTarget.GetWidth() - nOffset);
			nOffset += nThisStep;

			Size aSizeOfNew(nOffset, aTarget.GetHeight());
			Size aSizeOfOld(aTarget.GetWidth() - nOffset, aTarget.GetHeight());

			pWin->DrawOutDev(
					 Point(aTarget.Right() - nOffset + 1, aTarget.Top()),
					 aSizeOfNew,
					 aSource.TopLeft(),
					 aSizeOfNew,
					 *pVDev);

			pWin->DrawOutDev(aTarget.TopLeft(),
							 aSizeOfOld,
							 Point(aSource.Left() + nOffset, aSource.Top()),
							 aSizeOfOld,
							 *pVDevOld);

			nStep = aCtrl.GetNextStep();
			TESTMAGIC();
		}
	}
}

/*************************************************************************
|*
|* Ueberblenden: von oben rollen
|*
\************************************************************************/

void Fader::RollFromTop()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
	nStep = aCtrl.GetNextStep();

	// alte Bitmap nicht gesetzt, Window::Scroll() benutzen
	if(!pVDevOld)
	{
		while (nOffset != aTarget.GetHeight())
		{
			ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
			nOffset += nThisStep;

			Rectangle aScroll (aTarget);
			aScroll.Bottom() -= nThisStep;
			pWin->Scroll( 0, nThisStep, aScroll, FADESCROLL );
			Size aSize(aTarget.GetWidth(), nThisStep);

			pWin->DrawOutDev(
					 aTarget.TopLeft(), aSize,
					 Point(aSource.Left(), aSource.Bottom() - nOffset + 1), aSize,
					 *pVDev);

			nStep = aCtrl.GetNextStep();
			TESTMAGIC();
		}
	}

	// alte Bitmap gesetzt, alles zeichnen statt Window::Scroll()
	else
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);

		while (nOffset < aTarget.GetHeight())
		{
			ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
			nOffset += nThisStep;

			Size aSizeOfNew(aTarget.GetWidth(), nOffset);
			Size aSizeOfOld(aTarget.GetWidth(), aTarget.GetHeight() - nOffset);

			pWin->DrawOutDev(
					 aTarget.TopLeft(),
					 aSizeOfNew,
					 Point(aSource.Left(), aSource.Bottom() - nOffset + 1),
					 aSizeOfNew,
					 *pVDev);

			pWin->DrawOutDev(Point(aTarget.Left(), aTarget.Top() + nOffset),
							 aSizeOfOld,
							 aSource.TopLeft(),
							 aSizeOfOld,
							 *pVDevOld);

			nStep = aCtrl.GetNextStep();
			TESTMAGIC();
		}
	}
}

/*************************************************************************
|*
|* Ueberblenden: von unten rollen
|*
\************************************************************************/

void Fader::RollFromBottom()
{
	SpeedControl	aCtrl( pWin );
	long			nOffset = 0L;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() ) );
	nStep = aCtrl.GetNextStep();

	// alte Bitmap nicht gesetzt, Window::Scroll() benutzen
	if( !pVDevOld )
	{
		while (nOffset != aTarget.GetHeight())
		{
			ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);

			Rectangle aScroll(aTarget);
			aScroll.Top() += nThisStep;
			pWin->Scroll( 0, -(long)nThisStep, aScroll, FADESCROLL );
			Size aSize(aTarget.GetWidth(), nThisStep);

			pWin->DrawOutDev(
					 Point(aTarget.Left(), aTarget.Bottom() - nThisStep + 1),
					 aSize,
					 Point(aSource.Left(), aSource.Top() + nOffset),
					 aSize,
					 *pVDev);

			nOffset += nThisStep;
			nStep = aCtrl.GetNextStep();
			TESTMAGIC();
		}
	}

	// alte Bitmap gesetzt, alles zeichnen statt Window::Scroll()
	else
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);

		while (nOffset < aTarget.GetHeight())
		{
			ULONG nThisStep = std::min ((long)nStep, aTarget.GetHeight() - nOffset);
			nOffset += nThisStep;

			Size aSizeOfNew(aTarget.GetWidth(), nOffset);
			Size aSizeOfOld(aTarget.GetWidth(), aTarget.GetHeight() - nOffset);

			pWin->DrawOutDev(
					 Point(aTarget.Left(), aTarget.Bottom() - nOffset + 1),
					 aSizeOfNew,
					 aSource.TopLeft(),
					 aSizeOfNew,
					 *pVDev);

			pWin->DrawOutDev(aTarget.TopLeft(),
							 aSizeOfOld,
							 Point(aSource.Left(), aSource.Top() + nOffset),
							 aSizeOfOld,
							 *pVDevOld);

			nStep = aCtrl.GetNextStep();
			TESTMAGIC();
		}
	}
}

/*************************************************************************
|*
|* Ueberblenden: vertikal blenden
|*
\************************************************************************/

void Fader::VerticalStripes()
{
	SpeedControl	aCtrl( pWin );
	ULONG			nNoOfStripes = 5;
	ULONG			nStripeWidth = aTarget.GetWidth() / nNoOfStripes;
	ULONG			nRect;
	Rectangle*		pRect = NULL;
	List			aRectList;
	BOOL			bDone = FALSE;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, nStripeWidth / 2 ) );
	nStep = aCtrl.GetNextStep();

	for( nRect= 0; nRect < nNoOfStripes; nRect++ )
	{
		const ULONG nAxis = aTarget.Left() + nRect * nStripeWidth + nStripeWidth / 2;
		aRectList.Insert(new Rectangle(Point(nAxis, aTarget.Top()), Size(1, aTarget.GetHeight())), LIST_APPEND);
	}

	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while( !bDone )
	{
		bDone = TRUE;

		for( nRect = 0; nRect < nNoOfStripes; nRect++ )
		{
			pRect = (Rectangle*) aRectList.GetObject( nRect );

			Rectangle aRect( *pRect );

			aRect.Left() = Max( aRect.Left() - (long) nStep, aTarget.Left() );
			aRect.Right() = Min( aRect.Right() + (long) nStep, aTarget.Right() );

			const Point aSrc( aSource.Left() + ( aRect.Left() - aTarget.Left() ),
							  aSource.Top() + ( aRect.Top() - aTarget.Top() ) );

			pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
							  aSrc, aRect.GetSize(), *pVDev );

			pRect->Left() = aRect.Left();
			pRect->Right() = aRect.Right();

			if( !nRect )
			{
				if( pRect->Left() > aTarget.Left() )
					bDone = FALSE;
			}
			else
			{
				// linke Kante an rechter Kante des Vorgaengers?
				if( pRect->Left() > ((Rectangle*)aRectList.GetObject(nRect - 1))->Right() + 1 )
					bDone = FALSE;

				// letzter Streifen: rechte Kante auf rechter Kante des Ausgabebereichs?
				if( ( nRect == nNoOfStripes - 1 ) && ( pRect->Right() < aTarget.Right() ) )
					bDone = FALSE;
			}
		}

		nStep = aCtrl.GetNextStep();
		if( nMagic != FADER_MAGIC )
			break;
	}

	for( pRect = (Rectangle*) aRectList.First(); pRect; pRect = (Rectangle*) aRectList.Next() )
		delete pRect;
}

/*************************************************************************
|*
|* Ueberblenden: horizontal blenden
|*
\************************************************************************/

void Fader::HorizontalStripes()
{
	SpeedControl	aCtrl( pWin );
	ULONG			nNoOfStripes = 5;
	ULONG			nStripeHeight = aTarget.GetHeight() / nNoOfStripes;
	ULONG			nRect;
	Rectangle*		pRect = NULL;
	List			aRectList;
	BOOL			bDone = FALSE;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, nStripeHeight / 2 ) );
	nStep = aCtrl.GetNextStep();

	for( nRect= 0; nRect < nNoOfStripes; nRect++ )
	{
		const ULONG nAxis = aTarget.Top() + nRect * nStripeHeight + nStripeHeight / 2;
		aRectList.Insert(new Rectangle(Point(aTarget.Left(), nAxis),Size(aTarget.GetWidth(), 1)), LIST_APPEND);
	}

	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while( !bDone )
	{
		bDone = TRUE;

		for( nRect = 0; nRect < nNoOfStripes; nRect++ )
		{
			pRect = (Rectangle*) aRectList.GetObject( nRect );

			Rectangle aRect( *pRect );

			aRect.Top() = Max( aRect.Top() - (long) nStep, aTarget.Top() );
			aRect.Bottom() = Min( aRect.Bottom() + (long) nStep, aTarget.Bottom() );

			const Point aSrc( aSource.Left() + ( aRect.Left() - aTarget.Left() ),
							  aSource.Top() + ( aRect.Top() - aTarget.Top() ) );

			pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
							  aSrc, aRect.GetSize(), *pVDev );

			pRect->Top() = aRect.Top();
			pRect->Bottom() = aRect.Bottom();

			if( !nRect )
			{
				if( pRect->Top() > aTarget.Top() )
					bDone = FALSE;
			}
			else
			{
				// obere Kante an unterer Kante des Vorgaengers?
				if( pRect->Top() > ((Rectangle*)aRectList.GetObject(nRect - 1))->Bottom() + 1 )
					bDone = FALSE;

				// letzter Streifen: untere Kante auf unterer Kante des Ausgabebereichs?
				if( ( nRect == nNoOfStripes - 1 ) && ( pRect->Bottom() < aTarget.Bottom() ) )
					bDone = FALSE;
			}
		}

		nStep = aCtrl.GetNextStep();
		if( FADER_MAGIC != nMagic )
			break;
	}

	for( pRect = (Rectangle*) aRectList.First(); pRect; pRect = (Rectangle*) aRectList.Next() )
		delete pRect;
}

/*************************************************************************
|*
|* im Uhrzeigersinn ueberblenden (dran denken: y waechst nach unten)
|*
\************************************************************************/

void Fader::Clockwise()
{
	SpeedControl	aCtrl( pWin );
	Polygon			aClip( 4 );
	const double	fStart = 0.75 * F_2PI;
	const double	fEnd = fStart + F_2PI;
	const double	fDiff = 8. * F_PI180;
	double			fPhi1, fPhi2, fSin, fCos;
	Point			aPnt( 2 * Max (aTarget.GetWidth(), aTarget.GetHeight() ), 0 );
	Point			aPnt1 = aPnt;
	Point			aPnt2 = aPnt1;
	Point			aCenter(aTarget.Left() + aTarget.GetWidth() / 2,
							aTarget.Top() + aTarget.GetHeight() / 2);

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, (ULONG) ( F_2PI * 10000. ) ) );
	nStep = aCtrl.GetNextStep();

	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	aClip[ 0 ] = aClip[ 3 ] = aCenter;

	fPhi1 = fPhi2 = fStart;

	while( fPhi2 < fEnd )
	{
		double fTemp = fPhi1 - fDiff;

		if( fTemp < fStart )
			fTemp = fStart;

		aPnt1 = aCenter;
		fSin = sin( fTemp );
		fCos = cos( fTemp );
		aPnt1.X() += (long) ( aPnt.X() * fCos - aPnt.Y() * fSin );
		aPnt1.Y() += (long) ( aPnt.X() * fSin + aPnt.Y() * fCos );

		aPnt2 = aCenter;
		fPhi1 = fPhi2 = fPhi1 + ( (double) nStep / 10000. );
		fSin = sin( fPhi2 );
		fCos = cos( fPhi2 );
		aPnt2.X() += (long) ( aPnt.X() * fCos - aPnt.Y() * fSin );
		aPnt2.Y() += (long) ( aPnt.X() * fSin + aPnt.Y() * fCos );

		aClip[ 1 ] = aPnt1;
		aClip[ 2 ] = aPnt2;

		pWin->SetClipRegion( aClip );
		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
						  aSource.TopLeft(), aSource.GetSize(), *pVDev );

		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}

	pWin->SetClipRegion();
	pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
					 aSource.TopLeft(), aSource.GetSize(), *pVDev);
}

/*************************************************************************
|*
|* gegen den Uhrzeigersinn ueberblenden (dran denken: y waechst nach unten)
|*
\************************************************************************/

void Fader::CounterClockwise()
{
	SpeedControl	aCtrl( pWin );
	Polygon			aClip( 4 );
	const double	fStart = 0.75 * F_2PI;
	const double	fEnd = fStart + F_2PI;
	const double	fDiff = 8. * F_PI180;
	double			fPhi1, fPhi2, fSin, fCos;
	Point			aPnt( 2 * Max (aTarget.GetWidth(), aTarget.GetHeight() ), 0 );
	Point			aPnt1 = aPnt;
	Point			aPnt2 = aPnt1;
	Point			aCenter(aTarget.Left() + aTarget.GetWidth() / 2,
							aTarget.Top() + aTarget.GetHeight() / 2);

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, (ULONG) ( F_2PI * 10000. ) ) );
	nStep = aCtrl.GetNextStep();

	if( pVDevOld )
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	aClip[ 0 ] = aClip[ 3 ] = aCenter;

	fPhi1 = fPhi2 = fStart;

	while( fPhi2 < fEnd )
	{
		double fTemp = fPhi1 - fDiff;

		if( fTemp < fStart )
			fTemp = fStart;

		aPnt1 = aCenter;
		fTemp = fStart - ( fTemp - fStart );
		fSin = sin( fTemp );
		fCos = cos( fTemp );
		aPnt1.X() += (long) ( aPnt.X() * fCos - aPnt.Y() * fSin );
		aPnt1.Y() += (long) ( aPnt.X() * fSin + aPnt.Y() * fCos );

		aPnt2 = aCenter;
		fPhi1 = fPhi2 = fPhi1 + ( (double) nStep / 10000. );
		fTemp = fStart - ( fPhi2 - fStart );
		fSin = sin( fTemp );
		fCos = cos( fTemp );
		aPnt2.X() += (long) ( aPnt.X() * fCos - aPnt.Y() * fSin );
		aPnt2.Y() += (long) ( aPnt.X() * fSin + aPnt.Y() * fCos );

		aClip[ 1 ] = aPnt1;
		aClip[ 2 ] = aPnt2;

		pWin->SetClipRegion( aClip );
		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
						  aSource.TopLeft(), aSource.GetSize(), *pVDev );

		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}

	pWin->SetClipRegion();
	pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
					 aSource.TopLeft(), aSource.GetSize(), *pVDev);
}

/*************************************************************************
|*
|* Vertikal schliessen
|*
\************************************************************************/

void Fader::CloseVertical()
{
	SpeedControl	aCtrl( pWin );
	Rectangle		aRect( aTarget );
	Point			aSrc;
	long			nOffset = 0UL;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() / 2 ) );
	nStep = aCtrl.GetNextStep();

	if( pVDevOld )
	{
		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
						  aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
	}

	while( TRUE )
	{
		aRect.Top() = aTarget.Top();
		aRect.Bottom() = aTarget.Top() + nOffset;
		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );
		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
						  aSrc, aRect.GetSize(), *pVDev );

		aRect.Top() = aTarget.Bottom() - nOffset;
		aRect.Bottom() = aTarget.Bottom();
		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );
		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
						  aSrc, aRect.GetSize(), *pVDev );

		if( ( aTarget.Top() + nOffset ) > ( aTarget.Bottom() - nOffset ) )
			break;

		nOffset += nStep;
		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}
}

/*************************************************************************
|*
|* Horizontal schliessen
|*
\************************************************************************/

void Fader::CloseHorizontal()
{
	SpeedControl	aCtrl( pWin );
	Rectangle		aRect( aTarget );
	Point			aSrc;
	long			nOffset = 0UL;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() / 2 ) );
	nStep = aCtrl.GetNextStep();

	if( pVDevOld )
	{
		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
						  aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
	}

	while( TRUE )
	{
		aRect.Left() = aTarget.Left();
		aRect.Right() = aTarget.Left() + nOffset;
		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );
		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
						  aSrc, aRect.GetSize(), *pVDev );

		aRect.Left() = aTarget.Right() - nOffset;
		aRect.Right() = aTarget.Right();
		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );
		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
						  aSrc, aRect.GetSize(), *pVDev );

		if( ( aTarget.Left() + nOffset ) > ( aTarget.Right() - nOffset ) )
			break;

		nOffset += nStep;
		nStep = aCtrl.GetNextStep();
		TESTMAGIC();
	}
}

/*************************************************************************
|*
|* Vertikal oeffnen
|*
\************************************************************************/

void Fader::OpenVertical()
{
	SpeedControl	aCtrl( pWin );
	Rectangle		aRect( aTarget );
	Point			aSrc;
	long			nOffset = 0L;
	long			nCenter = aTarget.Top() + aTarget.GetHeight() / 2;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetHeight() / 2 ) );
	nStep = aCtrl.GetNextStep();

	if( pVDevOld )
	{
		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
						  aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
	}

	while( TRUE )
	{
		aRect.Top() = Max( aTarget.Top(), nCenter - nOffset );
		aRect.Bottom() = Min( aTarget.Bottom(), nCenter + nOffset );
		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );

		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
						  aSrc, aRect.GetSize(), *pVDev );

		nOffset += nStep;
		nStep = aCtrl.GetNextStep();
		if( FADER_MAGIC != nMagic || aRect == aTarget )
			break;
	}
}


/*************************************************************************
|*
|* Horizontal oeffnen
|*
\************************************************************************/

void Fader::OpenHorizontal()
{
	SpeedControl	aCtrl( pWin );
	Rectangle		aRect( aTarget );
	Point			aSrc;
	long			nOffset = 0L;
	long			nCenter = aTarget.Left() + aTarget.GetWidth() / 2;

	aCtrl.Reset( ImplGetUnitsPerSec( eSpeed, aTarget.GetWidth() / 2 ) );
	nStep = aCtrl.GetNextStep();

	if( pVDevOld )
	{
		pWin->DrawOutDev( aTarget.TopLeft(), aTarget.GetSize(),
						  aSource.TopLeft(), aSource.GetSize(), *pVDevOld );
	}

	while( TRUE )
	{
		aRect.Left() = Max( aTarget.Left(), nCenter - nOffset );
		aRect.Right() = Min( aTarget.Right(), nCenter + nOffset );
		aSrc.X() = aSource.Left() + ( aRect.Left() - aTarget.Left() );
		aSrc.Y() = aSource.Top() + ( aRect.Top() - aTarget.Top() );

		pWin->DrawOutDev( aRect.TopLeft(), aRect.GetSize(),
						  aSrc, aRect.GetSize(), *pVDev );

		nOffset += nStep;
		nStep = aCtrl.GetNextStep();
		if( FADER_MAGIC != nMagic || aRect == aTarget )
			break;
	}
}

/*************************************************************************
|*
|* Anzahl der der Zellen horizontal und vertikal bestimmen
|* (erst NACH SwitchToPixel rufen!)
|*
|*   Hoehe a, Breite b, Zellgroesse z, etwa 500 Zellen
|*
|*   (1)  a = nRow * z
|*   (2)  b = nCol * z
|*   (3)  nRow * nCol = nCells
|*
|*                        1/2
|*    ==> z = (a*b/nCells)
|*
\************************************************************************/

void Fader::CalcCellParams(USHORT nCells)
{
	double fTemp = (double)aTarget.GetWidth() * (double)aTarget.GetHeight();
	fTemp /= nCells;
	fTemp = sqrt(fTemp);
	nPrefCellSize = (USHORT) fTemp;
	nPrefCellSize = Max(nPrefCellSize, (USHORT)1);

	nRowCount = aTarget.GetHeight() / nPrefCellSize;
	if (nRowCount * nPrefCellSize < aTarget.GetHeight())
		nRowCount++;
	nColCount = aTarget.GetWidth() / nPrefCellSize;
	if (nColCount * nPrefCellSize < aTarget.GetWidth())
		nColCount++;
}

/*************************************************************************
|*
|* Zellgroesse und -position fuer eine bestimmte Reihe und Spalte ermitteln
|*
\************************************************************************/

Rectangle Fader::GetCell(USHORT nCol, USHORT nRow) const
{
	// so gross
	Rectangle aRect(0, 0, nPrefCellSize, nPrefCellSize);

	// an dieser Position
	aRect.Move(nCol * nPrefCellSize, nRow * nPrefCellSize);

	// Korrektur fuer letzte Spalte und Reihe
	if (nCol == nColCount - 1)
		aRect.Right() = aTarget.Right() - aTarget.Left();
	if (nRow == nRowCount - 1)
		aRect.Bottom() = aTarget.Bottom() - aTarget.Top();

	return aRect;
}

/*************************************************************************
|*
|* Zellenweise einblenden: zufaellig
|*
\************************************************************************/

void Fader::CellsRandom()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	CalcCellParams(500);                // etwa 500 Zellen

	USHORT nCellCount = nColCount * nRowCount;
	USHORT nHits      = 0;
	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
	nPause = Max(nPause, (USHORT)1);

	char* pFlags = new char[nCellCount];
	memset(pFlags, 0, nCellCount);

	srand(1);

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while (nHits < nCellCount)
	{
		USHORT nCellIndex = rand();
		if (nCellIndex < nCellCount && !pFlags[nCellIndex])
		{
			nHits++;
			pFlags[nCellIndex] = 1;
			USHORT nRow = nCellIndex / nColCount;
			USHORT nCol = nCellIndex % nColCount;
			Rectangle aRect(GetCell(nCol, nRow));

			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 aSource.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 *pVDev);

			if( !( nHits % nPause ) )
			{
				// GetpApp()->Reschedule();
				if( FADER_MAGIC != nMagic )
					break;
				WaitInEffect(WAIT_IN_EFFECT_MS);
			}

		}
	}

	delete[] pFlags;
}

/*************************************************************************
|*
|* Zellenweise einblenden: von innen nach aussen und im Uhrzeigersinn
|*
\************************************************************************/

void Fader::CellsSpiralOutClockwise()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	CalcCellParams(100);         // etwa 100 Zellen

	USHORT nCellCount = nColCount * nRowCount;
	USHORT nHits      = 0;
	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
	nPause = Max(nPause, (USHORT)1);

	USHORT nDir = 0;            // rechts = 0, unten = 1, links = 2, oben = 3

	USHORT nXSteps;
	USHORT nYSteps;

	USHORT nCurX;
	USHORT nCurY;

	// Startpunkt, Startrichtung und Schrittweiten festlegen
	if (nColCount > nRowCount)
	{
		nDir = 0;
		nCurX = nRowCount / 2;
		if (nRowCount % 2 == 0)
			nCurX--;
		nCurY = nCurX;
		nXSteps = nColCount - 2 * nCurX - 1;
		nYSteps = 1;
	}
	else if (nColCount < nRowCount)
	{
		nDir = 1;
		nCurY = nColCount / 2;
		if (nColCount % 2 == 0)
			nCurY--;
		nCurX = nColCount - 1 - nCurY;
		nXSteps = 1;
		nYSteps = nRowCount - 2 * nCurY - 1;
	}
	else
	{
		nDir = 0;
		nCurX = nRowCount / 2;
		if (nRowCount % 2 == 0)
			nCurX--;
		nCurY = nCurX;
		nXSteps = nYSteps = 1;
	}

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	// die erste Zelle zeichnen und die naechste ermitteln (alle weiteren
	// Zellen werden jetzt NEBEN eine bereits gezeichnete Zelle gesetzt)
	Rectangle aRect(GetCell(nCurX, nCurY));
	pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
					 aRect.GetSize(),
					 aSource.TopLeft() + aRect.TopLeft(),
					 aRect.GetSize(),
					 *pVDev);
	nHits++;
	switch (nDir)
	{
		case 0: nCurX++; break;
		case 1: nCurY++; break;
		case 2: nCurX--; break;
		case 3: nCurY--; break;
	}

	while (nHits < nCellCount)
	{
		USHORT nStepMax = (nDir % 2) ?  nYSteps : nXSteps;

		for (USHORT nStep = 0; nStep < nStepMax && nHits < nCellCount; nStep++)
		{
			Rectangle aRect(GetCell(nCurX, nCurY));
			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 aSource.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 *pVDev);
			nHits++;

			// wenn noch ein Schritt in diese Richtung getan wird, hier
			// die naechste Zelle bestimmen
			if (nStep < nStepMax - 1)
			{
				switch (nDir)
				{
					case 0: nCurX++; break;
					case 1: nCurY++; break;
					case 2: nCurX--; break;
					case 3: nCurY--; break;
				}
			}

			if( !( nHits % nPause) )
			{
				// GetpApp()->Reschedule();
				if( FADER_MAGIC != nMagic )
					return;
				WaitInEffect(WAIT_IN_EFFECT_MS);
			}
		}

		// Schrittweite erhoehen
		if( nDir % 2 )
			nYSteps++;
		else
			nXSteps++;

		// Richtung wechseln und naechste Zelle bestimmen
		nDir++;
		if( nDir > 3 )
			nDir = 0;

		switch (nDir)
		{
			case 0: nCurX++; break;
			case 1: nCurY++; break;
			case 2: nCurX--; break;
			case 3: nCurY--; break;
		}
	}
}

/*************************************************************************
|*
|* Zellenweise einblenden: von innen nach aussen und gegen den Uhrzeigersinn
|*
\************************************************************************/

void Fader::CellsSpiralOutCounterClockwise()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	CalcCellParams(100);         // etwa 100 Zellen

	USHORT nCellCount = nColCount * nRowCount;
	USHORT nHits      = 0;
	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
	nPause = Max(nPause, (USHORT)1);

	USHORT nDir = 0;            // links = 0, unten = 1, rechts = 2, oben = 3

	USHORT nXSteps;
	USHORT nYSteps;

	USHORT nCurX;
	USHORT nCurY;

	// Startpunkt, Startrichtung und Schrittweiten festlegen (Berechnung wie
	// bei 'Clockwise', dann spiegeln
	if (nColCount > nRowCount)
	{
		nDir = 0;
		nCurX = nRowCount / 2;
		if (nRowCount % 2 == 0)
			nCurX--;
		nCurY = nCurX;
		nXSteps = nColCount - 2 * nCurX - 1;
		nYSteps = 1;
		nCurX = nColCount - 1 - nCurX;      // spiegeln
	}
	else if (nColCount < nRowCount)
	{
		nDir = 1;
		nCurY = nColCount / 2;
		if (nColCount % 2 == 0)
			nCurY--;
		nCurX = nColCount - 1 - nCurY;
		nXSteps = 1;
		nYSteps = nRowCount - 2 * nCurY - 1;
		nCurX = nColCount - 1 - nCurX;      // spiegeln
	}
	else
	{
		nDir = 0;
		nCurX = nRowCount / 2;
		if (nRowCount % 2 == 0)
			nCurX--;
		nCurY = nCurX;
		nXSteps = nYSteps = 1;
		nCurX = nColCount - 1 - nCurX;      // spiegeln
	}

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	// die erste Zelle zeichnen und die naechste ermitteln (alle weiteren
	// Zellen werden jetzt NEBEN eine bereits gezeichnete Zelle gesetzt)
	Rectangle aRect(GetCell(nCurX, nCurY));
	pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
					 aRect.GetSize(),
					 aSource.TopLeft() + aRect.TopLeft(),
					 aRect.GetSize(),
					 *pVDev);
	nHits++;
	switch (nDir)
	{
		case 0: nCurX--; break;
		case 1: nCurY++; break;
		case 2: nCurX++; break;
		case 3: nCurY--; break;
	}

	while (nHits < nCellCount)
	{
		USHORT nStepMax = (nDir % 2) ?  nYSteps : nXSteps;

		for (USHORT nStep = 0; nStep < nStepMax && nHits < nCellCount; nStep++)
		{
			Rectangle aRect(GetCell(nCurX, nCurY));
			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 aSource.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 *pVDev);
			nHits++;

			// wenn noch ein Schritt in diese Richtung getan wird, hier
			// die naechste Zelle bestimmen
			if (nStep < nStepMax - 1)
			{
				switch (nDir)
				{
					case 0: nCurX--; break;
					case 1: nCurY++; break;
					case 2: nCurX++; break;
					case 3: nCurY--; break;
				}
			}

			// warten
			if( !( nHits % nPause ) )
			{
				// GetpApp()->Reschedule();
				if( FADER_MAGIC != nMagic )
					return;
				WaitInEffect(WAIT_IN_EFFECT_MS);
			}
		}

		// Schrittweite erhoehen
		if( nDir % 2 )
			nYSteps++;
		else
			nXSteps++;

		// Richtung wechseln und naechste Zelle bestimmen
		nDir++;
		if( nDir > 3 )
			nDir = 0;

		switch (nDir)
		{
			case 0: nCurX--; break;
			case 1: nCurY++; break;
			case 2: nCurX++; break;
			case 3: nCurY--; break;
		}
	}
}

/*************************************************************************
|*
|* Zellenweise einblenden: von aussen nach innen und im Uhrzeigersinn
|*
\************************************************************************/

void Fader::CellsSpiralInClockwise()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	CalcCellParams(100);         // etwa 100 Zellen

	USHORT nCellCount = nColCount * nRowCount;
	USHORT nHits      = 0;
	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
	nPause = Max(nPause, (USHORT)1);

	USHORT nDir = 0;            // rechts = 0, unten = 1, links = 2, oben = 3

	USHORT nXSteps = nColCount;
	USHORT nYSteps = nRowCount;

	USHORT nCurX = 0;
	USHORT nCurY = 0;

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while (nHits < nCellCount)
	{
		USHORT nStepMax = (nDir % 2) ?  nYSteps : nXSteps;

		for (USHORT nStep = 0; nStep < nStepMax && nHits < nCellCount; nStep++)
		{
			Rectangle aRect(GetCell(nCurX, nCurY));
			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 aSource.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 *pVDev);
			nHits++;

			// wenn noch ein Schritt in diese Richtung getan wird, hier
			// die naechste Zelle bestimmen
			if (nStep < nStepMax - 1)
			{
				switch (nDir)
				{
					case 0: nCurX++; break;
					case 1: nCurY++; break;
					case 2: nCurX--; break;
					case 3: nCurY--; break;
				}
			}

			// warten
			if( !( nHits % nPause ) )
			{
				// GetpApp()->Reschedule();
				if( FADER_MAGIC != nMagic )
					return;
				WaitInEffect(WAIT_IN_EFFECT_MS);
			}
		}

		// Schrittweite verringern
		if( nDir % 2 )
			nXSteps--;
		else
			nYSteps--;

		// Richtung wechseln und naechste Zelle bestimmen
		nDir++;
		if( nDir > 3 )
			nDir = 0;

		switch (nDir)
		{
			case 0: nCurX++; break;
			case 1: nCurY++; break;
			case 2: nCurX--; break;
			case 3: nCurY--; break;
		}
	}
}

/*************************************************************************
|*
|* Zellenweise einblenden: von aussen nach innen und gegen den Uhrzeigersinn
|*
\************************************************************************/

void Fader::CellsSpiralInCounterClockwise()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	CalcCellParams(100);         // etwa 100 Zellen

	USHORT nCellCount = nColCount * nRowCount;
	USHORT nHits      = 0;
	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
	nPause = Max(nPause, (USHORT)1);

	USHORT nDir = 0;            // links = 0, unten = 1, rechts = 2, oben = 3

	USHORT nXSteps = nColCount;
	USHORT nYSteps = nRowCount;

	USHORT nCurX = nColCount - 1;
	USHORT nCurY = 0;

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while (nHits < nCellCount)
	{
		USHORT nStepMax = (nDir % 2) ?  nYSteps : nXSteps;

		for (USHORT nStep = 0; nStep < nStepMax && nHits < nCellCount; nStep++)
		{
			Rectangle aRect(GetCell(nCurX, nCurY));
			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 aSource.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 *pVDev);
			nHits++;

			// wenn noch ein Schritt in diese Richtung getan wird, hier
			// die naechste Zelle bestimmen
			if (nStep < nStepMax - 1)
			{
				switch (nDir)
				{
					case 0: nCurX--; break;
					case 1: nCurY++; break;
					case 2: nCurX++; break;
					case 3: nCurY--; break;
				}
			}

			// warten
			if( !( nHits % nPause ) )
			{
				// GetpApp()->Reschedule();
				if( FADER_MAGIC != nMagic )
					return;
				WaitInEffect(WAIT_IN_EFFECT_MS);
			}
		}

		// Schrittweite verringern
		if( nDir % 2 )
			nXSteps--;
		else
			nYSteps--;

		// Richtung wechseln und naechste Zelle bestimmen
		nDir++;
		if( nDir > 3 )
			nDir = 0;

		switch (nDir)
		{
			case 0: nCurX--; break;
			case 1: nCurY++; break;
			case 2: nCurX++; break;
			case 3: nCurY--; break;
		}
	}
}

