/*************************************************************************
 *
 *  $RCSfile: pguard.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ok $ $Date: 2001/09/05 13:24:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <io.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <windows.h>

#include "pguard.h"

// globals ---------------------------------------------------------------

#define _OPEN_R_FLAG 		_O_RDONLY | _O_BINARY
#define _OPEN_W_FLAG 		_O_CREAT | _O_TRUNC | _O_WRONLY | _O_BINARY

HINSTANCE	hInst;
#ifdef WIN
HANDLE	hInstallInst;
#else
UINT	hInstallInst;
#endif

#ifndef ULONG
#define ULONG unsigned long
#endif

HWND	hWnd;

#define WINDOW_WIDTH    280
#define WINDOW_HEIGHT   80

#define MAX_IDENTIFYER_LEN	100
#define LPARAM_ENUMWINDOWS	100
#define	INI_FILENAME		"\\pguard.ini"
#define MAX_BLOCK			32000
#define W16_MAX_SAVE_WAIT	18000

char 	aProcessIdentifyer[MAX_IDENTIFYER_LEN];
int 	nProcessIdentifyerLen;
DWORD	nProcessID = 0;

#ifdef WIN
#define GETTEXTEVENT( aHDC, cpText, nTxtLen, nWidth )				\
	nWidth = LOWORD ( GetTextExtent( aHDC, cpText, nTxtLen ) )
#else
#define GETTEXTEVENT( aHDC, cpText, nTxtLen, nWidth )				\
	{ 																\
		SIZE aSize; 												\
		GetTextExtentPoint32( aHDC, cpText, nTxtLen, &aSize ); 		\
		nWidth = aSize.cx;											\
	}
#endif

// EnumCallBack ----------------------------------------------------------
BOOL CALLBACK EnumCallBack( HWND hWnd, LPARAM lParam )
{

	char cWinTitle[MAX_IDENTIFYER_LEN];
	char cClassName[MAX_IDENTIFYER_LEN];

	memset( cWinTitle, 0, MAX_IDENTIFYER_LEN );
	memset( cClassName, 0, MAX_IDENTIFYER_LEN );

	GetWindowText( hWnd, cWinTitle, MAX_IDENTIFYER_LEN );
	GetClassName( hWnd, cClassName, MAX_IDENTIFYER_LEN );

	if( (strncmp(cWinTitle, aProcessIdentifyer, nProcessIdentifyerLen) == 0) &&
		(strcmp(cClassName, "SALFRAME") == 0) )
	{
	#ifdef WNT
		GetWindowThreadProcessId( hWnd, &nProcessID );
	#else
	   nProcessID = GetWindowTask( hWnd );
	#endif
		return FALSE;
	}
	return TRUE;
}

// IsUpdateApp -----------------------------------------------------------
BOOL GetAppPID()
{
	BOOL bResult = EnumWindows((WNDENUMPROC)EnumCallBack,
		LPARAM_ENUMWINDOWS );
	return !bResult;
}

// WinMain ---------------------------------------------------------------

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine,
					int nCmdShow )
{
	MSG message;
	if ( hPrevInstance )
		return FALSE;
	else if ( !InitApplication( hInstance ) )
		return FALSE;
	if ( !InitInstance( hInstance, nCmdShow ) )
		return FALSE;

	char szTitle[50];
	char szMessage[250];

	LoadString( hInst, IDS_TITLE, szTitle, sizeof(szTitle) );

	char aAppPath[256];
	char aIniFileName[256];

#ifdef WNT
	GetModuleFileName( NULL, aAppPath, 256 );
#else
	GetModuleFileName( hInst, aAppPath, 256 );
#endif

	long nAppPathLen = strlen( aAppPath );
	for( long nIdx = nAppPathLen; nIdx >= 0; --nIdx )
		if( aAppPath[nIdx] == '\\' )
		{
			aAppPath[nIdx] = 0;
			break;
		}

	strcpy( aIniFileName, aAppPath );
	strcat( aIniFileName, INI_FILENAME );

	int	hFileHandle = _open( aIniFileName, _OPEN_R_FLAG );

	// wenn es die pguard.ini gibt, dann sollen wir automatisch starten.
	if( hFileHandle != -1 )
	{
		char* pBuffer;
		pBuffer = new char[MAX_BLOCK];

		memset( pBuffer, 0, MAX_BLOCK );

		ULONG nRead = _read( hFileHandle, pBuffer, MAX_BLOCK );
		_close( hFileHandle );

		long nLen = strlen( pBuffer );
		for( long i = nLen; i >= 0; --i )
			if( pBuffer[i] == '\\' )
				break;
			else if( pBuffer[i] == 0x0a || pBuffer[i] == 0x0d )
				pBuffer[i] = 0;

		strcpy( aProcessIdentifyer, "StarOffice" );
		nProcessIdentifyerLen = strlen( aProcessIdentifyer );
#ifdef WIN
{
		MSG aMsg;
		unsigned short nSaveCnt = 0;

		while( GetAppPID() && nSaveCnt < W16_MAX_SAVE_WAIT )
		{
			if( ++nSaveCnt == 100 ) {
				ShowWindow( hWnd, SW_SHOW );
				UpdateWindow( hWnd );
			}
			PeekMessage(&aMsg, 0, 0, 0, PM_REMOVE);
		}
		if( nSaveCnt == W16_MAX_SAVE_WAIT )
		{
			ShowWindow( hWnd, SW_HIDE );
			UpdateWindow( hWnd );
			LoadString( hInst, IDS_OFFICE, szMessage, sizeof(szMessage) );
			MessageBox( NULL, szMessage, szTitle, MB_OK | MB_ICONSTOP );
			return message.wParam;
		}
}
#else
		if( GetAppPID() )
		{
			HANDLE hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, nProcessID);
			DWORD nResult = WaitForSingleObject(hProcess, 60000);
		}
#endif

		strcpy( aProcessIdentifyer, "StarMoney" );
		nProcessIdentifyerLen = strlen( aProcessIdentifyer );
#ifdef WIN
{		MSG aMsg;
		unsigned short nSaveCnt = 0;
		while( GetAppPID() && nSaveCnt < W16_MAX_SAVE_WAIT )
		{
			if( ++nSaveCnt == 100 ) {
				ShowWindow( hWnd, SW_SHOW );
				UpdateWindow( hWnd );
			}
			PeekMessage(&aMsg, 0, 0, 0, PM_REMOVE);
		}
		if( nSaveCnt == W16_MAX_SAVE_WAIT )
		{
			ShowWindow( hWnd, SW_HIDE );
			UpdateWindow( hWnd );
			LoadString( hInst, IDS_MONEY, szMessage, sizeof(szMessage) );
			MessageBox( NULL, szMessage, szTitle, MB_OK | MB_ICONSTOP );
			return message.wParam;
		}
}
#else
		if( GetAppPID() )
		{
			HANDLE hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, nProcessID);
			DWORD nResult = WaitForSingleObject(hProcess, 60000);
		}
#endif

		strcpy( aProcessIdentifyer, "Downloader" );
		nProcessIdentifyerLen = strlen( aProcessIdentifyer );
		if( GetAppPID() )
		{
			LoadString( hInst, IDS_DOWNLOADER, szMessage, sizeof(szMessage) );
			MessageBox( NULL, szMessage, szTitle, MB_OK | MB_ICONSTOP );
			return message.wParam;
		}

#ifdef WNT
		BOOL b = SetCurrentDirectory( aAppPath );
#endif
		ShowWindow( hWnd, SW_HIDE );
		UpdateWindow( hWnd );

		if( lpCmdLine && strlen(lpCmdLine) )
		{
			strcat(pBuffer, " ");
			strcat(pBuffer, lpCmdLine);
		}

		hInstallInst = WinExec( pBuffer, SW_SHOW );
		delete pBuffer;
	}
	else
	{
		strcpy( aProcessIdentifyer, "StarOffice" );
		nProcessIdentifyerLen = strlen( aProcessIdentifyer );
		if( GetAppPID() )
		{
			LoadString( hInst, IDS_OFFICE, szMessage, sizeof(szMessage) );
			MessageBox( NULL, szMessage, szTitle, MB_OK | MB_ICONSTOP );
			return message.wParam;
		}

		strcpy( aProcessIdentifyer, "Downloader" );
		nProcessIdentifyerLen = strlen( aProcessIdentifyer );
		if( GetAppPID() )
		{
			LoadString( hInst, IDS_DOWNLOADER, szMessage, sizeof(szMessage) );
			MessageBox( NULL, szMessage, szTitle, MB_OK | MB_ICONSTOP );
			return message.wParam;
		}

		strcpy( aProcessIdentifyer, "StarMoney" );
		nProcessIdentifyerLen = strlen( aProcessIdentifyer );
		if( GetAppPID() )
		{
			LoadString( hInst, IDS_MONEY, szMessage, sizeof(szMessage) );
			MessageBox( NULL, szMessage, szTitle, MB_OK | MB_ICONSTOP );
			return message.wParam;
		}

		char aAgLoader[256];
		strcpy( aAgLoader, aAppPath );
		strcat( aAgLoader, "\\agloader.exe" );
		if( lpCmdLine && strlen(lpCmdLine) )
		{
			strcat(aAgLoader, " ");
			strcat(aAgLoader, lpCmdLine);
		}

		hInstallInst = WinExec( aAgLoader, SW_SHOW );
	}

	return message.wParam;
}

// -----------------------------------------------------------------------

BOOL InitApplication( HINSTANCE hInstance )
{
	WNDCLASS  wc;

	wc.style		 = 0;
	wc.lpfnWndProc	 = MainWndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInstance;
	wc.hIcon		 = 0;
	wc.hCursor		 = LoadCursor( 0, IDC_ARROW );
	wc.hbrBackground = 0;
	wc.lpszMenuName  = 0;
	wc.lpszClassName = "SetupWClass";

	return RegisterClass( &wc );
}

BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{
	hInst = hInstance;

	hWnd = CreateWindow( "SetupWClass", 0, WS_POPUP | WS_DLGFRAME,
		( GetSystemMetrics( SM_CXSCREEN ) - WINDOW_WIDTH )	/ 2,
		( GetSystemMetrics( SM_CYSCREEN ) - WINDOW_HEIGHT ) / 2,
		WINDOW_WIDTH, WINDOW_HEIGHT, 0, 0, hInstance, 0 );

	if ( hWnd )
	{
		return TRUE;
	}
	else
		return FALSE;

	return TRUE;
}

LONG FAR PASCAL MainWndProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
	switch( message )
	{
		case WM_PAINT:
		{
			PAINTSTRUCT ps;
			RECT		rect;
			char		szBuffer[100];
			int 		nOldBkMode;

			BeginPaint( hWnd, &ps );
			GetClientRect( hWnd, &rect );
#if _MSC_VER < 1200
			FillRect( ps.hdc, &rect, GetStockObject( LTGRAY_BRUSH ) );
#else
			FillRect( ps.hdc, &rect, (HBRUSH__ *)GetStockObject( LTGRAY_BRUSH ) );
#endif

			nOldBkMode = SetBkMode( ps.hdc, TRANSPARENT );
			LoadString( hInst, IDS_INIT, szBuffer, sizeof(szBuffer) );
			int nWidth;
			GETTEXTEVENT( ps.hdc, szBuffer, lstrlen(szBuffer), nWidth );
			TextOut( ps.hdc, ( rect.right - nWidth ) / 2, 30, szBuffer, lstrlen(szBuffer) );
			SetBkMode( ps.hdc, nOldBkMode );
			EndPaint( hWnd, &ps );
			return 0;
		} break;

		default:
		{
			return DefWindowProc( hWnd, message, wParam, lParam );
		} break;
	}
	return 0;
}

