/*************************************************************************
 *
 *  $RCSfile: macropg.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: os $ $Date: 2001/05/17 12:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _MACROPG_HXX
#define _MACROPG_HXX

#include <basedlgs.hxx>
#include <tabdlg.hxx>

#ifndef _SFXMACITEM_HXX //autogen
#include <svtools/macitem.hxx>
#endif
#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
class _SfxMacroTabPage;
class SvStringsDtor;
class SvTabListBox;
class Edit;
class MultiLineEdit;
class String;

#if SUPD>399
typedef SvStringsDtor* (*FNGetRangeHdl)( _SfxMacroTabPage*,
										const String& rLanguage );

typedef SvStringsDtor* (*FNGetMacrosOfRangeHdl)( _SfxMacroTabPage*,
												const String& rLanguage,
												const String& rRange );
#else
typedef SvStringsDtor* (*FNGetRangeHdl)( _SfxMacroTabPage*,
										ScriptType eType );

typedef SvStringsDtor* (*FNGetMacrosOfRangeHdl)( _SfxMacroTabPage*,
												ScriptType eType,
												const String& rRange );
#endif

class SfxConfigGroupListBox_Impl;
class SfxConfigFunctionListBox_Impl;

class _SfxMacroTabPage : public SfxTabPage
{
	SvxMacroTableDtor aTbl;
#if _SOLAR__PRIVATE
	DECL_STATIC_LINK( _SfxMacroTabPage, SelectEvent_Impl, SvTabListBox * );
	DECL_STATIC_LINK( _SfxMacroTabPage, SelectGroup_Impl, ListBox * );
	DECL_STATIC_LINK( _SfxMacroTabPage, SelectMacro_Impl, ListBox * );

	DECL_STATIC_LINK( _SfxMacroTabPage, DoubleClickHdl_Impl, Control* );
	DECL_STATIC_LINK( _SfxMacroTabPage, AssignDeleteHdl_Impl, PushButton * );

	DECL_STATIC_LINK( _SfxMacroTabPage, ChangeScriptHdl_Impl, RadioButton * );
	DECL_STATIC_LINK( _SfxMacroTabPage, GetFocus_Impl, Edit* );
#endif
protected:
	PushButton*		pAssignPB;
	PushButton*		pDeletePB;
	ListBox*		pScriptTypeLB;
	SvTabListBox*	pEventLB;
	SfxConfigGroupListBox_Impl* pGroupLB;
	SfxConfigFunctionListBox_Impl* pMacroLB;

    FixedLine*      pEventGB;
    FixedLine*      pMacroGB;
	String*			pMacroStr;
#if SUPD<582
	String*			pJavaStr;
	MultiLineEdit*	pJavaED;
#endif
	FNGetRangeHdl	fnGetRange;
	FNGetMacrosOfRangeHdl fnGetMacroOfRange;

	BOOL			bReadOnly;

	_SfxMacroTabPage( Window* pParent, const ResId& rId,
						const SfxItemSet& rItemSet );

	void InitAndSetHandler();
	void FillEvents();
	void FillMacroList();
	void EnableButtons( const String& rLanguage );

public:

	virtual ~_SfxMacroTabPage();

	void AddEvent( const String & rEventName, USHORT nEventId );

	const SvxMacroTableDtor& GetMacroTbl() const 	  { return aTbl; }
	void SetMacroTbl( const SvxMacroTableDtor& rTbl ) { aTbl = rTbl; }
	void ClearMacroTbl()							  { aTbl.DelDtor(); }

	virtual void ScriptChanged( const String& rLanguage );

	// zum setzen / abfragen der Links
	void SetGetRangeLink( FNGetRangeHdl pFn ) 	{ fnGetRange = pFn; }
	FNGetRangeHdl GetGetRangeLink() const 		{ return fnGetRange; }
	void SetGetMacrosOfRangeLink( FNGetMacrosOfRangeHdl pFn )	{ fnGetMacroOfRange = pFn; }
	FNGetMacrosOfRangeHdl GetGetMacrosOfRangeLink() const 		{ return fnGetMacroOfRange; }

	// --------- Erben aus der Basis -------------
	virtual	BOOL FillItemSet( SfxItemSet& rSet );
	virtual	void Reset( const SfxItemSet& rSet );

	void SetReadOnly( BOOL bSet )
			{ bReadOnly = bSet; }
	BOOL IsReadOnly() const
			{ return bReadOnly; }
	void SelectEvent( const String& rEventName, USHORT nEventId );
};


class SfxMacroTabPage : public _SfxMacroTabPage
{
public:
	SfxMacroTabPage( Window* pParent, const ResId& rId,
					const SfxItemSet& rSet );

	// --------- Erben aus der Basis -------------
	static SfxTabPage* Create( Window* pParent, const SfxItemSet& rAttrSet );
};

class SfxSmallMacroTabPage : public _SfxMacroTabPage
{
public:
	SfxSmallMacroTabPage( Window* pParent, const ResId& rId,
					const SfxItemSet& rSet );

	// --------- Erben aus der Basis -------------
	static SfxTabPage* Create( Window* pParent, const SfxItemSet& rAttrSet );
};


class SfxMacroAssignDlg : public SfxSingleTabDialog
{
public:
	SfxMacroAssignDlg( Window* pParent, SfxItemSet& rSet );
	virtual	~SfxMacroAssignDlg();
};



#endif
