/*************************************************************************
 *
 *  $RCSfile: rmacceptor.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <osl/diagnose.h>

#include <cppuhelper/implbase1.hxx>

#include <com/sun/star/uno/XNamingService.hpp>

#include "rmacceptor.hxx"

using namespace ::cppu;
using namespace ::rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::connection;
using namespace ::com::sun::star::bridge;

namespace sfx2_rmacceptor {


	class OInstanceProvider : public WeakImplHelper1 < XInstanceProvider >
	{
	public:
		OInstanceProvider( const Reference < XMultiServiceFactory > r ) :
			m_rServiceManager( r )
			{}
	public:
		virtual Reference< XInterface > SAL_CALL getInstance( const OUString& sInstanceName )
			throw( ::com::sun::star::container::NoSuchElementException, RuntimeException);

	private:

		Reference < XMultiServiceFactory > m_rServiceManager;
	};


	Reference< XInterface >
	OInstanceProvider::getInstance( const ::rtl::OUString& sObjectName )
		throw( ::com::sun::star::container::NoSuchElementException, RuntimeException)
	{
		try
		{
			Reference < XInterface > r = m_rServiceManager->createInstance(
				OUString::createFromAscii("com.sun.star.uno.NamingService" ) );

			Reference < XNamingService > rNamingService( r , UNO_QUERY );

			if( rNamingService.is() )
			{
				rNamingService->registerObject(
					OUString::createFromAscii( "StarOffice.ServiceManager" ),
					m_rServiceManager );
				return r;
			}
		}
		catch ( ... )
		{

		}
		return Reference < XNamingService > ();
	}


	OAcceptorThread::OAcceptorThread(
		const Reference< ::com::sun::star::lang::XMultiServiceFactory > &r ,
		const OUString &sConnectionDescription ) :
		m_rSMgr( r ),
		m_sConnectionDescription( sConnectionDescription )
	{
		try
		{
			m_rAcceptor = Reference< XAcceptor > (
				m_rSMgr->createInstance(
				OUString::createFromAscii( "com.sun.star.connection.Acceptor" ) ),
				UNO_QUERY );

			m_rBridgeFactory = Reference < XBridgeFactory > (
				m_rSMgr->createInstance(
					OUString::createFromAscii( "com.sun.star.bridge.BridgeFactory" ) ),
				UNO_QUERY );
		}
		catch ( ... )
		{
			OSL_TRACE( "sfx2:OAcceptorThread: exception during creating services" );
		}
	}


	void OAcceptorThread::run()
	{
		sal_Int32 nIndex = m_sConnectionDescription.indexOf( (sal_Unicode) ';' );
		if( -1 == nIndex )
		{
			// wrong format
			return;
		}
		OUString sConnection = m_sConnectionDescription.copy( 0 , nIndex ).trim();
		nIndex++;
		sal_Int32 nIndex2 = m_sConnectionDescription.indexOf( (sal_Unicode) ';' , nIndex );
		if( -1 == nIndex2 )
		{
			nIndex2 = m_sConnectionDescription.getLength();
		}
		OUString sProtocol   = m_sConnectionDescription.copy( nIndex, nIndex2 - nIndex );

		while ( m_rAcceptor.is() && m_rBridgeFactory.is()  )
		{
			try
			{
				Reference < XConnection > rConnection =
					m_rAcceptor->accept( sConnection );

				if( ! rConnection.is() )
				{
					break;
				}

				Reference < XBridge > rBridge =
					m_rBridgeFactory->createBridge(
						OUString() ,
						sProtocol ,
						rConnection ,
						(XInstanceProvider * ) new OInstanceProvider( m_rSMgr ) );
			}
			catch ( ... )
			{
				OSL_TRACE( "sfx2:OAcceptorThread: unknown exception thrown" );
				break;
			}
		}
	}

	void OAcceptorThread::stopAccepting()
	{
		if( m_rAcceptor.is() )
		{
			m_rAcceptor->stopAccepting();
		}
	}
}

