/*************************************************************************
 *
 *  $RCSfile: cfgimex.cxx,v $
 *
 *  $Revision: 1.6.6.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 11:08:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SVSTDARR_ULONGS_DECL
#define _SVSTDARR_ULONGS
#include <svtools/svstdarr.hxx>
#endif

#pragma hdrstop

#include "cfgmgr.hxx"
#include "cfgitem.hxx"
#include "objsh.hxx"
#include "mnumgr.hxx"
#include "tbxmgr.hxx"
#include "tbxconf.hxx"
#include "imgmgr.hxx"
#include "sfx.hrc"
#include "cfgimpl.hxx"
#include "accmgr.hxx"
#include "stbmgr.hxx"
#include "evntconf.hxx"
#include "objface.hxx"

// STATIC DATA -----------------------------------------------------------

static const char pHeader[] = "Star Framework Config File";
#define CFG_STREAM_BUFFER_SIZE  5000
static const USHORT nVersion = 26;
static const char cCtrlZ = 26;

static const USHORT nTypesCount = 76;
const char* pStreamNames[] =
{
    "statusbar.xml",
    "mathstatusbar.xml",
    "chartstatusbar.xml",
    "calcstatusbar.xml",
    "drawstatusbar.xml",
    "writerstatusbar.xml",
    "globalkeybinding.xml",
    "mathkeybinding.xml",
    "chartkeybinding.xml",
    "calckeybinding.xml",
    "impresskeybinding.xml",
    "drawkeybinding.xml",
    "writerkeybinding.xml",
    "webkeybinding.xml",
    "defaultmenubar.xml",
    "mathmenubar.xml",
    "chartmenubar.xml",
    "calcmenubar.xml",
    "impressmenubar.xml",
    "drawmenubar.xml",
    "writermenubar.xml",
    "webmenubar.xml",
    "fullscreenbar.xml",
    "functionbar.xml",
    "formsnavigationbar.xml",
    "formsfilterbar.xml",
    "mathtoolbar.xml",
    "chartobjectbar.xml",
    "charttoolbar.xml",
    "calctextobjectbar.xml",
    "calcformsobjectbar.xml",
    "calcdrawobjectbar.xml",
    "calcgrapicobjectbar.xml",
    "calcformatobjectbar.xml",
    "calcpreviewbar.xml",
    "calctoolbar.xml",
    "drawbezierobjectbar.xml",
    "drawgluepointsobjectbar.xml",
    "impressgraphicobjectbar.xml",
    "drawdrawingobjectbar.xml",
    "impresstextobjectbar.xml",
    "drawtextobjectbar.xml",
    "impresstoolbar.xml",
    "impressoptionsbar.xml",
    "impresscommontaskbar.xml",
    "drawtoolbar.xml",
    "drawoptionsbar.xml",
    "drawgraphicobjectbar.xml",
    "impressoutlinetoolbar.xml",
    "impressslideviewtoolbar.xml",
    "impressslideviewobjectbar.xml",
    "writerbezierobjectbar.xml",
    "writerdrawingobjectbar.xml",
    "writerformsobjectbar.xml",
    "writerdrawtextobjectbar.xml",
    "writerframeobjectbar.xml",
    "writergraphicobjectbar.xml",
    "writernumobjectbar.xml",
    "writeroleobjectbar.xml",
    "writertableobjectbar.xml",
    "writertextobjectbar.xml",
    "writerpreviewobjectbar.xml",
    "websourceviewobjectbar.xml",
    "websourceviewtoolbar.xml",
    "webtextobjectbar.xml",
    "writertoolbar.xml",
    "webframeobjectbar.xml",
    "webgraphicobjectbar.xml",
    "weboleobjectbar.xml",
    "webtoolbar.xml",
    "imagelist.xml",
    "toolboxlayout.xml",
    "eventbindings.xml",
    "eventbindings.xml",
	"macrobar.xml",
	"basicstatusbar.xml"
};


const USHORT pTypes[] =
{
    4,
    20816,
    30002,
    26005,
    23007,
    20013,
    1,
    20815,
    20080,
    26006,
    23005,
    23008,
    20017,
    20020,
    261,
    20814,
    20081,
    26007,
    23006,
    23009,
    20016,
    20019,
    558,
    560,
    18003,
    18004,
    20050,
    30001,
    30513,
    25005,
    25047,
    25053,
    25054,
    25001,
    25006,
    25035,
    23015,
    23019,
    23030,
    23013,
    23016,
    23028,
    23011,
    23020,
    23021,
    23025,
    23026,
    23027,
    23017,
    23012,
    23014,
    23283,
    23269,
    23299,
    23270,
    23267,
    23268,
    23271,
    23272,
    23266,
    23265,
    20631,
    23282,
    20402,
    20403,
    23273,
    20408,
    20410,
    20411,
    20412,
    6,
    9,
    10,
    11,
	14850,
	30805
};

BOOL SfxConfigManagerImExport_Impl::HasConfiguration( SotStorage& rStorage )
{
    return rStorage.IsStream( String::CreateFromAscii(pHeader) );
}

USHORT SfxConfigManagerImExport_Impl::Import( SotStorage* pInStorage, SotStorage* pStorage )
{
	SotStorageStreamRef aStr =
        pInStorage->OpenSotStream( String::CreateFromAscii(pHeader), STREAM_STD_READ );
	if ( aStr->GetError() )
		return SfxConfigManager::ERR_OPEN;

	SvStream* pStream = aStr;
	pStream->SetVersion( SOFFICE_FILEFORMAT_40 );
	pStream->SetBufferSize( CFG_STREAM_BUFFER_SIZE );
	pStream->Seek(0);
	USHORT nRet = SfxConfigManager::ERR_NO;

	// check header
	const unsigned nLen = strlen( pHeader );
	char *pBuf = new char[nLen+1];
	pStream->Read( pBuf, nLen );
	pBuf[nLen] = 0;
	if( strcmp( pBuf, pHeader ) )
	{
		delete pBuf;
		return SfxConfigManager::ERR_FILETYPE;
	}

	delete pBuf;

	// compare version
	char c;
	USHORT nFileVersion;
	(*pStream) >> c;					// skip ASCII 26 (CTRL-Z)
	(*pStream) >> nFileVersion;
	if( nFileVersion != nVersion )
	{
		return SfxConfigManager::ERR_VERSION;
	}

	// get position of directory
	long lDirPos, lStart = pStream->Tell();
	(*pStream) >> lDirPos;
	pStream->Seek(lDirPos);

	// get number of items
	USHORT nCount;
	(*pStream) >> nCount;

	// read in directory and convert items
	for( USHORT i=0; i < nCount; ++i )
	{
		SfxConfigItem_Impl* pItem = new SfxConfigItem_Impl;
		pItemArr->Insert( pItem, pItemArr->Count() );

		// retrieve type of item and human readable name
		long lLength, lPos;	            // dummies
        (*pStream) >> pItem->nType >> lPos >> lLength;
		pItem->bDefault = ( lPos == -1L );
        pStream->ReadByteString( pItem->aName );
        if ( pStream->GetError() )
        {
            pItem->bDefault = TRUE;
            return SfxConfigManager::ERR_READ;
        }

		// convert into new format
        if ( !pItem->bDefault )
        {
            // stream name for new format
            pItem->aStreamName = GetStreamName( pItem->nType );
            if ( pItem->aStreamName.Len() )
            {
                long lOldPos = pStream->Tell();
                pStream->Seek( lPos );

                // check for correct type id, inequality is allowed for userdef toolboxes
                USHORT nType;
                (*pStream) >> nType;
                BOOL bOk = ( nType == pItem->nType ||
                            1294 <= nType && nType <= 1301 &&
                            1294 <= pItem->nType && pItem->nType <= 1301 );

                if ( !bOk || !ImportItem( pItem, pStream, pStorage ) )
                {
                    pItem->bDefault = TRUE;
                    nRet = SfxConfigManager::ERR_IMPORT;
                }

                pStream->Seek( lOldPos );
            }
            else
            {
                DBG_ERROR("Couldn't convert old configuration!");
                // force error message that saving this document would lose some configuration information
            }
        }

        if ( !pItem->aStreamName.Len() )
		{
            // no real config item anymore
			delete pItem;
			pItemArr->Remove( pItemArr->Count() - 1 );
		}
	}

	return nRet;
}

BOOL SfxConfigManagerImExport_Impl::ImportItem( SfxConfigItem_Impl* pItem, SvStream* pStream, SotStorage* pStor )
{
	BOOL bRet = TRUE;
	switch ( pItem->nType )
	{
    	// Statusbars
    	case SFX_ITEMTYPE_STATBAR :     // Global
    	case 20816 :        			// Math
    	case 30002 :      				// Chart
    	case 26005 :                    // Calc
    	case 23007 :                    // Impress/Draw
    	case 20013 :                    // Writer/WriterWeb
		{
			BOOL bOK = FALSE;
			SotStorageStreamRef xStream =
            		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
			if ( !xStream->GetError() )
				bOK = SfxStatusBarManager::Import( *pStream, *xStream );
			if ( bRet )
				bRet = bOK;
			break;
		}

    	// Accels
    	case SFX_ITEMTYPE_ACCEL :		// Global
		case 20815 :        			// Math
        case 20080 :        			// Chart
        case 26006 :        			// Calc
        case 20017 :        			// Impress
        case 20020 :        			// Draw
        case 23005 :        			// Writer
        case 23008 :        			// WriterWeb
        {
            SfxAcceleratorManager aMgr( pItem->nType, NULL );
            int nRet = aMgr.Load( *pStream );
            if ( nRet == SfxConfigItem::ERR_OK )
                bRet = aMgr.Store( *pStor );
			break;
        }

    	// Menues
    	case 20814 :        			// Math
    	case 20081 :       				// Chart
        case 26007 :        			// Calc
        case 23006 :        			// Impress
        case 23009 :        			// Draw
        case 20016 :        			// Writer
        case 20019 :        			// WriterWeb
		{
			BOOL bOK = FALSE;
			MenuBar* pMenu = (MenuBar*) SfxMenuManager::LoadMenu( *pStream );
			if ( pMenu )
			{
				SotStorageStreamRef xStream =
                    	pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
				if ( !xStream->GetError() )
					bOK = SfxMenuBarManager::StoreMenuBar( *xStream, pMenu );
				delete pMenu;
			}

			if ( bRet )
				bRet = bOK;
			break;
		}

    	// Toolboxes
        case 558 :                      // Fullscreenbar
        case 560 :                    	// Functionbar
        case 18003 :                    // FormularNavigationbar
        case 18004 :                    // FormularFilterbar
        case 20050 :                    // MathToolbar
    	case 30001 :                    // ChartObjectbar
    	case 30513 :                    // ChartToolbar
    	case 25005 :                    // CalcTextObjectbar
    	case 25047 :                    // CalcFormObjectbar
    	case 25053 :                    // CalcDrawObjectbar
    	case 25054 :                    // CalcGraphicObjectbar
    	case 25001 :                    // CalcFormatObjectbar
    	case 25006 :                    // CalcPreviewObjectbar
    	case 25035 :                    // CalcToolbar
		case 23015 :                    // DrawBezierObjectbar
        case 23019 :                    // DrawGluepointsObjectbar
        case 23030 :                    // ImpressGraphicObjectbar
        case 23013 :                    // DrawDrawingObjectbar
        case 23016 :                    // ImpressTextObjectbar
        case 23028 :                    // DrawTextObjectbar
        case 23011 :                    // ImpressToolbar
        case 23020 :                    // ImpressOptionsbar
        case 23021 :                    // ImpressCommontaskbar
        case 23025 :                    // DrawToolbar
        case 23026 :                    // DrawOptionsbar
        case 23027 :                    // DrawGraphicObjectbar
        case 23017 :                    // OutlineToolbar
        case 23012 :                    // SlideViewToolbar
        case 23014 :                    // SlideViewObjectbar
        case 23283 :                    // WriterBezierObjectbar
        case 23269 :                    // WriterDrawObjectbar
        case 23299 :                    // WriterFormularObjectbar
        case 23270 :                    // WriterDrawTextObjectbar
        case 23267 :                    // WriterFrameObjectbar
        case 23268 :                    // WriterGraphicObjectbar
        case 23271 :                    // WriterNumObjectbar
        case 23272 :                    // WriterOleObjectbar
        case 23266 :                    // WriterTableObjectbar
        case 23265 :                    // WriterTextObjectbar
        case 20631 :                    // WriterPagePreviewObjectbar
        case 23282 :                    // WriterWebSourceViewObjectbar
        case 20402 :                    // WriterWebSourceViewToolbox
        case 20403 :                    // WriterWebTextObjectbar
        case 23273 :                    // WriterToolbox
        case 20408 :                    // WriterWebFrameObjectbar
        case 20410 :                    // WriterWebGraphicObjectbar
        case 20411 :                    // WriterWebOleObjectbar
        case 20412 :                    // WriterWebToolbar ????????????????????
		{
			BOOL bOK = FALSE;
			SotStorageStreamRef xStream =
            		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
			if ( !xStream->GetError() )
				bOK = SfxToolBoxManager::Import( *pStream, *xStream );
			if ( bRet )
				bRet = bOK;
			break;
		}

    	case SFX_ITEMTYPE_IMAGELIST :
		{
			BOOL bOK = SfxImageManager::Import( *pStream, *pStor );
			if ( bRet )
				bRet = bOK;
			break;
		}

    	case SFX_ITEMTYPE_TOOLBOXCONFIG :
		{
			BOOL bOK = FALSE;
			SotStorageStreamRef xStream =
            		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
			if ( !xStream->GetError() )
				bOK = SfxToolBoxConfig::Import( *pStream, *xStream );
			if ( bRet )
				bRet = bOK;
			break;
		}

    	case SFX_ITEMTYPE_APPEVENTCONFIG :
        {
			BOOL bOK = FALSE;
			SotStorageStreamRef xStream =
            		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
			if ( !xStream->GetError() )
                bOK = SfxEventConfiguration::Import( *pStream, xStream );
			if ( bRet )
				bRet = bOK;
            break;
        }

    	case SFX_ITEMTYPE_DOCEVENTCONFIG :
        {
            BOOL bOK = SfxEventConfiguration::Import( *pStream, NULL, pObjShell );
			if ( bRet )
				bRet = bOK;
			break;
        }

    	default:
        	if ( pItem->nType >= SFX_ITEMTYPE_INTERFACE_START && pItem->nType <= SFX_ITEMTYPE_INTERFACE_END )
        	{
        	}
        	else if ( pItem->nType >= RID_SFX_TOOLBOX_START + 10 && pItem->nType <= RID_SFX_TOOLBOX_START + 17 )
        	{
				// user defined toolboxes
				BOOL bOK = FALSE;
				SotStorageStreamRef xStream =
            			pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
				if ( !xStream->GetError() )
					bOK = SfxToolBoxManager::Import( *pStream, *xStream );
				if ( bRet )
					bRet = bOK;
        	}
#ifdef  DBG_UTIL
			else
			{
				ByteString aMsg("SfxConfigManager: ConfigItem will not be imported : ");
				aMsg += ByteString::CreateFromInt32( pItem->nType );
				DBG_TRACE( aMsg.GetBuffer() );
			}
#endif
			break;
	}

	return bRet;
}

USHORT SfxConfigManagerImExport_Impl::Export( SotStorage* pStor, SotStorage *pOut )
{
    // try to adjust old item names
    for( USHORT nItem = 0; nItem<pItemArr->Count(); ++nItem )
    {
        SfxConfigItem_Impl* pItem = (*pItemArr)[nItem];
        if ( !pItem->aName.Len() )
            pItem->aName = GetItemName( pItem->nType );
    }

    // open the stream for the old configuration format
    SotStorageStreamRef aStr =
        pOut->OpenSotStream( String::CreateFromAscii(pHeader), STREAM_STD_READWRITE | STREAM_TRUNC );
	if ( aStr->GetError() )
		return SfxConfigManager::ERR_OPEN;

	SvStream* pStream = aStr;
	pStream->SetVersion( SOFFICE_FILEFORMAT_40 );
	pStream->SetBufferSize( CFG_STREAM_BUFFER_SIZE );

	USHORT nRet = SfxConfigManager::ERR_NO;

	// write header
	pStream->Write( pHeader, strlen(pHeader) );
	(*pStream) << cCtrlZ << nVersion;

    // write a placeholder for the directory pointer and remember its position
	long lStart = pStream->Tell();
	(*pStream) << lStart;

	// write all items into the file and remember the starting position of each item
	USHORT nCount = (*pItemArr).Count();

    // special treatment for ToolBoxConfig in presence of user defined toolboxes ( see below )
    USHORT nTbxCfgItem = nCount;
    BOOL bTbxCfgIsDefault = TRUE;

    // directory of config stream will contain the position and length values, the latter one will be
    // calculated by the difference of the position and the position of the successor
    // so for the last item a dummy successor is added to aDir
    SvULongs aDir( nCount+1, 1 );
	for( USHORT i=0; i<nCount; i++ )
	{
		SfxConfigItem_Impl *pItem = (*pItemArr)[i];
        if ( pItem->nType == SFX_ITEMTYPE_TOOLBOXCONFIG )
        {
            // remember index of this item, because it will be needed below
            nTbxCfgItem = i;

            // remember old bDefault, because it must be set to non-default for exporting ( temporarily, see below )
            // and export is required if user defined toolboxes are present
            bTbxCfgIsDefault = pItem->bDefault;
        }

        // remember file position
        aDir.Insert( pStream->Tell(), i );

        // write data only if it's not the default configuration
        if ( !pItem->bDefault )
        {
            // write data for plausibility check
            (*pStream) << pItem->nType;

            if ( !ExportItem( pItem, pStor, pStream ) )
            {
                // export failed, stop writing
                nRet = SfxConfigManager::ERR_EXPORT;
                break;
            }
        }
	}

    if ( pIFaceConfig )
    {
        // if there are some userdefined toolboxes, a ToolboxConfig must be exported also
        SfxConfigItem_Impl *pItem=NULL;
        if ( nTbxCfgItem < nCount )
            // get the current item for it
            pItem = (*pItemArr)[nTbxCfgItem];

        if ( !pItem || pItem->bDefault )
        {
            // if there is no item or the old one is a default item, a new item must be added
            // ( because the stream of the ToolboxConfig will be written behind all items written so far
            // and aDir's file positions must be in ascending order )
            if ( pItem )
            {
                // ToolBoxConfig gets a new entry, so remove old one ( temporarily, see below )
                // it's a default entry, so its does not disturb aDir's positions!
                pItemArr->Remove( nTbxCfgItem );
            }
            else
            {
                // create a new entry
                pItem = new SfxConfigItem_Impl;
                pItem->nType = SFX_ITEMTYPE_TOOLBOXCONFIG;
                nCount++;
            }

            // append the new item ( temporarily, see below )
            pItemArr->Insert( pItem, pItemArr->Count() );

            // get the starting position in the stream
            aDir.Insert( pStream->Tell(), nCount-1 );

            // only non-default items will be exported, change flag ( temporarily, see below )
            pItem->bDefault = FALSE;

            // write data for plausibility check
            (*pStream) << pItem->nType;

            // no inputstream for export, because there is no configuration in the storage, because
            // it's a default configuration for 6.0 format
            if ( !SfxToolBoxConfig::Export( NULL, *pStream ) )
                nRet = SfxConfigManager::ERR_EXPORT;
        }

        // if there are some userdefined toolboxes, they must be exported in an interface configuration
        pItem = new SfxConfigItem_Impl;
        pItem->nType = pIFaceConfig->GetType();
        pItem->bDefault = FALSE;
        nCount++;

        // insert new item ( temporarily, see below )
		pItemArr->Insert( pItem, pItemArr->Count() );

            // get the starting position in the stream
        aDir.Insert( pStream->Tell(), nCount-1 );

        // write data for plausibility check
        (*pStream) << pItem->nType;

        // store the interface configuration that will cover all user defined toolbox registrations
        if ( !pIFaceConfig->Store(*pStream) )
            nRet = SfxConfigManager::ERR_EXPORT;
    }

    if ( nRet == SfxConfigManager::ERR_NO )
    {
        // directory is stored behind the items
        long lDirPos = pStream->Tell();
        aDir.Insert( lDirPos, nCount );          // last element for calculation of differences

        // write position of directory into file ( use space of placeholder )
        pStream->Seek( lStart );
        (*pStream) << lDirPos;

        // write directory
        pStream->Seek( lDirPos );
        (*pStream) << nCount;
        for( i=0; i<nCount; i++ )
        {
            SfxConfigItem_Impl *pItem = (*pItemArr)[i];
            if ( pItem->bDefault )
                // ignore file position stored in aDir, because default configurations are not written
                *pStream << pItem->nType << -1L << 0L;
            else
                *pStream << pItem->nType << aDir[i] << ( aDir[i+1] - aDir[i] );
            pStream->WriteByteString( pItem->aName );
        }
    }

    if ( pIFaceConfig )
    {
        // restore original array
        // first remove last inserted entry for the additional interface configuration
        delete pItemArr->GetObject( --nCount );
        pItemArr->Remove( nCount );

        // now repair entry for ToolBoxConfig
        if ( nTbxCfgItem < nCount )
        {
            // already existed before
            if ( bTbxCfgIsDefault )
            {
                // was default before, reinsert at previous position and reset to default
                SfxConfigItem_Impl *pItem = pItemArr->GetObject( nCount-1 );
                pItemArr->Remove( nCount-1 );
                pItemArr->Insert( pItem, nTbxCfgItem );
                pItem->bDefault = TRUE;
            }
        }
        else
        {
            // was inserted while exportin, remove
            delete pItemArr->GetObject( --nCount );
            pItemArr->Remove( nCount );
        }

        DELETEZ( pIFaceConfig );
    }

	return nRet;
}

BOOL SfxConfigManagerImExport_Impl::ExportItem( SfxConfigItem_Impl *pItem, SotStorage* pStor, SvStream* pStream )
{
	BOOL bRet = TRUE;
	switch ( pItem->nType )
	{
    	// Statusbars
    	case SFX_ITEMTYPE_STATBAR :     // Global
    	case 20816 :        			// Math
    	case 30002 :      				// Chart
    	case 26005 :                    // Calc
    	case 23007 :                    // Impress/Draw
    	case 20013 :                    // Writer/WriterWeb
		{
			BOOL bOK = FALSE;
			SotStorageStreamRef xStream =
            		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
			if ( !xStream->GetError() )
				bOK = SfxStatusBarManager::Export( *xStream, *pStream );
			if ( bRet )
				bRet = bOK;
			break;
		}

    	// Accels
    	case SFX_ITEMTYPE_ACCEL :		// Global
		case 20815 :        			// Math
        case 20080 :        			// Chart
        case 26006 :        			// Calc
        case 20017 :        			// Impress
        case 20020 :        			// Draw
        case 23005 :        			// Writer
        case 23008 :        			// WriterWeb
        {
            SfxAcceleratorManager aMgr( pItem->nType, NULL );
            int nRet = aMgr.Load( *pStor );
            if ( nRet == SfxConfigItem::ERR_OK )
                bRet = aMgr.Store( *pStream );
			break;
        }

    	// Menues
    	case 20814 :        			// Math
    	case 20081 :       				// Chart
        case 26007 :        			// Calc
        case 23006 :        			// Impress
        case 23009 :        			// Draw
        case 20016 :        			// Writer
        case 20019 :        			// WriterWeb
		{
			BOOL bOK = FALSE;
			SotStorageStreamRef xStream =
                    pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
			if ( !xStream->GetError() )
			{
				MenuBar* pMenu = SfxMenuBarManager::LoadMenuBar( *xStream );
                bOK = SfxMenuManager::StoreMenu( *pStream, pMenu, pObjShell->GetModule() );
				delete pMenu;
			}

			if ( bRet )
				bRet = bOK;
			break;
		}

    	// Toolboxes
        case 558 :                      // Fullscreenbar
        case 560 :                    	// Functionbar
        case 18003 :                    // FormularNavigationbar
        case 18004 :                    // FormularFilterbar
        case 20050 :                    // MathToolbar
    	case 30001 :                    // ChartObjectbar
    	case 30513 :                    // ChartToolbar
    	case 25005 :                    // CalcTextObjectbar
    	case 25047 :                    // CalcFormObjectbar
    	case 25053 :                    // CalcDrawObjectbar
    	case 25054 :                    // CalcGraphicObjectbar
    	case 25001 :                    // CalcFormatObjectbar
    	case 25006 :                    // CalcPreviewObjectbar
    	case 25035 :                    // CalcToolbar
		case 23015 :                    // DrawBezierObjectbar
        case 23019 :                    // DrawGluepointsObjectbar
        case 23030 :                    // ImpressGraphicObjectbar
        case 23013 :                    // DrawDrawingObjectbar
        case 23016 :                    // ImpressTextObjectbar
        case 23028 :                    // DrawTextObjectbar
        case 23011 :                    // ImpressToolbar
        case 23020 :                    // ImpressOptionsbar
        case 23021 :                    // ImpressCommontaskbar
        case 23025 :                    // DrawToolbar
        case 23026 :                    // DrawOptionsbar
        case 23027 :                    // DrawGraphicObjectbar
        case 23017 :                    // OutlineToolbar
        case 23012 :                    // SlideViewToolbar
        case 23014 :                    // SlideViewObjectbar
        case 23283 :                    // WriterBezierObjectbar
        case 23269 :                    // WriterDrawObjectbar
        case 23299 :                    // WriterFormularObjectbar
        case 23270 :                    // WriterDrawTextObjectbar
        case 23267 :                    // WriterFrameObjectbar
        case 23268 :                    // WriterGraphicObjectbar
        case 23271 :                    // WriterNumObjectbar
        case 23272 :                    // WriterOleObjectbar
        case 23266 :                    // WriterTableObjectbar
        case 23265 :                    // WriterTextObjectbar
        case 20631 :                    // WriterPagePreviewObjectbar
        case 23282 :                    // WriterWebSourceViewObjectbar
        case 20402 :                    // WriterWebSourceViewToolbox
        case 20403 :                    // WriterWebTextObjectbar
        case 23273 :                    // WriterToolbox
        case 20408 :                    // WriterWebFrameObjectbar
        case 20410 :                    // WriterWebGraphicObjectbar
        case 20411 :                    // WriterWebOleObjectbar
        case 20412 :                    // WriterWebToolbar ????????????????????
		{
			BOOL bOK = FALSE;
			SotStorageStreamRef xStream =
            		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
			if ( !xStream->GetError() )
				bOK = SfxToolBoxManager::Export( *xStream, *pStream );
			if ( bRet )
				bRet = bOK;
			break;
		}

    	case SFX_ITEMTYPE_IMAGELIST :
		{
			BOOL bOK = SfxImageManager::Export( *pStor, *pStream );
			if ( bRet )
				bRet = bOK;
			break;
		}

    	case SFX_ITEMTYPE_TOOLBOXCONFIG :
		{
			BOOL bOK = FALSE;
			SotStorageStreamRef xStream =
            		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
			if ( !xStream->GetError() )
                bOK = SfxToolBoxConfig::Export( xStream, *pStream );
			if ( bRet )
				bRet = bOK;
			break;
		}

    	case SFX_ITEMTYPE_APPEVENTCONFIG :
		{
			BOOL bOK = FALSE;
			SotStorageStreamRef xStream =
            		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
			if ( !xStream->GetError() )
                bOK = SfxEventConfiguration::Export( xStream, *pStream );
			if ( bRet )
				bRet = bOK;
			break;
		}

    	case SFX_ITEMTYPE_DOCEVENTCONFIG :
        {
            BOOL bOK = SfxEventConfiguration::Export( NULL, *pStream, pObjShell );
			if ( bRet )
				bRet = bOK;
			break;
        }

    	default:
            if ( pItem->nType >= RID_SFX_TOOLBOX_START + 10 && pItem->nType <= RID_SFX_TOOLBOX_START + 17 )
        	{
				// user defined toolboxes
                BOOL bOK = FALSE;
                SotStorageStreamRef xStream =
                        pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
                if ( !xStream->GetError() )
                    bOK = SfxToolBoxManager::Export( *xStream, *pStream );
                if ( bRet )
                    bRet = bOK;

                // now register in global context to save later
                if ( !pIFaceConfig )
                    pIFaceConfig = new SfxIFConfig_Impl;
                USHORT nPos = SFX_OBJECTBAR_USERDEF1 + pItem->nType - RID_SFX_TOOLBOX_START - 10;
                pIFaceConfig->RegisterObjectBar( nPos, pItem->nType, 0, NULL );
        	}

			break;
	}

	return bRet;
}

String SfxConfigManagerImExport_Impl::GetItemName( USHORT nType )
{
    return String();
}

String SfxConfigManagerImExport_Impl::GetStreamName( USHORT nType )
{
    if ( nType >= SFX_ITEMTYPE_INTERFACE_START && nType <= SFX_ITEMTYPE_INTERFACE_END && nType != RID_DEFAULTMENU )
    {
        // accidently the old default menu interfered with the interface ID area
        if ( nType != RID_DEFAULTMENU )
            DBG_ERROR("Obsolete configitem!");
        return String();
    }
    else if ( nType >= RID_SFX_TOOLBOX_START + 10 && nType <= RID_SFX_TOOLBOX_START + 17 )
    {
        ByteString aStr("userdeftoolbox");
        aStr += ByteString::CreateFromInt32( nType - ( RID_SFX_TOOLBOX_START + 9 ) );
        aStr += ".xml";
        return String( aStr, RTL_TEXTENCODING_UTF8 );
    }

    for ( USHORT n=0; n<nTypesCount; n++ )
    {
        if ( pTypes[n] == nType )
            return String::CreateFromAscii( pStreamNames[n] );
    }

    DBG_ERROR("Unknown configitem!");
    return String();
}

USHORT SfxConfigManagerImExport_Impl::GetType( const String& rStreamName )
{
    ByteString aCmp( rStreamName, RTL_TEXTENCODING_ASCII_US );

    if ( !aCmp.CompareTo( "userdeftoolbox", 14 ) )
        return (USHORT) ( RID_SFX_TOOLBOX_START + 9 + aCmp.Copy( 14 ).ToInt32() );

    for ( USHORT n=0; n<nTypesCount; n++ )
        if ( !strcmp( aCmp.GetBuffer(), pStreamNames[n] ) )
            return pTypes[n];

    return 0;
}

