/*************************************************************************
 *
 *  $RCSfile: cfgitem.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mba $ $Date: 2001/12/05 10:33:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include "cfgitem.hxx"
#include "cfgmgr.hxx"
#include "sfx.hrc"
#include "cfgimpl.hxx"

// class SfxConfigItem ---------------------------------------------------

SfxConfigItem::SfxConfigItem( USHORT nType, SfxConfigManager* pCfgMgr )
	: m_pCfgMgr( pCfgMgr )
	, m_nType( nType )
	, m_bDefault( TRUE )
    , m_bModified( FALSE )
    , m_bInitialized( FALSE )
{
    if ( pCfgMgr )
        pCfgMgr->AddConfigItem( *this );
}

SfxConfigItem::~SfxConfigItem()
{
    if ( m_pCfgMgr )
        m_pCfgMgr->RemoveConfigItem( *this );
}

// ----------------------------------------------------------------------
BOOL SfxConfigItem::Initialize()
{
	BOOL bRet = TRUE;
	if ( !m_pCfgMgr )
		UseDefault();
	else
        bRet = m_pCfgMgr->LoadConfigItem( *this );
    m_bModified = FALSE;
    m_bInitialized = TRUE;
	return bRet;
}

// ----------------------------------------------------------------------
BOOL SfxConfigItem::StoreConfig()
{
	BOOL bRet = FALSE;
	if ( m_pCfgMgr )
        bRet = m_pCfgMgr->StoreConfigItem( *this );
	m_bModified = FALSE;
	return bRet;
}

// ------------------------------------------------------------------------
void SfxConfigItem::SetDefault( BOOL bOn )
{
    if ( m_bInitialized && (!bOn || !m_bDefault) )
		SetModified( TRUE );
	m_bDefault = bOn;
}

//-------------------------------------------------------------------------
void SfxConfigItem::SetModified( BOOL bMod )
{
    if ( m_bInitialized )
    {
        m_bModified = bMod;
        if ( bMod && m_pCfgMgr )
            m_pCfgMgr->SetModified( bMod );
    }
}

void SfxConfigItem::ReConnect( SfxConfigManager* pMgr )
{
    if ( m_pCfgMgr )
    {
        if ( m_bModified )
            m_pCfgMgr->StoreConfigItem( *this );
        m_pCfgMgr->RemoveConfigItem( *this );
    }

    m_pCfgMgr = pMgr;
    if ( m_pCfgMgr )
    {
        m_pCfgMgr->AddConfigItem( *this );
        ReInitialize();
    }
}

BOOL SfxConfigItem::ReInitialize()
{
    m_bInitialized = FALSE;
    return Initialize();
}

String SfxConfigItem::GetStreamName( USHORT nType )
{
    return SfxConfigManagerImExport_Impl::GetStreamName( nType );
}
