/*************************************************************************
 *
 *  $RCSfile: menucfg.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: mba $ $Date: 2001/11/09 15:26:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _HELP_HXX //autogen
#include <vcl/help.hxx>
#endif
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include <so3/svstor.hxx>

#pragma hdrstop
#include "cfg.hxx"
#include "viewfrm.hxx"
#include "viewsh.hxx"
#include "dialog.hrc"
#include "cfg.hrc"
#include "app.hxx"
#include "msg.hxx"
#include "msgpool.hxx"
#include "mnumgr.hxx"
#include "sfxresid.hxx"
#include "macrconf.hxx"
#include "minfitem.hxx"
#include "cfgmgr.hxx"
#include "sfxresid.hxx"
#include "objsh.hxx"
#include "dispatch.hxx"
#include "sfxtypes.hxx"
#include "request.hxx"

static long nMenuCfgTabs[] =
{
		2, 								// Number of Tabs
		0,
		120                             // Function
};

static const char __FAR_DATA pSeparatorStr[] = "--------------------";
static const char __FAR_DATA pUnknownStr[]	= "???";

#ifdef MSC
#pragma warning (disable:4355)
#endif

void SfxMenuCfgTabListBox_Impl::ModelHasCleared()
/*  Beschreibung
	Virtuelle Methode der TreeList, die aufgerufen wird, wenn sie geleert wird.
	Dabei wird nicht zus"atzlich ModelHasRemoved gerufen!
*/
{
	// Alle UserDaten l"oschen
	for ( USHORT i=0; i<aMenuArr.Count(); i++ )
		delete aMenuArr[i];
	aMenuArr.Remove(0, aMenuArr.Count());
	SvTabListBox::ModelHasCleared();
}

void SfxMenuCfgTabListBox_Impl::EntryInserted( SvListEntry* pEntry )
/*  Beschreibung
	Virtuelle Methode, die gerufen wird, wenn ein Entry in die TreeList eingef"ugt wurde.
*/
{
	// Der "ubliche Handler ModelHasInserted kann hier nicht aufgerufen werden, da zu
	// diesem Zeitpunkt noch keine UserData vorhanden ist
	// UserDaten-Pointer des Entries merken, um beim Clearen schnell alle Daten l"oschen zu k"onnen
	SfxMenuConfigEntry *pMEntry = (SfxMenuConfigEntry*) ((SvLBoxEntry*)pEntry)->GetUserData();
	aMenuArr.C40_INSERT( SfxMenuConfigEntry, pMEntry, aMenuArr.Count() );
}

void SfxMenuCfgTabListBox_Impl::ModelIsRemoving( SvListEntry* pEntry )
/*  Beschreibung
	Virtuelle Methode, die gerufen wird, wenn ein Entry aus der Treelist entfernt wird.
*/
{
	// UserDaten-Pointer des Entries im Arrays suchen, l"oschen und entfernen
	SfxMenuConfigEntry *pMEntry = (SfxMenuConfigEntry*) ((SvLBoxEntry*)pEntry)->GetUserData();
	USHORT nPos = aMenuArr.C40_GETPOS( SfxMenuConfigEntry, pMEntry );
	delete aMenuArr[nPos];
	aMenuArr.Remove( nPos );
	SvTabListBox::ModelIsRemoving( pEntry );
}

void SfxMenuCfgTabListBox_Impl::EditingRequest( SvLBoxEntry* pEntry, SvLBoxItem* pItem,
						const Point& rMousePos )
/*  Beschreibung
	Virtuelle Methode, die gerufen wird, wenn ein Entry in der Treelist inplace editiert werden soll.
*/
{
	// Separatoren werden nicht editiert
	SfxMenuConfigEntry *pMEntry = (SfxMenuConfigEntry*) ((SvLBoxEntry*)pEntry)->GetUserData();
	if ( !pMEntry->GetId() )
		return;

	if ( pEntry->GetPos( pItem ) != pEntry->ItemCount() - 1 )
	{
		// Wenn die lezte Spalte selektiert wird, soll nicht editiert werden
		SvTabListBox::EditingRequest( pEntry, pItem, rMousePos );
	}
}

BOOL SfxMenuCfgTabListBox_Impl::EditedEntry( SvLBoxEntry* pEntry, const String& rNewText )
/*  Beschreibung
	Virtuelle Methode, die gerufen wird, wenn ein Entry in der Treelist inplace editiert wurde.
*/
{
	// Text abholen und in den UserDaten merken
	SfxMenuConfigEntry *pMEntry = (SfxMenuConfigEntry*) pEntry->GetUserData();
	pMEntry->SetName( rNewText );
	pPage->SetModified( TRUE );
	pPage->SetDefault( FALSE );
	return TRUE;
}

void SfxMenuCfgTabListBox_Impl::MouseMove( const MouseEvent& rMEvt )
/*  Beschreibung
	Virtuelle Methode, die gerufen wird, wenn der Mauszeiger "uber der TreeListBox bewegt wurde.
	Wenn die Position des Mauszeigers "uber dem aktuell selektierten Entry liegt, wird ein Timer
	aufgesetzt, um ggf. einen Hilfetext einzublenden.
*/
{
	Point aMousePos = rMEvt.GetPosPixel();
	SvLBoxEntry *pEntry = GetCurEntry();
	pCurEntry = pEntry ? (SfxMenuConfigEntry*) pEntry->GetUserData() : NULL;

	if ( pEntry && GetEntry( aMousePos ) == pEntry && aMousePos.X() > GetTab( TabCount()-1 ) )
		aTimer.Start();
	else
	{
		Help::ShowBalloon( this, aMousePos, String() );
		aTimer.Stop();
	}
}

SfxMenuCfgTabListBox_Impl::SfxMenuCfgTabListBox_Impl( Window *pParent, const ResId& rResId )
	: SvTabListBox( pParent, rResId )
	, pPage( (SfxMenuConfigPage*) pParent )
	, pCurEntry( NULL )
{
	// DRAG_COPY verboten
	DragDropMode aDDMode = SV_DRAGDROP_CTRL_MOVE;
	SetDragDropMode( aDDMode );

	aTimer.SetTimeout( 200 );
	aTimer.SetTimeoutHdl(
		LINK( this, SfxMenuCfgTabListBox_Impl, TimerHdl ) );
}

SfxMenuCfgTabListBox_Impl::~SfxMenuCfgTabListBox_Impl()
{
	aTimer.Stop();
}

IMPL_LINK( SfxMenuCfgTabListBox_Impl, TimerHdl, Timer*, pTimer)
/*  Beschreibung
	Timer-Handler f"ur die Einblendung eines Hilfetextes. Wenn nach Ablauf des Timers
	der Mauszeiger immer noch auf dem aktuell selektierten Eintrag steht, wird der
	Helptext des Entries als Balloon-Help eingeblendet.
*/
{
	if ( pTimer )
		pTimer->Stop();

	Point aMousePos = GetPointerPosPixel();
	SvLBoxEntry *pEntry = GetCurEntry();
	if ( pEntry && GetEntry( aMousePos ) == pEntry && aMousePos.X() > GetTab( TabCount()-1 ) )
	{
		// Vergleiche den Userdaten-Pointer mit dem beim Aufsetzen des Timers gemerkten
		if ( pCurEntry == (SfxMenuConfigEntry*) pEntry->GetUserData() )
		{
			USHORT nId = pCurEntry->GetId();
			String aText( pCurEntry->GetHelpText() );
			if ( !aText.Len() )
			{
#if SUPD>628
                aText = Application::GetHelp()->GetHelpText( nId, this );
#else
				aText = Application::GetHelp()->GetHelpText( nId );
#endif
				pCurEntry->SetHelpText( aText );
			}

			Help::ShowBalloon( this, OutputToScreenPixel( aMousePos ), aText );
		}
	}

	return 0L;
}

long SfxMenuCfgTabListBox_Impl::PreNotify( NotifyEvent& rEvt )
{
	if ( rEvt.GetType() == EVENT_LOSEFOCUS && rEvt.GetWindow() != this )
		EndEditing();
	SvTabListBox::PreNotify( rEvt );
	return 0L;
}

sal_Int8 SfxMenuCfgTabListBox_Impl::AcceptDrop( const AcceptDropEvent& rEvt )
{
	// copy isn't allowed!
	if ( rEvt.mnAction == DND_ACTION_COPY )
		return DND_ACTION_NONE;
	else
		return SvTreeListBox::AcceptDrop( rEvt );
}

BOOL SfxMenuCfgTabListBox_Impl::NotifyMoving(SvLBoxEntry* pTarget, SvLBoxEntry* pEntry,
							SvLBoxEntry*& rpNewParent, ULONG& rNewChildPos)
/*  Beschreibung
	Virtuelle Methode, die gerufen wird, wenn ein Entry per D&D verschoben wurde.
*/
{
	if ( !pTarget )
		return FALSE;

	ULONG nTargetPos = GetModel()->GetAbsPos( pTarget );
	ULONG nActPos = GetModel()->GetAbsPos( pEntry );
	BOOL bForward = ( nTargetPos > nActPos );
	SvLBoxEntry *pSibling = (SvLBoxEntry*) ( bForward ?
		GetModel()->NextSibling( pEntry ) : GetModel()->PrevSibling( pEntry ) );

	if ( !nTargetPos )
		return FALSE;

	SfxMenuConfigEntry *pTargetData = (SfxMenuConfigEntry*) pTarget->GetUserData();

	// Wenn das Target ein Popup ist, wird nur dahinter eingef"ugt, wenn es
	// nicht expanded oder leer ist
	if ( pTargetData->IsPopup() && ( !FirstChild( pTarget ) ||
		IsExpanded( pTarget ) && bForward && pTarget == pSibling ) )
	{
			// Ist der parent expanded oder leer, wird in das Popup eingef"ugt
			rpNewParent = pTarget;
			rNewChildPos = 0;
	}
	else
	{
		// DragItem anstelle des DropTarget einf"ugen
		rpNewParent = GetParent( pTarget );
		rNewChildPos = GetModel()->GetRelPos( pTarget );
		if ( bForward && rpNewParent == GetParent( pEntry ) ||
			!bForward && rpNewParent && rNewChildPos == GetModel()->GetChildList( rpNewParent )->Count() - 1 )
			rNewChildPos++;
	}

	pPage->SetModified( TRUE );
	pPage->SetDefault( FALSE );
	return TRUE;
}

void SfxMenuCfgTabListBox_Impl::Apply( SfxMenuManager* pMgr, SvLBoxEntry *pParentEntry )
/*  Beschreibung
	Rekursives Auslesen der Treelist, um das Menue zu konfigurieren
*/
{
	// Ausgehend vom "ubergebenen parent entry werden alle children abgelaufen
	SvLBoxEntry *pActEntry = FirstChild( pParentEntry );
	while ( pActEntry )
	{
		// Userdaten holen
		SfxMenuConfigEntry *pEntry = (SfxMenuConfigEntry*) pActEntry->GetUserData();
		if ( pEntry->IsBinding() )
		{
			// Binding
			pMgr->AppendItem( pEntry->GetName(), pEntry->GetHelpText(), pEntry->GetId(), pEntry->GetCommand() );
		}
		else if ( pEntry->IsSeparator() )
		{
			// Separator
			pMgr->AppendSeparator();
		}
		else
		{
			// Popup "offnen
			pMgr->EnterPopup( pEntry->GetName(), pEntry->GetHelpText(), pEntry->GetId() );

			// Eine neue Loop "uber alle children von pActEntry aufmachen
			Apply( pMgr, pActEntry );

			// Popup wieder schlie\sen
			pMgr->LeavePopup();
		}

		pActEntry = NextSibling( pActEntry );
	}
}

SV_IMPL_PTRARR(SfxMenuConfigEntryArr, SfxMenuConfigEntry*)

SfxMenuConfigPage::SfxMenuConfigPage( Window *pParent, const SfxItemSet& rSet ) :

	SfxTabPage( pParent, SfxResId( TP_CONFIG_MENU	 ), rSet ),
	aUpButton			( this, ResId( BTN_MN_UP              ) ),
	aDownButton			( this, ResId( BTN_MN_DOWN            ) ),
	aNewButton          ( this, ResId( BTN_MN_NEW             ) ),
	aNewPopupButton     ( this, ResId( BTN_MN_NEWPOPUP        ) ),
	aChangeButton       ( this, ResId( BTN_MN_CHANGE          ) ),
	aRemoveButton       ( this, ResId( BTN_MN_REMOVE          ) ),
	aEntriesBox         ( this, ResId( BOX_MN_ENTRIES         ) ),
	aMenuGroup          ( this, ResId( GRP_MN_MENU            ) ),
	aGroupText          ( this, ResId( TXT_MN_GROUP           ) ),
    aGroupLBox           ( this, ResId( BOX_MN_GROUP ), SFX_SLOT_MENUCONFIG ),
	aFunctionText       ( this, ResId( TXT_MN_FUNCTION        ) ),
	aFunctionBox        ( this, ResId( BOX_MN_FUNCTION        ) ),
	aFunctionsGroup     ( this, ResId( GRP_FUNCTIONS       ) ),
	aLoadButton 		( this, ResId( BTN_LOAD ) ),
	aSaveButton 		( this, ResId( BTN_SAVE ) ),
	aResetButton		( this, ResId( BTN_RESET   ) ),
	pMgr( 0 ),

    bModified( FALSE ),
    bDefault( TRUE )
{
	FreeResource();

	// Handler installieren
	aUpButton.SetClickHdl ( LINK( this, SfxMenuConfigPage, MoveHdl ) );
	aDownButton.SetClickHdl ( LINK( this, SfxMenuConfigPage, MoveHdl ) );
	aNewButton.SetClickHdl ( LINK( this, SfxMenuConfigPage, NewHdl ) );
	aNewPopupButton.SetClickHdl ( LINK( this, SfxMenuConfigPage, NewPopupHdl ) );
	aChangeButton.SetClickHdl ( LINK( this, SfxMenuConfigPage, ChangeHdl ) );
	aRemoveButton.SetClickHdl ( LINK( this, SfxMenuConfigPage, RemoveHdl ) );
	aEntriesBox.SetSelectHdl( LINK( this, SfxMenuConfigPage, SelectHdl ) );
    aGroupLBox.SetSelectHdl( LINK( this, SfxMenuConfigPage, SelectHdl ) );
	aFunctionBox.SetSelectHdl( LINK( this, SfxMenuConfigPage, SelectHdl ) );
	aLoadButton.SetClickHdl ( LINK( this, SfxMenuConfigPage, Load ) );
	aSaveButton.SetClickHdl ( LINK( this, SfxMenuConfigPage, Save ) );
	aResetButton.SetClickHdl ( LINK( this, SfxMenuConfigPage, Default ) );

	// aEntriesBox initialisieren
	aEntriesBox.SetWindowBits( WB_HSCROLL|WB_CLIPCHILDREN );
	aEntriesBox.SetSelectionMode( SINGLE_SELECTION );
	aEntriesBox.SetTabs( &nMenuCfgTabs[0], MAP_APPFONT );
	aEntriesBox.Resize(); // OS: Hack fuer richtige Selektion
//	aEntriesBox.SetFont( SFX_APP()->GetAppFont() );
	aEntriesBox.SetSpaceBetweenEntries( 0 );
    aGroupLBox.SetFunctionListBox( &aFunctionBox );
}

void SfxMenuConfigPage::Init()
/*  Beschreibung
	Die Konfiguration des SfxMenuManagers wird ausgelesen und f"ur jeden Menuentry ein SfxMenuConfigEntry
	angelegt. Dieser wird als UserDaten dem zugeh"origen Eintrag in der TreeListbox mitgegeben.
*/
{
	aEntriesBox.SetUpdateMode(FALSE);
	BOOL bItem = pMgr->FirstItem();
	SvLBoxEntry *pParentEntry = NULL;
	SvLBoxEntry *pLastParentEntry = NULL;
	SvLBoxEntry *pLastEntry = NULL;
	SfxMenuConfigEntry *pEntry = NULL;
	SfxMenuConfigEntry *pLastMenuEntry = NULL;
	USHORT nLastLevel = 0;
	while ( bItem )
	{
		while ( bItem && pMgr->GetLevel() > nLastLevel && pLastMenuEntry && !pLastMenuEntry->IsPopup() )
		{
			// "Unechtes" Popup; Entries davon "uberspringen
			bItem = pMgr->NextItem();
		}

		if ( !bItem )
			break;

		USHORT nId = pMgr->GetItemId();
		if ( pMgr->IsBinding() )
		{
			// Binding
			pEntry = new SfxMenuConfigEntry( nId, pMgr->GetTitle(), pMgr->GetHelpText(), FALSE );
			pEntry->SetCommand( pMgr->GetCommand() );
		}
		else if ( pMgr->IsSeparator() )
		{
			// Separator
			pEntry = new SfxMenuConfigEntry;
		}
		else if ( pMgr->IsPopup() )
		{
			// Popup; keine SlotIds zulassen (s.u.)
			if ( nId > SID_SFX_START && !SfxMenuManager::IsPopupFunction( nId ) )
				nId = 0;

			pEntry = new SfxMenuConfigEntry( nId, pMgr->GetTitle(), pMgr->GetHelpText(), TRUE );
		}
		else
		{
			DBG_ERROR( "unknown entry type" );
			pEntry = new SfxMenuConfigEntry;
		}

		if ( pMgr->GetLevel() > nLastLevel )
		{
			// H"oheres Level -> Letzter Entry war ein Popup
			pLastParentEntry = pParentEntry;
			pParentEntry = pLastEntry;
		}

		while ( pMgr->GetLevel() < nLastLevel )
		{
			// Niedrigerer Level -> Popup(s) schlie\sen
			pParentEntry = pLastParentEntry;
			if ( pParentEntry )
				pLastParentEntry = aEntriesBox.GetParent( pParentEntry );
			nLastLevel--;
		}

		// Eintrag einf"ugen
		if ( nId == 0 && pMgr->IsPopup() )
		{
			// Wenn eine neue PopupId zugeteilt werden mu\s, eine suchen, die
			// noch nicht vergeben wurde
			nId = 1;
			SvLBoxEntry *pCur = aEntriesBox.FirstChild( pParentEntry );
			while ( pCur )
			{
				if ( ((SfxMenuConfigEntry*)pCur->GetUserData())->GetId() == nId )
				{
					// N"achste Id versuchen
					nId++;
					pCur = aEntriesBox.FirstChild( pParentEntry );
				}
				else
					pCur = aEntriesBox.NextSibling( pCur );
			}

			pEntry->SetId( nId );
		}

		pLastEntry = aEntriesBox.InsertEntry( MakeEntry( *pEntry ), pParentEntry, LIST_APPEND, 0xFFFF );

		// Nach dem Einf"ugen des ersten childs den parent aufklappen
		if ( pMgr->GetLevel() > nLastLevel )
			aEntriesBox.Expand( pParentEntry );

		// MenuConfigEntry an Listbox-Entry
		pLastEntry->SetUserData( pEntry );
		aEntriesBox.EntryInserted( pLastEntry );

		// n"achster Eintrag
		nLastLevel = pMgr->GetLevel();
		pLastMenuEntry = pEntry;
		bItem = pMgr->NextItem();
	}

	aEntriesBox.SetUpdateMode(TRUE);
}

void SfxMenuConfigPage::ResetConfig()
/*  Beschreibung
	Methode, um die Anzeige der Konfiguration neu zu initialisieren.
*/
{
	// Das MenuArray wird im ModelHasCleared() der Listbox geleert.
	aEntriesBox.Clear();
}

SfxMenuConfigPage::~SfxMenuConfigPage()
{
}

void SfxMenuConfigPage::Apply( SfxMenuManager* pMenuMgr, BOOL bIsDefault )
/*  Beschreibung
	Die Konfiguration wird angewendet. Anhand der MenuConfigEntries wird der SfxMenuManager komplett
	neu aufgebaut.
*/
{
    if ( bIsDefault )
	{
		// Konfiguration wurde auf default geschaltet
		pMgr->UseDefault();
		pMgr->SetDefault( TRUE );
	}
	else
	{
		pMenuMgr->Clear();
		aEntriesBox.Apply( pMenuMgr );
		pMenuMgr->Reconfigure();
		pMgr->SetDefault( FALSE );
	}

	((SfxMenuBarManager*) pMenuMgr)->ReconfigureObjectMenus();
}

IMPL_LINK( SfxMenuConfigPage, MoveHdl, Button *, pButton )
{
	// Selektierter Eintrag
	SvLBoxEntry *pActEntry = aEntriesBox.FirstSelected();
	if ( !pActEntry )
		return 0;

	SvLBoxEntry* pNewParent=NULL;
	ULONG nNewPos=0;
	if ( TryMove_Impl( pButton, &pNewParent, &nNewPos ) )
	{
		aEntriesBox.GetModel()->Move( pActEntry, pNewParent, nNewPos );
		aEntriesBox.MakeVisible( pActEntry );
		CheckEntry( &aEntriesBox );
		SetModified( TRUE );
		SetDefault( FALSE );
	}

	return 0;
}

BOOL SfxMenuConfigPage::TryMove_Impl( Button *pButton, SvLBoxEntry** pParent, ULONG *pPos )
{
	// Selektierter Eintrag
	SvLBoxEntry *pActEntry = aEntriesBox.FirstSelected();
	if ( !pActEntry )
		return FALSE;

	// Einige Items sollen nicht verschoben werden
//    if ( !aEntriesBox.IsDropEnabled() )
//        return FALSE;

	// Dessen Position
	ULONG nPos = aEntriesBox.GetModel()->GetAbsPos( pActEntry );
	SvLBoxEntry* pNewParent=NULL;
	ULONG nNewPos=SV_TREELIST_ERROR;
	SvLBoxEntry* pTarget=NULL;

	if ( pButton == &aDownButton && nPos < aEntriesBox.GetModel()->GetEntryCount() - 1 )
		pTarget = (SvLBoxEntry*) aEntriesBox.NextVisible( pActEntry );
	else if ( pButton == &aUpButton && nPos > 1 )
		pTarget = (SvLBoxEntry*) aEntriesBox.PrevVisible( pActEntry );

	if ( pTarget && aEntriesBox.NotifyMoving( pTarget, pActEntry, pNewParent, nNewPos ) )
	{
		if ( pParent )
			*pParent = pNewParent;
		if ( pPos )
			*pPos = nNewPos;
	}

	return ( nNewPos != SV_TREELIST_ERROR );
}


IMPL_LINK( SfxMenuConfigPage, Save, Button *, pButton )
/*  Beschreibung
	Die Men"ukonfiguration soll in einem storage abgelegt werden.
*/
{
	String aCfgName = SfxConfigDialog::FileDialog_Impl( this,
		WB_SAVEAS | WB_STDMODAL | WB_3DLOOK, String( SfxResId( STR_SAVEMENUCONFIG ) ) );
	if ( aCfgName.Len() )
	{
		GetTabDialog()->EnterWait();
		BOOL bCreated = FALSE;
		BOOL bLoadedDocument = FALSE;
		SfxObjectShellRef xDoc;

        SfxConfigManager* pCfgMgr = SFX_APP()->GetConfigManager_Impl();
		if ( pCfgMgr->GetURL() != aCfgName )
		{
			// it was not the global configuration manager
			// first check if URL points to a document already loaded
			xDoc = SFX_APP()->DocAlreadyLoaded( aCfgName, TRUE, TRUE );
            if ( xDoc.Is() )
                bLoadedDocument = TRUE;
            else
				// try to load a document from the URL
				xDoc = MakeObjectShellForOrganizer_Impl( aCfgName, TRUE );
			if ( xDoc.Is() )
			{
				// get config manager, force creation if there was none before
				pCfgMgr = xDoc->GetConfigManager( TRUE );
			}
			else
			{
				// URL doesn't point to a document, must be a single storage
				bCreated = TRUE;
        		SvStorageRef xStor = new SvStorage( aCfgName, STREAM_STD_WRITE, STORAGE_TRANSACTED );
				if ( xStor->GetError() == ERRCODE_NONE )
					pCfgMgr = new SfxConfigManager( xStor );
				else
					pCfgMgr = NULL;
			}
		}

		if ( pCfgMgr )
		{
			// create new MenubarManager and apply changes
			// constructing with a SfxConfigManager reads in configuration
			SfxMenuBarManager* pMenuMgr = new SfxMenuBarManager( *((SfxMenuBarManager*)pMgr), pCfgMgr );
            Apply( pMenuMgr, FALSE );
			pCfgMgr->StoreConfigItem( *pMenuMgr );
            if ( bLoadedDocument )
            {
                SfxRequest aReq( SID_SAVEDOC, SFX_CALLMODE_SYNCHRON, xDoc->GetPool() );
                xDoc->ExecuteSlot( aReq );
            }
            else
				pCfgMgr->StoreConfiguration();

			delete pMenuMgr;
			if ( bCreated )
				delete pCfgMgr;
            else
                pCfgMgr->ReInitialize( pMgr->GetType() );

			// if a document didn't have an own menu configuration, the menues in all of its view must be
			// reconfigured
			if ( bLoadedDocument && !xDoc->GetConfigManager()->HasConfigItem( pMgr->GetType() ) )
			{
				SfxViewFrame *pFrame = SfxViewFrame::GetFirst( xDoc );
				while ( pFrame )
				{
					pFrame->GetViewShell()->GetMenuBar_Impl()->ReConnect( pCfgMgr );
					pFrame = SfxViewFrame::GetNext( *pFrame, xDoc );
				}
			}
		}

		GetTabDialog()->LeaveWait();
	}

	return 0;
}

IMPL_LINK( SfxMenuConfigPage, Load, Button *, pButton )
/*  Beschreibung
	Die Men"ukonfiguration soll aus einem storage geladen werden.
*/
{
	String aCfgName = SfxConfigDialog::FileDialog_Impl( this,
		WB_OPEN | WB_STDMODAL | WB_3DLOOK, String( SfxResId( STR_LOADMENUCONFIG ) ) );
	if ( aCfgName.Len() )
	{
		GetTabDialog()->EnterWait();
		BOOL bCreated = FALSE;
		SfxObjectShellRef xDoc;

        SfxConfigManager* pCfgMgr = SFX_APP()->GetConfigManager_Impl();
		if ( pCfgMgr->GetURL() != aCfgName )
		{
			// it was not the global configuration manager
			// first check if URL points to a document already loaded
			xDoc = SFX_APP()->DocAlreadyLoaded( aCfgName, TRUE, TRUE );
			if ( !xDoc.Is() )
				// try to load a document from the URL
				xDoc = MakeObjectShellForOrganizer_Impl( aCfgName, TRUE );
			if ( xDoc.Is() )
			{
				// get config manager, force creation if there was none before
				pCfgMgr = xDoc->GetConfigManager( TRUE );
			}
			else
			{
				// URL doesn't point to a document, must be a single storage
				bCreated = TRUE;
        		SvStorageRef xStor = new SvStorage( aCfgName, STREAM_STD_READ );
				if ( xStor->GetError() == ERRCODE_NONE )
					pCfgMgr = new SfxConfigManager( xStor );
				else
					pCfgMgr = NULL;
			}
		}

		if ( pCfgMgr )
		{
			// create new MenuBarManager and read configuration
			// constructing with a SfxConfigManager reads in configuration
			SfxMenuBarManager* pMenuMgr = new SfxMenuBarManager( *((SfxMenuBarManager*)pMgr), pCfgMgr );

			// put new configuration into TabPage
			SfxMenuManager* pOld = pMgr;
			pMgr = pMenuMgr;
			aEntriesBox.SetUpdateMode( FALSE );
			ResetConfig();
			Init();
			aEntriesBox.SetUpdateMode( TRUE );
			aEntriesBox.Invalidate();
			aEntriesBox.Select( aEntriesBox.GetEntry( 0, 0 ) );
			bDefault = FALSE;
			bModified = TRUE;
			pMgr = pOld;

			delete pMenuMgr;
			if ( bCreated )
				delete pCfgMgr;
		}

		GetTabDialog()->LeaveWait();
	}

	return 0;
}

IMPL_LINK( SfxMenuConfigPage, Default, PushButton *, pPushButton )
/*  Beschreibung
	Die Men"ukonfiguration wird auf default geschaltet.
*/
{
	// creating a ConfigItem without ConfigManager forces it to use its default
	SfxMenuBarManager aMgr( *((SfxMenuBarManager*)pMgr), NULL );

	SfxMenuManager* pOld = pMgr;
	pMgr = &aMgr;
	bDefault = TRUE;
	bModified = !pOld->IsDefault();
	aEntriesBox.SetUpdateMode(FALSE);
	ResetConfig();
	Init();
	aEntriesBox.SetUpdateMode(TRUE);
	aEntriesBox.Invalidate();
	aEntriesBox.Select( aEntriesBox.GetEntry( 0, 0 ) );
	pMgr = pOld;

	return 0;
}

IMPL_LINK( SfxMenuConfigPage, NewHdl, Button *, pButton )
/*  Beschreibung
	Ein neuer Eintrag soll an der aktuellen Position eingef"ugt werden
*/
{
	// Entry, hinter dem eingef"ugt werden soll
	SvLBoxEntry *pActEntry = aEntriesBox.FirstSelected();
	if ( !pActEntry )
		return 0;
	SfxMenuConfigEntry *pEntry = (SfxMenuConfigEntry*) pActEntry->GetUserData();
	ULONG nPos = aEntriesBox.GetModel()->GetRelPos( pActEntry ) + 1;

	// Parent des aktuellen Entry ( Popup )
	SvLBoxEntry *pParent = aEntriesBox.GetParent( pActEntry );

	// Der erste Entry dieses Popups
	SvLBoxEntry *pChild = aEntriesBox.FirstChild( pParent );
	if ( pEntry->IsPopup() )
	{
		// Wenn der aktuelle Entry ein Popup ist, wird hinter dem Popup eingef"ugt,
		// sofern es nicht expanded ist
		if ( !aEntriesBox.FirstChild( pActEntry ) || aEntriesBox.IsExpanded( pActEntry ) )
		{
			// Ist der parent expanded oder leer, wird in das Popup eingef"ugt
			pParent = pActEntry;
			pChild = aEntriesBox.FirstChild( pParent );
			nPos = 0;
		}
	}

	// Funktion, die eingef"ugt werden soll
	USHORT nId = GetCurId();

	if ( nId)
	{
		// Wenn kein Separator, alle children "uberpr"ufen, ob es diese Funktion in diesem Popup schon gibt
		while ( pChild )
		{
			SfxMenuConfigEntry *pCurEntry = (SfxMenuConfigEntry*) pChild->GetUserData();
			if ( pCurEntry->GetId() == nId )
			{
				InfoBox( this, SfxResId( IBX_MNUCFG_ALREADY_INCLUDED ) ).Execute();
				return 0;
			}

			pChild = aEntriesBox.NextSibling( pChild );
		}
	}

	// "Anderung vornehmen
	bDefault = FALSE;
	bModified = TRUE;

	Help *pHelp = Application::GetHelp();

	// SfxMenuConfigEntry konstruieren ...
	SvLBoxEntry *pFuncEntry = aFunctionBox.FirstSelected();
	if( pFuncEntry )
		pEntry = new SfxMenuConfigEntry( nId,
								Trim( aFunctionBox.GetEntryText( pFuncEntry ) ),
#if SUPD>628
                                Trim( pHelp->GetHelpText( nId, this ) ),
#else
								Trim( pHelp->GetHelpText( nId ) ),
#endif
								FALSE );
	else
		pEntry = new SfxMenuConfigEntry;

	// ... und einf"ugen
	pActEntry = aEntriesBox.InsertEntry( MakeEntry( *pEntry ), pParent, nPos, 0xFFFF );

	// Wenn ein neuer erster Sub-Entry eingef"ugt wird, parent aufklappen
	if ( !nPos )
		aEntriesBox.Expand( pParent );

	pActEntry->SetUserData( pEntry );
	aEntriesBox.EntryInserted( pActEntry );
	aEntriesBox.Select( pActEntry );
	aEntriesBox.MakeVisible( pActEntry );
	return 0;
}

IMPL_LINK( SfxMenuConfigPage, NewPopupHdl, Button *, pButton )
/*  Beschreibung
	Ein neues submenu soll an der akzuellen Position eingef"ugt werden
*/
{
	// Entry, hinter dem eingef"ugt werden soll
	SvLBoxEntry *pActEntry = aEntriesBox.FirstSelected();
	if ( !pActEntry )
		return 0;
	SfxMenuConfigEntry *pEntry = (SfxMenuConfigEntry*) pActEntry->GetUserData();
	ULONG nPos = aEntriesBox.GetModel()->GetRelPos( pActEntry ) + 1;

	// Parent des aktuellen Entry ( Popup )
	SvLBoxEntry *pParent = aEntriesBox.GetParent( pActEntry );

	// Der erste Entry dieses Popups
	SvLBoxEntry *pChild = aEntriesBox.FirstChild( pParent );
	if ( pEntry->IsPopup() )
	{
		// Wenn der aktuelle Entry ein Popup ist, wird hinter dem Popup eingef"ugt,
		// sofern es nicht expanded ist
		if ( !aEntriesBox.FirstChild( pActEntry ) || aEntriesBox.IsExpanded( pActEntry ) )
		{
			// Ist der parent expanded oder leer, wird in das Popup eingef"ugt
			pParent = pActEntry;
			pChild = aEntriesBox.FirstChild( pParent );
			nPos = 0;
		}
	}

	// Eine geeignete Id f"ur das Popup ermitteln
	USHORT nId = 1;
	while ( pChild )
	{
		SfxMenuConfigEntry *pCurEntry = (SfxMenuConfigEntry*) pChild->GetUserData();
		if ( pCurEntry->GetId() == nId )
		{
			// N"achste Id versuchen
			nId++;
			pChild = aEntriesBox.FirstChild( pParent );
		}
		else
			pChild = aEntriesBox.NextSibling( pChild );
	}

	bDefault = FALSE;
	bModified = TRUE;

	// SfxMenuConfigEntry konstruieren ...
	pEntry = new SfxMenuConfigEntry ( nId,
								String( SfxResId( STR_MENU ) ),
								String(),
								TRUE );
	// ... und einf"ugen
	pActEntry = aEntriesBox.InsertEntry( MakeEntry( *pEntry ), pParent, nPos, 0xFFFF );

	// Wenn ein neuer erster Sub-Entry eingef"ugt wird, parent aufklappen
	if ( !nPos )
		aEntriesBox.Expand( pParent );
	pActEntry->SetUserData( pEntry );
	aEntriesBox.EntryInserted( pActEntry );
	aEntriesBox.Select( pActEntry );

	// Noch einen Dummy-Separator einf"ugen und selektieren
	pParent = pActEntry;
	pEntry = new SfxMenuConfigEntry;

	// ... und einf"ugen
	pActEntry = aEntriesBox.InsertEntry( MakeEntry( *pEntry ), pParent, 0, 0xFFFF );
	aEntriesBox.Expand( pParent );
	pActEntry->SetUserData( pEntry );
	aEntriesBox.EntryInserted( pActEntry );
	aEntriesBox.Select( pActEntry );
	aEntriesBox.MakeVisible( pActEntry );
	return 0;
}

IMPL_LINK( SfxMenuConfigPage, ChangeHdl, Button *, pButton )
/*  Beschreibung
	Der aktuelle Eintrag soll durch einen anderen ersetzt werden.
*/
{
	SvLBoxEntry *pActEntry = aEntriesBox.FirstSelected();
	if ( !pActEntry )
		return 0;

	USHORT nId = GetCurId();
	SfxMenuConfigEntry *pEntry = (SfxMenuConfigEntry*) pActEntry->GetUserData();
	SvLBoxEntry *pParent = aEntriesBox.GetParent( pActEntry );
	SvLBoxEntry *pChild = aEntriesBox.FirstChild( pParent );
	while ( pChild )
	{
		SfxMenuConfigEntry *pCurEntry = (SfxMenuConfigEntry*) pChild->GetUserData();
		if ( pCurEntry->GetId() == nId )
		{
			InfoBox( this, SfxResId( IBX_MNUCFG_ALREADY_INCLUDED ) ).Execute();
			break;
		}

		pChild = aEntriesBox.NextSibling( pChild );
	}

	bDefault = FALSE;
	bModified = TRUE;

	// ... und Eintrag "andern

	Help *pHelp = Application::GetHelp();
	pEntry->SetId( nId );

	SvLBoxEntry *pFuncEntry = aFunctionBox.FirstSelected();
	if( pFuncEntry )
		pEntry->SetName( Trim( aFunctionBox.GetEntryText( pFuncEntry ) ) );
	else
		pEntry->SetName( String() );
#if SUPD>628
    pEntry->SetHelpText( Trim( pHelp->GetHelpText( nId, this ) ) );
#else
	pEntry->SetHelpText( Trim( pHelp->GetHelpText( nId ) ) );
#endif
	aEntriesBox.SetEntryText( MakeEntry( *pEntry ), pActEntry, 0xFFFF );
	return 0;
}

IMPL_LINK( SfxMenuConfigPage, RemoveHdl, Button *, pButton )
/*  Beschreibung
	Der aktuelle Eintrag soll entfernt werden.
*/
{
	// Der zu l"oschende Entry
	SvLBoxEntry *pActEntry = aEntriesBox.FirstSelected();
	if ( !pActEntry )
		return 0;

	bModified = TRUE;
	bDefault = FALSE;

	// Aus der Listbox entfernen ...
	SfxMenuConfigEntry *pEntry = (SfxMenuConfigEntry*) pActEntry->GetUserData();
	String aName = pEntry->GetName();
	aEntriesBox.GetModel()->Remove( pActEntry );
	return 0;
}

IMPL_LINK( SfxMenuConfigPage, SelectHdl, Control*, pCtrl )
/*  Beschreibung
	In einer der Listboxen wurde etwas selektiert.
*/
{
    if ( pCtrl == &aGroupLBox )
	{
        aGroupLBox.GroupSelected();
		aFunctionBox.InsertEntry( String::CreateFromAscii( pSeparatorStr ), 0 , FALSE, 0 );
		return 0;
	}

	if ( pCtrl == &aFunctionBox )
		aFunctionBox.FunctionSelected();
	CheckEntry( pCtrl );
	return 0;
}

USHORT SfxMenuConfigPage::GetCurId()
/*  Beschreibung
	Liefert die Id des in der Function-Listbox selektierten Eintrags
*/
{
	USHORT nId = 0;
	nId = aFunctionBox.GetCurId();
	return nId;
}

String SfxMenuConfigPage::MakeEntry( const SfxMenuConfigEntry &rEntry ) const
/*  Beschreibung
	Bereitet einen Eintrag f"ur die Tablistbox auf und gibt einen String zur"uck,
	der als Entrytext verwendet werden soll.
*/
{
	String aStr;
	if ( rEntry.IsBinding() )
	{
		// Binding
		if( rEntry.GetId() != 1 )
			aStr += rEntry.GetName();
		else
			aStr += String::CreateFromAscii( pUnknownStr );

		// Funktion anh"angen
		aStr += '\t';
		aStr +=  '[';
		if ( rEntry.GetId() != 1 )
			aStr += SFX_SLOTPOOL().GetSlotName_Impl( rEntry.GetId() );
		else
			aStr += String::CreateFromAscii(pUnknownStr);
		aStr += ']';
	}
	else if ( rEntry.IsSeparator() )
		// Separator
		aStr += String::CreateFromAscii(pSeparatorStr);
	else if ( rEntry.IsPopup() )
	{
		// Popup
		aStr += rEntry.GetName();
		if ( pMgr->IsPopupFunction( rEntry.GetId() ) )
		{
			// Funktion anh"angen
			aStr += '\t';
			aStr +=  '[';
				aStr += SFX_SLOTPOOL().GetSlotName_Impl(rEntry.GetId());
			aStr += ']';
		}
	}
	else
		DBG_ERROR( "unknown entry type" );

	return aStr;
}

void SfxMenuConfigPage::CheckEntry( Control *pCtrl )
/*  Beschreibung
	Anhand der Selektion in der Entriesbox und der Functionbox wird der Enabled-State der
	Pushbuttons gesteuert und evtl. ein Helptext ausgegeben.
*/
{
	USHORT nId = 0;
	SvLBoxEntry *pActEntry = aEntriesBox.FirstSelected();
	SfxMenuConfigEntry *pEntry = NULL;
	if ( pActEntry )
		pEntry = (SfxMenuConfigEntry*) pActEntry->GetUserData();

	if ( pCtrl == &aEntriesBox && pEntry )
	{
		Help::ShowBalloon( this, Point(), String() );

		// Es wurde eine neuer Entry in der Tablistbox selektiert
		USHORT nID = pEntry->GetId();

		// Separatoren k"onnen nicht editiert werden
		aEntriesBox.EnableInplaceEditing( nID != 0 );

		// Das Dateimenue darf nicht verschoben werden
//        aEntriesBox.EnableDrop( nID != SID_PICKLIST );

		// In der Initialisierung wird der Select-Handler der Entriesbox vor dem der
		// Groupbox gerufen, daher gibt es dann noch keine Funktionen
		if ( !aFunctionBox.FirstSelected() )
			return;
	}

	// aNewButton enablen/disablen; es mu\s etwas in der Entriesbox selektiert sein
	BOOL bEnabled = ( pActEntry != NULL );
	aNewPopupButton.Enable( bEnabled );

	// ObjectMenues d"urfen nur auf TopLevel eingef"ugt werden
	nId = GetCurId();
	if ( bEnabled && nId >= SID_OBJECTMENU0 && nId <= SID_OBJECTMENU3 && !aEntriesBox.GetParent( pActEntry ) )
		bEnabled = FALSE;
	aNewButton.Enable( bEnabled );

	// aChangeButton enablen/disablen; Popups darf keine Funktion zugewiesen werden
	bEnabled = ( pEntry != NULL ) && !pEntry->IsPopup();

	// Es ist eine Funtion selektiert, aber die gleiche wie die konfigurierte
	if ( bEnabled && pEntry->GetId() == GetCurId() )
		bEnabled = FALSE;
	aChangeButton.Enable( bEnabled );

	// aRemoveButton enablen/disablen; einige Menues sind generell tabu
	bEnabled = ( pEntry != NULL );
	if ( bEnabled && pMgr->IsPopupFunction( pEntry->GetId() ) )
		bEnabled = FALSE;
	aRemoveButton.Enable( bEnabled );

	aDownButton.Enable( TryMove_Impl( &aDownButton ) );
	aUpButton.Enable( TryMove_Impl( &aUpButton ) );
}

String SfxMenuConfigPage::Trim( const String &rStr ) const
/*  Beschreibung
	Entfernt vorne und hinten Blanks aus einem String.
*/
{
	String aStr( rStr );

	while ( aStr.Len() && aStr.GetChar( 0 ) == ' ' )
		aStr.Erase( 0, 1 );
	while ( aStr.Len() && aStr.GetChar( aStr.Len() - 1 ) == ' ' )
		aStr.Erase( aStr.Len() - 1, 1 );

	return aStr;
}

BOOL SfxMenuConfigPage::FillItemSet( SfxItemSet& )
{
	if ( bModified )
	{
		Apply( pMgr, bDefault );
		bModified = FALSE;
        pMgr->StoreConfig();
		return TRUE;
	}
	return FALSE;
}

void SfxMenuConfigPage::Reset( const SfxItemSet& )
{
    if ( !pMgr )
    {
        pMgr = GetTabDialog()->GetViewFrame()->GetViewShell()->GetMenuBar_Impl();
        bDefault = pMgr->IsDefault();
        Init();
        aGroupLBox.Init();
        aEntriesBox.Select( aEntriesBox.GetEntry( 0, 0 ) );
        aGroupLBox.Select( aGroupLBox.GetEntry( 0, 0 ) );

        // Damit der Selecthandler noch einmal gerufen wird, wenn alle Boxen
        // initialisiert sind
        aEntriesBox.Select( aEntriesBox.GetEntry( 0, 0 ) );
    }
}


