/*************************************************************************
 *
 *  $RCSfile: register.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "sfxresid.hxx"
#include "register.hxx"

#include "dialog.hrc"
#include "register.hrc"


StarOfficeRegisterDlg::StarOfficeRegisterDlg( Window *pParent ) :
	ModalDialog			( pParent, SfxResId(RID_REGISTER_DLG) ),
	aFT_InfoText		( this, SfxResId(FT_INFOTEXT) ),
	aFT_RegNr			( this, SfxResId(FT_REGNR) ),
	aED_RegNr			( this, SfxResId(ED_REGNR) ),
	aFT_Email			( this, SfxResId(FT_EMAIL) ),
	aED_Email			( this, SfxResId(ED_EMAIL) ),
	aFL_Line1			( this, SfxResId(FL_LINE1) ),
	aBTN_Register		( this, SfxResId(BTN_REGISTER) ),
	aBTN_StartOffice	( this, SfxResId(BTN_STARTOFFICE) ),
	aBTN_GetFree		( this, SfxResId(BTN_GETFREE) ),
	aStr_WrongData		( SfxResId(STR_WRONG_NUMBER) )
{
	FreeResource();

	aED_RegNr.SetModifyHdl( LINK( this, StarOfficeRegisterDlg, ModifyHdl ) );
	aED_Email.SetModifyHdl( LINK( this, StarOfficeRegisterDlg, ModifyHdl ) );

	aBTN_Register.SetClickHdl( LINK( this, StarOfficeRegisterDlg, ClickHdl ) );
	aBTN_StartOffice.SetClickHdl( LINK( this, StarOfficeRegisterDlg, ClickHdl ) );
	aBTN_GetFree.SetClickHdl( LINK( this, StarOfficeRegisterDlg, ClickHdl ) );

	aBTN_GetFree.Enable( FALSE );
}

StarOfficeRegisterDlg::~StarOfficeRegisterDlg()
{
}

BOOL StarOfficeRegisterDlg::Close()
{
	return FALSE;
}

void StarOfficeRegisterDlg::SetEmail(const XubString& rEmail)
{
	aED_Email.SetText(rEmail);
}

void StarOfficeRegisterDlg::CheckReg()
{
	XubString aRegNr( aED_RegNr.GetText() );
	XubString aEMail( aED_Email.GetText() );
	long nCoded = 0;

	for( USHORT i = 0; i < 8; ++i )
	{
		unsigned char cCodedChar = 0x00;
		for( USHORT x = i; x < aEMail.Len(); ++x )
		{
			if( ((x+1) % (i+1)) == 0 )
				cCodedChar += aEMail.GetChar(x);
		}

		cCodedChar %= 10;
		nCoded *= 10;
		nCoded += cCodedChar;
	}

	XubString strCoded;
	while( nCoded != 0 )
	{
		int r = nCoded % 9;
		nCoded /= 9;
		strCoded.Insert( (char)(r + '0'), 0 );
	}
	strCoded.InsertAscii( "00000000", 0 );
	if( strCoded.Len() > 8 )
		strCoded.Erase( 0, strCoded.Len() - 8 );

	XubString aRealRegNr;
	for( USHORT nx = 0; nx <= aRegNr.Len(); ++nx )
		if( ((nx) % 2) == 0 )
			aRealRegNr += aRegNr.GetChar(nx);

	// 8010207336707402 == ok@stardivision.de
	if( aRealRegNr == strCoded )
		EndDialog(3); // erfolgreich
	else
	{
		InfoBox( this, aStr_WrongData ).Execute();
	}
}

IMPL_LINK( StarOfficeRegisterDlg, ClickHdl, PushButton*, pBtn )
{
	if( pBtn == &aBTN_StartOffice )
		EndDialog(1);
	else if( pBtn == &aBTN_Register )
		EndDialog(2);
	else if( pBtn == &aBTN_GetFree )
		CheckReg();
	return 1;
}

IMPL_LINK( StarOfficeRegisterDlg, ModifyHdl, Edit*, pEdit )
{
	if( aED_RegNr.GetText().Len() && aED_Email.GetText().Len() )
	{
		if( !aBTN_GetFree.IsEnabled() )
			aBTN_GetFree.Enable( TRUE );
	}
	else
		aBTN_GetFree.Enable( FALSE );

	return 1;
}


